;CRONOS430.ASM 11JAN03 - COPYRIGHT JOHN BECKER - EPE PICRONOS WALL CLOCK
; amended timing method

;PIC16F877-4, 3.2768MHz, WDT OFF, POR ON, XTAL XS

;Config register bits
; CP1 CP0 DBG NIL WRT CPD LVP BOR CP1 CP0 POR WDT OS1 OS0
;  1   1   1   1   1   1   0   0   1   1   0   0   0   1
;N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
;respectively - refer to PIC '87 data sheet.

#DEFINE PAGE0 BCF $03,5
#DEFINE PAGE1 BSF $03,5
#DEFINE RP1LO BCF $03,6  ; clear STATUS bit 6 (RP1)
#DEFINE RP1HI BSF $03,6  ; set   STATUS bit 6 (RP1)
#DEFINE BLOCK0 BCF $03,7 ; clear STATUS bit 7 (IRP)
#DEFINE BLOCK1 BSF $03,7 ; set   STATUS bit 7 (IRP)

	List P = PIC16F877, R=DEC; 
        __CONFIG   h'3F31'

INDF:    .EQU $00  ;page 0, 1, 2, 3
TMR0:    .EQU $01  ;page 0, 2
OPTION:  .EQU $01  ;page 1, 3
PCL:     .EQU $02  ;page 0, 1, 2, 3
STATUS:  .EQU $03  ;page 0, 1, 2, 3
FSR:     .EQU $04  ;page 0, 1, 2, 3

PORTA:   .EQU $05  ;page 0
TRISA:   .EQU $05  ;page 1
PORTB:   .EQU $06  ;page 0, 2
TRISB:   .EQU $06  ;page 1, 3
PORTC:   .EQU $07  ;page 0
TRISC:   .EQU $07  ;page 1
PORTD:   .EQU $08  ;page 0
TRISD:   .EQU $08  ;page 1
PORTE:   .EQU $09  ;page 0
TRISE:   .EQU $09  ;page 1

PCLATH:  .EQU $0A  ;page 0, 1, 2, 3
INTCON:  .EQU $0B  ;page 0, 1, 2, 3
PIR1:    .EQU $0C  ;page 0
PIE1:    .EQU $0C  ;page 1
EEDATA:  .EQU $0C  ;page 2
EECON1:  .EQU $0C  ;page 3
PIR2:    .EQU $0D  ;page 0
EEADR:   .EQU $0D  ;page 2
EECON2:  .EQU $0D  ;page 3
TMR1L:   .EQU $0E  ;page 0
TMR1H:   .EQU $0F  ;page 0
T1CON:   .EQU $10  ;page 0
CCP1CON: .EQU $17  ;page 0

RCSTA:   .EQU $18  ;page 0
TXSTA:   .EQU $18  ;page 1
TXREG:   .EQU $19  ;page 0
SPBRG:   .EQU $19  ;page 1
ADRESH:  .EQU $1E  ;page 0
ADRESL:  .EQU $1E  ;page 1
ADCON0:  .EQU $1F  ;page 0
ADCON1:  .EQU $1F  ;page 1

STORE1:      .EQU $20  ; general store
CLKSEC:      .EQU $21  ; seconds
CLKMIN:      .EQU $22  ; minutes
CLKHRS:      .EQU $23  ; hours
CLKCNT:      .EQU $24  ; 1/25th sec count
MATRIXCSECS: .EQU $25  ; value output to PORTC for secs
MATRIXDSECS: .EQU $26  ; value output to PORTD for secs
MATRIXCMINS: .EQU $27  ; value output to PORTC for mins
MATRIXDMINS: .EQU $28  ; value output to PORTD for mins
MULTIPLEX:   .EQU $29
DIGIT1:      .EQU $2A
DIGIT2:      .EQU $2B
DIGIT3:      .EQU $2C
DIGIT4:      .EQU $2D
DIGIT5:      .EQU $2E
DIGIT6:      .EQU $2F
DIGIT7:      .EQU $30
DIGIT8:      .EQU $31
COUNT0:      .EQU $32
COUNT1:      .EQU $33
COUNT2:      .EQU $34
BITCNT:      .EQU $35
DIGCNT:      .EQU $36

HALFSEC:     .EQU $37
CLKDAY:      .EQU $38
WKDAY:       .EQU $39
CLKMONTH:    .EQU $3A
HALFDAY:     .EQU $3B
MONTH:       .EQU $3C
SHOWMODE:    .EQU $3D
TEMPMSD:     .EQU $3E
TEMPNSD:     .EQU $3F
TEMPLSD:     .EQU $40
CALIBFLAG:   .EQU $41     ; flag to indicate calibration mode
CALIBMSB:    .EQU $42     ; holds value of time correction
CALIBLSB:    .EQU $43     ; that is reloaded after each countdown
FASTERFLAG:  .EQU $44     ; holds +/- flag for timing correction
ADJUSTMSB:   .EQU $45     ; countdown counter for time correction
ADJUSTLSB:   .EQU $46
TCALIBMSB:   .EQU $47     ; holds value of temperature correction
TCALIBLSB:   .EQU $48
TEMPMINUS:   .EQU $49
ADCMSB:      .EQU $4A     ; ADC VALUE
ADCLSB:      .EQU $4B
TIMINGCNT:   .EQU $4C     ; countdown value for seconds timing
CLKSECMSB:   .EQU $4D     ; seconds fraction MSB
CLKSECLSB:   .EQU $4E     ; seconds fraction LSB
CALIBUNIT:   .EQU $4F     ; timing calibration unit integer
HEXHRS:      .EQU $50
HEXMIN:      .EQU $51
MODELENGTH:  .EQU $52
MODECOUNT:   .EQU $53
MODEOFF:     .EQU $54
CALIBDECIMAL: .EQU $55
CLKSECDECIMAL: .EQU $56
CALIBFRACTION: .EQU $57
YEARMSB:     .EQU $58
YEARLSB:     .EQU $59
LOOP:        .EQU $5A


DIVIDLSB:   .EQU $5B     ; Dividend and quotient LSB
DIVIDMSB:   .EQU $5C     ; Dividend and quotient MSB
REMDRLSB:   .EQU $5D     ; Remainder LSB
REMDRMSB:   .EQU $5E     ; Remainder MSB
DIVISLSB:   .EQU $5F     ; Divisor LSB
DIVISMSB:   .EQU $60     ; Divisor MSB
PORTAPREV:  .EQU $61     ; porta previous setting for mode change cwitch


             ;************************************************************
             ;           Bit Definitions
             ;************************************************************

W:      .EQU 0
F:      .EQU 1
C:      .EQU 0
DC:     .EQU 1 
Z:      .EQU 2

RP0:    .EQU 5          ; STATUS reg
RP1:    .EQU 6          ; STATUS reg
GIE:    .EQU 7          ; INTCON reg
RD:     .EQU 0          ; EECON1 reg eeprom read enable flag
WR:     .EQU 1          ; EECON1 reg eeprom write initiate flag
WREN:   .EQU 2          ; EECON1 reg eeprom write enable flag
EEPGD:  .EQU 7          ; EECON1 reg 
EEIF:   .EQU 4          ; PIR2 reg 
GO:     .EQU 2          ; ADCON0 reg
DI:     .EQU $07        ; eeprom input bit
DO:     .EQU $06        ; eeprom output bit
SDATA:  .EQU $04        ; serial EE data line (PORTC)
SCLK:   .EQU $03        ; serial EE clock line (PORTC)

PEIE    .EQU 6
T0IE    .EQU 5
INTE    .EQU 4
RBIE    .EQU 3
T0IF    .EQU 2
INTF    .EQU 1
RBIF    .EQU 0
ADFM    .EQU 128        ; ADCON1 REG
ADIF    .EQU 6          ; PIR1 REG

        .ORG 0
        goto START
        .ORG 4          ; Interrupt vector address
        goto START
        .ORG 5          ; Start of program memory
        goto START

TABLEC: addwf PCL,F     ; seconds & mins - matrix via PORTC
        retlw %10000000
        retlw %10000000
        retlw %10000000
        retlw %10000000
        retlw %10000000
        retlw %10000000
        retlw %10000000
        retlw %10000000

        retlw %01000000
        retlw %01000000
        retlw %01000000
        retlw %01000000
        retlw %01000000
        retlw %01000000
        retlw %01000000
        retlw %01000000

        retlw %00100000
        retlw %00100000
        retlw %00100000
        retlw %00100000
        retlw %00100000
        retlw %00100000
        retlw %00100000
        retlw %00100000

        retlw %00010000
        retlw %00010000
        retlw %00010000
        retlw %00010000
        retlw %00010000
        retlw %00010000
        retlw %00010000
        retlw %00010000

        retlw %00001000
        retlw %00001000
        retlw %00001000
        retlw %00001000
        retlw %00001000
        retlw %00001000
        retlw %00001000
        retlw %00001000

        retlw %00000100
        retlw %00000100
        retlw %00000100
        retlw %00000100
        retlw %00000100
        retlw %00000100
        retlw %00000100
        retlw %00000100

        retlw %00000010
        retlw %00000010
        retlw %00000010
        retlw %00000010
        retlw %00000010
        retlw %00000010
        retlw %00000010
        retlw %00000010

        retlw %00000001
        retlw %00000001
        retlw %00000001
        retlw %00000001
        retlw %00000001
        retlw %00000001
        retlw %00000001
        retlw %00000001

TABLED: addwf PCL,F     ; seconds - matrix via PORTD
        retlw %11111110
        retlw %11111101
        retlw %11111011
        retlw %11110111
        retlw %11101111
        retlw %11011111
        retlw %10111111
        retlw %01111111

TABLEE:; movf CLKHRS,W   ; hours - matrix via PORTE
        addwf PCL,F
        retlw %00000001
        retlw %00000001
        retlw %00000001
        retlw %00000001

        retlw %00000010
        retlw %00000010
        retlw %00000010
        retlw %00000010

        retlw %00000100
        retlw %00000100
        retlw %00000100
        retlw %00000100

TABLEHRSB: addwf PCL,F  ; hours - matrix via PORTB RB0-RB3
        retlw %11111110
        retlw %11111101
        retlw %11111011
        retlw %11110111

SEGMENT: addwf PCL,F    ; 7-segment digits - matrix via PORTA RA1-RA4
        retlw %00001000
        retlw %00000100
        retlw %00000010
        retlw %00010000

SEGTABLE: addwf PCL,F
        retlw %00111111 ;0   common anode codes (IC4 ULN2004A inverts them)
        retlw %00000110 ;1
        retlw %01011011 ;2
        retlw %01001111 ;3
        retlw %01100110 ;4
        retlw %01101101 ;5
        retlw %01111100 ;6
        retlw %00000111 ;7
        retlw %01111111 ;8
        retlw %01100111 ;9
        retlw %01100001 ;c  10
        retlw %01000000 ;-  11
        retlw %00000000 ;   12  blank
        retlw %01011110 ;d  13
        retlw %01110111 ; 'A' (AM) 14
        retlw %01110011 ; 'P' (PM) 15
        retlw %00000000 ; 16 upper segment (add to clock)
        retlw %01000000 ; 17 lower segment (subtract from clock)
        retlw %01101001 ;c-  18

MONTH4: ADDWF PCL,F     ;month length in days in BCD
        retlw %00110001 ;0. XXX 31
        retlw %00110001 ;1. JAN 31
        goto FEB        ;2. FEB 28/29
        retlw %00110001 ;3. MAR 31
        retlw %00110000 ;4. APR 30
        retlw %00110001 ;5. MAY 31
        retlw %00110000 ;6. JUN 30
        retlw %00110001 ;7. JUL 31
        retlw %00110001 ;8. AUG 31
        retlw %00110000 ;9. SEP 30
        retlw %00110001 ;10. OCT 31
        retlw %00110000 ;11. NOV 30
        retlw %00110001 ;12. DEC 31

FEB:	call LEAPYR
        movf REMDRLSB,W  ; check value of remainder after div by 4
        iorwf REMDRMSB,W 
        andlw %00000011
        btfss STATUS,Z  ;is year a multiple of 4?
        retlw %00101000 ;no, FEB = 28 - remainder > 0
        retlw %00101001 ;yes, FEB = 29  - remainder = 0

TABLESECS: ADDWF PCL,F     ; corrects PCB led position backwards by 1 place
        retlw 59
        retlw 0
        retlw 1
        retlw 2
        retlw 3
        retlw 4
        retlw 5
        retlw 6
        retlw 7
        retlw 8
        retlw 9
        retlw 10
        retlw 11
        retlw 12
        retlw 13
        retlw 14
        retlw 15
        retlw 16
        retlw 17
        retlw 18
        retlw 19
        retlw 20
        retlw 21
        retlw 22
        retlw 23
        retlw 24
        retlw 25
        retlw 26
        retlw 27
        retlw 28
        retlw 29
        retlw 30
        retlw 31
        retlw 32
        retlw 33
        retlw 34
        retlw 35
        retlw 36
        retlw 37
        retlw 38
        retlw 39
        retlw 40
        retlw 41
        retlw 42
        retlw 43
        retlw 44
        retlw 45
        retlw 46
        retlw 47
        retlw 48
        retlw 49
        retlw 50
        retlw 51
        retlw 52
        retlw 53
        retlw 54
        retlw 55
        retlw 56
        retlw 57
        retlw 58

TABLEHOURS: ADDWF PCL,F     ; corrects PCB led position backwards by 1 place
        retlw 11
        retlw 0
        retlw 1
        retlw 2
        retlw 3
        retlw 4
        retlw 5
        retlw 6
        retlw 7
        retlw 8
        retlw 9
        retlw 10

ROUTE:  movf SHOWMODE,W    ; which mode to show on matrix?
        andlw 3
        addwf PCL,F
        goto SHOWTIME
        goto SHOWDATE
        goto SHOWTEMP
        clrf SHOWMODE
        goto ROUTE

MODETIME: movf SHOWMODE,W ; length of time to display each mode
        andlw 3
        addwf PCL,F
        retlw 5
        retlw 5
        retlw 5
        retlw 5

;*******************

START:  bcf STATUS,RP0
        bcf STATUS,RP1
        clrf PORTA
        clrf PORTB
        clrf PORTC
        clrf PORTD
        clrf PORTE
        clrf PCLATH

        BLOCK0
        PAGE1
        movlw %10000000     ; RB7 as input, rest as output
        movwf PORTB
        clrf TRISC          ; PORTC as output
        clrf TRISD          ; PORTD as output
        clrf TRISE          ; PORTE as output
        movlw %10001110     ; set RHS justify, RA0 as analog input, RA1-RA7 & PORTE as digital
        movwf ADCON1        ; with RA, RE digital, ref to +VE and 0V
        movlw %11100001     ; RA0, RA5 as input, RA2-RA4 as output
        movwf TRISA

        movlw %00000010     ; timer 1:4 (1/400th sec), pull-ups on
        movwf OPTION
        PAGE0
        movlw %10000001     ; set AD on, Fosc/32, chan 0
        movwf ADCON0
        clrf INTCON

        movlw 200           ; seconds countdown timing value
        movwf TIMINGCNT

        clrf CLKSEC
        clrf CLKMIN
        clrf CLKHRS

        clrf HEXMIN
        clrf HEXHRS

        clrf PORTB
        clrf PORTC
        clrf PORTD
        clrf PORTE
        movf TIMINGCNT,W
        movwf CLKCNT
        clrf MATRIXCSECS
        clrf MATRIXDSECS
        clrf MATRIXCMINS
        clrf MATRIXDMINS
        clrf MULTIPLEX
        movlw 12
        movwf TEMPMSD
        movwf TEMPNSD
        movwf TEMPLSD

        movlw 1
        movwf CLKDAY
        movwf CLKMONTH
        movwf MONTH

        clrf MODEOFF
        clrf WKDAY
        clrf HALFDAY
        clrf SHOWMODE
        clrf CALIBFLAG
        clrf CALIBMSB
        clrf CALIBLSB
        clrf CALIBDECIMAL
        clrf CALIBFRACTION
        clrf ADJUSTMSB
        clrf ADJUSTLSB
        clrf FASTERFLAG
        clrf TCALIBMSB
        clrf TCALIBLSB
        clrf TEMPMINUS
        clrf MODECOUNT
        clrf YEARLSB
        clrf YEARMSB
        clrf PORTAPREV

        call RECALLPROM

        bsf ADCON0,GO   ; start temperature data conversion
        call GETADC

; ***** END OF SETUP - START OF MAIN *****

MAIN:   btfss INTCON,2     ; has a timer time-out been detected?
        goto MAIN          ; no
	call CLKADD
        bcf INTCON,2
        goto MAIN

CLKADD: movf MULTIPLEX,W   ; is MULTIPLEX = 4?
        xorlw 4
        btfsc STATUS,Z
        goto SHOWHRS       ; yes, so show hours

        call MODETIME
        movwf MODELENGTH
        goto ROUTE

SHOWTEMP: movf TEMPMSD,W
        movwf DIGIT4
        movf TEMPNSD,W
        movwf DIGIT3
        movf TEMPLSD,W
        movwf DIGIT2
        movlw 10            ; 'c'
        btfsc TEMPMINUS,0
        movlw 18            ; 'c-'
        movwf DIGIT1
        goto SHOWMATRIX

SHOWHRS: clrf PORTA        ; turn off matrix display
        movf CLKHRS,W   ; hours - matrix via PORTE

        call TABLEHOURS
        call TABLEE
        movwf PORTE

        movf CLKHRS,W
        call TABLEHOURS
        andlw %00000011
        call TABLEHRSB
        movwf PORTB
        clrf MULTIPLEX
        goto SHOWSECS

SHOWDATE: movf CLKMONTH,W
        andlw 15
        movwf DIGIT1
        swapf CLKMONTH,W
        andlw 15
        movwf DIGIT2
        movf CLKDAY,W
        andlw 15
        movwf DIGIT3
        swapf CLKDAY,W
        andlw 15
        movwf DIGIT4
        goto SHOWMATRIX

SHOWTIME: movf HEXMIN,W
        andlw 15
        movwf DIGIT1
        swapf HEXMIN,W
        andlw 15
        movwf DIGIT2
        movf HEXHRS,W
        andlw 15
        movwf DIGIT3
        swapf HEXHRS,W
        andlw 15
        movwf DIGIT4
        goto SHOWMATRIX

SHOWMATRIX: clrf PORTE     ; show matrix, but turn off hours first
        movf MULTIPLEX,W
        andlw %00000011
        call SEGMENT
        movwf PORTA

        movf MULTIPLEX,W
        andlw %00000011
        addlw DIGIT1
        movwf FSR
        movf INDF,W
        call SEGTABLE
        movwf PORTB
        incf MULTIPLEX,F

SHOWSECS: btfss CLKCNT,0
        goto SHOWMINS
        movf MATRIXCSECS,W
        movwf PORTC
        movf MATRIXDSECS,W
        movwf PORTD
        goto DECCLK

SHOWMINS: movf MATRIXCMINS,W
        movwf PORTC
        movf MATRIXDMINS,W
        movwf PORTD

DECCLK: decfsz CLKCNT,F    ; decrement system clock counter. Is it = 0?
        return             ; no
        movf TIMINGCNT,W
        movwf CLKCNT

        btfsc PORTA,5
        goto DC1
        movf PORTA,W          ; is port a still set from preveious press?
        andlw %00100000
        xorwf PORTAPREV,W
        btfss STATUS,Z
        incf MODEOFF,F        ; no

DC1:    btfss PORTB,7
        call ADJUSTSETTINGS

        movf PORTA,W
        andlw %00100000
        movwf PORTAPREV

        PAGE1
        movlw %00000010
        movwf TRISE
        PAGE0
        nop
        movf PORTE,W
        movwf CALIBFLAG
        btfsc CALIBFLAG,1

        call CALIBRATE

        PAGE1
        clrf TRISE
        PAGE0

        movf CALIBDECIMAL,W       ; add timing val fraction to count fraction
        addwf CLKSECDECIMAL,F
        movf STATUS,W             ; add Carry (if any) to count lsb
        andlw 1
        addwf CLKSECLSB,F
        movf STATUS,W             ; add Carry (if any) to count msb
        andlw 1
        addwf CLKSECMSB,F
        movf STATUS,W             ; add Carry (if any) to count seconds
        andlw 1
        addwf CLKSEC,F

        movf CALIBLSB,W           ; add timing val lsb to count lsb
        addwf CLKSECLSB,F
        movf STATUS,W             ; add Carry (if any) to count msb
        andlw 1
        addwf CLKSECMSB,F
        movf STATUS,W             ; add Carry (if any) to count seconds
        andlw 1
        addwf CLKSEC,F

        movf CALIBMSB,W           ; add timing val msb to count msb
        addwf CLKSECMSB,F
        movf STATUS,W             ; add Carry (if any) to count seconds
        andlw 1
        movwf HALFSEC             ; and set/reset Halfsec according to bit 0
        addwf CLKSEC,F

        btfss HALFSEC,0    ; is HALFSEC bit 0 set?
        goto INCS2         ; no

INCSECS: incf MODECOUNT,F   ; yes, inc modecount only if bit 0 set
        movf MODECOUNT,W
        xorwf MODELENGTH,W
        btfss STATUS,Z
        goto INCS2
        clrf MODECOUNT

        btfsc MODEOFF,0    ; is mode no-change flag on?
        goto INCS2         ; yes

        incf SHOWMODE,F    ; no
        movf SHOWMODE,W
        xorlw 4
        btfsc STATUS,Z
        clrf SHOWMODE

INCS2:  movf CLKSEC,W      ; are secs >= 60 ?
        addlw 196
        btfss STATUS,C
        goto INC2          ; no
        clrf CLKSEC        ; yes, reset secs & inc mins

;        btfsc MODEOFF,0    ; is mode no-change flag on?
        btfss MODEOFF,0    ; is mode no-change flag on?
        clrf SHOWMODE      ;##
        call MODETIME
        movwf MODELENGTH

;        clrf MODELENGTH

ADDMIN: call GETADC        ; sample temperature
        incf HEXMIN,F      ; inc hex minutes
        movf HEXMIN,W      ; add 6 to check DC
        addlw 6
        btfsc STATUS,DC
        movwf HEXMIN

        incf CLKMIN,F
        movf CLKMIN,W
        xorlw 60
        btfss STATUS,Z
        goto INC2
        clrf CLKMIN        ; reset mins
        clrf HEXMIN        ; reset mins
        call ADDHRS

INC2:   movf CLKSEC,W
        call TABLESECS
        call TABLEC
        movwf MATRIXCSECS

        movf CLKSEC,W
        call TABLESECS
        andlw %00000111
        call TABLED
        movwf MATRIXDSECS

        movf CLKMIN,W      ; mins - circle matrix via PORTC
        call TABLESECS
        call TABLEC
        movwf MATRIXCMINS
        movf CLKMIN,W
        call TABLESECS
        andlw %00000111
        call TABLED
        movwf MATRIXDMINS
        return

ADDHRS: incf HEXHRS,F      ; inc hex hours
        movf HEXHRS,W      ; add 6 to check DC
        addlw 6
        btfsc STATUS,DC
        movwf HEXHRS
        movf HEXHRS,W      ; are hex hours = 24?
        xorlw %00100100
        btfss STATUS,Z
        goto ADDH2
        clrf HEXHRS        ; yes, reset hex hours
        clrf CLKHRS        ; reset hours
        goto ADDWK

ADDH2:  incf CLKHRS,F        ; normal inc of hours
        movf CLKHRS,W
        xorlw 12
        btfss STATUS,Z
        return
        clrf CLKHRS        ; reset hours
        return

ADDWK:  incf WKDAY,F
        movlw 7
        xorwf WKDAY,W
        btfsc STATUS,Z
        clrf WKDAY

ADDDAY: incf CLKDAY,F      ; inc days
        movlw 6
        addwf CLKDAY,W     ; if 6 is added is there a digit carry?
        btfsc STATUS,DC
        movwf CLKDAY       ; yes
        movf MONTH,W       ; get days in month
        call MONTH4
        movwf STORE1
        movf CLKDAY,W      ; are days <= max?
        subwf STORE1,W
        btfsc STATUS,C
        return
        movlw 1
        movwf CLKDAY       ; yes, so reset to 1

ADDMON: incf CLKMONTH,F
        movlw 6
        addwf CLKMONTH,W   ; if 6 is added is there a digit carry?
        btfsc STATUS,DC
        movwf CLKMONTH     ; yes
        incf MONTH,F
        movlw 13
        xorwf MONTH,W
        btfss STATUS,Z
        return
        movlw 1
        movwf MONTH
        movwf CLKMONTH
        return

; **** GET TEMPERATURE FROM ADC

GETADC: btfsc ADCON0,GO    ; wait conversion flag
        goto GETADC

        movf ADRESH,W
        movwf ADCMSB
        PAGE1
        movf ADRESL,W
        PAGE0
        movwf ADCLSB
        bsf ADCON0,GO      ; start next data conversion

ADC34:  movf TCALIBLSB,W      ; add correction
        addwf ADCLSB,F
        btfsc STATUS,C        ; is there a carry?
        incf ADCMSB,F         ; yes
        movf TCALIBMSB,W      ; add MSB
        addwf ADCMSB,F

        movf ADCLSB,W
        movwf COUNT0
        movf ADCMSB,W
        movwf COUNT1
        clrf COUNT2

        clrf TEMPMINUS
        movf ADCMSB,W
        andlw %11111100
        btfsc STATUS,Z
        goto ADC50
        bsf TEMPMINUS,0
        comf COUNT0,F
        incf COUNT0,F
        comf COUNT1,F

ADC50:  call BIN2DEC
        movf DIGIT3,W
        btfss STATUS,Z
        goto ADC51
        movlw 12
        movwf DIGIT3
        movf DIGIT2,W
        btfss STATUS,Z
        goto ADC51
        movlw 12
        movwf DIGIT2

ADC51:  movf DIGIT3,W
        movwf TEMPMSD
        movf DIGIT2,W
        movwf TEMPNSD
        movf DIGIT1,W
        movwf TEMPLSD
        return

; ***** Peter Hemsley's binary to decimal routine *****

BIN2DEC: clrf   DIGIT1
        clrf    DIGIT2
        clrf    DIGIT3
        clrf    DIGIT4
        clrf    DIGIT5
        clrf    DIGIT6
        clrf    DIGIT7
        clrf    DIGIT8

        movlw   24              ;24 bits to do
        movwf   BITCNT

BITLP:  rlf     COUNT0,F        ;Shift msb into carry
        rlf     COUNT1,F
        rlf     COUNT2,F

        movlw   DIGIT1
        movwf   FSR             ;Pointer to DIGITs
        movlw   8               ;8 DIGITs to do
        movwf   DIGCNT
ADJLP:  rlf     INDF,F          ;Shift DIGIT 1 bit left
        movlw   10
        subwf   INDF,w          ;Check and adjust for decimal overflow
        skpnc
        movwf   INDF

        incf    FSR,F           ;Next DIGIT
        decfsz  DIGCNT,F
        goto    ADJLP
        decfsz  BITCNT,F        ;Next bit
        goto    BITLP
        return

; ***** ADJUSTMENT ZONE *****

ADJUSTSETTINGS:

ADJUSTMONTH: clrf CLKSEC 
        movf TIMINGCNT,W
        movwf CLKCNT
        bcf INTCON,2

        clrf PORTA        ; turn off matrix display
        clrf PORTC
        clrf PORTD
        clrf PORTE

ADJMN1: call NEWMONTH
        btfss PORTB,7
        goto ADJMN1

        movf TIMINGCNT,W
        movwf CLKCNT

ADJMN1A: call NEWMONTH
        movf CLKCNT,W
        xorlw 1
        btfss STATUS,Z
        goto ADJMN1A

ADJMN2:  call NEWMONTH
        btfss PORTB,7
        goto ADJUSTDAY

        btfsc PORTA,5
        goto ADJMN2

        incf CLKMONTH,F
        movlw 6
        addwf CLKMONTH,W   ; if 6 is added is there a digit carry?
        btfsc STATUS,DC
        movwf CLKMONTH     ; yes
        incf MONTH,F
        movlw 13
        xorwf MONTH,W
        btfss STATUS,Z
        goto ADJMN3
        movlw 1
        movwf MONTH
        movwf CLKMONTH

ADJMN3: movf TIMINGCNT,W
        movwf CLKCNT

ADJMN2A: call NEWMONTH
        movf CLKCNT,W
        xorlw 1
        btfss STATUS,Z
        goto ADJMN2A
        goto ADJMN2

; *******

ADJUSTDAY: clrf CLKSEC 
        movf TIMINGCNT,W
        movwf CLKCNT
        bcf INTCON,2

        clrf PORTA        ; turn off matrix display
        clrf PORTC
        clrf PORTD
        clrf PORTE

ADJD1:  call NEWDAY
        btfss PORTB,7
        goto ADJD1

        movf TIMINGCNT,W
        movwf CLKCNT

ADJD1A: call NEWDAY
        movf CLKCNT,W
        xorlw 1
        btfss STATUS,Z
        goto ADJD1A

ADJD2:  call NEWDAY
        btfss PORTB,7
        goto ADJUSTHOURS

        btfsc PORTA,5
        goto ADJD2

        incf CLKDAY,F      ; inc days
        movlw 6
        addwf CLKDAY,W     ; if 6 is added is there a digit carry?
        btfsc STATUS,DC
        movwf CLKDAY       ; yes
        movf MONTH,W       ; get days in month
        call MONTH4
        movwf STORE1
        movf CLKDAY,W      ; are days <= max?
        subwf STORE1,W
        btfsc STATUS,C
        goto ADJD3
        movlw 1
        movwf CLKDAY       ; yes, so reset to 1

ADJD3:  movf TIMINGCNT,W
        movwf CLKCNT

ADJD2A: call NEWDAY
        movf CLKCNT,W
        xorlw 1
        btfss STATUS,Z
        goto ADJD2A
        goto ADJD2

; *****

ADJUSTHOURS: clrf CLKSEC 
        movf TIMINGCNT,W
        movwf CLKCNT
        bcf INTCON,2

        movlw 12           ; blank
        movwf DIGIT1
        movwf DIGIT2
        movf HEXHRS,W
        andlw 15
        movwf DIGIT3
        swapf HEXHRS,W
        andlw 15
        movwf DIGIT4
        clrf MULTIPLEX

ADJH1:  call NEWHOURS
        btfss PORTB,7
        goto ADJH1

ADJH2:  btfss PORTB,7
        goto ADJUSTMINS

        call NEWHOURS

        btfsc PORTA,5
        goto ADJH2

        incf HEXHRS,F      ; inc hex hours
        movf HEXHRS,W      ; add 6 to check DC
        addlw 6
        btfsc STATUS,DC
        movwf HEXHRS
        movf HEXHRS,W
        xorlw %00100100
        btfss STATUS,Z
        goto ADJH2A
        clrf HEXHRS
        clrf CLKHRS
        goto ADJH3

ADJH2A: incf CLKHRS,F
        movf CLKHRS,W
        xorlw 12
        btfss STATUS,Z
        goto ADJH3
        clrf CLKHRS        ; reset hours

ADJH3:  movf TIMINGCNT,W
        movwf CLKCNT
        movlw 12           ; blank
        movwf DIGIT1
        movwf DIGIT2
        movf HEXHRS,W
        andlw 15
        movwf DIGIT3
        swapf HEXHRS,W
        andlw 15
        movwf DIGIT4

ADJH3A: call NEWHOURS
        movf CLKCNT,W
        xorlw 1
        btfss STATUS,Z
        goto ADJH3A
        goto ADJH2

; ******

ADJUSTMINS: clrf CLKSEC 
        movf TIMINGCNT,W
        movwf CLKCNT
        bcf INTCON,2

        movlw 12           ; blank
        movwf DIGIT3
        movwf DIGIT4
        movf HEXMIN,W
        andlw 15
        movwf DIGIT1
        swapf HEXMIN,W
        andlw 15
        movwf DIGIT2
        clrf MULTIPLEX

ADJM1:  call NEWMINS
        btfss PORTB,7
        goto ADJM1

ADJM2:  btfss PORTB,7
        goto WAITB7

        call NEWMINS

        btfsc PORTA,5
        goto ADJM2

        incf HEXMIN,F      ; inc hex minutes
        movf HEXMIN,W      ; add 6 to check DC
        addlw 6
        btfsc STATUS,DC
        movwf HEXMIN

        incf CLKMIN,F
        movf CLKMIN,W
        xorlw 60
        btfss STATUS,Z
        goto ADJM3
        clrf CLKMIN        ; reset mins
        clrf HEXMIN        ; reset mins

ADJM3:  movlw 12           ; blank
        movwf DIGIT3
        movwf DIGIT4
        movf HEXMIN,W
        andlw 15
        movwf DIGIT1
        swapf HEXMIN,W
        andlw 15
        movwf DIGIT2
        clrf MULTIPLEX

ADJM3A: call NEWMINS
        movf CLKCNT,W
        xorlw 1
        btfss STATUS,Z
        goto ADJM3A
        goto ADJM2

; ***** DISPLAYS CALLED FROM ADJUSTMENT ZONE *****

NEWDAY: movlw 12           ; blank
        movwf DIGIT1
        movwf DIGIT2
        movf CLKDAY,W
        andlw 15
        movwf DIGIT3
        swapf CLKDAY,W
        andlw 15
        movwf DIGIT4
        call NEWMATRIX
        return

; *******

NEWMONTH: movlw 12           ; blank
        movwf DIGIT3
        movwf DIGIT4
        movf CLKMONTH,W
        andlw 15
        movwf DIGIT1
        swapf CLKMONTH,W
        andlw 15
        movwf DIGIT2
        call NEWMATRIX
        return

; *******

NEWHOURS: movf MULTIPLEX,W
        xorlw 4
        btfsc STATUS,Z
        goto NH3           ; yes, so show hours

        call NEWMATRIX
        return

NH3:    clrf PORTA        ; turn off matrix display
        movf CLKHRS,W   ; hours - matrix via PORTE
        call TABLEHOURS
        call TABLEE       ; automatically selects hour led
        movwf PORTE
        movf CLKHRS,W     ; selects power matrix line
        call TABLEHOURS
        andlw %00000011
        call TABLEHRSB
        movwf PORTB
        clrf MULTIPLEX

NH2:    btfss INTCON,2    ; has a timer time-out been detected?
        goto NH2          ; no
        bcf INTCON,2
        decfsz CLKCNT,F    ; decrement system clock counter. Is it = 0?
        return
        movf TIMINGCNT,W
        movwf CLKCNT
        return

; *******

NEWMINS: movf MULTIPLEX,W
        xorlw 4
        btfsc STATUS,Z
        goto NM3           ; yes, so show mins

        call NEWMATRIX
        return

NM3:    movf CLKMIN,W      ; mins - circle matrix via PORTC
        call TABLESECS
        call TABLEC
        movwf MATRIXCMINS
        movf CLKMIN,W
        call TABLESECS
        andlw %00000111
        call TABLED
        movwf MATRIXDMINS
        movf MATRIXCMINS,W
        movwf PORTC
        movf MATRIXDMINS,W
        movwf PORTD

        clrf MULTIPLEX

NM2:    btfss INTCON,2    ; has a timer time-out been detected?
        goto NM2          ; no
        bcf INTCON,2
        decfsz CLKCNT,F    ; decrement system clock counter. Is it = 0?
        return
        movf TIMINGCNT,W
        movwf CLKCNT
        return


; *******

NEWMATRIX: clrf PORTE     ; show matrix, but turn off hours first
        movf MULTIPLEX,W
        andlw %00000011
        call SEGMENT
        movwf PORTA

        movf MULTIPLEX,W
        andlw %00000011
        addlw DIGIT1
        movwf FSR
        movf INDF,W
        call SEGTABLE
        movwf PORTB
        incf MULTIPLEX,F

NEWMAT2: btfss INTCON,2    ; has a timer time-out been detected?
        goto NEWMAT2       ; no
        bcf INTCON,2
        decfsz CLKCNT,F    ; decrement system clock counter. Is it = 0?
        return
        movf TIMINGCNT,W
        movwf CLKCNT
        return

; *******

PAUSEHALF: btfss INTCON,2  ; has a timer time-out been detected?
        goto PAUSEHALF     ; no
        bcf INTCON,2
        decfsz CLKCNT,F    ; increment system clock counter. Is it = 0?
        goto PAUSEHALF     ; no
        movf TIMINGCNT,W
        movwf CLKCNT
        return

; *******

WAITB7:
        clrf PORTA
        clrf PORTB
        clrf PORTE

WAITB7A: call ROTATE

        btfss PORTB,7
        goto WAITB7A
        call SAVEPROM
        clrf CLKSEC
;        call PAUSEHALF
        return

WAITE1:
        clrf PORTA
;        clrf PORTB
        movlw %11111111
        movwf PORTB
        clrf PORTE

WAITE1A: call ROTATE
        btfsc PORTE,1      ; .........s
        goto WAITE1A
        clrf CLKSEC
;        call PAUSEHALF
        return

ROTATE: incf CLKSEC,F
        movf CLKSEC,W      ; are secs >= 60 ?
        addlw 196
        btfsc STATUS,C
        clrf CLKSEC        ; yes, reset secs & inc mins

        movf CLKSEC,W
        call TABLESECS
        call TABLEC
        movwf MATRIXCSECS

        movf CLKSEC,W
        call TABLESECS
        andlw %00000111
        call TABLED
        movwf MATRIXDSECS

        movf MATRIXCSECS,W
        movwf PORTC
        movf MATRIXDSECS,W
        movwf PORTD
        return


;****** CALIBRATE CLOCK TIMING AND TEMPERATURE *****

CALIBRATE:
        clrf PORTA        ; turn off matrix display
        clrf PORTC
        clrf PORTD
        clrf PORTE
        movlw %11111111
        movwf PORTB

        movf CALIBMSB,W
        movwf COUNT1
        movf CALIBLSB,W
        movwf COUNT0
        clrf COUNT2

        btfsc CALIBMSB,7   ; is CALIB a negative number?
        goto ADJUST2       ; no
        comf COUNT0,F
        incf COUNT0,F
        comf COUNT1,F

ADJUST2: bcf COUNT1,7
        call BIN2DEC
        movlw 16           ; + add to clock (upper segment)
        btfss FASTERFLAG,0
        movlw 17           ; - subtract from clock (lower segment)
        movwf DIGIT4
        movf DIGIT3,F
        btfss STATUS,Z
        goto ADJUST3
        movlw 12
        movwf DIGIT3       ; blank leading zero
        movf DIGIT2,F
        btfss STATUS,Z
        goto ADJUST3
        movlw 12           ; blank leading zero
        movwf DIGIT2

        bcf STATUS,C           ; divide calibdecimal by 8 for display
        rrf CALIBDECIMAL,W
        movwf CALIBFRACTION
        bcf STATUS,C
        rrf CALIBFRACTION,F
        bcf STATUS,C
        rrf CALIBFRACTION,F

        clrf MULTIPLEX

ADJUST3: clrf CLKSEC
        movf TIMINGCNT,W
        movwf CLKCNT
        bcf INTCON,2

;        clrf PORTA        ; turn off matrix display
;        clrf PORTC
;        clrf PORTD
;        clrf PORTE
;        movlw %11111111
;        movwf PORTB

ADJF1: ;  call NEWMATRIX    ;  call NEWADJUST     ;*******
        btfsc PORTE,1
        goto ADJF1

        PAGE1
        clrf TRISE
        PAGE0

        movf TIMINGCNT,W
        movwf CLKCNT

ADJF1A: call NEWADJUST
        movf CLKCNT,W
        xorlw 1
        btfss STATUS,Z
        goto ADJF1A

ADJF2:  call NEWADJUST

        PAGE1
        movlw %00000010
        movwf TRISE
        PAGE0
        nop
        movf PORTE,W
        movwf CALIBFLAG
        btfsc CALIBFLAG,1
        goto TEMPCALIBRATE

        PAGE1
        clrf TRISE
        PAGE0

        btfsc PORTB,7      ; is + pressed?
        goto INCTIM        ; no

        movlw 8
        subwf CALIBDECIMAL,F ; subtract from decimal place
        comf STATUS,W
        andlw 1
        subwf CALIBLSB,F   ; sub borrow if any
        comf STATUS,W
        andlw 1
        subwf CALIBMSB,F   ; sub borrow if any
        goto CONVERT

INCTIM: btfsc PORTA,5      ; is - pressed?
        goto ADJF2
        movlw 8
        addwf CALIBDECIMAL,F   ; add to decimal place
        movf STATUS,W
        andlw 1
        addwf CALIBLSB,F   ; add carry if any
        movf STATUS,W
        andlw 1
        addwf CALIBMSB,F   ; add carry if any

CONVERT: movf CALIBLSB,W
        movwf COUNT0
        movf CALIBMSB,W
        movwf COUNT1
        clrf COUNT2

        bcf FASTERFLAG,0
        btfsc CALIBMSB,7   ; is CALIB a negative number?
        goto CONV2         ; no
        comf COUNT0,F
        incf COUNT0,F
        comf COUNT1,F
        bsf FASTERFLAG,0

CONV2:  bcf STATUS,C           ; divide calibdecimal by 8 for display
        rrf CALIBDECIMAL,W
        movwf CALIBFRACTION
        bcf STATUS,C
        rrf CALIBFRACTION,F
        bcf STATUS,C
        rrf CALIBFRACTION,F

        clrf ADJUSTMSB
        clrf ADJUSTLSB
        bcf COUNT1,7
        call BIN2DEC
        movlw 16           ; + add to clock (upper segment)
        btfsc FASTERFLAG,0
        movlw 17           ; - subtract from clock (lower segment)
        movwf DIGIT4
        movf DIGIT3,F
        btfss STATUS,Z
        goto ADJF3
        movlw 12
        movwf DIGIT3       ; blank leading zero
        movf DIGIT2,F
        btfss STATUS,Z
        goto ADJF3
        movlw 12           ; blank leading zero
        movwf DIGIT2

ADJF3:  movf TIMINGCNT,W
        movwf CLKCNT

ADJF2A: call NEWADJUST
        movf CLKCNT,W
        xorlw 1
        btfss STATUS,Z
        goto ADJF2A
        goto ADJF2

; *****

NEWADJUST: movf MULTIPLEX,W
        xorlw 4
        btfsc STATUS,Z
        goto NA3           ; yes, so show mins

        call NEWMATRIX
        return

NA3:    movf CALIBFRACTION,W     ; mins - circle matrix via PORTC
        call TABLESECS
        call TABLEC
        movwf MATRIXCMINS
        movf CALIBFRACTION,W
        call TABLESECS
        andlw %00000111
        call TABLED
        movwf MATRIXDMINS
        movf MATRIXCMINS,W
        movwf PORTC
        movf MATRIXDMINS,W
        movwf PORTD

        clrf MULTIPLEX

NA2:    btfss INTCON,2    ; has a timer time-out been detected?
        goto NA2          ; no
        bcf INTCON,2
        decfsz CLKCNT,F    ; decrement system clock counter. Is it = 0?
        return
        movf TIMINGCNT,W
        movwf CLKCNT
        return


;**************

TEMPCALIBRATE:             ; temperature calibrate

TADJUST3: clrf CLKSEC
        movf TIMINGCNT,W
        movwf CLKCNT
        bcf INTCON,2

        clrf PORTA        ; turn off matrix display
        clrf PORTC
        clrf PORTD
        clrf PORTE
        movlw %11111111
        movwf PORTB

TADJF1: ;   call NEWSHOWTEMP
        btfsc PORTE,1
        goto TADJF1

        PAGE1
        clrf TRISE
        PAGE0

        movf TIMINGCNT,W
        movwf CLKCNT

TADJF1A: call NEWSHOWTEMP
        movf CLKCNT,W
        xorlw 1
        btfss STATUS,Z
        goto TADJF1A

TADJF2: call NEWSHOWTEMP

        PAGE1
        movlw %00000010
        movwf TRISE
        PAGE0
        nop
        movf PORTE,W
        movwf CALIBFLAG
        btfsc CALIBFLAG,1
        goto CALIBYEAR

TADJF5: PAGE1
        clrf TRISE
        PAGE0

        btfsc PORTB,7      ; is + pressed?
        goto INCTEMP       ; no

        movlw 1
        subwf TCALIBLSB,F   ; subtract 1 from LSB
        comf STATUS,W
        andlw 1
        subwf TCALIBMSB,F   ; sub borrow if any
        goto TCONVERT

INCTEMP: btfsc PORTA,5      ; is - pressed?
        goto TADJF2
        movlw 1
        addwf TCALIBLSB,F   ; subtract 1 from LSB
        movf STATUS,W
        andlw 1
        addwf TCALIBMSB,F   ; sub borrow if any

TCONVERT: movf TIMINGCNT,W
        movwf CLKCNT

TADJF2A: call NEWSHOWTEMP
        movf CLKCNT,W
        xorlw 1
        btfss STATUS,Z
        goto TADJF2A
        call GETADC
        goto TADJF2

NEWSHOWTEMP: movf TEMPMSD,W
        movwf DIGIT4
        movf TEMPNSD,W
        movwf DIGIT3
        movf TEMPLSD,W
        movwf DIGIT2
        movlw 10
        btfsc TEMPMINUS,0
        movlw 18
        movwf DIGIT1
        call NEWMATRIX
        return

;*************

CALIBYEAR: clrf MULTIPLEX   ; year calibrate
        movf YEARMSB,W
        movwf COUNT1
        movf YEARLSB,W
        movwf COUNT0
        clrf COUNT2
        call BIN2DEC

YADJUST3: clrf CLKSEC
        movf TIMINGCNT,W
        movwf CLKCNT
        bcf INTCON,2

        clrf PORTA        ; turn off matrix display
        clrf PORTC
        clrf PORTD
        clrf PORTE
        movlw %11111111
        movwf PORTB

YADJF1: ;  call NEWMATRIX 
        btfsc PORTE,1
        goto YADJF1

        PAGE1
        clrf TRISE
        PAGE0

        movf TIMINGCNT,W
        movwf CLKCNT

YADJF1A: call NEWMATRIX        ;...NEWSHOWYEAR
        movf CLKCNT,W
        xorlw 1
        btfss STATUS,Z
        goto YADJF1A

YADJF2: call NEWMATRIX          ; ...NEWSHOWYEAR

        PAGE1
        movlw %00000010
        movwf TRISE
        PAGE0
        nop
        movf PORTE,W
        movwf CALIBFLAG
        btfss CALIBFLAG,1
        goto YADJF5

        call SAVEPROM
        call WAITE1
        PAGE1
        clrf TRISE
        PAGE0
        return

YADJF5: PAGE1
        clrf TRISE
        PAGE0

        btfsc PORTB,7      ; is + pressed?
        goto INCYEAR       ; no

        movlw 1
        subwf YEARLSB,F   ; subtract 1 from LSB
        comf STATUS,W
        andlw 1
        subwf YEARMSB,F   ; sub borrow if any

        movf YEARMSB,W
        movwf COUNT1
        movf YEARLSB,W
        movwf COUNT0
        clrf COUNT2
        call BIN2DEC

        goto YCONVERT

INCYEAR: btfsc PORTA,5      ; is - pressed?
        goto YADJF2
        movlw 1
        addwf YEARLSB,F   ; subtract 1 from LSB
        movf STATUS,W
        andlw 1
        addwf YEARMSB,F   ; sub borrow if any

        movf YEARMSB,W
        movwf COUNT1
        movf YEARLSB,W
        movwf COUNT0
        clrf COUNT2
        call BIN2DEC

YCONVERT: movf TIMINGCNT,W
        movwf CLKCNT

YADJF2A: call NEWMATRIX          ;  ....NEWSHOWYEAR
        movf CLKCNT,W
        xorlw 1
        btfss STATUS,Z
        goto YADJF2A
        goto YADJF2

;NEWSHOWYEAR:
;        call NEWMATRIX
;        return

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F87x devices ********
          ;according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in STORE1.
SETPRM: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bcf STATUS,RP1  ;set for Page 0
        movf STORE1,W   ;get data value from STORE1 and hold in W
        bsf STATUS,RP1  ;set for Page 2
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf STATUS,RP0  ;set for page 3
        bcf EECON1,EEPGD ;point to Data memory
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw $55       ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw $AA       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        bcf STATUS,RP1  ;set for Page 0
        bcf STATUS,RP0

CHKWRT: btfss PIR2,EEIF ;wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR2,EEIF   ;clear bit 4 of PIR2
        return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F87x devices ****
;         according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
GETPRM: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf STATUS,RP0  ;set for Page 3
        bcf EECON1,EEPGD ;point to data memory
        bsf EECON1,RD   ;enable read flag
        bcf STATUS,RP0  ;set for Page 2 
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        bcf STATUS,RP1  ;set for Page 0
        return

; *********

LEAPYR:
        movf YEARLSB,W        ; get leap year facts
        movwf DIVIDLSB
        movf YEARMSB,W
        movwf DIVIDMSB

        movlw 4               ; divide by 4
        movwf DIVISLSB
        clrf DIVISMSB
        call DIVISION         ; 

;        movf DIVIDLSB,W
;        movwf MULCLSB
;        movf DIVIDMSB,W
;        movwf MULCMSB
	return


;A neat 16 bit division routine, from Peter Hemsley

DIVISION: movf   DIVISLSB,W
          iorwf  DIVISMSB,W
          btfsc  STATUS,2
          goto   JMP0041
          movlw  16
          movwf  BITCNT 
          clrf   REMDRMSB  
          clrf   REMDRLSB  
JMP0018:  bcf    STATUS,0
          rlf    DIVIDLSB,F
          rlf    DIVIDMSB,F
          rlf    REMDRLSB,F
          rlf    REMDRMSB,F
          movf   DIVISMSB,W
          subwf  REMDRMSB,W
          btfss  STATUS,2
          goto   JMP0029
          movf   DIVISLSB,W
          subwf  REMDRLSB,W
JMP0029:  btfss  STATUS,0
          goto   JMP0038
          movf   DIVISLSB,W
          subwf  REMDRLSB,F
          btfss  STATUS,0
          decf   REMDRMSB,F
          movf   DIVISMSB,W
          subwf  REMDRMSB,F
          bsf    DIVIDLSB,0
JMP0038:  decfsz BITCNT,F
          goto   JMP0018
          bcf    STATUS,2
JMP0041:  return 


; *****************

SAVEPROM: movf CLKDAY,W       ; stores changed factors back to eeprom
        movwf STORE1
        movlw 0
        call SETPRM

        movf CLKMONTH,W
        movwf STORE1
        movlw 1
        call SETPRM

        movf MONTH,W
        movwf STORE1
        movlw 2
        call SETPRM

        movf CLKHRS,W
        movwf STORE1
        movlw 3
        call SETPRM

        movf CLKMIN,W
        movwf STORE1
        movlw 4
        call SETPRM

        movf CALIBDECIMAL,W
        movwf STORE1
        movlw 5
        call SETPRM

        movf CALIBMSB,W
        movwf STORE1
        movlw 6
        call SETPRM

        movf CALIBLSB,W
        movwf STORE1
        movlw 7
        call SETPRM

        movf TCALIBMSB,W
        movwf STORE1
        movlw 8
        call SETPRM

        movf TCALIBLSB,W
        movwf STORE1
        movlw 9
        call SETPRM

        movf HEXHRS,W
        movwf STORE1
        movlw 10
        call SETPRM

        movf HEXMIN,W
        movwf STORE1
        movlw 11
        call SETPRM

        movf YEARMSB,W
        movwf STORE1
        movlw 12
        call SETPRM

        movf YEARLSB,W
        movwf STORE1
        movlw 13
        call SETPRM

        clrf SHOWMODE
        clrf CLKSEC
        call MODETIME
        movwf MODELENGTH

;        clrf MODELENGTH
        return

RECALLPROM: movlw 0
        call GETPRM
        movwf CLKDAY       ; reaclls factors back from eeprom

        movlw 1
        call GETPRM
        movwf CLKMONTH

        movlw 2
        call GETPRM
        movwf MONTH

        movlw 3
        call GETPRM
        movwf CLKHRS

        movlw 4
        call GETPRM
        movwf CLKMIN

        movlw 5
        call GETPRM
        movwf CALIBDECIMAL

        movlw 6
        call GETPRM
        movwf CALIBMSB

        movlw 7
        call GETPRM
        movwf CALIBLSB

        movlw 8 
        call GETPRM
        movwf TCALIBMSB

        movlw 9 
        call GETPRM
        movwf TCALIBLSB

        movlw 10
        call GETPRM
        movwf HEXHRS

        movlw 11
        call GETPRM
        movwf HEXMIN

        movlw 12
        call GETPRM
        movwf YEARMSB

        movlw 13
        call GETPRM
        movwf YEARLSB
        return

        .org $2100             ; default data eeprom values
        DE $11                 ; 0. day of month in hexadecimal (BCD) CLKDAY
        DE $01                 ; 1. clock month in hexadecimal (BCD) CLKMONTH
        DE 1                   ; 2. month in decimal MONTH
        DE 0                   ; 3. hours in decimal CLKHRS
        DE 0                   ; 4. minutes in decimal CLKMIN
        DE 127                 ; 5. CALIBDECIMAL time calib
        DE 127                 ; 6. CALIBMSB time calib
        DE 250                 ; 7. CALIBLSB time calib **
        DE 254                 ; 8. TCALIBMSB temp calib
        DE 250                 ; 9. TCALIBLSB temp calib
        DE $12                 ; 10. hours in hexadecimal (BCD) HEXHRS
        DE $00                 ; 11. minutes in hexadecimal (BCD) HEXMIN
        DE $07                 ; 12. year MSB ($07D3 = year 2003)
        DE $D3                 ; 13. year LSB

        .END


