;WINDSPEED351.ASM 15NOV02 - COPYRIGHT JOHN BECKER - EPE WIND SPEED MONITOR

;PIC16F628, 20MHz, WDT OFF, POR ON, XTAL HS

;Config register bits
; CP1 CP0 CP1 CP0 NIL CPD LVP BOR MCL OS2 POR WDT OS1 OS0
;  1   1   1   1   1   1   0   0   1   0   0   0   1   0
;N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
;respectively - refer to PIC '627 data sheet

#DEFINE PAGE0 BCF $03,5
#DEFINE PAGE1 BSF $03,5

        List P = PIC16F628, R=DEC; 
        __CONFIG   h'3F22'

INDF:    .EQU $00  ;page 0, 1, 2, 3
TMR0:    .EQU $01  ;page 0, 2
OPTION:  .EQU $01  ;page 1, 3
PCL:     .EQU $02  ;page 0, 1, 2, 3
STATUS:  .EQU $03  ;page 0, 1, 2, 3
FSR:     .EQU $04  ;page 0, 1, 2, 3

PORTA:   .EQU $05  ;page 0
TRISA:   .EQU $05  ;page 1
PORTB:   .EQU $06  ;page 0, 2
TRISB:   .EQU $06  ;page 1, 3

PCLATH:  .EQU $0A  ;page 0, 1, 2, 3
INTCON:  .EQU $0B  ;page 0, 1, 2, 3
PIR1:    .EQU $0C  ;page 0
PIE1:    .EQU $0C  ;page 1
PCON:    .EQU $0E  ;page 1
TMR1L:   .EQU $0E  ;page 0
TMR1H:   .EQU $0F  ;page 0
T1CON:   .EQU $10  ;page 0
TMR2:    .EQU $11  ;page 0 
T2CON:   .EQU $12  ;page 0 
CCPR1L   .EQU $15  ;page 0 
CCPR1H   .EQU $16  ;page 0 
CCP1CON: .EQU $17  ;page 0
RCSTA:   .EQU $18  ;page 0
TXSTA:   .EQU $18  ;page 1
TXREG:   .EQU $19  ;page 0
SPBRG:   .EQU $19  ;page 1
RCREG:   .EQU $1A  ;page 0
EEDATA:  .EQU $1A  ;page 1
EEADR:   .EQU $1B  ;page 1
EECON1:  .EQU $1C  ;page 1
EECON2:  .EQU $1D  ;page 1
CMCON:   .EQU $1F  ;page 0
VRCON:   .EQU $1F  ;page 1

unused1: .EQU $0D
unused2: .EQU $13
unused3: .EQU $14
unused4: .EQU $1B
unused5: .EQU $1C
unused6: .EQU $1D
unused7: .EQU $1E

LOOPA:      .EQU $20     ; general loop counter
RSLINE:     .EQU $21     ; LCD command/data flag
STORE:      .EQU $22     ; general store
SLOWIT:     .EQU $23     ; counter for pause
COUNT0      .EQU $24     ; lsb
COUNT1      .EQU $25     ; nsb
COUNT2      .EQU $26     ; msb
DIGIT1      .EQU $27     ; lsd digital conversion
DIGIT2      .EQU $28
DIGIT3      .EQU $29
DIGIT4      .EQU $2A
DIGIT5      .EQU $2B
DIGIT6      .EQU $2C
DIGIT7      .EQU $2D
DIGIT8      .EQU $2E     ; msd digital conversion
BITCNT      .EQU $2F     ; maths routine counter

DIGCNT      .EQU $30     ; maths routine counter
MULCLSB:    .EQU $31     ; multiplicant LSB
MULCMSB:    .EQU $32     ; multiplicant MSB
MULPLSB:    .EQU $33     ; multiplier LSB
MULPMSB:    .EQU $34     ; multiplier MSB
PRODLSB:    .EQU $35     ; product LSB
PRODMSB:    .EQU $36     ; product MSB
DIVIDLSB:   .EQU $37     ; Dividend and quotient LSB
DIVIDMSB:   .EQU $38     ; Dividend and quotient MSB
REMDRLSB:   .EQU $39     ; Remainder LSB
REMDRMSB:   .EQU $3A     ; Remainder MSB
DIVISLSB:   .EQU $3B     ; Divisor LSB
DIVISMSB:   .EQU $3C     ; Divisor MSB
SAVEW:      .EQU $3D     ; temp store in ISR
SAVES:      .EQU $3E     ; temp store in ISR
ISRFLAG:    .EQU $3F     ; ISR flag

SUBJECTNO:  .EQU $40     ; correction routine variable
CHANGECNT:  .EQU $41     ; correction routine variable
VALCHANGE:  .EQU $42     ; val changed flag during change routine
FREQMSB:    .EQU $43     ; timing count MSB
FREQLSB:    .EQU $44     ; timing count LSB
AVRGFLAG:   .EQU $45     ; averaging on/off flag
TESTFLAG:   .EQU $46     ; on/off flag for showing count or metres/sec on line 1
PREVLSB:    .EQU $47     ; previous val of windcount for averaging purposes
PREVMSB:    .EQU $48

; ******* Values in both pages *******

PROMVAL:    .EQU $70     ; for EEPROM write
WIND0LSB:   .EQU $71     ; wind count LSB direction 1
WIND0MSB:   .EQU $72     ; wind count MSB direction 1
WIND1LSB:   .EQU $73     ; wind count LSB direction 2
WIND1MSB:   .EQU $74     ; wind count MSB direction 2
LOOP:       .EQU $75     ; general loop counter
AVRGCNT:    .EQU $76     ; average location store counter

             ; locations up to $7F are available

AVERAGE0:   .EQU $A0     ; averaging store 0, extends to $BF
AVERAGE1:   .EQU $C0     ; averaging store 1, extends to $DF


             ;************************************************************
             ;           Bit Definitions
             ;************************************************************

W:      .EQU 0
F:      .EQU 1
C:      .EQU 0
DC:     .EQU 1 
Z:      .EQU 2

RP0:    .EQU 5          ; STATUS reg
RP1:    .EQU 6          ; STATUS reg
GIE:    .EQU 7          ; INTCON reg
RD:     .EQU 0          ; EECON1 reg eeprom read enable flag
WR:     .EQU 1          ; EECON1 reg eeprom write initiate flag
WREN:   .EQU 2          ; EECON1 reg eeprom write enable flag
EEIF:   .EQU 7          ; PIR2 reg 
INTE:   .EQU 4          ; RB0/INT interrupt enable bit
INTF    .EQU 1          ; RB0/INT external interrupt flag bit
RBIE    .EQU 3          ; RB7-4 change interrupt enable bit
RBIF    .EQU 0          ; RB7-4 change interrupt flag bit

        .ORG 0
        goto GIEOFF

        .ORG 4          ; Interrupt vector address
        bcf T1CON,0     ; stop timer 1
        goto ISR

GIEOFF: BCF INTCON,GIE  ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

LCDSET: clrf LOOP       ;clr LCD set-up loop
        clrf RSLINE     ;clear RS line for instruction send
LCDST2: movf LOOP,W     ;get table address
        call TABLCD     ;get set-up instruction
        call LCDOUT     ;perform it
        incf LOOP,F     ;inc loop
        btfss LOOP,3    ;has last LCD set-up instruction now been done?
        goto LCDST2     ;no
        return

TABLCD: addwf PCL,F     ;LCD initialisation table
        retlw %00110011 ;initialise lcd - first byte
        retlw %00110011 ;2nd byte (repeat of first)
        retlw %00110010 ;set for 4-bit operation
        retlw %00101100 ;set for 2 lines
        retlw %00000110 ;set entry mode to increment each address
        retlw %00001100 ;set display on, cursor off, blink off
        retlw %00000001 ;clear display
        retlw %00000010 ;return home, cursor & RAM to zero
                        ;end inititalisation table

SUBJECT: ADDWF PCL,F    ; used during setting correction values 
        retlw 'W'       ; 0 Wind pulse
        retlw 'I'
        retlw 'N'
        retlw 'D'
        retlw ' '
        retlw 'P'
        retlw 'U'
        retlw 'L'
        retlw 'S'
        retlw 'E'
        retlw 'W'       ; 10 Wind mask
        retlw 'I'
        retlw 'N'
        retlw 'D'
        retlw ' '
        retlw 'M'
        retlw 'A'
        retlw 'S'
        retlw 'K'
        retlw ' '

        retlw 'C'       ; 20 correction adjust
        retlw 'O'
        retlw 'R'
        retlw 'R'
        retlw 'E'
        retlw 'C'
        retlw 'T'
        retlw 'I'
        retlw 'O'
        retlw 'N'

SUBJECTVAL: ADDWF PCL,F ; used during setting correction values, for accessing SUBJECT message table
        retlw 0         ; Wind pulse
        retlw 10        ; Wind mask
        retlw 20        ; North adjust

;*******************

START:  clrf PORTA
        clrf PORTB
        movlw $07
        movwf CMCON

        PAGE1
        movlw %11000000
        movwf TRISB
        clrf TRISA
        movlw %00000111     ; timer 1:128, pull-ups on
        movwf OPTION
        PAGE0

        clrf INTCON
        call PAUSIT
        call LCDSET
        clrf INTCON

        movlw %00000000     ; T1 ext osc disable (bit3=0), T1 stopped (bit0=0), internal clock (bit1=0), bit2 dont care
        movwf T1CON

        btfsc PORTB,6       ; is PORTB,6 pressed?
        goto START2         ; no

        PAGE1               ; set TX rate fast for scope monitoring ease
        movlw %00000001
        movwf OPTION
        PAGE0
        goto START3

START2: btfss PORTB,7       ; is PORTB,7 pressed?
        call CHANGE         ; yes

START3: call CLRLINE1
        call CLRLINE2
        clrf AVRGCNT
        clrf AVRGFLAG
        clrf TESTFLAG
        clrf PREVLSB
        clrf PREVMSB

        movlw AVERAGE0     ; clear all Average 0 registers
        movwf FSR
        clrf LOOP
AVRCLR: clrf INDF
        incf FSR,F
        incf LOOP,F
        btfss LOOP,5
        goto AVRCLR

        PAGE1
        movlw AVERAGE1     ; clear all Average 1 registers
        movwf FSR
        clrf LOOP
AVRCLR2: clrf INDF
        incf FSR,F
        incf LOOP,F
        btfss LOOP,5
        goto AVRCLR2
        PAGE0

;****************** START OF MAIN

MAIN:   btfsc PORTB,6      ; is test switch pressed?
        goto MAIN1         ; no
        incf TESTFLAG,F    ; yes, toggle flag
MAIN0:  btfss PORTB,6      ; wait till switch released
        goto MAIN0
        goto WIND0

MAIN1:  btfsc PORTB,7
        goto WIND0
        incf AVRGFLAG,F
        call LCD27
        bsf RSLINE,4
        movlw ' '
        btfsc AVRGFLAG,0
        movlw 'A'
        call LCDOUT
        movlw ' '
        btfsc AVRGFLAG,0
        movlw 'v'
        call LCDOUT
MAIN2:  btfss PORTB,7      ; wait till switch released
        goto MAIN2

WIND0:  call LCD1
        bsf RSLINE,4
        movlw %00000000    ; North
        movwf PORTA        ; RA1 low - mux pin 10
        call SONICTX
        movf FREQLSB,W
;        movlw $D0
        movwf WIND0LSB
        movf FREQMSB,W
;        movlw $10   ;0F   ; E
        movwf WIND0MSB

WIND1:  movlw %00000010    ; South
        movwf PORTA        ; RA1 high - mux pin 10
        call SONICTX
        movf FREQLSB,W
;         movlw $10
        movwf WIND1LSB

        movf FREQMSB,W
;         movlw $0C    ;D
        movwf WIND1MSB

        movlw %00000000    ; North
        movwf PORTA        ; RA1 low - mux pin 10

        call GETSPEED
        goto MAIN

;***********             

SONICTX: call PAUSIT2
        movlw 0
        call PRMGET         ; WINDPULSE number of pulses to be sent
        movwf LOOP

        bcf T1CON,0         ; stop timer 1
        clrf FREQLSB
        clrf FREQMSB
        clrf TMR1L          ; reset timer 1
        clrf TMR1H
        bcf PIR1,0          ; clear timer 1 overflow
        bsf T1CON,0         ; start timer 1

BEAMITW: bsf PORTA,2        ; send 40kHz signal
        movlw 20            ; command qty sets freq/mark-space. 3 for 4MHz clock. 9 for 10MHz clock. 20 for 20MHz
        movwf LOOPA
B2:     decfsz LOOPA,F
        goto B2
        bcf PORTA,2         ; send 40kHz signal
        movlw 19            ; command qty sets freq/mark-space. 3 for 4MHz clock. 9 for 10MHz clock. 19 for 20MHz
        movwf LOOPA
B3:     decfsz LOOPA,F
        goto B3
        decfsz LOOP,F
        goto BEAMITW
;        goto BEAMITW       ; temporarily reinstate this command if you want to check 40kHz output (must be removed again after checking)

        movlw 1
        call PRMGET         ; WINDMASK  masking delay
        movwf LOOP

B4:     decfsz LOOP,F
        goto B4

        clrf ISRFLAG

        PAGE1
        movlw %11000001      ; set RB0 as input
        movwf TRISB
        PAGE0
        nop
        nop
        movf PORTB,W
        bsf PORTA,0          ; for scope to indicate start of Listening
        bcf INTCON, INTF     ; and ensure flag bit is clear
        bsf INTCON, INTE     ; enable INTF interrupt
        bsf INTCON, GIE      ; enable global interrupts

LISTEN2: btfsc PIR1,0        ; has timer 1 overflowed?
        goto L2              ; yes
        btfss ISRFLAG,0      ; no, has interrupt flag been set?
        goto LISTEN2         ; no

L2:     bcf INTCON, GIE      ; disable global interrupts
        bcf INTCON, INTF     ; and ensure flag bit is clear
        bcf INTCON, INTE     ; disable RBIF interrupt
        bcf T1CON,0          ; stop timer

        PAGE1
        movlw %11000000      ; set RB0 as output
        movwf TRISB
        PAGE0
        return

;********** CHANGE SETTINGS - groups to suit function

CHANGE: btfss PORTB,7
        goto CHANGE
        clrf CHANGECNT        ; loop counter

CHANGELOOP: clrf VALCHANGE    ; for single byte numbers, max val decimal 9
        movf CHANGECNT,W
        call SUBJECTVAL
        movwf SUBJECTNO
        call SHOWSUBJECT      ; show mode name
        call CHANGE4
        btfsc VALCHANGE,0     ; has value been changed?
        call SAVEPROM         ; yes
        incf CHANGECNT,F

        clrf VALCHANGE    ; for single byte numbers, max val decimal 255
        movf CHANGECNT,W
        call SUBJECTVAL
        movwf SUBJECTNO
        call SHOWSUBJECT      ; show mode name
        call CHANGE6
        btfsc VALCHANGE,0     ; has value been changed?
        call SAVEPROM         ; yes
        incf CHANGECNT,F

        clrf VALCHANGE   ; for single val bytes with +- signing
        bcf STATUS,C
        movf CHANGECNT,W
        call SUBJECTVAL
        movwf SUBJECTNO
        call SHOWSUBJECT      ; show mode name
        call CHANGE5
        btfsc VALCHANGE,0     ; has value been changed?
        call SAVEPROM         ; yes
        return

CHANGE4: movf CHANGECNT,W     ; get msb value - single byte vals
        call PRMGET
        movwf PROMVAL
        clrf LOOP

CMAX4:  movlw %10001111
        call LCDLIN
        bsf RSLINE,4
        movf PROMVAL,W
        iorlw 48
        call LCDOUT
        call WAITSWITCH
        movf PROMVAL,W
        addlw 6             ; add 6 to set DC flag if val > 9
        movlw 1             ; load W with 1 to put into COUNT0 if DC flag is set
        btfsc STATUS,DC
        movwf PROMVAL
        btfsc LOOP,0
        return
        call PAUSIT
        call PAUSIT
        call PAUSIT
        goto CMAX4

CHANGE6: movf CHANGECNT,W     ; get msb value - single byte vals to 255
        call PRMGET
        movwf PROMVAL
        clrf LOOP

CMAX6:  movlw %10001101
        call LCDLIN
        bsf RSLINE,4
        movf PROMVAL,W
        movwf COUNT0
        clrf COUNT1
        clrf COUNT2
        call BIN2DEC
        movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        call WAITSWITCH
        btfsc LOOP,0
        return
        call PAUSIT
        call PAUSIT
        call PAUSIT
        goto CMAX6

CHANGE5: movf CHANGECNT,W   ; get msb value - single bytes vals with +- signing
        call PRMGET
        movwf PROMVAL
        clrf LOOP

CMAX5:  movlw %10001110
        call LCDLIN
        bsf RSLINE,4
        movlw '+'
        btfss PROMVAL,3        ; is val +VE (bit 3 set)?
        movlw '-'
        call LCDOUT
        movf PROMVAL,W
        andlw %00000111
        iorlw 48
        call LCDOUT
        call WAITSWITCH
        btfsc LOOP,0
        return
        call PAUSIT
        call PAUSIT
        call PAUSIT
        goto CMAX5

WAITSWITCH: btfss PORTB,7
        goto INCVALUE
        btfss PORTB,6
        goto INCSUBJECT
        goto WAITSWITCH

INCVALUE: bsf VALCHANGE,0
        incf PROMVAL,F
        return

INCSUBJECT: btfss PORTB,6
        goto INCSUBJECT
        call CLRLINE2
        bsf LOOP,0
        call PAUSIT
        call PAUSIT
        return

; *********

SHOWSUBJECT: movlw 10
        movwf COUNT0     ; loop length
        call CLRLINE1
        call LCD1
        bsf RSLINE,4

SUB3:   movf SUBJECTNO,W
        call SUBJECT
        call LCDOUT
        incf SUBJECTNO,F
        decfsz COUNT0,F
        goto SUB3
        movlw ' '
        call LCDOUT
        return

; ************

SAVEPROM: movf CHANGECNT,W  ; stores changed factors back to eeprom 
        call SETPRM
        call LCD2B
        bsf RSLINE,4

        movlw 'S'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'V'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'D'
        call LCDOUT
        call LONGPAUSE
        call CLRLINE2
        return

; **********

LONGPAUSE: call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        return

;..............

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F62x devices ********
          ;according to data sheet page 93 (is the same as for 16F87x devices
	  ; except that PIR2 of '87x has become PIR1 for '62x and page 2/3 not used)
	
                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in PROMVAL, which is located in both pages at or above $70
SETPRM: 
        PAGE1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        movf PROMVAL,W  ;get data value from PROMVAL and hold in W
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw $55       ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw $AA       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
	PAGE0

CHKWRT: btfss PIR1,EEIF ;wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR1,EEIF   ;clear bit 4 of PIR2
        return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F62x devices ****
;         the data sheet page 93 is wrong!  This routine here works!

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET:	PAGE1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf EECON1,RD   ;enable read flag
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
	PAGE0
        return

;******** LCD ROUTINES **********

LCD1:   movlw %10000000
        goto LCDLIN
LCD21:  movlw %11000000
        goto LCDLIN
LCD27:  movlw %11001110
        goto LCDLIN
LCD2B:  movlw %11001011

LCDLIN: BCF RSLINE,4

LCDOUT: movwf STORE
        movlw 250
        movwf LOOPA
DELAYIT: decfsz LOOPA,F
        goto DELAYIT
        call SENDIT

SENDIT: swapf STORE,F
        movf STORE,W
        andlw 15
        iorwf RSLINE,W
        movwf PORTB
        BSF PORTB,5
        nop 
        nop
        BCF PORTB,5
        nop
        nop
        bsf PORTB,0      ; return RB0 high to facilitate scope reading of TR1 pulses
        return

;.............

PAUSIT: movlw 50
        movwf SLOWIT
        bcf INTCON,2
PAUSE:  btfss INTCON,2
        goto PAUSE
        bcf INTCON,2
        decfsz SLOWIT,F
        goto PAUSE
        return

PAUSIT2: clrf TMR0
        movlw 12          ; 25
        movwf SLOWIT
        bcf INTCON,2
PAUSE2: btfss INTCON,2
        goto PAUSE2
        bcf INTCON,2
        decfsz SLOWIT,F
        goto PAUSE2
        return

;************

BIN2DEC: clrf   DIGIT1
        clrf    DIGIT2
        clrf    DIGIT3
        clrf    DIGIT4
        clrf    DIGIT5
        clrf    DIGIT6
        clrf    DIGIT7
        clrf    DIGIT8

        movlw   24              ;24 bits to do
        movwf   BITCNT

BITLP:  rlf     COUNT0,F        ;Shift msb into carry
        rlf     COUNT1,F
        rlf     COUNT2,F

        movlw   DIGIT1
        movwf   FSR             ;Pointer to DIGITs
        movlw   8               ;8 DIGITs to do
        movwf   DIGCNT
ADJLP:  rlf     INDF,F          ;Shift DIGIT 1 bit left
        movlw   10
        subwf   INDF,w          ;Check and adjust for decimal overflow
        skpnc
        movwf   INDF

        incf    FSR,F           ;Next DIGIT
        decfsz  DIGCNT,F
        goto    ADJLP
        decfsz  BITCNT,F        ;Next bit
        goto    BITLP
        movlw 48
        iorwf DIGIT1,F       ; convert to ascii numeral
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F

        movf DIGIT8,W       ; blank leading zeros
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT8,4
        movf DIGIT7,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT7,4
        movf DIGIT6,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT6,4
        movf DIGIT5,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT5,4
        movf DIGIT4,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT4,4
        movf DIGIT3,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT3,4
        movf DIGIT2,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT2,4
        movf DIGIT8,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT8,4
        return

;****************

;A neat Multiply routine, from Peter Hemsley 15July01.

;Multiply 16 bit multiplicand (mulcL,H) by 16 bit multiplier (mulpL,H)
;32 bit result (product) in mulpL,H (low word) and prodL,H (high word)

MULTIPLY: movlw  16        ; B'00010000' H'10'
          movwf  BITCNT  
          clrf   PRODLSB  
          clrf   PRODMSB  
JMP0014:  bcf    STATUS,0
          btfss  MULPLSB,0
          goto   JMP0028
          movf   MULCLSB,W
          addwf  PRODLSB,F
          movf   MULCMSB,W
          btfsc  STATUS,0
          goto   JMP0024
          addwf  PRODMSB,F
          goto   JMP0028
JMP0024:  addwf  PRODMSB,F
          incf   PRODMSB,F
          btfsc  STATUS,2
          bsf    STATUS,0
JMP0028:  rrf    PRODMSB,F
          rrf    PRODLSB,F
          rrf    MULPMSB,F
          rrf    MULPLSB,F
          decfsz BITCNT,F
          goto   JMP0014
          return 

;A neat 16 bit division routine, from Peter Hemsley

DIVISION: movf   DIVISLSB,W
          iorwf  DIVISMSB,W
          btfsc  STATUS,2
          goto   JMP0041
          movlw  16
          movwf  BITCNT 
          clrf   REMDRMSB  
          clrf   REMDRLSB  
JMP0018:  bcf    STATUS,0
          rlf    DIVIDLSB,F
          rlf    DIVIDMSB,F
          rlf    REMDRLSB,F
          rlf    REMDRMSB,F
          movf   DIVISMSB,W
          subwf  REMDRMSB,W
          btfss  STATUS,2
          goto   JMP0029
          movf   DIVISLSB,W
          subwf  REMDRLSB,W
JMP0029:  btfss  STATUS,0
          goto   JMP0038
          movf   DIVISLSB,W
          subwf  REMDRLSB,F
          btfss  STATUS,0
          decf   REMDRMSB,F
          movf   DIVISMSB,W
          subwf  REMDRMSB,F
          bsf    DIVIDLSB,0
JMP0038:  decfsz BITCNT,F
          goto   JMP0018
          bcf    STATUS,2
JMP0041:  return 

;**************

; Based on Malc Wiles' Demo of interrupts
; ----------------------------------------------------------
; Interrupt service routine
; ----------------------------------------------------------

ISR:    bsf PORTA,3           ; for scope to indicate signal capture
        movwf SAVEW           ; save W
        swapf STATUS,W
        movwf SAVES           ; save STATUS
        PAGE0                 ; ensure bank 0 set for PORT access

        bsf ISRFLAG,0 
        bcf INTCON,INTF       ; clear the interrupt
        movf TMR1L,W          ; get sample COUNT
        movwf FREQLSB
        movf TMR1H,W
        movwf FREQMSB

        swapf SAVES,W         ; restore STATUS
        movwf STATUS
        swapf SAVEW,F         ; restore W
        swapf SAVEW,W
        retfie                ; exit ISR

;*************

CLRLINE1: call LCD1     ;set address for line 1 cell 1
        bsf RSLINE,4    ;set RS for data send
        clrf LOOP       ;
CLRL1:  movlw ' '       ;clear cell
        call LCDOUT     ;
        incf LOOP,F     ;inc loop
        btfss LOOP,4    ;has last LCD letter been sent?
        goto CLRL1      ;no
        return

CLRLINE2: call LCD21
        bsf RSLINE,4
        movlw 16
        movwf LOOP
CL2:    movlw ' '
        call LCDOUT
        decfsz LOOP,F
        goto CL2
        return

;*********** GET WIND SPEED FROM VALUES OF WIND0 AND WIND1

; In still air at around room temp (20^C) when the 2 screen counts are equal,
; the count value (3608 in one version of the prototype) represents a sound speed of 344 metres per second.
; A difference of 1 count between the two counters represents:
; (higher count / lower count) * 344
; e.g. (3609 / 3608) * 344 = 344.09532 metres per sec
; i.e. the sound speed is now 0.09532 faster than above "standard"
; and 1 count represents (rounded) sound speed + 0.1 metres per sec
; Wind speed in this case thus =
; 0.1 * 3600 (seconds in a hour) = 360 metres per hour
; 360 / 1000 (metres in 1 kilometre) = 0.36 kilometres per hour (kph)
; miles per hour (mph) = kph * 5 / 8
; therefore 1 pulse = 0.225mph
; feet per sec = metres per sec * 3.28
; therefore 1 pulse = 0.328 feet per sec
; A 20^C change in temp = 3.5% error from above which is taken as
; insignificant and not correct for.
; N.B. temp change is the main cause of changes in sound speed
; at   0^C = 332 m/s
; at  20^C = 344 m/s
; at 100^C = 386 m/s
; (effects of humidity and barometric pressure are small by comparison)

GETSPEED: btfss TESTFLAG,0      ; is test flag on?
        goto BYPASS1          ; no

        call LCD1
        bsf RSLINE,4
        movlw ' '
        call LCDOUT

        movf WIND0LSB,W       ; yes, show orig wind0
        movwf COUNT0          ; (typically around 3410 in prototype in still air)
        movf WIND0MSB,W
        movwf COUNT1
        clrf COUNT2
        call BIN2DEC
        movf DIGIT4,W
        call LCDOUT
        movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        movlw ' '
        call LCDOUT

        movf WIND1LSB,W       ; show orig wind1
        movwf COUNT0          ; (typically around 3410 in prototype in still air)
        movf WIND1MSB,W
        movwf COUNT1
        clrf COUNT2
        call BIN2DEC
        movf DIGIT4,W
        call LCDOUT
        movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT

BYPASS1: movlw 2              ; get correction val from eeprom
        call PRMGET
        movwf STORE
        btfss STORE,3         ; is val >= 8? (i.e has val to be added to north?)
        goto SPD1             ; no
        bcf STORE,3

        movf STORE,W          ; yes, add correction val to north
        andlw %00000111
        addwf WIND0LSB,F
        btfsc STATUS,C
        incf WIND0MSB,F
        goto SPD1A

SPD1:   movf STORE,W          ; no, add correction to south
        andlw %00000111
        addwf WIND1LSB,F
        btfsc STATUS,C
        incf WIND1MSB,F

SPD1A:  movf WIND1LSB,W       ; subtract South (Wind1) from North (Wind0)
        subwf WIND0LSB,F      ; leaving answer in Wind0
        btfss STATUS,C        ; is there a borrow?
        incf WIND1MSB,F       ; yes, so inc val of next byte to be subtracted
        movf WIND1MSB,W       ; subtract South from North MSB
        subwf WIND0MSB,F
        btfsc STATUS,C        ; is there a borrow?
        goto SPD2             ; no
        comf WIND0MSB,F       ; yes, so invert answer
        comf WIND0LSB,F       
        incf WIND0LSB,F       

SPD2:   call CHECKVALUE

        PAGE1
        movlw AVERAGE0        ; store answer for averaging
        addwf AVRGCNT,W
        movwf FSR
        movf WIND1LSB,W
        movwf INDF
        incf FSR,F
        movf WIND1MSB,W
        movwf INDF
        movlw AVERAGE0        ; get average of 16 samples
        movwf FSR             ; and use for further calcs
        PAGE0

        call GETAVERAGE
;        goto here

        PAGE1
        movlw AVERAGE1        ; store average answer for 2nd averaging
        addwf AVRGCNT,W
        movwf FSR
        movf WIND1LSB,W
        movwf INDF
        incf FSR,F
        movf WIND1MSB,W
        movwf INDF

        movlw AVERAGE1        ; get average of 16 samples
        movwf FSR             ; and use for further calcs
        clrf LOOP
        PAGE0

        call GETAVERAGE

here:
        movf DIGIT1,W
        movwf WIND1LSB
        movf DIGIT2,W 
        movwf WIND1MSB

        movlw 2               ; inc average counter by 2
        addwf AVRGCNT,F
        bcf AVRGCNT,5         ; limit to 32

        btfss AVRGFLAG,0      ; is averaging flag on?
        goto SPD4             ; no

        movf WIND1LSB,W       ; yes, copy averaged value into WIND0
        movwf WIND0LSB
        movf WIND1MSB,W
        movwf WIND0MSB

SPD4:   btfss TESTFLAG,0      ; is test flag on?
        goto BYPASS2          ; no

        movf WIND0LSB,W       ; yes, show count value (top right of screen)
        movwf COUNT0
        movf WIND0MSB,W
        movwf COUNT1
        clrf COUNT2
        call BIN2DEC
        movf DIGIT4,W
        call LCDOUT
        movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        movlw ' '
        call LCDOUT

BYPASS2: movf WIND0LSB,W      ; multiply by 5 (to multiply by 10 and
        movwf MULCLSB         ; divide by 2 and leave decimal place)
        movf WIND0MSB,W
        movwf MULCMSB
        movlw 5             
        movwf MULPLSB
        clrf MULPMSB
        call MULTIPLY

        movf MULPLSB,W
        movwf WIND0LSB
        movf MULPMSB,W
        movwf WIND0MSB

        btfsc TESTFLAG,0      ; is test flag on?
        goto BYPASS3          ; yes

        movf WIND0LSB,W       ; no, show metres per sec (count diff/10)
        movwf COUNT0
        movf WIND0MSB,W
        movwf COUNT1

        movf PRODLSB,W        ;****
        movwf COUNT2          ;****

;        clrf COUNT2
        call BIN2DEC

        call LCD1
        bsf RSLINE,4

        movf DIGIT5,W
        andlw 15              ;*******
        btfsc STATUS,Z        
        goto BP1
        movf DIGIT5,W         ;*******
        call LCDOUT
BP1:    movf DIGIT4,W
        call LCDOUT
        movf DIGIT3,W
        iorlw 48
        call LCDOUT
        movlw '.'
        call LCDOUT
        movf DIGIT2,W
        iorlw 48
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        movlw 'm'
        call LCDOUT
        movlw '/'
        call LCDOUT
        movlw 's'
        call LCDOUT

        movf WIND0LSB,W      ; multiply value of north by 328 (3.28 x 100)
        movwf MULCLSB        ; (1 * 256 + 72) to get feet per sec
        movf WIND0MSB,W
        movwf MULCMSB
        movlw 72             
        movwf MULPLSB
        movlw 1
        movwf MULPMSB
        call MULTIPLY

        movf MULPLSB,W
        movwf COUNT0
        movf MULPMSB,W
        movwf COUNT1

        movf PRODLSB,W        ;****
        movwf COUNT2          ;****
        
;        clrf COUNT2
        call BIN2DEC          ; show feet per sec

        movf DIGIT7,W
        andlw 15              ;*******
        btfsc STATUS,Z
        goto BP2
        movf DIGIT7,W         ;*******
        call LCDOUT

BP2:    movf DIGIT6,W
        call LCDOUT
        movf DIGIT5,W
        iorlw 48
        call LCDOUT
        movlw '.'
        call LCDOUT
        movf DIGIT4,W
        iorlw 48
        call LCDOUT
        movf DIGIT3,W
        iorlw 48
        call LCDOUT
        movlw 'f'
        call LCDOUT
        movlw '/'
        call LCDOUT
        movlw 's'
        call LCDOUT

BYPASS3: movf WIND0LSB,W      ; multiply value of north by 36 (3600/100)
        movwf MULCLSB         ; get kilometres per hour
        movf WIND0MSB,W
        movwf MULCMSB

        movlw 36             
        movwf MULPLSB
        clrf MULPMSB
        call MULTIPLY

        movf MULPLSB,W
        movwf COUNT0
        movf MULPMSB,W
        movwf COUNT1

        movf PRODLSB,W        ;****
        movwf COUNT2          ;****
;        clrf COUNT2

        call BIN2DEC          ; show kph

        call LCD21
        bsf RSLINE,4
        movf DIGIT6,W
        call LCDOUT
        movf DIGIT5,W
        call LCDOUT
        movf DIGIT4,W
        iorlw 48
        call LCDOUT
        movlw '.'
        call LCDOUT
        movf DIGIT3,W
        iorlw 48
        call LCDOUT
        movlw 'k'
        call LCDOUT
        movlw 'h'
        call LCDOUT

        movf MULPLSB,W        ; get mph
        movwf DIVIDLSB
        movf MULPMSB,W
        movwf DIVIDMSB

;        movlw 8               ; divide by 8
;        movwf DIVISLSB
;        clrf DIVISMSB
;        call DIVISION

        bcf STATUS,C           ;*********
        rrf PRODLSB,F
        rrf DIVIDMSB,F
        rrf DIVIDLSB,F
        bcf STATUS,C
        rrf PRODLSB,F
        rrf DIVIDMSB,F
        rrf DIVIDLSB,F
        bcf STATUS,C
        rrf PRODLSB,F
        rrf DIVIDMSB,F
        rrf DIVIDLSB,F

        movf DIVIDLSB,W
        movwf MULCLSB
        movf DIVIDMSB,W
        movwf MULCMSB

        movlw 5
        movwf MULPLSB
        clrf MULPMSB
        call MULTIPLY         ; multiply by 5

        movf MULPLSB,W        
        movwf COUNT0
        movf MULPMSB,W
        movwf COUNT1

        movf PRODLSB,W        ;****
        movwf COUNT2          ;****

;        clrf COUNT2
        call BIN2DEC
        movf DIGIT6,W
        call LCDOUT
        movf DIGIT5,W
        call LCDOUT
        movf DIGIT4,W
        iorlw 48
        call LCDOUT
        movlw '.'
        call LCDOUT
        movf DIGIT3,W
        iorlw 48
        call LCDOUT
        movlw 'm'
        call LCDOUT
        movlw 'h'
        call LCDOUT
        return

;.............

GETAVERAGE:
        clrf LOOP
        clrf DIGIT1
        clrf DIGIT2
        clrf DIGIT3

SPD3A:  PAGE1
        movf INDF,W
        PAGE0

        addwf DIGIT1,F
        movf STATUS,W
        andlw 1
        addwf DIGIT2,F
        movf STATUS,W
        andlw 1
        addwf DIGIT3,F

        PAGE1
        incf FSR,F
        movf INDF,W
        PAGE0

        addwf DIGIT2,F
        movf STATUS,W
        andlw 1
        addwf DIGIT3,F

        PAGE1
        incf FSR,F
        PAGE0

        movlw 2
        addwf LOOP,F
        btfss LOOP,5
        goto SPD3A

        bcf STATUS,C          ; divide by 16
        rrf DIGIT3,F
        rrf DIGIT2,F
        rrf DIGIT1,F
        bcf STATUS,C
        rrf DIGIT3,F
        rrf DIGIT2,F
        rrf DIGIT1,F
        bcf STATUS,C
        rrf DIGIT3,F
        rrf DIGIT2,F
        rrf DIGIT1,F
        bcf STATUS,C
        rrf DIGIT3,F
        rrf DIGIT2,F
        rrf DIGIT1,F
        movf DIGIT1,W
        movwf WIND1LSB
        movf DIGIT2,W
        movwf WIND1MSB
        return

;............

CHECKVALUE: movf WIND0LSB,W   ; check that val is reasonable, for use in averaging
        movwf WIND1LSB        ; first copying true val into temporary stores
        movwf FREQLSB
        movf WIND0MSB,W
        movwf WIND1MSB
        movwf FREQMSB
        movf PREVLSB,W
        movwf DIGIT1
        movf PREVMSB,W
        movwf DIGIT2 

        movf DIGIT1,W         ; subtract prev LSB from current
        subwf FREQLSB,F       ; leaving answer in FREQLSB
        btfss STATUS,C        ; is there a borrow?
        incf DIGIT2,F         ; yes, so inc val of next byte to be subtracted
        movf DIGIT2,W         ; subtract prev MSB from current
        subwf FREQMSB,F 
        btfss STATUS,C        ; is there a borrow?
        goto VALUE2           ; yes

        movf FREQLSB,W        ; check if val > 15
        andlw %11110000
        iorwf FREQMSB,W
        btfsc STATUS,Z
        goto VALUE3           ; no, less than 

        movf PREVMSB,W        ; yes, add 16 to count val
        movwf WIND1MSB
        movf PREVLSB,W
        movwf WIND1LSB
        movlw 8
        addwf WIND1LSB,F
        btfsc STATUS,C
        incf WIND1MSB,F
        goto VALUE3

VALUE2: comf FREQMSB,F       ; yes, so invert answer
        comf FREQLSB,F       
        incf FREQLSB,F       

        movf FREQLSB,W        ; check if val > 7
        andlw %11110000
        iorwf FREQMSB,W
        btfsc STATUS,Z
        goto VALUE3           ; no, less than 8

        movf PREVMSB,W        ; yes, sub 4 from count val
        movwf WIND1MSB
        movf PREVLSB,W
        movwf WIND1LSB
        movlw 8
        subwf WIND1LSB,F
        btfss STATUS,C
        decf WIND1MSB,F

VALUE3: movf WIND1LSB,W       ; store val as previous count
        movwf PREVLSB
        movf WIND1MSB,W
        movwf PREVMSB
        return

        .org $2100             ; data eeprom values
        DE 2,80,0,0,0

         .END


