;WINDTUNNEL25.ASM 23NOV02 - COPYRIGHT JOHN BECKER - EPE WIND TUNNEL MONITOR

;PIC16F628, 4MHz, WDT OFF, POR ON, XTAL HS

;Config register bits
; CP1 CP0 CP1 CP0 NIL CPD LVP BOR MCL OS2 POR WDT OS1 OS0
;  1   1   1   1   1   1   0   0   1   0   0   0   1   0
;N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
;respectively - refer to PIC '628 data sheet

#DEFINE PAGE0 BCF $03,5
#DEFINE PAGE1 BSF $03,5

        List P = PIC16F628, R=DEC; 
        __CONFIG   h'3F21'

INDF:    .EQU $00  ;page 0, 1, 2, 3
TMR0:    .EQU $01  ;page 0, 2
OPTION:  .EQU $01  ;page 1, 3
PCL:     .EQU $02  ;page 0, 1, 2, 3
STATUS:  .EQU $03  ;page 0, 1, 2, 3
FSR:     .EQU $04  ;page 0, 1, 2, 3

PORTA:   .EQU $05  ;page 0
TRISA:   .EQU $05  ;page 1
PORTB:   .EQU $06  ;page 0, 2
TRISB:   .EQU $06  ;page 1, 3

PCLATH:  .EQU $0A  ;page 0, 1, 2, 3
INTCON:  .EQU $0B  ;page 0, 1, 2, 3
PIR1:    .EQU $0C  ;page 0
PIE1:    .EQU $0C  ;page 1
PCON:    .EQU $0E  ;page 1
TMR1L:   .EQU $0E  ;page 0
TMR1H:   .EQU $0F  ;page 0
T1CON:   .EQU $10  ;page 0
TMR2:    .EQU $11  ;page 0 
T2CON:   .EQU $12  ;page 0 
CCPR1L   .EQU $15  ;page 0 
CCPR1H   .EQU $16  ;page 0 
CCP1CON: .EQU $17  ;page 0
RCSTA:   .EQU $18  ;page 0
TXSTA:   .EQU $18  ;page 1
TXREG:   .EQU $19  ;page 0
SPBRG:   .EQU $19  ;page 1
RCREG:   .EQU $1A  ;page 0
EEDATA:  .EQU $1A  ;page 1
EEADR:   .EQU $1B  ;page 1
EECON1:  .EQU $1C  ;page 1
EECON2:  .EQU $1D  ;page 1
CMCON:   .EQU $1F  ;page 0
VRCON:   .EQU $1F  ;page 1

unused1: .EQU $0D
unused2: .EQU $13
unused3: .EQU $14
unused4: .EQU $1B
unused5: .EQU $1C
unused6: .EQU $1D
unused7: .EQU $1E

LOOP:       .EQU $20     ; loop counter
LOOPA:      .EQU $21     ; general loop counter
RSLINE:     .EQU $22     ; LCD command/data flag
CLKCNT:     .EQU $23     ; pre-counter for seconds
COUNT0      .EQU $24     ; lsb
COUNT1      .EQU $25     ; nsb
COUNT2      .EQU $26     ; msb
DIGIT1      .EQU $27     ; lsd digital conversion
DIGIT2      .EQU $28
DIGIT3      .EQU $29
DIGIT4      .EQU $2A
DIGIT5      .EQU $2B
DIGIT6      .EQU $2C
DIGIT7      .EQU $2D
DIGIT8      .EQU $2E     ; msd digital conversion
BITCNT      .EQU $2F     ; maths routine counter

DIGCNT:     .EQU $30     ; maths routine counter
DIVIDLSB:   .EQU $31     ; Dividend and quotient LSB
DIVIDMSB:   .EQU $32     ; Dividend and quotient MSB
REMDRLSB:   .EQU $33     ; Remainder LSB
REMDRMSB:   .EQU $34     ; Remainder MSB
DIVISLSB:   .EQU $35     ; Divisor LSB
DIVISMSB:   .EQU $36     ; Divisor MSB
STORE1:     .EQU $37     ; general store
PREVFAN:    .EQU $38
BLADES:     .EQU $39
PULSEMSB:   .EQU $3A
PULSELSB:   .EQU $3B
HZLSB:      .EQU $3C
HZMSB:      .EQU $3D
PREVHZ:     .EQU $3E

; ***** VALUE HELD IN BOTH PAGES

PROMVAL:    .EQU $70

             ;************************************************************
             ;           Bit Definitions
             ;************************************************************

W:      .EQU 0
F:      .EQU 1
C:      .EQU 0
DC:     .EQU 1 
Z:      .EQU 2

RP0:    .EQU 5          ; STATUS reg
RP1:    .EQU 6          ; STATUS reg
GIE:    .EQU 7          ; INTCON reg
RD:     .EQU 0          ; EECON1 reg eeprom read enable flag
WR:     .EQU 1          ; EECON1 reg eeprom write initiate flag
WREN:   .EQU 2          ; EECON1 reg eeprom write enable flag
EEIF:   .EQU 7          ; PIR2 reg 
INTE:   .EQU 4          ; RB0/INT interrupt enable bit
INTF:   .EQU 1          ; RB0/INT external interrupt flag bit
RBIE:   .EQU 3          ; RB7-4 change interrupt enable bit
RBIF:   .EQU 0          ; RB7-4 change interrupt flag bit

        .ORG 0
        goto GIEOFF
        .ORG 4          ; Interrupt vector address
        goto GIEOFF
        .ORG 5

GIEOFF: BCF INTCON,GIE  ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

LCDSET: clrf LOOP       ;clr LCD set-up loop
        clrf RSLINE     ;clear RS line for instruction send
LCDST2: movf LOOP,W     ;get table address
        call TABLCD     ;get set-up instruction
        call LCDOUT     ;perform it
        incf LOOP,F     ;inc loop
        btfss LOOP,3    ;has last LCD set-up instruction now been done?
        goto LCDST2     ;no
        return

TABLCD: addwf PCL,F     ;LCD initialisation table
        retlw %00110011 ;initialise lcd - first byte
        retlw %00110011 ;2nd byte (repeat of first)
        retlw %00110010 ;set for 4-bit operation
        retlw %00101100 ;set for 2 lines
        retlw %00000110 ;set entry mode to increment each address
        retlw %00001100 ;set display on, cursor off, blink off
        retlw %00000001 ;clear display
        retlw %00000010 ;return home, cursor & RAM to zero
                        ;end inititalisation table

MESSAG: addwf PCL,F
        retlw ' '
        retlw 'R'
        retlw 'P'
        retlw 'S'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw 'H'
        retlw 'z'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw 'S'
        retlw 'E'
        retlw 'G'

MESSAG2: addwf PCL,F
        retlw 'S'
        retlw 'E'
        retlw 'T'
        retlw ' '
        retlw 'B'
        retlw 'L'
        retlw 'A'
        retlw 'D'
        retlw 'E'
        retlw ' '
        retlw 'C'
        retlw 'O'
        retlw 'U'
        retlw 'N'
        retlw 'T'
        retlw ' '

;*******************

START:  clrf PORTA
        clrf PORTB
        movlw $07
        movwf CMCON

        PAGE1
        movlw %10000000
        movwf TRISB
        movlw %00000111
        movwf TRISA
        movlw %10000110 ;set timer ratio 1:128, pull-ups off
        movwf OPTION
        PAGE0

        clrf INTCON
        call PAUSIT
        call LCDSET
        clrf INTCON

        call PAUSIT     ;1st 1/5th sec delay

        movlw 25        ;initial basic CLKCNT val for secs timing
        movwf CLKCNT
        clrf PULSEMSB
        clrf PULSELSB
        clrf PREVFAN
        clrf HZLSB
        clrf HZMSB
        clrf PREVHZ

        movlw 0
        call PRMGET
        movwf BLADES

        btfsc PORTA,2   ; is blade qty setting required?
        goto SETBLADES  ; yes

LCDMSG: clrf LOOP       ; clear loop
        bsf RSLINE,4    ; set RS for data send
LCDMS2: movf LOOP,W     ; get table address
        call MESSAG     ; get message letter
        call LCDOUT     ; show it
        incf LOOP,F     ; inc loop
        btfss LOOP,4    ; has last LCD letter been sent?
        goto LCDMS2     ; no, repeat for next

        movlw %11001111 ; show blades
        call LCDLIN     ; set address for line 2 (address 64)
        movf BLADES,W
        iorlw 48
        call LCDOUT
        call CLKSHW

INTRPT: movf PORTA,W    ; get PORTA
        movwf STORE1
        andlw %00000010 ; has RA1 change occurred?
        xorwf PREVFAN,W
        btfsc STATUS,Z
        goto INT1

        incfsz PULSELSB,F ; inc counter
        goto INT1
        incf PULSEMSB,F

INT1:   movf STORE1,W
        andlw %00000001 ; has RA0 change occurred?
        xorwf PREVHZ,W
        btfsc STATUS,Z
        goto INT2

        incfsz HZLSB,F ; inc HZ counter
        goto INT2
        incf HZMSB,F

INT2:
        movf STORE1,W   ; store RA1 val
        andlw %00000010
        movwf PREVFAN
        movf STORE1,W   ; store RA0 val
        andlw %00000001
        movwf PREVHZ

        btfss INTCON,2  ; has a timer time-out been detected?
        goto INTRPT     ; no
        bcf INTCON,2    ; yes
        call CLKADD     ; update time
INT3:   btfss INTCON,2  ; has a timer time-out been detected?
        goto INT3       ; no
        bcf INTCON,2    ; yes
        goto INTRPT

CLKADD: decfsz CLKCNT,F ; increment system clock counter. Is it = 0?
        return          ; no
        movlw 25        ; yes, reset start value of CLKCNT
        movwf CLKCNT

CLKSHW: movlw %11000000 ; show rps
        call LCDLIN     ; set address for line 2 (address 64)

        movf PULSELSB,W ; get pulse count
        movwf DIVIDLSB
        movf PULSEMSB,W
        movwf DIVIDMSB
        clrf COUNT2

        bcf STATUS,C
        rlf BLADES,W    ; divide by blade count x 2
        movwf DIVISLSB
        clrf DIVISMSB
        call DIVISION

        movf DIVIDMSB,W
        movwf COUNT1
        movf DIVIDLSB,W
        movwf COUNT0
        clrf COUNT2

        call BIN2DEC
        movf DIGIT4,W
        call LCDOUT
        movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT

        movlw %11000110 ; show Hz
        call LCDLIN

        movf HZLSB,W    ; get Hz count
        movwf COUNT0
        movf HZMSB,W
        movwf COUNT1
        clrf COUNT2

        bcf STATUS,C
        rrf COUNT1,F    ; divide by 2
        rrf COUNT0,F

        call BIN2DEC
        movf DIGIT4,W
        call LCDOUT
        movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT

        clrf PULSELSB
        clrf PULSEMSB
        clrf HZLSB
        clrf HZMSB
	return

LCDOUT: movwf STORE1    ; temp store value that will be output to LCD
        movlw 60        ; set minimum time between sending full bytes to
        movwf LOOPA     ; LCD - value of 60 seems OK for this prog with
DELAY:  decfsz LOOPA,F  ; XTAL clk of upto 5MHz, possibly 5.5MHz
        goto DELAY
        call SENDIT     ; send MSB, then (by default) send LSB

SENDIT: swapf STORE1,F  ; swap byte nibbles
        movf STORE1,W   ; get nibble (MSB)
        andlw 15        ; AND to isolate nibble
        iorwf RSLINE,W  ; OR the RS bit
        movwf PORTB     ; output the byte
        bsf PORTB,5     ; set E high
        bcf PORTB,5     ; set E low
        return

LCDLIN: bcf RSLINE,4    ; sets LCD command/line
        call LCDOUT     ; and outputs cmmand code to LCD
        bsf RSLINE,4    ; set RS flag
        return

PAUSIT: movlw 5         ; 1/5th sec wait set
        movwf CLKCNT
        clrf INTCON     ; clear interupt flag
PAUSE:                  ; initial 1/5th sec wait before setting up LCD
        btfss INTCON,2  ; has a timer time-out been detected?
        goto PAUSE      ; no
        bcf INTCON,2    ; yes
        decfsz CLKCNT,F ; dec loop, is it zero?
        goto PAUSE      ; no
        return          ; yes

BIN2DEC: clrf   DIGIT1
        clrf    DIGIT2
        clrf    DIGIT3
        clrf    DIGIT4
        clrf    DIGIT5
        clrf    DIGIT6
        clrf    DIGIT7
        clrf    DIGIT8

        movlw   24        ; 24 bits to do
        movwf   BITCNT

BITLP:  rlf     COUNT0,F  ; Shift msb into carry
        rlf     COUNT1,F
        rlf     COUNT2,F

        movlw   DIGIT1
        movwf   FSR       ; Pointer to DIGITs
        movlw   8         ; 8 DIGITs to do
        movwf   DIGCNT
ADJLP:  rlf     INDF,F    ; Shift DIGIT 1 bit left
        movlw   10
        subwf   INDF,w    ; Check and adjust for decimal overflow
        skpnc
        movwf   INDF

        incf    FSR,F     ; Next DIGIT
        decfsz  DIGCNT,F
        goto    ADJLP
        decfsz  BITCNT,F  ; Next bit
        goto    BITLP
        movlw 48
        iorwf DIGIT1,F    ; convert to ascii numeral
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F

        movf DIGIT5,W     ; blank leading zeros
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT5,4
        movf DIGIT4,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT4,4
        movf DIGIT3,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT3,4
        movf DIGIT2,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT2,4
        return

; ******** A neat 16 bit division routine, from Peter Hemsley

DIVISION: movf   DIVISLSB,W
          iorwf  DIVISMSB,W
          btfsc  STATUS,2
          goto   JMP0041
          movlw  16
          movwf  BITCNT 
          clrf   REMDRMSB  
          clrf   REMDRLSB  
JMP0018:  bcf    STATUS,0
          rlf    DIVIDLSB,F
          rlf    DIVIDMSB,F
          rlf    REMDRLSB,F
          rlf    REMDRMSB,F
          movf   DIVISMSB,W
          subwf  REMDRMSB,W
          btfss  STATUS,2
          goto   JMP0029
          movf   DIVISLSB,W
          subwf  REMDRLSB,W
JMP0029:  btfss  STATUS,0
          goto   JMP0038
          movf   DIVISLSB,W
          subwf  REMDRLSB,F
          btfss  STATUS,0
          decf   REMDRMSB,F
          movf   DIVISMSB,W
          subwf  REMDRMSB,F
          bsf    DIVIDLSB,0
JMP0038:  decfsz BITCNT,F
          goto   JMP0018
          bcf    STATUS,2
JMP0041:  return 

; ***** SET BLADE COUNT - RANGE 1 to 9

SETBLADES: movlw %10000000 ; show blades
        call LCDLIN     ; set address for line 1 (address 0)
        clrf LOOP       ; clear loop
        bsf RSLINE,4    ; set RS for data send
LCDMS4: movf LOOP,W     ; get table address
        call MESSAG2    ; get message letter
        call LCDOUT     ; show it
        incf LOOP,F     ; inc loop
        btfss LOOP,4    ; has last LCD letter been sent?
        goto LCDMS4     ; no, repeat for next

        movlw %11000000 ; show blades
        call LCDLIN     ; set address for line 2 (address 64)
        movf BLADES,W
        iorlw 48
        call LCDOUT

SETB1:  btfsc PORTA,2   ; wait till switch released
        goto SETB1

SETB2:  call PAUSIT
        call PAUSIT
SETB3:  btfss PORTA,2   ; wait till switch pressed
        goto SETB3
        incf BLADES,F
        movf BLADES,W   ; are blades >= 10?
        addlw 6
        btfss STATUS,DC
        goto SETB4
        movlw 1
        movwf BLADES

SETB4:  movf BLADES,W
        movwf PROMVAL
        movlw 0
        call SETPRM

        movlw %11000000 ; show blades
        call LCDLIN     ; set address for line 2 (address 64)
        movf BLADES,W
        iorlw 48
        call LCDOUT
        call PAUSIT
        goto SETB2

;..............

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F62x devices ********
          ; according to data sheet page 93 (is the same as for 16F87x devices
	  ; except that PIR2 of '87x has become PIR1 for '62x and page 2/3 not used)
          ; This routine is entered with W holding the eeprom byte address at
          ; which data is to be stored. The data to be stored is held in
          ; PROMVAL, which is located in both pages at or above $70

SETPRM: PAGE1
        movwf EEADR     ; copy W into EEADR to set eeprom address
        movf PROMVAL,W  ; get data value from PROMVAL and hold in W
        movwf EEDATA    ; copy W into eeprom data byte register
        bsf EECON1,WREN ; enable write flag

MANUAL: movlw $55       ; these lines cause the action required by
        movwf EECON2    ; by the eeprom to store the data in EEDATA
        movlw $AA       ; at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ; set the ``perform write'' flag
	PAGE0

CHKWRT: btfss PIR1,EEIF ; wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR1,EEIF   ; clear bit 4 of PIR2
        return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F62x devices ****
;         the data sheet page 93 is wrong!  This routine here works!

                        ; This routine is entered with W holding
                        ; the eeprom byte address to be read.
PRMGET:	PAGE1
        movwf EEADR     ; copy W into EEADR to set eeprom address
        bsf EECON1,RD   ; enable read flag
        movf EEDATA,W   ; read eeprom data now in EEDATA into W
	PAGE0
        return


        .org $2100      ; data eeprom value
        DE 1

         .END


