VERSION 5.00
Begin VB.Form Morse 
   Caption         =   "EPE Morse Code Facility V1.0"
   ClientHeight    =   5715
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   9645
   LinkTopic       =   "Form1"
   ScaleHeight     =   5715
   ScaleWidth      =   9645
   StartUpPosition =   1  'CenterOwner
   Begin VB.CommandButton SetRate 
      BackColor       =   &H0000FF00&
      Caption         =   "Set Timing"
      Height          =   375
      Left            =   6840
      Style           =   1  'Graphical
      TabIndex        =   43
      ToolTipText     =   "Calculates program's TX timing to match PC used (see EPE text)"
      Top             =   4840
      Width           =   1095
   End
   Begin VB.CommandButton MorseKey 
      BackColor       =   &H0000FF00&
      Caption         =   "Send Morse via Keyboard"
      Height          =   495
      Left            =   1320
      Style           =   1  'Graphical
      TabIndex        =   41
      ToolTipText     =   "Performs same action as a morse key when any keyboard key pressed "
      Top             =   840
      Width           =   1095
   End
   Begin VB.CommandButton TextKey 
      BackColor       =   &H0000FF00&
      Caption         =   "Send Text via Keyboard"
      Height          =   495
      Left            =   120
      Style           =   1  'Graphical
      TabIndex        =   40
      ToolTipText     =   "Send morse code for letters entered via keyboard"
      Top             =   840
      Width           =   1095
   End
   Begin VB.ListBox List1 
      Height          =   3765
      Index           =   1
      Left            =   4920
      Sorted          =   -1  'True
      TabIndex        =   36
      ToolTipText     =   "Displays morse codes"
      Top             =   960
      Width           =   4575
   End
   Begin VB.DriveListBox Drive1 
      Height          =   315
      Left            =   8400
      TabIndex        =   32
      ToolTipText     =   "Allows selection of drive used as default (see Notes via Text File Directory button)  "
      Top             =   5040
      Width           =   975
   End
   Begin VB.OptionButton Option1 
      Caption         =   "3BCh"
      Height          =   255
      Index           =   2
      Left            =   5760
      TabIndex        =   30
      ToolTipText     =   "Allows correct printer port register to be selected (see EPE text)"
      Top             =   5160
      Width           =   735
   End
   Begin VB.OptionButton Option1 
      Caption         =   "278h"
      Height          =   255
      Index           =   1
      Left            =   5760
      TabIndex        =   29
      ToolTipText     =   "Allows correct printer port register to be selected (see EPE text)"
      Top             =   4920
      Width           =   735
   End
   Begin VB.OptionButton Option1 
      Caption         =   "378h"
      Height          =   255
      Index           =   0
      Left            =   5040
      TabIndex        =   28
      ToolTipText     =   "Allows correct printer port register to be selected (see EPE text)"
      Top             =   5160
      Value           =   -1  'True
      Width           =   735
   End
   Begin VB.CommandButton Quit 
      BackColor       =   &H0000FFFF&
      Caption         =   "Quit Morse Program"
      Height          =   615
      Left            =   8640
      Style           =   1  'Graphical
      TabIndex        =   27
      ToolTipText     =   "Final exit from program"
      Top             =   240
      Width           =   975
   End
   Begin VB.CommandButton ViewText 
      BackColor       =   &H00FFFF00&
      Caption         =   " View Text File"
      Height          =   495
      Left            =   120
      Style           =   1  'Graphical
      TabIndex        =   24
      ToolTipText     =   "Displays text file contents"
      Top             =   4200
      Width           =   975
   End
   Begin VB.CommandButton SendAll 
      BackColor       =   &H0000FF00&
      Caption         =   "Send All Codes"
      Height          =   495
      Left            =   2520
      Style           =   1  'Graphical
      TabIndex        =   23
      ToolTipText     =   "Send full range of known morse codes"
      Top             =   240
      Width           =   1095
   End
   Begin VB.CommandButton SaveScales 
      BackColor       =   &H0000FFFF&
      Caption         =   "Save TX Scales"
      Height          =   495
      Left            =   1920
      Style           =   1  'Graphical
      TabIndex        =   22
      ToolTipText     =   "Saves transmission rate scales disk for future use when program next run"
      Top             =   1800
      Visible         =   0   'False
      Width           =   975
   End
   Begin VB.CommandButton EditScales 
      BackColor       =   &H00FFFF00&
      Caption         =   "Edit TX Scales"
      Height          =   495
      Left            =   3720
      Style           =   1  'Graphical
      TabIndex        =   21
      ToolTipText     =   "Allows transmission rate scales to be altered"
      Top             =   3600
      Width           =   975
   End
   Begin VB.CommandButton Command3 
      BackColor       =   &H0000FF00&
      Caption         =   "Hide Codes"
      Height          =   615
      Left            =   7320
      Style           =   1  'Graphical
      TabIndex        =   20
      ToolTipText     =   "Hides display of morse codes"
      Top             =   240
      Width           =   975
   End
   Begin VB.CommandButton Command2 
      BackColor       =   &H00FFFF00&
      Caption         =   "Codes - Alpha"
      Height          =   615
      Left            =   4920
      Style           =   1  'Graphical
      TabIndex        =   19
      ToolTipText     =   "Displays known morse codes in alphanumeric order"
      Top             =   240
      Width           =   975
   End
   Begin VB.CommandButton Command1 
      BackColor       =   &H0000FF00&
      Caption         =   "Codes - Binary"
      Height          =   615
      Left            =   6120
      Style           =   1  'Graphical
      TabIndex        =   18
      ToolTipText     =   "Displays known morse codes in binary value order"
      Top             =   240
      Width           =   975
   End
   Begin VB.CommandButton Paris 
      BackColor       =   &H0000FF00&
      Caption         =   "Send ""PARIS"""
      Height          =   495
      Left            =   1320
      Style           =   1  'Graphical
      TabIndex        =   16
      ToolTipText     =   "Repeatedly sends test word PARIS as morse code"
      Top             =   240
      Width           =   1095
   End
   Begin VB.CommandButton MorseDirectory 
      BackColor       =   &H00FFFF00&
      Caption         =   "Text File Directory"
      Height          =   495
      Index           =   0
      Left            =   120
      Style           =   1  'Graphical
      TabIndex        =   15
      ToolTipText     =   "Accesses directory via which text file for transmission/viewing is made"
      Top             =   3600
      Width           =   975
   End
   Begin VB.CommandButton ReadMorse 
      BackColor       =   &H0000FF00&
      Caption         =   "Read Morse Input"
      Height          =   495
      Left            =   3720
      Style           =   1  'Graphical
      TabIndex        =   14
      ToolTipText     =   "Reads morse code input via BUSY printer port pin"
      Top             =   240
      Width           =   975
   End
   Begin VB.TextBox Text3 
      BackColor       =   &H8000000F&
      Height          =   285
      Left            =   120
      Locked          =   -1  'True
      TabIndex        =   13
      Text            =   "|             41 35  24       17       14     10        8         7         6"
      ToolTipText     =   "Scale for morse transmission rate as set by slider  (VB6 does allow slider itself to have a pop-up description like this!)"
      Top             =   3240
      Width           =   4575
   End
   Begin VB.TextBox Text2 
      BackColor       =   &H8000000F&
      Height          =   285
      Left            =   120
      Locked          =   -1  'True
      TabIndex        =   12
      Text            =   "|     |     |     |     |     |     |     |     |     |     |     |     |     |     |     |     |     |"
      ToolTipText     =   "Scale for morse transmission rate as set by slider  (VB6 does allow slider itself to have a pop-up description like this!)"
      Top             =   2880
      Width           =   4575
   End
   Begin VB.TextBox Text1 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1095
      Left            =   120
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   2
      ToolTipText     =   "Displays text being input or output"
      Top             =   1440
      Width           =   4575
   End
   Begin VB.CommandButton StopIt 
      Caption         =   "Stop TX/RX"
      Height          =   495
      Left            =   3720
      Style           =   1  'Graphical
      TabIndex        =   1
      ToolTipText     =   "Stops transmission/reception of morse code (waits for word space before acting - see EPE text)"
      Top             =   4200
      Width           =   975
   End
   Begin VB.CommandButton Start 
      BackColor       =   &H0000FF00&
      Caption         =   " Send Text File"
      Height          =   495
      Left            =   120
      Style           =   1  'Graphical
      TabIndex        =   0
      ToolTipText     =   "Sends selected text file as morse code to printer port pin DA0"
      Top             =   240
      Width           =   1095
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   1
      Left            =   2880
      Top             =   3960
   End
   Begin VB.ListBox List1 
      Height          =   3765
      Index           =   0
      Left            =   4920
      TabIndex        =   17
      ToolTipText     =   "Displays morse codes"
      Top             =   960
      Visible         =   0   'False
      Width           =   4575
   End
   Begin VB.HScrollBar HScroll1 
      Height          =   255
      LargeChange     =   2
      Left            =   120
      Max             =   40
      Min             =   1
      TabIndex        =   11
      Top             =   2640
      Value           =   6
      Width           =   4575
   End
   Begin VB.Label Label6 
      BackStyle       =   0  'Transparent
      Height          =   375
      Left            =   2640
      TabIndex        =   45
      ToolTipText     =   "Of course you know what this says!"
      Top             =   960
      Width           =   2055
   End
   Begin VB.Shape Shape6 
      BorderColor     =   &H00800000&
      BorderWidth     =   2
      Height          =   735
      Left            =   6720
      Shape           =   4  'Rounded Rectangle
      Top             =   4800
      Width           =   1335
   End
   Begin VB.Label Label8 
      Alignment       =   2  'Center
      Caption         =   "Rate = 4700"
      Height          =   210
      Left            =   6840
      TabIndex        =   44
      ToolTipText     =   "Timing calculation value used in transmission (see EPE text)"
      Top             =   5280
      Width           =   1095
   End
   Begin VB.Shape Shape4 
      BackColor       =   &H000000FF&
      BorderColor     =   &H00FFFFFF&
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   4
      Left            =   4080
      Top             =   1080
      Width           =   135
   End
   Begin VB.Shape Shape4 
      BackColor       =   &H000000FF&
      BorderColor     =   &H00FFFFFF&
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   3
      Left            =   3720
      Top             =   1080
      Width           =   255
   End
   Begin VB.Shape Shape4 
      BackColor       =   &H000000FF&
      BorderColor     =   &H00FFFFFF&
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   2
      Left            =   3360
      Top             =   1080
      Width           =   255
   End
   Begin VB.Shape Shape4 
      BackColor       =   &H000000FF&
      BorderColor     =   &H00FFFFFF&
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   1
      Left            =   3120
      Top             =   1080
      Width           =   135
   End
   Begin VB.Shape Shape4 
      BackColor       =   &H000000FF&
      BorderColor     =   &H00FFFFFF&
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   0
      Left            =   2760
      Top             =   1080
      Width           =   135
   End
   Begin VB.Label Label5 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Caption         =   "Hover mouse cursor over buttons/labels for functional description"
      Height          =   255
      Left            =   120
      TabIndex        =   42
      ToolTipText     =   "Just as you are doing now!"
      Top             =   5400
      Width           =   4695
   End
   Begin VB.Label Label4 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "Active"
      Height          =   195
      Left            =   3720
      TabIndex        =   39
      Top             =   720
      Visible         =   0   'False
      Width           =   975
   End
   Begin VB.Label Label7 
      Alignment       =   2  'Center
      BackColor       =   &H000000FF&
      Caption         =   "TX"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   215
      Left            =   1320
      TabIndex        =   38
      ToolTipText     =   "Program now in transmission mode"
      Top             =   3720
      Visible         =   0   'False
      Width           =   375
   End
   Begin VB.Label Label3 
      BackColor       =   &H00FFFF00&
      Caption         =   "Label3"
      Height          =   255
      Left            =   4920
      TabIndex        =   37
      ToolTipText     =   "The numbers represent the date & time "
      Top             =   0
      Visible         =   0   'False
      Width           =   4575
   End
   Begin VB.Label Label14 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "Click ""Stop"" first"
      Height          =   255
      Left            =   120
      TabIndex        =   35
      Top             =   0
      Visible         =   0   'False
      Width           =   4575
   End
   Begin VB.Label Label13 
      BackColor       =   &H0000FFFF&
      Caption         =   "Double-click on file name for full Path details"
      Height          =   255
      Left            =   120
      TabIndex        =   34
      ToolTipText     =   "Do as it says!"
      Top             =   5160
      Width           =   3135
   End
   Begin VB.Shape Shape3 
      BorderColor     =   &H00800000&
      BorderWidth     =   2
      Height          =   735
      Left            =   8160
      Shape           =   4  'Rounded Rectangle
      Top             =   4800
      Width           =   1335
   End
   Begin VB.Label Label12 
      Alignment       =   2  'Center
      Caption         =   "Drive"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   8520
      TabIndex        =   33
      ToolTipText     =   "Allows selection of drive used as default (see Notes via Text File Directory button)  "
      Top             =   4800
      Width           =   735
   End
   Begin VB.Shape Shape2 
      BorderColor     =   &H00800000&
      BorderWidth     =   2
      Height          =   735
      Left            =   4920
      Shape           =   4  'Rounded Rectangle
      Top             =   4800
      Width           =   1695
   End
   Begin VB.Label Label11 
      Caption         =   "Port"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   5160
      TabIndex        =   31
      ToolTipText     =   "Allows correct printer port register to be selected (see EPE text)"
      Top             =   4900
      Width           =   495
   End
   Begin VB.Label Label10 
      BackColor       =   &H0000FFFF&
      Caption         =   "Selected file ="
      Height          =   255
      Left            =   120
      TabIndex        =   26
      ToolTipText     =   "Name of selected text file"
      Top             =   4920
      Width           =   1035
   End
   Begin VB.Label Label9 
      Caption         =   "Label9"
      Height          =   255
      Left            =   1200
      TabIndex        =   25
      ToolTipText     =   "Name of selected text file"
      Top             =   4920
      Width           =   2415
   End
   Begin VB.Shape Shape1 
      BorderColor     =   &H00800000&
      BorderWidth     =   2
      Height          =   1215
      Left            =   1200
      Shape           =   4  'Rounded Rectangle
      Top             =   3600
      Width           =   2295
   End
   Begin VB.Label Label2 
      Caption         =   "-"
      Height          =   255
      Index           =   3
      Left            =   2640
      TabIndex        =   10
      ToolTipText     =   "Total ""words"" transmitted since starting transmission (see EPE text)"
      Top             =   4440
      Width           =   735
   End
   Begin VB.Label Label2 
      Caption         =   "-"
      Height          =   255
      Index           =   2
      Left            =   2640
      TabIndex        =   9
      ToolTipText     =   "Time at which last word count was updated (on a 1-minute basis)"
      Top             =   3960
      Width           =   735
   End
   Begin VB.Label Label2 
      Caption         =   "-"
      Height          =   255
      Index           =   1
      Left            =   2640
      TabIndex        =   8
      ToolTipText     =   "Number of ""words"" transmitted relative to Dits and Dahs sent per minute (see EPE text)"
      Top             =   4200
      Width           =   735
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Total words"
      Height          =   255
      Index           =   3
      Left            =   1320
      TabIndex        =   7
      ToolTipText     =   "Total ""words"" transmitted since starting transmission (see EPE text)"
      Top             =   4440
      Width           =   1215
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Last WPM Time"
      Height          =   255
      Index           =   2
      Left            =   1320
      TabIndex        =   6
      ToolTipText     =   "Time at which last word count was updated (on a 1-minute basis)"
      Top             =   3960
      Width           =   1215
   End
   Begin VB.Label Label1 
      Caption         =   "Words per minute"
      Height          =   255
      Index           =   1
      Left            =   1320
      TabIndex        =   5
      ToolTipText     =   "Number of ""words"" transmitted relative to Dits and Dahs sent per minute (see EPE text)"
      Top             =   4200
      Width           =   1335
   End
   Begin VB.Label Label2 
      Caption         =   "-"
      Height          =   255
      Index           =   0
      Left            =   2640
      TabIndex        =   4
      ToolTipText     =   "Time at which transmission started"
      Top             =   3720
      Width           =   735
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Started"
      Height          =   255
      Index           =   0
      Left            =   2040
      TabIndex        =   3
      ToolTipText     =   "Time at which transmission started"
      Top             =   3720
      Width           =   495
   End
   Begin VB.Shape Shape5 
      BorderColor     =   &H00800000&
      BorderWidth     =   2
      FillColor       =   &H00FFFFFF&
      Height          =   375
      Left            =   2640
      Shape           =   4  'Rounded Rectangle
      Top             =   960
      Width           =   2055
   End
   Begin VB.Shape Shape4 
      BackColor       =   &H000000FF&
      BorderColor     =   &H00FFFFFF&
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   5
      Left            =   4440
      Top             =   1080
      Width           =   135
   End
End
Attribute VB_Name = "Morse"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'MORSE TRANSMIT 02SEP01

Private Sub Form_Load()
OpenFile = "An unknown problem exists right at the start of loading Morse.EXE"
On Error GoTo FatalError: 'set error handler

newuser = 0:
ErrorMessage$ = "This error has been intercepted by the PC System, not by the Morse program."
ErrorMessage$ = ErrorMessage$ & "If the problem persists please report its details and circumstances of it occurring to John Becker at EPE"
defaulterror$ = ErrorMessage$
tempa$ = "No File Selected Yet"
InputFile(0) = tempa$: NamedFile(0) = tempa$: InputSize(0) = 0

OpenFile = "File MorseCode.txt cannot be found, or its data is corrupted"
Open "morsecode.txt" For Input As #1: Close

Port1 = 888: Port2 = 889: Port3 = 890: DefaultDrive = "C:\": CLK = 4700
DirComboText = "C:\"
PicPath = 0: PrevPicPath = 1

OpenFile = "INPOUT32.DLL not found"
Out Port1, 0

On Error GoTo ScalesError
OpenFile = "Cannot find MorseScales.txt"
Open "MorseScales.txt" For Input As #1: Close

On Error GoTo SettingsError
OpenFile = "Cannot find MorseSettings.txt"
Open "MorseSettings.txt" For Input As #1: Close

On Error GoTo HistoryError
OpenFile = "Cannot find MorseHistory.txt"
Open "MorseHistory.txt" For Input As #1: Close

On Error GoTo showerror: 'set error handler
OpenFile = "Unknown error"

Open "MorseScales.txt" For Input As #1
Line Input #1, AA$: Text2.Text = Mid$(AA$, 2)
Line Input #1, AA$: Text3.Text = Mid$(AA$, 2)
Close

GetCodes2:
List1(0).AddItem "Binary representation: 0 = DIT,  1 = DAH"
List1(0).AddItem "Char" & Chr(9) & "Binary" & Chr(9) & "Bits   Binary Value"
List1(1).AddItem "   Binary representation: 0 = DIT,  1 = DAH"
List1(1).AddItem "   Char" & Chr(9) & "Binary" & Chr(9) & "Bits   Binary Value"

Open "morsecode.txt" For Input As #1
getit: If EOF(1) = 0 Then
 Line Input #1, AA$: BA$ = LTrim$(AA$)
 If Left$(BA$, 1) <> "*" And Left$(BA$, 1) <> "#" Then
 A = Asc(BA$)
 For C = 1 To Len(BA$)
  If Mid$(BA$, C, 1) = Chr(9) Or Mid$(BA$, C, 1) = " " Then
  BA$ = Mid$(BA$, C + 1): Exit For
  End If
Next

For C = 1 To 10
 If Mid$(BA$, C, 1) = Chr(9) Or Mid$(BA$, C, 1) = " " Then
 BA$ = Left$(BA$, C - 1): MorseCode$(A) = LTrim$(BA$): Exit For
 End If
 Next
End If

If Left$(AA$, 1) = "#" Then AA$ = " " & Mid$(AA$, 2)
List1(0).AddItem AA$

If Left$(AA$, 1) <> "*" Then AA$ = " " & AA$
If Right$(AA$, 1) = Chr(34) Then AA$ = "*" & AA$
List1(1).AddItem AA$
GoTo getit
Else
Close
End If

Open "MorseSettings.txt" For Input As #1
Line Input #1, tempa$:
Port1 = Val(tempa$): Port2 = Port1 + 1: Port3 = Port1 + 2
Line Input #1, tempa$: DriveC$ = tempa$:
Line Input #1, tempa$: CLK = Val(tempa$)
Line Input #1, tempa$: DirComboText = tempa$
Line Input #1, tempa$: InputFile(0) = tempa$
Line Input #1, tempa$: NamedFile(0) = tempa$
Close: Out Port1, 0
 
Label9.Caption = NamedFile(0)

Label8.Caption = "Rate = " & CLK
DefaultDrive = DriveC$: Drive1 = DriveC$

If Port1 = 888 Then Option1(0).Value = True
If Port1 = 632 Then Option1(1).Value = True
If Port1 = 956 Then Option1(2).Value = True


If UCase$(Left$(DriveC$, 3)) <> DefaultDrive Then DriveC$ = DefaultDrive

OpenFile = "Cannot correctly access Morse Directory Default Drive path  " & DefaultDrive

MorseDir.Drive1.Drive = DefaultDrive
OpenFile = "Cannot correctly access Morse Directory (Drive C$) path  " & DriveC$
MorseDir.Dir1.Path = DriveC$

HistoryQ = 0:
OpenFile = "Cannot find MorseHistory.txt file, or its data is corrupted"
Open "MorseHistory.txt" For Input As #1
getit3: If EOF(1) = 0 Then
  Line Input #1, tempa$
  If tempa$ <> "" And tempa$ <> History(HistoryQ) Then
  HistoryQ = HistoryQ + 1: History(HistoryQ) = tempa$
  MorseDir.Combo1.AddItem tempa$
  End If
GoTo getit3
End If
MorseDir.Combo1.Text = DirComboText: 'tempa$
MorseDirPath(0) = DirComboText
Close

On Error GoTo NewUserError: 'set error handler used to check if prog has been run before
Open "ClearMorse.txt" For Input As #1: Close

On Error GoTo showerror
HScroll1.Value = 12: CA = 0: Call HScroll1_Change

MidBlue = &HFFFF00
MidYellow = &HFFFF&
MidGreen = &HFF00&
MidGrey = &H8000000F

MorseA$(1) = "ET"
MorseA$(2) = "IANM"
MorseA$(3) = "SURWDKGO"
MorseA$(4) = "HVFULAPJBXCYZQOC"
MorseA$(5) = "54**E**2**+**A*16=/***(*7**N8*90"
MorseA$(6) = "******3*****?!****'**.********'**-***********)*****,****;*******"

Dit = 100000: Dah = Dit * 2: LetterSpace2 = Dit * 2: WordSpace2 = Dit * 7: ' dah 3

For A = 1 To 6: MorseA$(A) = LCase$(MorseA$(A)): For C = 1 To Len(MorseA$(A))
Code$(A, C - 1) = Mid$(MorseA$(A), C, 1): Next: Next: Code$(6, 18) = Chr$(34)
OpenFile = ""
Exit Sub

'.............

NewUserError:
Close: Open "ClearMorse.txt" For Output As #2
Print #2, "Morse first loaded " & Date$ & " " & Time$: Close
DriveC$ = "C:\": newuser = 1: Call SetClk: Call SaveDefaults
Close: Open "MorseScales.txt" For Output As #2
Print #2, "." & Text2.Text: Print #2, "." & Text3.Text: Close
Close: Open "MorseHistory.txt" For Output As #2: Print #2, "C:\": Close
MorseDir.Combo1.Text = DirComboText: MorseDirPath(0) = DirComboText
Resume Next

ScalesError:
Close: Open "MorseScales.txt" For Output As #2
Print #2, "." & Text2.Text: Print #2, "." & Text3.Text: Close
Resume Next

SettingsError:
Close: Call SaveDefaults
Resume Next

HistoryError:
Close: Open "MorseHistory.txt" For Output As #2: Print #2, "C:\": Close
MorseDir.Combo1.Text = DirComboText: MorseDirPath(0) = DirComboText
Resume Next

showerror:
Close: Morse.Hide: Call MorseShowError.waitresponse
Resume enderror
enderror:
Exit Sub

FatalError:
Beep
tempB$ = "A non-recoverable error has occurred during program loading and involves the following Morse-generated statement:"
tempB$ = tempB$ & Chr(13) & Chr(13) & OpenFile
tempB$ = tempB$ & Chr(13) & Chr(13) & "Please check that all the Morse files are in the same folder (directory) as the program you are now trying to run. The folder must be on the Hard Drive."
tempB$ = tempB$ & Chr(13) & Chr(13) & "If the data is corrupted re-copy the file of the same name from your original disk or FTP download."
tempB$ = tempB$ & Chr(13) & Chr(13) & "If you cannot resolve the problem please advise John Becker of the details via the EPE Editorial Office (not via the Chat Zone)."
tempB$ = tempB$ & Chr(13) & Chr(13) & "The loading has been aborted and you will be returned to the previous screen."
MsgBox tempB$, vbCritical
End

End Sub

Private Sub Start_Click()
StopIt.SetFocus
If Mode <> 0 Then Beep: Label14.Visible = True: Exit Sub
On Error GoTo showerror

Mode = 1: Close: fname = InputFile(PicPath)
If fname = "No File Selected Yet" Then
Beep
MsgBox fname, vbExclamation: MorseDirectory(0).SetFocus: Exit Sub
End If
Call SetZeroTime: Start.BackColor = &HFFFF00: Open fname For Input As #1
Timer1.Enabled = True
Exit Sub

showerror:
MorseShowError.Show
Call MorseShowError.waitresponse
Resume enderror
enderror:
Close

End Sub

Public Sub SendText()
B = Asc(Mid$(AA$, CA, 1))
If MorseCode$(B) <> "" Then
Call Sendit: If Mid$(Time$, 4, 2) <> T$ Then Call ShowTime
Else: Call SendWordSpace
End If
CA = CA + 1
End Sub

Private Sub Paris_Click()
StopIt.SetFocus
If Mode <> 0 Then Beep: Label14.Visible = True: Exit Sub
Mode = 3: Call SetZeroTime: Paris.BackColor = &HFFFF00
CA = 1: AA$ = "PARIS ": Text1.Text = AA$: Timer1.Enabled = True
End Sub

Private Sub SendParis()
ParisSend: Text1.Text = Text1.Text & "PARIS "
For CA = 1 To 5: B = Asc(Mid$(AA$, CA, 1)): Call Sendit: Next CA
Call SendWordSpace
If Mid$(Time$, 4, 2) <> T$ Then Call ShowTime: Text1.Text = "PARIS "
End Sub

Private Sub SendAll_Click()
StopIt.SetFocus
If Mode <> 0 Then Beep: Label14.Visible = True: Exit Sub
Mode = 4: Call SetZeroTime: SendAll.BackColor = &HFFFF00
Label7.Visible = True: Text1.Text = ""
If List1(1).Visible = True Then Z = 1 Else Z = 0: List1(0).Visible = True: Call Command1_Click
List1(Z).ListIndex = 2: Timer1.Enabled = True
End Sub

Private Sub SendAllCodes()
On Error GoTo showerror

SendAll: AA$ = List1(Z).Text
If AA$ = "" Or Left$(AA$, 1) = "*" Then
List1(Z).ListIndex = List1(Z).ListIndex + 1: GoTo SendAll
End If
AA$ = Left$(LTrim$(AA$), 1): Text1.Text = Text1.Text & AA$: Text1.Refresh
B = Asc(AA$): Call Sendit
List1(Z).ListIndex = List1(Z).ListIndex + 1: Label14.Visible = False
If Mid$(Time$, 4, 2) <> T$ Then Call ShowTime
Exit Sub

showerror:
If Err.Number = 380 Then Text1.Text = "": List1(Z).ListIndex = 2: Resume SendAll

Timer1.Enabled = False
MorseShowError.Show: Call MorseShowError.waitresponse
Resume enderror
enderror:
MorseDir.Hide
Exit Sub

End Sub

Private Sub ReadMorse_Click()
StopIt.SetFocus
If Mode <> 0 Then Beep: Label14.Visible = True:  Exit Sub
Mode = 2
T$ = Time$: AA$ = Date$: T$ = Left$(T$, 2) & Mid$(T$, 4, 2) & Right$(T$, 2)
AA$ = Mid$(AA$, 4, 2) & Left$(AA$, 2) & Right$(AA$, 2)
Close: Open "Morse" & AA$ & T$ & ".txt" For Output As #2
Print #2, "Morse code received, starting " & Time$ & " " & Date$
Label3.Caption = "Saving input to Morse folder as file:  " & "Morse" & AA$ & T$ & ".txt"
Label3.Visible = True
Call GreyButtons: ReadMorse.BackColor = &HFFFF00

Label2(0).Caption = Time$: 'Start time
Label2(1).Caption = "Not read": 'Words per minute
Label2(2).Caption = "Not read": 'Last WPM time
Label2(3).Caption = "Not read": 'Total words
Label7.Visible = True

Text1.Text = "": CountA = 0: CountB = 0: Dit = 100000: Prev = 0: Morsecnt = 0
Highcnt = 0: Morse0 = 0: Timer1.Enabled = True: AA$ = "": BA$ = ""
End Sub

Private Sub GETMORSE()

getmorsebit:
StorA = Inp(Port2) And 64
If StorA = 64 Then
If Highcnt > 1000000 Then
Beep
Timer1.Enabled = False
Print #2, "Receiving terminated as no response from Morse unit"
Print #2, "": Print #2, "Recording ended " & Time$ & " " & Date$
MsgBox "Receiving terminated - no response from Morse unit", vbExclamation
Close: Mode = 0: Call StopIt_Click
Exit Sub
End If
Highcnt = Highcnt + 1: GoTo endmorse
End If

If StorA = Prev Then GoTo DITY
If Highcnt >= Dah Then B = 1 Else B = 0
Morse0 = ((Morse0 * 2) Or B) And 255: Morsecnt = Morsecnt + 1: CountB = CountB + 1
If CountB = 16 Then
Dah = Dit * 2: LetterSpace2 = Dah: 'WordSpace2 = Dah * 2.: Dit = 100000: CountB = 0
WordSpace2 = Dit * 7: Dit = 100000: CountB = 0
End If
Low0 = 0: If Highcnt < Dit Then Dit = Highcnt
Highcnt = 0

DITY:
Low0 = Low0 + 1: If Low0 <> LetterSpace2 Then GoTo LO3
'If Morsecnt < 9 Then
If Morsecnt < 9 Then CB$ = Code$(Morsecnt, Morse0) Else CB$ = "###"
If CB$ = "" Then CB$ = "**"
'AA$ = AA$ & Code$(Morsecnt, Morse0): BA$ = BA$ & Code$(Morsecnt, Morse0)
AA$ = AA$ & CB$: BA$ = BA$ & CB$
'Print #2, Code$(Morsecnt, Morse0);: Text1.Text = BA$: Text1.Refresh
Print #2, CB$;: Text1.Text = BA$: Text1.Refresh
'End If
Morsecnt = 0: Morse0 = 0: GoTo endmorse

LO3:
If Low0 = WordSpace2 Then
Label14.Visible = False: AA$ = AA$ & " ": BA$ = BA$ & " "
Print #2, " ";: Morsecnt = 0: Prev = StorA: Exit Sub
End If

endmorse: Prev = StorA: GoTo getmorsebit

'..........

UNDERSTOOD:
WAITMSG:
STARTING:
ENDWORK:

End Sub

Private Sub SaveScales_Click()
StopIt.SetFocus
If Mode <> 0 Then Beep: Label14.Visible = True:  Exit Sub

Text2.Locked = True: Text3.Locked = True
Text2.BackColor = &H8000000F: Text3.BackColor = &H8000000F
SaveScales.Visible = False
Open "MorseScales.txt" For Output As #2
Print #2, "." & Text2.Text: Print #2, "." & Text3.Text
Close: Beep
Command2.Visible = True: Command1.Visible = False
MsgBox "Scales saved OK", vbExclamation

End Sub

Private Sub StopIt_Click()
ReadMorse.BackColor = MidGreen: Start.BackColor = MidGreen
Paris.BackColor = MidGreen: SendAll.BackColor = MidGreen
TextKey.BackColor = MidGreen: MorseKey.BackColor = MidGreen
MorseKey.BackColor = MidGreen: SetRate.BackColor = MidGreen
MorseDirectory(0).BackColor = MidBlue: ViewText.BackColor = MidBlue
EditScales.BackColor = MidBlue: StopIt.BackColor = MidGrey
Label3.Visible = False: Label14.Visible = False
Label7.Visible = False: Timer1.Enabled = False
If Mode = 2 Then Print #2, "": Print #2, "Recording ended " & Time$ & " " & Date$
AA$ = "": Close: CA = 0: Out Port1, 0: Mode = 0
End Sub

Private Sub Text2_click()
If Mode <> 0 And Mode <> 5 Then Beep: Label14.Visible = True: StopIt.SetFocus: Exit Sub
Call EditScales_Click
End Sub

Private Sub Text3_click()
If Mode <> 0 And Mode <> 5 Then Beep: Label14.Visible = True: StopIt.SetFocus: Exit Sub
Call EditScales_Click
End Sub

Private Sub TextKey_Click()
If Mode <> 0 Then Beep: StopIt.SetFocus: Label14.Visible = True: Exit Sub
Mode = 5: Text1.Text = "": Text1.Locked = False: Text1.SetFocus
Call SetZeroTime: TextKey.BackColor = &HFFFF00
End Sub

Private Sub Timer1_Timer()

If Mode = 3 Then Call SendParis: Exit Sub

If Mode = 2 Then
If Len(AA$) > 50 Then Text1.Text = AA$: BA$ = AA$: AA$ = "":
Call GETMORSE: Exit Sub
End If

If Mode = 4 Then Call SendAllCodes: Exit Sub

If CA = 0 Then
If EOF(1) Then
Close: Timer1.Enabled = False: Call StopIt_Click
Beep
MsgBox "Transmission ended", vbExclamation: Exit Sub
End If
Line Input #1, AA$: Text1.Text = AA$: AA$ = UCase$(AA$) & " ": CA = 1
End If

Call SendText: If CA >= Len(AA$) Then CA = 0
End Sub

Private Sub HScroll1_Change()
V = HScroll1.Value: Dot(0) = (CLK * V): Dot(1) = Dot(0) * 3: Space = Dot(0)
LetterSpace = Dot(0) * 3: WordSpace = Dot(0) * 4: ' assumes letterspace sent, to make up 7 dots worth
End Sub

Private Sub MorseDirectory_Click(Index As Integer)
StopIt.SetFocus
If Mode <> 0 Then Beep: Label14.Visible = True:  Exit Sub
On Error GoTo showerror

Timer1.Enabled = False: PicPath = Index: FileName = "*.TXT":
If MorseDir.Combo1.ListCount = 0 Then
MorseDir.Combo1.Clear
For A = 1 To HistoryQ: MorseDir.Combo1.AddItem History(A): Next
MorseDir.Combo1.Text = DirComboText
End If

If MorseDirPath(PicPath) = "" Then MorseDirPath(PicPath) = DefaultDrive
OpenFile = MorseDirPath(PicPath)

MorseDir.Show
If PicPath <> PrevPicPath Then
If MorseDirPath(PicPath) <> DefaultDrive Then MorseDir.Dir1.Path = MorseDirPath(PicPath)
MorseDir.Label1.Caption = "": Call MorseDir.dirshow
PrevPicPath = PicPath: FilePath = InputFile(PicPath)
End If
Exit Sub

showerror:
If Err.Number = 68 Or Err.Number = 71 Or Err.Number = 76 Then
ErrorMessage = "Drive not ready for" & Chr(13) & OpenFile
Style = vbRetryCancel + vbExclamation
response = MsgBox(ErrorMessage, Style)
  If response = vbCancel Then
  MorseDirPath(PicPath) = DefaultDrive
  OpenFile = MorseDirPath(PicPath)
  Resume here
here:   Exit Sub
  End If

Resume
  Beep
  End If

MorseShowError.Show
Call MorseShowError.waitresponse
Resume enderror
enderror:
MorseDir.Hide

End Sub

Private Sub AllFilesDir_Click()
MorseDir.Show
End Sub

Private Sub Command1_Click()
Command1.BackColor = MidBlue: Command2.BackColor = MidGreen
List1(0).Visible = True: Z = 0: List1(1).Visible = False
If Mode = 4 Then List1(0).ListIndex = 2: Text1.Text = ""
End Sub

Private Sub Command2_Click()
Command2.BackColor = MidBlue: Command1.BackColor = MidGreen
List1(1).Visible = True: Z = 1: List1(0).Visible = False
If Mode = 4 Then List1(1).ListIndex = 2: Text1.Text = ""
End Sub

Private Sub Command3_Click()
StopIt.SetFocus
If Mode <> 0 Then Beep: Label14.Visible = True:  Exit Sub
Command1.BackColor = MidGreen: Command2.BackColor = MidGreen
List1(0).Visible = False: List1(1).Visible = False
End Sub

Private Sub Directory_Click()
MorseDir.Show
End Sub

Private Sub EditScales_Click()
If Mode <> 0 Then Beep: Label14.Visible = True: StopIt.SetFocus: Exit Sub
Text2.Locked = False: Text3.Locked = False
Text2.BackColor = vbWhite: Text3.BackColor = vbWhite
SaveScales.Visible = True: Text2.BorderStyle = 1: Text3.BorderStyle = 1
End Sub

Private Sub ViewText_Click()
StopIt.SetFocus
If Mode <> 0 Then Beep: Label14.Visible = True:  Exit Sub
On Error GoTo showerror
  fname = InputFile(PicPath)
If fname = "No File Selected Yet" Then
Beep
MsgBox fname, vbExclamation: MorseDirectory(0).SetFocus
Exit Sub
End If

OpenFile = fname: Open fname For Input As #1: Close
processid = Shell("Notepad " & fname, vbNormalFocus): OpenFile = ""
Exit Sub

showerror:
MorseShowError.Show
Call MorseShowError.waitresponse
Resume enderror
enderror:
Close

End Sub

Private Sub Option1_Click(Index As Integer)
If Index = 0 Then Port1 = 888: Port2 = 889: Port3 = 890: ' 0378h
If Index = 1 Then Port1 = 632: Port2 = 633: Port3 = 634: ' 0278H
If Index = 2 Then Port1 = 956: Port2 = 957: Port3 = 958: ' 03BCh
Call SaveDefaults
End Sub

Private Sub Drive1_Change()
StopIt.SetFocus
If Mode <> 0 Then Beep: Label14.Visible = True:  Exit Sub

PicPath = 0: FileName = "*.TXT":
DefaultDrive = UCase$(Drive1.Drive) & "\"
DriveC$ = DefaultDrive
MorseDir.Combo1.AddItem DriveC$
MorseDir.Drive1.Drive = Drive1.Drive
MorseDir.Dir1.Path = DriveC$
PrevPicPath = 0
Call SaveDefaults
PicPath = 0: FileName = DriveC$ & "*.TXT":
MorseDir.Show
Call MorseDir.dirshow
Label9.Caption = NamedFile(PicPath)
End Sub

Public Sub SaveDefaults()
Close: Open "MorseSettings.txt" For Output As #2
If Len(DriveC$) <> 3 Then DriveC$ = "C:\"
Print #2, Str$(Port1): Print #2, DriveC$: Print #2, CLK
Print #2, MorseDir.Combo1.Text
Print #2, InputFile(0): Print #2, NamedFile(0)
Close
End Sub

Private Sub SetClk()
CLK = 0: T = Int(Timer)
timinga: tm = Int(Timer): If tm = T Then GoTo timinga Else T = tm
timingb: CLK = CLK + 1: tm = Int(Timer): If tm = T Then GoTo timingb
CLK = CLK \ 200: Label8.Caption = "Rate = " & CLK
V = HScroll1.Value: Dot(0) = (CLK * V): Dot(1) = Dot(0) * 3: Space = Dot(0)
LetterSpace = Dot(0) * 3: WordSpace = Dot(0) * 4: ' assumes letterspace sent, to make up 7 dots worth
End Sub

Private Sub Label9_dblClick()
Beep
MsgBox "Full path name =" & Chr(13) & Chr(13) & InputFile(0) & "    ", vbInformation
End Sub

Private Sub MorseKey_Click()
If Mode <> 0 Then Beep: StopIt.SetFocus: Label14.Visible = True: Exit Sub
Mode = 6: Text1.Text = "": Text1.Locked = False: Text1.SetFocus
Call SetZeroTime: MorseKey.BackColor = &HFFFF00
End Sub

Private Sub text1_click()
If Mode < 5 Then StopIt.SetFocus: Exit Sub
End Sub

Private Sub Text1_KeyUp(keycode As Integer, shift As Integer)
If Mode = 6 Then Out Port1, 0
End Sub

Private Sub Text1_KeyPress(KeyAscii As Integer)
If Mode < 5 Then StopIt.SetFocus: Exit Sub
If Mode = 6 Then Out Port1, 1: Text1.Text = "": Exit Sub
B = Asc(UCase$(Chr(KeyAscii)))
If MorseCode$(B) <> "" Then Call Sendit: ' SendAlpha
If B = 32 Or B = 13 Then
Call SendWordSpace
If B = 13 Then Text1.Text = ""
End If
If Mid$(Time$, 4, 2) <> T$ Then Call ShowTime
End Sub

Private Sub SendAlpha():
Call Sendit: If Mode = 4 Then List1(Z).ListIndex = List1(Z).ListIndex + 1
If Mid$(Time$, 4, 2) <> T$ Then Call ShowTime
End Sub

Private Sub SetRate_Click()
If Mode <> 0 Then Beep: StopIt.SetFocus: Label14.Visible = True: Exit Sub
Call SetClk: Call SaveDefaults: Beep
MsgBox "Timing rate adjusted", vbExclamation
End Sub

Private Sub GreyButtons()
Start.BackColor = MidGrey
Paris.BackColor = MidGrey
SendAll.BackColor = MidGrey
ReadMorse.BackColor = MidGrey
TextKey.BackColor = MidGrey
MorseKey.BackColor = MidGrey
MorseDirectory(0).BackColor = MidGrey
ViewText.BackColor = MidGrey
SetRate.BackColor = MidGrey
EditScales.BackColor = MidGrey
StopIt.BackColor = MidYellow
OpenFile = ""
End Sub

Private Sub Sendit()
For D = 1 To Len(MorseCode$(B)): V = Val(Mid$(MorseCode$(B), D, 1))
Out Port1, 1: E = Dot(V)
DotDelay: TA = Int(Timer): If E > 0 Then E = E - 1: GoTo DotDelay: ' send Dit or Dah
Out Port1, 0: E = Space
SpaceDelay: TA = Int(Timer): If E > 0 Then E = E - 1: GoTo SpaceDelay: ' send DIT space
Next D
Out Port1, 0: E = LetterSpace
LetterDelay: TA = Int(Timer): If E > 0 Then E = E - 1: GoTo LetterDelay: ' send pause between letters
CountA = CountA + 0.2
End Sub

Private Sub ShowTime()
WordTotal = WordTotal + CountA
Label2(1).Caption = CInt(CountA): 'Words per minute
Label2(2).Caption = Time$: 'Last WPM time
Label2(3).Caption = Int(WordTotal): 'Total words
CountA = 0: T$ = Mid$(Time$, 4, 2)
End Sub

Private Sub SendWordSpace()
Out Port1, 0: E = WordSpace
WordDelay: TA = Int(Timer): If E > 0 Then E = E - 1: GoTo WordDelay: ' send pause between words
Label14.Visible = False
End Sub

Private Sub SetZeroTime()
T$ = Time$: Close
Label2(0).Caption = T$: 'Start time
Label2(1).Caption = "0": 'Words per minute
Label2(2).Caption = T$: 'Last WPM time
Label2(3).Caption = "0": 'Total words
Label7.Visible = True
CountA = 0: WordTotal = 0: Call GreyButtons: T$ = Mid$(T$, 4, 2)
End Sub

Private Sub Quit_Click()
Close: Out Port1, 0: End
End Sub

