VERSION 5.00
Object = "{86CF1D34-0C5F-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCT2.OCX"
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Begin VB.Form frmLogicAnalyser 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Logic Analyser"
   ClientHeight    =   6225
   ClientLeft      =   8535
   ClientTop       =   2280
   ClientWidth     =   2760
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   HelpContextID   =   300
   Icon            =   "frmLogicAnalyser.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MDIChild        =   -1  'True
   MinButton       =   0   'False
   ScaleHeight     =   6225
   ScaleWidth      =   2760
   Begin VB.Timer tmrTimeOut 
      Enabled         =   0   'False
      Interval        =   10000
      Left            =   1950
      Top             =   6030
   End
   Begin VB.OptionButton optOption 
      Caption         =   "Free running"
      Height          =   195
      HelpContextID   =   300
      Index           =   1
      Left            =   105
      TabIndex        =   50
      ToolTipText     =   "Free running data grabbing"
      Top             =   2670
      Width           =   1230
   End
   Begin VB.Frame Frame3 
      Height          =   825
      Left            =   30
      TabIndex        =   64
      Top             =   2640
      Width           =   2670
      Begin VB.TextBox txtField 
         Alignment       =   1  'Right Justify
         Height          =   300
         HelpContextID   =   300
         Index           =   0
         Left            =   1110
         MaxLength       =   4
         TabIndex        =   51
         Text            =   "0"
         Top             =   300
         Width           =   510
      End
      Begin MSComCtl2.UpDown UpDown1 
         Height          =   300
         HelpContextID   =   300
         Left            =   1620
         TabIndex        =   52
         ToolTipText     =   "Change wait delay between bit pattern capture"
         Top             =   300
         Width           =   240
         _ExtentX        =   423
         _ExtentY        =   529
         _Version        =   393216
         BuddyControl    =   "txtField(0)"
         BuddyDispid     =   196612
         BuddyIndex      =   0
         OrigLeft        =   1605
         OrigTop         =   300
         OrigRight       =   1845
         OrigBottom      =   600
         Max             =   32000
         SyncBuddy       =   -1  'True
         BuddyProperty   =   65547
         Enabled         =   -1  'True
      End
      Begin VB.Label Label4 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "ms"
         Height          =   195
         Left            =   1875
         TabIndex        =   66
         Top             =   390
         Width           =   195
      End
      Begin VB.Label Label2 
         BackStyle       =   0  'Transparent
         Caption         =   "Sample Delay:"
         Height          =   195
         Left            =   75
         TabIndex        =   65
         Top             =   315
         Width           =   1050
      End
   End
   Begin VB.CheckBox chkOption 
      Caption         =   "Activate Device Pull-Ups"
      Height          =   195
      HelpContextID   =   300
      Index           =   4
      Left            =   75
      TabIndex        =   56
      ToolTipText     =   "Active the pull up resistors of the tester"
      Top             =   4650
      Width           =   2070
   End
   Begin VB.Frame Frame1 
      Caption         =   "Monitor Pins:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1050
      Index           =   1
      Left            =   0
      TabIndex        =   63
      ToolTipText     =   "Select which pins data should be captured for"
      Top             =   0
      Width           =   2700
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   225
         HelpContextID   =   300
         Index           =   24
         Left            =   135
         TabIndex        =   0
         Top             =   300
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   22
         Left            =   555
         TabIndex        =   2
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   20
         Left            =   975
         TabIndex        =   4
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   2
         Left            =   345
         TabIndex        =   13
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   23
         Left            =   345
         TabIndex        =   1
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   21
         Left            =   765
         TabIndex        =   3
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   1
         Left            =   135
         TabIndex        =   12
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   3
         Left            =   555
         TabIndex        =   14
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   19
         Left            =   1185
         TabIndex        =   5
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   18
         Left            =   1395
         TabIndex        =   6
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   4
         Left            =   765
         TabIndex        =   15
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   5
         Left            =   975
         TabIndex        =   16
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   16
         Left            =   1815
         TabIndex        =   8
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   15
         Left            =   2025
         TabIndex        =   9
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   17
         Left            =   1605
         TabIndex        =   7
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   6
         Left            =   1185
         TabIndex        =   17
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   14
         Left            =   2235
         TabIndex        =   10
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   210
         HelpContextID   =   300
         Index           =   13
         Left            =   2445
         TabIndex        =   11
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   7
         Left            =   1395
         TabIndex        =   18
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   8
         Left            =   1605
         TabIndex        =   19
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   12
         Left            =   2445
         TabIndex        =   23
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   11
         Left            =   2235
         TabIndex        =   22
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   10
         Left            =   2025
         TabIndex        =   21
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkMonitor 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   9
         Left            =   1815
         TabIndex        =   20
         Top             =   750
         Width           =   210
      End
      Begin VB.Shape Shape1 
         FillStyle       =   0  'Solid
         Height          =   270
         Index           =   1
         Left            =   0
         Shape           =   4  'Rounded Rectangle
         Top             =   495
         Width           =   120
      End
   End
   Begin MSCommLib.MSComm MSComm1 
      Left            =   2550
      Top             =   660
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   -1  'True
   End
   Begin VB.PictureBox picBuffer 
      AutoRedraw      =   -1  'True
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      ForeColor       =   &H000000FF&
      Height          =   240
      HelpContextID   =   300
      Left            =   0
      ScaleHeight     =   180
      ScaleWidth      =   1920
      TabIndex        =   62
      TabStop         =   0   'False
      ToolTipText     =   "RS232 Buffer percentage full"
      Top             =   4950
      Width           =   1980
      Begin VB.Label lblBufferPercentage 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   795
         TabIndex        =   68
         Top             =   -30
         Width           =   495
      End
   End
   Begin VB.Timer tmrDisplay 
      Enabled         =   0   'False
      Interval        =   250
      Left            =   2160
      Top             =   5565
   End
   Begin VB.Timer tmrFlash 
      Enabled         =   0   'False
      Interval        =   500
      Left            =   75
      Top             =   5580
   End
   Begin VB.CommandButton cmdCommand 
      Caption         =   "&Start"
      Height          =   330
      Left            =   735
      TabIndex        =   57
      Top             =   5700
      Width           =   1155
   End
   Begin VB.Frame Frame2 
      Caption         =   "Performance:"
      Height          =   1035
      Left            =   0
      TabIndex        =   60
      Top             =   3525
      Width           =   2715
      Begin VB.CheckBox chkOption 
         Caption         =   "Real-time Plot"
         Enabled         =   0   'False
         Height          =   210
         HelpContextID   =   300
         Index           =   3
         Left            =   330
         TabIndex        =   55
         ToolTipText     =   "Plot updates to the Logic Trace display real-time"
         Top             =   735
         Width           =   1335
      End
      Begin VB.CheckBox chkOption 
         Caption         =   "Update ""Logic Trace"""
         Height          =   195
         HelpContextID   =   300
         Index           =   2
         Left            =   75
         TabIndex        =   54
         ToolTipText     =   "Update the Logic Trace display"
         Top             =   465
         Width           =   1830
      End
      Begin VB.CheckBox chkOption 
         Caption         =   "Update ""Pin Display"""
         Height          =   195
         HelpContextID   =   300
         Index           =   1
         Left            =   75
         TabIndex        =   53
         ToolTipText     =   "Update the IC Pin Display"
         Top             =   225
         Width           =   1755
      End
   End
   Begin VB.OptionButton optOption 
      Caption         =   "Only detect pattern changes"
      Height          =   195
      HelpContextID   =   300
      Index           =   0
      Left            =   105
      TabIndex        =   49
      ToolTipText     =   "Only create a display entry when the bit pattern changes."
      Top             =   2415
      Value           =   -1  'True
      Width           =   2400
   End
   Begin VB.Frame Frame1 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1050
      Index           =   0
      Left            =   0
      TabIndex        =   58
      Top             =   1110
      Width           =   2700
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   8
         Left            =   1815
         TabIndex        =   45
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   9
         Left            =   2025
         TabIndex        =   46
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   10
         Left            =   2235
         TabIndex        =   47
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   11
         Left            =   2445
         TabIndex        =   48
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   7
         Left            =   1605
         TabIndex        =   44
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   6
         Left            =   1395
         TabIndex        =   43
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   210
         HelpContextID   =   300
         Index           =   12
         Left            =   2445
         TabIndex        =   36
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   13
         Left            =   2235
         TabIndex        =   35
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   5
         Left            =   1185
         TabIndex        =   42
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   16
         Left            =   1605
         TabIndex        =   32
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   14
         Left            =   2025
         TabIndex        =   34
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   15
         Left            =   1815
         TabIndex        =   33
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   4
         Left            =   975
         TabIndex        =   41
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   3
         Left            =   765
         TabIndex        =   40
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   17
         Left            =   1395
         TabIndex        =   31
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   18
         Left            =   1185
         TabIndex        =   30
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   2
         Left            =   555
         TabIndex        =   39
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   0
         Left            =   135
         TabIndex        =   37
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   20
         Left            =   765
         TabIndex        =   28
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   22
         Left            =   345
         TabIndex        =   26
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   1
         Left            =   345
         TabIndex        =   38
         Top             =   750
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   19
         Left            =   975
         TabIndex        =   29
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         HelpContextID   =   300
         Index           =   21
         Left            =   555
         TabIndex        =   27
         Top             =   315
         Width           =   210
      End
      Begin VB.CheckBox chkPin 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   225
         HelpContextID   =   300
         Index           =   23
         Left            =   135
         TabIndex        =   25
         Top             =   300
         Width           =   210
      End
      Begin VB.CheckBox chkOption 
         Caption         =   "Trigger Pattern"
         Height          =   330
         HelpContextID   =   300
         Index           =   0
         Left            =   105
         TabIndex        =   24
         ToolTipText     =   "Wait for the selected trigger pattern to be detected"
         Top             =   -45
         Width           =   1440
      End
      Begin VB.Shape Shape1 
         FillStyle       =   0  'Solid
         Height          =   270
         Index           =   0
         Left            =   0
         Shape           =   4  'Rounded Rectangle
         Top             =   495
         Width           =   120
      End
   End
   Begin VB.Label lblBufferCount 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   2010
      TabIndex        =   67
      ToolTipText     =   "Total number of samples processed"
      Top             =   4935
      Width           =   705
   End
   Begin VB.Label lblMessage 
      Alignment       =   2  'Center
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Press 'Start'..."
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   360
      Left            =   0
      TabIndex        =   61
      Top             =   5205
      Width           =   2715
   End
   Begin VB.Label Label1 
      BackStyle       =   0  'Transparent
      Caption         =   "Once Triggered:"
      Height          =   225
      Left            =   45
      TabIndex        =   59
      Top             =   2175
      Width           =   1185
   End
End
Attribute VB_Name = "frmLogicAnalyser"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private mbStop                                  As Boolean
Private mlBufferCount                           As Long
Private msMonitor                               As String
Private msTrigger                               As String

Private Const Module_Name                       As String = "frmLogicAnalyser"

Private Sub LockDisplay(bLock As Boolean)

    Dim con                     As Control

    
    For Each con In Controls
        If TypeOf con Is CheckBox Then
            con.Enabled = Not bLock
        ElseIf TypeOf con Is OptionButton Then
            con.Enabled = Not bLock
        ElseIf TypeOf con Is UpDown Then
            con.Enabled = Not bLock
        ElseIf TypeOf con Is TextBox Then
            con.Enabled = Not bLock
        End If
    Next
    
End Sub

Private Sub SaveSettings()
    
    Dim con                     As Control
    
    
    
    For Each con In Controls
        If TypeOf con Is CheckBox Then
            SaveSetting App.Title, "LogicAnalyser", con.Name & Format$(con.Index, "00"), Abs(con.Value)
            
        ElseIf TypeOf con Is OptionButton Then
            SaveSetting App.Title, "LogicAnalyser", con.Name & Format$(con.Index, "00"), Abs(con.Value)
        
        ElseIf TypeOf con Is TextBox Then
            SaveSetting App.Title, "LogicAnalyser", con.Name & Format$(con.Index, "00"), con.Text
        End If
    Next
    
End Sub

Private Sub chkMonitor_Click(Index As Integer)

    Dim F                           As Integer
    
    msMonitor = ""
    With gtypModel
        .NumPins = MAX_PINS
        For F = 1 To 24
            .Pin(F).Tag = ""
            If chkMonitor(F).Value Then
                .Pin(F).Usage = 0 ' Monitor Mode
                msMonitor = msMonitor & "1"
            Else
                .Pin(F).Usage = 5
                msMonitor = msMonitor & "0"
            End If
        Next F
    End With
End Sub

Private Sub chkOption_Click(Index As Integer)

    Dim F                           As Integer
    
    

    For F = 0 To 23
        chkPin(F).Enabled = Abs(chkOption(0).Value)
    Next F
    
End Sub

Private Sub chkPin_Click(Index As Integer)

    Dim F                           As Integer
    
    
    msTrigger = ""
    For F = 0 To MAX_PINS - 1
        If chkPin(F).Value Then
            msTrigger = msTrigger & "1"
        Else
            msTrigger = msTrigger & "0"
        End If
    Next F
    
End Sub


Private Sub cmdCommand_Click()

    Dim F                                       As Integer
    Const PROC_NAME                             As String = "cmdCommand"
    
    On Error GoTo ErrorHandler
    
    If cmdCommand.Tag = "1" Then
        ' Send stop command to tester
        If MSComm1.PortOpen = True Then
            MSComm1.Output = "X"
        End If
        tmrTimeOut.Enabled = True
        lblMessage.Caption = "Emptying Buffer !"
        lblMessage.BackColor = QBColor(11) ' Light Cyan
        Sleep 1
        DoEvents
        
        mbStop = True
        
    Else
        ' Starting
        If msMonitor = String$(MAX_PINS, "0") Then
            MsgBox "You need to specify at least one pin to monitor !", vbOKOnly + vbExclamation, "No Pins Selected For Monitoring"
        Else
            mbStop = False
            cmdCommand.Caption = "Stop"
            cmdCommand.Tag = "1"
            LockDisplay True
            
            ' Save the settings
            Call SaveSettings
            
            If chkOption(2).Value Then
                frmTrace.Show
                frmTrace.Reset
            End If
            
            If chkOption(1).Value Then
                With gtypModel
                    .NumPins = MAX_PINS
                    For F = 1 To MAX_PINS
                        .Pin(F).Usage = 1
                    Next F
                End With
                
                frmICView.Show
                frmICView.PackagePins
            End If
            
            tmrDisplay.Enabled = True
            Call Analyser
        End If
    End If
    
    Exit Sub
    
ErrorHandler:
    ErrorRoutine Module_Name, PROC_NAME, Err
End Sub

Private Sub Analyser()

    Dim bWaitForTrigger                         As Boolean
    Dim bFlag                                   As Boolean
    Dim bFreeRunning                            As Boolean
    Dim bUpdates(2)                             As Boolean
    Dim bTerminate                              As Boolean
    Dim F                                       As Integer
    Dim lSleep                                  As Long
    Dim sBuffer                                 As String
    Dim sPreviousBuffer                         As String
    Dim sTrigger                                As String
    Dim sBinaryData                             As String
    Dim sTemp                                   As String
    Dim sPreviousBinary                         As String
    Dim ComPort                                 As MSComm
    Const PROC_NAME                             As String = "Analyser"
    
    On Error GoTo ErrorHandler
    
    mbStop = False
    
    mlBufferCount = 0
    For F = 1 To 3
        If chkOption(F) Then
            bUpdates(F - 1) = True
        End If
    Next F
    bFreeRunning = optOption(1).Value
    lSleep = Val(txtField(0).Text)
    bWaitForTrigger = chkOption(0).Value
    
    '
    ' Establish connection to the IC Tester
    Set ComPort = MSComm1
    
    ComPort.InBufferSize = Val(gsSettings(1))
    
    Call Device_OpenPort(ComPort) ' This often causes Datacomms Error on the PIC !
    
    '
    ' Make sure there nothing in the RX buffer
    Device_FlushBuffer ComPort
    
    '
    ' Send the device reset command
    LogEvent "Sending Tester 'Reset' Command...", 1, 0
    Device_Reset ComPort
    
    '
    ' Wait for Reply
    sBuffer = Device_ReadBuffer(ComPort)
    If Right$(sBuffer, 8) = "Ready." & vbCrLf Then
        ' All ok
        LogEvent "Tester Reset Ok...", 1, 0
        
        ' Reset the PIC to the IC's base I/O configuration
        LogEvent "Base I/O configuration", 1, 0
        Device_SendConfigBits ComPort, "" ' Use the base configuration
    Else
        LogEvent "Tester failed to respond to 'Reset' command...", 2, 0
        LogEvent "Analyser Aborted...", 3, 0
        Device_ClosePort ComPort
        lblMessage.Caption = "Hardware Problem !"
        tmrFlash.Enabled = False
        lblMessage.BackColor = QBColor(12) ' Light Red
        GoTo HardwareError
    End If
    
    ComPort.InputLen = 4 ' We grab blocks of 4 bytes
            
    '
    ' Send config command
    LogEvent "Set Config", 6, 0
    Device_SendConfigBits ComPort, String$(24, "1") ' All PIC pins are inputs
    '
    ' Wait for Reply
    sBuffer = Device_ReadBuffer(ComPort)
    If Right$(sBuffer, 5) <> "OK." & vbCrLf Then
        LogEvent "Tester failed to respond to 'Config' command...", 2, 0
        LogEvent "Analyser Aborted...", 3, 0
        Device_ClosePort ComPort
        lblMessage.Caption = "Hardware Problem !"
        tmrFlash.Enabled = False
        lblMessage.BackColor = QBColor(12) ' Light Red
        GoTo HardwareError
    End If
    '
    
    If chkOption(4).Value Then
        '
        ' Activate Pull up resistors
        LogEvent "Tester '+5V' On", 9, 0
        Device_TestPowerOn ComPort
        '
        ' Wait for Reply
        sBuffer = Device_ReadBuffer(ComPort)
        If Right$(sBuffer, 5) <> "OK." & vbCrLf Then
            LogEvent "Tester failed to respond to '+5v ON' command...", 2, 0
            LogEvent "Analyser Aborted...", 3, 0
            Device_ClosePort ComPort
            lblMessage.Caption = "Hardware Problem !"
            tmrFlash.Enabled = False
            lblMessage.BackColor = QBColor(12) ' Light Red
            GoTo HardwareError
        End If
    End If
            
    '
    ' Start the testing process
    LogEvent "Starting Analyser", 11, 0

    '
    ' Indicate operating mode to user
    If chkOption(0).Value Then
        lblMessage.Caption = "Waiting For Trigger"
        tmrFlash.Enabled = True
        lblMessage.BackColor = QBColor(6) ' Yellow
        bWaitForTrigger = True
    Else
        lblMessage.Caption = "Running..."
        tmrFlash.Enabled = True
        lblMessage.BackColor = QBColor(10) ' Light Green
        bWaitForTrigger = False
    End If
    
    ' Send mode command
    LogEvent "Set Mode - Continuos Read", 6, 0
    Device_SetContinMode ComPort
    '
    ' Main Proccessing loop
    '
    Do
        If mbStop = True Then
            bUpdates(2) = False ' Supress updating the display - We just want to empty the buffer ASAP
            If ComPort.InBufferCount < 8 Then
                ' We ignore the last 8 as they will contain rubbish
                bTerminate = True
            End If
        End If
        
        If ComPort.InBufferCount >= 4 Then
            ' Something to grab - take 4 bytes
            sBuffer = ComPort.Input
            
            ' Convert input to binary
            sBinaryData = ConvertToBinary(Asc(Mid$(sBuffer, 1, 1))) ' .....................PORT B
            sBinaryData = sBinaryData & ConvertToBinary(Asc(Mid$(sBuffer, 2, 1))) '........... PORT D
            sTemp = Right$(ConvertToBinary(Asc(Mid$(sBuffer, 3, 1))), 6) ' ............PORT A
            sBinaryData = sBinaryData & Left$(sTemp, 1) ' Recover A5
            sBinaryData = sBinaryData & Mid$(sTemp, 3) ' Recover A3 to A0
            sBinaryData = sBinaryData & Right$(ConvertToBinary(Asc(Mid$(sBuffer, 4, 1))), 3) ' PORT E
            
            If bWaitForTrigger = True Then
                ' See if we are triggered
                bFlag = True
                For F = 1 To MAX_PINS
                    If chkMonitor(F).Value Then
                        If Mid$(sBinaryData, F, 1) <> Mid$(msTrigger, F, 1) Then
                            bFlag = False
                            Exit For
                        End If
                    End If
                Next F
                
                If bFlag = True Then
                    lblMessage.Caption = "Running..."
                    tmrFlash.Enabled = True
                    lblMessage.BackColor = QBColor(10) ' Light Green
                    bWaitForTrigger = False
                End If
            End If
            
            If bWaitForTrigger = False Then
                ' We are triggered OR there is no need
                ' Are we free running or only on change
                
                ' Only on change
                If sPreviousBuffer <> sBuffer Or bFreeRunning = True Then
                    ' Somthings changed - We need to see what
                    sPreviousBuffer = sBuffer
                    
                    
                    If bFreeRunning = False Then
                        For F = 1 To MAX_PINS
                            If chkMonitor(F).Value Then
                                If Mid$(sPreviousBinary, F, 1) <> Mid$(sBinaryData, F, 1) Then
                                    ' Data has changed
                                    sPreviousBinary = sBinaryData
                                    bFlag = True
                                    Exit For
                                End If
                            End If
                        Next F
                    Else
                        ' Free running
                        bFlag = True
                    End If
                End If
            
                If bFlag = True And mbStop = False Then
                    mlBufferCount = mlBufferCount + 1
                    If bUpdates(1) Then
                        If frmTrace.AddEntry(sBinaryData, bUpdates(2), sBinaryData) = False Then
                            ' Out of memory
                            ComPort.Output = "X" ' Tell tester to terminate
                            DoEvents
                            bTerminate = True
                        End If
                    End If
                    If bUpdates(0) Then
                        ' Update the IC pin view display
                        frmICView.UpdateLogicLevels sBinaryData
                    End If
                    bFlag = False
                End If
            
            End If
        End If ' Read of MSComm buffer
        If lSleep And bFreeRunning Then
            If mbStop = False Then
                ' We only need to sleep if were actually collecting and not stopping
                Sleep lSleep
                ComPort.InBufferCount = 0 ' Clear the input buffer
            End If
        End If
        
        DoEvents
    Loop While bTerminate = False
    
HardwareError:
    On Error Resume Next
    tmrTimeOut.Enabled = False
        
    LockDisplay False
    
    'tmrDisplay.Enabled = False
    cmdCommand.Caption = "Start"
    cmdCommand.Tag = "0"
    
    ComPort.InBufferCount = 0
    ComPort.OutBufferCount = 0
    ComPort.PortOpen = False
    
    lblMessage.BackColor = QBColor(7)
    lblMessage.Caption = "Press 'Start'"
    tmrFlash.Enabled = False
        
    frmTrace.RefreshDetails 0 ' Refresh details and display from sample 0

    Exit Sub
    
ErrorHandler:
    ErrorRoutine Module_Name, PROC_NAME, Err
End Sub
Private Sub Form_Load()
    Dim con                             As Control
    Dim F                               As Integer
    
    Const PROC_NAME                     As String = "Form_Load"
    
    On Error GoTo ErrorHandler

    Unload frmTestIC
    
    RecoverFormLoadPosition Me, True
    Call SetWindowPos(Me.hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE Or SWP_NOMOVE)
     
    
    For Each con In Controls
        If TypeOf con Is CheckBox Then
            con.Value = Abs(Val(GetSetting(App.Title, "LogicAnalyser", con.Name & Format$(con.Index, "00"), "0")))
            
        ElseIf TypeOf con Is OptionButton Then
            If Abs(Val(GetSetting(App.Title, "LogicAnalyser", con.Name & Format$(con.Index, "00"), "0"))) Then
                con.Value = True
            End If
        
        ElseIf TypeOf con Is TextBox Then
            con.Text = GetSetting(App.Title, "LogicAnalyser", con.Name & Format$(con.Index, "00"), "0")
            
        End If
    Next
    
    For F = 1 To MAX_PINS
        chkPin(F - 1).ToolTipText = "Pin " & Format$(F)
        chkMonitor(F).ToolTipText = "Pin " & Format$(F)
    Next F
    
    Call chkPin_Click(0)
    Call chkMonitor_Click(0)
    
    MsgBox "Note:" & vbCrLf & vbCrLf & "Please make sure that ALL power DIPS are off and there is no IC in the test socket !", vbOKOnly + vbExclamation, "Switch Off DIPS and Remove Test IC's"
    
    Exit Sub
    
ErrorHandler:
    ErrorRoutine Module_Name, PROC_NAME, Err
End Sub


Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)

    If MSComm1.PortOpen = True Then
        Cancel = True
        Exit Sub
    End If
    
    If Me.WindowState <> vbMinimized Then
        SaveSetting App.Title, "FormPositions", Me.Name, Format$(Me.Width) & "," & Format$(Me.Height) & "," & Format$(Me.Top) & "," & Format$(Me.Left)
    End If
    
    tmrDisplay.Enabled = False
    mbStop = True
    
    DoEvents
    
    Unload Me
    
End Sub


Private Sub optOption_Click(Index As Integer)

    Select Case Index
    Case 0
        chkOption(3).Value = 1
        chkOption(3).Enabled = True
        
    Case Else
        chkOption(3).Value = False
        chkOption(3).Enabled = False
        
    End Select
    
End Sub

Private Sub tmrDisplay_Timer()

    Dim bTimeoutEnabled                 As Boolean
    Dim X                               As Single
    Dim z                               As Single
    
    Static STATIC_PREVIOUS              As Long
    
    Const PROC_NAME                     As String = "tmrDisplay_Timer"
    
    On Error GoTo ErrorHandler
    
    
    X = MSComm1.InBufferCount
    
    X = (X / MSComm1.InBufferSize)
    
    z = picBuffer.Width * X
    If z > picBuffer.Width Then
        X = picBuffer.Width
        Stop
    End If
    
    With picBuffer
        .Cls
        If X < 0.5 Then
            .ForeColor = QBColor(10)  ' Light green
        ElseIf X >= 0.5 And X <= 0.8 Then
            .ForeColor = QBColor(14) ' Light Yellow
        Else
            .ForeColor = QBColor(12) ' Light Red
        End If
        
        picBuffer.Line (0, 0)-(z, .Height), , BF
        
        lblBufferPercentage.Caption = Format$(X * 100, "#0") & "%"
        
    End With
    
    
    If mlBufferCount <> STATIC_PREVIOUS Then
        ' The buffer fill level has changed
        bTimeoutEnabled = tmrTimeOut.Enabled ' Current setting
        tmrTimeOut.Enabled = False
        lblBufferCount.Caption = Format$(mlBufferCount)
        STATIC_PREVIOUS = mlBufferCount ' Remember the current fill level for next time
        tmrTimeOut.Enabled = bTimeoutEnabled
    End If
    
    Exit Sub
    
ErrorHandler:
    ErrorRoutine Module_Name, PROC_NAME, Err
End Sub

Private Sub tmrFlash_Timer()

    
    If gbOptions(3) = False Then
        tmrFlash.Enabled = False
    End If

End Sub


Private Sub tmrTimeOut_Timer()
    
    MsgBox "Time-out occured !", vbOKOnly + vbExclamation, "Time-out in Logic Analyser"
    Unload frmLogicAnalyser
End Sub




Private Sub txtField_KeyPress(Index As Integer, KeyAscii As Integer)

    Select Case Index
    Case 0
        KeyAscii = ValidateKeyPress(KeyAscii, VALIDATE_NUMERIC)
        
    End Select
End Sub


