;Hulda Clark Virus Zapper program
;for PIC16F84: osc=XT, wdt=OFF, put=ON.
;Andy Flind, 21/06/2001

#DEFINE PAGE0 BCF STATUS,5
#DEFINE PAGE1 BSF STATUS,5

STATUS:	.EQU $03			;general equates
PORTA:	.EQU $05
TRISA:	.EQU $05
PORTB:	.EQU $06
TRISB:	.EQU $06
F:	.EQU $01
CTR0:	.EQU $0C
CTR1:	.EQU $0D
CTR2:	.EQU $10
CTR3:	.EQU $11
CTR4:	.EQU $12

	.ORG $0004
	.ORG $0005

;initialise the system for operation
	CLRF PORTA
	CLRF PORTB
	PAGE1
	MOVLW %11110001		;RA1,2,3 outputs
	MOVWF TRISA
	MOVLW %11000111		;only RB3,4, and 5 outputs
	MOVWF TRISB
	PAGE0
	MOVLW 255
	MOVWF PORTA		;sets all high, for LEDs off
	MOVLW %00100000		;RB5 high, rest low
	MOVWF PORTB

;main program sequence
	CALL BLEEP
	CALL FLASH
	CALL BLEEP
	CALL TRT
	CALL BLEEP
	CALL WAIT
	CALL BLEEP
	CALL FLASH
	CALL BLEEP
	CALL TRT
	CALL BLEEP
	CALL WAIT
	CALL BLEEP
	CALL FLASH
	CALL BLEEP
	CALL TRT
	CALL FNSH

;Bleeper, 1/2 second bleep at 4kHz for piezo sounder, yellow LED on
BLEEP:	 BCF PORTA,2		;yellow LED on
	MOVLW 8		;initialise for 2000 half cycles,
	MOVWF CTR0		;1/4 second total with 8
	MOVLW 250		;or 1/2 second with 16 etc 
	MOVWF CTR1
BLP1:	MOVLW 8		;change state of RB3
	XORWF PORTB,F
	BSF PORTA,3		;battery check
	BTFSS PORTB,0
	BCF PORTA,3
	MOVLW 36		;timing to get exactly 125 uS half cycles
	MOVWF CTR2
BLP2:	DECFSZ CTR2,F
	GOTO BLP2
	NOP
	NOP
	DECFSZ CTR1,F		;counter, always takes 9 instruction cycles
	GOTO BLP3
	MOVLW 250
	MOVWF CTR1
	DECFSZ CTR0,F
	GOTO BLP4
	BSF PORTA,2		;yellow LED off
	RETURN
BLP3:	NOP
	NOP
	NOP
	NOP
BLP4:	GOTO BLP1

;30 seconds of 1 second yellow LED flashes, 50% duty cycle
FLASH:	 MOVLW 60		;60 half cycles, 30 seconds
	MOVWF CTR0
FLSH1:  MOVLW 4			;change state of RA2
	XORWF PORTA,F
	MOVLW 79		;30 second delay
	MOVWF CTR1
FLSH2:	MOVLW 25
	MOVWF CTR2
FLSH3:	MOVLW 83
	MOVWF CTR3
FLSH4:	DECFSZ CTR3,F
	GOTO FLSH4
	DECFSZ CTR2,F
	GOTO FLSH3
	DECFSZ CTR1,F
	GOTO FLSH2
	BSF PORTA,3		;battery test
	BTFSS PORTB,0
	BCF PORTA,3
	DECFSZ CTR0,F		;cycle counter
	GOTO FLSH1
	RETURN

;Treatment routine, 7 minutes of 2.5kHz output, yellow LED on
TRT:	BCF PORTA,2		;yellow LED on
	MOVLW 48		;initialise counter for 2.1 million half cycles
	MOVWF CTR0
	MOVLW 175
	MOVWF CTR1
	MOVLW 250
	MOVWF CTR2
TRT1:	MOVLW 48		;change state of RB4 and RB5
	XORWF PORTB,F
	BSF PORTA,3		;battery test
	BTFSS PORTB,0
	BCF PORTA,3
	MOVLW 60		;timing to exactly 200uS for half cycle
	MOVWF CTR4
TRT2:	DECFSZ CTR4,F
	GOTO TRT2
	NOP
	DECFSZ CTR2,F		;counter takes exactly 13 instruction cycles
	GOTO TRT3		;regardless of zero skips
	MOVLW 250
	MOVWF CTR2
	DECFSZ CTR1,F
	GOTO TRT4
	MOVLW 175
	MOVWF CTR1 
	DECFSZ CTR0,F
	GOTO TRT5
	BSF PORTA,2		;yellow LED off
	RETURN
TRT3:	NOP
	NOP
	NOP
	NOP
TRT4:	NOP
	NOP
	NOP
	NOP
TRT5:	 GOTO TRT1

;Wait routine, for 28 mins, batt test every 30 seconds, green LED on
WAIT:	BCF PORTA,1		;green LED on
	MOVLW 56		;56 for a 28 minute period
	MOVWF CTR4
WT1:	MOVLW 229		;these values give error of -4.312mS
	MOVWF CTR0		;over 28 minutes!
WT2:	MOVLW 200
	MOVWF CTR1
WT3:	MOVLW 217
	MOVWF CTR2
WT4:	DECFSZ CTR2,F
	GOTO WT4
	DECFSZ CTR1,F
	GOTO WT3
	DECFSZ CTR0,F
	GOTO WT2
	BSF PORTA,3		;Battery check
	BTFSS PORTB,0
	BCF PORTA,3
	DECFSZ CTR4,F
	GOTO WT1
	BSF PORTA,1		;green LED off
	RETURN

;Finish routine, bleeps every ten seconds, green LED on
FNSH:	BCF PORTA,1		;green LED on
FIN1:	CALL BLEEP
	MOVLW 59		;use 59 with 1/4 sec bleep, 105 with 1/2
	MOVWF CTR0
FIN2:	MOVLW 250		;use 250 with 1/4 sec bleep, 172 with 1/2
	MOVWF CTR1
FIN3:	MOVLW 219		;use 219 with 1/4 sec bleep, 174 with 1/2
	MOVWF CTR2
FIN4:	DECFSZ CTR2,F
	GOTO FIN4
	DECFSZ CTR1,F
	GOTO FIN3
	DECFSZ CTR0,F
	GOTO FIN2
	GOTO FIN1

.END
