;TUT26.ASM. FIGPD.PIC 14AUG97 - JOHN BECKER - EPE PIC TUTOR
;Use of Timer with BCD counting on 7-segment (single)

LIST p = PIC16F877, r= dec	;********PB1

include pbm.inc		;********PB1

;<Approx 111 lines of PB1 macro statements >

#DEFINE PAGE0   BCF $03,5
#DEFINE PAGE1   BSF $03,5

OPTION: .EQU $01        
PCL:    .EQU $02        
STATUS: .EQU $03        
PORTB:  .EQU $06        
TRISB:  .EQU $06        
INTCON: .EQU $0B        
W:      .EQU 0          
F:      .EQU 1          
C:      .EQU 0          
DC:     .EQU 1          

CLKCNT: .EQU $20        ;clock division counter 
CLKSEC: .EQU $21        ;seconds counter  
        .org 4
        .org 5
        clrf PORTB	;********** see text
        PAGE1
        clrf TRISB      ;Port B0-B7 as output
        bsf TRISB,6	;********PB1 B6 as input
        bsf TRISB,7	;********PB1 B7 as input
        movlw %00000110 ;set timer ratio 1:128 (TMRO rate)
        movwf OPTION
        PAGE0
        movlw 25
        movwf CLKCNT
        clrf CLKSEC
        bcf INTCON,2
        goto INTRPT
TABLE:  addwf PCL,F     ;add to PCL
        retlw %11000000 ;0   common anode codes
        retlw %11111001 ;1
        retlw %10100100 ;2
        retlw %10110000 ;3
        retlw %10011001 ;4
        retlw %10010010 ;5
        retlw %10000011 ;6
        retlw %11111000 ;7
        retlw %10000000 ;8
        retlw %10011000 ;9

INTRPT: btfss INTCON,2  ;has a timer time-out been detected?
        goto INTRPT     ;no
        bcf INTCON,2    ;yes
        decfsz CLKCNT,F ;dec clock division counter, is it zero?
        goto INTRPT     ;no
        movlw 25        ;yes, reset CLKCNT
        movwf CLKCNT
        incf CLKSEC,F   ;inc count
        movf CLKSEC,W   ;check units >9
        addlw 6
        btfsc STATUS,DC ;is there a digit carry?
        clrf CLKSEC     ;yes, clear counter
OUTPUT: movf CLKSEC,W   ;get count val
        setc            ;********PB1
        bkpt            ;********PB1

;< 10 - 16 PB1 instructions >

        clrc            ;********PB1
        andlw 15        ;AND for LS nibble
        call TABLE      ;get 7-seg code for val
        movwf PORTB     ;output to display
        bkpt            ;********PB1

;< 10 - 16 PB1 instructions >

        goto INTRPT     ;repeat for next
        pb              ;********PB1

;< 69 - 72 PB1 instructions >

       .END            
