;Pic Breakpoint V1 - Copyright Richard Hinckley (c) 2003

#ifdef __16F877
bkpt	macro
	LOCAL _bkpt1
_bkpt1	
	bcf 0x78,7	;save GIE bit
	btfsc 11,7
	bsf 0x78,7
	bcf 11,7		;and disable interrupts
	movwf 0x7F	;save W
	movlw LOW _bkpt1	;save low address
	movwf 0x7D
	movlw HIGH _bkpt1
	movwf 0x7A	;save high address
	swapf 10,0	;save PCLATH in W
	movwf 0x77	;and then in 0x77
	movlw HIGH _pbreak	;Store high address of _pbreak in PCLATH
	movwf 10
	call _pbreak
	btfsc 0x78,7	;test if GIE should be set
	bsf 11,7		;and set if necessary
	endm
pb	macro
_pbreak
	bsf 0x78,6	;set 4 banks
	swapf 3,0		;load status into w
	movwf 0x7E	;save status
	swapf 0x7E,1	;Swap saved status the right way round	
	swapf 0x77,1	;swap saved PCLATH right way round
	bcf 3,5		;Page 0
	bcf 6,7		;ensure 0 at RB7
	bcf 6,6		;ensure 0 at RB6
	movfw 4		;save fsr
	movwf 0x7C
	bcf 3,7		;Set Banks 0 and 1
	bsf 3,5		;Page 1
	bcf 6,7		;PortB, RB7 as output
	bsf 6,6		;PortB, RB6 as input
	bcf 3,5		;Page 0
_pblp0
	btfss 6,6		;first handshake on entry
	goto _pblp0
	bsf 6,7
_pblp1
	btfsc 6,6		;second handshake on entry
	goto _pblp1
	bcf 6,7	
_pblp2
	clrf 0x79	; set up for 2 banks of bytes
	clrf 4		;clear fsr
_pblp3
	clrwdt		;ensure no reset from wdt
	movfw 0		;move indf to w
	movwf 0x7B
	movlw b'11000000'	;set up for 8 bits
	andwf 0x78,1
_pblp4
	btfss 6,6		;test if PC ready to receive data
	goto _pblp4
	rlf 0x7B,1	;rotate msbit into carry
	skpnc
	bsf 6,7		;output 0 or 1 appropriate
	skpc
	bcf 6,7
_pblp5
	btfsc 6,6		;test if PC has received data
	goto _pblp5
	incf 0x78,1	;do 8 bits
	btfss 0x78,3
	goto _pblp4
	incf 4,1		;inc fsr to next byte
	decfsz 0x79,1	;do 256 bytes
	goto _pblp3
	btfsc 0x78,6	;test if 2 or 4 banks to be sent
	goto _pblp6	;goto set IRP if required 
	goto _pblp7	;goto out sequence
_pblp6
	bcf 0x78,6
	bsf 3,7		;Do Banks 2 & 3 if required
	goto _pblp2
_pblp7
	bcf 11,0		;prevent port change interrupts from PB
	bsf 3,5		;Page 1
	bsf 6,7		;PortB, RB7 as input
	bcf 3,5		;Page 0
	bcf 6,7		;prevent spurious writes to RB7
	movfw 0x7C	;restore fsr
	movwf 4
	movfw 0x77	;Restore PCLATH
	movwf 10
	swapf 0x7E,1
	swapf 0x7E,0	;restore status
	movwf 3
	swapf 0x7F,1	;restore w
	swapf 0x7F,0
	return
	endm
#endif
#ifdef __16F876
bkpt	macro
	LOCAL _bkpt1
_bkpt1	
	bcf 0x78,7	;save GIE bit
	btfsc 11,7
	bsf 0x78,7
	bcf 11,7		;and disable interrupts
	movwf 0x7F	;save W
	movlw LOW _bkpt1	;save low address
	movwf 0x7D
	movlw HIGH _bkpt1
	movwf 0x7A	;save high address
	swapf 10,0	;save PCLATH in W
	movwf 0x77	;and then in 0x77
	movlw HIGH _pbreak	;Store high address of _pbreak in PCLATH
	movwf 10
	call _pbreak
	btfsc 0x78,7	;test if GIE should be set
	bsf 11,7		;and set if necessary
	endm
pb	macro
_pbreak
	bsf 0x78,6	;set 4 banks
	swapf 3,0		;load status into w
	movwf 0x7E	;save status
	swapf 0x7E,1	;Swap saved status the right way round	
	swapf 0x77,1	;swap saved PCLATH right way round
	bcf 3,5		;Page 0
	bcf 6,7		;ensure 0 at RB7
	bcf 6,6		;ensure 0 at RB6
	movfw 4		;save fsr
	movwf 0x7C
	bcf 3,7		;Set Banks 0 and 1
	bsf 3,5		;Page 1
	bcf 6,7		;PortB, RB7 as output
	bsf 6,6		;PortB, RB6 as input
	bcf 3,5		;Page 0
_pblp0
	btfss 6,6		;first handshake on entry
	goto _pblp0
	bsf 6,7
_pblp1
	btfsc 6,6		;second handshake on entry
	goto _pblp1
	bcf 6,7	
_pblp2
	clrf 0x79	; set up for 2 banks of bytes
	clrf 4		;clear fsr
_pblp3
	clrwdt		;ensure no reset from wdt
	movfw 0		;move indf to w
	movwf 0x7B
	movlw b'11000000'	;set up for 8 bits
	andwf 0x78,1
_pblp4
	btfss 6,6		;test if PC ready to receive data
	goto _pblp4
	rlf 0x7B,1	;rotate msbit into carry
	skpnc
	bsf 6,7		;output 0 or 1 appropriate
	skpc
	bcf 6,7
_pblp5
	btfsc 6,6		;test if PC has received data
	goto _pblp5
	incf 0x78,1	;do 8 bits
	btfss 0x78,3
	goto _pblp4
	incf 4,1		;inc fsr to next byte
	decfsz 0x79,1	;do 256 bytes
	goto _pblp3
	btfsc 0x78,6	;test if 2 or 4 banks to be sent
	goto _pblp6	;goto set IRP if required 
	goto _pblp7	;goto out sequence
_pblp6
	bcf 0x78,6
	bsf 3,7		;Do Banks 2 & 3 if required
	goto _pblp2
_pblp7
	bcf 11,0		;prevent port change interrupts from PB
	bsf 3,5		;Page 1
	bsf 6,7		;PortB, RB7 as input
	bcf 3,5		;Page 0
	bcf 6,7		;prevent spurious writes to RB7
	movfw 0x7C	;restore fsr
	movwf 4
	movfw 0x77	;Restore PCLATH
	movwf 10
	swapf 0x7E,1
	swapf 0x7E,0	;restore status
	movwf 3
	swapf 0x7F,1	;restore w
	swapf 0x7F,0
	return
	endm
#endif
#ifdef __16F874
bkpt	macro
	LOCAL _bkpt1
_bkpt1	
	bcf 0x78,7	;save GIE bit
	btfsc 11,7
	bsf 0x78,7
	bcf 11,7		;and disable interrupts
	movwf 0x7F	;save W
	movlw LOW _bkpt1	;save low address
	movwf 0x7D
	movlw HIGH _bkpt1
	movwf 0x7A	;save high address
	swapf 10,0	;save PCLATH in W
	movwf 0x77	;and then in 0x77
	movlw HIGH _pbreak	;Store high address of _pbreak in PCLATH
	movwf 10
	call _pbreak
	btfsc 0x78,7	;test if GIE should be set
	bsf 11,7		;and set if necessary
	endm
pb	macro
_pbreak
	bsf 0x78,6	;set 4 banks
	swapf 3,0		;load status into w
	movwf 0x7E	;save status
	swapf 0x7E,1	;Swap saved status the right way round	
	swapf 0x77,1	;swap saved PCLATH right way round
	bcf 3,5		;Page 0
	bcf 6,7		;ensure 0 at RB7
	bcf 6,6		;ensure 0 at RB6
	movfw 4		;save fsr
	movwf 0x7C
	bcf 3,7		;Set Banks 0 and 1
	bsf 3,5		;Page 1
	bcf 6,7		;PortB, RB7 as output
	bsf 6,6		;PortB, RB6 as input
	bcf 3,5		;Page 0
_pblp0
	btfss 6,6		;first handshake on entry
	goto _pblp0
	bsf 6,7
_pblp1
	btfsc 6,6		;second handshake on entry
	goto _pblp1
	bcf 6,7	
_pblp2
	clrf 0x79	; set up for 2 banks of bytes
	clrf 4		;clear fsr
_pblp3
	clrwdt		;ensure no reset from wdt
	movfw 0		;move indf to w
	movwf 0x7B
	movlw b'11000000'	;set up for 8 bits
	andwf 0x78,1
_pblp4
	btfss 6,6		;test if PC ready to receive data
	goto _pblp4
	rlf 0x7B,1	;rotate msbit into carry
	skpnc
	bsf 6,7		;output 0 or 1 appropriate
	skpc
	bcf 6,7
_pblp5
	btfsc 6,6		;test if PC has received data
	goto _pblp5
	incf 0x78,1	;do 8 bits
	btfss 0x78,3
	goto _pblp4
	incf 4,1		;inc fsr to next byte
	decfsz 0x79,1	;do 256 bytes
	goto _pblp3
	btfsc 0x78,6	;test if 2 or 4 banks to be sent
	goto _pblp6	;goto set IRP if required 
	goto _pblp7	;goto out sequence
_pblp6
	bcf 0x78,6
	bsf 3,7		;Do Banks 2 & 3 if required
	goto _pblp2
_pblp7
	bcf 11,0		;prevent port change interrupts from PB
	bsf 3,5		;Page 1
	bsf 6,7		;PortB, RB7 as input
	bcf 3,5		;Page 0
	bcf 6,7		;prevent spurious writes to RB7
	movfw 0x7C	;restore fsr
	movwf 4
	movfw 0x77	;Restore PCLATH
	movwf 10
	swapf 0x7E,1
	swapf 0x7E,0	;restore status
	movwf 3
	swapf 0x7F,1	;restore w
	swapf 0x7F,0
	return
	endm
#endif
#ifdef __16F873
bkpt	macro
	LOCAL _bkpt1
_bkpt1	
	bcf 0x78,7	;save GIE bit
	btfsc 11,7
	bsf 0x78,7
	bcf 11,7		;and disable interrupts
	movwf 0x7F	;save W
	movlw LOW _bkpt1	;save low address
	movwf 0x7D
	movlw HIGH _bkpt1
	movwf 0x7A	;save high address
	swapf 10,0	;save PCLATH in W
	movwf 0x77	;and then in 0x77
	movlw HIGH _pbreak	;Store high address of _pbreak in PCLATH
	movwf 10
	call _pbreak
	btfsc 0x78,7	;test if GIE should be set
	bsf 11,7		;and set if necessary
	endm
pb	macro
_pbreak
	bsf 0x78,6	;set 4 banks
	swapf 3,0		;load status into w
	movwf 0x7E	;save status
	swapf 0x7E,1	;Swap saved status the right way round	
	swapf 0x77,1	;swap saved PCLATH right way round
	bcf 3,5		;Page 0
	bcf 6,7		;ensure 0 at RB7
	bcf 6,6		;ensure 0 at RB6
	movfw 4		;save fsr
	movwf 0x7C
	bcf 3,7		;Set Banks 0 and 1
	bsf 3,5		;Page 1
	bcf 6,7		;PortB, RB7 as output
	bsf 6,6		;PortB, RB6 as input
	bcf 3,5		;Page 0
_pblp0
	btfss 6,6		;first handshake on entry
	goto _pblp0
	bsf 6,7
_pblp1
	btfsc 6,6		;second handshake on entry
	goto _pblp1
	bcf 6,7	
_pblp2
	clrf 0x79	; set up for 2 banks of bytes
	clrf 4		;clear fsr
_pblp3
	clrwdt		;ensure no reset from wdt
	movfw 0		;move indf to w
	movwf 0x7B
	movlw b'11000000'	;set up for 8 bits
	andwf 0x78,1
_pblp4
	btfss 6,6		;test if PC ready to receive data
	goto _pblp4
	rlf 0x7B,1	;rotate msbit into carry
	skpnc
	bsf 6,7		;output 0 or 1 appropriate
	skpc
	bcf 6,7
_pblp5
	btfsc 6,6		;test if PC has received data
	goto _pblp5
	incf 0x78,1	;do 8 bits
	btfss 0x78,3
	goto _pblp4
	incf 4,1		;inc fsr to next byte
	decfsz 0x79,1	;do 256 bytes
	goto _pblp3
	btfsc 0x78,6	;test if 2 or 4 banks to be sent
	goto _pblp6	;goto set IRP if required 
	goto _pblp7	;goto out sequence
_pblp6
	bcf 0x78,6
	bsf 3,7		;Do Banks 2 & 3 if required
	goto _pblp2
_pblp7
	bcf 11,0		;prevent port change interrupts from PB
	bsf 3,5		;Page 1
	bsf 6,7		;PortB, RB7 as input
	bcf 3,5		;Page 0
	bcf 6,7		;prevent spurious writes to RB7
	movfw 0x7C	;restore fsr
	movwf 4
	movfw 0x77	;Restore PCLATH
	movwf 10
	swapf 0x7E,1
	swapf 0x7E,0	;restore status
	movwf 3
	swapf 0x7F,1	;restore w
	swapf 0x7F,0
	return
	endm
#endif
#ifdef __16F872
bkpt	macro
	LOCAL _bkpt1
_bkpt1	
	bcf 0x78,7	;save GIE bit
	btfsc 11,7
	bsf 0x78,7
	bcf 11,7		;and disable interrupts
	movwf 0x7F	;save W
	movlw LOW _bkpt1	;save low address
	movwf 0x7D
	call _pbreak
	btfsc 0x78,7	;test if GIE should be set
	bsf 11,7		;and set if necessary
	endm
pb	macro
_pbreak
	bsf 0x78,6	;set 4 banks
	swapf 3,0		;load status into w
	movwf 0x7E	;save status
	swapf 0x7E,1	;Swap saved status the right way round	
	bcf 3,5		;Page 0
	bcf 6,7		;ensure 0 at RB7
	bcf 6,6		;ensure 0 at RB6
	movfw 4		;save fsr
	movwf 0x7C
	bcf 3,7		;Set Banks 0 and 1
	bsf 3,5		;Page 1
	bcf 6,7		;PortB, RB7 as output
	bsf 6,6		;PortB, RB6 as input
	bcf 3,5		;Page 0
_pblp0
	btfss 6,6		;first handshake on entry
	goto _pblp0
	bsf 6,7
_pblp1
	btfsc 6,6		;second handshake on entry
	goto _pblp1
	bcf 6,7	
_pblp2
	clrf 0x79	; set up for 2 banks of bytes
	clrf 4		;clear fsr
_pblp3
	clrwdt		;ensure no reset from wdt
	movfw 0		;move indf to w
	movwf 0x7B
	movlw b'11000000'	;set up for 8 bits
	andwf 0x78,1
_pblp4
	btfss 6,6		;test if PC ready to receive data
	goto _pblp4
	rlf 0x7B,1	;rotate msbit into carry
	skpnc
	bsf 6,7		;output 0 or 1 appropriate
	skpc
	bcf 6,7
_pblp5
	btfsc 6,6		;test if PC has received data
	goto _pblp5
	incf 0x78,1	;do 8 bits
	btfss 0x78,3
	goto _pblp4
	incf 4,1		;inc fsr to next byte
	decfsz 0x79,1	;do 256 bytes
	goto _pblp3
	btfsc 0x78,6	;test if 2 or 4 banks to be sent
	goto _pblp6	;goto set IRP if required 
	goto _pblp7	;goto out sequence
_pblp6
	bcf 0x78,6
	bsf 3,7		;Do Banks 2 & 3 if required
	goto _pblp2
_pblp7
	bcf 11,0		;prevent port change interrupts from PB
	bsf 3,5		;Page 1
	bsf 6,7		;PortB, RB7 as input
	bcf 3,5		;Page 0
	bcf 6,7		;prevent spurious writes to RB7
	movfw 0x7C	;restore fsr
	movwf 4
	swapf 0x7E,1
	swapf 0x7E,0	;restore status
	movwf 3
	swapf 0x7F,1	;restore w
	swapf 0x7F,0
	return
	endm
#endif
#ifdef __16F871
bkpt	macro
	LOCAL _bkpt1
_bkpt1	
	bcf 0x78,7	;save GIE bit
	btfsc 11,7
	bsf 0x78,7
	bcf 11,7		;and disable interrupts
	movwf 0x7F	;save W
	movlw LOW _bkpt1	;save low address
	movwf 0x7D
	call _pbreak
	btfsc 0x78,7	;test if GIE should be set
	bsf 11,7		;and set if necessary
	endm
pb	macro
_pbreak
	bsf 0x78,6	;set 4 banks
	swapf 3,0		;load status into w
	movwf 0x7E	;save status
	swapf 0x7E,1	;Swap saved status the right way round	
	bcf 3,5		;Page 0
	bcf 6,7		;ensure 0 at RB7
	bcf 6,6		;ensure 0 at RB6
	movfw 4		;save fsr
	movwf 0x7C
	bcf 3,7		;Set Banks 0 and 1
	bsf 3,5		;Page 1
	bcf 6,7		;PortB, RB7 as output
	bsf 6,6		;PortB, RB6 as input
	bcf 3,5		;Page 0
_pblp0
	btfss 6,6		;first handshake on entry
	goto _pblp0
	bsf 6,7
_pblp1
	btfsc 6,6		;second handshake on entry
	goto _pblp1
	bcf 6,7	
_pblp2
	clrf 0x79	; set up for 2 banks of bytes
	clrf 4		;clear fsr
_pblp3
	clrwdt		;ensure no reset from wdt
	movfw 0		;move indf to w
	movwf 0x7B
	movlw b'11000000'	;set up for 8 bits
	andwf 0x78,1
_pblp4
	btfss 6,6		;test if PC ready to receive data
	goto _pblp4
	rlf 0x7B,1	;rotate msbit into carry
	skpnc
	bsf 6,7		;output 0 or 1 appropriate
	skpc
	bcf 6,7
_pblp5
	btfsc 6,6		;test if PC has received data
	goto _pblp5
	incf 0x78,1	;do 8 bits
	btfss 0x78,3
	goto _pblp4
	incf 4,1		;inc fsr to next byte
	decfsz 0x79,1	;do 256 bytes
	goto _pblp3
	btfsc 0x78,6	;test if 2 or 4 banks to be sent
	goto _pblp6	;goto set IRP if required 
	goto _pblp7	;goto out sequence
_pblp6
	bcf 0x78,6
	bsf 3,7		;Do Banks 2 & 3 if required
	goto _pblp2
_pblp7
	bcf 11,0		;prevent port change interrupts from PB
	bsf 3,5		;Page 1
	bsf 6,7		;PortB, RB7 as input
	bcf 3,5		;Page 0
	bcf 6,7		;prevent spurious writes to RB7
	movfw 0x7C	;restore fsr
	movwf 4
	swapf 0x7E,1
	swapf 0x7E,0	;restore status
	movwf 3
	swapf 0x7F,1	;restore w
	swapf 0x7F,0
	return
	endm
#endif
#ifdef __16F870
bkpt	macro
	LOCAL _bkpt1
_bkpt1	
	bcf 0x78,7	;save GIE bit
	btfsc 11,7
	bsf 0x78,7
	bcf 11,7		;and disable interrupts
	movwf 0x7F	;save W
	movlw LOW _bkpt1	;save low address
	movwf 0x7D
	call _pbreak
	btfsc 0x78,7	;test if GIE should be set
	bsf 11,7		;and set if necessary
	endm
pb	macro
_pbreak
	bsf 0x78,6	;set 4 banks
	swapf 3,0		;load status into w
	movwf 0x7E	;save status
	swapf 0x7E,1	;Swap saved status the right way round	
	bcf 3,5		;Page 0
	bcf 6,7		;ensure 0 at RB7
	bcf 6,6		;ensure 0 at RB6
	movfw 4		;save fsr
	movwf 0x7C
	bcf 3,7		;Set Banks 0 and 1
	bsf 3,5		;Page 1
	bcf 6,7		;PortB, RB7 as output
	bsf 6,6		;PortB, RB6 as input
	bcf 3,5		;Page 0
_pblp0
	btfss 6,6		;first handshake on entry
	goto _pblp0
	bsf 6,7
_pblp1
	btfsc 6,6		;second handshake on entry
	goto _pblp1
	bcf 6,7	
_pblp2
	clrf 0x79	; set up for 2 banks of bytes
	clrf 4		;clear fsr
_pblp3
	clrwdt		;ensure no reset from wdt
	movfw 0		;move indf to w
	movwf 0x7B
	movlw b'11000000'	;set up for 8 bits
	andwf 0x78,1
_pblp4
	btfss 6,6		;test if PC ready to receive data
	goto _pblp4
	rlf 0x7B,1	;rotate msbit into carry
	skpnc
	bsf 6,7		;output 0 or 1 appropriate
	skpc
	bcf 6,7
_pblp5
	btfsc 6,6		;test if PC has received data
	goto _pblp5
	incf 0x78,1	;do 8 bits
	btfss 0x78,3
	goto _pblp4
	incf 4,1		;inc fsr to next byte
	decfsz 0x79,1	;do 256 bytes
	goto _pblp3
	btfsc 0x78,6	;test if 2 or 4 banks to be sent
	goto _pblp6	;goto set IRP if required 
	goto _pblp7	;goto out sequence
_pblp6
	bcf 0x78,6
	bsf 3,7		;Do Banks 2 & 3 if required
	goto _pblp2
_pblp7
	bcf 11,0		;prevent port change interrupts from PB
	bsf 3,5		;Page 1
	bsf 6,7		;PortB, RB7 as input
	bcf 3,5		;Page 0
	bcf 6,7		;prevent spurious writes to RB7
	movfw 0x7C	;restore fsr
	movwf 4
	swapf 0x7E,1
	swapf 0x7E,0	;restore status
	movwf 3
	swapf 0x7F,1	;restore w
	swapf 0x7F,0
	return
	endm
#endif
#ifdef __16F628
bkpt	macro
	LOCAL _bkpt1
_bkpt1	
	bcf 0x78,7	;save GIE bit
	btfsc 11,7
	bsf 0x78,7
	bcf 11,7		;and disable interrupts
	movwf 0x7F	;save W
	movlw LOW _bkpt1	;save low address
	movwf 0x7D
	call _pbreak
	btfsc 0x78,7	;test if GIE should be set
	bsf 11,7		;and set if necessary
	endm
pb	macro
_pbreak
	bsf 0x78,6	;set 4 banks
	swapf 3,0		;load status into w
	movwf 0x7E	;save status
	swapf 0x7E,1	;Swap saved status the right way round	
	bcf 3,5		;Page 0
	bcf 6,7		;ensure 0 at RB7
	bcf 6,6		;ensure 0 at RB6
	movfw 4		;save fsr
	movwf 0x7C
	bcf 3,7		;Set Banks 0 and 1
	bsf 3,5		;Page 1
	bcf 6,7		;PortB, RB7 as output
	bsf 6,6		;PortB, RB6 as input
	bcf 3,5		;Page 0
_pblp0
	btfss 6,6		;first handshake on entry
	goto _pblp0
	bsf 6,7
_pblp1
	btfsc 6,6		;second handshake on entry
	goto _pblp1
	bcf 6,7	
_pblp2
	clrf 0x79	; set up for 2 banks of bytes
	clrf 4		;clear fsr
_pblp3
	clrwdt		;ensure no reset from wdt
	movfw 0		;move indf to w
	movwf 0x7B
	movlw b'11000000'	;set up for 8 bits
	andwf 0x78,1
_pblp4
	btfss 6,6		;test if PC ready to receive data
	goto _pblp4
	rlf 0x7B,1	;rotate msbit into carry
	skpnc
	bsf 6,7		;output 0 or 1 appropriate
	skpc
	bcf 6,7
_pblp5
	btfsc 6,6		;test if PC has received data
	goto _pblp5
	incf 0x78,1	;do 8 bits
	btfss 0x78,3
	goto _pblp4
	incf 4,1		;inc fsr to next byte
	decfsz 0x79,1	;do 256 bytes
	goto _pblp3
	btfsc 0x78,6	;test if 2 or 4 banks to be sent
	goto _pblp6	;goto set IRP if required 
	goto _pblp7	;goto out sequence
_pblp6
	bcf 0x78,6
	bsf 3,7		;Do Banks 2 & 3 if required
	goto _pblp2
_pblp7
	bcf 11,0		;prevent port change interrupts from PB
	bsf 3,5		;Page 1
	bsf 6,7		;PortB, RB7 as input
	bcf 3,5		;Page 0
	bcf 6,7		;prevent spurious writes to RB7
	movfw 0x7C	;restore fsr
	movwf 4
	swapf 0x7E,1
	swapf 0x7E,0	;restore status
	movwf 3
	swapf 0x7F,1	;restore w
	swapf 0x7F,0
	return
	endm
#endif
#ifdef __16F627
bkpt	macro
	LOCAL _bkpt1
_bkpt1	
	bcf 0x78,7	;save GIE bit
	btfsc 11,7
	bsf 0x78,7
	bcf 11,7		;and disable interrupts
	movwf 0x7F	;save W
	movlw LOW _bkpt1	;save low address
	movwf 0x7D
	call _pbreak
	btfsc 0x78,7	;test if GIE should be set
	bsf 11,7		;and set if necessary
	endm
pb	macro
_pbreak
	bsf 0x78,6	;set 4 banks
	swapf 3,0		;load status into w
	movwf 0x7E	;save status
	swapf 0x7E,1	;Swap saved status the right way round	
	bcf 3,5		;Page 0
	bcf 6,7		;ensure 0 at RB7
	bcf 6,6		;ensure 0 at RB6
	movfw 4		;save fsr
	movwf 0x7C
	bcf 3,7		;Set Banks 0 and 1
	bsf 3,5		;Page 1
	bcf 6,7		;PortB, RB7 as output
	bsf 6,6		;PortB, RB6 as input
	bcf 3,5		;Page 0
_pblp0
	btfss 6,6		;first handshake on entry
	goto _pblp0
	bsf 6,7
_pblp1
	btfsc 6,6		;second handshake on entry
	goto _pblp1
	bcf 6,7	
_pblp2
	clrf 0x79	; set up for 2 banks of bytes
	clrf 4		;clear fsr
_pblp3
	clrwdt		;ensure no reset from wdt
	movfw 0		;move indf to w
	movwf 0x7B
	movlw b'11000000'	;set up for 8 bits
	andwf 0x78,1
_pblp4
	btfss 6,6		;test if PC ready to receive data
	goto _pblp4
	rlf 0x7B,1	;rotate msbit into carry
	skpnc
	bsf 6,7		;output 0 or 1 appropriate
	skpc
	bcf 6,7
_pblp5
	btfsc 6,6		;test if PC has received data
	goto _pblp5
	incf 0x78,1	;do 8 bits
	btfss 0x78,3
	goto _pblp4
	incf 4,1		;inc fsr to next byte
	decfsz 0x79,1	;do 256 bytes
	goto _pblp3
	btfsc 0x78,6	;test if 2 or 4 banks to be sent
	goto _pblp6	;goto set IRP if required 
	goto _pblp7	;goto out sequence
_pblp6
	bcf 0x78,6
	bsf 3,7		;Do Banks 2 & 3 if required
	goto _pblp2
_pblp7
	bcf 11,0		;prevent port change interrupts from PB
	bsf 3,5		;Page 1
	bsf 6,7		;PortB, RB7 as input
	bcf 3,5		;Page 0
	bcf 6,7		;prevent spurious writes to RB7
	movfw 0x7C	;restore fsr
	movwf 4
	swapf 0x7E,1
	swapf 0x7E,0	;restore status
	movwf 3
	swapf 0x7F,1	;restore w
	swapf 0x7F,0
	return
	endm
#endif
#ifdef __16F84A
bkpt	macro
	LOCAL _bkpt1
_bkpt1	
	bcf 0x48,7	;save GIE bit
	btfsc 11,7
	bsf 0x48,7
	bcf 11,7		;and disable interrupts
	movwf 0x4F	;save W
	movlw LOW _bkpt1	;save low address
	movwf 0x4D
	call _pbreak
	btfsc 0x48,7	;test if GIE should be set
	bsf 11,7		;and set if necessary
	endm
pb	macro
_pbreak
	bcf 0x48,6	;set 4 banks
	swapf 3,0		;load status into w
	movwf 0x4E	;save status
	swapf 0x4E,1	;Swap saved status the right way round	
	bcf 3,5		;Page 0
	bcf 6,7		;ensure 0 at RB7
	bcf 6,6		;ensure 0 at RB6
	movfw 4		;save fsr
	movwf 0x4C
	bcf 3,7		;Set Banks 0 and 1
	bsf 3,5		;Page 1
	bcf 6,7		;PortB, RB7 as output
	bsf 6,6		;PortB, RB6 as input
	bcf 3,5		;Page 0
_pblp0
	btfss 6,6		;first handshake on entry
	goto _pblp0
	bsf 6,7
_pblp1
	btfsc 6,6		;second handshake on entry
	goto _pblp1
	bcf 6,7	
_pblp2
	clrf 0x49	; set up for 2 banks of bytes
	clrf 4		;clear fsr
_pblp3
	clrwdt		;ensure no reset from wdt
	movfw 0		;move indf to w
	movwf 0x4B
	movlw b'11000000'	;set up for 8 bits
	andwf 0x48,1
_pblp4
	btfss 6,6		;test if PC ready to receive data
	goto _pblp4
	rlf 0x4B,1	;rotate msbit into carry
	skpnc
	bsf 6,7		;output 0 or 1 appropriate
	skpc
	bcf 6,7
_pblp5
	btfsc 6,6		;test if PC has received data
	goto _pblp5
	incf 0x48,1	;do 8 bits
	btfss 0x48,3
	goto _pblp4
	incf 4,1		;inc fsr to next byte
	decfsz 0x49,1	;do 256 bytes
	goto _pblp3
	btfsc 0x48,6	;test if 2 or 4 banks to be sent
	goto _pblp6	;goto set IRP if required 
	goto _pblp7	;goto out sequence
_pblp6
	bcf 0x48,6
	bsf 3,7		;Do Banks 2 & 3 if required
	goto _pblp2
_pblp7
	bcf 11,0		;prevent port change interrupts from PB
	bsf 3,5		;Page 1
	bsf 6,7		;PortB, RB7 as input
	bcf 3,5		;Page 0
	bcf 6,7		;prevent spurious writes to RB7
	movfw 0x4C	;restore fsr
	movwf 4
	swapf 0x4E,1
	swapf 0x4E,0	;restore status
	movwf 3
	swapf 0x4F,1	;restore w
	swapf 0x4F,0
	return
	endm
#endif
#ifdef __16F84
bkpt	macro
	LOCAL _bkpt1
_bkpt1	
	bcf 0x48,7	;save GIE bit
	btfsc 11,7
	bsf 0x48,7
	bcf 11,7		;and disable interrupts
	movwf 0x4F	;save W
	movlw LOW _bkpt1	;save low address
	movwf 0x4D
	call _pbreak
	btfsc 0x48,7	;test if GIE should be set
	bsf 11,7		;and set if necessary
	endm
pb	macro
_pbreak
	bcf 0x48,6	;set 4 banks
	swapf 3,0		;load status into w
	movwf 0x4E	;save status
	swapf 0x4E,1	;Swap saved status the right way round	
	bcf 3,5		;Page 0
	bcf 6,7		;ensure 0 at RB7
	bcf 6,6		;ensure 0 at RB6
	movfw 4		;save fsr
	movwf 0x4C
	bcf 3,7		;Set Banks 0 and 1
	bsf 3,5		;Page 1
	bcf 6,7		;PortB, RB7 as output
	bsf 6,6		;PortB, RB6 as input
	bcf 3,5		;Page 0
_pblp0
	btfss 6,6		;first handshake on entry
	goto _pblp0
	bsf 6,7
_pblp1
	btfsc 6,6		;second handshake on entry
	goto _pblp1
	bcf 6,7	
_pblp2
	clrf 0x49	; set up for 2 banks of bytes
	clrf 4		;clear fsr
_pblp3
	clrwdt		;ensure no reset from wdt
	movfw 0		;move indf to w
	movwf 0x4B
	movlw b'11000000'	;set up for 8 bits
	andwf 0x48,1
_pblp4
	btfss 6,6		;test if PC ready to receive data
	goto _pblp4
	rlf 0x4B,1	;rotate msbit into carry
	skpnc
	bsf 6,7		;output 0 or 1 appropriate
	skpc
	bcf 6,7
_pblp5
	btfsc 6,6		;test if PC has received data
	goto _pblp5
	incf 0x48,1	;do 8 bits
	btfss 0x48,3
	goto _pblp4
	incf 4,1		;inc fsr to next byte
	decfsz 0x49,1	;do 256 bytes
	goto _pblp3
	btfsc 0x48,6	;test if 2 or 4 banks to be sent
	goto _pblp6	;goto set IRP if required 
	goto _pblp7	;goto out sequence
_pblp6
	bcf 0x48,6
	bsf 3,7		;Do Banks 2 & 3 if required
	goto _pblp2
_pblp7
	bcf 11,0		;prevent port change interrupts from PB
	bsf 3,5		;Page 1
	bsf 6,7		;PortB, RB7 as input
	bcf 3,5		;Page 0
	bcf 6,7		;prevent spurious writes to RB7
	movfw 0x4C	;restore fsr
	movwf 4
	swapf 0x4E,1
	swapf 0x4E,0	;restore status
	movwf 3
	swapf 0x4F,1	;restore w
	swapf 0x4F,0
	return
	endm
#endif
#ifdef __16C84
bkpt	macro
	LOCAL _bkpt1
_bkpt1	
	bcf 0x48,7	;save GIE bit
	btfsc 11,7
	bsf 0x48,7
	bcf 11,7		;and disable interrupts
	movwf 0x4F	;save W
	movlw LOW _bkpt1	;save low address
	movwf 0x4D
	call _pbreak
	btfsc 0x48,7	;test if GIE should be set
	bsf 11,7		;and set if necessary
	endm
pb	macro
_pbreak
	bcf 0x48,6	;set 4 banks
	swapf 3,0		;load status into w
	movwf 0x4E	;save status
	swapf 0x4E,1	;Swap saved status the right way round	
	bcf 3,5		;Page 0
	bcf 6,7		;ensure 0 at RB7
	bcf 6,6		;ensure 0 at RB6
	movfw 4		;save fsr
	movwf 0x4C
	bcf 3,7		;Set Banks 0 and 1
	bsf 3,5		;Page 1
	bcf 6,7		;PortB, RB7 as output
	bsf 6,6		;PortB, RB6 as input
	bcf 3,5		;Page 0
_pblp0
	btfss 6,6		;first handshake on entry
	goto _pblp0
	bsf 6,7
_pblp1
	btfsc 6,6		;second handshake on entry
	goto _pblp1
	bcf 6,7	
_pblp2
	clrf 0x49	; set up for 2 banks of bytes
	clrf 4		;clear fsr
_pblp3
	clrwdt		;ensure no reset from wdt
	movfw 0		;move indf to w
	movwf 0x4B
	movlw b'11000000'	;set up for 8 bits
	andwf 0x48,1
_pblp4
	btfss 6,6		;test if PC ready to receive data
	goto _pblp4
	rlf 0x4B,1	;rotate msbit into carry
	skpnc
	bsf 6,7		;output 0 or 1 appropriate
	skpc
	bcf 6,7
_pblp5
	btfsc 6,6		;test if PC has received data
	goto _pblp5
	incf 0x48,1	;do 8 bits
	btfss 0x48,3
	goto _pblp4
	incf 4,1		;inc fsr to next byte
	decfsz 0x49,1	;do 256 bytes
	goto _pblp3
	btfsc 0x48,6	;test if 2 or 4 banks to be sent
	goto _pblp6	;goto set IRP if required 
	goto _pblp7	;goto out sequence
_pblp6
	bcf 0x48,6
	bsf 3,7		;Do Banks 2 & 3 if required
	goto _pblp2
_pblp7
	bcf 11,0		;prevent port change interrupts from PB
	bsf 3,5		;Page 1
	bsf 6,7		;PortB, RB7 as input
	bcf 3,5		;Page 0
	bcf 6,7		;prevent spurious writes to RB7
	movfw 0x4C	;restore fsr
	movwf 4
	swapf 0x4E,1
	swapf 0x4E,0	;restore status
	movwf 3
	swapf 0x4F,1	;restore w
	swapf 0x4F,0
	return
	endm
#endif
#ifdef __16F83
bkpt	macro
	LOCAL _bkpt1
_bkpt1	
	bcf 0x28,7	;save GIE bit
	btfsc 11,7
	bsf 0x28,7
	bcf 11,7		;and disable interrupts
	movwf 0x2F	;save W
	movlw LOW _bkpt1	;save low address
	movwf 0x2D
	call _pbreak
	btfsc 0x28,7	;test if GIE should be set
	bsf 11,7		;and set if necessary
	endm
pb	macro
_pbreak
	bcf 0x28,6	;set 4 banks
	swapf 3,0		;load status into w
	movwf 0x2E	;save status
	swapf 0x2E,1	;Swap saved status the right way round	
	bcf 3,5		;Page 0
	bcf 6,7		;ensure 0 at RB7
	bcf 6,6		;ensure 0 at RB6
	movfw 4		;save fsr
	movwf 0x2C
	bcf 3,7		;Set Banks 0 and 1
	bsf 3,5		;Page 1
	bcf 6,7		;PortB, RB7 as output
	bsf 6,6		;PortB, RB6 as input
	bcf 3,5		;Page 0
_pblp0
	btfss 6,6		;first handshake on entry
	goto _pblp0
	bsf 6,7
_pblp1
	btfsc 6,6		;second handshake on entry
	goto _pblp1
	bcf 6,7	
_pblp2
	clrf 0x29	; set up for 2 banks of bytes
	clrf 4		;clear fsr
_pblp3
	clrwdt		;ensure no reset from wdt
	movfw 0		;move indf to w
	movwf 0x2B
	movlw b'11000000'	;set up for 8 bits
	andwf 0x28,1
_pblp4
	btfss 6,6		;test if PC ready to receive data
	goto _pblp4
	rlf 0x2B,1	;rotate msbit into carry
	skpnc
	bsf 6,7		;output 0 or 1 appropriate
	skpc
	bcf 6,7
_pblp5
	btfsc 6,6		;test if PC has received data
	goto _pblp5
	incf 0x28,1	;do 8 bits
	btfss 0x28,3
	goto _pblp4
	incf 4,1		;inc fsr to next byte
	decfsz 0x29,1	;do 256 bytes
	goto _pblp3
	btfsc 0x28,6	;test if 2 or 4 banks to be sent
	goto _pblp6	;goto set IRP if required 
	goto _pblp7	;goto out sequence
_pblp6
	bcf 0x28,6
	bsf 3,7		;Do Banks 2 & 3 if required
	goto _pblp2
_pblp7
	bcf 11,0		;prevent port change interrupts from PB
	bsf 3,5		;Page 1
	bsf 6,7		;PortB, RB7 as input
	bcf 3,5		;Page 0
	bcf 6,7		;prevent spurious writes to RB7
	movfw 0x2C	;restore fsr
	movwf 4
	swapf 0x2E,1
	swapf 0x2E,0	;restore status
	movwf 3
	swapf 0x2F,1	;restore w
	swapf 0x2F,0
	return
	endm
#endif

