 #ifdef notdefined

;	RCS Header $Id: fxm88.a16 2.3 1996/10/16 14:23:23 F.J.Testa Exp $

;	$Revision: 2.3 $

;       8x8 PIC16 FIXED POINT MULTIPLY ROUTINES
;
;       Input:  fixed point arguments in AARG and BARG
;
;       Output: product AARGxBARG in AARG
;
;       All timings are worst case cycle counts
;
;       It is useful to note that the additional unsigned routines requiring a non-power of two
;       argument can be called in a signed multiply application where it is known that the
;       respective argument is nonnegative, thereby offering some improvement in
;       performance.
;
;         Routine            Clocks     Function
;
;       FXM0808S     82 08x08 -> 16 bit signed fixed point multiply
;
;       FXM0808U     73 08x08 -> 16 bit unsigned fixed point multiply
;
;       FXM0707U     67 07x07 -> 14 bit unsigned fixed point multiply
;
;       The above timings are based on the looped macros. If space permits,
;       approximately 29-35 clocks can be saved by using the unrolled macros.
;

;**********************************************************************************************


;**********************************************************************************************

;       08x08 Bit Multiplication Macros

SMUL0808L        macro

;       Max Timing:     3+10+5*9+8+3 = 69 clks

;       Min Timing:     3+6*6+5+3 = 47 clks

;       PM: 21            DM: 5

                MOVLW   0x07
                MOVWF   LOOPCOUNT

                MOVF    AARGB0,W

LOOPSM0808A
		RRF	BARGB0, F
                BTFSC   _C
                GOTO    LSM0808NA
		DECFSZ	LOOPCOUNT, F
                GOTO    LOOPSM0808A

                CLRF    AARGB0
                RETLW   0x00

LOOPSM0808
		RRF	BARGB0, F
                BTFSC   _C
		ADDWF	AARGB0, F
LSM0808NA	RLF    SIGN, F
		RRF    AARGB0, F
		RRF    AARGB1, F
		DECFSZ	LOOPCOUNT, F
                GOTO    LOOPSM0808

		RLF    SIGN, F
		RRF    AARGB0, F
		RRF    AARGB1, F


                endm



UMUL0808L        macro

;       Max Timing:     3+12+6*8+7 = 70 clks

;       Min Timing:     3+7*6+5+3 = 53 clks

;       PM: 19            DM: 4

                MOVLW   0x08
                MOVWF   LOOPCOUNT
                MOVF    AARGB0,W

LOOPUM0808A
                RRF     BARGB0, F
                BTFSC   _C
                GOTO    LUM0808NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM0808A

                CLRF    AARGB0
                RETLW   0x00

LUM0808NAP
                BCF     _C
                GOTO    LUM0808NA

LOOPUM0808
                RRF             BARGB0, F
                BTFSC   _C
                ADDWF   AARGB0, F
LUM0808NA       RRF    AARGB0, F
                RRF    AARGB1, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPUM0808

                endm

;**********************************************************************************************
  #ifdef notdefined	;ttttttttttttttttttttttttt      
;       8x8 Bit Signed Fixed Point Multiply 8x8 -> 16

;       Input:  8 bit signed fixed point multiplicand in AARGB0
;                       8 bit signed fixed point multiplier in BARGB0

;       Use:    CALL    FXM0808S

;       Output: 16 bit signed fixed point product in AARGB0 (hi) AARGB1 (lo)

;       Result: AARG  <--  AARG x BARG

;       Max Timing:     12+69+2 = 83 clks                B > 0
;                       17+69+2 = 88 clks                B < 0

;       Min Timing:     12+47 = 59 clks
;			6 clks				 A = 0

;       PM: 17+21+1 = 39              DM: 5

FXM0808S	CLRF	AARGB1          ; clear partial product
		CLRF	SIGN
		MOVF	AARGB0,W
		BTFSC	_Z
		RETLW	0x00
		
		XORWF	BARGB0,W
		MOVWF	TEMPB3
		BTFSC	TEMPB3,MSB
		COMF	SIGN, F


	        BTFSS   BARGB0,MSB
                GOTO    M0808SOK
		COMF	BARGB0, F      ; make multiplier BARG > 0
		INCF	BARGB0, F
		COMF	AARGB0, F
		INCF	AARGB0, F

		BTFSC	BARGB0,MSB
		GOTO	M0808SX

M0808SOK

                SMUL0808L

                RETLW	0x00

M0808SX		CLRF	AARGB1
		RLF	SIGN, W
		RRF	AARGB0, F
		RRF	AARGB1, F

		RETLW	0x00
;**********************************************************************************************
        
;       8x8 Bit Unsigned Fixed Point Multiply 8x8 -> 16

;       Input:  8 bit unsigned fixed point multiplicand in AARGB0
;               8(DW ??) bit unsigned fixed point multiplier in BARGB0

;       Use:    CALL    FXM0808U

;       Output: 8 bit unsigned fixed point product in AARGB0

;       Result: AARG  <--  AARG x BARG

;       Max Timing:     1+70+2 = 73 clks

;       Min Timing:     1+53 = 54 clks

;       PM: 1+19+1 = 21              DM: 4

FXM0808U        CLRF    AARGB1          ; clear partial product

                UMUL0808L

                RETLW           0x00
 #endif	;ttttttttttttttttttttttttttttttttt
;**********************************************************************************************

UDIV1608L  macro

;       Max Timing: 2+7*12+11+3+7*24+23 = 291 clks

;       Min Timing: 2+7*11+10+3+7*17+16 = 227 clks

;       PM: 39                                  DM: 7

                MOVLW           8
                MOVWF           LOOPCOUNT

LOOPU1608A      RLF             AARGB0,W
                RLF             REMB0, F
                MOVF            BARGB0,W
                SUBWF           REMB0, F

                BTFSC           _C
                GOTO            UOK68A          
                ADDWF           REMB0, F
                BCF             _C
UOK68A          RLF             AARGB0, F

                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU1608A

                CLRF            TEMP

                MOVLW           8
                MOVWF           LOOPCOUNT

LOOPU1608B      RLF             AARGB1,W
                RLF             REMB0, F
                RLF             TEMP, F
                MOVF            BARGB0,W
                SUBWF           REMB0, F
                CLRF            AARGB5
                CLRW
                BTFSS           _C
                INCFSZ          AARGB5,W
                SUBWF           TEMP, F

                BTFSC           _C
                GOTO            UOK68B          
                MOVF            BARGB0,W
                ADDWF           REMB0, F
                CLRF            AARGB5
                CLRW
                BTFSC           _C
                INCFSZ          AARGB5,W
                ADDWF           TEMP, F

                BCF             _C
UOK68B          RLF             AARGB1, F

                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU1608B

                endm

;**********************************************************************************************
        
;       16/8 Bit Unsigned Fixed Point Divide 16/8 -> 16.08

;       Input:  16 bit unsigned fixed point dividend in AARGB0, AARGB1
;               8 bit unsigned fixed point divisor in BARGB0

;       Use:    CALL    FXD1608U

;       Output: 16 bit unsigned fixed point quotient in AARGB0, AARGB1
;               8 bit unsigned fixed point remainder in REMB0

;       Result: AARG, REM  <--  AARG / BARG

;       Max Timing:     1+291+2 = 294 clks

;       Min Timing:     1+227+2 = 230 clks

;       PM: 1+39+1 = 41         DM: 7

FXD1608U        CLRF            REMB0

                UDIV1608L

                RETLW           0x00

;**********************************************************************************************
#endif

