; LCDroutines.inc

;******** LCD ROUTINES **********

LCD1:   movlw %10000000
        goto LCDLIN
LCD12:  movlw %10001100
        goto LCDLIN
LCD21:  movlw %11000000
        goto LCDLIN
LCD26:  movlw %11000110
        goto LCDLIN
LCD2B:  movlw %11001011
        goto LCDLIN
LCD2E:  movlw %11001110
LCDLIN: BCF RSLINE,4

LCDOUT: movwf STORE
        movlw 50
        movwf LOOPA
DELAYIT: decfsz LOOPA,F
        goto DELAYIT
        call SENDIT

SENDIT: swapf STORE,F
        movf STORE,W
        andlw 15
        iorwf RSLINE,W
        movwf PORTD
        BSF PORTA,2
        nop 
        nop
        BCF PORTA,2
        RETURN

;*************

CLRLINE1: call LCD1     ;set address for line 1 cell 1
        bsf RSLINE,4    ;set RS for data send
        clrf LOOP       ;
CLRL1:  movlw ' '       ;clear cell
        call LCDOUT     ;
        incf LOOP,F     ;inc loop
        btfss LOOP,4    ;has last LCD letter been sent?
        goto CLRL1      ;no
        return

CLRLINE2: call LCD21
        bsf RSLINE,4
        movlw 16
        movwf LOOP
CL2:    movlw ' '
        call LCDOUT
        decfsz LOOP,F
        goto CL2
        return

SHOWHEX: clrf PCLATH
        call LCD12
        bsf RSLINE,4
        movf DIGIT4,W
        call LCDOUT
        movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        bsf PCLATH,3
        return

SHOWDEC: clrf PCLATH
        call LCD21
        bsf RSLINE,4
        movf DIGIT5,W
        call LCDOUT
        movf DIGIT4,W
        call LCDOUT
        movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        bsf PCLATH,3
        return

;****************

BIN2HEX: swapf COUNT1,W  ;get most significant nibble
        andlw 15
        movwf DIGIT4
        addlw 6
        btfss STATUS,DC
        goto BIN2
        movf DIGIT4,W
        addlw 55        ;set as alpha
        goto BIN3
BIN2:   movf DIGIT4,W
        iorlw 48        ;set as numeral
BIN3:   movwf DIGIT4
        movf COUNT1,W  ;get next significant nibble
        andlw 15
        movwf DIGIT3
        addlw 6
        btfss STATUS,DC
        goto BIN4
        movf DIGIT3,W
        addlw 55        ;set as alpha
        goto BIN5
BIN4:   movf DIGIT3,W
        iorlw 48        ;set as numeral
BIN5:   movwf DIGIT3
        swapf COUNT0,W  ;get next significant nibble
        andlw 15
        movwf DIGIT2
        addlw 6
        btfss STATUS,DC
        goto BIN6
        movf DIGIT2,W
        addlw 55        ;set as alpha
        goto BIN7
BIN6:   movf DIGIT2,W
        iorlw 48        ;set as numeral
BIN7:   movwf DIGIT2
        movf COUNT0,W  ;get least significant nibble
        andlw 15
        movwf DIGIT1
        addlw 6
        btfss STATUS,DC
        goto BIN8
        movf DIGIT1,W
        addlw 55        ;set as alpha
        goto BIN9
BIN8:   movf DIGIT1,W
        iorlw 48        ;set as numeral
BIN9:   movwf DIGIT1
        return



