VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form frmMain 
   BackColor       =   &H00C0C0C0&
   Caption         =   "18F MPASM preprocessor"
   ClientHeight    =   5910
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   4140
   LinkTopic       =   "Form1"
   ScaleHeight     =   5910
   ScaleWidth      =   4140
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdGo 
      Caption         =   "Go"
      Enabled         =   0   'False
      Height          =   555
      Left            =   2400
      Style           =   1  'Graphical
      TabIndex        =   3
      Top             =   0
      Width           =   495
   End
   Begin VB.CommandButton cmdMPASM 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Launch MPASM"
      Enabled         =   0   'False
      Height          =   555
      Left            =   3000
      Style           =   1  'Graphical
      TabIndex        =   1
      Top             =   0
      Width           =   915
   End
   Begin VB.TextBox Text1 
      Height          =   4815
      Left            =   120
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   0
      Top             =   840
      Width           =   3855
   End
   Begin MSComDlg.CommonDialog dlgCommonDialog 
      Left            =   240
      Top             =   5280
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin MSComctlLib.ImageList imlToolbarIcons 
      Left            =   1320
      Top             =   5400
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   12632256
      _Version        =   393216
      BeginProperty Images {2C247F25-8591-11D1-B16A-00C0F0283628} 
         NumListImages   =   13
         BeginProperty ListImage1 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0000
            Key             =   "New"
         EndProperty
         BeginProperty ListImage2 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0112
            Key             =   "Open"
         EndProperty
         BeginProperty ListImage3 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0224
            Key             =   "Save"
         EndProperty
         BeginProperty ListImage4 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0336
            Key             =   "Print"
         EndProperty
         BeginProperty ListImage5 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0448
            Key             =   "Cut"
         EndProperty
         BeginProperty ListImage6 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":055A
            Key             =   "Copy"
         EndProperty
         BeginProperty ListImage7 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":066C
            Key             =   "Paste"
         EndProperty
         BeginProperty ListImage8 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":077E
            Key             =   "Bold"
         EndProperty
         BeginProperty ListImage9 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0890
            Key             =   "Italic"
         EndProperty
         BeginProperty ListImage10 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":09A2
            Key             =   "Underline"
         EndProperty
         BeginProperty ListImage11 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0AB4
            Key             =   "Align Left"
         EndProperty
         BeginProperty ListImage12 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0BC6
            Key             =   "Center"
         EndProperty
         BeginProperty ListImage13 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0CD8
            Key             =   "Align Right"
         EndProperty
      EndProperty
   End
   Begin VB.Label Label1 
      Caption         =   "Check MPASM file.  Warnings output to <filename.err>"
      Height          =   495
      Left            =   120
      TabIndex        =   2
      Top             =   120
      Width           =   2295
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileOpen 
         Caption         =   "&Open..."
      End
      Begin VB.Menu mnuFileClose 
         Caption         =   "&Close"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelpContents 
         Caption         =   "&Contents"
      End
      Begin VB.Menu mnuHelpBar0 
         Caption         =   "-"
      End
      Begin VB.Menu mnuHelpAbout 
         Caption         =   "&About "
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim filename As String          ' path to the .asm file
Dim mpasmpath As String         ' path to mpasmwin.exe

Private Declare Function OSWinHelp% Lib "user32" Alias "WinHelpA" (ByVal hwnd&, ByVal HelpFile$, ByVal wCommand%, dwData As Any)

Private Sub cmdGo_Click()
ParseFile filename
End Sub
' Launch MPASM
Private Sub cmdMPASM_Click()
Dim taskid

If (mpasmpath <> "") Then
    On Error Resume Next        ' disable error handling
    taskid = Shell(mpasmpath, vbNormalFocus)
    On Error GoTo 0             ' default error handling
    If (taskid = 0) Then
        MsgBox ("Can't run " & mpasmpath)
        mpasmpath = ""
        cmdMPASM.Enabled = False        ' disable button
        cmdMPASM.BackColor = &HC0C0C0   ' grey
    End If
End If
End Sub
' Executed when program loads
Private Sub Form_Load()

' read settings from the Registry
' HK_CURRENT_USER/software/VB and VBA program settings/prempasm/settings

    filename = GetSetting(App.Title, "Settings", "Filename", "")
    mpasmpath = GetSetting(App.Title, "Settings", "MpasmPath", "")
    If (mpasmpath <> "") Then
        cmdMPASM.Enabled = True        ' enable launch MPASM button
        cmdMPASM.BackColor = &HC0C0FF  ' pink
    Else
        ' initiate dialogue to set the MPASM path
        If MsgBox("Your MPASM path is not set" & vbCrLf & _
        "Please navigate to mpasmwin.exe in the box which follows", _
        vbOKCancel, "MPASM path setup") = vbOK Then
           With dlgCommonDialog
             .DialogTitle = "Set MPASM path"
             .Filter = "Exe Files (*.exe)|*.exe"
             .filename = ""
             .Flags = cdlOFNHideReadOnly Or cdlOFNFileMustExist
             .ShowOpen
             If Len(.filename) > 0 Then
                mpasmpath = .filename
                cmdMPASM.Enabled = True
                cmdMPASM.BackColor = &HC0C0FF    ' pink
             End If
           End With
       End If
    End If
    
    If (filename <> "") Then
       cmdGo.Enabled = True
       cmdGo.BackColor = &HC0FFC0    ' green
    End If
    ' set window size to previous or default values
    Me.Left = GetSetting(App.Title, "Settings", "MainLeft", 2310)
    Me.Top = GetSetting(App.Title, "Settings", "MainTop", 2010)
    Me.Width = GetSetting(App.Title, "Settings", "MainWidth", 4230)
    Me.Height = GetSetting(App.Title, "Settings", "MainHeight", 6465)
End Sub

' Program close
Private Sub Form_Unload(Cancel As Integer)
    Dim i As Integer
    'close all sub forms
    For i = Forms.Count - 1 To 1 Step -1
        Unload Forms(i)
    Next
    ' save current settings in Registry
    SaveSetting App.Title, "Settings", "Filename", filename
    SaveSetting App.Title, "Settings", "MpasmPath", mpasmpath
    If Me.WindowState <> vbMinimized Then
        SaveSetting App.Title, "Settings", "MainLeft", Me.Left
        SaveSetting App.Title, "Settings", "MainTop", Me.Top
        SaveSetting App.Title, "Settings", "MainWidth", Me.Width
        SaveSetting App.Title, "Settings", "MainHeight", Me.Height
    End If
End Sub
Private Sub mnuHelpAbout_Click()
    MsgBox "Version " & App.Major & "." & App.Minor & "." & App.Revision
End Sub

Private Sub mnuHelpSearchForHelpOn_Click()

End Sub

Private Sub mnuHelpContents_Click()
    Dim nRet As Integer


    'if there is no helpfile for this project display a message to the user
    'you can set the HelpFile for your application in the
    'Project Properties dialog
    If Len(App.HelpFile) = 0 Then
        MsgBox "Looking for help?  Not a chance!", vbInformation, Me.Caption
    Else
        On Error Resume Next
        nRet = OSWinHelp(Me.hwnd, App.HelpFile, 3, 0)
        If Err Then
            MsgBox Err.Description
        End If
    End If

End Sub


Private Sub mnuFileExit_Click()
    'unload the form
    Unload Me

End Sub

Private Sub mnuFileClose_Click()
    'ToDo: Add 'mnuFileClose_Click' code.
    ' MsgBox "Add 'mnuFileClose_Click' code."
End Sub
' Open .asm file dialogue
Private Sub mnuFileOpen_Click()
    With dlgCommonDialog
        .DialogTitle = "Open"
        .CancelError = True
        On Error GoTo ErrHandler
       
        .Filter = "MPASM Files (*.asm)|*.asm"
        .filename = filename
        .Flags = cdlOFNHideReadOnly Or cdlOFNFileMustExist
        .ShowOpen
        If Len(.filename) = 0 Then
            Exit Sub
        End If
        filename = .filename
        cmdGo.Enabled = True
        cmdGo.BackColor = &HC0FFC0    ' green
    End With
    ParseFile filename
    
ErrHandler:
  'User pressed the Cancel button
  Exit Sub
End Sub

Private Sub mnuFileNew_Click()
    'ToDo: Add 'mnuFileNew_Click' code.
    MsgBox "Add 'mnuFileNew_Click' code."
End Sub

' This does all the work

Private Sub ParseFile(ByVal lclfilename As String)
Dim thisline As String      ' current assembler file line
Dim wstr As String          ' a working string
Dim label As String         ' statement label
Dim opcode As String        ' statement opcode
Dim args As String          ' statement arguments
Dim pos As Integer          ' position wkg var
Dim lineno As Integer       ' line number of current line
Dim linelen As Integer      ' line length
Dim col1_is_space As Boolean
Dim error As Boolean        ' error flag
Dim warningscount As Integer   ' total warnings

    lineno = 0
    warningscount = 0
    Text1.Text = ""
    Text1.Text = lclfilename & vbCrLf
    Text1.Refresh
    On Error GoTo Openerr
    Open filename For Input As #1
    On Error GoTo 0             ' cancel error handler
    pos = InStr(lclfilename, ".")
    wstr = Left(lclfilename, pos)
    wstr = wstr & "err"
    Open wstr For Output As #2          ' .err listing file
    
    While Not EOF(1)
        Line Input #1, thisline         ' read next line
        lineno = lineno + 1
        wstr = Replace(thisline, Chr(9), " ")   ' convert tabs to spaces
        thisline = LCase(wstr)           ' wstr needed else replace doesn't work

' need to distinguish between two fields which are either a label and a mnemonic
' with no args, or else a mnemonic with one arg
' just assume labels start in col 1

        If Mid(thisline, 1, 1) = " " Then
            col1_is_space = True
        Else
            col1_is_space = False
        End If
            
        thisline = Trim(thisline)       ' remove leading and trailing spaces
   
        pos = InStr(thisline, ";")      ' chuck away comments
        If (pos > 0) Then thisline = Left(thisline, pos - 1)
        If thisline = "" Then GoTo continue     ' chuck away blank lines
        thisline = thisline & " "       ' stick one space on the end for parsing

        label = ""          ' split up what remains of thisline into these strings
        opcode = ""
        args = ""
       
        ' label
        linelen = Len(thisline)
        If ((linelen > 0) And (col1_is_space = False)) Then
            pos = InStr(thisline, " ")
            label = Left(thisline, pos)
            wstr = Right(thisline, linelen - pos)
            thisline = LTrim(wstr)
            linelen = Len(thisline)
        Else
        End If
        
        ' opcode
        If linelen > 0 Then
            pos = InStr(thisline, " ")
            opcode = Left(thisline, pos)
            wstr = Right(thisline, linelen - pos)
            thisline = LTrim(wstr)
            linelen = Len(thisline)
        Else
        End If
     
        If linelen > 0 Then args = thisline     ' anything left is args
     
' just a label on its own - ignore it
        If ((col1_is_space = False) And (args = "") And (opcode = "")) Then GoTo continue

' bash all the spaces out
        
        wstr = args
        args = Replace(wstr, " ", "")
        wstr = opcode
        opcode = Replace(wstr, " ", "")
        linelen = Len(args)
        error = False

' now look at all the cases

' these take 3 args d,f,a
       Select Case opcode
        Case "addwf", "addwfc", "andwf", "comf", "decf", "decfsz", "dcfsnz", "incf", _
        "incfsz", "infsnz", "iorwf", "movf", "rlcf", "rlncf", "rrcf", "rrncf", _
        "subfwb", "subwf", "subwfb", "swapf", "xorwf"
        
            pos = InStr(args, ",")
            If pos = 0 Then
                error = True
                GoTo err1
            End If
            wstr = Mid(args, pos + 1, 1)
            If ((wstr <> "f") And (wstr <> "w")) Then
                error = True
                GoTo err1
            End If
            args = Right(args, linelen - pos)
            pos = InStr(args, ",")
            If pos = 0 Then
                error = True
                GoTo err1
            End If
            wstr = Mid(args, pos + 1, 1)
            If ((wstr <> "a") And (wstr <> "b")) Then error = True
         
err1:
            If (error) Then
                Text1.Text = Text1.Text & "line " & lineno & " " & opcode & " takes 3 args" _
                & Chr(13) & Chr(10)
                Print #2, "line "; lineno; " "; opcode; " takes 3 args"
                warningscount = warningscount + 1
            End If
                
' this lot take 2 args f,a

        Case "clrf", "cpfseq", "cpfsgt", "cpfslt", "movwf", "mulwf", "negf", _
        "setf", "tstfsz"
                
            pos = InStr(args, ",")
            If pos = 0 Then
                error = True
                GoTo err2
            End If
            wstr = Mid(args, pos + 1, 1)
            If ((wstr <> "a") And (wstr <> "b")) Then
                error = True
                GoTo err2
            End If
                
err2:
            If (error) Then
                Text1.Text = Text1.Text & "line " & lineno & " " & opcode & " takes 2 args" _
                & Chr(13) & Chr(10)
                Print #2, "line "; lineno; " "; opcode; " takes 2 args"
                warningscount = warningscount + 1
            End If
                
' these take 3 args f,b,a   but can't validate b easily

       Case "bcf", "bsf", "btfsc", "btfss", "btg"
            pos = InStr(args, ",")
            If pos = 0 Then
                error = True
                GoTo err3
            End If
            args = Right(args, linelen - pos)
            pos = InStr(args, ",")
            If pos = 0 Then
                error = True
                GoTo err3
            End If
            wstr = Mid(args, pos + 1, 1)
            If ((wstr <> "a") And (wstr <> "b")) Then error = True
         
err3:
            If (error) Then
                Text1.Text = Text1.Text & "line " & lineno & " " & opcode & _
                " takes 3 args" & Chr(13) & Chr(10)
                Print #2, "line "; lineno; " "; opcode; " takes 3 args"
                warningscount = warningscount + 1
            End If
        
' these take 0 args.

        Case "clrwdt", "daw", "nop", "pop", "push", "reset", _
        "sleep", "tblrd*", "tblrd*+", "tblrd*-", "tblrd+*", _
        "tblwt*", "tblwt*+", "tblwt*-", "tblwt+*", "endm", "end"
            If (args <> "") Then        ' shouldn't be any args
                Text1.Text = Text1.Text & "line " & lineno & " " & opcode & _
                " takes 0 args" & Chr(13) & Chr(10)
                Print #2, "line "; lineno; " "; opcode; " takes 0 args"
                warningscount = warningscount + 1

            End If
            
' these take exactly 1 arg

        Case "bc", "bnc", "bn", "bnn", "bnov", "bnz", "bov", "bra", "bz", _
        "goto", "rcall", "addlw", "andlw", "iorlw", "movlb", _
        "movlw", "mullw", "retlw", "sublw", "xorlw", "include", _
        "org", "equ"
            ' must have args
            If (args = "") Then
                error = True
                GoTo err4
            End If
         
           ' shouldn't be a "," in the args
            pos = InStr(args, ",")
            If pos <> 0 Then
                error = True
                GoTo err4
            End If
  
err4:
            If (error) Then
                Text1.Text = Text1.Text & "line " & lineno & " " & opcode & _
                " takes 1 arg" & Chr(13) & Chr(10)
                Print #2, "line "; lineno; " "; opcode; " takes 1 arg"
                warningscount = warningscount + 1
            End If
  
' these take variable no of args, and/or are hard to validate.
' Hopefully MPASM will spot errors here

        Case "call", "retfie", "movff", "return", "lfsr", _
        "include", "__config", "macro", "list", "de", "db", _
        "enter_critical_section", "leave_critical_section"
         
        ' do nothing
        
' what's this then?
        
        Case Else
            Text1.Text = Text1.Text & "line " & lineno & " " & opcode & " unknown" _
            & Chr(13) & Chr(10)
            warningscount = warningscount + 1
            Print #2, "line "; lineno; " "; opcode; " unknown"
            
        End Select
        
continue:

    Wend
Text1.Text = Text1.Text & "Done " & warningscount & " warning"
If (warningscount <> 1) Then Text1.Text = Text1.Text & "s"
Text1.Text = Text1.Text & vbCrLf
Print #2,
Print #2, "Total "; warningscount; "warnings"
Close #1
Close #2
Exit Sub
    
' open input .asm file error
Openerr:
MsgBox ("File " & lclfilename & " can't be opened")
filename = ""
cmdGo.Enabled = False
cmdGo.BackColor = &HC0C0C0
End Sub
