; tp3.asm
; Test for 18F242 (but should run on any 18FXX2)
; RC Osc
; connect led/resistor to ground on RA0 and RA1
; input 5v sq waves from signal generator on RB5
; flashes 2 leds - RA0 with high priority interrupts from TMR0
; RA1 with low priority interrupts from RB5

; Malcolm Wiles, 8 Mar 05


        LIST    p=18f242,r=dec

	include P18F242.inc
 
B	equ	1
F 	equ	1


	__config H'300000', H'00'		; config
	__config H'300001', H'23'		; config
	__config H'300002', H'08'		; config
	__config H'300003', H'00'		; config
	__config H'300004', H'00'		; config
	__config H'300005', H'00'		; config
	__config H'300006', H'80'		; config
	__config H'300007', H'00'		; config
	__config H'300008', H'0F'		; config
	__config H'300009', H'C0'		; config
	__config H'30000A', H'0F'		; config
	__config H'30000B', H'E0'		; config
	__config H'30000C', H'0F'		; config
	__config H'30000D', H'40'		; config


 ;  Vars (bank 0)

TEMP1	equ	0x0
TEMP2	equ	0x1

BSAVE	equ	0x2		; lo priority ISR context save area
WSAVE	equ	0x3
SSAVE	equ	0x4

SOFTB	equ	0x5		; RB soft copy
BPORT	equ	0x6		; RB working copy

; code

	org	0		; reset vector
	goto	init
	
	org	0008h		; hi interrupt vector
	bra	isrhi
	org	0018h
	bra	isrlo		; lo interrupt vector

; initialise PIC

	org	0020h	
init:	
	movlb	15		; set bank 15 (illustrate banked addressing)
	movlw	b'00100000'	; RB5 input	
	movwf	TRISB,B
	movlb	1		; set bank 1

; Timer 0 setup

	movlw	0xF8		; clear prescale bits
	andwf	T0CON,F,A		
	movlw	7		; prescale /128
	iorwf	T0CON,F,A
	bcf	T0CON,PSA,A	; assign prescaler
	bsf	T0CON,T08BIT,A	; 8 bit mode
	bcf	T0CON,T0CS,A	; timer mode
	clrf	TMR0H,A		; clear counter hi byte latch
	clrf	TMR0L,A		; clear counter	

; set up PORTA 

	movlw	6
	movwf	ADCON1,A	; all PORTA digital I/O
	clrf	TRISA,A		; all PORTA outputs
	movlw	0xFF
	movwf	LATA,A		; set PORTA latches

; data initialisation

	clrf	TEMP1,A
	clrf	TEMP2,A
	movf	PORTB,W,A
	movwf	SOFTB,A		; soft copy of PORTB

; set up interrupts

	bcf	INTCON,INT0IF,A	; ensure INT0 is clear
	bcf	INTCON,RBIF,A	; ensure RBIF clear

	bsf	INTCON2,TMR0IP,A	; set TMR0 hi priority
	bcf	INTCON2,RBIP,A	; set RB change low priority

	bsf	INTCON,T0IE,A	; enable TMR0 interrupt
	bsf	INTCON,RBIE,A	; enable RB change interrupt
	bsf	RCON,IPEN,A	; enable priority interrupts
	bsf	INTCON,GIEH,A	; enable hi priority interrupts
	bsf	INTCON,GIEL,A	; enable lo priority interrupts

; main loop
; tests whether interrupts have corrupted W
; stops leds flashing if so

main:
	movlw	1		; add 1 to temp1
	addwf	TEMP1,F,A
	nop
; if the isrs are failing to preserve W, sooner or later there'll be an interrupt
; here which will make temp1 != temp2
	nop
	addwf	TEMP2,F,A	; and to temp2
	movf	TEMP1,W,A
	xorwf	TEMP2,W,A	; temp1 should = temp2
	bz	main		; Z is set if they are equal
	bcf	INTCON,GIEH,A	; if not, stop led flashing
	bra	main


; hi priority interrupt service routine 

isrhi:
	movlw	3		; deliberately corrupt W

; timer interrupt

	btfss	INTCON, T0IF, A	; test if TMR0 int
	bra	hi_exit		; not a TMR0 int
	
	bcf	INTCON, T0IF, A	; clear the interrupt
	btg	LATA,0,A	; toggle bit to flash RA0 led on/off
hi_exit:
	retfie	FAST		; exit isr with automatic context reload

; lo priority interrupt service routine

isrlo:
	movwf	WSAVE,A		; save context
	movff	STATUS,SSAVE
	movff	BSR, BSAVE

	btfss	INTCON,RBIF,A	; RBIF interrupt?
	bra	lo_exit		; no
	
	movf	PORTB,W,A	; clear mismatch condition
	bcf	INTCON,RBIF,A	; clear the interrupt
	movwf	BPORT,A		; save a wkg copy
	xorwf	SOFTB,W,A	; sets bits in W where changes from last value read
	andlw	b'00100000'	; are there changes in RB5?
	bz	lo_exit		; no
	btg	LATA,1,A	; flash led on RA1
	movff	BPORT,SOFTB	; update PORTB soft copy		
lo_exit:
	movff	BSAVE,BSR	; restore context
	movff	SSAVE,STATUS
	movf	WSAVE,W,A
	retfie
 
	END
