;PICKEY50.ASM 13JUL00 - JOHN BECKER - EPE PIC + KEYPAD DEMO

#DEFINE PAGE0   BCF $03,5
#DEFINE PAGE1   BSF $03,5

OPTION: .EQU $01
PCL:    .EQU $02              
STATUS: .EQU $03
PORTA:  .EQU $05
TRISA:  .EQU $05
PORTB:  .EQU $06
TRISB:  .EQU $06
INTCON: .EQU $0B

LOOP:   .EQU $0C   ;general loop
LOOPA:  .EQU $0D   ;loop for LCD routine
CLKCNT: .EQU $0E   ;counter for PAUSE val
STORE:  .EQU $0F   ;temporary store
COL:    .EQU $10   ;column counter (inc in decimal)
ROW:    .EQU $11   ;row counter (inc as matrix val)
ANSWER: .EQU $12   ;holds final keyed answer
RSLINE: .EQU $13   ;RS line of LCD

W:      .EQU 0
F:      .EQU 1
Z:      .EQU 2                
C:      .EQU 0
MATRIX  .EQU 4     ;matrix quantity value
                   ;set as 3 for (3 x 4)
                   ; or as 4 for (4 x 4)

        .ORG $04
        GOTO 5
        .ORG $05
        clrf PORTA
        clrf PORTB
        PAGE1
        clrf TRISA        ;set PORTA as outputs
        clrf TRISB        ;set PORTB as outputs
        movlw %00000110   ;pull-up Rs on (bit 7), timer 1/25 sec
        movwf OPTION      ;(for 3.2768MHz xtal)
        PAGE0
        goto SETUP

TABLCD: ADDWF PCL,F       ;LCD initialisation commands
        retlw %00110011
        retlw %00110011
        retlw %00110010
        retlw %00101100
        retlw %00000110
        retlw %00001100
        retlw %00000001
        retlw %00000010

TABLE1: ADDWF PCL,F       ;demo label line
        retlw 'C'
        retlw 'O'
        retlw 'L'
        retlw ' '
        retlw 'R'
        retlw 'O'
        retlw 'W'
        retlw ' '
        retlw 'V'
        retlw 'A'
        retlw 'L'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '

VALUE:  ADDWF PCL,F       ;lookup table for key allocation
        retlw '0'
        retlw '1'
        retlw '2'
        retlw '3'
        retlw '4'
        retlw '5'
        retlw '6'
        retlw '7'
        retlw '8'
        retlw '9'
        retlw 'A'
        retlw 'B'
        retlw 'C'
        retlw 'D'
        retlw 'E'
        retlw 'F'

SETUP:  call PAUSIT       ;pause to allow LCD to stabilise
LCDSET: clrf LOOP         ;LCD setup routine
        clrf RSLINE
LCDST2: movf LOOP,W
        call TABLCD
        call LCDOUT
        incf LOOP,F
        btfss LOOP,3
        goto LCDST2
        call PAUSIT       ;pause to allow LCD to stabilise

LCDMSG: clrf LOOP         ;line 1 message routine
        call LCD1
        bsf RSLINE,4
LCDMS2: movf LOOP,W
        call TABLE1
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto LCDMS2

        PAGE1             ;set RB0-RB3 as inputs
        movlw 15
        movwf TRISB
        PAGE0

MAINPROG: call GETKEY
          goto MAINPROG

;..........GET KEYPAD VAL ROUTINE........

GETKEY:  clrf PORTA       ;all PORTA low
         nop              ;pause to allow PORTA to stabilise
         comf PORTB,W     ;get & invert PORTB
         andlw 15         ;isolate bits 0-3
         btfsc STATUS,Z   ;is result NOT zero (keys pressed)?
         return           ;no, so return to main prog

         movlw %00000111  ;yes, a key is pressed so get it
         movwf PORTA      ;initial val for PORTA
         clrf COL

GK2:     comf PORTB,W     ;get & invert PORTB
         andlw 15         ;isolate bits 0-3
         btfss STATUS,Z   ;is result NOT zero (keys pressed)?
         goto GK3         ;yes
         incf COL,F       ;no, inc col val
         rrf PORTA,F      ;rotate PORTA right
         btfsc STATUS,C   ;is Carry zero?
         goto GK2         ;no, so repeat
         return           ;yes, so return to main prog

GK3:     movwf STORE
         clrf ROW         ;clear row number count

GK4:     rrf STORE,F      ;rotate right PORTB store val
         btfsc STATUS,C   ;is carry flag set?
         goto SUMIT       ;yes so key pressed, go & finish answer
         movlw MATRIX
         addwf ROW,F      ;add matrix val to ROW count
         goto GK4

SUMIT:   movf COL,W
         sublw 3
         movwf COL        ;store as column
         movf ROW,W       ;sum up results to single answer
         addwf COL,W      ;add ROW to COL (total of 0-15)
         call VALUE       ;convert val to allocated table character
         movwf ANSWER     ;store it
         call SHOWIT      ;show it
         return           ;return to main program

;............SHOW KEY RESULTS ETC..........

SHOWIT:  clrf PORTA       ;clear PORTA
         PAGE1
         clrf TRISB       ;set PORTB for output (for display use)
         PAGE0

         call LCD21       ;set LCD for line 2, cell 1
         bsf RSLINE,4     ;set LCD RS line high

         movlw ' '        ;show space
         call LCDOUT

         movf COL,W       ;show column number
         iorlw 48
         call LCDOUT
         movlw ' '        ;show space
         call LCDOUT
         movlw ' '        ;show space
         call LCDOUT
         movlw ' '        ;show space
         call LCDOUT

         movf ROW,W        ;show row number
         iorlw 48
         call LCDOUT
         movlw ' '        ;show space
         call LCDOUT
         movlw ' '        ;show space
         call LCDOUT
         movlw ' '        ;show space
         call LCDOUT

         movf ANSWER,W
         call LCDOUT      ;show character result

         PAGE1
         movlw 15
         movwf TRISB      ;reset RB0-RB3 as inputs
         PAGE0
         return           ;end of display

;..............LCD OUTPUT ROUTINES..........

LCD1:   movlw %10000000   ;command for LCD line 1 cell 1
        goto LCDLIN
LCD21:  movlw %11000000   ;command for LCD line 2 cell 1
LCDLIN: BCF RSLINE,4
LCDOUT: movwf STORE       ;LCD display routine
        movlw 20
        movwf LOOPA
DELAY:  decfsz LOOPA,F
        goto DELAY
        call SENDIT
SENDIT: swapf STORE,F
        movf STORE,W
        andlw 15
        iorwf RSLINE,W
        movwf PORTB
        BSF PORTB,5
        BCF PORTB,5
        RETURN

;...........PAUSE ROUTINE...........

PAUSIT: movlw 5           ;pause routine, 1/5th sec
        movwf CLKCNT
        clrf INTCON
PAUSE:  btfss INTCON,2
        goto PAUSE
        BCF INTCON,2
        decfsz CLKCNT,F
        goto PAUSE
        return

        .END
