;Sixteen channel 2-wire receiver
;For PIC16F84
;A.J.Flind, 4/4/99
;xtal 4MHz
;Watchdog timer ON
;Startup timer ON

#DEFINE page0 BCF status,5              
#DEFINE page1 BSF status,5              
		
status:   .EQU $03        ;general equates
portA:    .EQU $05        
trisA:    .EQU $05        
portB:    .EQU $06        
trisB:    .EQU $06        
pcl:      .EQU $02        
rtcc:     .EQU $01        
option:   .EQU $01        
intcon:   .EQU $0B        
f:        .EQU $01        
w:        .EQU $00        
z:        .EQU $02        
c:        .EQU $00                

count:    .EQU $0C        ;program specific equates
dcount:   .EQU $0D
sw1:      .EQU $0E
sw2:      .EQU $0F
last:     .EQU $10
dcount2:  .EQU $11

	.org $0004      ;interrupt vector
	.org $0005      ;start of program
;==============================================
start:	page1               ;set up to do receiver
	movlw 255
	movwf trisA         ;RA0-4 all input
	clrf trisB          ;portB all output
	movlw %11111111      
	movwf option        ;watchdog prescaled
	page0
	clrf portB
;==============================================          
rx:	clrwdt
	btfsc portA,2
	goto rx             ;locate a falling edge
	clrf sw1            ;clear both switch files
	clrf sw2
	
A0:	call dly100         ;wait 100uS
	btfsc portA,2       ;check input is low
	goto rx             ;if not, got back to start
	call dly500         ;wait 500uS
	btfss portA,2       ;check input is high
	goto rx             ;if not, got back to start            
	call dly500         ;wait 500uS           
	btfss portA,2       ;check data input, if it's low
	bsf sw1,0           ;switch is on so set bit high
	
A1:	call dly1000        ;wait 1mS
	btfsc portA,2       ;check input is low
	goto rx             ;if not, got back to start
	call dly500         ;wait 500uS
	btfss portA,2       ;check input is high
	goto rx             ;if not, got back to start            
	call dly500         ;wait 500uS           
	btfss portA,2       ;check data input, if it's low
	bsf sw1,1           ;switch is on so set bit high

A2:	call dly1000        ;and do the remaining bits likewise
	btfsc portA,2
	goto rx
	call dly500
	btfss portA,2
	goto rx          
	call dly500      
	btfss portA,2
	bsf sw1,2

A3:	call dly1000
	btfsc portA,2
	goto rx
	call dly500
	btfss portA,2
	goto rx          
	call dly500      
	btfss portA,2
	bsf sw1,3

A4:	call dly1000
	btfsc portA,2
	goto rx
	call dly500
	btfss portA,2
	goto rx          
	call dly500      
	btfss portA,2
	bsf sw1,4

A5:	call dly1000
	btfsc portA,2
	goto rx
	call dly500
	btfss portA,2
	goto rx          
	call dly500      
	btfss portA,2
	bsf sw1,5

A6:	call dly1000
	btfsc portA,2
	goto rx
	call dly500
	btfss portA,2
	goto rx          
	call dly500      
	btfss portA,2
	bsf sw1,6

A7:	call dly1000
	btfsc portA,2
	goto rx
	call dly500
	btfss portA,2
	goto rx          
	call dly500      
	btfss portA,2
	bsf sw1,7

B0:	call dly1000
	btfsc portA,2
	goto rx
	call dly500
	btfss portA,2
	goto rx          
	call dly500      
	btfss portA,2
	bsf sw2,0

B1:	call dly1000
	btfsc portA,2
	goto rx
	call dly500
	btfss portA,2
	goto rx          
	call dly500      
	btfss portA,2
	bsf sw2,1

B2:	call dly1000
	btfsc portA,2
	goto rx
	call dly500
	btfss portA,2
	goto rx          
	call dly500      
	btfss portA,2
	bsf sw2,2

B3:	call dly1000
	btfsc portA,2
	goto rx
	call dly500
	btfss portA,2
	goto rx          
	call dly500      
	btfss portA,2
	bsf sw2,3

B4:	call dly1000
	btfsc portA,2
	goto rx
	call dly500
	btfss portA,2
	goto rx          
	call dly500      
	btfss portA,2
	bsf sw2,4

B5:	call dly1000
	btfsc portA,2
	goto rx
	call dly500
	btfss portA,2
	goto rx          
	call dly500      
	btfss portA,2
	bsf sw2,5

B6:	call dly1000
	btfsc portA,2
	goto rx
	call dly500
	btfss portA,2
	goto rx          
	call dly500      
	btfss portA,2
	bsf sw2,6

B7:	call dly1000
	btfsc portA,2
	goto rx
	call dly500
	btfss portA,2
	goto rx          
	call dly500      
	btfss portA,2
	bsf sw2,7

	btfss portA,4
	goto s2out
	movf sw1,w
	movwf portB
	goto rx
s2out:	movf sw2,w
	movwf portB
	goto rx
;==============================================          
dly100:	movlw 31
	movwf dcount
d100a:	decfsz dcount,f          
	goto d100a
	nop
	nop
	return
;==============================================
dly500:	movlw 164
	movwf dcount
d500a:	decfsz dcount,f          
	goto d500a
	return
;==============================================
dly1000:	movlw 3
	movwf dcount
d1000a:	movlw 109
	movwf dcount2
d1000b:	decfsz dcount2,f
	goto d1000b
	decfsz dcount,f
	goto d1000a
	nop
	nop
	return
;==============================================          
	.END

