;
	TITLE  "ICELCD1.ASM - ICEBREAKER PIC 16F877 LCD DRIVER"
;
;USES 20.000 MHz CRYSTALOR
;
;ICELCD1  FIRST VERSION 14/2/00
;         SECOND VERSION - ERROR IN RS AND E PORT ASSIGNMENTS CORRECTED 15/3/00
        LIST            P=16F877
;
;This routine has been derived from the code supplied with the Magenta LCD Display
;Driver kit. It has been modified fir the IceBreaker PIC16F877 in just two minor ways.
;Firstly, the time delays have been increased by changing the counter value loaded
;into the 'PAUSE' subroutine - this was necessary because of the 20 Mhz clock speed
;used by IceBreaker - the original 16C84 kit runs at 4MHz. Without this change the
;display could not keep up with the data being written to it.
;
;The second change has been to alter the file registers being used by the program.
;The first register used was 0C.  The lowest register now used is 30. This change is
;required because the 16F877 uses more registers for its own internal operations 
;
;
;The LCD driver uses the 6 available PORTB pins B0 to B5
;To connect the LCD on IceBreaker, make the following links from the PIC16F877
;to the LCD link area.
;
;pin 33	PORTB 0  TO LCD		D4
;pin 34	PORTB 1  TO LCD		D5
;pin 35	PORTB 2  TO LCD		D6
;pin 36	PORTB 3  TO LCD		D7
;pin 37	PORTB 4  TO LCD		E
;pin 38	PORTB 5  TO LCD		RS
;
;
        #DEFINE INDF    0000                    ;PAGE 0 & 1 INDIRECT ADDRESS
        #DEFINE RTCC    0001                    ;PAGE 0
        #DEFINE OPTION  0001                    ;PAGE 1 (0081)
        #DEFINE PCL     0002                    ;PAGE 0 & 1 PC LOW BYTE
        #DEFINE STATUS  0003                    ;PAGE 0 & 1
        #DEFINE FSR     0004                    ;PAGE 0 & 1
        #DEFINE PORTA   0005                    ;PAGE 0
        #DEFINE TRISA   0085                    ;PAGE 1 (0085)
        #DEFINE PORTB   0006                    ;PAGE 0
        #DEFINE TRISB   0086                    ;PAGE 1 (0086)
        #DEFINE PCLATH  000A                    ;PAGE 0 & 1
;
        #DEFINE DELAY0  0030                    ;PAGE 0  DELAY LOOP COUNTER
        #DEFINE DELAY1  0031                    ;PAGE 0  DELAY LOOP COUNTER
        #DEFINE DELAY2  0032                    ;PAGE 0  DELAY LOOP COUNTER
        #DEFINE UPBYT   0033                    ;PAGE 0  STRING UPPER ADDRESS
        #DEFINE OFSET   0034                    ;PAGE 0  STRING CHR. OFFSET
        #DEFINE FLAGS1  0035                    ;PAGE 0  SYSTEM FLAGS 1
        #DEFINE INDEX   0036                    ;PAGE 0  STRING LOWER ADDRESS
        #DEFINE TMPW    0037                    ;PAGE 0  TEMP W STORE FOR DISP.
        #DEFINE BCDMSD  0038                    ;PAGE 0  MSD OF BCD CONVERSION
        #DEFINE BCDLSD  0039                    ;PAGE 0  LSD OF BCD CONVERSION
        #DEFINE INCNT   003A                    ;PAGE 0  1/10 SEC COUNTER   
        #DEFINE INCNTU  003B                    ;PAGE 0  UNITS OF SECONDS      
        #DEFINE INCNTT  003C                    ;PAGE 0  TENS OF SECONDS
        #DEFINE INTCHR  003D                    ;PAGE 0  CHARACTER CODE COUNT
;
;       STATUS REGISTER BITS
        #DEFINE CARRY   0X03,0                   ;CARRY FLAG
        #DEFINE DCARRY  0X03,1                   ;DECIMAL CARRY FLAG
        #DEFINE ZERO    0X03,2                   ;ZERO FLAG
        #DEFINE RPAGE   0X03,5                   ;REGISTER PAGE SELECT
;
;       OPTION REGISTER BITS
        #DEFINE PS0     0X01,0                  ;P1 - PRESCALER SELECT VALUES
        #DEFINE PS1     0X01,1                  ;      ''
        #DEFINE PS2     0X01,2                  ;      ''
        #DEFINE PSA     0X01,3                  ;P1 - PRESCALER ASSIGNMENT 
        #DEFINE RTE     0X01,4                  ;P1 - TMR0 EDGE (WHEN EXTERNL)
        #DEFINE RTS     0X01,5                  ;P1 - TMR0 SOURCE
        #DEFINE INTEDG  0X01,6                  ;P1 - B0 INTERRUPT EDGE  
        #DEFINE RBPU    0X01,7                  ;P1 - PORTB WEAK PULL UPS
;
;       INTCON REGISTER BITS
        #DEFINE RBIF    0X0B,0                  ;PORTB CHANGE FLAG
        #DEFINE INTF    0X0B,1                  ;B0 INT FLAG
        #DEFINE T01F    0X0B,2                  ;TIMER 1 INTERRUPT FLAG 
        #DEFINE RBIE    0X0B,3                  ;PORTB CHANGE INTERRUPT ENABLE
        #DEFINE INTE    0X0B,4                  ;B0 INTERRUPT ENABLE
        #DEFINE T01E    0X0B,5                  ;TIMER 1 INTERRUPT ENABLE
        #DEFINE EEIE    0X0B,6                  ;EEPROM WRITE INT           
        #DEFINE GIE     0X0B,7                  ;GLOBAL INTERRUPT ENABLE
;
;       PORTB BITS
        #DEFINE RS      0X06,5                  ;P0 - DISPLAY CONTROL RS   
        #DEFINE E       0X06,4                  ;P0 - DISPLAY CONTROL E   
;  
;       FLAGS1 BITS
        #DEFINE NIBLOP  0X35,0                  ;P0 - LCD DRIVE LOOP FLAG
;
        ORG     0x000                           ;RESET VECTOR
        GOTO    START                           ;
;
        ORG     0X004                           ;INTERRUPT VECTOR
        CALL    SERVE1                          ;INTERRUPT SERVICE ROUTINE
        RETFIE                                  ;RETURN FROM INTERRUPT
;
        ORG     0X10
START   BCF     RPAGE                           ;MAKE SURE PAGE 0
        CLRWDT                                  ;CLEAR WATCHDOG TIMER
;
;****************************************************************************
;*                          CLEAR REGISTERS                                 *
;CLEAR OPERATING REGISTERS LOWER BANK
        MOVLW   0X0C                            ;LOAD FIRST REGISTER ADDRESS
        MOVWF   FSR                             ;TO FILE SELECT REGISTER
NXREG   CLRF    INDF                            ;CLEAR SELECTED REGISTER
        INCF    FSR,1                           ;INCREMENT POINTER
        MOVLW   0X30                            ;LOAD TOP LOCATION +1 TO W
        SUBWF   FSR, 0                          ;SUBTRACT FROM CURRENT ONE
        BTFSS   ZERO                            ;CHECK TO SEE IF EQUAL
        GOTO    NXREG                           ;IF NOT - LOOP
;
;****************************************************************************
;*
;SET UP INITIAL PORT DATA
        MOVLW   B'00010000'                     ;MOVE DATA FOR PORTA
        MOVWF   PORTA                           ;TO PORTA REGISTER
        MOVLW   B'00001111'                     ;MOVE DATA FOR PORTB
        MOVWF   PORTB                           ;TO PORTB REGISTER
;
;*****************************************************************************
;                            PAGE 1
;SET UP PORT I/O AND OPTION REGISTER CONTENTS
        BSF     RPAGE                           ;SET PAGE 1
;
        MOVLW   B'00000000'                     ;SET A TO ALL OUTPUT
        MOVWF   TRISA                           
        MOVLW   B'00000000'                     ;SET B TO ALL OUTPUT
        MOVWF   TRISB
;
        BSF     RBPU                            ;DISABLE PORTB PULL UPS
        BSF     INTEDG                          ;SET B0 INT ON RISING EDGE
        BCF     RTS                             ;TIMER COUNTS INT CLOCK    
        BCF     RTE                             ;LOW-HIGH INT EDGE (UNUSED)
        BCF     PSA                             ;ASSIGN PRESCALER TO TIMER
        BSF     PS0                             ;SET UP PRESCALER TO /256
        BSF     PS1                             ;           ''
        BSF     PS2                             ;           ''
;
        BCF     RPAGE                           ;BACK TO PAGE 0
;                            PAGE 1
;*****************************************************************************
;
;SET UP OPENING DISPLAY
;
;Before writing to the display it must be set up for 4 bit operation by 
;sending the string of code in subroutine 'INILCD'.
;The string can be varied to deal with many display options. In this example
;4 bit operation is chosen, with 2 lines displayed, no cursor, and automatic
;display increment after each character is sent. 
;
;Opening display is located starting at 02 00 hex in the ROM area
;UPBYT and INDEX are loaded with the upper and lower bytes respectively.
;
;
        CALL    INILCD                          ;INITIALISE LCD
        MOVLW   0X02                            ;LOAD DATA STRING POINTER
        MOVWF   UPBYT                           ;FOR UPPER ADDRESS BYTE
        MOVLW   0X00                            ;LOAD DATA STRING POINTER
        MOVWF   INDEX                           ;FOR LOWER ADDRESS BYTE
        CALL    MESGE                           ;DISPLAY FIRST MESSAGE
        CALL    PAUSE2                          ;LONG PAUSE
        CALL    PAUSE2                          ;LONG PAUSE
        CALL    PAUSE2                          ;LONG PAUSE
        CALL    PAUSE2                          ;LONG PAUSE
        CALL    PAUSE2                          ;LONG PAUSE
;
;****************************************************************************
;
;MAIN PROGRAM STARTS HERE
;
;The main program sets up the second display message address, and enables the 
;interrupt routine to count up and display the entire 256 characters
;by scrolling them in from the right. 
;
MAIN ;  CLRF    INTCON                          ;CLEAR ALL INTERRUPTS & FLAGS
        CLRF    INCNT                           ;CLEAR 1/10 SEC COUNTER
        CLRF    INCNTU                          ;CLEAR 1    SEC COUNTER
        CLRF    INCNTT                          ;CLEAR   10 SEC COUNTER
;
;                                               ;set up second message address
        MOVLW   0X02                            ;LOAD DATA STRING POINTER
        MOVWF   UPBYT                           ;FOR UPPER ADDRESS BYTE
        MOVLW   0X21                            ;LOAD DATA STRING POINTER
        MOVWF   INDEX                           ;FOR LOWER ADDRESS BYTE
;
        MOVLW   0X0C                            ;LOAD VALUE
        MOVWF   RTCC                            ;AND INITIALISE RTCC
;
        BSF     T01E                            ;ENABLE TIMER INTERRUPT
        BSF     GIE                             ;ENABLE GLOBAL INTERRUPTS
;
RUNING  NOP
	GOTO    RUNING                          ;LOOP FOREVER
;
;****************************************************************************
;               SERVE1  INTERRUPT SERVICE ROUTINE
;
SERVE1  MOVLW   0X0C                            ;RELOAD RTCC
        MOVWF   RTCC                            ;
;
        CALL    MESGE                           ;DISPLAY MESSAGE
        CALL    INTCNT                          ;COUNT INTERRUPTS
        CALL    DISPT0                          ;DISPLAY COUNTER VALUE
;
        BCF     T01F                            ;CLEAR INTERRUPT FLAG
        RETURN                                  ;RETURN TO CALLING ROUTINE
;
;****************************************************************************
;
;DISPT0 DISPLAYS COUNTER VALUE
;                                                  
;This routine shows how to set up and write independently to any position
;in the display. The character position is first selected by sending the 
;address as an instruction and then writing the characters in the normal way
;
;This is done twice in this instance, first C8 to position the decimal count
;and later CC for the character to be displayed. 
;
;
DISPT0  MOVLW   0xC8                            ;move cursor position
        CALL    CONT1                           ;to line 2 '8'
        CALL    PAUSE
        MOVF    INCNTT,0                        ;LOAD HUNDREDS COUNTER 
        CALL    CONT2D                          ;AND DISPLAY DIGIT
        MOVF    INCNTU,0                        ;LOAD TENS COUNTER 
        CALL    CONT2D                          ;AND DISPLAY DIGIT
        MOVF    INCNT,0                         ;LOAD UNITS COUNTER 
        CALL    CONT2D                          ;AND DISPLAY DIGIT
;
        MOVLW   0xCC                            ;move cursor position
        CALL    CONT1                           ;to line 2 '12'
        MOVF    INTCHR,0
        CALL    CONT2                           ;AND DISPLAY CHARACTER
        MOVF    INTCHR,0
        ADDLW   0X01                            ;ADD 1
        CALL    CONT2                           ;DISPLAY NEXT CHARACTER
        MOVF    INTCHR,0
        ADDLW   0X02                            ;ADD 2
        CALL    CONT2                           ;DISPLAY NEXT CHARACTER
        MOVF    INTCHR,0
        ADDLW   0X03                            ;ADD 3
        CALL    CONT2                           ;DISPLAY NEXT CHARACTER
        RETURN
;
;****************************************************************************
;
;INTCNT COUNTS INTERRUPTS
;
INTCNT  INCF    INTCHR,1                        ;INCREMENT CHARACTER CODE
        BTFSS   ZERO                            ;IF ZERO CLEAR ALL
        GOTO    INCDEC                          ;IF NOT ZERO INC OTHERS
;
        CLRF    INCNT                           ;CLEAR DECIMAL COUNTERS
        CLRF    INCNTU                          ;
        CLRF    INCNTT                          ;
        GOTO    INCDUN                          ;EXIT
;
INCDEC  INCF    INCNT,1                         ;INCREMENT INTERRUPT COUNTER
        MOVLW   0X0A                            ;TEST FOR TEN
        SUBWF   INCNT,0
        BTFSS   CARRY
        GOTO    INCDUN
;
        CLRF    INCNT                           ;TEN UNITS SO ZERO AND 
        INCF    INCNTU,1                        ;INCREMENT TENS
        MOVLW   0X0A                            ;TEST FOR TEN
        SUBWF   INCNTU,0
        BTFSS   CARRY
        GOTO    INCDUN

        CLRF    INCNTU                          ;TEN TENS SO ZERO AND
        INCF    INCNTT,1                        ;INCREMENT HUNDREDS
        MOVLW   0X0A                            ;TEST FOR TEN
        SUBWF   INCNTT,0
        BTFSS   CARRY
        GOTO    INCDUN
;
        CLRF    INCNTT                          ;OVERFLOW SO ZERO HUNDREDS
;
INCDUN  RETURN                                  ;ALL COMPLETE
;
;****************************************************************************
;
;PAUSE2 GIVES LONG DELAY BY LOOPING 40 TIMES CALLING PAUSE1 EACH TIME
;
PAUSE2  MOVLW   0x40                            ;MOVE SET UP PAUSE DELAY
        MOVWF   DELAY2                          ;TO DELAY2 REGISTER
DEL2LP  CALL    PAUSE1                          ;CALL SECOND LOOP
        DECFSZ  DELAY2, 1                       ;DECREMENT SAMPLE PULSE COUNT
        GOTO    DEL2LP                          ;AND LOOP UNTIL IT IS ZERO
        RETURN
;
;PAUSE1 GIVES MEDIUM DELAY BY LOOPING 80 TIMES CALLING PAUSE EACH TIME
;
PAUSE1  MOVLW   0x80                            ;MOVE SET UP PAUSE DELAY
        MOVWF   DELAY1                          ;TO DELAY1 REGISTER
DEL1LP  CALL    PAUSE                           ;CALL SECOND LOOP
        DECFSZ  DELAY1, 1                       ;DECREMENT SAMPLE PULSE COUNT
        GOTO    DEL1LP                          ;AND LOOP UNTIL IT IS ZERO
        RETURN
;
;PAUSE GIVES SHORT DELAY BY LOOPING 80 TIMES
;
PAUSE   MOVLW   0x80                            ;MOVE SET UP PAUSE DELAY
        MOVWF   DELAY0                          ;TO DELAY0 REGISTER
DELLP   DECFSZ  DELAY0, 1                       ;DECREMENT SAMPLE PULSE COUNT
        GOTO    DELLP                           ;AND LOOP UNTIL IT IS ZERO
        RETURN             
;
;****************************************************************************
;*                        LCD DRIVE BLOCK                                   *
;
;INILCD INITIALISES LCD FOR 4 BIT DRIVE MODE ETC
;
INILCD  MOVLW   0x33                            ;
        CALL    CONT1
;
        MOVLW   0x32                            ;
        CALL    CONT1
;                                                
        MOVLW   0x28                            ;function set 
        CALL    CONT1                           ;4 bit mode; 2 lines
;
        MOVLW   0x06                            ;entry mode set
        CALL    CONT1                           ;cursor increments on write
;
        MOVLW   0x0C                            ;display on off 
        CALL    CONT1                           ;display on; cursor off
;
        MOVLW   0x01                            ;clear display
        CALL    CONT1                           ;move cursor to home
        CALL    PAUSE2
;
;       CODE TO HERE INITIALISES AND CLEARS THE DISPLAY
;
        RETURN
;****************************************************************************
;
; CONT1 ARRIVES WITH 8 BIT DATA IN W AND SENDS AS INSTRUCTION TO DISPLAY
;
;Instruction is sent in two 4 bit nibbles, upper nibble first and then lower 
;nibble. As each nibble is set up it is latched into the display by setting 
;the 'E' line high and then low. (latching occurs on the falling edge) 
;The RS (register select) line is held low to indicate that an INSTRUCTION is 
;being sent. Setting the RS line high indicates DISPLAY DATA. 
;
CONT1   BCF     RS                              ;SET RS TO ZERO 
        BCF     E                               ;AND E
        MOVWF   TMPW                            ;MOVE W TO TEMP STORE
        SWAPF   TMPW,0                          ;PUT MSB TO D0-3 IN W
        ANDLW   0X0F                            ;MASK UPPER BITS

        MOVWF   PORTB                           ;WRITE DATA TO PORTB
        CALL    PAUSE  
        BSF     E                               ;SET E HIGH
        CALL    PAUSE
        BCF     E                               ;FALLING E LATCHES DATA
        CALL    PAUSE                           ;DELAY 
;
        MOVF    TMPW,0                          ;PUT LSB TO D0-3
        ANDLW   0X0F                            ;MASK UPPER BITS
;
        MOVWF   PORTB                           ;WRITE DATA TO PORTB
        CALL    PAUSE  
        BSF     E                               ;SET E HIGH
        CALL    PAUSE
        BCF     E                               ;FALLING E LATCHES DATA
        CALL    PAUSE                           ;DELAY 

        RETURN                                  ;BACK FROM SUBROUTINE
;
;****************************************************************************
; CONT2D ADDS HEX 30 TO NUMBER VALUES TO MAKE THEM ASCII AND RUNS INTO CONT2
;
;The display uses a variety of the standard ASCII charcter set. This means 
;that the code for the number 0 is Hex 30 etc. This routine automatically 
;adds Hex 30 so that numeric values can be displayed directly. 
;
CONT2D  ADDLW   0X30
;
; CONT2  TAKES 8 BIT DATA IN W AND SENDS AS CHARACTER CODE TO DISPLAY
;
;Character code is sent in two 4 bit nibbles, upper nibble first and then 
;lower nibble. As each nibble is set up it is latched into the display by 
;setting the 'E' line high and then low. (latching occurs on the falling edge) 
;The RS (register select) line is held high to indicate that DISPLAY DATA is 
;being sent. This routine has been made different from the instruction routine
;to demonstrate the use of a loop to send the second half of the data. It is 
;slightly shorter, and so may help if memory is not available. Either routine 
;can be used provided care is taken to maintain RS in the appropriate state. 
;
CONT2   BCF     NIBLOP                          ;CLR LOOP COUNT FLAG ON ENTRY
        MOVWF   TMPW                            ;MOVE W TO TEMP STORE      
        SWAPF   TMPW,0                          ;PUT MSB TO D0-3 IN W
CONT2A  ANDLW   0x0F                            ;MASK UPPER 4 BITS
        BSF     RS                              ;SET RS HIGH
;
        IORLW   0X20                            ;KEEP RS BIT HIGH IN W
        MOVWF   PORTB                           ;WRITE DATA FROM W TO PORTB 
        CALL    PAUSE 
        BSF     E                               ;SET E HIGH
        CALL    PAUSE
        BCF     E                               ;FALLING E LATCHES DATA
        CALL    PAUSE                           ;DELAY 
;
        MOVF    TMPW,0                          ;GET HIGH ORDER BYTES INTO W
        BTFSC   NIBLOP                          ;TEST LOOP FLAG IF CLEAR, SKIP
        RETURN                                  ;FLAG SET, 2 LOOPS, ALL DONE.
;
        BSF     NIBLOP                          ;SET FLAG AND DO SECOND LOOP
        GOTO    CONT2A                          ;TO SEND HIGH ORDER BYTES
;
        RETURN
;
;****************************************************************************
;MESGE TAKES ALPHA NUMERIC STRING FROM ROM AND LOADS INTO DISPLAY
;STRING BEGINNING IS POINTED TO BY UPBYT AND INDEX (UPBYT IS 02)
;
;This routine takes the start addresses from UPBYTE and INDEX and collects 
;the following characters from ROM. It checks for hex 0D and starts a new line  
;and checks for hex 04 which indicates the end of the message. 
;
;
;
MESGE   ORG     01E6                            ;
        MOVLW   0x02                            ;home cursor 
        CALL    CONT1                           ;without clearing display
        CALL    PAUSE2
;
        MOVF    INDEX, 0                        ;LOAD START POINTER
        MOVWF   OFSET                           ;TO TABLE OFFSET REGISTER
MESGE1  CALL    DIGIT                           ;GET DIGIT FROM TABLE INTO W
        INCF    OFSET,1                         ;STEP ON TO NEXT DATA BYTE
        MOVWF   TMPW                            ;HOLD W VALUE FOR E O M TEST
        XORLW   0X04                            ;IS VALUE END OF MESSAGE CODE?
        BTFSC   ZERO                            ;IF SO ZERO WILL BE SET
        RETURN                                  ;SO RETURN
;
        MOVF    TMPW,0                          ;RELOAD W WITH DIGIT 
        XORLW   0X0D                            ;IS VALUE END OF LINE?
        BTFSC   ZERO                            ;IF SO ZERO WILL BE SET
        GOTO    NEWLIN                          ;SET CURSOR FOR NEW LINE
;
        MOVF    TMPW,0                          ;RELOAD W WITH DIGIT 
        CALL    CONT2                           ;WRITE TO DISPLAY
        GOTO    MESGE1                          ;AND LOOP 
;
NEWLIN  MOVLW   0xC0                            ;SET CURSOR TO NEWLINE
        CALL    CONT1                           ;BY SENDING INSTRUCTION C0 
        CALL    PAUSE1                          ;
        GOTO    MESGE1
;
DIGIT   MOVF    UPBYT, 0                        ;LOAD UPPER BYTE ADDRESS
        MOVWF   PCLATH                          ;TO PC UPPER BYTE REGISTER
        MOVF    OFSET, 0                        ;GET TABLE OFFSET 
        ADDWF   PCL,1                           ;AND ADD TO PC LOWER 8 BITS
;
;       THE SUBROUTINE 'DIGIT' MUST BE LOCATED AS SHOWN
;       IN ORDER TO ALLOW THE 'TABLE LOOK UP' FUNCTION TO TAKE PLACE
;       THIS HAS BEEN ENSURED IN THIS EXAMPLE BY THE 'ORG' 01E6 
;       WHICH HAS FIXED THE 'MESGE' LINE AND ALL SUBSEQUENT CODE 
;       THIS IS ONE OF MANY POSSIBLE WAYS OF FIXING THE CODE.
;       TAKE CARE NOT TO CROSS PAGE BOUNDARIES AS 'UPBYT' REFERS TO  
;       A SINGLE PAGE ONLY. 
;
;The PC (program counter) is loaded with the table address from UBBYT and 
;OFFSET and so execution jumps to that address, and returns with the data
;following the RETLW instruction 
;Note thet the addresses are shown in hex, but the individual characters are 
;numbered sequentially in decimal. 
;
;                                               ;UPBYT 02, OFSET 00
        RETLW   'M'                             ;CHARACTER 1
        RETLW   'A'                             ;          2
        RETLW   'G'                             ;          3
        RETLW   'E'                             ;          4
        RETLW   'N'                             ;          5
        RETLW   'T'                             ;          6
        RETLW   'A'                             ;          7
        RETLW   ' '                             ;          8
        RETLW   'D'                             ;          9
        RETLW   'I'                             ;         10
        RETLW   'S'                             ;         11
        RETLW   'P'                             ;         12
        RETLW   'L'                             ;         13
        RETLW   'A'                             ;         14
        RETLW   'Y'                             ;         15
        RETLW   ' '                             ;         16
        RETLW   0X0D                            ;         17
        RETLW   'D'                             ;         18
        RETLW   'R'                             ;         19
        RETLW   'I'                             ;         20
        RETLW   'V'                             ;         21
        RETLW   'E'                             ;         22
        RETLW   'R'                             ;         23
        RETLW   ' '                             ;         24
        RETLW   'P'                             ;         25
        RETLW   'R'                             ;         26
        RETLW   'O'                             ;         27
        RETLW   'G'                             ;         28
        RETLW   'R'                             ;         29
        RETLW   'A'                             ;         30
        RETLW   'M'                             ;         31
        RETLW   ' '                             ;         32
        RETLW   0X04                            ;         33
;
                                                ;UPBYT 02, OFSET 22
        RETLW   'S'                             ;         34
        RETLW   'h'                             ;         35
        RETLW   'o'                             ;         36
        RETLW   'w'                             ;         37
        RETLW   ' '                             ;         38
        RETLW   'C'                             ;         39 
        RETLW   'h'                             ;         40
        RETLW   'a'                             ;         41
        RETLW   'r'                             ;         42
        RETLW   'a'                             ;         43
        RETLW   'c'                             ;         44
        RETLW   't'                             ;         45
        RETLW   'e'                             ;         46
        RETLW   'r'                             ;         47
        RETLW   's'                             ;         48
        RETLW   0X0D                            ;         49
        RETLW   'D'                             ;         50
        RETLW   'e'                             ;         51
        RETLW   'c'                             ;         52
        RETLW   'i'                             ;         53
        RETLW   'm'                             ;         54
        RETLW   'a'                             ;         55
        RETLW   'l'                             ;         56
        RETLW   ' '                             ;         57
        RETLW   ' '                             ;         58
        RETLW   ' '                             ;         59
        RETLW   ' '                             ;         60
        RETLW   ' '                             ;         61
        RETLW   ' '                             ;         62
        RETLW   ' '                             ;         63
        RETLW   ' '                             ;         64
        RETLW   0X04                            ;         65
;
;Further data may be added as required up to 2FF. If a short display is 
;required, and the display is currently showing a long one, it is useful to 
;clear the display memory first by sending instruction code 0x01. 
;
;        MOVLW   0x01                            ;clear display and 
;        CALL    CONT1                           ;move cursor to home
;
;The new display data can then be stored in the minimum memory space 
;followed by 0x04 the end of message character. 
;The alternative method of writing ' ' characters over the original message
;can be used for simplicity, but uses a lot of memory space.   
;
;
;****************************************************************************
;
;
;
        END

