;PSU170.ASM 01JUL00 - COPYRIGHT JOHN BECKER - EPE PIC MONITORED QUAD PSU

;PIC16F877-4, 3.2768MHz, WDT OFF, POR ON, XTAL XT

;Config register bits (all PIC Toolkit Mk2 defaults)
; CP1 CP0 DBG NIL WRT CPD LVP BOR CP1 CP0 POR WDT OS1 OS0
;  1   1   1   1   1   1   0   0   1   1   0   0   0   1
;N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
;respectively - refer to PIC '87 data sheet.

#DEFINE PAGE0   BCF $03,5
#DEFINE PAGE1   BSF $03,5

INDF:    .EQU $00  ;page 0, 1, 2, 3
OPTION:  .EQU $01  ;page 1, 3
PCL:     .EQU $02  ;page 0, 1, 2, 3
STATUS:  .EQU $03  ;page 0, 1, 2, 3
FSR:     .EQU $04  ;page 0, 1, 2, 3

PORTA:   .EQU $05  ;page 0
TRISA:   .EQU $05  ;page 1
PORTB:   .EQU $06  ;page 0, 2
TRISB:   .EQU $06  ;page 1, 3
PORTC:   .EQU $07  ;page 0
TRISC:   .EQU $07  ;page 1
PORTD:   .EQU $08  ;page 0
TRISD:   .EQU $08  ;page 1
PORTE:   .EQU $09  ;page 0
TRISE:   .EQU $09  ;page 1

INTCON:  .EQU $0B  ;page 0, 1, 2, 3
EEDATA:  .EQU $0C  ;page 2
EECON1:  .EQU $0C  ;page 3
PIR2:    .EQU $0D  ;page 0
EEADR:   .EQU $0D  ;page 2
EECON2:  .EQU $0D  ;page 3

ADRESH:  .EQU $1E  ;page 0
ADRESL:  .EQU $1E  ;page 1

ADCON0:  .EQU $1F  ;page 0
ADCON1:  .EQU $1F  ;page 1

LOOP:   .EQU $20
LOOPA:  .EQU $21
STORE:  .EQU $22
STORE1: .EQU $23
STORE2: .EQU $24
RSLINE: .EQU $25        ;flag for LCD command control
CHAN:   .EQU $26        ;chan data selection pointer
PATH:   .EQU $27        ;channel path to be shown on screen
OLOAD:  .EQU $28        ;overload flag
EXCESS: .EQU $29        ;store for overload flags
STOREX: .EQU $2A        ;temp store for FSR during switch call
MODE:   .EQU $2B        ;flag for separate chans or all 4 for voltage
PRESS:  .EQU $2C        ;flag for which switched pressed
LOOPB:  .EQU $2D        ;loop counter
ANSA1:  .EQU $2E        ;misc answer 1
ANSA2:  .EQU $2F        ;misc answer 2

COUNTER1: .EQU $30      ;counter used in decimalisation
COUNTER2: .EQU $31      ;counter used in decimalisation
COUNT0: .EQU $32        ;holds bin val to be decimalised LSB
COUNT1: .EQU $33        ;holds bin val to be decimalised NSB
COUNT2: .EQU $34        ;holds bin val to be decimalised MSB
DIGIT1: .EQU $35        ;decimalised digit 1
DIGIT2: .EQU $36        ;decimalised digit 2
DIGIT3: .EQU $37        ;decimalised digit 3
DIGIT4: .EQU $38        ;decimalised digit 4
DIGIT5: .EQU $39        ;decimalised digit 5
DIGIT6: .EQU $3A        ;decimalised digit 6
DIGIT7: .EQU $3B        ;decimalised digit 7
DIGIT8: .EQU $3C        ;decimalised digit 8
SLOWIT: .EQU $3D        ;pause counter

V1AMSB: .EQU $40        ;sample V1a MSB store
V1ALSB: .EQU $41        ;sample V1a LSB store
V2AMSB: .EQU $42        ;sample V2a MSB store
V2ALSB: .EQU $43        ;sample V2a LSB store
V3AMSB: .EQU $44        ;sample V3a MSB store
V3ALSB: .EQU $45        ;sample V3a LSB store
V4AMSB: .EQU $46        ;sample V4a MSB store
V4ALSB: .EQU $47        ;sample V4a LSB store
V1BMSB: .EQU $48        ;sample V1b MSB store
V1BLSB: .EQU $49        ;sample V1b LSB store
V2BMSB: .EQU $4A        ;sample V2b MSB store
V2BLSB: .EQU $4B        ;sample V2b LSB store
V3BMSB: .EQU $4C        ;sample V3b MSB store
V3BLSB: .EQU $4D        ;sample V3b LSB store
V4BMSB: .EQU $4E        ;sample V4b MSB store
V4BLSB: .EQU $4F        ;sample V4b LSB store

LIMIT0: .EQU $50        ;limit channel 0 (switched 1)
LIMIT1: .EQU $51        ;limit channel 1 (variable 1)
LIMIT2: .EQU $52        ;limit channel 2 (switched 2)
LIMIT3: .EQU $53        ;limit channel 3 (variable 2)

VAMSB:  .EQU $54        ;working voltage high MSB (pre-resistor)
VALSB:  .EQU $55        ;working voltage high LSB (pre-resistor)
VBMSB:  .EQU $56        ;working voltage low MSB  (post-resistor)
VBLSB:  .EQU $57        ;working voltage low LSB  (post-resistor)
LIMIT:  .EQU $58        ;working limit value

A0MSB:   .EQU $59        ;present current on chan 0 MSB
A0LSB:   .EQU $5A        ;present current on chan 0 LSB
A1MSB:   .EQU $5B        ;present current on chan 1 MSB
A1LSB:   .EQU $5C        ;present current on chan 1 LSB
A2MSB:   .EQU $5D        ;present current on chan 2 MSB
A2LSB:   .EQU $5E        ;present current on chan 2 LSB
A3MSB:   .EQU $5F        ;present current on chan 3 MSB
A3LSB:   .EQU $60        ;present current on chan 3 LSB

LIM1:    .EQU $61        ;LSB store for use with LIMIT calc
LIM2:    .EQU $62        ;MSB store for use with LIMIT calc
ALARM:   .EQU $63        ;alarm trigger store

          ; locations up to $7F are available

             ;************************************************************
             ;           Bit Definitions
             ;************************************************************

W:      .EQU 0
F:      .EQU 1
C:      .EQU 0
DC:     .EQU 1
Z:      .EQU 2

RD:     .EQU 0  ;EECON1 reg eeprom read enable flag
WR:     .EQU 1  ;EECON1 reg eeprom write initiate flag
WREN:   .EQU 2  ;EECON1 reg eeprom write enable flag

EEIF:   .EQU 4          ;PIR2 reg
EEPGD:  .EQU 7          ;EECON1 reg

RP0:    .EQU 5          ;STATUS reg
RP1:    .EQU 6          ;STATUS reg
GIE:    .EQU 7          ;INTCON reg
GO:     .EQU 2          ;ADCON0 reg
ADFM:   .EQU 128        ;ADCON1 reg

        .ORG $0004      ;Interrupt vector address
        GOTO GIEOFF     ;Jump to interrupt routine on interrupt
        .ORG $0005      ;Start of program memory

GIEOFF: bcf INTCON,GIE  ;turn off global interrupts
        btfsc INTCON,GIE
        goto GIEOFF
        goto START

TABLCD: addwf PCL,F     ;LCD initialisation table
        retlw %00110011 ;initialise lcd - first byte
        retlw %00110011 ;2nd byte (repeat of first)
        retlw %00110010 ;set for 4-bit operation
        retlw %00101100 ;set for 2 lines
        retlw %00000110 ;set entry mode to increment each address
        retlw %00001100 ;set display on, cursor off, blink off
        retlw %00000001 ;clear display
        retlw %00000010 ;return home, cursor & RAM to zero
                        ;end initialisation table

ROUTE:  movwf STORE     ;copy channel voltage data into working store
        call ROUTE2
        movwf FSR
        movf INDF,W
        movwf VAMSB
        incf FSR,F
        movf INDF,W
        movwf VALSB
        incf FSR,F
        movf INDF,W
        movwf VBMSB
        incf FSR,F
        movf INDF,W
        movwf VBLSB
        movlw LIMIT0
        addwf STORE,W
        movwf FSR
        movf INDF,W
        movwf LIMIT
        return

ROUTE2:  addwf PCL,F
         retlw V1AMSB
         retlw V3AMSB
         retlw V1BMSB
         retlw V3BMSB

;..............

START:  bcf STATUS,RP0
        bcf STATUS,RP1
        clrf PORTA
        clrf PORTB
        clrf PORTC
        clrf PORTD
        clrf PORTE
        PAGE1
        movlw %00111111     ;PORTA as input
        movwf TRISA
        clrf TRISB          ;PORTB as output
        clrf TRISC          ;PORTC as output
        movlw %00001111     ;RD0-RD3 as input, RD4-RD7 as output
        movwf TRISD
        movlw 7
        movwf TRISE         ;PORTE as input
        movlw ADFM          ;set RHS justify, and all PORTA as analog inputs
        movwf ADCON1
        movlw %00000101     ;timer 1:64 (1/50th sec)
        movwf OPTION
        PAGE0

        movlw 4
        movwf LOOPA
        clrf LOOPB
        movlw LIMIT0
        movwf FSR
PRIME:  movf LOOPB,W    ;get primary data from EEPROM
        call PRMGET
        andlw 127
        btfsc STATUS,Z  ;is it 0?
        movlw 1         ;yes
        movwf INDF
        incf FSR,F
        incf LOOPB,F
        decfsz LOOPA,F
        goto PRIME

        clrf MODE
        clrf PATH
        call PAUSIT
        call LCDSET

;............................ END OF SETUP

INTRPT:  call SWITCH
         clrf CHAN
         movlw V1AMSB
         movwf FSR

DIRECT:  bcf STATUS,C    ;clear Carry
         rlf CHAN,W      ;temp multiply CHAN by 2
         movwf STORE     ;and store it
         rlf STORE,F     ;multiply STORE by 4
         rlf STORE,F
         movlw %10000001 ;set clock Fosc/32 with A/D on
         iorwf STORE,W   ;or this with STORE value
         movwf ADCON0    ;move into ADCON0
         call DELAY1     ;brief pause for data aquisition
         bsf ADCON0,GO   ;set ADC conversion flag

WAITADA: btfsc ADCON0,GO ;is ADC conversion flag = 0?
         goto WAITADA    ;no

         movf ADRESH,W   ;yes, so get ADC val MSB and store it
         movwf INDF
         incf FSR,F
         PAGE1
         movf ADRESL,W   ;get ADC val LSB and store it
         PAGE0
         movwf INDF
         incf FSR,F
         movf FSR,W
         movwf STOREX
         call SWITCH
         movf STOREX,W
         movwf FSR

         incf CHAN,F
         btfss CHAN,3
         goto DIRECT
         call PAUSIT
         call MONITOR
         call SHOWIT
         goto INTRPT

;............

MONITOR: clrf EXCESS     ;show load status on LEDs for all 4 chans
         clrf LOOP
         clrf ALARM

MON2:   clrf OLOAD
        movf LOOP,W
        call ROUTE
        movf VAMSB,W
        movwf ANSA2
        movf VALSB,W
        movwf ANSA1
        movf VBLSB,W     ;subtract V2 from V1 (LSB)
        subwf ANSA1,F
        btfsc STATUS,C   ;is there a borrow?
        goto MON2A2      ;no
        movlw 1
        subwf ANSA2,F
        btfss STATUS,C   ;is there a borrow?
        goto MON2A3      ;yes

MON2A2: movf VBMSB,W     ;subtract V2 from V1 (MSB)
        subwf ANSA2,F
        btfsc STATUS,C   ;is there a borrow?
        goto MON2A1      ;no
MON2A3: clrf ANSA2       ;yes, so V2>V1 due to resistor tolerances
        clrf ANSA1       ;so ANSA must be set to zero
        clrf LIM1
        clrf LIM2
        goto MON2A

MON2A1: bcf STATUS,C
        rrf ANSA2,W
        movwf LIM2
        rrf ANSA1,W
        movwf LIM1

        bcf STATUS,C     ;multiply answer by 1.5
        rrf ANSA2,W      ;(because of way in which limit is stored)
        addwf ANSA2,F
        bcf STATUS,C
        rrf ANSA1,W
        addwf ANSA1,F
        btfsc STATUS,C
        incf ANSA2,F

MON2A:  bcf STATUS,C     ;store present channel current value
        rlf LOOP,W
        addlw A0MSB
        movwf FSR
        movf LIM2,W
        movwf INDF
        incf FSR,F
        movf LIM1,W
        movwf INDF

        movf LIM2,W
        btfss STATUS,Z
        goto OVER
        movf LIMIT,W
        subwf LIM1,W
        btfsc STATUS,C
OVER:   bsf OLOAD,0

MON3:   rrf OLOAD,F      ;rotate overload status into EXCESS
        rrf EXCESS,F
        incf LOOP,F
        btfss LOOP,2
        goto MON2

MON4:   movf A1LSB,W     ;check if total for C0 + C1 > 1000mA
        addwf A0LSB,F
        btfsc STATUS,C
        incf A0MSB,F
        movf A1MSB,W
        addwf A0MSB,F

        movf A0MSB,W
        btfss STATUS,Z
        goto OVER2
        movlw 100  
        subwf A0LSB,W
        btfss STATUS,C
        goto MON5
OVER2:  movlw %00110000
        movwf ALARM      ;sounds alarm if fitted

MON5:   movf A3LSB,W     ;check if total for C2 + C3 > 1000mA
        addwf A2LSB,F
        btfsc STATUS,C
        incf A2MSB,F
        movf A3MSB,W
        addwf A2MSB,F

        movf A2MSB,W
        btfss STATUS,Z
        goto OVER3
        movlw 100  
        subwf A2LSB,W
        btfss STATUS,C
        goto MON6
OVER3:  movlw %11000000
        movwf ALARM      ;sounds alarm if fitted

MON6:   movf EXCESS,W    ;set LEDs on/off
        iorwf ALARM,W
        andlw %11110000
        movwf PORTD
        bcf PORTC,7      ;is alarm needed?
        movf ALARM,W
        btfss STATUS,Z
        bsf PORTC,7      ;yes
        return

;............

SHOWIT: btfsc MODE,0
        goto SHOWVOLT
        btfsc MODE,1
        goto SHOWAMP

        movf PATH,W
        call ROUTE

        call LCD1        ;show channel identity
        bsf RSLINE,4
        movlw 'C'
        call LCDOUT
        movlw 'h'
        call LCDOUT
        incf PATH,W
        iorlw 48
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'a'
        call LCDOUT
        movlw 'l'
        call LCDOUT
        movlw 'a'
        call LCDOUT
        movlw 'r'
        call LCDOUT
        movlw 'm'
        call LCDOUT
        movlw '='
        call LCDOUT

        movf LIMIT,W     ;show channel limit
        movwf COUNT0
        clrf COUNT1
        clrf COUNT2
        call DECIML

        movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        movlw '0'
        call LCDOUT
        movlw 'm'
        call LCDOUT
        movlw 'A'
        call LCDOUT

        call LCD21        ;show channel voltage
        bsf RSLINE,4
        call SHOWV1

        call LCD27        ;show channel current
        bsf RSLINE,4
        movlw 'a'
        call LCDOUT
        movlw 't'
        call LCDOUT
        movlw ' '
        call LCDOUT
        goto SHOWA1

;...........

DELAY1: clrf INTCON
DELAY2: btfss INTCON,2
        goto DELAY2
        return

;..........

MULT5:   movf ANSA1,W    ;multiply answer by 5
         movwf STORE1
         movf ANSA2,W
         movwf STORE2
         bcf STATUS,C    ;first mult by 4
         rlf ANSA1,F
         rlf ANSA2,F
         bcf STATUS,C
         rlf ANSA1,F
         rlf ANSA2,F

         movf STORE1,W   ;add orig to previous answer
         addwf ANSA1,F
         movf STATUS,W
         andlw 1
         addwf ANSA2,F
         movf STORE2,W   ;add this to previous answer
         addwf ANSA2,F
         return

;.............

PAUSIT: movlw 10
        movwf SLOWIT
        clrf INTCON
PAUSE:  btfss INTCON,2
        goto PAUSE
        BCF INTCON,2
        decfsz SLOWIT,F
        goto PAUSE
        return

LCD1:   movlw %10000000
        goto LCDLIN
LCD9:   movlw %10001001
        goto LCDLIN
LCD21:  movlw %11000000
        goto LCDLIN
LCD27:  movlw %11000111
        goto LCDLIN
LCD29:  movlw %11001001
LCDLIN: bcf RSLINE,4

LCDOUT: movwf STORE
        movlw 50
        movwf LOOPA
DELAY:  decfsz LOOPA,F
        goto DELAY
        call SENDIT
SENDIT: swapf STORE,F
        movf STORE,W
        andlw 15
        iorwf RSLINE,W
        movwf PORTB
        BSF PORTB,5
        BCF PORTB,5
        RETURN

LCDSET: clrf LOOP
        clrf RSLINE
LCDST2: movf LOOP,W
        call TABLCD
        call LCDOUT
        incf LOOP,F
        btfss LOOP,3
        goto LCDST2
        call PAUSIT
        return

;..........

SWITCH:  movf PORTD,W
         andlw %00001111
         btfsc STATUS,Z
         return
         movwf PRESS          ;store switch pressed

S6:      btfss PORTD,3
         goto S5
         clrf PRESS
         incf MODE,F
         movf MODE,W
         xorlw %00000011
         btfsc STATUS,Z
         clrf MODE
         call PAUSIT
         call PAUSIT
         goto ENDSW

S5:      movf MODE,W
         btfss STATUS,Z
         return

         movlw LIMIT0
         addwf PATH,W
         movwf FSR
         btfss PORTD,2
         goto S4
         clrf PRESS
         incf PATH,F
         bcf PATH,2
         call PAUSIT
         call PAUSIT
         goto ENDSW

S4:      btfss PORTD,1
         goto S3
         incf INDF,F
         movf INDF,W
         xorlw 101
         btfss STATUS,Z
         goto ENDSW
         movlw 100
         movwf INDF
         goto ENDSW

S3:      btfss PORTD,0
         goto ENDSW
         decf INDF,F
         btfss STATUS,Z
         goto ENDSW
         movlw 1
         movwf INDF

ENDSW:   call SHOWIT
         call PAUSIT
         movf PORTD,W
         andlw %00001111
         btfss STATUS,Z
         goto S6

         movf PRESS,W       ;has + or - key been used?
         btfsc STATUS,Z
         return             ;no

         movf LIMIT0,W      ;store new current limits in EEPROM
         movwf STORE1
         movlw 0
         call SETPRM

         movf LIMIT1,W
         movwf STORE1
         movlw 1
         call SETPRM

         movf LIMIT2,W
         movwf STORE1
         movlw 2
         call SETPRM

         movf LIMIT3,W
         movwf STORE1
         movlw 3
         call SETPRM
         return

;...........

SHOWVOLT: movlw 0
        call ROUTE
        call LCD1         ;show chan0 voltage
        bsf RSLINE,4
        call SHOWV1
        movlw ' '
        call LCDOUT

        movlw 1
        call ROUTE
        call LCD21        ;show chan1 voltage
        bsf RSLINE,4
        call SHOWV1

        movlw 2
        call ROUTE
        call LCD9         ;show chan2 voltage
        bsf RSLINE,4
        call SHOWV1
        movlw ' '
        call LCDOUT

        movlw 3
        call ROUTE
        call LCD29        ;show chan3 voltage
        bsf RSLINE,4
        call SHOWV1
        return
                                                                        
SHOWV1:; call CLRANS
        movf VAMSB,W
        movwf ANSA2
        movf VALSB,W
        movwf ANSA1
        call MULT5
        movf ANSA1,W
        movwf COUNT0
        movf ANSA2,W
        movwf COUNT1
        clrf COUNT2
        call DECIML

        movf DIGIT4,W
        call LCDOUT
        movf DIGIT3,W
        iorlw 48
        call LCDOUT
        movlw '.'
        call LCDOUT
        movf DIGIT2,W
        iorlw 48
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        movlw 'V'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        return

;............

SHOWAMP: movlw 0
        call ROUTE
        call LCD1         ;show chan0 amps
        bsf RSLINE,4
        movlw ' '
        call LCDOUT
        call SHOWA1

        movlw 1
        call ROUTE
        call LCD21        ;show chan1 amps
        bsf RSLINE,4
        movlw ' '
        call LCDOUT
        call SHOWA1

        movlw 2
        call ROUTE
        call LCD9         ;show chan2 amps
        bsf RSLINE,4
        movlw ' '
        call LCDOUT
        call SHOWA1

        movlw 3
        call ROUTE
        call LCD29        ;show chan3 amps
        bsf RSLINE,4
        movlw ' '
        call LCDOUT
        call SHOWA1
        return

;..........

SHOWA1:; call CLRANS
        movf VAMSB,W
        movwf ANSA2
        movf VALSB,W
        movwf ANSA1
        movf VBLSB,W       ;subtract V2 from V1 (LSB)
        subwf ANSA1,F
        btfsc STATUS,C     ;is there a borrow?
        goto SA2           ;no
        movlw 1
        subwf ANSA2,F
        btfsc STATUS,C     ;is there a borrow?
        goto SA2           ;no
        clrf ANSA1         ;yes
        clrf ANSA2
        goto SA3

SA2:    movf VBMSB,W       ;subtract V2 from V1 (MSB)
        subwf ANSA2,F
        btfsc STATUS,C     ;is there a borrow?
        goto SA2A          ;no
        clrf ANSA1         ;yes
        clrf ANSA2
        goto SA3

SA2A:   call MULT5

SA3:    movf ANSA1,W
        movwf COUNT0
        movf ANSA2,W
        movwf COUNT1
        clrf COUNT2
        call DECIML
        movf DIGIT4,W
        call LCDOUT
        movf DIGIT3,W
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        movlw 'm'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw ' '
        call LCDOUT
        return

;...............

;WRITE DATA TO EEPROM ROUTINE modified for PIC16F87x devices
;according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in STORE1.
SETPRM: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bcf STATUS,RP1  ;set for Page 0
        movf STORE1,W   ;get data value from STORE1 and hold in W
        bsf STATUS,RP1  ;set for Page 2
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf STATUS,RP0  ;set for page 3
        bcf EECON1,EEPGD ;point to Data memory
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw $55       ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw $AA       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        bcf STATUS,RP1  ;set for Page 0
        bcf STATUS,RP0

CHKWRT: btfss PIR2,EEIF ;wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR2,EEIF   ;clear bit 4 of PIR2
        return

;..............

;READ DATA FROM EEPROM ROUTINE modified for PIC16F87x devices
;according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf STATUS,RP0  ;set for Page 3
        bcf EECON1,EEPGD ;point to data memory
        bsf EECON1,RD   ;enable read flag
        bcf STATUS,RP0  ;set for Page 2 
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        bcf STATUS,RP1  ;set for Page 0
        return

;............. Modified BIN-DEC ROUTINE from Peter Hemsley 07JUN00
;              converts 24-bit binary (3 bytes) to decimal

DECIML:                   ;decimalise binary number
                          ;on entry COUNT0-2 holds number to be decimalised
                          ;answer goes into DIGIT1-8

        call BINDEC
        call BLANK0       ;blank leading zeros
        return

BINDEC: call CLRDIG       ;reset DIGITs
        movlw 24          ;24 bits to do
        movwf COUNTER1
        goto SHIFT1

ADJBCD  movlw DIGIT1
        movwf FSR         ;pointer to digits
        movlw 7           ;7 digits to do (Digit 8 never >4)
        movwf COUNTER2    ;if Digit > 4 then digit = digit + 3
        movlw 3           ;check for Digit > 4 by adding 3 to it
ADJLOOP: addwf INDF,F     ;and test bit 3 of result
        btfss INDF,3      ;is it greater than 7?
        subwf INDF,F      ;restore to original
        incf FSR,F        ;next digit
        decfsz COUNTER2,F
        goto ADJLOOP

SHIFT1: call SLCNT        ;shift MSB into Carry

SLDEC:  movlw DIGIT1      ;shift Carry and Digits 1 bit left
        movwf FSR         ;pointer to digits
        movlw 8           ;8 Digits to do
        movwf COUNTER2

SLDLOOP:                  ;after RLF if bit 4 is set then shift 1
        rlf INDF,F        ;into LSB of next Digit else shift 0
        btfsc INDF,4      ;test for BCD carry
        bsf STATUS,C      ;set Carry for next Digit (cleared by RLF)
        bcf INDF,4        ;clear BCD overflow (if any)
        incf FSR,F        ;next Digit
        decfsz COUNTER2,F
        goto SLDLOOP

        decfsz COUNTER1,F ;next bit
        goto ADJBCD
        return

SLCNT:  rlf COUNT0,F      ;LSB
        rlf COUNT1,F      ;shift left count 0-2
        rlf COUNT2,F      ;MSB
        return

CLRDIG: clrf DIGIT1       ;lsd
        clrf DIGIT2
        clrf DIGIT3
        clrf DIGIT4
        clrf DIGIT5
        clrf DIGIT6
        clrf DIGIT7
        clrf DIGIT8       ;msd
        return

BLANK0: movlw 8
        movwf LOOPA
        movlw DIGIT8
        movwf FSR
BLANK1: movf INDF,W
        btfss STATUS,Z
        goto BLANK2
        movlw ' '
        movwf INDF
        decf FSR,F
        decfsz LOOPA,F
        goto BLANK1
        movlw 48
        iorwf DIGIT1,F
        return

BLANK2: movlw 48
        iorwf INDF,F
        decf FSR,F
        decfsz LOOPA,F
        goto BLANK2
        return

        .END

