; mathsbin2dec.inc

;REGA0  ; registers needed by BIN2DEC
;REGA1
;REGA2
;REGA3
;MTEMP
;
;COUNT0
;COUNT1
;COUNT2
;DIGIT1
;DIGIT2
;DIGIT3
;DIGIT4
;DIGIT5
;DIGIT6
;DIGIT7
;DIGIT8
;BITCNT
;DIGCNT


bin2dec: clrf    digit1
	clrf	digit2
	clrf	digit3
	clrf	digit4
	clrf	digit5
	clrf	digit6
	clrf	digit7
	clrf	digit8

	movlw	24		;24 bits to do
	movwf	bitcnt

bitlp   rlf     count0,F        ;Shift msb into carry
	rlf	count1,F
	rlf	count2,F

	movlw	digit1
	movwf	fsr		;Pointer to digits
	movlw	8		;8 digits to do
	movwf	digcnt
adjlp	rlf	indf,F		;Shift digit 1 bit left
	movlw	10
	subwf	indf,w		;Check and adjust for decimal overflow
	skpnc
	movwf	indf

	incf	fsr,F		;Next digit
	decfsz	digcnt,F
	goto	adjlp
        decfsz  bitcnt,F        ;Next bit
	goto	bitlp
        movlw 48
        iorwf DIGIT1,F
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
	return

BLANKIT
        movf DIGIT8,W       ; blank leading zeros
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT8,4
        movf DIGIT7,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT7,4
        movf DIGIT6,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT6,4
        movf DIGIT5,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT5,4
        movf DIGIT4,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT4,4
        movf DIGIT3,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT3,4
        movf DIGIT2,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT2,4
        movf DIGIT8,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT8,4
        return

;****************

;UTILITY ROUTINES


;Check sign of REGA and convert negative to positive
;Used by multiply, divide, bin2dec

chksgna	rlf	REGA3,w
	skpc
	return

;Negate REGA
;Used by multiply, divide, bin2dec, dec2bin

negatea	movf	REGA3,w		;Save sign in w
	andlw	0x80

	comf	REGA0,f		;2's complement
	comf	REGA1,f
	comf	REGA2,f
	comf	REGA3,f
	incfsz	REGA0,f
	goto	nega1
	incfsz	REGA1,f
	goto	nega1
	incfsz	REGA2,f
	goto	nega1
	incf	REGA3,f
nega1
	incf	MTEMP,f		;flip sign flag
	addwf	REGA3,w		;Return carry set if -2147483648
	return

SHOWDIGIT8 movf DIGIT8,W       ; show decimal values
           call LCDOUT
SHOWDIGIT7 movf DIGIT7,W
           call LCDOUT
SHOWDIGIT6 movf DIGIT6,W
           call LCDOUT
SHOWDIGIT5 movf DIGIT5,W
           call LCDOUT
SHOWDIGIT4 movf DIGIT4,W
           call LCDOUT
SHOWDIGIT3 movf DIGIT3,W
           call LCDOUT
SHOWDIGIT2 movf DIGIT2,W
           call LCDOUT
SHOWDIGIT1 movf DIGIT1,W
           call LCDOUT
	   return
