; TEACHINH02.ASM 15FEB08 - TEACH IN 2008 PT8
; Reaction timer

#DEFINE BANK0 BCF STATUS,5  ; clear STATUS bit 5 (RP0)
#DEFINE BANK1 BSF STATUS,5  ; set   STATUS bit 5 (RP0)

           include p16f628.inc

           __config  h'3F30'    ; internal 4MHz oscillator

        CBLOCK h'20'
LOOP
LOOPA
STORE
RSLINE
CLKCNT
COUNTER
COUNTER2
DELAY

DCOUNT
DSIGN 
DIGIT1
DIGIT2
DIGIT3
DIGIT4
DIGIT5
DIGIT6
DIGIT7
DIGIT8
DIGIT9
DIGIT10
REGA0
REGA1
REGA2
REGA3
REGB0
REGB1
REGB2
REGB3
REGC0
REGC1
REGC2
REGC3
MTEMP
MCOUNT
        ENDC

           ORG 0              ; reset vector
           goto STARTIT
           ORG 4              ; Interrupt vector address
           goto STARTIT
           ORG 5              ; PIC program memory location at which to start 
           goto STARTIT

           include LCDheader.inc

MESSAG     addwf PCL,F
           retlw 'R'
           retlw 'E'
           retlw 'A'
           retlw 'C'
           retlw 'T'
           retlw 'I'
           retlw 'O'
           retlw 'N'
           retlw ' '
           retlw 'T'
           retlw 'I'
           retlw 'M'
           retlw 'E'
           retlw 'R'
           retlw ' '
           retlw ' '

STARTIT    clrf PORTA          ; clear PORTA's outputs if any
           clrf PORTB          ; clear PORTB's output if any
           movlw 7             ; needed by some PICs, including PIC16F628
           movwf CMCON         ; so that PORTA is treated as digital port

           BANK1               ; set for Bank 1
           clrf TRISB          ; set PORTB for all outputs
           movlw b'00011000'   ; set PORTA for RA3, RA4 as input
           movwf TRISA
           movlw b'10000111'   ; timer 1:128, pull-ups off (bit 7 = 1)
           movwf OPTION_REG
           BANK0               ; set for Bank 0

           call PAUSIT
           call LCDSET
           call PAUSIT

LCDMSG     clrf LOOP               ; clear loop
	   call LCD21
           bsf RSLINE,4            ; set RS for data send
LCDMS2     movf LOOP,W             ; get table address
           call MESSAG             ; get message letter
           call LCDOUT             ; show it
           incf LOOP,F             ; inc loop
           btfss LOOP,4            ; has last LCD letter been sent?
           goto LCDMS2             ; no, so repeat for next one

           movlw b'00000000' ; set timer 1 for prescale 1/1, and timer off
           movwf T1CON

MAIN       clrf TMR1L        ; reset timer 1 LSB
           clrf TMR1H        ; reset timer 1 MSB
           clrf COUNTER
           bcf PORTA,0
           bsf PORTA,1
           movf COUNTER2,W
           movwf DELAY

M0         incf COUNTER2,F
           btfss PORTA,3
           goto M0
           bcf PORTA,1

           call CLRLINE1
           call PAUSIT2
           bsf PORTA,0
           bsf T1CON,0       ; start timer 1

M2         btfss PIR1,TMR1IF
           goto M3
           bcf PIR1,TMR1IF
           incfsz COUNTER,F
           goto M3
           goto OVERFLOW

M3         btfss PORTA,4     ; has switch been pressed?
           goto M2           ; no

           clrf REGA0
           clrf REGA1
           movlw 1
           movwf REGA2
           clrf REGA3
           movf COUNTER,W
           movwf REGB0
           clrf REGB1
           clrf REGB2
           clrf REGB3
           call MULTIPLY32
           movf TMR1L,W
           movwf REGB0
           movf TMR1H,W
           movwf REGB1
           clrf REGB2
           clrf REGB3
           call ADDBA

           call BIN2DEC
           call LCD1
           bsf RSLINE,4
           movf DIGIT1,W         ; show decimal values
           call LCDOUT
           movf DIGIT2,W
           call LCDOUT
           movf DIGIT3,W
           call LCDOUT
           movf DIGIT4,W
           iorlw 48
           call LCDOUT
           movlw '.'
           call LCDOUT
           movf DIGIT5,W
           call LCDOUT
           movf DIGIT6,W
           call LCDOUT
           movf DIGIT7,W
           call LCDOUT
           movlw ' '
           call LCDOUT
           movlw 's'
           call LCDOUT
           movlw 'e'
           call LCDOUT
           movlw 'c'
           call LCDOUT
           movlw 's'
           call LCDOUT
           bcf PIR1,TMR1IF
           goto MAIN

OVERFLOW   call LCD1
           bsf RSLINE,4
           movlw 'O'
           call LCDOUT
           movlw 'V'
           call LCDOUT
           movlw 'E'
           call LCDOUT
           movlw 'R'
           call LCDOUT
           movlw 'F'
           call LCDOUT
           movlw 'L'
           call LCDOUT
           movlw 'O'
           call LCDOUT
           movlw 'W'
           call LCDOUT
           bsf PORTA,1
           bcf PIR1,TMR1IF
           goto MAIN

; *********

PAUSIT     movlw 5             ; set delay counter
           movwf CLKCNT        ; 
           clrf INTCON         ; clear interupt flag
PAUSE                          ; initial wait before setting up LCD
           btfss INTCON,2      ; has a timer time-out been detected?
           goto PAUSE          ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto PAUSE          ; no
           return              ; yes

PAUSIT2    movf DELAY,W        ; set delay counter
           movwf CLKCNT        ; 
           clrf INTCON         ; clear interupt flag
PAUSE2     btfss INTCON,2      ; has a timer time-out been detected?
           goto PAUSE2         ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto PAUSE2         ; no
           return              ; yes

           include LCDroutines.inc

; *********** PART OF PETER HEMSLEY'S 32-BIT MATHS ROUTINES *******

;*** SIGNED BINARY TO DECIMAL ***
;REGA -> DIGITS 1 (MSD) TO 10 (LSD) & DSIGN
;DSIGN = 0 if REGA is positive, FF if negative
;return carry set if overflow
;Uses FSR register

bin2dec:
        call    clrdig          ;Clear all digits
        clrf    MTEMP           ;Reset sign flag
        call    chksgna         ;Make REGA positive
	skpnc
        call    negatea         ;Negative

        movlw   D'32'           ;Loop counter
        movwf   MCOUNT

b2dloop	rlf	REGA0,f		;Shift msb into carry
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f

        movlw   DIGIT10
        movwf   FSR             ;Pointer to digits
        movlw   D'10'           ;10 digits to do
        movwf   DCOUNT

adjlp	rlf	INDF,f		;Shift digit and carry 1 bit left
        movlw   -D'10'
	addwf	INDF,w		;Check and adjust for decimal overflow
	skpnc
        movwf   INDF

	decf	FSR,f		;Next digit
	decfsz	DCOUNT,f
        goto    adjlp

	decfsz	MCOUNT,f	;Next bit
        goto    b2dloop

	btfsc	MTEMP,0		;Check sign
	comf	DSIGN,f		;Negative
	clrc

BLANKIT: movlw 48
        iorwf DIGIT1,F
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
        iorwf DIGIT9,F
        iorwf DIGIT10,F

        movlw 10          ; blank leading zeros
        movwf LOOP
        movlw DIGIT1
        movwf FSR
BLANK:  movf LOOP,W
        movf INDF,W
        andlw 15
        btfss STATUS,Z
        return
        bcf INDF,4
        incf FSR,F
        decfsz LOOP,F
        goto BLANK
        movlw 48
        iorwf DIGIT10,F
        return

; **************

;Set all digits to 0
;Used by bin2dec

clrdig	clrf	DSIGN
	clrf	DIGIT1
	clrf	DIGIT2
	clrf	DIGIT3
	clrf	DIGIT4
	clrf	DIGIT5
	clrf	DIGIT6
	clrf	DIGIT7
	clrf	DIGIT8
	clrf	DIGIT9
	clrf	DIGIT10
        return

;UTILITY ROUTINES

;Check sign of REGA and convert negative to positive
;Used by bin2dec

chksgna	rlf	REGA3,w
	skpc
        return

;Negate REGA
;Used by bin2dec

negatea movf    REGA3,w         ;Save sign in w
	andlw	0x80

	comf	REGA0,f		;2's complement
	comf	REGA1,f
	comf	REGA2,f
	comf	REGA3,f
        incfsz  REGA0,f
        goto    nega1
        incfsz  REGA1,f
        goto    nega1
        incfsz  REGA2,f
        goto    nega1
        incf    REGA3,f
nega1
        incf    MTEMP,f         ;flip sign flag
        addwf   REGA3,w         ;return carry set if -2147483648
        return

SHOWDIGIT1 movf DIGIT1,W         ; show decimal values
           call LCDOUT
SHOWDIGIT2 movf DIGIT2,W
           call LCDOUT
SHOWDIGIT3 movf DIGIT3,W
           call LCDOUT
SHOWDIGIT4 movf DIGIT4,W
           call LCDOUT
SHOWDIGIT5 movf DIGIT5,W
           call LCDOUT
SHOWDIGIT6 movf DIGIT6,W
           call LCDOUT
SHOWDIGIT7 movf DIGIT7,W
           call LCDOUT
SHOWDIGIT8 movf DIGIT8,W
           call LCDOUT
SHOWDIGIT9 movf DIGIT9,W
           call LCDOUT
SHOWDIGIT10 movf DIGIT10,W
           call LCDOUT
           return

;*** SIGNED 32 BIT INTEGER MATHS ROUTINES FOR PIC16 SERIES BY PETER HEMSLEY JAN 2003 ***


;*** SIGNED MULTIPLY ***
;REGA * REGB -> REGA
;Return carry set if overflow

multiply32
	clrf	MTEMP
	call	chksgna		;Make REGA positive
	skpnc
	return			;Overflow
	call	chksgnb		;Make REGB positive
	skpnc
	return			;Overflow

	call	movac		;Move REGA to REGC
	call	clra		;Clear product

	movlw	D'31'		;Loop counter
	movwf	MCOUNT

muloop	call	slac		;Shift left product and multiplicand

	rlf	REGA3,w
	skpnc			;Check for overflow
	return

	btfss	REGC3,7		;If multiplicand bit is a 1 then
	goto	nxtmul
	call	addba		;add multiplier to product

	rlf	REGA3,w
	skpnc			;Check for overflow
	return

nxtmul	decfsz	MCOUNT,f	;Next
	goto	muloop

	btfsc	MTEMP,0		;Check result sign
	call	negatea		;Negative
	return

;Check sign of REGB and negative convert to positive
;Used by multiply, divide

chksgnb	rlf	REGB3,w
	skpc
	return

;Move REGA to REGC
;Used by multiply, sqrt

movac	movf	REGA0,w
	movwf	REGC0
	movf	REGA1,w
	movwf	REGC1
	movf	REGA2,w
	movwf	REGC2
	movf	REGA3,w
	movwf	REGC3
	return

;Clear REGA
;Used by multiply, sqrt

clra	clrf	REGA0
	clrf	REGA1
	clrf	REGA2
	clrf	REGA3
	return



;Shift left REGA and REGC
;Used by multiply, divide

slac	rlf	REGA0,f
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f
	rlf	REGC0,f
	rlf	REGC1,f
	rlf	REGC2,f
	rlf	REGC3,f
	return

;Add REGB to REGA
;Used by add, multiply

addba	movf	REGB0,w		;Add lo byte
	addwf	REGA0,f

	movf	REGB1,w		;Add mid-lo byte
	skpnc			;No carry_in, so just add
	incfsz	REGB1,w		;Add carry_in to REGB
	addwf	REGA1,f		;Add and propagate carry_out

	movf	REGB2,w		;Add mid-hi byte
	skpnc
	incfsz	REGB2,w
	addwf	REGA2,f

	movf	REGB3,w		;Add hi byte
	skpnc
	incf	REGB3,w
	addwf	REGA3,f
	return

;*** SIGNED DIVIDE ***
;REGA / REGB -> REGA
;Remainder in REGC
;Return carry set if overflow or division by zero

divide32  movf    REGB0,w         ;Trap division by zero
	iorwf	REGB1,w
	iorwf	REGB2,w
	iorwf	REGB3,w
	sublw	0
	skpnc
	return

	clrf	MTEMP
	call	chksgna		;Make dividend (REGA) positive
	skpnc
	return			;Overflow
	call	chksgnb		;Make divisor (REGB) positive
	skpnc
	return			;Overflow

	clrf	REGC0		;Clear remainder
	clrf	REGC1
	clrf	REGC2
	clrf	REGC3

	movlw	D'32'		;Loop counter
	movwf	MCOUNT

dvloop	call	slac		;Shift dividend (REGA) msb into remainder (REGC)

	movf	REGB3,w		;Test if remainder (REGC) >= divisor (REGB)
	subwf	REGC3,w
	skpz
	goto	dtstgt
	movf	REGB2,w
	subwf	REGC2,w
	skpz
	goto	dtstgt
	movf	REGB1,w
	subwf	REGC1,w
	skpz
	goto	dtstgt
	movf	REGB0,w
	subwf	REGC0,w
dtstgt	skpc			;Carry set if remainder >= divisor
	goto	dremlt

	movf	REGB0,w		;Subtract divisor (REGB) from remainder (REGC)
	subwf	REGC0,f
	movf	REGB1,w
	skpc
	incfsz	REGB1,w
	subwf	REGC1,f
	movf	REGB2,w
	skpc
	incfsz	REGB2,w
	subwf	REGC2,f
	movf	REGB3,w
	skpc
	incfsz	REGB3,w
	subwf	REGC3,f
	clrc
	bsf	REGA0,0		;Set quotient bit

dremlt	decfsz	MCOUNT,f	;Next
	goto	dvloop

	btfsc	MTEMP,0		;Check result sign
	call	negatea		;Negative
	return

        END
