; TEACHINH01.ASM 15FEB08 - TEACH IN 2008 PT8
; Using RS232 COMs and Timer 1

#DEFINE BANK0 BCF STATUS,5  ; clear STATUS bit 5 (RP0)
#DEFINE BANK1 BSF STATUS,5  ; set   STATUS bit 5 (RP0)

           include p16f628.inc

           __config  h'3F30'    ; internal 4MHz oscillator

        CBLOCK h'20'
VALUE
LOOP
LOOPA
STORE
RSLINE
FSRSTORE
CLKCNT
COUNTER

DCOUNT
DSIGN 
DIGIT1
DIGIT2
DIGIT3
DIGIT4
DIGIT5
DIGIT6
DIGIT7
DIGIT8
DIGIT9
DIGIT10
REGA0
REGA1
REGA2
REGA3
MTEMP
MCOUNT
        ENDC

SPBRG                        EQU     H'99'

           ORG 0              ; reset vector
           goto STARTIT
           ORG 4              ; Interrupt vector address
           goto STARTIT
           ORG 5              ; PIC program memory location at which to start 

           include LCDheader.inc

STARTIT    clrf PORTA          ; clear PORTA's outputs if any
           clrf PORTB          ; clear PORTB's output if any
           movlw 7             ; needed by some PICs, including PIC16F628
           movwf CMCON         ; so that PORTA is treated as digital port

           BANK1               ; set for Bank 1
           clrf TRISB          ; set PORTB for all outputs
           movlw b'00010100'   ; set PORTA for RA2, RA4 as inputs
           movwf TRISA
           movlw b'10000110'   ; timer 1:128, pull-ups off (bit 7 = 1)
           movwf OPTION_REG
           BANK0               ; set for Bank 0

           call PAUSIT
           call LCDSET
           call PAUSIT
           clrf COUNTER

           call JOESETBAUD

           btfsc PORTA,2
           goto RECEIVE

;          movlw b'00110000' ; set timer 1 for prescale 1/8, and timer off
           movlw b'00000000' ; set timer 1 for prescale 1/1, and timer off
           movwf T1CON

MAIN       clrf TMR1L        ; reset timer 1 LSB
           clrf TMR1H        ; reset timer 1 MSB
           bsf PORTA,1       ; set RA1 high to start cap charging
           bsf T1CON,0       ; start timer 1

M2         btfss PORTA,4     ; has cap reached RA4 trigger level?
           goto M2           ; no
           bcf T1CON,0       ; yes, stop timer 1
           bcf PORTA,1       ; set RA1 low to discharge cap

           movlw 'S'         ; transmite 'S' for sync
           call  TXBYTE
           movf TMR1H,W
           call  TXBYTE
           movf TMR1L,W
           call  TXBYTE

           call PAUSIT       ; allow time for cap to discharge
           call PAUSIT       ; allow time for cap to discharge
           goto MAIN         ; repeat

; *********

PAUSIT     movlw 5             ; set delay counter
           movwf CLKCNT        ; 
           clrf INTCON         ; clear interupt flag
PAUSE                          ; initial wait before setting up LCD
           btfss INTCON,2      ; has a timer time-out been detected?
           goto PAUSE          ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto PAUSE          ; no
           return              ; yes

           include LCDroutines.inc

; *********** PART OF PETER HEMSLEY'S 32-BIT MATHS ROUTINES *******

;*** SIGNED BINARY TO DECIMAL ***
;REGA -> DIGITS 1 (MSD) TO 10 (LSD) & DSIGN
;DSIGN = 0 if REGA is positive, FF if negative
;return carry set if overflow
;Uses FSR register

bin2dec:
        call    clrdig          ;Clear all digits
        clrf    MTEMP           ;Reset sign flag
        call    chksgna         ;Make REGA positive
	skpnc
        call    negatea         ;Negative

        movlw   D'32'           ;Loop counter
        movwf   MCOUNT

b2dloop	rlf	REGA0,f		;Shift msb into carry
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f

        movlw   DIGIT10
        movwf   FSR             ;Pointer to digits
        movlw   D'10'           ;10 digits to do
        movwf   DCOUNT

adjlp	rlf	INDF,f		;Shift digit and carry 1 bit left
        movlw   -D'10'
	addwf	INDF,w		;Check and adjust for decimal overflow
	skpnc
        movwf   INDF

	decf	FSR,f		;Next digit
	decfsz	DCOUNT,f
        goto    adjlp

	decfsz	MCOUNT,f	;Next bit
        goto    b2dloop

	btfsc	MTEMP,0		;Check sign
	comf	DSIGN,f		;Negative
	clrc

BLANKIT: movlw 48
        iorwf DIGIT1,F
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
        iorwf DIGIT9,F
        iorwf DIGIT10,F

        movlw 10          ; blank leading zeros
        movwf LOOP
        movlw DIGIT1
        movwf FSR
BLANK:  movf LOOP,W
        movf INDF,W
        andlw 15
        btfss STATUS,Z
        return
        bcf INDF,4
        incf FSR,F
        decfsz LOOP,F
        goto BLANK
        movlw 48
        iorwf DIGIT10,F
        return

; **************

;Set all digits to 0
;Used by bin2dec

clrdig	clrf	DSIGN
	clrf	DIGIT1
	clrf	DIGIT2
	clrf	DIGIT3
	clrf	DIGIT4
	clrf	DIGIT5
	clrf	DIGIT6
	clrf	DIGIT7
	clrf	DIGIT8
	clrf	DIGIT9
	clrf	DIGIT10
        return

;UTILITY ROUTINES

;Check sign of REGA and convert negative to positive
;Used by bin2dec

chksgna	rlf	REGA3,w
	skpc
        return

;Negate REGA
;Used by bin2dec

negatea movf    REGA3,w         ;Save sign in w
	andlw	0x80

	comf	REGA0,f		;2's complement
	comf	REGA1,f
	comf	REGA2,f
	comf	REGA3,f
        incfsz  REGA0,f
        goto    nega1
        incfsz  REGA1,f
        goto    nega1
        incfsz  REGA2,f
        goto    nega1
        incf    REGA3,f
nega1
        incf    MTEMP,f         ;flip sign flag
        addwf   REGA3,w         ;return carry set if -2147483648
        return

SHOWDIGIT1 movf DIGIT1,W         ; show decimal values
           call LCDOUT
SHOWDIGIT2 movf DIGIT2,W
           call LCDOUT
SHOWDIGIT3 movf DIGIT3,W
           call LCDOUT
SHOWDIGIT4 movf DIGIT4,W
           call LCDOUT
SHOWDIGIT5 movf DIGIT5,W
           call LCDOUT
SHOWDIGIT6 movf DIGIT6,W
           call LCDOUT
SHOWDIGIT7 movf DIGIT7,W
           call LCDOUT
SHOWDIGIT8 movf DIGIT8,W
           call LCDOUT
SHOWDIGIT9 movf DIGIT9,W
           call LCDOUT
SHOWDIGIT10 movf DIGIT10,W
           call LCDOUT
           return

       ;*************** OUTPUT TO PC SERIAL PORT FOR DOWNLOAD

;  Modified from Joe Farr's file SAMPLE5.ASM
;  Orig Date: 10-Feb-2003, mod date 01MAR03

JOESETBAUD BANK1                ; Configure the baud rate generator
;        movlw 25                ; BRG for 9600baud from 4MHz, brgh=1
        movlw 103               ; BRG for 2400baud from 4MHz, brgh=1

        movwf   SPBRG           ; In bank 1
        movlw   b'00100100'     ; BRGH = 1(High speed, bit 2) & ASYNC transmission (bit 5)
        movwf   TXSTA           ; In bank 1
        bcf     STATUS,RP0      ; back to RAM page 0
        movlw   b'10010000'     ; ASYNC reception
        movwf   RCSTA           ; In bank 0
        call    FlushRXBuffer   ; Flush the RX buffer in bank 0
        return

; Send byte in W to the USART

TxByte  nop
        btfss   PIR1,TXIF       ; TX Buffer empty yet ?
        goto    TxByte          ; No - Keep waiting
        movwf   TXREG           ; Now empty - send this character
        return

; Flush the contents of the RX Buffer

FlushRXBuffer
	movf    RCREG,W        	; Flush the RX buffer in bank 0
        movf    RCREG,W
        movf    RCREG,W
        return

RECEIVE movlw   b'10010000'     ; ASYNC reception
        movwf   RCSTA           ; In bank 0

        BANK1
        movlw b'00000110'       ; set TRISB for RS232 
        movwf TRISB
        BANK0

R1      btfss PIR1,RCIF         ; Check for any RX'd data
        goto R1                 ; Nothing RX'd
        movf RCREG,W            ; is recd data = 'S'?
        xorlw 'S'
        btfss STATUS,Z
        goto R1                 ; no

        comf PORTA,F            ; yes, toggle PORTA to prove it externally

R2      btfss PIR1,RCIF         ; Check for any RX'd data
        goto R2                 ; Nothing RX'd
        movf RCREG,W            ; Store the RX'd data in 'W'
        movwf REGA1

R3      btfss PIR1,RCIF         ; Check for any RX'd data
        goto R3                 ; Nothing RX'd
        movf  RCREG,W           ; Store the RX'd data in 'W'
        movwf REGA0

        movlw 0
        movwf RCSTA
        BANK1
        movlw b'00000000'       ; set TRISB for LCD output
        movwf TRISB
        BANK0

        clrf REGA2              ; show value
        clrf REGA3
        call BIN2DEC
        call LCD1
        bsf RSLINE,4
        call SHOWDIGIT5
        movlw ' '
        call LCDOUT

        incf COUNTER,F
        movf COUNTER,W          ; counter value and display
        movwf REGA0
        clrf REGA1
        clrf REGA2
        clrf REGA3
        call BIN2DEC
        call SHOWDIGIT8
        goto RECEIVE           ; repeat

        END
