;TeachInJ01.ASM. 06FEB08
;A simple program which makes use of WDT

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

              include p16f628.inc

              __config  h'3F34'    ; internal 4MHz oscillator, WDT on

        CBLOCK h'20'
LOOP
LOOPA
STORE
RSLINE
FSRSTORE
CLKCNT
COUNTER0
COUNTER1
COUNTER2
COUNTER3

DCOUNT
DSIGN 
DIGIT1
DIGIT2
DIGIT3
DIGIT4
DIGIT5
DIGIT6
DIGIT7
DIGIT8
DIGIT9
DIGIT10
REGA0
REGA1
REGA2
REGA3
MTEMP
MCOUNT
        ENDC

              ORG 0              ; reset vector
              goto STARTIT
              ORG 4              ; Interrupt vector address
              goto STARTIT
              ORG 5              ; PIC program memory location at which to start 

              include LCDheader.inc

STARTIT       clrf PORTA         ; clear PORTA's outputs if any
              clrf PORTB         ; clear PORTB's output if any
              movlw 7            ; needed by some PICs, including PIC16F628
              movwf CMCON        ; so that PORTA is treated as digital port

              BANK1              ; set for Bank 1
              MOVLW b'00010000'  ; RA4 as input
              MOVWF TRISA
              clrf TRISB         ; PORTB as output

              MOVLW b'00001111'  ; set WDT on (bit 3)
;              MOVLW b'00001110'  ; set WDT on (bit 3)
                                 ; with slowest timer 1:128 (bits 0-2)
              MOVWF OPTION_REG
              CLRWDT             ; clear watchdog timer
              BANK0
;              MOVLW b'00000000'  ; disable other interrupts
;              MOVWF INTCON

              call PAUSIT
              call LCDSET
              call PAUSIT
              clrf COUNTER0
              clrf COUNTER1
              clrf COUNTER2
              clrf COUNTER3

TESTON        incfsz COUNTER0,F ; inc Counter value
              goto TSTOFF
              incfsz COUNTER1,F ; inc Counter value
              goto TSTOFF
              incfsz COUNTER2,F ; inc Counter value
              goto TSTOFF
              incf COUNTER3,F   ; inc Counter value

TSTOFF        movf COUNTER0,W
              movwf REGA0
              movf COUNTER1,W
              movwf REGA1
              movf COUNTER2,W
              movwf REGA2
              movf COUNTER3,W
              movwf REGA3

              call BIN2DEC
              call LCD1
              bsf RSLINE,4
              call SHOWDIGIT1
              btfsc PORTA,4
              CLRWDT
              call PAUSIT
              goto TESTON      ; repeat the procedure

; *********

PAUSIT     movlw 5             ; set delay counter
           movwf CLKCNT        ; 
           clrf INTCON         ; clear interupt flag
PAUSE                          ; initial wait before setting up LCD
           btfss INTCON,2      ; has a timer time-out been detected?
           goto PAUSE          ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto PAUSE          ; no
           return              ; yes

           include LCDroutines.inc

; *********** PART OF PETER HEMSLEY'S 32-BIT MATHS ROUTINES *******

;*** SIGNED BINARY TO DECIMAL ***
;REGA -> DIGITS 1 (MSD) TO 10 (LSD) & DSIGN
;DSIGN = 0 if REGA is positive, FF if negative
;return carry set if overflow
;Uses FSR register

bin2dec:
        call    clrdig          ;Clear all digits
        clrf    MTEMP           ;Reset sign flag
        call    chksgna         ;Make REGA positive
	skpnc
        call    negatea         ;Negative

        movlw   D'32'           ;Loop counter
        movwf   MCOUNT

b2dloop	rlf	REGA0,f		;Shift msb into carry
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f

        movlw   DIGIT10
        movwf   FSR             ;Pointer to digits
        movlw   D'10'           ;10 digits to do
        movwf   DCOUNT

adjlp	rlf	INDF,f		;Shift digit and carry 1 bit left
        movlw   -D'10'
	addwf	INDF,w		;Check and adjust for decimal overflow
	skpnc
        movwf   INDF

	decf	FSR,f		;Next digit
	decfsz	DCOUNT,f
        goto    adjlp

	decfsz	MCOUNT,f	;Next bit
        goto    b2dloop

	btfsc	MTEMP,0		;Check sign
	comf	DSIGN,f		;Negative
	clrc

BLANKIT: movlw 48
        iorwf DIGIT1,F
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
        iorwf DIGIT9,F
        iorwf DIGIT10,F

        movlw 10          ; blank leading zeros
        movwf LOOP
        movlw DIGIT1
        movwf FSR
BLANK:  movf LOOP,W
        movf INDF,W
        andlw 15
        btfss STATUS,Z
        return
        bcf INDF,4
        incf FSR,F
        decfsz LOOP,F
        goto BLANK
        movlw 48
        iorwf DIGIT10,F
        return

; **************

;Set all digits to 0
;Used by bin2dec

clrdig	clrf	DSIGN
	clrf	DIGIT1
	clrf	DIGIT2
	clrf	DIGIT3
	clrf	DIGIT4
	clrf	DIGIT5
	clrf	DIGIT6
	clrf	DIGIT7
	clrf	DIGIT8
	clrf	DIGIT9
	clrf	DIGIT10
        return

;UTILITY ROUTINES

;Check sign of REGA and convert negative to positive
;Used by bin2dec

chksgna	rlf	REGA3,w
	skpc
        return

;Negate REGA
;Used by bin2dec

negatea movf    REGA3,w         ;Save sign in w
	andlw	0x80

	comf	REGA0,f		;2's complement
	comf	REGA1,f
	comf	REGA2,f
	comf	REGA3,f
        incfsz  REGA0,f
        goto    nega1
        incfsz  REGA1,f
        goto    nega1
        incfsz  REGA2,f
        goto    nega1
        incf    REGA3,f
nega1
        incf    MTEMP,f         ;flip sign flag
        addwf   REGA3,w         ;return carry set if -2147483648
        return

SHOWDIGIT1 movf DIGIT1,W         ; show decimal values
           call LCDOUT
SHOWDIGIT2 movf DIGIT2,W
           call LCDOUT
SHOWDIGIT3 movf DIGIT3,W
           call LCDOUT
SHOWDIGIT4 movf DIGIT4,W
           call LCDOUT
SHOWDIGIT5 movf DIGIT5,W
           call LCDOUT
SHOWDIGIT6 movf DIGIT6,W
           call LCDOUT
SHOWDIGIT7 movf DIGIT7,W
           call LCDOUT
SHOWDIGIT8 movf DIGIT8,W
           call LCDOUT
SHOWDIGIT9 movf DIGIT9,W
           call LCDOUT
SHOWDIGIT10 movf DIGIT10,W
           call LCDOUT
           return

              END

