; TEACHINY01.ASM 17FEB08 - TEACH IN 2008 PTx

#DEFINE BANK0 BCF STATUS,5     ; define STATUS register bit 5 clear as BANK0
#DEFINE BANK1 BSF STATUS,5     ; define STATUS register bit 5 set as BANK1

           list p=16f628       ; tell MPASM-type programmer to create a
                               ; list (LST) file

           include p16f628.inc ; bring in all standard register values

           CBLOCK h'20'
RSLINE
STORE
LOOP
LOOPA
LOOPB
CLKCNT
HEX3
HEX2
HEX1
HEX0

DCOUNT        ; used by BIN2DEC routines
DSIGN
DIGIT1
DIGIT2
DIGIT3
DIGIT4
DIGIT5
DIGIT6
DIGIT7
DIGIT8
DIGIT9
DIGIT10

REGA0
REGA1
REGA2
REGA3
MTEMP
MCOUNT

COUNT0
COUNT1
	   ENDC

           __config  $3F30     ; internal 4MHz oscillator

           ORG 0               ; reset vector
           goto STARTIT
           ORG 4               ; Interrupt vector address
           goto STARTIT
           ORG 5               ; PIC program memory location at which to start 
           goto STARTIT

           include LCDheader.inc

MESSAG     addwf PCL,F
           retlw 'B'
           retlw 'I'
           retlw 'N'
           retlw '-'
           retlw 'H'
           retlw 'E'
           retlw 'X'
           retlw '-'
           retlw 'D'
           retlw 'E'
           retlw 'C'
           retlw ' '
           retlw 'C'
           retlw 'O'
           retlw 'N'
           retlw 'V'

MESSAG2    andlw 15
           addwf PCL,F
           retlw '0'
           retlw '1'
           retlw '2'
           retlw '3'
           retlw '4'
           retlw '5'
           retlw '6'
           retlw '7'
           retlw '8'
           retlw '9'
           retlw 'A'
           retlw 'B'
           retlw 'C'
           retlw 'D'
           retlw 'E'
           retlw 'F'

STARTIT    clrf PORTA          ; clear PORTA's outputs if any
           clrf PORTB          ; clear PORTB's output if any
           movlw $07           ; needed by some PICs, including PIC16F628
           movwf CMCON         ; so that PORTA is treated as digital port

           BANK1
           movlw b'00001111'   ; RA0-RA3 as input
           movwf TRISA         ; data direction register for PORTA
           movlw b'00000000'   ; PORTB as output
           movwf TRISB         ; data direction register for PORTB
           movlw b'10000110'   ; timer 1:128, pull-ups off (bit 7 = 1)
           movwf OPTION_REG
           BANK0

           call PAUSIT
           call LCDSET
	   call PAUSIT
	   call LCDMSG	    

           clrf LOOP
           clrf LOOPB
           clrf HEX3
           clrf HEX2
           clrf HEX1
           clrf HEX0
           call PAUSIT2
           call PAUSIT2
           call PAUSIT2
           call PAUSIT2
           call CLRLINE1
           goto OUTHEX

DIG0       movf PORTA,W
           andlw 15
           btfsc STATUS,Z
           goto DIG0
           clrf LOOP

DIG4       btfss PORTA,0
           goto DIG3
           incf HEX3,F
           bcf HEX3,4
           goto OUTHEX

DIG3       btfss PORTA,1
           goto DIG2
           incf HEX2,F
           bcf HEX2,4
           goto OUTHEX

DIG2       btfss PORTA,2
           goto DIG1
           incf HEX1,F
           bcf HEX1,4
           goto OUTHEX

DIG1       btfss PORTA,3
           goto DIG0
           incf HEX0,F
           bcf HEX0,4

OUTHEX     call LCD1
           bsf RSLINE,4
           movlw 'H'
           call LCDOUT
           movf HEX3,W
           call MESSAG2
           call LCDOUT
           movf HEX2,W
           call MESSAG2
           call LCDOUT
           movf HEX1,W
           call MESSAG2
           call LCDOUT
           movf HEX0,W
           call MESSAG2
           call LCDOUT
           movlw ' '
           call LCDOUT

           call HEXDEC
           call HEX2BIN

           call PAUSIT2
           goto DIG0

HEXDEC     swapf HEX3,W
           iorwf HEX2,W
           movwf COUNT1
           movwf REGA1
           swapf HEX1,W
           iorwf HEX0,W
           movwf COUNT0
           movwf REGA0
           clrf REGA2
           clrf REGA3
           call BIN2DEC
           call SHOWDIGIT5
           return

HEX2BIN    call LCD21
           bsf RSLINE,4
           movlw 16
           movwf LOOP
HEX2BIN2   rlf COUNT0,F
           rlf COUNT1,F
           movf STATUS,W
           andlw 1
           iorlw 48
           call LCDOUT
           decfsz LOOP,F
           goto HEX2BIN2
           return

PAUSIT     movlw 5             ; set delay counter to 5
           movwf CLKCNT        ; (for 1/25th sec x 5)
           clrf INTCON         ; clear interupt flag
PAUSE                          ; initial 1/5th sec wait before setting up LCD
           btfss INTCON,2      ; has a timer time-out been detected?
           goto PAUSE          ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto PAUSE          ; no
           return              ; yes

PAUSIT2    movlw 15            ; set delay counter to 15
           movwf CLKCNT        ; 
           clrf INTCON         ; clear interupt flag
PAUSE2                         ; 
           btfss INTCON,2      ; has a timer time-out been detected?
           goto PAUSE2         ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto PAUSE2         ; no
           return              ; yes

LCDMSG     clrf LOOP               ; clear loop
           call LCD1
           bsf RSLINE,4
LCDMS2     movf LOOP,W             ; get table address
           call MESSAG             ; get message letter
           call LCDOUT             ; show it
           incf LOOP,F             ; inc loop
           btfss LOOP,4            ; has last LCD letter been sent?
           goto LCDMS2             ; no, so repeat for next one
	   return                  ; return to the main program

           include LCDroutines.inc

; *********** PART OF PETER HEMSLEY'S 32-BIT MATHS ROUTINES *******

;*** SIGNED BINARY TO DECIMAL ***
;REGA -> DIGITS 1 (MSD) TO 10 (LSD) & DSIGN
;DSIGN = 0 if REGA is positive, FF if negative
;Return carry set if overflow
;Uses FSR register

bin2dec:
        call    clrdig          ;Clear all digits
        clrf    MTEMP           ;Reset sign flag
	call	chksgna		;Make REGA positive
	skpnc
        call    negatea         ;Negative

	movlw	D'32'		;Loop counter
	movwf	MCOUNT

b2dloop	rlf	REGA0,f		;Shift msb into carry
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f

	movlw	DIGIT10
	movwf	FSR		;Pointer to digits
	movlw	D'10'		;10 digits to do
	movwf	DCOUNT

adjlp	rlf	INDF,f		;Shift digit and carry 1 bit left
        movlw   -D'10'
	addwf	INDF,w		;Check and adjust for decimal overflow
	skpnc
	movwf	INDF

	decf	FSR,f		;Next digit
	decfsz	DCOUNT,f
	goto	adjlp

	decfsz	MCOUNT,f	;Next bit
	goto	b2dloop

	btfsc	MTEMP,0		;Check sign
	comf	DSIGN,f		;Negative
	clrc

BLANKIT: movlw 48
        iorwf DIGIT1,F
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
        iorwf DIGIT9,F
        iorwf DIGIT10,F

        movlw 10          ; blank leading zeros
        movwf LOOP
        movlw DIGIT1
        movwf FSR
BLANK:  movf LOOP,W
        movf INDF,W
        andlw 15
        btfss STATUS,Z
        return
        bcf INDF,4
        incf FSR,F
        decfsz LOOP,F
        goto BLANK
        movlw 48
        iorwf DIGIT10,F
        return

SHOWDIGIT1 movf DIGIT1,W         ; show decimal values
           call LCDOUT
SHOWDIGIT2 movf DIGIT2,W
           call LCDOUT
SHOWDIGIT3 movf DIGIT3,W
           call LCDOUT
SHOWDIGIT4 movf DIGIT4,W
           call LCDOUT
SHOWDIGIT5 movf DIGIT5,W
           call LCDOUT
SHOWDIGIT6 movf DIGIT6,W
           call LCDOUT
SHOWDIGIT7 movf DIGIT7,W
           call LCDOUT
SHOWDIGIT8 movf DIGIT8,W
           call LCDOUT
SHOWDIGIT9 movf DIGIT9,W
           call LCDOUT
SHOWDIGIT10 movf DIGIT10,W
           call LCDOUT
             return

;Set all digits to 0
;Used by bin2dec

clrdig	clrf	DSIGN
	clrf	DIGIT1
	clrf	DIGIT2
	clrf	DIGIT3
	clrf	DIGIT4
	clrf	DIGIT5
	clrf	DIGIT6
	clrf	DIGIT7
	clrf	DIGIT8
	clrf	DIGIT9
	clrf	DIGIT10
	return

;Check sign of REGA and convert negative to positive
;Used by multiply, divide, bin2dec

chksgna	rlf	REGA3,w
	skpc
	return

;Negate REGA
;Used by multiply, divide, bin2dec, dec2bin

negatea	movf	REGA3,w		;Save sign in w
	andlw	0x80

	comf	REGA0,f		;2's complement
	comf	REGA1,f
	comf	REGA2,f
	comf	REGA3,f
	incfsz	REGA0,f
	goto	nega1
	incfsz	REGA1,f
	goto	nega1
	incfsz	REGA2,f
	goto	nega1
	incf	REGA3,f
nega1
	incf	MTEMP,f		;flip sign flag
	addwf	REGA3,w		;Return carry set if -2147483648
	return

           END
