; FRUIT216.ASM 28JAN08

#DEFINE BANK0 BCF STATUS,5     ; define STATUS register bit 5 clear as BANK0
#DEFINE BANK1 BSF STATUS,5     ; define STATUS register bit 5 set as BANK1

           list p=16f628       ; tell MPASM-type programmer to create a
                               ; list (LST) file

           include p16f628.inc ; bring in all standard register values

           CBLOCK h'20'
RSLINE
STORE
LOOP
LOOPA
CLKCNT
STORE2
STORE3

RANDOM1
RANDOM2
RANDOM3
RANDOM4
XORGATE1
XORGATE2
SRANDOM1
SRANDOM2
SRANDOM3
JACKPOT0
JACKPOT1
JACKPOT2
JACKPOT3
PAYOUT0
PAYOUT1
PAYOUT2
PAYOUT3

DCOUNT        ; used by BIN2DEC routines
DSIGN
DIGIT1
DIGIT2
DIGIT3
DIGIT4
DIGIT5
DIGIT6
DIGIT7
DIGIT8
DIGIT9
DIGIT10

REGA0
REGA1
REGA2
REGA3
REGB0
REGB1
REGB2
REGB3
REGC0
REGC1
REGC2
REGC3
MTEMP
MCOUNT

	ENDC

	CBLOCK h'70'
PROMVAL
	ENDC

           __config  $3F30     ; internal 4MHz oscillator

           ORG 0               ; reset vector
           goto STARTIT
           ORG 4               ; Interrupt vector address
           goto STARTIT
           ORG 5               ; PIC program memory location at which to start 
           goto STARTIT

        include LCDHEADER.inc

TABLENOLUCK
        addwf PCL,F
        retlw 'N'  ;0
        retlw 'O'  ;1
        retlw ' '  ;2
        retlw 'L'  ;3
        retlw 'U'  ;4
        retlw 'C'  ;5
        retlw 'K'  ;6
        retlw ' '  ;7
        retlw 'N'  ;8
        retlw 'O'  ;9
        retlw 'W'  ;10
        retlw '!'  ;11
        retlw ' '  ;12
        retlw ' '  ;13
        retlw ' '  ;14
        retlw ' '  ;15

TABLEWINS
        addwf PCL,F
        retlw 'W'  ;0
        retlw 'I'  ;1
        retlw 'N'  ;2
        retlw 'N'  ;3
        retlw 'I'  ;4
        retlw 'N'  ;5
        retlw 'G'  ;6
        retlw 'S'  ;7

STARTIT    clrf PORTA          ; clear PORTA's output if any
           clrf PORTB          ; clear PORTB's output if any
           movlw $07           ; needed by some PICs, including PIC16F628
           movwf CMCON         ; so that PORTA is treated as digital port

           BANK1
           movlw b'00001111'   ; RA0-RA3 as input
           movwf TRISA         ; data direction register for PORTA
           movlw b'00000000'   ; PORTB as output
           movwf TRISB         ; data direction register for PORTB
           movlw b'10000110'   ; timer 1:128, pull-ups off (bit 7 = 1)
           movwf OPTION_REG
           BANK0

           call PAUSIT
           call LCDSET
	   call PAUSIT

        movlw 0                ; get random seed
        call PRMGET
        movwf RANDOM1
        movlw 0
        call PRMGET
        addlw 1                ; inc random seed value
        btfsc STATUS,Z         ; avoid zero value
        addlw 1
        movwf PROMVAL
        movlw 0
        call SETPRM            ; store new seed value

           call SETRANDOM
           call UPDATEALL
           call SHOWIT
           clrf JACKPOT0
           clrf JACKPOT1
           clrf JACKPOT2
           clrf JACKPOT3

           clrf PAYOUT0
           clrf PAYOUT1
           clrf PAYOUT2
           clrf PAYOUT3
           call SHOWJACKPOT
           call DOPAYOUT

MAIN       btfsc PORTA,0
           goto MAIN3
           goto MAIN

MAIN3      incf JACKPOT0,F
           call SHOWJACKPOT
           call CLRLINE2

MAIN2      call SETRANDOM
           call UPDATEALL
           btfsc PORTA,0
           goto MAIN2
           call CHECK12
           goto MAIN

SHOWIT     call LCD1
           bsf RSLINE,4        ; set RS for data send
           movf SRANDOM1,W
           iorlw 48
           call LCDOUT
           movf SRANDOM2,W
           iorlw 48
           call LCDOUT
           movf SRANDOM3,W
           iorlw 48
           call LCDOUT
           return

PAUSIT     movlw 5             ; set delay counter to 5
           movwf CLKCNT        ; (for 1/25th sec x 5)
           clrf INTCON         ; clear interupt flag
PAUSE                          ; initial 1/5th sec wait before setting up LCD
           btfss INTCON,2      ; has a timer time-out been detected?
           goto PAUSE          ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto PAUSE          ; no
           return              ; yes

        include LCDROUTINES.inc

LCD5:    movlw %10000101
         goto LCDLIN
LCD8:    movlw %10001000
         goto LCDLIN

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F62x devices ********

                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in PROMVAL.
SETPRM: BANK1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        movf PROMVAL,W  ;get data value and hold in W
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf EECON1,WREN ;enable write MASK

MANUAL: movlw $55       ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw $AA       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
	BANK0

CHKWRT: btfss PIR1,EEIF ;wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR1,EEIF   ;clear bit 4 of PIR2
        return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F62x devices ****

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: BANK1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf EECON1,RD   ;enable read MASK
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
	BANK0
        return

***********

SETRANDOM: clrf XORGATE1
        clrf XORGATE2
        btfsc RANDOM1,2
        bsf XORGATE1,0
        btfsc RANDOM4,6
        bsf XORGATE2,0
        bcf STATUS,C
        movf XORGATE1,W
        xorwf XORGATE2,W
        btfsc STATUS,Z
        bsf STATUS,C
        rrf RANDOM1,F
        rrf RANDOM2,F
        rrf RANDOM3,F
        rrf RANDOM4,F
        return

UPDATEALL
        movf RANDOM1,W
        andlw 3
        movwf SRANDOM1
        movf RANDOM2,W
        andlw 3
        movwf SRANDOM2
        movf RANDOM3,W
        andlw 3
        movwf SRANDOM3
        call SHOWIT
        return

CHECK12 call LCD5
        bsf RSLINE,4        ; set RS for data send
        movf SRANDOM1,W
        xorwf SRANDOM2,W
        btfsc STATUS,Z
        call CHECKALL
        goto CHECK13

CHECKALL   movf SRANDOM1,W
           btfsc STATUS,Z   ; is it 0 ?
           return           ; yes
           xorwf SRANDOM3,W ; is it equal
           btfss STATUS,Z
           goto CHECKNUDGE3 ; no
           goto DOPAYOUT    ; yes

CHECKNUDGE1 movlw 1
        movwf STORE2
        movf SRANDOM2,W
        movwf STORE3
        call SHOWNUDGE

NUDGE1  call SETRANDOM
        movf RANDOM1,W
        andlw 3
        movwf SRANDOM1
        call SHOWIT
        movlw ' '
        call LCDOUT
        btfsc PORTA,2
        goto CHEAT
        btfss PORTA,1
        goto NUDGE1

        movf SRANDOM1,W
        xorwf SRANDOM2,W  ; is it equal
        btfsc STATUS,Z
        goto DOPAYOUT
        btfss PORTA,2
        goto NOLUCK
        goto NUDGE1

CHECKNUDGE2 movlw 2
        movwf STORE2
        movf SRANDOM1,W
        movwf STORE3
        call SHOWNUDGE

NUDGE2  call SETRANDOM
        movf RANDOM2,W
        andlw 3
        movwf SRANDOM2
        call SHOWIT
        movlw ' '
        call LCDOUT
        btfsc PORTA,2
        goto CHEAT
        btfss PORTA,1
        goto NUDGE2

        movf SRANDOM1,W
        xorwf SRANDOM2,W  ; is it equal
        btfsc STATUS,Z
        goto DOPAYOUT
        btfss PORTA,2
        goto NOLUCK
        goto NUDGE2

CHECKNUDGE3 movlw 3
        movwf STORE2
        movf SRANDOM1,W
        movwf STORE3
        call SHOWNUDGE

NUDGE3  call SETRANDOM
        movf RANDOM3,W
        andlw 3
        movwf SRANDOM3
        call SHOWIT
        movlw ' '
        call LCDOUT
        btfsc PORTA,2
        goto CHEAT
        btfss PORTA,1
        goto NUDGE3

        movf SRANDOM1,W
        xorwf SRANDOM3,W  ; is it equal
        btfsc STATUS,Z
        goto DOPAYOUT
        btfss PORTA,2
        goto NOLUCK
        goto NUDGE3

SHOWNUDGE  call CLRLINE2
        call LCD21
        bsf RSLINE,4        ; set RS for data send
        movlw 'N'
        call LCDOUT
        movlw 'U'
        call LCDOUT
        movlw 'D'
        call LCDOUT
        movlw 'G'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movf STORE2,W
        iorlw 48
        call LCDOUT

CN1     btfsc PORTA,2
        goto CN2   
        btfss PORTA,1
        goto CN1

CN2     call CLRLINE2
        return

CHEAT   incf JACKPOT0,F
        call SHOWJACKPOT
CHEAT2  call SETRANDOM
;        call UPDATEALL
;        call SHOWIT
;        btfsc PORTA,2
;        goto CHEAT2
        movf STORE3,W
        movwf SRANDOM1
        movwf SRANDOM2
        movwf SRANDOM3
        call SHOWIT
        goto DOPAYOUT

CHECK13    movf SRANDOM1,W
           xorwf SRANDOM3,W
           btfss STATUS,Z
           goto CHECK23
           goto CHECKNUDGE2

CHECK23    movf SRANDOM2,W
           xorwf SRANDOM3,W
           btfss STATUS,Z
           goto NOLUCK
           goto CHECKNUDGE1

SHOWJACKPOT call LCD5
        bsf RSLINE,4        ; set RS for data send
        movlw 'J'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw 'K'
        call LCDOUT
        movlw 'P'
        call LCDOUT
        movlw 'O'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        movf JACKPOT0,W
        movwf REGA0
        movf JACKPOT1,W
        movwf REGA1
        movf JACKPOT2,W
        movwf REGA2
        movf JACKPOT3,W
        movwf REGA3
        call bin2dec
        call SHOWDIGIT7
        return

DOPAYOUT call LCD21
        bsf RSLINE,4        ; set RS for data send
        movf JACKPOT0,W
        movwf REGA0
        movf JACKPOT1,W
        movwf REGA1
        movf JACKPOT2,W
        movwf REGA2
        movf JACKPOT3,W
        movwf REGA3

        movf SRANDOM1,W
        btfsc STATUS,Z   ; is it 0 ?
        movlw 10         ; yes, set to 10

        movwf REGB0
        clrf REGB1
        clrf REGB2
        clrf REGB3
        call MULTIPLY32
        movf PAYOUT0,W
        movwf REGB0
        movf PAYOUT1,W
        movwf REGB1
        movf PAYOUT2,W
        movwf REGB2
        movf PAYOUT3,W
        movwf REGB3
        call ADD

        movf REGA0,W
        movwf PAYOUT0
        movf REGA1,W
        movwf PAYOUT1
        movf REGA2,W
        movwf PAYOUT2
        movf REGA3,W
        movwf PAYOUT3
        call BIN2DEC
        call WINS
        call SHOWDIGIT3
WAIT    btfss PORTA,0
        goto WAIT
        clrf JACKPOT0
        clrf JACKPOT1
        clrf JACKPOT2
        call SHOWJACKPOT
        return

NOLUCK  call LCD21
        bsf RSLINE,4        ; set RS for data send
        clrf LOOP
NL2     movf LOOP,W     ;get table address
        call TABLENOLUCK
        call LCDOUT     ;perform it
        incf LOOP,F     ;inc loop
        btfss LOOP,4    ;has last been done?
        goto NL2        ;no
        return

WINS    call LCD21
        bsf RSLINE,4        ; set RS for data send
        clrf LOOP
WN2     movf LOOP,W     ;get table address
        call TABLEWINS
        call LCDOUT     ;perform it
        incf LOOP,F     ;inc loop
        btfss LOOP,3 ;4    ;has last been done?
        goto WN2        ;no
        return

; *********** PART OF PETER HEMSLEY'S 32-BIT MATHS ROUTINES *******

;*** SIGNED BINARY TO DECIMAL ***
;REGA -> DIGITS 1 (MSD) TO 10 (LSD) & DSIGN
;DSIGN = 0 if REGA is positive, FF if negative
;Return carry set if overflow
;Uses FSR register

bin2dec:
        call    clrdig          ;Clear all digits
        clrf    MTEMP           ;Reset sign flag
	call	chksgna		;Make REGA positive
	skpnc
        call    negatea         ;Negative

	movlw	D'32'		;Loop counter
	movwf	MCOUNT

b2dloop	rlf	REGA0,f		;Shift msb into carry
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f

	movlw	DIGIT10
	movwf	FSR		;Pointer to digits
	movlw	D'10'		;10 digits to do
	movwf	DCOUNT

adjlp	rlf	INDF,f		;Shift digit and carry 1 bit left
        movlw   -D'10'
	addwf	INDF,w		;Check and adjust for decimal overflow
	skpnc
	movwf	INDF

	decf	FSR,f		;Next digit
	decfsz	DCOUNT,f
	goto	adjlp

	decfsz	MCOUNT,f	;Next bit
	goto	b2dloop

	btfsc	MTEMP,0		;Check sign
	comf	DSIGN,f		;Negative
	clrc

BLANKIT: movlw 48
        iorwf DIGIT1,F
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
        iorwf DIGIT9,F
        iorwf DIGIT10,F

        movlw 10          ; blank leading zeros
        movwf LOOP
        movlw DIGIT1
        movwf FSR
BLANK:  movf LOOP,W
        movf INDF,W
        andlw 15
        btfss STATUS,Z
        return
        bcf INDF,4
        incf FSR,F
        decfsz LOOP,F
        goto BLANK
        movlw 48
        iorwf DIGIT10,F
        return

; **************

;Set all digits to 0
;Used by bin2dec

clrdig	clrf	DSIGN
	clrf	DIGIT1
	clrf	DIGIT2
	clrf	DIGIT3
	clrf	DIGIT4
	clrf	DIGIT5
	clrf	DIGIT6
	clrf	DIGIT7
	clrf	DIGIT8
	clrf	DIGIT9
	clrf	DIGIT10
	return

;*** SIGNED ADD ***
;REGA + REGB -> REGA
;Return carry set if overflow

add:    movf    REGA3,w         ;Compare signs
	xorwf	REGB3,w
	movwf	MTEMP

	call	addba		;Add REGB to REGA

	clrc			;Check signs
	movf	REGB3,w		;If signs are same
	xorwf	REGA3,w		;so must result sign
	btfss	MTEMP,7		;else overflow
	addlw	0x80
	return

; **********

;*** SIGNED 32 BIT INTEGER MATHS ROUTINES FOR PIC16 SERIES BY PETER HEMSLEY JAN 2003 ***

;*** SIGNED MULTIPLY ***
;REGA * REGB -> REGA
;Return carry set if overflow

multiply32
	clrf	MTEMP
	call	chksgna		;Make REGA positive
	skpnc
	return			;Overflow
	call	chksgnb		;Make REGB positive
	skpnc
	return			;Overflow

	call	movac		;Move REGA to REGC
	call	clra		;Clear product

	movlw	D'31'		;Loop counter
	movwf	MCOUNT

muloop	call	slac		;Shift left product and multiplicand

	rlf	REGA3,w
	skpnc			;Check for overflow
	return

	btfss	REGC3,7		;If multiplicand bit is a 1 then
	goto	nxtmul
	call	addba		;add multiplier to product

	rlf	REGA3,w
	skpnc			;Check for overflow
	return

nxtmul	decfsz	MCOUNT,f	;Next
	goto	muloop

	btfsc	MTEMP,0		;Check result sign
	call	negatea		;Negative
	return

;UTILITY ROUTINES

;Add REGB to REGA
;Used by add, multiply

addba	movf	REGB0,w		;Add lo byte
	addwf	REGA0,f

	movf	REGB1,w		;Add mid-lo byte
	skpnc			;No carry_in, so just add
	incfsz	REGB1,w		;Add carry_in to REGB
	addwf	REGA1,f		;Add and propagate carry_out

	movf	REGB2,w		;Add mid-hi byte
	skpnc
	incfsz	REGB2,w
	addwf	REGA2,f

	movf	REGB3,w		;Add hi byte
	skpnc
	incf	REGB3,w
	addwf	REGA3,f
	return

;Move REGA to REGC
;Used by multiply, sqrt

movac	movf	REGA0,w
	movwf	REGC0
	movf	REGA1,w
	movwf	REGC1
	movf	REGA2,w
	movwf	REGC2
	movf	REGA3,w
	movwf	REGC3
	return

;Clear REGA
;Used by multiply, sqrt

clra	clrf	REGA0
	clrf	REGA1
	clrf	REGA2
	clrf	REGA3
	return

;Check sign of REGA and convert negative to positive
;Used by multiply, divide, bin2dec

chksgna	rlf	REGA3,w
	skpc
	return

;Negate REGA
;Used by multiply, divide, bin2dec, dec2bin

negatea	movf	REGA3,w		;Save sign in w
	andlw	0x80

	comf	REGA0,f		;2's complement
	comf	REGA1,f
	comf	REGA2,f
	comf	REGA3,f
	incfsz	REGA0,f
	goto	nega1
	incfsz	REGA1,f
	goto	nega1
	incfsz	REGA2,f
	goto	nega1
	incf	REGA3,f
nega1
	incf	MTEMP,f		;flip sign flag
	addwf	REGA3,w		;Return carry set if -2147483648
	return

;Check sign of REGB and negative convert to positive
;Used by multiply, divide

chksgnb	rlf	REGB3,w
	skpc
	return

;Negate REGB
;Used by subtract, multiply, divide

negateb	movf	REGB3,w		;Save sign in w
	andlw	0x80

	comf	REGB0,f		;2's complement
	comf	REGB1,f
	comf	REGB2,f
	comf	REGB3,f
	incfsz	REGB0,f
	goto	negb1
	incfsz	REGB1,f
	goto	negb1
	incfsz	REGB2,f
	goto	negb1
	incf	REGB3,f
negb1
	incf	MTEMP,f		;flip sign flag
	addwf	REGB3,w		;Return carry set if -2147483648
	return

;Shift left REGA and REGC
;Used by multiply, divide

slac	rlf	REGA0,f
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f
	rlf	REGC0,f
	rlf	REGC1,f
	rlf	REGC2,f
	rlf	REGC3,f
	return

SHOWDIGIT1 movf DIGIT1,W         ; show decimal values
           call LCDOUT
SHOWDIGIT2 movf DIGIT2,W
           call LCDOUT
SHOWDIGIT3 movf DIGIT3,W
           call LCDOUT
SHOWDIGIT4 movf DIGIT4,W
           call LCDOUT
SHOWDIGIT5 movf DIGIT5,W
           call LCDOUT
SHOWDIGIT6 movf DIGIT6,W
           call LCDOUT
SHOWDIGIT7 movf DIGIT7,W
           call LCDOUT
SHOWDIGIT8 movf DIGIT8,W
           call LCDOUT
SHOWDIGIT9 movf DIGIT9,W
           call LCDOUT
SHOWDIGIT10 movf DIGIT10,W
           call LCDOUT
	   return

        org H'2100'      ; data eeprom address

        DE 1           ; random seed number



           END
