'ALARM SYSTEM WITH KEY-SWITCH CONTROL

'INSTRUCTIONS:
'	To set, switch on keyswitch; you have 20 secs to exit
'		during this time, small buzzer pulses
'	To unset, enter by zone4 then turn off keyswitch
'		you have 20 secs to switch off, small buz pulses
'	If alarm triggered, siren sounds for 10 minutes
'	At end of 10 mins or if keyswitch switched off, then
'		lights indicate which zone was triggered
'	For full reset, switch keyswitch on then off

	
'Keyswitch SW5 on RA7 = pin7 (actual pin16)
'zone 1, SW1, normally open, RA0 = pin0 (actual pin 17)
'zone 2, SW2, normally open, RA1 = pin1 (actual pin 18)
'zone 3, SW3, normally closed, RA2 = pin2 (actual pin 1)
'zone 4, SW4, normally closed, RA6 = pin6 (actual pin15) timed


'zone1 = D1 = RB0
'zone2 = D2 = RB1
'zone3 = D3 = RB2
'zone4 = D4 = RB3

'indicator buzzer = RB4
'SIREN = RB7


hold:	wait 1			'pauses 1 secs
				' while you switch keyswitch off

start:
	let pins = 0		'resets all outputs to zero
	pause 50		'anti-bounce
	if pin7 = 1 then setalarm
	goto start

setalarm:	
	gosub timed20		'exit: pause & bleep for 20 secs

check:
	if pin7 = 0 then start
	if pin6 = 1 then timed	'timed entry via zone4
	if pin0 = 1 then zone1
	if pin1 = 1 then zone2
	if pin2 = 1 then zone3
	goto check

zone1:
	pause 50		'checks for stray interference
	if pin0 = 0 then check	' if pulse too short, ignore
	high 0			'lights D1
	goto siren

zone2:
	pause 50		'checks for stray interference
	if pin1 = 0 then check	' if pulse too short, ignore
	high 1			'lights D2
	goto siren

zone3:
	pause 50		'checks for stray interference
	if pin2 = 0 then check	' if pulse too short, ignore
	high 2			'lights D3
	goto siren	

timed:
	pause 50		'checks for stray interference
	if pin6 = 0 then check	' if pulse too short, ignore
	high 3			'lights D4
	gosub timed20

siren:
	let b1 = 0
	high 7			'turns on siren
	let b1 = b1+1
	if b1 = 30 then semioff	'times for 20secs X 30 = 10mins
	gosub timed20
	goto siren
	
semioff:
	low 7			'turns off siren
	pause 100		'anti-bounce
	if pin7 = 1 then hold	'resets lights
	goto semioff


timed20:
	for b0 = 1 to 200	'loop to pause
	high 4			' 200 X 100 = 20000ms = 20secs
	pause 70
	low 4
	pause 30
	if pin7 = 0 then semioff
	next b0
	return





