'TY2KH001 21FEB00 - EPE TEACH-IN 2000 V1.1
SCREEN 9: COLOR 15, 1: ld = 2500
DIM seg$(255), a(20), matrix$(255), ledyel%(1100), ledoff%(1100)
DIM led0%(ld), led1%(ld), led2%(ld), led3%(ld), led4%(ld)
DIM led5%(ld), led6%(ld), led7%(ld), led8%(ld), led9%(ld)
DIM ledclear%(ld)

DIM led10%(ld), led11%(ld), led12%(ld), led13%(ld), led14%(ld)
DIM led15%(ld), led16%(ld), led17%(ld), led18%(ld), led19%(ld)

DIM h%(1000), menu$(40): version$ = "V1.1": ' CLS
LINE (2, 2)-(637, 347), 15, B
LINE (5, 5)-(634, 344), 15, B: PAINT (3, 3), 7, 15: COLOR 14

CONST pi = 3.141592653589# / 180: ' DEFDBL V

' Data values in order of key identity, then segments A to G.
' "0000000" following the key identity signifies non-availability
' with a standard 7-segment display

DATA 01111110
DATA 10110000
DATA 21101101
DATA 31111001
DATA 40110011
DATA 51011011
DATA 60011111
DATA 71110000
DATA 81111111
DATA 91110011
DATA A1110111
DATA a0000000
DATA B0000000
DATA b0011111
DATA C1001110
DATA c0001101
DATA D0000000
DATA d0111101
DATA E1001111
DATA e0000000
DATA F1000111
DATA f0000000
DATA G1011111
DATA g0000000
DATA H0110111
DATA h0010111
DATA I0110000
DATA i0010000
DATA J0111100
DATA j0000000
DATA K0000000
DATA k0000000
DATA L0001110
DATA l0000110
DATA M0000000
DATA m0000000
DATA N0000000
DATA n0010101
DATA O1111110
DATA o0011101
DATA P1100111
DATA p0000000
DATA Q0000000
DATA q0000000
DATA R0000000
DATA r0000101
DATA S1011011
DATA s0000000
DATA T0000000
DATA t0000000
DATA U0111110
DATA u0011100
DATA V0000000
DATA v0000000
DATA W0000000
DATA w0000000
DATA X0000000
DATA x0000000
DATA Y0000000
DATA y0111011
DATA Z0000000
DATA z0000000
DATA *

DATA "7-SEGMENT DISPLAY - BASICS        0 TY2KH001"
DATA "7-SEGMENT LED DISPLAY - DETAIL    1 TY2KH001"
DATA "7-SEGMENT LED DISPLAY - MULTIPLEX 2 TY2KH001"
DATA "MATRIXED DISPLAYS - BASICS        3 TY2KH001"
DATA "LCD DISPLAYS - PRINCIPLE          4 TY2KH001"
DATA "MAIN MENU                         5 TY2KMENU"
DATA *

GOSUB clearit

LOCATE 10, 35: PRINT "SETTING UP"
LINE (2, 2)-(637, 347), 15, B
LINE (5, 5)-(634, 344), 15, B: PAINT (3, 3), 7, 15
GOSUB setup: LOCATE 10, 35: PRINT "          ": a = 0

setmenu: READ menu$(a): IF menu$(a) <> "*" THEN a = a + 1: GOTO setmenu
maxmenu = a - 1: menucolumn = CINT(maxmenu / 2) + 1: l = LEN(menu$(0)) - 10
menu$(a) = ""

menu: GOSUB clearit: COLOR 14
LOCATE 2, 24: PRINT "TEACH-IN 2000 DISPLAYS MENU "; version$: COLOR 15
LINE (154 + 16, 35 - 26)-(456 + 16 - 14, 63 - 30), 15, B: LINE (157 + 16, 38 - 26)-(453 + 16 - 14, 60 - 30), 15, B
PAINT (155 + 16, 36 - 26), 7, 15: COLOR 11

FOR a = 0 TO menucolumn - 1: LOCATE a + 4, 4: PRINT LEFT$(menu$(a), l)
LOCATE a + 4, 43: PRINT LEFT$(menu$(a + menucolumn), l): NEXT

COLOR 14: LOCATE 23, 19: PRINT "SELECT WITH CURSOR ARROWS THEN PRESS <ENTER>"
COLOR 14: LOCATE 24, 27: PRINT "M"; : COLOR 11: PRINT " AND "; : COLOR 14
PRINT "Q "; : COLOR 11: PRINT "ALSO CALL MAIN MENU"; : LOCATE 1, 1

ac = (band \ menucolumn) * 39 + 3: dn = band MOD menucolumn + 3
GOSUB highlight

getkey: a$ = INKEY$: IF a$ = "" THEN GOTO getkey
IF UCASE$(a$) = "M" THEN CHAIN "TY2KMENU"
IF UCASE$(a$) = "Q" THEN CHAIN "TY2KMENU"
IF a$ = CHR$(13) THEN GOTO 20
a$ = UCASE$(MID$(a$, 2)): IF a$ = "" THEN GOTO getkey
IF a$ = "M" THEN band = band + menucolumn: GOTO 10:  'right
IF a$ = "K" THEN band = band - menucolumn: GOTO 10: 'left
IF a$ = "P" THEN band = band + 1: GOTO 10: 'down
IF a$ = "H" THEN band = band - 1: GOTO 10: 'up
IF a$ = "G" THEN band = 0: GOTO 10: 'home
IF a$ = "O" THEN band = maxmenu: GOTO 10: 'end
IF a$ = "Q" THEN band = menucolumn - 1: GOTO 10: 'page down
IF a$ = "I" THEN band = 0: GOTO 10: 'page up
GOTO getkey

10 : IF band > maxmenu THEN band = maxmenu ELSE IF band < 0 THEN band = 0

GOSUB highlight: ac = (band \ menucolumn) * 39 + 3
dn = band MOD menucolumn + 3: GOSUB highlight: GOTO getkey

20 : menu$ = RIGHT$(menu$(band), 8): menu = VAL(RIGHT$(menu$(band), 10))
menupath = menu + 1

30 : ON menupath GOTO 100, 200, 300, 400, 500, mainmenu

mainmenu: CHAIN "TY2KMENU"

'....................

100 : '7-SEGMENT DISPLAY - BASIC
GOSUB clearit
COLOR 14: LOCATE 2, 23: PRINT "7-SEGMENT DISPLAY - BASIC PRINCIPLE"
COLOR 14: LOCATE 4, 12: PRINT "MENU - PRESS <ENTER> "; : COLOR 11
PRINT "(ALL OTHER KEYS ARE FOR THE DISPLAY)": COLOR 10

COLOR 10: LOCATE 21, 34: PRINT "A B C D E F G"
z$ = "8": v = ASC(z$): GOTO seg2

segroute: z$ = INKEY$: IF z$ = "" THEN GOTO segroute
IF z$ = CHR$(13) THEN GOTO menu

v = ASC(z$):
IF z$ >= "a" AND z$ <= "z" THEN z$ = UCASE$(z$): v = ASC(z$): GOTO seg2
IF z$ >= "A" AND z$ <= "Z" THEN z$ = LCASE$(z$): v = ASC(z$)

seg2: a$ = seg$(v): FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * 14
col2 = VAL(MID$(a$, c, 1)) * 10
COLOR 14: LOCATE 22, 32 + (c * 2): PRINT MID$(a$, c, 1)
ON c GOSUB sa, sb, sc, sd, se, sf, sg: NEXT

COLOR 11: LOCATE 20, 31: PRINT "TURN-ON LOGIC FOR "; : COLOR 15: PRINT z$
LOCATE 23, 22: IF VAL(a$) = 0 THEN GOTO seg3
PRINT "                                      ": GOTO segroute
seg3: COLOR 14: PRINT " NOT FEASIBLE WITH 7-SEGMENT DISPLAY"
LOCATE 22, 32: PRINT "                ": GOTO segroute

sa: x = 34 * 8: x1 = x + 80 + 4: y = (4 + 3) * 14: y1 = y + 6:
LINE (x, y)-(x1, y1), col, BF: COLOR col2: LOCATE 7, 40: PRINT "A": RETURN

sb: x = 45 * 8: x1 = x + 8: y = (5 + 3) * 14 - 4: y1 = y + 60 - 4
LINE (x, y)-(x1, y1), col, BF: COLOR col2: LOCATE 10, 48: PRINT "B": RETURN

sc: x = 45 * 8: x1 = x + 8: y = (10 + 3) * 14 + 0 - 4: y1 = y + 60 - 4
LINE (x, y)-(x1, y1), col, BF: COLOR col2: LOCATE 15, 48: PRINT "C": RETURN

sd: x = 34 * 8: x1 = x + 80 + 4: y = (14 + 3) * 14 + 8 - 4 - 4: y1 = y + 6:
LINE (x, y)-(x1, y1), col, BF: COLOR col2: LOCATE 17, 40: PRINT "D": RETURN

sg: x = 34 * 8: x1 = x + 80 + 4: y = (9 + 3) * 14 + 4 - 4: y1 = y + 6:
LINE (x, y)-(x1, y1), col, BF: COLOR col2: LOCATE 12, 40: PRINT "G": RETURN

se: x = 33 * 8 - 4: x1 = x + 8: y = (10 + 3) * 14 + 0 - 4: y1 = y + 60 - 4
LINE (x, y)-(x1, y1), col, BF: COLOR col2: LOCATE 15, 32: PRINT "E": RETURN

sf: x = 33 * 8 - 4: x1 = x + 8: y = (5 + 3) * 14 - 4: y1 = y + 60 - 4
LINE (x, y)-(x1, y1), col, BF: COLOR col2: LOCATE 10, 32: PRINT "F": RETURN

'..................

200 : '7-SEGMENT LED DISPLAY - SINGLE
GOSUB clearit
COLOR 14: LOCATE 2, 26: PRINT "7-SEGMENT LED DISPLAY DETAIL": COLOR 10
LOCATE 3, 22: PRINT "CONTROLS: A-G    MENU - PRESS <ENTER> ";
LOCATE 4, 32: PRINT "N = NOTES ON/OFF": COLOR 14
n = 1: GOSUB lednotes

GOSUB LEDsetup: FOR a = 1 TO 7: led(a) = 1: NEXT: GOTO seg22

segroute2: z$ = INKEY$: IF z$ = "" THEN GOTO segroute2
IF z$ = CHR$(13) THEN GOTO menu
IF UCASE$(z$) = "N" THEN n = (n + 1) AND 1: GOSUB lednotes

v = ASC(UCASE$(z$)) - 64: IF v < 1 OR v > 7 THEN GOTO segroute2
led(v) = (led(v) + 1) AND 1

seg22: ac = (4 * 8) - 15: dn = 10 * 14 + 29

FOR c = 1 TO 7: col = led(c) * 4 + 8: col2 = led(c) * 3 + 7
COLOR 14: LOCATE 9, (c * 4) - 1: PRINT led(c)
LOCATE 17, (c * 4) + 46: PRINT (led(c) + 1) AND 1
IF led(c) = 1 THEN PUT (ac, dn), ledyel%, PSET: PUT (ac + 376, dn), ledyel%, PSET
IF led(c) = 0 THEN PUT (ac, dn), ledoff%, PSET: PUT (ac + 376, dn), ledoff%, PSET
ac = ac + 32: ON c GOSUB sa, sb, sc, sd, se, sf, sg: NEXT: GOTO segroute2

LEDsetup: COLOR 11: ac = (4 * 8) - 5: dn = 10 * 14 - 5

LINE (ac, dn - 15)-(ac, dn): 'resistor
dn = dn + 2: LINE -(ac + 4, dn): dn = dn + 4: LINE -(ac - 4, dn)
dn = dn + 4: LINE -(ac + 4, dn): dn = dn + 4: LINE -(ac - 4, dn)
dn = dn + 4: LINE -(ac + 4, dn): dn = dn + 2: LINE -(ac, dn)
dn = dn + 14: LINE -(ac, dn + 74)

COLOR 8: x3 = ac: y = 12 * 14 + 7
LINE (x3 - 8, y)-(x3 + 8, y): 'LED symbol (off colour)
LINE -(x3, y + 14): LINE -(x3 - 8, y): PAINT (x3 + 1, y + 2), 8, 8
LINE (x3 - 8, y + 14)-(x3 + 8, y + 16), , BF

LINE (x3 + 12, y + 2)-(x3 + 18, y + 2): 'LED arrows
LINE -(x3 + 14, y - 2): LINE (x3 + 18, y + 2)-(x3 + 14, y + 6)
LINE (x3 + 12, y + 12)-(x3 + 18, y + 12): LINE -(x3 + 14, y + 8)
LINE (x3 + 18, y + 12)-(x3 + 14, y + 16)
dn = 10 * 14 + 3: GET (ac - 10, dn + 26)-(ac + 20, dn + 52), ledoff%

COLOR 12: x3 = ac: y = 12 * 14 + 7
LINE (x3 - 8, y)-(x3 + 8, y): 'LED symbol (on colour)
LINE -(x3, y + 14): LINE -(x3 - 8, y): PAINT (x3 + 1, y + 2), 12, 12
LINE (x3 - 8, y + 14)-(x3 + 8, y + 16), , BF

LINE (x3 + 12, y + 2)-(x3 + 18, y + 2): 'LED arrows
LINE -(x3 + 14, y - 2): LINE (x3 + 18, y + 2)-(x3 + 14, y + 6)
LINE (x3 + 12, y + 12)-(x3 + 18, y + 12): LINE -(x3 + 14, y + 8)
LINE (x3 + 18, y + 12)-(x3 + 14, y + 16)
COLOR 14: LOCATE 18, 4: PRINT "0V": COLOR 10
LOCATE 12, 5: PRINT "a": LOCATE 15, 5: PRINT "k"

dn = 10 * 14 - 15: ac = ac - 10
GET (ac, dn)-(ac + 32, dn + 100), ledyel%

FOR a = 1 TO 7: PUT (ac, dn), ledyel%, PSET: ac = ac + 32: NEXT
ac = (4 * 8) - 4: LINE (ac, dn + 100)-(ac + 191, dn + 100), 11

ac = (4 * 8) - 5: FOR a = 1 TO 6
CIRCLE (ac, dn + 100), 3, 7: PAINT (ac, dn + 100), 11, 7
CIRCLE (ac, dn + 100), 3, 11: ac = ac + 32: NEXT

ac = (50 * 8) - 7
FOR a = 1 TO 7: PUT (ac, dn), ledyel%, PSET: ac = ac + 32: NEXT
ac = (50 * 8) + 4: LINE (ac, dn)-(ac + 191, dn), 11
LINE (ac + 191, dn)-(ac + 191, dn - 14), 11
COLOR 14: LOCATE 8, 74: PRINT "+V": ac = (50 * 8) + 35
FOR a = 1 TO 6: CIRCLE (ac, dn), 3, 7: PAINT (ac, dn), 11, 7
CIRCLE (ac, dn), 3, 11: ac = ac + 32: NEXT

ac = (4 * 8) - 5: GET (ac - 10, dn + 44)-(ac + 20, dn + 70), ledyel%

COLOR 11: LOCATE 6, 5: PRINT "COMMON CATHODE DISPLAY"
LOCATE 6, 53: PRINT "COMMON ANODE DISPLAY"

COLOR 10: LOCATE 8, 4: PRINT "A   B   C   D   E   F   G"
LOCATE 18, 51: PRINT "A   B   C   D   E   F   G"
COLOR 14: LOCATE 9, 4: PRINT "1   1   1   1   1   1   1"
LOCATE 17, 51: PRINT "1   1   1   1   1   1   1": RETURN

lednotes: COLOR 11 * n
LOCATE 19, 4: PRINT "COMMON CATHODE SEGMENTS TURNED ON BY LOGIC 1 (+V)"
LOCATE 20, 4: PRINT "COMMON ANODE SEGMENTS TURNED ON BY LOGIC 0 (0V)"
LOCATE 21, 4: PRINT "RESISTOR VALUES CALCULATED AS FOR SINGLE LEDS"
LOCATE 22, 4: PRINT "NEVER REPLACE THE 7 RESISTORS WITH A SINGLE RESISTOR";
PRINT " IN THE COMMON LINE -": LOCATE 23, 4
PRINT "THE TOTAL CURRENT VARIES WITH THE NUMBER OF 'ON' SEGMENTS";
PRINT " AND THE SEGMENT": LOCATE 24, 4
PRINT "BRILLIANCE WILL CHANGE ACCORDINGLY IF JUST A SINGLE RESISTOR IS USED";
LOCATE 1, 1: RETURN

'..................

300 : '7-SEGMENT LED DISPLAY - MULTIPLEX
GOSUB clearit

d$(1) = "1           0           0           0"
d$(2) = "0           1           0           0"
d$(3) = "0           0           1           0"
d$(4) = "0           0           0           1"

COLOR 14: LOCATE 2, 23: PRINT "7-SEGMENT LED DISPLAY - MULTIPLEX"
GOSUB setmulti: led = 3456: led$ = "3456": delay = 1: runit = 0
COLOR 10: LOCATE 18, 26: PRINT "NUMBER BEING MULTIPLEXED ";
COLOR 14: PRINT led$
COLOR 10: LOCATE 19, 23: PRINT "MULTIPLEXING RATE DISPLAYED = ";
COLOR 14: PRINT "FAST"
COLOR 10: LOCATE 6, 3: PRINT "DIGIT ON LOGIC =": COLOR 11
LOCATE 22, 14: PRINT "FOR THE SAME VOLTAGE AND CURRENT RAPIDLY MULTIPLEXED"
LOCATE 23, 14: PRINT "DIGITS WILL ALWAYS APPEAR LESS BRIGHT THAN SLOW ONES"
COLOR 10:
LOCATE 3, 17: PRINT "CONTROLS: "; : COLOR 11: PRINT "MENU "; : COLOR 14
PRINT "M"; : COLOR 11: PRINT "   FAST/SLOW "; : COLOR 14: PRINT "F";
COLOR 11: PRINT "   DIGITS "; : COLOR 14: PRINT "1 to 4"

segroute3: ac = 15: y = (4 + 3) * 14
FOR d = 1 TO 4: x = (ac + 1) * 8 + 2: v = VAL(MID$(led$, d, 1))
IF runit = 1 THEN ON v + 1 GOSUB L0, L1, L2, L3, L4, L5, L6, L7, L8, L9
IF runit = 0 THEN ON v + 1 GOSUB L10, L11, L12, L13, L14, L15, L16, L17, L18, L19
LOCATE 6, 21: PRINT d$(d): t$ = TIME$

segwait: z$ = INKEY$: IF z$ = "" THEN GOTO seg32
IF z$ = CHR$(13) THEN GOTO menu
z$ = UCASE$(z$): IF z$ = "M" THEN GOTO menu
IF z$ <> "F" THEN GOTO segw2
runit = (runit + 1) AND 1: ' GOTO segw2
COLOR 10: LOCATE 19, 23: PRINT "MULTIPLEXING RATE DISPLAYED = ";
COLOR 14: PRINT "FAST"
IF runit <> 1 THEN GOTO segw2
COLOR 10: LOCATE 19, 23: PRINT "MULTIPLEXING RATE DISPLAYED = ";
COLOR 14: PRINT "SLOW"
ac = 15: FOR e = 1 TO 4
x = (ac + 1) * 8 + 2: GOSUB L20: ac = ac + 12: NEXT: EXIT FOR

segw2: IF z$ < "1" OR z$ > "4" THEN GOTO seg32
led = led + (10 ^ (4 - VAL(z$))): IF led >= 10000 THEN led = led - 10000
led$ = RIGHT$("000" + LTRIM$(STR$(led)), 4): ' GOTO segx
COLOR 10: LOCATE 18, 26: PRINT "NUMBER BEING MULTIPLEXED ";
COLOR 14: PRINT led$

seg32: v = VAL(MID$(led$, d, 1)): IF runit = 0 THEN GOTO segx
IF t$ = TIME$ THEN GOTO segwait

segx: IF runit = 1 THEN GOSUB L20
ac = ac + 12: NEXT: GOTO segroute3

'.......

L0: PUT (x, y), led0%, PSET: RETURN
L1: PUT (x, y), led1%, PSET: RETURN
L2: PUT (x, y), led2%, PSET: RETURN
L3: PUT (x, y), led3%, PSET: RETURN
L4: PUT (x, y), led4%, PSET: RETURN
L5: PUT (x, y), led5%, PSET: RETURN
L6: PUT (x, y), led6%, PSET: RETURN
L7: PUT (x, y), led7%, PSET: RETURN
L8: PUT (x, y), led8%, PSET: RETURN
L9: PUT (x, y), led9%, PSET: RETURN

L10: PUT (x, y), led10%, PSET: RETURN
L11: PUT (x, y), led11%, PSET: RETURN
L12: PUT (x, y), led12%, PSET: RETURN
L13: PUT (x, y), led13%, PSET: RETURN
L14: PUT (x, y), led14%, PSET: RETURN
L15: PUT (x, y), led15%, PSET: RETURN
L16: PUT (x, y), led16%, PSET: RETURN
L17: PUT (x, y), led17%, PSET: RETURN
L18: PUT (x, y), led18%, PSET: RETURN
L19: PUT (x, y), led19%, PSET: RETURN
L20: PUT (x, y), ledclear%, PSET: RETURN

setmulti:
dn = 6: y = dn * 14 + 4: y1 = dn + (16 * 14) - 4
ac = 15: x = ac * 8 + 2: x1 = x + 88
x2 = x: x3 = x1: y2 = y: y3 = y1
GET (x2 + 8, y2 + 8)-(x3 - 8, y3 - 8), ledclear%

ac = 15: FOR a = 1 TO 4: x = ac * 8 + 2: x1 = x + 88
LINE (x, y + 4)-(x1, y1), 10, B: ac = ac + 12: NEXT: led = 0

v = 48: a$ = seg$(v): ac = 17: d = 12
FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * d
ON c GOSUB ma, mb, mc, md, me, mf, mg: NEXT
GET (x2 + 8, y2 + 8)-(x3 - 8, y3 - 8), led0%

v = 49: a$ = seg$(v): ac = 17
FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * d
ON c GOSUB ma, mb, mc, md, me, mf, mg: NEXT
GET (x2 + 8, y2 + 8)-(x3 - 8, y3 - 8), led1%

v = 50: a$ = seg$(v): ac = 17
FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * d
ON c GOSUB ma, mb, mc, md, me, mf, mg: NEXT
GET (x2 + 8, y2 + 8)-(x3 - 8, y3 - 8), led2%

v = 51: a$ = seg$(v): ac = 17
FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * d
ON c GOSUB ma, mb, mc, md, me, mf, mg: NEXT
GET (x2 + 8, y2 + 8)-(x3 - 8, y3 - 8), led3%

v = 52: a$ = seg$(v): ac = 17
FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * d
ON c GOSUB ma, mb, mc, md, me, mf, mg: NEXT
GET (x2 + 8, y2 + 8)-(x3 - 8, y3 - 8), led4%

v = 53: a$ = seg$(v): ac = 17
FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * d
ON c GOSUB ma, mb, mc, md, me, mf, mg: NEXT
GET (x2 + 8, y2 + 8)-(x3 - 8, y3 - 8), led5%

v = 54: a$ = seg$(v): ac = 17
FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * d
ON c GOSUB ma, mb, mc, md, me, mf, mg: NEXT
GET (x2 + 8, y2 + 8)-(x3 - 8, y3 - 8), led6%

v = 55: a$ = seg$(v): ac = 17
FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * d
ON c GOSUB ma, mb, mc, md, me, mf, mg: NEXT
GET (x2 + 8, y2 + 8)-(x3 - 8, y3 - 8), led7%

v = 56: a$ = seg$(v): ac = 17
FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * d
ON c GOSUB ma, mb, mc, md, me, mf, mg: NEXT
GET (x2 + 8, y2 + 8)-(x3 - 8, y3 - 8), led8%

v = 57: a$ = seg$(v): ac = 17
FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * d
ON c GOSUB ma, mb, mc, md, me, mf, mg: NEXT
GET (x2 + 8, y2 + 8)-(x3 - 8, y3 - 8), led9%

v = 48: a$ = seg$(v): ac = 17: d = 6
FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * d
ON c GOSUB ma, mb, mc, md, me, mf, mg: NEXT
GET (x2 + 8, y2 + 8)-(x3 - 8, y3 - 8), led10%

v = 49: a$ = seg$(v): ac = 17
FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * d
ON c GOSUB ma, mb, mc, md, me, mf, mg: NEXT
GET (x2 + 8, y2 + 8)-(x3 - 8, y3 - 8), led11%

v = 50: a$ = seg$(v): ac = 17
FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * d
ON c GOSUB ma, mb, mc, md, me, mf, mg: NEXT
GET (x2 + 8, y2 + 8)-(x3 - 8, y3 - 8), led12%

v = 51: a$ = seg$(v): ac = 17
FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * d
ON c GOSUB ma, mb, mc, md, me, mf, mg: NEXT
GET (x2 + 8, y2 + 8)-(x3 - 8, y3 - 8), led13%

v = 52: a$ = seg$(v): ac = 17
FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * d
ON c GOSUB ma, mb, mc, md, me, mf, mg: NEXT
GET (x2 + 8, y2 + 8)-(x3 - 8, y3 - 8), led14%

v = 53: a$ = seg$(v): ac = 17
FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * d
ON c GOSUB ma, mb, mc, md, me, mf, mg: NEXT
GET (x2 + 8, y2 + 8)-(x3 - 8, y3 - 8), led15%

v = 54: a$ = seg$(v): ac = 17
FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * d
ON c GOSUB ma, mb, mc, md, me, mf, mg: NEXT
GET (x2 + 8, y2 + 8)-(x3 - 8, y3 - 8), led16%

v = 55: a$ = seg$(v): ac = 17
FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * d
ON c GOSUB ma, mb, mc, md, me, mf, mg: NEXT
GET (x2 + 8, y2 + 8)-(x3 - 8, y3 - 8), led17%

v = 56: a$ = seg$(v): ac = 17
FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * d
ON c GOSUB ma, mb, mc, md, me, mf, mg: NEXT
GET (x2 + 8, y2 + 8)-(x3 - 8, y3 - 8), led18%

v = 57: a$ = seg$(v): ac = 17
FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * d
ON c GOSUB ma, mb, mc, md, me, mf, mg: NEXT
GET (x2 + 8, y2 + 8)-(x3 - 8, y3 - 8), led19%: RETURN

ma: ' IF col = 0 THEN col = 8
COLOR col: x = ac * 8 + 8: x1 = x + 60 - 16: y = 7 * 14: y1 = y + 7
LINE (x, y)-(x1, y1), col, BF: RETURN

mb: 'IF col = 0 THEN col = 8
COLOR col: x = (ac + 7) * 8: x1 = x + 8: y = 7 * 14 + 2: y1 = y + 42 + 14 + 1 - 2
LINE (x, y)-(x1, y1), col, BF: RETURN

mc: 'IF col = 0 THEN col = 8
COLOR col: x = (ac + 7) * 8: x1 = x + 8: y = 12 * 14 - 9: y1 = y + 60 - 2 - 2
LINE (x, y)-(x1, y1), col, BF: RETURN

md: 'IF col = 0 THEN col = 8
COLOR col: x = ac * 8 + 8: x1 = x + 60 - 16: y = 15 * 14: y1 = y + 7:
LINE (x, y)-(x1, y1), col, BF: RETURN

me: 'IF col = 0 THEN col = 8
COLOR col: x = ac * 8 - 4: x1 = x + 8: y = 12 * 14 - 9: y1 = y + 60 - 2 - 2
LINE (x, y)-(x1, y1), col, BF: RETURN

mf: 'IF col = 0 THEN col = 8
COLOR col: x = ac * 8 - 4: x1 = x + 8: y = 7 * 14 + 2: y1 = y + 57 - 2
LINE (x, y)-(x1, y1), col, BF: RETURN

mg: 'IF col = 0 THEN col = 8
COLOR col: x = (ac + 1) * 8: x1 = x + 44: y = (9 + 2) * 14: y1 = y + 6
LINE (x, y)-(x1, y1), col, BF: RETURN

'..................

400 : 'MATRIX DISPLAYS - BASIC
GOSUB clearit
COLOR 11: LOCATE 2, 23: PRINT "MATRIXED DISPLAYS - BASIC PRINCIPLE"
COLOR 14: LOCATE 4, 12: PRINT "MENU - PRESS <ENTER> "; : COLOR 11
PRINT "(ALL OTHER KEYS ARE FOR THE DISPLAY)": COLOR 10
LOCATE 7, 19: PRINT "5 x 7 MATRIX": LOCATE 7, 49: PRINT "8 x 14 MATRIX"
LOCATE 17, 16: PRINT "THE 5 x 7 IS TYPICAL FOR ALPHANUMERIC LCD DISPLAYS"
LOCATE 18, 15: PRINT "THE 8 x 14 IS BEING 'READ' FROM YOUR COMPUTER SCREEN"

z$ = "8": v = ASC(z$): GOTO max2

maxroute: z$ = INKEY$: IF z$ = "" THEN GOTO maxroute
IF z$ = CHR$(13) THEN GOTO menu
IF LEN(z$) > 1 THEN GOTO maxroute

v = ASC(z$):
IF z$ >= "a" AND z$ <= "z" THEN z$ = UCASE$(z$): v = ASC(z$): GOTO max2
IF z$ >= "A" AND z$ <= "Z" THEN z$ = LCASE$(z$): v = ASC(z$)

max2: a$ = matrix$(v): IF a$ = "" THEN a$ = max$: v = 0
GOSUB letterseg: GOSUB lettermatrix

LOCATE 22, 4:
COLOR 0: IF v = 0 THEN COLOR 14
PRINT " 5 x 7 MATRIX NOT YET AVAILABLE - THIS IS YOUR CHALLENGE (SEE EPE TEXT)!"
GOTO maxroute

lettermatrix: yy = 120: FOR a = 1 TO LEN(a$) STEP 6: xx = 162: '5
FOR B = a TO a + 4: colx = VAL(MID$(matrix$(v), B, 1)) * 15
LINE (xx, yy)-(xx + 6, yy + 6), colx, BF: xx = xx + 12: NEXT
yy = yy + 10: NEXT: RETURN

letterseg: DEF SEG = &HA000: COLOR 11:
LOCATE 20, 31: PRINT "TURN-ON MATRIX FOR "; : COLOR 15: PRINT z$
c = (19 * 14) * 80 + 49
FOR B = 0 TO 13: d = PEEK(c): a(B) = d: c = c + 80: NEXT: DEF SEG
yy = 105: FOR B = 0 TO 13: e = 128: xx = 410: FOR c = 0 TO 7: d = a(B) AND e
colx = d * 15: LINE (xx, yy)-(xx + 4, yy + 4), colx, BF: xx = xx + 8
e = e / 2: NEXT: yy = yy + 8: NEXT: RETURN

'..........

500 : 'LCD DISPLAYS - PRINCIPLE
GOSUB clearit
GOSUB digit8: GOSUB clearit

PUT (x2 + 8 + 160 + 32, y2 + 8 + 70), led8%
LINE (x2 + 200 - 16, y2 + 78 - 8)-(x2 + 200 + 80 - 8 + 16, y2 + 201 + 8), 7, B
PAINT (x2 + 200 - 16 + 1, y2 + 78 - 8 + 1), 8, 7
LINE (x2 + 200 - 16, y2 + 78 - 8)-(x2 + 200 + 80 - 8 + 16, y2 + 201 + 8), 15, B

COLOR 11: LOCATE 2, 23: PRINT "LCD DISPLAYS - BASIC PRINCIPLE"
LOCATE 3, 21: PRINT "MENU "; : COLOR 14: PRINT "<M>   ";
COLOR 11: PRINT "SEGMENT LOGIC ON/OFF "; : COLOR 14: PRINT "<+>"

COLOR 10
LOCATE 5, 42: PRINT "LCD SEGMENTS ARE ON ONLY WHEN THE"
LOCATE 6, 42: PRINT "LOGIC OF THE SEGMENT DOES NOT EQUAL"
LOCATE 7, 42: PRINT "THE LOGIC OF THE BACKPLANE"

LOCATE 9, 48: PRINT "'INTELLIGENT' LCDS HAVE THEIR"
LOCATE 10, 48: PRINT " OWN INTERNAL OSCILLATOR"
LOCATE 12, 54: PRINT "THERE ARE ALSO SPECIAL"
LOCATE 13, 54: PRINT "LCD DRIVING CHIPS"

LOCATE 16, 3: PRINT "LCD BACKPLANES"
LOCATE 17, 3: PRINT "TYPICALLY OSCILLATE"
LOCATE 18, 3: PRINT "AT ABOUT 30Hz TO 50Hz"
LOCATE 20, 3: PRINT "EACH SEGMENT NEEDS"
LOCATE 21, 3: PRINT "ITS CONTROL LOGIC BUT"
LOCATE 22, 3: PRINT "THE BACKPLANE IS COMMON"
LOCATE 23, 3: PRINT "TO ALL SEGMENTS"

LOCATE 24, 20: COLOR 14
PRINT "LCD SEGMENTS (AND PIXELS) MUST NEVER BE CONTROLLED BY DC";
COLOR 11: LOCATE 1, 1

gate1: c$ = "": g$ = "": z$ = ""
gate1a: IF c$ = "M" OR g$ = "M" OR z$ = "M" THEN GOTO menu
col = 3: COLOR 15: GOSUB showgates:

gate = 2: dn = 9: ac = 18: GOSUB logicshow: t$ = TIME$

gate1mode: z$ = UCASE$(INKEY$): ' IF z$ = "" THEN GOTO gate1mode
IF z$ = CHR$(13) THEN GOTO menu
IF t$ <> TIME$ THEN count(gate) = (count(gate) + 2) AND 3: t$ = TIME$
IF z$ = "M" THEN GOTO menu
IF z$ = "+" THEN a = ((count(gate) + 1) AND 1) OR (count(gate) AND 2): count(gate) = a

dn = 9: ac = 18: GOSUB logicshow: GOTO gate1mode

orsymbol: y = dn * 14 + 11
angle1 = 25: angle2 = 90: s = angle1 * pi: e = angle2 * pi
CIRCLE (x, y), 60, 15, s, e: 'top curve
angle1 = 270: angle2 = 335: s = angle1 * pi: e = angle2 * pi
CIRCLE (x, y - 36), 60, 15, s, e: ' bottom curve
angle1 = 320: angle2 = 40: s = angle1 * pi: e = angle2 * pi
CIRCLE (x - 44, y - 18), 56, 15, s, e: ' end curve
PAINT (x + 16, y - 19), col, 15
ax = (ac - 2) * 8 + 2: dx = dn * 14: ay = ax + 22
LINE (ax - 16, dx - 21)-(ay, dx - 21), 14: 'A
LINE (ax - 16, dx + 7)-(ay, dx + 7), 14: 'B
LINE (ax - 16 + 4, dx + 7)-(ax - 16 + 4, dx + 28 + 14), 14: 'B down
LINE -(ay + 100 + 4, dx + 28 + 14), 14: 'B horiz
CIRCLE (ay + 106, dx + 42), 3, 7: PAINT (ay + 106, dx + 42), 11, 7
CIRCLE (ay + 106, dx + 42), 3, 11

LINE (ax + 68, dx - 7)-(ay + 68, dx - 7), 14: ' Y
LINE (ax + 68 + 54, dx - 7)-(ay + 68 + 48 + 40 - 6, dx - 7), 14: ' Y extension
LINE -(ay + 150, dx + 7 + 20), 14: ' Y down
CIRCLE (ay + 150, dx + 42 - 16), 3, 7: PAINT (ay + 150, dx + 42 - 16), 11, 7
CIRCLE (ay + 150, dx + 42 - 16), 3, 11
LOCATE dn - 1, ac - 2 - 2: PRINT "A": LOCATE dn, ac + 11: PRINT "Y"
LOCATE dn + 1, ac - 2 - 2: PRINT "B": RETURN

xorgate: x = ac * 8: y = dn * 14 + 12: GOSUB orsymbol
CIRCLE (x - 51, y - 18), 56, 15, s, e: ' xor curve
COLOR 11: LOCATE dn - 3, ac + 1: PRINT "XOR GATE"
LOCATE dn + 10, ac + 1: PRINT "XOR GATE"
LOCATE dn + 10, ac + 32: PRINT "DISPLAY"
LOCATE dn - 1, 5: PRINT "SEGMENT LOGIC"
LOCATE dn + 1, 3: PRINT "BACKPLANE LOGIC": COLOR 15: RETURN

tablebox:
COLOR 14: LOCATE dn + 5, ac + 1: PRINT "B  A  Y"
LOCATE dn + 5, ac + 31: PRINT "B  Y  LCD": COLOR 15
LOCATE dn + 6, ac + 1: PRINT "0  0": LOCATE dn + 7, ac + 1: PRINT "0  1"
LOCATE dn + 8, ac + 1: PRINT "1  0": LOCATE dn + 9, ac + 1: PRINT "1  1"
LOCATE dn + 6, ac + 31: PRINT "0  0": LOCATE dn + 7, ac + 31: PRINT "0  1"
LOCATE dn + 8, ac + 31: PRINT "1  0": LOCATE dn + 9, ac + 31: PRINT "1  1"

ax = (ac - 1) * 8: dx = (dn + 4) * 14
LINE (ax, dx)-((ac + 8) * 8, dx + 70), 14, B
LINE (ax, dx + 14)-((ac + 8) * 8, dx + 14), 14
LINE ((ac + 5) * 8, dx)-((ac + 5) * 8, dx + 70), 14

ax = (ac - 1 + 30) * 8: dx = (dn + 4) * 14
LINE (ax, dx)-((ac + 8 + 30 + 2) * 8, dx + 70), 14, B
LINE (ax, dx + 14)-((ac + 8 + 30 + 2) * 8, dx + 14), 14
LINE ((ac + 5 + 30) * 8, dx)-((ac + 5 + 30) * 8, dx + 70), 14: RETURN

xortable: ax = ac + 7
LOCATE dn + 6, ax: PRINT "0"
LOCATE dn + 7, ax: PRINT "1"
LOCATE dn + 8, ax: PRINT "1"
LOCATE dn + 9, ax: PRINT "0"
ax = ac + 37
LOCATE dn + 6, ax + 1: PRINT "0"
LOCATE dn + 7, ax + 1: PRINT "1"
LOCATE dn + 8, ax + 1: PRINT "1"
LOCATE dn + 9, ax + 1: PRINT "0": RETURN

logicshow: col = 12: B = count(gate) \ 2: a = count(gate) AND 1
y = a XOR B:
LOCATE dn, ac + 1: PRINT MID$(STR$(a), 2)
LOCATE dn + 2, ac + 1: PRINT MID$(STR$(B), 2)
LOCATE dn + 1, ac + 18 + 2: PRINT MID$(STR$(y), 2)
ac = ac + 4.5: ax = ac * 8 - 10: ay = dn * 14 - 14

hi = 10 * a: lo = col * ((a + 1) AND 1)
LINE (ax + 8, ay)-(ax + 8 + 8, ay + 6), hi, BF
ay = ay + 7: LINE (ax + 8, ay + 1)-(ax + 8 + 8, ay + 7), lo, BF

dn = dn + 2: ay = dn * 14 - 14
hi = 10 * B: lo = col * ((B + 1) AND 1)
LINE (ax + 8, ay)-(ax + 8 + 8, ay + 6), hi, BF
ay = ay + 7: LINE (ax + 8, ay + 1)-(ax + 8 + 8, ay + 7), lo, BF

dn = dn - 1: ay = dn * 14 - 14: ac = ac + 9: ax = ac * 8 + 16
hi = 10 * y: lo = col * ((y + 1) AND 1)
LINE (ax - 8, ay)-(ax + 8 - 8, ay + 6), hi, BF
ay = ay + 7: LINE (ax - 8, ay + 1)-(ax + 8 - 8, ay + 7), lo, BF
IF B = y THEN digcol = 7 ELSE digcol = 15
LINE (ax + 68, ay + 35)-(ax + 112, ay + 42), digcol, BF: ' digit box
RETURN

showgates:
ac = 25: dn = 10: GOSUB xorgate: GOSUB xortable: GOTO tablebox

digit8: v = 56: a$ = seg$(v): d = 7
dn = 6: y = dn * 14 + 4: y1 = dn + (16 * 14) - 4
ac = 15: x = ac * 8 + 2: x1 = x + 88
x2 = x: x3 = x1: y2 = y: y3 = y1

FOR c = 1 TO 7: col = VAL(MID$(a$, c, 1)) * d
ON c GOSUB ma, mb, mc, md, me, mf, mg: NEXT
GET (x2 + 8 - 16, y2 + 8)-(x3 - 8 - 16, y3 - 8), led8%: RETURN

'......................END GATE 1

hold: IF INKEY$ = "" THEN GOTO hold ELSE RETURN

'............

clearit: LINE (6, 6)-(633, 343), 0, BF: RETURN

'..........

setup: max$ = "000000000000000000000000000000000000000000"
OPEN "TY2KMTRX.TXT" FOR INPUT AS #1
segments: READ a$: IF a$ = "*" THEN GOTO matrix
a = ASC(a$): seg$(a) = MID$(a$, 2): GOTO segments

matrix: IF EOF(1) THEN CLOSE : RETURN
INPUT #1, a$: a = ASC(a$): matrix$(a) = MID$(a$, 3): GOTO matrix

'........

highlight:
ax = ac * 8 - 1: dx = dn * 14 + 1: ay = (ac + 33) * 8: dy = dx + 14 - 2
GET (ax, dx)-(ay, dy), h%: PUT (ax, dx), h%, PRESET: RETURN

