'TY2KB001 28SEP99 V1.0
SCREEN 9: COLOR 15, 1: CLS : RANDOMIZE TIMER
CONST pi = 3.141592653589# / 180
DATA 1,1.1,1.2,1.3,1.5,1.6,1.8,2,2.2,2.4,2.7,3,3.3,3.6,3.9,4.3,4.7,5.1,5.6
DATA 6.2,6.8,7.5,8.2,9.1: 'res

ohms$ = "R": sqrt$ = CHR$(251)
DIM a%(10000), arrowright%(70), arrowleft%(70), arrowup%(70), arrowdown%(70)
DIM electron%(70), res(217), r$(9), res$(217), count(600)

LOCATE 8, 35: PRINT "SETTING UP"
GOSUB setup
LOCATE 8, 35: PRINT "          "

selftest = 0

OPEN "TY2KPATH.TXT" FOR INPUT AS #1: INPUT #1, a$: CLOSE
menupath = VAL(a$) + 1: ON menupath GOTO page2, page3, page4

menu: CHAIN "TY2KMENU"

hold: z$ = UCASE$(INKEY$): IF z$ = "" THEN GOTO hold ELSE RETURN

'.................

page2: 'OHM'S LAW AND RELATIONSHIPS
exam = 0: prevexam = 0: value = 1: prevvalue = 1: z = 0:
volts = 1: amps = 1: res = 89: power = 1: scale = 0
zvolts = 1: zamps = -3: zpower = 0

COLOR 11: LOCATE 1, 28: PRINT "OHM'S LAW AND RELATIONSHIPS": COLOR 15
ac = 62: dn = 1.3: ltab = ac: rtab = ac + 14: ttab = dn - .5: btab = dn + 5
col = 10: GOSUB right2: GOSUB down2: GOSUB left2: GOSUB up2
LOCATE 2, 64: COLOR 11: PRINT "C"; : COLOR 15: PRINT " CURRENT"
LOCATE 3, 64: COLOR 11: PRINT "E"; : COLOR 15: PRINT " ELECTRONS"
LOCATE 4, 64: COLOR 11: PRINT "X"; : COLOR 15: PRINT " SCALE"
LOCATE 5, 64: COLOR 11: PRINT "S"; : COLOR 15: PRINT " SELFTEST"
LOCATE 6, 64: COLOR 11: PRINT "M"; : COLOR 15: PRINT " MENU"

col = 14: GOSUB pdline: GOSUB powerlines
ltab = ac + 2: rtab = ac + 6: ttab = 5.5 + .5: btab = 6 + .5: col = 14
GOSUB batterysymbol: GOSUB ohmsbox
col = 14: ltab = ac + 21: ttab = 5: GOSUB vresistor

triangle:
dn = 14: dx = dn * 14: ax = 12 * 8 + 4
PSET (ax, dx), 14: DRAW "f60 l120 e60"
PSET (ax, dx), 14: DRAW "f30 ta25 l32"
PSET (ax, dx), 14: DRAW "ta0 g30 ta-25 r32"
PSET (ax, dx), 14: DRAW "ta0 f60 l60 u20"
COLOR 14: LOCATE dn + 2, 13: PRINT "V": LOCATE dn + 4, 10: PRINT "I"
LOCATE dn + 4, 16: PRINT "R"
dn = 19: dx = dn * 14: ' ax = 12 * 8 + 4: COLOR 15
PSET (ax, dx), 14: DRAW "f60 l120 e60"
PSET (ax, dx), 14: DRAW "f30 ta25 l32"
PSET (ax, dx), 14: DRAW "ta0 g30 ta-25 r32"
PSET (ax, dx), 14: DRAW "ta0 f60 l60 u20"
LOCATE dn + 2, 13: PRINT "P": LOCATE dn + 4, 10: PRINT "I"
LOCATE dn + 4, 16: PRINT "V": COLOR 15

examplesbox:
ac = 27: dn = 12: ltab = ac: rtab = ac + 49: ttab = dn - .2: btab = dn + 2.2
col = 10: GOSUB right2: GOSUB down2: GOSUB left2: GOSUB up2
COLOR 11: LOCATE 13, 29: PRINT "EXAMPLE": COLOR 15

valuesbox:
ac = 4: dn = 1.3: ltab = ac: rtab = ac + 16: ttab = dn - .5: btab = dn + 6
col = 10: GOSUB right2: GOSUB down2: GOSUB left2: GOSUB up2
show$(0) = "# ": show$(1) = "  ": show$(2) = "# ": show$(3) = "  "
COLOR 11: LOCATE 2, 5: PRINT "PRESET VALUES"
LOCATE 7, 5: PRINT "# = ADJUSTABLE": COLOR 15
LOCATE 3, 5: PRINT show$(0); "V = ": LOCATE 4, 5: PRINT show$(1); "I = "
LOCATE 5, 5: PRINT show$(2); "R = ": LOCATE 6, 5: PRINT show$(3); "P = "
COLOR 11: LOCATE 9, 5: PRINT "VALUE CONTROLS:  "
LOCATE 11, 5: PRINT "FORMULA CONTROLS:"
COLOR 15: LOCATE 10, 5: PRINT "V I R P + - * /"
LOCATE 12, 5: PRINT "KEYBOARD ARROWS": GOSUB showvalues

'setvalues & formula highlights
a = prevexam \ 3: d = prevexam - (a * 3)
dn = 16 + d: ac = 27 + (12 * a): GOSUB highlight:
ax = 6 * 8: ay = 7 * 8: dx = (2 + value) * 14: dy = dx + 14
GET (ax, dx)-(ay, dy), a%: PUT (ax, dx), a%, PRESET

GOSUB totalvolts: GOSUB totalamps: GOSUB totalpower: GOSUB totalres
GOSUB showexample

page2mode:
getkey: z$ = INKEY$: IF z$ = "" THEN GOTO getkey
z$ = UCASE$(z$)
IF z$ = "C" THEN looplen = 2: GOSUB rotatearrows: GOTO page2mode
IF z$ = "E" THEN GOSUB electron: GOTO page2mode
IF z$ = "X" THEN GOSUB scaleset: GOTO page2mode
IF z$ = "M" THEN GOTO menu
IF z$ = "S" THEN GOSUB selftest: GOTO page2mode
IF selftest1 = 1 GOTO ex2

ex1: IF MID$(z$, 2) = "" THEN GOTO ex2
z$ = MID$(z$, 2)
IF z$ = "M" THEN exam = exam + 3
IF z$ = "K" THEN exam = exam - 3
IF z$ = "P" THEN exam = exam + 1
IF z$ = "H" THEN exam = exam - 1
IF exam > 11 THEN exam = 11 ELSE IF exam < 0 THEN exam = 0
IF exam = prevexam THEN GOTO page2mode
a = prevexam \ 3: d = prevexam - (a * 3)
dn = 16 + d: ac = 27 + (12 * a): GOSUB highlight
a = exam \ 3: d = exam - (a * 3)
dn = 16 + d: ac = 27 + (12 * a): GOSUB highlight
prevexam = exam: GOSUB showexample: GOTO page2mode

ex2:
IF z$ = "+" THEN GOSUB incval: GOSUB showexample: GOTO page2mode
IF z$ = "-" THEN GOSUB decval: GOSUB showexample: GOTO page2mode
IF z$ = "*" THEN GOSUB multval: GOSUB showexample: GOTO page2mode
IF z$ = "/" THEN GOSUB divideval: GOSUB showexample: GOTO page2mode
IF selftest1 = 1 AND z$ = "Y" THEN GOSUB selftestohms: GOTO page2mode
IF selftest1 = 1 AND z$ = "A" THEN GOSUB answerohms: ' GOTO page2mode
IF z$ = "V" THEN value = 0: GOTO ex3
IF z$ = "I" THEN value = 1: GOTO ex3
IF z$ = "R" THEN value = 2: GOTO ex3
IF z$ = "P" THEN value = 3: GOTO ex3

ex3:
IF value = prevvalue THEN GOTO page2mode
ax = 6 * 8: ay = 7 * 8: dx = (2 + prevvalue) * 14: dy = dx + 14
GET (ax, dx)-(ay, dy), a%: PUT (ax, dx), a%, PRESET
dx = (2 + value) * 14: dy = dx + 14
GET (ax, dx)-(ay, dy), a%: PUT (ax, dx), a%, PRESET
prevvalue = value: GOTO page2mode

showexample: sl = 1000 ^ scale
ON exam + 1 GOTO exam1, exam2, exam3, exam4, exam5, exam6
ON exam - 5 GOTO exam7, exam8, exam9, exam10, exam11, exam12
RETURN

exam1: ' V = I x R
V = 4: i = 3: r = 3: GOSUB painttriangle1: GOSUB cleartriangle2
show$(0) = "  ": show$(1) = "# ": show$(2) = "# ": show$(3) = "  "
amps2 = tamps * sl: res2 = tres / sl: volts2 = tamps * tres * sl
a$ = STR$(amps2) + ascale$(scale): r$ = STR$(res2) + rscale$(scale)
V$ = STR$(volts2) + vscale$(scale): p$ = LEFT$(sp$, 10)
q$ = "V =" + a$ + " x" + r$ + " =" + V$
q1$ = "VOLTAGE": GOSUB showexamfacts: RETURN

exam2: ' I = V / R
V = 3: i = 4: r = 3: GOSUB painttriangle1: GOSUB cleartriangle2
show$(0) = "# ": show$(1) = "  ": show$(2) = "# ": show$(3) = "  "
volts2 = tvolts * sl: res2 = tres / sl: amps2 = tvolts / tres * sl
a$ = STR$(amps2) + ascale$(scale): r$ = STR$(res2) + rscale$(scale)
V$ = STR$(volts2) + vscale$(scale): p$ = LEFT$(sp$, 10)
q$ = "I =" + V$ + " /" + r$ + " =" + a$
q1$ = "CURRENT": GOSUB showexamfacts: RETURN

exam3: ' R= V / I
V = 3: i = 3: r = 4: GOSUB painttriangle1: GOSUB cleartriangle2
show$(0) = "# ": show$(1) = "# ": show$(2) = "  ": show$(3) = "  "
volts2 = tvolts * sl: amps2 = tamps * sl: res2 = tvolts / tamps / sl
a$ = STR$(amps2) + ascale$(scale): r$ = STR$(res2) + rscale$(scale)
V$ = STR$(volts2) + vscale$(scale): p$ = LEFT$(sp$, 10)
q$ = "R =" + V$ + " /" + a$ + " =" + r$
q1$ = "RESISTANCE": GOSUB showexamfacts: RETURN

exam4: ' P = I x V
p = 4: i = 3: V = 3: GOSUB painttriangle2: GOSUB cleartriangle1
show$(0) = "# ": show$(1) = "# ": show$(2) = "  ": show$(3) = "  "
amps2 = tamps * sl: volts2 = tvolts * sl: power2 = tamps * tvolts * sl
a$ = STR$(amps2) + ascale$(scale): p$ = STR$(power2) + pscale$(scale)
V$ = STR$(volts2) + vscale$(scale): r$ = LEFT$(sp$, 10)
q$ = "P =" + a$ + " x" + V$ + " =" + p$
q1$ = "POWER": GOSUB showexamfacts: RETURN

exam5: ' I = P / V
p = 3: i = 4: V = 3: GOSUB painttriangle2: GOSUB cleartriangle1
show$(0) = "# ": show$(1) = "  ": show$(2) = "  ": show$(3) = "# "
volts2 = tvolts * sl: power2 = tpower * sl: amps2 = tpower / tvolts * sl
a$ = STR$(amps2) + ascale$(scale): p$ = STR$(power2) + pscale$(scale)
V$ = STR$(volts2) + vscale$(scale): r$ = LEFT$(sp$, 10)
q$ = "I =" + p$ + " /" + V$ + " =" + a$
q1$ = "CURRENT": GOSUB showexamfacts: RETURN

exam6: ' V = P / I
p = 3: i = 3: V = 4: GOSUB painttriangle2: GOSUB cleartriangle1
show$(0) = "  ": show$(1) = "# ": show$(2) = "  ": show$(3) = "# "
amps2 = tamps * sl: power2 = tpower * sl: volts2 = tpower / tamps * sl
a$ = STR$(amps2) + ascale$(scale): p$ = STR$(power2) + pscale$(scale)
V$ = STR$(volts2) + vscale$(scale): r$ = LEFT$(sp$, 10)
q$ = "V =" + p$ + " /" + a$ + " =" + V$
q1$ = "VOLTAGE": GOSUB showexamfacts: RETURN

exam7: ' V = root (P x R)
GOSUB cleartriangle1: GOSUB cleartriangle2
show$(0) = "  ": show$(1) = "  ": show$(2) = "# ": show$(3) = "# "
res2 = tres / sl: power2 = tpower * sl: volts2 = SQR(tpower * tres) * sl
V$ = STR$(volts2) + vscale$(scale): r$ = STR$(res2) + rscale$(scale)
p$ = MID$(STR$(power2), 2) + pscale$(scale): a$ = LEFT$(sp$, 10)
q$ = "V = " + sqrt$ + "(" + p$ + " x" + r$ + ") =" + V$
q1$ = "VOLTAGE": GOSUB showexamfacts: RETURN

exam8: ' R = P / (I^2)
GOSUB cleartriangle1: GOSUB cleartriangle2
show$(0) = "  ": show$(1) = "# ": show$(2) = "  ": show$(3) = "# "
amps2 = tamps * sl: power2 = tpower * sl: res2 = tpower / (tamps ^ 2) / sl
a$ = STR$(amps2) + CHR$(253) + ascale$(scale): p$ = STR$(power2) + pscale$(scale)
r$ = STR$(res2) + rscale$(scale): V$ = LEFT$(sp$, 10)
q$ = "R =" + p$ + " /" + a$ + " =" + r$: a$ = STR$(amps2) + ascale$(scale)
q1$ = "RESISTANCE": GOSUB showexamfacts: RETURN

exam9: ' R = (V^2) / P
GOSUB cleartriangle1: GOSUB cleartriangle2
show$(0) = "# ": show$(1) = "  ": show$(2) = "  ": show$(3) = "# "
volts2 = tvolts * sl: power2 = tpower * sl: res2 = (tvolts ^ 2) / tpower / sl
p$ = STR$(power2) + pscale$(scale)
V$ = STR$(volts2) + CHR$(253) + vscale$(scale)
r$ = STR$(res2) + rscale$(scale): a$ = LEFT$(sp$, 10)
q$ = "R =" + V$ + " /" + p$ + " =" + r$: V$ = STR$(volts2) + vscale$(scale)
q1$ = "RESISTANCE": GOSUB showexamfacts: RETURN

exam10: ' I = root (P / R)
show$(0) = "  ": show$(1) = "  ": show$(2) = "# ": show$(3) = "# "
res2 = tres / sl: power2 = tpower * sl: amps2 = SQR(tpower / tres) * sl
a$ = STR$(amps2) + ascale$(scale): r$ = STR$(res2) + rscale$(scale)
p$ = MID$(STR$(power2), 2) + pscale$(scale): V$ = LEFT$(sp$, 10)
q$ = "I = " + sqrt$ + "(" + p$ + " /" + r$ + ") =" + a$
q1$ = "CURRENT": GOSUB showexamfacts: RETURN

exam11: ' P = (V^2) / R
show$(0) = "# ": show$(1) = "  ": show$(2) = "# ": show$(3) = "  "
volts2 = tvolts * sl: res2 = tres / sl: power2 = (tvolts ^ 2) / tres * sl
p$ = STR$(power2) + pscale$(scale)
V$ = STR$(volts2) + CHR$(253) + vscale$(scale)
r$ = STR$(res2) + rscale$(scale): a$ = LEFT$(sp$, 10)
q$ = "P =" + V$ + " /" + r$ + " =" + p$: V$ = STR$(volts2) + vscale$(scale)
q1$ = "POWER": GOSUB showexamfacts: RETURN

exam12: ' P = (I^2) * R
show$(0) = "  ": show$(1) = "# ": show$(2) = "# ": show$(3) = "  "
amps2 = tamps * sl: res2 = tres / sl: power2 = (tamps ^ 2) * tres * sl
a$ = STR$(amps2) + CHR$(253) + ascale$(scale): p$ = STR$(power2) + pscale$(scale)
r$ = STR$(res2) + rscale$(scale): V$ = LEFT$(sp$, 10)
q$ = "P =" + a$ + " /" + r$ + " =" + p$: a$ = STR$(amps2) + ascale$(scale)
q1$ = "POWER": GOSUB showexamfacts: RETURN

painttriangle1: IF selftest1 = 1 THEN GOTO cleartriangle1
PAINT (12 * 8, (14 + 2) * 14), V, 14: 'V
PAINT (9 * 8, (14 + 4) * 14), i, 14: 'I
PAINT (15 * 8, (14 + 4) * 14), r, 14: 'R
RETURN

cleartriangle1:
PAINT (12 * 8, (14 + 2) * 14), 0, 14: 'V
PAINT (9 * 8, (14 + 4) * 14), 0, 14: 'I
PAINT (15 * 8, (14 + 4) * 14), 0, 14: 'R
RETURN

painttriangle2: IF selftest1 = 1 THEN GOTO cleartriangle2
PAINT (12 * 8, (19 + 2) * 14), p, 14: 'P
PAINT (9 * 8, (19 + 4) * 14), i, 14: 'I
PAINT (15 * 8, (19 + 4) * 14), V, 14: 'V
RETURN

cleartriangle2:
PAINT (12 * 8, (19 + 2) * 14), 0, 14: 'P
PAINT (9 * 8, (19 + 4) * 14), 0, 14: 'I
PAINT (15 * 8, (19 + 4) * 14), 0, 14: 'V
RETURN

showexamfacts:
IF selftest1 = 0 OR z$ = "A" THEN COLOR 15 ELSE COLOR 0
q$ = LEFT$(q$ + sp$, 47): a$ = LEFT$(a$ + sp$, 24): r$ = RIGHT$(sp$ + r$, 13)
V$ = LEFT$(V$ + sp$, 24): p$ = LEFT$(p$ + sp$, 14): LOCATE 14, 29: PRINT q$
LOCATE 4, 34: PRINT a$: LOCATE 8, 34: PRINT r$: LOCATE 8, 51: PRINT V$
LOCATE 11, 34: PRINT p$: COLOR 15: LOCATE 14, 29:
IF selftest1 = 1 THEN PRINT q1$: COLOR 11: LOCATE 14, 49
IF selftest1 = 1 THEN PRINT "PRESS [A] TO SHOW ANSWER": COLOR 15
GOSUB showvalues: RETURN

powerlines:
col = 14: ac = 27: ltab = ac: rtab = ac + 8: ttab = 6: btab = 9
col = 15: ltab = ac + 4: rtab = ac + 22: btab = 6: ttab = 4
GOSUB up2: GOSUB right2: GOSUB down2: 'top lines
col = 15: ltab = ac + 4: rtab = ac + 22: btab = 11: ttab = 9
GOSUB down2: GOSUB left2: GOSUB up2: 'bottom lines
RETURN

pdline:
ac = 24: ltab = ac + 22.75: rtab = ltab + .5: ttab = 4
FOR a = 1 TO 8: GOSUB right2: ltab = ltab + 1: rtab = rtab + 1: NEXT
ltab = ac + 22.75: rtab = ltab + .5: ttab = 11
FOR a = 1 TO 8: GOSUB right2: ltab = ltab + 1: rtab = rtab + 1: NEXT
rtab = ac + 29: ttab = 4: btab = 11: GOSUB down2
ltab = ac + 28.5: rtab = ltab + .5: ttab = 4.5: btab = 4: GOSUB diagonal
ltab = ltab + .5: rtab = ltab + .5: ttab = 4: btab = 4.5: GOSUB diagonal
ltab = ac + 28.5: rtab = ltab + .5: ttab = 10.5: btab = 11: GOSUB diagonal
ltab = ltab + .5: rtab = ltab + .5: ttab = 11: btab = 10.5: GOSUB diagonal
RETURN

electron: COLOR 14
LOCATE 3, 28: PRINT "ELECTRONS FLOW FROM -VE TO +VE": COLOR 15
y = 238: x = 121: lx = 144 / 2: vx = 98 / 2:  '94
FOR a = 1 TO 28 / 2: PUT (y, x), electron%, XOR: GOSUB shortdelay:
PUT (y, x), electron%, XOR: x = x + 2: NEXT
FOR a = 1 TO lx: PUT (y, x), electron%, XOR: GOSUB shortdelay
PUT (y, x), electron%, XOR: y = y + 2: NEXT
FOR a = 1 TO vx: PUT (y, x), electron%, XOR: GOSUB shortdelay
PUT (y, x), electron%, XOR: x = x - 2: NEXT
FOR a = 1 TO lx: PUT (y, x), electron%, XOR: GOSUB shortdelay
PUT (y, x), electron%, XOR: y = y - 2: NEXT
FOR a = 1 TO 32 / 2: PUT (y, x), electron%, XOR: GOSUB shortdelay
PUT (y, x), electron%, XOR: x = x + 2:  NEXT
LOCATE 3, 28: PRINT "                              ": RETURN

rotatearrows: COLOR 14
LOCATE 3, 28: PRINT "CURRENT FLOWS FROM +VE TO -VE": COLOR 15
y = 235: x = 126 - 50: lx = 144 / 2: vx = 98 / 2: '94
FOR a = 1 TO 20 / 2: PUT (y, x), arrowup%, XOR: GOSUB shortdelay:
PUT (y, x), arrowup%, XOR: x = x - 2: NEXT: y = y + 8: x = x - 8
FOR a = 1 TO lx - 4: PUT (y, x), arrowright%, XOR: GOSUB shortdelay
PUT (y, x), arrowright%, XOR: y = y + 2: NEXT: x = x + 8
FOR a = 1 TO vx - 3: PUT (y, x), arrowdown%, XOR: GOSUB shortdelay
PUT (y, x), arrowdown%, XOR: x = x + 2: NEXT: x = x - 2
FOR a = 1 TO lx - 4: PUT (y, x), arrowleft%, XOR: GOSUB shortdelay
PUT (y, x), arrowleft%, XOR: y = y - 2: NEXT: y = y - 8
FOR a = 1 TO 30 / 2: PUT (y, x), arrowup%, XOR: GOSUB shortdelay
PUT (y, x), arrowup%, XOR: x = x - 2:  NEXT
LOCATE 3, 28: PRINT "                             ": RETURN

showvalues: sl = 1000 ^ scale
s$(0) = STR$(tvolts * sl) + vscale$(scale)
s$(1) = STR$(tamps * sl) + ascale$(scale)
s$(2) = STR$(tres / sl) + rscale$(scale)
s$(3) = STR$(tpower * sl) + pscale$(scale)

FOR a = 0 TO 3: IF LEFT$(show$(a), 1) = " " THEN s$(a) = ""
s$(a) = LEFT$(s$(a) + sp$, 10): LOCATE 3 + a, 5: PRINT show$(a)
LOCATE 3 + a, 9: PRINT s$(a): NEXT: RETURN

incval: ON value + 1 GOTO voltinc, ampinc, resinc, powerinc
decval: ON value + 1 GOTO voltdec, ampdec, resdec, powerdec
multval: ON value + 1 GOTO voltmult, ampmult, resmult, powermult
divideval: ON value + 1 GOTO voltdivide, ampdivide, resdivide, powerdivide

voltinc: volts = volts + 1: GOTO totalvolts
ampinc: amps = amps + 1: GOTO totalamps
powerinc: power = power + 1: GOTO totalpower
resinc: res = res + 1: IF res > 153 THEN res = 153
GOTO totalres

voltdec: IF (volts - 1) > 0 THEN volts = volts - 1
GOTO totalvolts
ampdec: IF (amps - 1) > 0 THEN amps = amps - 1
GOTO totalamps
powerdec: IF (power - 1) > 0 THEN power = power - 1
GOTO totalpower
resdec: res = res - 1: IF res < 1 THEN res = 1
GOTO totalres

voltmult: zvolts = zvolts + 1: IF zvolts > 1 THEN zvolts = 1
GOTO totalvolts
ampmult: zamps = zamps + 1: IF zamps > 1 THEN zamps = 1
GOTO totalamps
powermult: zpower = zpower + 1: IF zpower > 1 THEN zpower = 1
GOTO totalpower
resmult: res = res + 24: IF res > 153 THEN res = 153
GOTO totalres

voltdivide: zvolts = zvolts - 1: IF zvolts < -6 THEN zvolts = -6
GOTO totalvolts
ampdivide: zamps = zamps - 1: IF zamps < -6 THEN zamps = -6
GOTO totalamps
powerdivide: zpower = zpower - 1: IF zpower < -6 THEN zpower = -6
GOTO totalpower
resdivide: res = res - 24: IF res < 1 THEN res = 1
GOTO totalres

totalvolts: tvolts = volts * (10 ^ zvolts): RETURN
totalamps: tamps = amps * (10 ^ zamps): RETURN
totalpower: tpower = power * (10 ^ zpower): RETURN
totalres: tres = res(res): RETURN

scaleset:
scale = scale + 1: IF scale > 2 THEN scale = 0
GOSUB totalvolts: GOSUB totalamps: GOSUB totalpower: GOSUB totalres
GOSUB showexample: IF selftest1 = 1 THEN RETURN

scaleset2:
ON scale + 1 GOTO scale0, scale1, scale2
scale0:
LOCATE 22, 41: PRINT "VOLTS": LOCATE 22, 68: PRINT "OHMS"
LOCATE 23, 44: PRINT "AMPS": LOCATE 23, 63: PRINT "WATTS": RETURN
scale1:
LOCATE 22, 41: PRINT "mV   ": LOCATE 22, 68: PRINT "k" + ohms$ + "  "
LOCATE 23, 44: PRINT "mA  ": LOCATE 23, 63: PRINT "mW   ": RETURN
scale2:
LOCATE 22, 41: PRINT CHR$(230) + "V   "
LOCATE 22, 68: PRINT "M" + ohms$ + "   "
LOCATE 23, 44: PRINT CHR$(230) + "A   "
LOCATE 23, 63: PRINT CHR$(230) + "W   ": RETURN

ohmsbox:
IF selftest1 = 0 THEN GOTO ohmsbox2
FOR a = 16 TO 23: LOCATE a, 28: PRINT LEFT$(sp$, 48): NEXT: COLOR 11
LOCATE 13, 29: PRINT "USING THE PRESET VALUES SHOWN, CALCULATE THE"
COLOR 15: RETURN

ohmsbox2: COLOR 11
LOCATE 13, 29: PRINT "ANSWER =                                    ": COLOR 15
ac = 27: dn = 15: ltab = ac: rtab = ac + 49: ttab = dn - .5: btab = dn + 8.5
col = 10: GOSUB right2: GOSUB down2: GOSUB left2: GOSUB up2
COLOR 11: LOCATE 16, 29: PRINT "OHM'S LAW     POWER         RELATIONSHIPS"
COLOR 15: LOCATE 17, 29:
PRINT "V = I x R   P = I x V   V = " + CHR$(251) + "(PxR)  ";
PRINT "I = " + CHR$(251) + "(P/R)": LOCATE 18, 29
PRINT "I = V / R   I = P / V   R = P / I"; CHR$(253); "  ";
PRINT "P = V"; CHR$(253); " / R": LOCATE 19, 29
PRINT "R = V / I   V = P / I   R = V"; CHR$(253); " / P  ";
PRINT "P = I"; CHR$(253); " x R"
LOCATE 21, 29: PRINT "where :"
LOCATE 22, 29: PRINT "V = P.D. IN VOLTS    R = RESISTANCE IN OHMS"
LOCATE 23, 29: PRINT "I = CURRENT IN AMPS  P = POWER IN WATTS"
GOSUB scaleset2: RETURN

selftest: IF selftest1 = 1 THEN RETURN
selftest1 = 1: GOSUB ohmsbox
GOSUB cleartriangle1: GOSUB cleartriangle2

selftestohms:
exam = exam + 7: IF exam > 11 THEN exam = exam - 12
zvolts = INT(RND(1) * 6) - 6
zamps = INT(RND(1) * 6) - 6
zpower = INT(RND(1) * 6) - 6
volts = INT(RND(1) * 99) + 1
amps = INT(RND(1) * 99) + 1
power = INT(RND(1) * 99) + 1
res = INT(RND(1) * 152) + 1
GOSUB totalvolts: GOSUB totalamps: GOSUB totalpower: GOSUB totalres
GOSUB showexamfacts: GOSUB showexample: RETURN

answerohms:
selftest1 = 0: GOSUB showexample: GOSUB ohmsbox2
a = exam \ 3: d = exam - (a * 3)
dn = 16 + d: ac = 27 + (12 * a): GOSUB highlight
prevexam = exam: RETURN


'..................END PAGE 2

'.................START PAGE 3


page3: tm = 5: scale = 1: note = 0: selftest1 = 0: answer1 = 0
f$(0) = "Hz": f$(1) = "kHz": f$(2) = "MHz"
tnote$(0) = "secs": tnote$(1) = "ms": tnote$(2) = CHR$(230) + "s"
tnote(0) = 1: tnote(1) = 1000: tnote(2) = 1000000

tscale(0) = 1: tscale(1) = 10: tscale(2) = 100
tscale(3) = 1000: tscale(4) = 10000: tscale(5) = 100000
tscale(6) = 1000000: tscale(7) = 10000000: tscale(8) = 100000000

pmin = -18.4: pmax(1) = 145: pmax(2) = 145: pmax(3) = 145: pmax(4) = 80
pmax(5) = 100: pmax(6) = 145: pmax(7) = 100: pmax(8) = 100:
clear$ = "                 "

drawoscilloscope:
ac = 5: ax = ac + 41: dn = 2: dx = 23: td = dn + 2: tc = ax + 2: z = ax
LINE ((ac - 1) * 8 + 4, (dn - .5) * 14)-((ax + 9) * 8 + 7, (dx + .5) * 14), 15, B
LINE (ac * 8 + 4, dn * 14)-(ax * 8, dx * 14), 15, B
FOR a = ac * 8 + 4 + 2 + 32 TO ax * 8 - 32 STEP 32
FOR B = dn * 14 + 1 TO dx * 14 - 1 STEP 3: PSET (a, B), 14: NEXT: NEXT
LINE (ac * 8 + 5, 14)-(ax * 8 - 1, 14), 15
LINE (ac * 8 + 5, 10)-(ac * 8 + 5, 18), 15
LINE (ax * 8 - 1, 10)-(ax * 8 - 1, 18), 15

aa = (tc * 8) - 12: ab = (td * 14) - 18: FOR B = 1 TO 7
LINE (aa, ab)-(aa + (8 * 8) + 8, ab + 20), 15, B: ab = ab + 42: NEXT

PAINT (ac * 8 - 1, dn * 14 - 1), 3, 15: 'PAINT (320, 175), 1, 15
PSET ((ax + 9) * 8 + 7, (dn - .5) * 14), 15: DRAW "f4 d308 l411 h4": '414
PAINT ((ax + 9) * 8 + 9, dn * 14 + 14), 1, 15

LOCATE 1, 64: PRINT "CONTROLS:"
LOCATE 2, 64: COLOR 11: PRINT "F"; : COLOR 15: PRINT " FREQ/TIME"
LOCATE 3, 64: COLOR 11: PRINT "M"; : COLOR 15: PRINT " MENU"
LOCATE 4, 64: COLOR 11: PRINT "S"; : COLOR 15: PRINT " SELFTEST"
LOCATE 5, 64: COLOR 11: PRINT "U"; : COLOR 15: PRINT " UNITS"
LOCATE 6, 64: COLOR 11: PRINT "X"; : COLOR 15: PRINT " SCALE"
COLOR 11: LOCATE 7, 60: PRINT "+ - * / plus arrows"

wave$(1) = "TRIANGLE": wave$(2) = "+VE RAMP": wave$(3) = "-VE RAMP"
wave$(4) = "SINE": wave$(5) = "SQUARE": wave$(6) = "R-PULSE"
wave$(7) = "I-PULSE": wave$(8) = "COMPLEX"

col = 10: GOSUB frequencybox

FOR a = 1 TO 6: page(a) = -3: NEXT: page(7) = 20: page(8) = -10
page = 4: GOSUB waveforms
ac = 42 + 4: dn = 2: dx = 14: FOR p = 1 TO 7
ON p GOSUB 301, 302, 303, 304, 305, 306, 308
NEXT: page = 4

page3mode: z$ = UCASE$(INKEY$): IF z$ = "" THEN GOTO page3mode

IF z$ = "U" THEN note = note + 1: IF note > 2 THEN note = 0
IF z$ = "S" OR z$ = "Y" THEN selftest1 = 1: answer1 = 0: GOSUB selftest300
IF z$ = "A" AND selftest1 = 1 THEN selftest1 = 0: answer1 = 1
IF z$ = "N" THEN answer1 = 0: fcalc = fcalc AND 1
IF z$ = "M" THEN GOTO menu
IF answer1 = 1 THEN z$ = ""

IF z$ = "+" THEN page(page) = page(page) - .1
IF z$ = "-" THEN page(page) = page(page) + .1
IF z$ = "*" THEN page(page) = page(page) - 10
IF z$ = "/" THEN page(page) = page(page) + 10

IF z$ = "F" THEN fcalc = (fcalc + 1) AND 1: GOSUB freqcalc
IF z$ = "X" THEN scale = scale + 1: IF scale > 8 THEN scale = 0

IF MID$(z$, 2) = "" THEN GOTO 300
IF MID$(z$, 2) = "P" THEN page = page + 1
IF MID$(z$, 2) = "H" THEN page = page - 1
IF page > 8 THEN page = 1 ELSE IF page < 1 THEN page = 8
GOSUB waveforms: z$ = STR$(page)

300 : z = VAL(z$): IF z > 0 AND z < 9 THEN page = z: GOSUB waveforms
col = 10: ON page GOSUB 301, 302, 303, 304, 305, 306, 307, 308
GOTO page3mode

waveforms:
ON prevpage GOSUB 301, 302, 303, 304, 305, 306, 307, 308
FOR a = 1 TO 8: COLOR 15: IF a = page THEN COLOR 10
x = td + (a * 3) - 3: IF a = 8 THEN x = td + (7 * 3) - 3
IF a <> 7 THEN LOCATE x, tc: PRINT wave$(a): COLOR 15
NEXT: COLOR 10: IF page = 8 THEN COLOR 15
IF page = 7 OR page = 8 THEN x = td + (6 * 3) - 3: LOCATE x, tc: PRINT wave$(7)
COLOR 15: prevpage = page: RETURN

301 : IF page(1) > 320 THEN page(1) = 320: 'triangle
IF page(1) < -18.4 THEN page(1) = -18.4
x1 = page(1) + 19: y = dx * 4 - 8: jk = y: s = -10
yx = 320 / x1: x = ac: colf = 0: IF page = 1 THEN colf = 6
LINE (ac, y - 12)-(ac + 320, y + 12), colf, BF: PSET (ac, y + s), col
FOR a = 0 TO INT(yx): LINE -(x, y + s), col: x = x + x1: s = -s: NEXT
xx = x - x1 - ac: xy = 320 - xx: x4 = xy / x1: x5 = (20 * x4): y = y - s
jy = y + (x5 * SGN(s)): LINE -(ac + 320, jy), col
IF page = 1 THEN GOTO timeboxshow ELSE RETURN

302 : IF page(2) > 320 THEN page(2) = 320: 'posramp
IF page(2) < -18.4 THEN page(2) = -18.4
x1 = page(2) + 19: y = dx * 7 - 8: jk = y: s = -10
yx = 320 / x1: x = ac + x1: colf = 0: IF page = 2 THEN colf = 6
LINE (ac, y - 12)-(ac + 320, y + 12), colf, BF: PSET (ac, y - s), col
FOR a = 1 TO INT(yx): LINE -(x, y + s), col: LINE -(x, y - s), col
x = x + x1: NEXT: xx = x - x1 - ac: xy = 320 - xx: x4 = xy / x1: y = y - s
x5 = (20 * x4): jy = y + (x5 * SGN(s)): LINE -(ac + 320, jy), col
IF page = 2 THEN GOTO timeboxshow ELSE RETURN

303 : IF page(3) > 320 THEN page(3) = 320: 'negramp
IF page(3) < -18.4 THEN page(3) = -18.4
x1 = page(3) + 19: y = dx * 10 - 8: jk = y: s = 10
yx = 320 / x1: x = ac + x1: colf = 0: IF page = 3 THEN colf = 6
LINE (ac, y - 12)-(ac + 320, y + 12), colf, BF: PSET (ac, y - s), col
FOR a = 1 TO INT(yx): LINE -(x, y + s), col: LINE -(x, y - s), col
x = x + x1: NEXT: xx = x - x1 - ac: xy = 320 - xx: x4 = xy / x1: y = y - s
x5 = (20 * x4): jy = y + (x5 * SGN(s)): LINE -(ac + 320, jy), col
IF page = 3 THEN GOTO timeboxshow ELSE RETURN

304 : IF page(4) > 360 THEN page(4) = 360: 'sine
IF page(4) < -18.4 THEN page(4) = -18.4
y = dx * 12 + 6: jk = y: col = 10: angle = 270
colf = 0: IF page = 4 THEN colf = 6
LINE (ac, y - 12)-(ac + 320, y + 12), colf, BF: PSET (ac, y - 10), col
x1 = (page(4) + 19) * 2: aa = 360 / x1
FOR x = ac TO ac + 320: y1 = SIN(angle * pi) * 10 + y
angle = angle + aa: LINE -(x, y1), col: NEXT
IF page = 4 THEN GOTO timeboxshow ELSE RETURN

305 : IF page(5) > 320 THEN page(5) = 320: 'square
IF page(5) < -18.4 THEN page(5) = -18.4
x1 = page(5) + 19: y = dx * 16 - 8: jk = y: s = -10
yx = 320 / x1: x = ac + x1: colf = 0: IF page = 5 THEN colf = 6
LINE (ac, y - 12)-(ac + 320, y + 12), colf, BF: PSET (ac, y + s), col
FOR a = 1 TO INT(yx): LINE -(x, y + s), col: LINE -(x, y - s), col
x = x + x1: s = -s: NEXT: LINE -(ac + 320, y + s), col
IF page = 5 THEN GOTO timeboxshow ELSE RETURN

306 : IF page(6) > 320 THEN page(6) = 320: 'pulse
IF page(6) < -18.4 THEN page(6) = -18.4
x1 = page(6) + 19: y = dx * 19 - 8: jk = y: s = 10
yx = (320 * 2) / x1: x = ac + (x1 * 1 / 3)
colf = 0: IF page = 6 THEN colf = 6
LINE (ac, y - 12)-(ac + 320, y + 12), colf, BF: PSET (ac, y - s), col
FOR a = 1 TO yx: LINE -(x, y - s), col: LINE -(x, y + s), col
IF s < 0 THEN B = x1 / 3 ELSE B = x1 * (2 / 3)
x = x + B: s = -s: NEXT
IF x < ac + 320 THEN LINE -(x, y - s), col: LINE -(x, y + s), col: s = -s
IF s < 0 THEN B = x1 / 3 ELSE B = x1 * (2 / 3)
x = x + B: IF x < ac + 320 THEN LINE -(x, y - s), 14: LINE -(x, y + s), 14: s = -s
LINE -(ac + 320, y - s), col
IF page = 6 THEN GOTO timeboxshow ELSE RETURN

307 : IF page(7) > 320 THEN page(7) = 320: 'irregular pulse
IF page(7) < -1 THEN page(7) = 1
y = dx * 18 + 6: s = -10: colf = 0: IF page = 7 THEN colf = 6
LINE (ac, y - 12)-(ac + 320, y + 12), colf, BF
x1 = INT(RND(1) * page(7)) + ac + 3
prevx = ac: prevy = y + s: FOR x = ac TO ac + 320
LINE (prevx, prevy)-(x, y + s), col: IF x <> x1 THEN GOTO a307
LINE (x, y - s)-(x, y + s), col: x1 = INT(RND(1) * page(7)) + x + 1: s = -s
a307: prevx = x: prevy = y + s: NEXT
IF page = 7 THEN GOTO timeboxshow ELSE RETURN

308 : IF page(8) > 100 THEN page(8) = 100: 'complex
IF page(8) < -100 THEN page(8) = -100
y = dx * 21: colf = 0: IF page = 8 THEN colf = 6
LINE (ac, y - 13)-(ac + 320, y + 21), colf, BF
angle = RND(1) * 360: y1 = SIN(angle * pi) * 12: PSET (ac, y + y1), col
FOR x = ac TO ac + 318: B = RND(1) * page(8)
FOR e = 1 TO 6: d = RND(1) * 16: angle = angle + B
y1 = SIN(angle * pi) * d: LINE -(x, y + y1 + 4), col: x = x + 1: NEXT
NEXT: IF page = 8 THEN GOTO timeboxshow ELSE RETURN

frequencybox:
ac = 59: ax = ac + 19: dn = 8: dx = dn + 15
LINE (ac * 8, dn * 14 - 6)-(ax * 8, dx * 14 + 7), 15, B
LINE (ac * 8 - 4, dn * 14 - 10)-(ax * 8 + 4, dx * 14 + 11), 15, B
PAINT (ac * 8 + 2, dn * 14 - 8), 3, 15: RETURN

timeboxshow:
t3 = 0: ON page GOTO 311, 312, 312, 313, 311, 314
GOTO freqcalc

311 : t1 = x1 * 2 + ac: t2 = x1 * 4 + ac
IF t2 > ac + 320 THEN t1 = x1 + ac: t2 = x1 * 3 + ac
IF t2 > ac + 320 THEN GOTO freqcalc
t3 = CINT(x1 * 200): GOTO showtbs

312 : t1 = x1 + ac: t2 = x1 * 2 + ac: IF t2 > ac + 320 THEN GOTO freqcalc
t3 = CINT(x1 * 100): GOTO showtbs

313 : t1 = x1 + ac: t2 = x1 * 2 + ac
IF t2 > ac + 320 THEN t1 = x1 / 2 + ac: t2 = t1 + x1
IF t2 > ac + 320 THEN GOTO freqcalc
t3 = CINT(x1 * 100): GOTO showtbs

314 : t1 = x1 + ac: t2 = x1 * 2 + ac
IF t2 > ac + 320 THEN t1 = x1 / 3 + ac: t2 = t1 + x1
IF t2 > ac + 320 THEN GOTO freqcalc
t3 = CINT(x1 * 100)

showtbs: IF t2 > ac + 320 THEN t3 = 0: GOTO freqcalc
IF selftest1 = 0 THEN LINE (t1, jk - 12)-(t2, jk + 12), 15, B

freqcalc:
IF t3 = 0 THEN t$ = " UNCERTAIN        ": f$ = " UNRESOLVED     ": GOTO freqcalc4
t4 = t3: t3 = (t3 * tnote(note)) / (tscale(scale) * 320)
t$ = LEFT$(STR$(t3) + tnote$(note) + "          ", 16)
f = (tscale(scale) * 320) / (t4 * tnote(note))
f$ = LEFT$(STR$(f) + f$(note) + "             ", 16)

freqcalc4:
LOCATE 1, 18: s$ = STR$((1 / tscale(scale)) * 100 * tnote(note)) + " "
scale$ = LEFT$("SCALE =" + s$ + tnote$(note) + "          ", 20)
PRINT scale$: ON fcalc GOTO freqcalc5, freqcalc6, freqcalc7

freqcalc4a:
COLOR 11: LOCATE 9, 65: PRINT "FREQUENCY"
IF selftest1 = 0 THEN GOTO fc4a
FOR a = 10 TO 23: LOCATE a, 61: PRINT clear$: NEXT
COLOR 14: LOCATE 11, 65: PRINT "SELFTEST "
COLOR 11: LOCATE 13, 63: PRINT "ADJUST VALUES"
LOCATE 14, 64: PRINT "IF YOU WANT"
LOCATE 21, 62: PRINT "CALCULATE "; : COLOR 14: PRINT "f   "
COLOR 15: LOCATE 23, 62: PRINT "A "; : COLOR 11: PRINT "for ANSWER  "
GOTO fc4b

fc4a: COLOR 14: LOCATE 10, 66
IF answer1 = 1 THEN PRINT "ANSWER" ELSE PRINT "         "
LOCATE 23, 62: COLOR 11
IF answer1 = 1 THEN PRINT "ANOTHER Y/N " ELSE PRINT "           "
COLOR 15: LOCATE 11, 63: PRINT "  f = 1 / t"
COLOR 11: LOCATE 13, 61: PRINT "where:         ": COLOR 15
LOCATE 14, 61: PRINT "f = FREQUENCY    "
LOCATE 15, 61: PRINT "t = PERIODIC TIME"
COLOR 11: LOCATE 16, 65: PRINT "(outlined)"
LOCATE 17, 61: PRINT clear$
LOCATE 20, 61: PRINT clear$
COLOR 11: LOCATE 21, 62: PRINT "thus: f =    "
COLOR 14: LOCATE 22, 61: PRINT f$: COLOR 15

fc4b:
COLOR 11: LOCATE 18, 62: PRINT "t =             "
COLOR 14: LOCATE 19, 61: PRINT t$: COLOR 15: RETURN

freqcalc5:
COLOR 11: LOCATE 9, 65: PRINT "  TIME   "
IF selftest1 = 0 THEN GOTO fc5a
FOR a = 10 TO 23: LOCATE a, 61: PRINT clear$: NEXT
COLOR 14: LOCATE 11, 65: PRINT "SELFTEST "
COLOR 11: LOCATE 13, 63: PRINT "ADJUST VALUES"
LOCATE 14, 64: PRINT "IF YOU WANT"
LOCATE 21, 62: PRINT "CALCULATE "; : COLOR 14: PRINT "t   "
COLOR 15: LOCATE 23, 62: PRINT "A "; : COLOR 11: PRINT "for ANSWER  "
GOTO fc5b

fc5a: COLOR 14: LOCATE 10, 61
IF answer1 = 1 THEN PRINT "     ANSWER" ELSE PRINT clear$
LOCATE 23, 61: COLOR 11
IF answer1 = 1 THEN PRINT " ANOTHER Y/N " ELSE PRINT clear$
COLOR 15: LOCATE 11, 63: PRINT "  t = 1 / f"
COLOR 11: LOCATE 13, 61: PRINT "where:         ": COLOR 15
LOCATE 14, 61: PRINT "f = FREQUENCY    "
LOCATE 15, 61: PRINT "t = PREIODIC TIME"
COLOR 11: LOCATE 16, 65: PRINT "(outlined)"
LOCATE 17, 61: PRINT clear$
LOCATE 20, 61: PRINT clear$
COLOR 11: LOCATE 21, 62: PRINT "thus: t =    "
COLOR 14: LOCATE 22, 61: PRINT t$: COLOR 15

fc5b:
COLOR 11: LOCATE 18, 62: PRINT "f =          "
COLOR 14: LOCATE 19, 61: PRINT f$: COLOR 15: RETURN

freqcalc6:
IF answer1 = 1 THEN GOTO freqcalc6a
FOR a = 10 TO 22: LOCATE a, 61: PRINT clear$: NEXT
COLOR 14: LOCATE 11, 65: PRINT "SELFTEST "
COLOR 11: LOCATE 13, 62: PRINT "USING THE GRID"
LOCATE 14, 63: PRINT "AND WAVEFORM"
LOCATE 15, 63: PRINT "   SHOWN "
LOCATE 17, 64: PRINT "ESTIMATE "; : COLOR 14: PRINT "t   "
COLOR 15: LOCATE 23, 62: PRINT "A "; : COLOR 11: PRINT "for ANSWER  "
COLOR 15: RETURN

freqcalc6a:
FOR a = 13 TO 15: LOCATE a, 61: PRINT clear$: NEXT
COLOR 14: LOCATE 13, 66: PRINT "ANSWER"
LOCATE 19, 62: PRINT "t = ": LOCATE 20, 61: PRINT t$
COLOR 11: LOCATE 23, 62: PRINT "ANOTHER Y/N ": COLOR 15: RETURN

freqcalc7:
IF answer1 = 1 THEN GOTO freqcalc7a
FOR a = 10 TO 22: LOCATE a, 61: PRINT clear$: NEXT
COLOR 14: LOCATE 11, 65: PRINT "SELFTEST "
COLOR 11: LOCATE 13, 62: PRINT "USING THE GRID"
LOCATE 14, 63: PRINT "AND WAVEFORM"
LOCATE 15, 63: PRINT "   SHOWN "
LOCATE 17, 64: PRINT "ESTIMATE "; : COLOR 14: PRINT "f   "
COLOR 15: LOCATE 23, 62: PRINT "A "; : COLOR 11: PRINT "for ANSWER  "
COLOR 15: RETURN

freqcalc7a:
FOR a = 13 TO 15: LOCATE a, 61: PRINT clear$: NEXT
COLOR 14: LOCATE 13, 66: PRINT "ANSWER"
LOCATE 19, 62: PRINT "f = ": LOCATE 20, 61: PRINT f$
COLOR 11: LOCATE 23, 62: PRINT "ANOTHER Y/N ": COLOR 15: RETURN

selftest300: IF selftest1 = 0 THEN RETURN
selftest301: fcalc = (fcalc + 1) AND 3

selftest302: scale = CINT(RND(1) * 8): p = page(page)
selftest303: p = p + 53.3: IF p > pmax(page) THEN p = RND(1) * pmin
IF p = prevrnd THEN GOTO selftest303
page(page) = p: z$ = STR$(page): prevrnd = page(page): RETURN

'........................END OF PAGE 3


'........................START OF PAGE 4


page4: tm = 3: tc = 50
COLOR 11: LOCATE 1, 13: PRINT "SINE WAVE VALUE RELATIONSHIPS": COLOR 15
exam = 0: prevexam = 0: av = 1: pk = 1: pkpk = 1: rms = 1
tav = av: tpk = pk: tpkpk = pkpk: trms = rms
scale = 0: value = 1: selftest1 = 0

ac = 62: dn = 1.3: ltab = ac: rtab = ac + 14: ttab = dn - .5: btab = dn + 3
col = 10: GOSUB right2: GOSUB down2: GOSUB left2: GOSUB up2
LOCATE 2, 64: COLOR 11: PRINT "X"; : COLOR 15: PRINT " SCALE"
LOCATE 3, 64: COLOR 11: PRINT "S"; : COLOR 15: PRINT " SELFTEST"
LOCATE 4, 64: COLOR 11: PRINT "M"; : COLOR 15: PRINT " MENU"

rmssine:
ac = 10: dn = 2: ltab = ac: ttab = dn: btab = dn + 13: rtab = ac + 36
col = 15: GOSUB up2: ttab = dn + 6.5: GOSUB right2: midtab = ttab * 14
PUT (rtab * 8 - 8, midtab - 7), arrowright%, PSET

LOCATE dn + 1, 7: PRINT "+VE": LOCATE dn + 7, 8: PRINT "0V"
LOCATE dn + 13, 7: PRINT "-VE": LOCATE dn + 7, 48: PRINT "TIME"

sinetime:
ac = 5: ax = ac + 41: col = 15: ac = ac * 8 + 4 + 32: ax = ax * 8
PSET (ac, midtab), 15: min = 1000: max = -1000
angle = -180: FOR a = ac TO 360: c = SIN(angle * pi) * 85 + midtab
angle = angle + 1.4: LINE -(a, c), col: IF c > max THEN max = c: peakmax = a
IF c < min THEN min = c: peakmin = a
IF angle > 180 THEN EXIT FOR
NEXT: min = min - 1: max = max + 1

ac = 5: ax = ac + 41: col = 15: ac = ac * 8 + 4 + 32: ax = ax * 8
LINE (ac, min)-(ax - 4, min), 14: 'positive peak line
LINE (ac, max)-(ax - 4, max), 14: 'negative peak line
GOSUB rmsbox2

valuesbox4:
ac = 6: dn = 16: ltab = ac: rtab = ac + 17: ttab = dn - .5: btab = dn + 7.5
col = 10: GOSUB right2: GOSUB down2: GOSUB left2: GOSUB up2
COLOR 11: LOCATE 17, 7: PRINT "PRESET VALUES"
LOCATE 18, 7: PRINT "ADJUSTABLE WHEN": LOCATE 19, 7: PRINT "VALUE SHOWN": COLOR 15
LOCATE 20, 7: PRINT "AV": LOCATE 21, 7: PRINT "Pk"
LOCATE 22, 7: PRINT "Pk-Pk": LOCATE 23, 7: PRINT "RMS"
COLOR 11: LOCATE 12, 60: PRINT "VALUE CONTROLS:  "
LOCATE 14, 60: PRINT "FORMULA CONTROLS:"
COLOR 15: LOCATE 13, 60: PRINT "+ - * /"
LOCATE 15, 60: PRINT "KEYBOARD ARROWS"
GOSUB showvalues4: GOSUB showexample4

setformulahighlight:
a = prevexam \ 4: d = prevexam - (a * 4)
dn = 19 + d: ac = 32 + (13 * a): GOSUB highlight4:
GOSUB vav: GOSUB vpk: GOSUB vpkpk: GOSUB vrms

page4mode:
z$ = INKEY$: IF z$ = "" THEN GOTO page4mode
z$ = UCASE$(z$)
IF z$ = "X" THEN GOSUB scaleset4: GOTO page4mode
IF z$ = "M" THEN GOTO menu
IF z$ = "S" THEN GOSUB selftest4: GOTO page4mode
IF selftest1 = 1 GOTO ex42

IF MID$(z$, 2) = "" THEN GOTO ex42
z$ = MID$(z$, 2)
IF z$ = "M" THEN exam = exam + 4
IF z$ = "K" THEN exam = exam - 4
IF z$ = "P" THEN exam = exam + 1
IF z$ = "H" THEN exam = exam - 1
IF exam > 11 THEN exam = 11 ELSE IF exam < 0 THEN exam = 0
IF exam = prevexam THEN GOTO page4mode
a = prevexam \ 4: d = prevexam - (a * 4)
dn = 19 + d: ac = 32 + (14 * a): GOSUB highlight4
a = exam \ 4: d = exam - (a * 4)
dn = 19 + d: ac = 32 + (14 * a): GOSUB highlight4
prevexam = exam: GOSUB showexample4: GOTO page4mode

ex42:
IF z$ = "+" THEN GOSUB incval4: GOSUB showexample4: GOTO page4mode
IF z$ = "-" THEN GOSUB decval4: GOSUB showexample4: GOTO page4mode
IF z$ = "*" THEN GOSUB multval4: GOSUB showexample4: GOTO page4mode
IF z$ = "/" THEN GOSUB divideval4: GOSUB showexample4: GOTO page4mode
IF selftest1 = 1 AND z$ = "Y" THEN GOSUB selftestsine: GOTO page4mode
IF selftest1 = 1 AND z$ = "A" THEN GOSUB answersine: ' GOTO page4mode
prevvalue = value: GOTO page4mode

showexample4:
ON exam + 1 GOTO exam41, exam42, exam43, exam44, exam45, exam46
ON exam - 5 GOTO exam47, exam48, exam49, exam410, exam411, exam412

exam41: 'AV = PK x 0.636
mult4 = .636: pk2 = tpk: pk$ = STR$(pk2) + vscale$(scale) + "pk"
mult$ = STR$(mult4)
av2 = pk2 * mult4: av$ = STR$(av2) + vscale$(scale) + "av"
q$ = "AV =" + pk$ + " x" + mult$ + " =" + av$
q1$ = "AVERAGE": value = 1: GOSUB showexamfacts4: RETURN

exam42: 'PK = AV x 1.57
mult4 = 1.57: av2 = tav: av$ = STR$(av2) + vscale$(scale) + "av"
mult$ = STR$(mult4)
pk2 = av2 * mult4: pk$ = STR$(pk2) + vscale$(scale) + "pk"
q$ = "Pk =" + av$ + " x" + mult$ + " =" + pk$
q1$ = "PEAK": value = 0: GOSUB showexamfacts4: RETURN

exam43: 'Pk-Pk = AV x 3.14
mult4 = 3.14: av2 = tav: av$ = STR$(av2) + vscale$(scale) + "av"
mult$ = STR$(mult4)
pkpk2 = av * mult4: pkpk$ = STR$(pkpk2) + vscale$(scale) + "pk-pk"
q$ = "Pk-Pk =" + av$ + " x" + mult$ + " =" + pkpk$
q1$ = "PEAK-PEAK": value = 0: GOSUB showexamfacts4: RETURN

exam44: 'RMS = AV x 1.11
mult4 = 1.11: av2 = tav: av$ = STR$(av2) + vscale$(scale) + "av"
mult$ = STR$(mult4)
rms2 = av2 * mult4: rms$ = STR$(rms2) + vscale$(scale) + "rms"
q$ = "RMS =" + av$ + " x" + mult$ + " =" + rms$
q1$ = "RMS": value = 0: GOSUB showexamfacts4: RETURN

exam45: 'AV = PK-PK x 0.318
mult4 = .318: pkpk2 = tpkpk: pkpk$ = STR$(pkpk2) + vscale$(scale) + "pk-pk"
mult$ = STR$(mult4)
av2 = pkpk2 * mult4: av$ = STR$(av2) + vscale$(scale) + "av"
q$ = "AV =" + pkpk$ + " x" + mult$ + " =" + av$
q1$ = "AVERAGE": : value = 2: GOSUB showexamfacts4: RETURN

exam46: 'PK = PK-PK x 0.5
mult4 = .5: pkpk2 = tpkpk: pkpk$ = STR$(pkpk2) + vscale$(scale) + "pk-pk"
mult$ = STR$(mult4)
pk2 = pkpk2 * mult4: pk$ = STR$(pk2) + vscale$(scale) + "pk"
q$ = "Pk =" + pkpk$ + " x" + mult$ + " =" + pk$
q1$ = "PEAK": value = 2: GOSUB showexamfacts4: RETURN

exam47: 'PK-PK = PK x 2
mult4 = 2: pk2 = tpk: pk$ = STR$(pk2) + vscale$(scale) + "pk"
mult$ = STR$(mult4)
pkpk2 = pk2 * mult4: pkpk$ = STR$(pkpk2) + vscale$(scale) + "pk-pk"
q$ = "Pk-Pk =" + pk$ + " x" + mult$ + " =" + pkpk$
q1$ = "PEAK-PEAK": value = 1: GOSUB showexamfacts4: RETURN

exam48: 'RMS = PK x 0.707
mult4 = .707: pk2 = tpk: pk$ = STR$(pk2) + vscale$(scale) + "pk"
mult$ = STR$(mult4)
rms2 = pk2 * mult4: rms$ = STR$(rms2) + vscale$(scale) + "rms"
q$ = "RMS =" + pk$ + " x" + mult$ + " =" + rms$
q1$ = "RMS": value = 1: GOSUB showexamfacts4: RETURN

exam49: 'AV = RMS x 0.9
mult4 = .9: rms2 = trms: rms$ = STR$(rms2) + vscale$(scale) + "rms"
mult$ = STR$(mult4)
av2 = rms2 * mult4: av$ = STR$(av2) + vscale$(scale) + "av"
q$ = "AV =" + rms$ + " x" + mult$ + " =" + av$
q1$ = "AVERAGE": value = 3: GOSUB showexamfacts4: RETURN

exam410: 'PK = RMS x 1.414
mult4 = 1.414: rms2 = trms: rms$ = STR$(rms2) + vscale$(scale) + "rms"
mult$ = STR$(mult4)
pk2 = rms2 * mult4: pk$ = STR$(pk2) + vscale$(scale) + "pk"
q$ = "Pk =" + rms$ + " x" + mult$ + " =" + pk$
q1$ = "PEAK": value = 3: GOSUB showexamfacts4: RETURN

exam411: 'PK-PK = RMS x 2.828
mult4 = 2.828: rms2 = trms: rms$ = STR$(rms2) + vscale$(scale) + "rms"
mult$ = STR$(mult4)
pkpk2 = rms2 * mult4: pkpk$ = STR$(pkpk2) + vscale$(scale) + "pk-pk"
q$ = "Pk-Pk =" + rms$ + " x" + mult$ + " =" + pkpk$
q1$ = "PEAK-PEAK": value = 3: GOSUB showexamfacts4: RETURN

exam412: 'RMS = PK-PK x 0.353
mult4 = .353: pkpk2 = tpkpk: pkpk$ = STR$(pkpk2) + vscale$(scale) + "pk-pk"
mult$ = STR$(mult4)
rms2 = pkpk2 * mult4: rms$ = STR$(rms2) + vscale$(scale) + "rms"
q$ = "RMS =" + pkpk$ + " x" + mult$ + " =" + rms$
q1$ = "RMS": value = 2: GOSUB showexamfacts4: RETURN

rmsbox: ac = 25
dn = 16: ltab = ac - 1: rtab = ac + 49: ttab = dn - .5: btab = dn + 7.4
ttab = dn + 2.5: IF selftest1 = 0 THEN GOTO rmsbox2
FOR a = 20 TO 23: LOCATE a, 25: PRINT LEFT$(sp$, 49): NEXT: COLOR 11
LOCATE 17, 25: PRINT "USING THE PRESET VALUES SHOWN, CALCULATE THE"
col = 0: ltab = ltab + 8: GOSUB up2
ltab = ltab + 14: GOSUB up2: ltab = ltab + 14: GOSUB up2
col = 10: GOSUB right2: COLOR 15: RETURN

rmsbox2: ac = 25: LOCATE 17, ac: COLOR 11
PRINT "ANSWER =                                     ": COLOR 15
dn = 16: ltab = ac - 1: rtab = ac + 49: ttab = dn - .5: btab = dn + 7.5
col = 10: GOSUB right2: GOSUB down2: GOSUB left2: GOSUB up2
LOCATE 20, ac: PRINT "AV =    Pk x 0.636    Pk-Pk x 0.318 RMS   x 0.9"
LOCATE 21, ac: PRINT "Pk =    AV x 1.57     Pk-Pk x 0.5   RMS   x 1.414"
LOCATE 22, ac: PRINT "Pk-Pk = AV x 3.14     Pk    x 2     RMS   x 2.828"
LOCATE 23, ac: PRINT "RMS =   AV x 1.11     Pk    x 0.707 Pk-Pk x 0.353"
ttab = dn + 2.5: GOSUB right2: ltab = ltab + 8: GOSUB up2
ltab = ltab + 14: GOSUB up2: ltab = ltab + 14: GOSUB up2: RETURN

showexamfacts4:
IF selftest1 = 0 OR z$ = "A" THEN COLOR 15 ELSE COLOR 0
q$ = LEFT$(q$ + sp$, 48)
q1$ = LEFT$(q1$ + " VALUE" + sp$, 47)
av$ = LEFT$(av$ + sp$, 24)
pk$ = LEFT$(pk$ + sp$, 24)
pkpk$ = LEFT$(pkpk$ + sp$, 24)
rms$ = LEFT$(rms$ + sp$, 24)
mult$ = LEFT$(mult$ + sp$, 24)
LOCATE 18, 25: PRINT q$
COLOR 15: LOCATE 18, 25:
IF selftest1 = 1 THEN PRINT q1$: COLOR 11: LOCATE 18, 45
IF selftest1 = 1 THEN PRINT "PRESS [A] TO SHOW ANSWER": COLOR 15
GOSUB showvalues4: RETURN

showvalues4:
s$(0) = STR$(tav) + vscale$(scale)
s$(1) = STR$(tpk) + vscale$(scale)
s$(2) = STR$(tpkpk) + vscale$(scale)
s$(3) = STR$(trms) + vscale$(scale)

FOR a = 0 TO 3: IF value <> a THEN s$(a) = ""
s$(a) = LEFT$(s$(a) + sp$, 11): LOCATE 20 + a, 12: PRINT s$(a): NEXT
RETURN

highlight4:
ax = ac * 8: ay = (ac + 13) * 8: dx = dn * 14: dy = (dn + 1) * 14
GET (ax, dx)-(ay, dy), a%: PUT (ax, dx), a%, PRESET: RETURN

getvalues4:
incval4: ON value + 1 GOTO avinc, pkinc, pkpkinc, rmsinc
decval4: ON value + 1 GOTO avdec, pkdec, pkpkdec, rmsdec
multval4: ON value + 1 GOTO avmult, pkmult, pkpkmult, rmsmult
divideval4: ON value + 1 GOTO avdivide, pkdivide, pkpkdivide, rmsdivide

avinc: av = av + 1: GOTO totalav
pkinc: pk = pk + 1: GOTO totalpk
pkpkinc: pkpk = pkpk + 1: GOTO totalpkpk
rmsinc: rms = rms + 1: GOTO totalrms

avdec: av = av - 1: IF av < 1 THEN av = 1
GOTO totalav
pkdec: pk = pk - 1: IF pk < 1 THEN pk = 1
GOTO totalpk
pkpkdec: pkpk = pkpk - 1: IF pkpk < 1 THEN pkpk = 1
GOTO totalpkpk
rmsdec: rms = rms - 1: IF rms < 1 THEN rms = 1
GOTO totalrms

avmult: zav = zav + 1: IF zav > 1 THEN zav = 1
GOTO totalav
pkmult: zpk = zpk + 1: IF zpk > 1 THEN zpk = 1
GOTO totalpk
pkpkmult: zpkpk = zpkpk + 1: IF zpkpk > 1 THEN zpkpk = 1
GOTO totalpkpk
rmsmult: zrms = zrms + 1: IF zrms > 1 THEN zrms = 1
GOTO totalrms

avdivide: zav = zav - 1: IF zav < -6 THEN zav = -6
GOTO totalav
pkdivide: zpk = zpk - 1: IF zpk < -6 THEN zpk = -6
GOTO totalpk
pkpkdivide: zpkpk = zpkpk - 1: IF zpkpk < -6 THEN zpkpk = -6
GOTO totalpkpk
rmsdivide: zrms = zrms - 1: IF zrms < -6 THEN zrms = -6
GOTO totalrms

totalav: tav = av * (10 ^ zav) * (1000 ^ scale): RETURN
totalpk: tpk = pk * (10 ^ zpk) * (1000 ^ scale): RETURN
totalpkpk: tpkpk = pkpk * (10 ^ zpkpk) * (1000 ^ scale): RETURN
totalrms: trms = rms * (10 ^ zrms) * (1000 ^ scale): RETURN

scaleset4:
scale = scale + 1: IF scale > 2 THEN scale = 0
GOSUB totalav: GOSUB totalpk: GOSUB totalpkpk: GOSUB totalrms
GOSUB showexamfacts4: GOSUB showexample4: 'IF selftest1 = 1 THEN RETURN
RETURN

selftest4: IF selftest1 = 1 THEN RETURN
a = prevexam \ 4: d = prevexam - (a * 4)
dn = 19 + d: ac = 32 + (14 * a): GOSUB highlight4
selftest1 = 1: GOSUB rmsbox

selftestsine:
exam = exam + 7: IF exam > 11 THEN exam = exam - 12
zav = INT(RND(1) * 6) - 6
zpk = INT(RND(1) * 6) - 6
zpkpk = INT(RND(1) * 6) - 6
zrms = INT(RND(1) * 6) - 6
av = INT(RND(1) * 99) + 1
pk = INT(RND(1) * 99) + 1
pkpk = INT(RND(1) * 99) + 1
rms = INT(RND(1) * 99) + 1
GOSUB totalav: GOSUB totalpk: GOSUB totalpkpk: GOSUB totalrms
GOSUB showexamfacts4: GOSUB showexample4: RETURN

answersine: selftest1 = 0: GOSUB showexample4: GOSUB rmsbox2
a = exam \ 4: d = exam - (a * 4): dn = 19 + d: ac = 32 + (14 * a)
GOSUB highlight4: prevexam = exam: RETURN

vav: ac = 10: ax = ac * 8: ay = (ac + 19) * 8: dn = 7
a = (midtab - min) * .636: LINE (ax - 4, midtab - a)-(ay, midtab - a), 15
PAINT (peakmin, midtab - a + 3), 4, 15
LINE (ay - 16, midtab - a + 2)-(ay - 16, midtab - 1), 14
PUT (ay - 24, midtab - a + 1), arrowup%, PSET
PUT (ay - 24, midtab - 10), arrowdown%, PSET
LOCATE dn, ac + 19: PRINT "Vav": RETURN

vpk: ac = 37: ax = ac * 8: dn = 6
LINE (ax + 8, min)-(ax + 8, midtab - 1), 14: 'peak +V line
PUT (ax, min + 1), arrowup%, PSET
PUT (ax, midtab - 10), arrowdown%, PSET
LOCATE dn, ac + 3: PRINT "Vpk": RETURN

vpkpk: ac = 42: ax = ac * 8: dn = 6
LINE (ax + 8, min)-(ax + 8, max), 14: 'pk-pk line
PUT (ax, min + 1), arrowup%, PSET
PUT (ax, max - 10), arrowdown%, PSET
LOCATE dn, ac + 3: PRINT "Vpk-pk": RETURN

vrms: ac = 10: ax = ac * 8: ay = (ac + 24) * 8: dn = 7
a = (midtab - min) * .7: LINE (ax - 4, midtab - a)-(ay, midtab - a), 15
PAINT (peakmin, midtab - a + 3), 4, 15
LINE (ay - 16, midtab - a + 2)-(ay - 16, midtab - 1), 14
PUT (ay - 24, midtab - a + 1), arrowup%, PSET
PUT (ay - 24, midtab - 10), arrowdown%, PSET
LOCATE dn, ac + 24: PRINT "Vrms": RETURN


'.....................END OF PAGE 4

'......................MISC CALLS

diagonal: tl = (ltab - .5) * 8 - 1: br = (rtab - .5) * 8 - 1
top = ttab * 14: bot = btab * 14: LINE (tl, top)-(br, bot), col: RETURN

right2: lt = (ltab - .5) * 8 - 1: rt = (rtab - .5) * 8 - 1
LINE (lt, ttab * 14)-(rt, ttab * 14), col: RETURN
left2: lt = (ltab - .5) * 8 - 1: rt = (rtab - .5) * 8 - 1
LINE (rt, btab * 14)-(lt, btab * 14), col: RETURN
down2: rt = (rtab - .5) * 8 - 1: tt = ttab * 14: bt = btab * 14
LINE (rt, tt)-(rt, bt), col: RETURN
up2: lt = (ltab - .5) * 8 - 1: tt = ttab * 14: bt = btab * 14
LINE (lt, tt)-(lt, bt), col: RETURN

batterysymbol:
GOSUB right2
ltab = ltab + 1: rtab = rtab - 1: ttab = ttab + .5: GOSUB right2
rtab = rtab - 1: btab = btab + .5: GOSUB down2
ttab = ttab + 1: btab = btab + 1: GOSUB down2
ltab = ltab - 1: rtab = rtab + 2: ttab = ttab + 1: GOSUB right2
ltab = ltab + 1: rtab = rtab - 1: ttab = ttab + .5: GOSUB right2
ltab = ac + 5.2: rtab = ltab + 1.2: ttab = 10 - .5: GOSUB right2: 'minus
ttab = 5 + .5: GOSUB right2: 'plus
ttab = 4.7 + .5: btab = ttab + .6: rtab = ac + 5.5 + .2: GOSUB down2
col = 15: RETURN

vresistor:
V = (ltab + .5) * 8 - 1: h = (ttab + .5) * 14
W = 16: x = 8: PSET (V, h), col: h = h + x
LINE -(V, h), 15: h = h + (x / 2): V = V + x: FOR a = 1 TO 2
LINE -(V, h), col: h = h + x: V = V - W
LINE -(V, h), col: h = h + x: V = V + W: NEXT
LINE -(V, h), col: h = h + (x / 2): V = V - (W / 2)
LINE -(V, h), col: h = h + x: LINE -(V, h), 15: RETURN

highlight:
ax = ac * 8: ay = (ac + 11) * 8: dx = dn * 14: dy = (dn + 1) * 14
GET (ax, dx)-(ay, dy), a%: PUT (ax, dx), a%, PRESET: RETURN

'............................

'SETUP ROUTINES

setup:
sp$ = "                                       ": sp$ = sp$ + sp$

ohms$(1) = "OHMS   ": ohms$(2) = "KILOHMS": ohms$(3) = "MEGOHMS"
ohms$(4) = "GIGOHMS"

vscale$(0) = "V": vscale$(1) = "mV": vscale$(2) = CHR$(230) + "V"
ascale$(0) = "A ": ascale$(1) = "mA": ascale$(2) = CHR$(230) + "A"
rscale$(0) = ohms$ + " ": rscale$(1) = "k" + ohms$: rscale$(2) = "M" + ohms$
pscale$(0) = "W ": pscale$(1) = "mW": pscale$(2) = CHR$(230) + "W"
scaleval(0) = 1: scaleval(1) = 1000: scaleval(2) = 1000000

r$(1) = ohms$(1): r$(2) = r$(1): r$(3) = r$(1)
r$(4) = ohms$(2): r$(5) = r$(4): r$(6) = r$(4)
r$(7) = ohms$(3): r$(8) = r$(7): r$(9) = r$(7)

FOR a = 1 TO 24: READ res(a): NEXT: c = 0: FOR B = 0 TO 8: FOR a = 1 TO 24
c = c + 1: res(c) = res(a) * (10 ^ B): d = res(a) * decival%(B)
IF decival%(B) <> 1 THEN d = INT(d)
IF INT(res(c)) = 910000 THEN res(c) = 910000
r$ = LEFT$(STR$(d) + "       ", 6): res$(c) = r$ + r$(B + 1): NEXT: NEXT
c = c + 1: res(c) = 1000000000: res$(c) = " 1000 MEGOHMS"

arrows1:
ltab = ac + 18: rtab = ac + 26: ttab = 6: btab = 9
dc = 30.5: PSET (dc * 8 - 1, 4.5 * 14 + 2), 14: DRAW "f8 l16 e8": 'up arrow
PAINT (dc * 8, 5 * 14), 14, 14
GET (dc * 8 - 9, 4.5 * 14 + 2)-((dc + 2) * 8 - 9, 5.5 * 14 - 3), arrowup%

dc = 39: PSET (dc * 8 - 1, 3 * 14 + 6), 14: DRAW "f8 g8 u16": 'right arrow
PAINT (dc * 8, 3 * 14 + 8), 14, 14
GET (dc * 8 - 2, 3 * 14 + 6)-((dc + 2) * 8 - 9, 4.5 * 14 + 1), arrowright%
dc = 48.5: PSET (dc * 8 - 1, 5.5 * 14 - 1), 14: DRAW "e8 l16 f8": 'down arrow
PAINT (dc * 8, 5.5 * 14 - 3), 14, 14
GET (dc * 8 - 9, 5 * 14 - 3)-((dc + 2) * 8 - 9, 5.5 * 14 - 2), arrowdown%

ac = 40: PSET (ac * 8 - 1, 10 * 14 + 6), 14: DRAW "g8 f8 u16": 'left arrow
PAINT (ac * 8 - 4, 11 * 14 + 2), 14, 14
GET (ac * 8 - 8, 10 * 14 + 6)-((ac) * 8 + 0, 11.5 * 14 + 1), arrowleft%

wx = 120: lx = 94: vx = 65: x = wx + 7: y = 230 + (lx / 2):
CIRCLE (y, x), 5, 12: PAINT (y, x), 12, 12: '3
GET (y - 5, x - 5)-(y + 6, x + 6), electron%: ' y = y - 5: x = x - 5
PUT (y - 5, x - 5), electron%, XOR: CLS : RETURN

'.................END OF SET UP

'............MISC CALLS

delay: COLOR 15: timestart = TIMER
tw = tm / 100: ty = tw - INT(tw): tx = INT(tw) * 60 + (ty * 100)
tz = (tx / 3) + timestart: LOCATE 24, 60: PRINT "HOLD TO"; tm;
delay3: IF TIMER < tz THEN GOTO delay3
LOCATE 24, 60: PRINT "            "; : LOCATE 1, 1: RETURN

shortdelay: tx = TIMER + .01
delay3a: IF TIMER > tx THEN RETURN ELSE GOTO delay3a

