;RBD.ASM
;CHRISTMAS LIGHTS.
;Outputs are A0,A1 and A2. ZeroX i/p is A3.
;outputs drive transistors ie. go high for on.
;B0 & B1 used for i/p 
;**********************************************************************

PHCTR1  equ 0Ch ;phase counter 1
PHCTR2  equ 0Dh
PHCTR3  equ 0Eh

BRG1    equ 0Fh ;brightness register 1 
BRG2    equ 10h   
BRG3    equ 11h

DMDR    equ 12h ;Dimming direction register
PLSCTR  equ 13h ;pulse counter
GPREG   equ 14h ;GENERAL purpose register for delays etc.
GPREG2  equ 1Dh
GPREG3  equ 1Eh

NCTR1   equ 17h
NCTR2   equ 18h
NCTR3   equ 19h

NREG1   equ 1Ah
NREG2   equ 1Bh
NREG3   equ 1Ch

        LIST P=16C84  ;f=inhx16
        include "PIC.H"
;**********************************************************************
        goto START
;**********************************************************************

INTLSE  movlw 0F8h      ; ie 1111 1000
        tris PORTA      ; set up PORTA as o/ps except A3 i/p

        movlw 03h       ; i.e. 0000 0011
        tris PORTB      ; set up PORTB as o/p except B0 and B1

        movlw 01h
        movwf DMDR      ; ie. 0000 0001

        clrf PORTB

        movlw .20
        movwf GPREG2

        movlw .32
        movwf NREG1
        movwf NREG2
        movwf NREG3 

        movwf NCTR1
        movwf NCTR2
        movwf NCTR3

        movlw .120
        movwf BRG1
        movlw .80
        movwf BRG2
        movlw .40
        movwf BRG3

        retlw 00

;**********************************************************************

DELAY   movlw 0FFh
        movwf GPREG3
DLY1    decfsz GPREG3,1
        goto DLY1
        retlw 00         ; end of delay

;**********************************************************************

PSET    nop
        decfsz NCTR1,1
        goto PSETB      ; if not zero
        call LIN1       ; linearise and reload NCTR1

PSETA2  btfss DMDR,0
        goto PSETA3     ; if bit0 = 0
        decf BRG1,1     ; if bit0 = 1 ie. brighten
        btfss STATUS,2  ; test if BRG1 is zero
        goto PSETB      ; if not zero
        movlw 01
        movwf BRG1      ; make BRG1 = 1 if it was zero
        bcf DMDR,0      
        goto PSETB

PSETA3  incf BRG1,1     ; if bit0 = 0 ie. dim
        movlw .122      
        xorwf BRG1,w
        btfss STATUS,2
        goto PSETB      
        movlw .121      ; ie. 0111 1000
        movwf BRG1      
        bsf DMDR,0      

PSETB   decfsz NCTR2,1
        goto PSETC      ; if NCTR2 is not zero
        call LIN2       ; linearise and reload NCTR2

PSETB2  btfss DMDR,1
        goto PSETB3     ; if bit 2 = 0 ie. dim
        decfsz BRG2,1   ; if bit 2 = 1 ie. brighten
        goto PSETC      ; if BRG2 is not zero
        incf BRG2,1     ; increment BRG2 to 1 if it is zero
        bcf DMDR,1      
        goto PSETC

PSETB3  incf BRG2,1     ; if bit 2 of DMDR = 0 ie. dim
        movlw .122
        xorwf BRG2,w    
        btfss STATUS,2
        goto PSETC      
        decf BRG2,1     
        bsf DMDR,1    

PSETC   decfsz NCTR3,1
        goto PSETD      
        call LIN3       

PSETC2  btfss DMDR,2
        goto PSETC3
        decfsz BRG3,1
        goto PSETD
        incf BRG3,1
        bcf DMDR,2      
        goto PSETD

PSETC3  incf BRG3,1
        movlw .122
        xorwf BRG3,w
        btfss STATUS,2
        goto PSETD
        decf BRG3,1
        bsf DMDR,2      

PSETD    retlw 00

;**********************************************************************

ZRX     clrwdt          ; ZERO CROSSING SUBROUTINE
        movlw .122
        movwf PLSCTR  
        movlw 00h
        movwf PORTA     ; switch off outputs
        movf BRG1,w
        movwf PHCTR1    ; load PHCTR1 with contents of BRG1
        movf BRG2,w
        movwf PHCTR2
        movf BRG3,w
        movwf PHCTR3

        retlw 00

;**********************************************************************

DIMR    clrwdt          ;DIMMING ROUTINE
        movf PLSCTR,1
        btfsc STATUS,2  
        retlw 00        ; no more trigger pulses
        decf PLSCTR,1

        movf PHCTR1,1
        btfss STATUS,2  ; is PHCTR1 = 0?
        goto DIMR1      ; no
        bsf PORTA,0     ; yes - switch triac on
        goto DIMR1A

DIMR1   decf PHCTR1,1
DIMR1A  movf PHCTR2,1
        btfss STATUS,2  ; is PHCTR2 = 0?
        goto DIMR2      ; no
        bsf PORTA,1     ; yes - switch triac on
        goto DIMR2A

DIMR2   decf PHCTR2,1
DIMR2A  movf PHCTR3,1
        btfss STATUS,2
        goto DIMR3      ; if PHCTR3 is not zero
        bsf PORTA,2     ; if it is - switch triac on
        goto DIMR3A

DIMR3   decf PHCTR3,1

DIMR3A  nop
        nop
        nop
        nop
        nop
        clrf PORTA      ; switch off outputs
        retlw 00                                         

;**********************************************************************

LIN1    clrwdt          ;        LINEARISE 1 SUBROUTINE
        bcf STATUS,0    ; check if  40<BRG>80
        movlw .80
        subwf BRG1,w
        btfss STATUS,0
        goto FAST1
        movlw .40
        subwf BRG1,w
        btfss STATUS,0
        goto SLOW1

FAST1   movf NREG1,w    ; move N value (from NREG) into NCTR1
        movwf NCTR1
        retlw 00

SLOW1   clrc            ; clear carry and move 2N into NCTR1
        rlf NREG1,w
        movwf NCTR1
        retlw 00

;**********************************************************************

LIN2    clrwdt          ;        LINEARISE 2 SUBROUTINE
        bcf STATUS,0    ; check if  40<BRG>80
        movlw .80
        subwf BRG2,w
        btfss STATUS,0
        goto FAST2
        movlw .40
        subwf BRG2,w
        btfss STATUS,0
        goto SLOW2

FAST2   movf NREG2,w     ; move N value (from NREG) into NCTR2
        movwf NCTR2
        retlw 00

SLOW2   clrc            ; clear carry and move 2N into NCTR2
        rlf NREG2,w
        movwf NCTR2
        retlw 00

;**********************************************************************

LIN3    clrwdt          ;        LINEARISE 3 SUBROUTINE
        bcf STATUS,0    ; check if  40<BRG>80
        movlw .80
        subwf BRG3,w
        btfss STATUS,0
        goto FAST3
        movlw .40
        subwf BRG3,w
        btfss STATUS,0
        goto SLOW3

FAST3   movf NREG3,w     ; move N value (from NREG) into NCTR3
        movwf NCTR3
        retlw 00

SLOW3   clrc            ; clear carry and move 2N into NCTR3
        rlf NREG3,w
        movwf NCTR3
        retlw 00

;**********************************************************************

INPUT   decfsz GPREG2,1 ;      INPUT SUBROUTINE
        retlw 00

        movlw .20
        movwf GPREG2

        btfss PORTB,0   ; is speed up pressed?
        goto IP1        ; no

        incf NREG1,1    ; yes
        incf NREG1,1

        movlw .34
        xorwf NREG1,w
        btfss STATUS,2  ; NREG1=34?
        goto IP2        ; no

        movlw .32       ; yes make NREG1=32
        movwf NREG1

IP2     nop
        movf NREG1,w   
        movwf NREG2
        movwf NREG3
        retlw 00

IP1     btfss PORTB,1   ; is speed up pressed?
        retlw 00        ; no

        decf NREG1,1    ; yes
        decf NREG1,1

        btfss STATUS,2  ; is zero flag set ie. NREG1=0
        goto IP2        ; no

        movlw 02h       ; yes - make NREG1=2
        movwf NREG1
        goto IP2

;**********************************************************************
START   call INTLSE

BEGIN   btfsc PORTA,3   ; is A3 low?
        goto LOOP1      ; no
        call PSET       ; yes

        call ZRX

        call INPUT
        call DELAY
        call DELAY

LOOP2   call DIMR
        btfss PORTA,3   ; is A3 high?
        goto LOOP2      ; no
        call PSET       ; yes

NCHGE   call ZRX

        call DELAY
        call DELAY

LOOP1   call DIMR
        goto BEGIN

;**********************************************************************
        org 000h
        END
