;MSCOP142.ASM 05FEB00 - JOHN BECKER - EPE MICRO PIC-SCOPE

;PIC16F876-20, 5MHz, WDT OFF, POR ON, XTAL HS

;Config register bits (all PIC TOOLKIT MK2 defaults except OS1/OS0)
; CP1 CP0 DBG NIL WRT CPD LVP BOR CP1 CP0 POR WDT OS1 OS0
;  1   1   1   1   1   1   0   0   1   1   0   0   1   0
;N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
;respectively - refer to PIC '87 data sheet.

#DEFINE PAGE0   BCF $03,5
#DEFINE PAGE1   BSF $03,5

INDF:    .EQU $00  ;page 0, 1, 2, 3
OPTION:  .EQU $01  ;page 1, 3
PCL:     .EQU $02  ;page 0, 1, 2, 3
STATUS:  .EQU $03  ;page 0, 1, 2, 3
FSR:     .EQU $04  ;page 0, 1, 2, 3

PORTA:   .EQU $05  ;page 0
TRISA:   .EQU $05  ;page 1
PORTB:   .EQU $06  ;page 0, 2
TRISB:   .EQU $06  ;page 1, 3
PORTC:   .EQU $07  ;page 0
TRISC:   .EQU $07  ;page 1

INTCON:  .EQU $0B  ;page 0, 1, 2, 3
ADRESH:  .EQU $1E  ;page 0

ADCON0:  .EQU $1F  ;page 0
ADCON1:  .EQU $1F  ;page 1

LOOPA:   .EQU $20        ;loop used by LCD send routine
LOOPB:   .EQU $21        ;general loop
STORE:   .EQU $22
STORE1:  .EQU $23
STORE2:  .EQU $24
RSLINE:  .EQU $25        ;LCD function flag store
CGVAL:   .EQU $27        ;val to be sent to character gen
MADDR:   .EQU $28        ;memory address store
SLOWIT:  .EQU $29        ;sample limit value
MARK1:   .EQU $2B        ;freq count polarity marker 1
MARK2:   .EQU $2C        ;freq count polarity marker 2

WORK1:  .EQU $30        ;working store 1
WORK2:  .EQU $31        ;working store 2
WORK3:  .EQU $32        ;working store 3
WORK4:  .EQU $33        ;working store 4
DEC1:   .EQU $34        ;decimalisation byte 1 & other uses
DEC2:   .EQU $35        ; byte 2
DEC3:   .EQU $36        ; byte 3
DEC4:   .EQU $37        ; byte 4
DEC5:   .EQU $38        ; byte 5
ANSA1:  .EQU $39        ;decimalisation answer store 1 & other uses
ANSA2:  .EQU $3A        ; answer 2
ANSA3:  .EQU $3B        ; answer 3
ANSA4:  .EQU $3C        ; answer 4
ANSA5:  .EQU $3D        ; answer 5
FRQCNT1: .EQU $3E       ;counter frequency lsb
FRQCNT2: .EQU $3F       ;counter frequency msb
FOSC:    .EQU $40       ;Fosc flag store

STORE3:  .EQU $41
POINT:   .EQU $42
LOOP:    .EQU $43
SWITCH:  .EQU $44
VOLTS:   .EQU $45       ;peak-peak voltage
MIN:     .EQU $46       ;min volts received
MAX:     .EQU $47       ;max volts received
MEMA0:   .EQU $48       ;ADC CHAR store 0
MEMA1:   .EQU $49       ;ADC CHAR store 1 - not called by name
MEMA2:   .EQU $4A       ;ADC CHAR store 2 - not called by name
MEMA3:   .EQU $4B       ;ADC CHAR store 3 - not called by name
MEMA4:   .EQU $4C       ;ADC CHAR store 4 - not called by name
MEMA5:   .EQU $4D       ;ADC CHAR store 5 - not called by name
MEMA6:   .EQU $4E       ;ADC CHAR store 6 - not called by name
MEMA7:   .EQU $4F       ;ADC CHAR store 7 - not called by name
CHRADD:  .EQU $50       ;character store address
PRVBIT:  .EQU $51       ;previous bit location for LCD plot routine
TIMOUT0: .EQU $52       ;timeout counter LSB
TIMOUT1: .EQU $53       ;timeout counter MSB

MEM0:    .EQU $58       ;start of memory for ADC samples
                        ;extends to $7F (max limit)

W:      .EQU 0
F:      .EQU 1
C:      .EQU 0
DC:     .EQU 1
Z:      .EQU 2

RP0:    .EQU 5           ;STATUS reg
RP1:    .EQU 6           ;STATUS reg
GIE:    .EQU 7           ;INTCON reg
GO:     .EQU 2           ;ADCON0 reg

        .ORG $0004      ;Interrupt vector address
        GOTO GIEOFF     ;Jump to interrupt routine on interrupt
        .ORG $0005      ;Start of program memory

GIEOFF: BCF INTCON,GIE  ;turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

TABLCD: addwf PCL,F     ;LCD initialisation table
        retlw %00110011 ;initialise lcd - first byte
        retlw %00110011 ;2nd byte (repeat of first)
        retlw %00110010 ;set for 4-bit operation
        retlw %00101100 ;set for 2 lines
        retlw %00000110 ;set entry mode to increment each address
        retlw %00001100 ;set display on, cursor off, blink off
        retlw %00000001 ;clear display
        retlw %00000010 ;return home, cursor & RAM to zero
                        ;end initialisation table

TBDEC1:                 ;table for decimalisation lsb
        addwf PCL,F     ;add program counter
        retlw $10       ;lsb of 10000
        retlw $E8       ;lsb of 1000
        retlw $64       ;lsb of 100
        retlw $0A       ;lsb of 10

TBDEC2:                 ;table for decimalisation msb
        addwf PCL,F     ;add program counter
        retlw $27       ;msb of 10000
        retlw $03       ;msb of 1000
        retlw 0         ;msb of 100
        retlw 0         ;msb of 10

FREQVAL: movf FOSC,W
        addwf PCL,F     ;table for freq factor routing
        goto GETFREQ0
        goto GETFREQ1
        goto GETFREQ2

;..............

START:  bcf STATUS,RP0
        bcf STATUS,RP1
        clrf PORTA
        clrf PORTB
        clrf PORTC
        PAGE1
        movlw %00001111     ;RA0-RA3 as inputs, RA4-RA5 as output
        movwf TRISA
        clrf TRISB          ;PORTB as output
        movlw 255
        movwf TRISC         ;PORTC as input
        movlw %00000100     ;set LHS justify, RA0, RA1, RA3 as analog inputs
        movwf ADCON1        ;with RA, RE digital, ref to +VE and 0V
        movlw %00000101     ;timer 1:64 (1/50th sec)
        movwf OPTION
        PAGE0

        movlw %01000001
        movwf ADCON0        ;set AD on, Fosc/8

        call PAUSIT
LCDSET: clrf LOOPB
        clrf RSLINE
LCDST2: movf LOOPB,W
        call TABLCD
        call LCDOUT
        incf LOOPB,F
        btfss LOOPB,3
        goto LCDST2
        call PAUSIT

        movlw %01000000  ;set address for CG RAM write to 0
        call LCDLIN
        bsf RSLINE,4

SEND0:  movlw 0             ;clear CGRAM
        call LCDOUT
        incf LOOPB,F
        btfss LOOPB,4
        goto SEND0

        call LCD1           ;set 1st 8 cells of screen for CGRAM use
        bsf RSLINE,4        :(character values 0-15)
        clrf LOOPB
SEND1:  movf LOOPB,W
        call LCDOUT
        incf LOOPB,F
        btfss LOOPB,3
        goto SEND1
        clrf LOOPB

SEND2:  movlw ' '           ;set next 8 cells to blank
        call LCDOUT
        incf LOOPB,F
        btfss LOOPB,3
        goto SEND2

        clrf MARK2
        clrf SWITCH
        call GETRATE

        bsf ADCON0,GO     ;start data conversion

;............................ END OF SETUP

MAIN:    movlw MEM0        ;set store address at MEM0
         movwf FSR
         btfss PORTC,1     ;is sync needed?
         goto WAITAD0      ;no
         clrf TIMOUT0      ;yes, clear timeout counters
         clrf TIMOUT1

;.........get sync

WAITS1:  btfsc ADCON0,GO
         goto WAITS1 
         movf ADRESH,W     ;get ADC val
         bsf ADCON0,GO     ;start data conversion for next sample
         decfsz TIMOUT0,F
         decfsz TIMOUT1,F
         goto WAITS1A
         goto WAITAD0
WAITS1A: addlw 114
         btfss STATUS,C
         goto WAITS1

WAITS2:  btfsc ADCON0,GO
         goto WAITS2 
         movlw 120
         subwf ADRESH,W    ;sub 120 from ADC val
         bsf ADCON0,GO     ;start data conversion for next sample
         decfsz TIMOUT0,F
         decfsz TIMOUT1,F
         goto WAITS2A
         goto WAITAD0
WAITS2A: btfsc STATUS,C
         goto WAITS2

WAITS3:  btfsc ADCON0,GO
         goto WAITS3 
         movf ADRESH,W     ;get ADC val
         bsf ADCON0,GO     ;start data conversion for next sample
         decfsz TIMOUT0,F
         decfsz TIMOUT1,F
         goto WAITS3A
         goto WAITAD0
WAITS3A: addlw 128
         btfss STATUS,C
         goto WAITS3

;......get data block


WAITAD0: btfsc ADCON0,GO
         goto WAITAD0

         movf ADRESH,W     ;get ADC val
         bsf ADCON0,GO     ;start data conversion for next sample
         movwf INDF        ;put it out to mem

         incf FSR,F        ;inc store address
         btfss FSR,7       ;is it > $7F?
         goto WAITAD0      ;no

         call FREQVAL      ;yes

         movlw MEM0
         movwf MADDR       ;set count to MEM0 address

         movlw %01000000  ;set address for CG RAM write to 0
         call LCDLIN
         bsf RSLINE,4

SEND3:   movlw 31         ;set first rotating val
         movwf STORE1
         movlw MEMA0
         movwf CHRADD

         call SENDCG      ;set up character gen new values
         movlw 5
         addwf MADDR,F
         btfss MADDR,7
         goto SEND3
         goto MAIN

;..........

SENDCG:  movf MADDR,W      ;set mem address
         movwf FSR         
         clrf CGVAL
         
         movf INDF,W       ;get mem val 1
         addwf STORE1,W    ;is it > STORE1 val?
         btfss STATUS,C
         goto CHK3
         bsf CGVAL,4
         clrf INDF

CHK3:    incf FSR,F
         movf INDF,W
         addwf STORE1,W
         btfss STATUS,C
         goto CHK2
         bsf CGVAL,3
         clrf INDF

CHK2:    incf FSR,F
         movf INDF,W
         addwf STORE1,W
         btfss STATUS,C
         goto CHK1
         bsf CGVAL,2
         clrf INDF

CHK1:    incf FSR,F
         movf INDF,W
         addwf STORE1,W
         btfss STATUS,C
         goto CHK0
         bsf CGVAL,1
         clrf INDF

CHK0:    incf FSR,F
         movf INDF,W
         addwf STORE1,W
         btfss STATUS,C
         goto CHKEND
         bsf CGVAL,0
         clrf INDF

CHKEND:  movf CHRADD,W
         movwf FSR
         movf CGVAL,W     ;no, get character gen character
         movwf INDF       ;temp store it at MEMA

         incf CHRADD,F
         movlw 32
         addwf STORE1,F   ;inc store val
         btfss STATUS,C
         goto SENDCG      ;repeat process for this batch of mem bytes

         movlw MEM0
         xorwf MADDR,W     ;is count = MEM0 address
         btfsc STATUS,Z
         call GETPRV

;.......Filler - this fills in gaps in display trace


FILLBIT: movlw MEMA0      ;check bit 4 for set position
         movwf FSR
         movlw 8
         movwf LOOP
FILL4A:  btfsc INDF,4
         goto FILL4B
         incf FSR,F
         decfsz LOOP,F
         goto FILL4A
         decf FSR,F
         bsf INDF,4

FILL4B:  movf FSR,W       ;store location of bit 4
         movwf STORE1
         movlw %00010000
         movwf STORE3
         call FILLER

         movf STORE1,W
         movwf PRVBIT

         movlw MEMA0      ;check bit 3 for set position
         movwf FSR
         movlw 8
         movwf LOOP
FILL3A:  btfsc INDF,3
         goto FILL3B
         incf FSR,F
         decfsz LOOP,F
         goto FILL3A
         decf FSR,F
         bsf INDF,3

FILL3B:  movf FSR,W       ;store location of bit 3
         movwf STORE1
         movlw %00001000
         movwf STORE3
         call FILLER

         movf STORE1,W
         movwf PRVBIT

         movlw MEMA0      ;check bit 2 for set position
         movwf FSR
         movlw 8
         movwf LOOP
FILL2A:  btfsc INDF,2
         goto FILL2B
         incf FSR,F
         decfsz LOOP,F
         goto FILL2A
         decf FSR,F
         bsf INDF,2

FILL2B:  movf FSR,W       ;store location of bit 2
         movwf STORE1
         movlw %00000100
         movwf STORE3
         call FILLER

         movf STORE1,W
         movwf PRVBIT

         movlw MEMA0      ;check bit 1 for set position
         movwf FSR
         movlw 8
         movwf LOOP
FILL1A:  btfsc INDF,1
         goto FILL1B
         incf FSR,F
         decfsz LOOP,F
         goto FILL1A
         decf FSR,F
         bsf INDF,1

FILL1B:  movf FSR,W       ;store location of bit 1
         movwf STORE1
         movlw %00000010
         movwf STORE3
         call FILLER

         movf STORE1,W
         movwf PRVBIT

         movlw MEMA0      ;check bit 0 for set position
         movwf FSR
         movlw 8
         movwf LOOP
FILL0A:  btfsc INDF,0
         goto FILL0B
         incf FSR,F
         decfsz LOOP,F
         goto FILL0A
         decf FSR,F
         bsf INDF,0

FILL0B:  movf FSR,W       ;store location of bit 0
         movwf STORE1
         movlw %00000001
         movwf STORE3
         call FILLER

         movf STORE1,W
         movwf PRVBIT

CHKIT2:  movlw 8
         movwf LOOPB
         movlw MEMA0
         movwf FSR

SENDF:  movf INDF,W
        call LCDOUT
        incf FSR,F
        decfsz LOOPB,F
        goto SENDF
        return

;.........

FILLER:  movf PRVBIT,W     ;sub PRVBIT from STORE1
         subwf STORE1,W
         btfsc STATUS,Z   ;is answer = 0? (both equal)
         return           ;yes
         movwf STORE2     ;no, store the answer
         btfss STATUS,C   ;is there a borrow?
         goto LESS        ;yes

MORE:    decf STORE2,W    ;is there a diff of only 1?
         btfsc STATUS,Z
         return           ;yes

         movf PRVBIT,W     ;no, so set missing bits
         movwf FSR
MORE2:   incf FSR,F
         movf STORE3,W    ;get bit value
         iorwf INDF,F     ;OR it with existing value

         movf FSR,W       ;is FSR address the same as that at STORE1?
         xorwf STORE1,W
         btfss STATUS,Z
         goto MORE2
         return           ;yes

LESS:    incf STORE2,W    ;is there a diff of only 1?
         btfsc STATUS,Z
         return           ;yes

         movf PRVBIT,W     ;no, so set missing bits
         movwf FSR
LESS2:   decf FSR,F
         movf STORE3,W    ;get bit value
         iorwf INDF,F     ;OR it with existing value

         movf FSR,W       ;is FSR address the same as that at STORE1?
         xorwf STORE1,W
         btfss STATUS,Z
         goto LESS2
         return           ;yes

;.........


GETPRV:  movlw MEMA0      ;get bit 4 for set position for PRVBIT
         movwf FSR
         movlw 8
         movwf LOOP
GPRVA:   btfsc INDF,4
         goto GPRVB
         incf FSR,F
         decfsz LOOP,F
         goto GPRVA
         decf FSR,F
         bsf INDF,4

GPRVB:   movf FSR,W       ;store location of bit 4
         movwf PRVBIT
         return

;.......Frequency

   ;Prototype values (LSB/MSB) set with freq gen at 4000Hz, counter at 4000Hz
   ;Fosc=0 ...70/85  Approx best max - Gen at 17007Hz counter showed 16984Hz
   ;Fosc=1 ...110/77 Approx best max - Gen at 17007Hz counter showed 16998Hz
   ;Fosc=2 ...128/24 Approx best max - Gen at 5827Hz counter showed 5812Hz

GETFREQ0: movlw 70         ;freq factor lsb ... for Fosc=0 ...70/85
         movwf STORE       ;sample counter lsb
         movlw 85          ;freq factor msb
         movwf STORE1      ;sample counter msb
         goto GF0

GETFREQ1: movlw 110        ;freq factor lsb ... for Fosc=1 ...110/77
         movwf STORE       ;sample counter lsb
         movlw 77          ;freq factor msb
         movwf STORE1      ;sample counter msb
         goto GF0

GETFREQ2: movlw 128        ;freq factor lsb ... for Fosc=2 ...128/24
         movwf STORE       ;sample counter lsb
         movlw 24          ;freq factor msb
         movwf STORE1      ;sample counter msb

GF0:     btfss PORTC,2
         goto CLEAR16

         bsf ADCON0,GO     ;start data conversion for next sample
         clrf FRQCNT1      ;freq counter lsb
         clrf FRQCNT2      ;freq counter msb

GF1:     btfsc ADCON0,GO
         goto GF1

         movf ADRESH,W     ;get ADC val
         movwf STORE2
         bsf ADCON0,GO     ;start data conversion for next sample
CHKPOS:  movlw 120         ;is ADC >136
         addwf STORE2,W
         btfss STATUS,C
         goto CPOS1
         bsf MARK2,0
         goto CHKNEG

CPOS1:   bcf MARK2,7       ;dummy action to maintain timing

CHKNEG:  movlw 136
         addwf STORE2,W
         btfsc STATUS,C
         goto CNEG1
         bcf MARK2,0
         goto MARKIT

CNEG1:   bcf MARK2,7       ;dummy action to maintain timing

MARKIT:  movf MARK2,W      ;compare MARK1 & 2, add result (1 or 0) to count
         xorwf MARK1,W
         addwf FRQCNT1,F
         movf STATUS,W
         andlw 1
         addwf FRQCNT2,F

GF4:     movf MARK2,W
         movwf MARK1
         decfsz STORE,F    ;dec counter
         goto GF1          
         decfsz STORE1,F   ;dec counter
         goto GF1          

GETVOLTS: movlw MEM0
         movwf FSR
         movlw 255
         movwf MIN
         clrf MAX

GV2:     movf INDF,W     ;is ADC < MIN ? (sub ADC from MIN)
         subwf MIN,W
         btfss STATUS,C    ;is there a borrow
         goto GV3          ;yes
         movf INDF,W
         movwf MIN
GV3:     movf MAX,W        ;is ADC > MAX ? (sub MAX from ADC)
         subwf INDF,W    
         btfss STATUS,C    ;is there a borrow
         goto GV4          ;no
         movf INDF,W
         movwf MAX
GV4:     incf FSR,F
         btfss FSR,7
         goto GV2

GV5:     movf MIN,W       ;sub MIN from MAX
         subwf MAX,W
         movwf VOLTS
         bsf POINT,0

         call LCD26
         bsf RSLINE,4
         movf VOLTS,W
         movwf ANSA1
         clrf ANSA2
         bcf STATUS,C
         rlf ANSA1,F      ;multiply by 2
         rlf ANSA2,F
         clrf ANSA3
         clrf ANSA4
         clrf ANSA5
         movlw ANSA1
         call PREPRP
         movlw 'V'
         call LCDOUT
         movlw 'p'
         call LCDOUT
         movlw '-'
         call LCDOUT
         movlw 'p'
         call LCDOUT

         clrf POINT
         call LCD21
         bsf RSLINE,4
         movf FRQCNT1,W
         movwf ANSA1
         movf FRQCNT2,W
         movwf ANSA2
         clrf ANSA3
         clrf ANSA4
         clrf ANSA5
         movlw ANSA1
         call PREPRP

         call LCD25
         bsf RSLINE,4
         movlw 'H'
         call LCDOUT
         movlw 'z'
         call LCDOUT
         movlw ' '
         call LCDOUT
         call TESTIT
         return

;........

CLEAR16: movlw 16
         movwf LOOP
         call LCD21
         bsf RSLINE,4
CL16:    movlw ' '
         call LCDOUT
         decfsz LOOP,F
         goto CL16
         call TESTIT
         return

;.............

PAUSIT: movlw 50
        movwf SLOWIT
        clrf INTCON
PAUSE:  btfss INTCON,2
        goto PAUSE
        BCF INTCON,2
        decfsz SLOWIT,F
        goto PAUSE
        return

LCD1:   movlw %10000000     ;LCD cell position codes - not all used
        goto LCDLIN
LCD9:   movlw %10001001
        goto LCDLIN

LCD21:  movlw %11000000
        goto LCDLIN
LCD24:  movlw %11000100
        goto LCDLIN
LCD25:  movlw %11000101
        goto LCDLIN
LCD26:  movlw %11000110
        goto LCDLIN

LCD28:  movlw %11001000
        goto LCDLIN
LCD29:  movlw %11001001
        goto LCDLIN

LCDLIN: BCF RSLINE,4

LCDOUT: movwf STORE
        movlw 50
        movwf LOOPA
DELAY:  decfsz LOOPA,F
        goto DELAY
        call SENDIT
SENDIT: swapf STORE,F
        movf STORE,W
        andlw 15
        iorwf RSLINE,W
        movwf PORTB
        BSF PORTB,5
        BCF PORTB,5
        RETURN

;..............convert binary to hex - not used in final model

LCDHEX: movwf STORE2    ;split & format decimal byte as HEX for LCD
        swapf STORE2,W  ;get tens nibble
        andlw 15
        movwf STORE1
        addlw 6
        btfss STATUS,DC
        goto HEX2
        movf STORE1,W
        addlw 55        ;set as alpha
        goto HEX3
HEX2:   movf STORE1,W
        iorlw 48        ;set as numeral
HEX3:   call LCDOUT     ;send it
        movf STORE2,W   ;get units
        andlw 15
        movwf STORE1
        addlw 6
        btfss STATUS,DC
        goto HEX4
        movf STORE1,W
        addlw 55        ;set as alpha
        goto HEX5
HEX4:   movf STORE1,W
        iorlw 48        ;set as numeral
HEX5:   call LCDOUT
        call PAUSIT
        return

;........... used to convert binary bytes to decimal for LCD

DECIML:                 ;decimalise binary number
                        ;copy source into working area
                        ;source address is brought in on W
                        ;DEC1-5 becomes source
                        ;answer goes into ANSA
        call COPYFD     ;copy data at FSR into DEC
        clrf STORE1
        clrf LOOPA
        call CLRANS

        movlw ANSA4     ;set answer store address
        movwf FSR

DCML0:  movf LOOPA,W
        call TBDEC1     ;subtract lsb from source value
        subwf DEC1,F
        btfsc STATUS,C  ;is there a borrow?
        goto DCML1      ;no
        movlw 1
        subwf DEC2,F    ;yes so decrement next byte
        btfsc STATUS,C  ;is there a borrow?
        goto DCML1      ;no
        movlw 1         ;yes
        subwf DEC3,F
        btfsc STATUS,C  ;is there a borrow?
        goto DCML1      ;no

DCML3:  movf LOOPA,W    ;yes, so re-add last table values lsb
        call TBDEC1
        addwf DEC1,F
        btfss STATUS,C  ;is there a carry?
        goto DCML5      ;no so exit loop
        incf DEC2,F     ;yes so inc next byte
        btfss STATUS,Z  ;is there a carry? (is it zero)
        goto DCML5      ;no so exit loop
        incf DEC3,F     ;yes
        goto DCML5      ;exit loop

DCML1:  movf LOOPA,W
        call TBDEC2     ;subtract msb from source value
        subwf DEC2,F
        btfsc STATUS,C  ;is there a borrow?
        goto DCML2      ;no
        movlw 1
        subwf DEC3,F    ;yes so decrement next byte
        btfss STATUS,C  ;is there a borrow?
        goto DCML4      ;yes

DCML2:  incfsz STORE1,F ;inc counter & continue looping till zero
        goto DCML0

DCML4:  movf LOOPA,W    ;re-add last table values lsb
        call TBDEC1
        addwf DEC1,F
        btfss STATUS,C  ;is there a carry?
        goto DCML4A     ;no so add msb
        incf DEC2,F     ;yes so inc next byte
        btfsc STATUS,Z  ;is there a carry? (is it zero)
        incf DEC3,F     ;yes, so inc next byte

DCML4A: movf LOOPA,W    ;re-add last table values msb
        call TBDEC2
        addwf DEC2,F
        btfsc STATUS,C  ;is there a carry?
        incf DEC3,F     ;yes, so inc next byte

DCML5:  movf STORE1,W   ;store counter and loop for next values
        movwf INDF
        clrf STORE1
        decf FSR,F
        incf LOOPA,F
        btfss LOOPA,2   ;is it = 4?
        goto DCML0      ;no

DCML6:  movlw 15        ;compact answers into 3 bytes
        andwf ANSA1,F
        andwf ANSA2,F
        andwf ANSA3,F
        swapf ANSA1,F
        movf DEC1,W
        iorwf ANSA1,F
        swapf ANSA3,W
        iorwf ANSA2,F
        movf ANSA4,W
        movwf ANSA3
        movlw 6
        addwf ANSA3,W
        btfsc STATUS,DC
        movwf ANSA3
        return

COPYFD: movwf FSR       ;copy data at FSR to DEC - 3 bytes
        movf INDF,W     ;DO NOT CALL CLRDEC with this
        movwf DEC1      ;for reasons unknown it does not work then!
        incf FSR,F
        movf INDF,W
        movwf DEC2
        incf FSR,F
        movf INDF,W
        movwf DEC3
        clrf DEC4
        clrf DEC5
        return

CLRANS: clrf ANSA1
        clrf ANSA2
        clrf ANSA3
        clrf ANSA4
        clrf ANSA5
        return

PREPRP: call DECIML     ;convert to decimal. Answer in ANSA
        movlw ANSA1
        call PRPSHW
        goto SCREEN

PRPSHW: movwf FSR       ;prepare dual BCD data for single byte showing
        movwf STORE1
        movlw WORK2
        movwf STORE2
        movlw 3
        movwf LOOPA

PREP2:  movf STORE1,W
        movwf FSR
        movf INDF,W
        movwf STORE3
        movf STORE2,W
        movwf FSR
        movf STORE3,W
        andlw 15
        iorlw 48        ;OR decimal 48
        movwf INDF
        incf STORE2,F
        incf FSR,F
        swapf STORE3,W
        andlw 15
        iorlw 48        ;OR decimal 48
        movwf INDF
        incf STORE2,F
        incf STORE1,F
        decfsz LOOPA,F
        goto PREP2

        btfsc POINT,0   ;is decimal point needed?
        goto PREP31     ;yes
        movlw 32
        movwf WORK1
        goto PREP3      ;no
PREP31: movf WORK2,W
        movwf WORK1
        movf WORK3,W
        movwf WORK2
        movlw 46        ;decimal point
        movwf WORK3

PREP3:  movlw 128
        btfss POINT,0
        movlw ' ' 
        movwf STORE1
        btfss STORE1,7  ;is it 128?
        movwf DEC3
        movlw ' '
        movwf DEC4
        return

SCREEN: movlw 6          ;...8
        movwf LOOP
        movlw WORK1
        addlw 5          ;...7
        movwf FSR

SCRN2:  movf INDF,W
        call LCDOUT
        decf FSR,F
        decfsz LOOP,F
        goto SCRN2
        return

CLRWRK: clrf WORK1
        clrf WORK2
        clrf WORK3
        clrf WORK4
        return

CLRDEC: clrf DEC1
        clrf DEC2
        clrf DEC3
        clrf DEC4
        clrf DEC5
        return

;.........switch 

TESTIT: btfsc PORTC,0   ;test bit 0 of Port C, is it clear?
        goto TSTPRV     ;no, it's = 1 so go to TSTPRV
        bcf SWITCH,0    ;clear bit 0 of SWITCH
        return          ;return
TSTPRV: btfsc SWITCH,0  ;test bit 0 of SWITCH, is it clear?
        return          ;no, it's = 1 so return
        movlw %01000000
        addwf ADCON0,F   ;yes, it's = 0 so inc count
        movf ADCON0,W    ;get COUNT
        andlw %11000000
        xorlw %11000000
        btfss STATUS,Z
        goto TP2
        bcf ADCON0,6
        bcf ADCON0,7

TP2:    bsf SWITCH,0    ;set bit 0 of SWITCH

GETRATE: swapf ADCON0,W
         andlw %00001100
         movwf FOSC
         bcf STATUS,C 
         rrf FOSC,F
         rrf FOSC,F

         call LCD9
         bsf RSLINE,4
         movlw ' '
         call LCDOUT
         movlw 'R'
         call LCDOUT
         movlw 'A'
         call LCDOUT
         movlw 'T'
         call LCDOUT
         movlw 'E'
         call LCDOUT
         movlw ' '
         call LCDOUT

         movf FOSC,W
         iorlw 48
         call LCDOUT
         return

         .END

