;Sixteen channel 2-wire transmitter IC2
;For PIC16F84
;A.J.Flind, 4/4/99
;xtal 4MHz
;Watchdog timer ON
;Startup timer ON

#DEFINE page0 BCF status,5              
#DEFINE page1 BSF status,5              
		
status:   .EQU $03        ;general equates
portA:    .EQU $05        
trisA:    .EQU $05        
portB:    .EQU $06        
trisB:    .EQU $06        
pcl:      .EQU $02        
rtcc:     .EQU $01        
option:   .EQU $01        
intcon:   .EQU $0B        
f:        .EQU $01        
w:        .EQU $00        
z:        .EQU $02        
c:        .EQU $00                



count:    .EQU $0C        ;program specific equates
dcount:   .EQU $0D
sw1:      .EQU $0E
sw2:      .EQU $0F
dcount2:  .EQU $10

	.org $0004      ;interrupt vector
	.org $0005      ;start of program
	
start:	page1               
	movlw 255
	movwf trisA         ;RA0-4 input
	movwf trisB         ;RB0-7 input
	movlw %01111111
	movwf option        ;pull-ups on, watchdog set up
	page0
;==============================================          
rpta:	clrwdt
	clrf sw1
	btfsc portA,2       ;RA2 pulsed low by IC1?
	goto rpta           ;no, continue looking
	movf portB,w        ;yes, get switch states
	movwf sw1           ;place in file sw1
rptb:	btfss portA,2       ;wait for RA2 to return high
	goto rptb
	page1               ;make RA2 an output
	bcf trisA,2
	page0
	bsf portA,2         ;and set it high
	btfss sw1,0         ;was the first switch on (low)?
	bcf portA,2         ;if yes, set RA2 low
	call dly97          ;wait 100 uS
	bsf portA,2         ;set RA2 high again
	btfss sw1,1         ;repeat for remaining 7 bits of sw1
	bcf portA,2
	call dly97
	bsf portA,2
	btfss sw1,2
	bcf portA,2
	call dly97
	bsf portA,2
	btfss sw1,3
	bcf portA,2
	call dly97
	bsf portA,2
	btfss sw1,4
	bcf portA,2
	call dly97
	bsf portA,2
	btfss sw1,5
	bcf portA,2
	call dly97
	bsf portA,2
	btfss sw1,6
	bcf portA,2
	call dly97
	bsf portA,2
	btfss sw1,7
	bcf portA,2
	call dly97
	
	page1               ;return RA2 to input
	bsf trisA,2
	page0
	
	goto start          ;and do it all again
;============================================== 
dly97:	movlw 30            ;used by IC2 when sending to IC1
	movwf dcount
d97a:	decfsz dcount,f
	goto d97a
	nop
	nop
	return
;==============================================          
	.END

