;Moodloop Frequency Generator
;Andy Flind 1/12/99
;For PIC16F84 or PIC16C84
;For 4.00MHz xtal
;Configuration:
;Oscillator: XT
;Watchdog timer: NO
;Power-up timer: YES

#DEFINE page0 BCF status,5
#DEFINE page1 BSF status,5
		
status:   .EQU $03  ;general equates
portA:    .EQU $05
trisA:    .EQU $05
portB:    .EQU $06
trisB:    .EQU $06
pcl:      .EQU $02
rtcc:     .EQU $01
option:   .EQU $01
intcon:   .EQU $0B
f:        .EQU $01
w:        .EQU $00
z:        .EQU $02

ctr0:     .EQU $0C  ;program specific equates
ctr1:     .EQU $0D
ptr:      .EQU $0E
freq:     .EQU $1F

	.org $0004          ;interrupt vector
	.org $0005          ;start of program

	goto start
;=====================================================
dlytbl: addwf pcl,f
	goto dly0
	goto dly1
	goto dly2
	goto dly3
	goto dly4
	goto dly5
	goto dly6
	goto dly7
	goto dly8
	goto dly9
	goto dly10
	goto dly11
	goto dly12
	goto dly13
	goto dly14
	goto dly15
;=====================================================
start:  clrf portA          ;initialise for operation
	clrf portB
	page1
	movlw %11111111
	movwf trisA         ;portA all input
	clrf trisB          ;portB all output
	page0
	clrf portA
	clrf portB
;=====================================================
	comf portA,w                  ;get the switch pattern
	andlw 15            ;check validity
	movwf ptr           ;put it into ptr
;=====================================================
cycle:  bsf portB,0         ;output sequence step 1
	comf portA,w
	andlw 15
	xorwf ptr,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl

	nop                 ;output sequence step 2
	nop                 ;2 nops compensate for
	bsf portB,1         ;the "return" before step 1
	comf portA,w
	andlw 15
	xorwf ptr,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	nop                 ;output sequence step 3
	nop                 
	bsf portB,2         
	comf portA,w
	andlw 15
	xorwf ptr,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	nop                 ;output sequence step 4
	nop                 
	bsf portB,3         
	comf portA,w
	andlw 15
	xorwf ptr,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	nop                 ;output sequence step 5
	nop                 
	bsf portB,4         
	comf portA,w
	andlw 15
	xorwf ptr,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	nop                 ;output sequence step 6
	nop                 
	bsf portB,5         
	comf portA,w
	andlw 15
	xorwf ptr,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	nop                 ;output sequence step 7
	nop                 
	bsf portB,6         
	comf portA,w
	andlw 15
	xorwf ptr,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	nop                 ;output sequence step 8
	nop                 
	bsf portB,7         
	comf portA,w
	andlw 15
	xorwf ptr,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	nop                 ;output sequence step 9
	nop
	bcf portB,7         
	comf portA,w
	andlw 15
	xorwf ptr,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl

	nop                 ;output sequence step 10
	nop                 
	bcf portB,6         
	comf portA,w
	andlw 15
	xorwf ptr,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	nop                 ;output sequence step 11
	nop                 
	bcf portB,5         
	comf portA,w
	andlw 15
	xorwf ptr,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	nop                 ;output sequence step 12
	nop                 
	bcf portB,4         
	comf portA,w
	andlw 15
	xorwf ptr,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	nop                 ;output sequence step 13
	nop                 
	bcf portB,3         
	comf portA,w
	andlw 15
	xorwf ptr,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	nop                 ;output sequence step 14
	nop                 
	bcf portB,2         
	comf portA,w
	andlw 15
	xorwf ptr,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	nop                 ;output sequence step 15
	nop                 
	bcf portB,1         
	comf portA,w
	andlw 15
	xorwf ptr,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	nop                 ;output sequence step 16
	nop                 
	bcf portB,0         
	comf portA,w
	andlw 15
	xorwf ptr,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	goto cycle          ;and do sequence again
;=====================================================
dly0:   movlw 176   ;1st frequency
	movwf ctr1
t0a:    movlw 117
	movwf ctr0
t0:     decfsz ctr0,f
	goto t0
	decfsz ctr1,f
	goto t0a
	nop
	nop
	nop
	return     ;for 1.0Hz
;=====================================================
dly1:   movlw 57   ;2nd frequency
	movwf ctr1
t1a:    movlw 227
	movwf ctr0
t1:     decfsz ctr0,f
	goto t1
	decfsz ctr1,f
	goto t1a
	nop
	return     ;for 1.6Hz
;=====================================================
dly2:   movlw 78   ;3rd frequency
	movwf ctr1
t2a:    movlw 120
	movwf ctr0
t2:     decfsz ctr0,f
	goto t2
	decfsz ctr1,f
	goto t2a
	return     ;for 2.2Hz
;=====================================================
dly3:   movlw 48   ;4th frequency
	movwf ctr1
t3a:    movlw 95
	movwf ctr0
t3:     decfsz ctr0,f
	goto t3
	decfsz ctr1,f
	goto t3a
	return     ;for 4.5Hz
;=====================================================
dly4:     movlw 186   ;5th frequency
	movwf ctr1
t4a:      movlw 19
	movwf ctr0
t4:       decfsz ctr0,f
	goto t4
	decfsz ctr1,f
	goto t4a
	nop
	return     ;for 5.5Hz
;=====================================================
dly5:     movlw 21   ;6th frequency
	movwf ctr1
t5a:      movlw 151
	movwf ctr0
t5:       decfsz ctr0,f
	goto t5
	decfsz ctr1,f
	goto t5a
	nop
	return     ;for 6.5Hz
;=====================================================
dly6:     movlw 27   ;7th frequency
	movwf ctr1
t6a:      movlw 97
	movwf ctr0
t6:       decfsz ctr0,f
	goto t6
	decfsz ctr1,f
	goto t6a
	return     ;for 7.83Hz (schumann res.)
;=====================================================
dly7:     movlw 23    ;8th frequency
	movwf ctr1
t7a:      movlw 89
	movwf ctr0
t7:       decfsz ctr0,f
	goto t7
	decfsz ctr1,f
	goto t7a
	return     ;for 10.0Hz
;=====================================================
dly8:     movlw 149    ;9th frequency
	movwf ctr1
t8a:      movlw 11
	movwf ctr0
t8:       decfsz ctr0,f
	goto t8
	decfsz ctr1,f
	goto t8a
	nop
	return     ;for 11.3Hz
;=====================================================
dly9:     movlw 33    ;10th frequency
	movwf ctr1
t9a:      movlw 49
	movwf ctr0
t9:       decfsz ctr0,f
	goto t9
	decfsz ctr1,f
	goto t9a
	return     ;for 12.5Hz
;=====================================================
dly10:    movlw 21    ;11th frequency
	movwf ctr1
t10a:     movlw 48
	movwf ctr0
t10:      decfsz ctr0,f
	goto t10
	decfsz ctr1,f
	goto t10a
	return     ;for 20.0Hz
;=====================================================
dly11:    movlw 4    ;12th frequency
	movwf ctr1
t11a:     movlw 234
	movwf ctr0
t11:      decfsz ctr0,f
	goto t11
	decfsz ctr1,f
	goto t11a
	return     ;for 22.0Hz
;=====================================================
dly12:    movlw 209    ;13th frequency (test)
	movwf ctr1
t12a:     movlw 198
	movwf ctr0
t12:      decfsz ctr0,f
	goto t12
	decfsz ctr1,f
	goto t12a
	nop
	return     ;for 0.5Hz
;=====================================================
dly13:  movlw 14    ;14th frequency (test)
	movwf ctr1
t13a:   movlw 28
	movwf ctr0
t13:    decfsz ctr0,f
	goto t13
	decfsz ctr1,f
	goto t13a
	nop
	return     ;for 50.0Hz
;=====================================================
dly14:    movlw 255 ;15th frequency (test, all high)
	movwf portB
	comf portA,w
	andlw 15
	xorwf ptr,w
	btfsc status,z
	goto dly14          ;repeat until switches change
	return
;=====================================================   
dly15:    clrf portB   ;16th frequency (test, all low)
	comf portA,w
	andlw 15
	xorwf ptr,w
	btfsc status,z
	goto dly15          ;repeat until switches change
	return
;=====================================================
	
	.END


