;MoodPICker
;Andy Flind 19/3/99
;For PIC16F84 or PIC16C84
;For 32.768kHz xtal
;Configuration:
;Oscillator: LP
;Watchdog timer: NO
;Power-up timer: YES

#DEFINE page0 BCF status,5
#DEFINE page1 BSF status,5
		
status:	.EQU $03	;general equates
portA:	.EQU $05
trisA:	.EQU $05
portB:	.EQU $06
trisB:	.EQU $06
pcl:	.EQU $02
rtcc:	.EQU $01
option:	.EQU $01
intcon:	.EQU $0B
f:	.EQU $01
w:	.EQU $00
z:	.EQU $02

ctr0:	.EQU $0C	;program specific equates
ctr1:	.EQU $0D
ptr:	.EQU $0E
last:	.EQU $1F

	.org $0004	;interrupt vector
	.org $0005	;start of program

	goto start
;=====================================================
dlytbl:	addwf pcl,f
	goto dly0
	goto dly1
	goto dly2
	goto dly3
	goto dly4
	goto dly5
	goto dly6
	goto dly7
	goto dly8
	goto dly9
	goto dly10
	goto dly11
	goto dly12
	goto dly13
	goto dly14
	goto dly15
;=====================================================
start:	clrf portA
	clrf portB
	page1
	movlw %11111110
	movwf trisA	;portA 0 output, rest input
	clrf trisB	;portB all output
	page0
;=====================================================
	bsf portA,0	;turn on battery LED
	nop
	nop	;precaution against spurious clock
	movlw 75	;delay 2 seconds
	movwf ctr0
loop0:	movwf ctr1
loop1:	decfsz ctr1,f
	goto loop1
	decfsz ctr0,f
	goto loop 0
	bcf portA,0	;turn off battery LED
	nop
	nop	;precaution against spurious clock
	movf portA,w	;get the new switch pattern
	andlw %00011110	;exclude incorrect bits
	movwf last	;move it into "last" file
	rrf last,w	;adjust to ptr value (in w)
	andlw %00001111	;exclude incorrect bits
	movwf ptr	;put it into ptr
;=====================================================
cycle:	bsf portB,0	;main output sequence
	movf portA,w
	xorwf last,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	bsf portB,1
	movf portA,w
	xorwf last,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	bsf portB,2
	movf portA,w
	xorwf last,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	bsf portB,3
	movf portA,w
	xorwf last,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	bsf portB,4
	movf portA,w
	xorwf last,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	bsf portB,5
	movf portA,w
	xorwf last,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	bsf portB,6
	movf portA,w
	xorwf last,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	bsf portB,7	;all on for 2 periods
	movf portA,w
	xorwf last,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	nop
	movf portA,w
	xorwf last,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	bcf portB,0
	movf portA,w
	xorwf last,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	bcf portB,1
	movf portA,w
	xorwf last,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	bcf portB,2
	movf portA,w
	xorwf last,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	bcf portB,3
	movf portA,w
	xorwf last,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	bcf portB,4
	movf portA,w
	xorwf last,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	bcf portB,5
	movf portA,w
	xorwf last,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	bcf portB,6
	movf portA,w
	xorwf last,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	
	bcf portB,7	;all off for 2 periods
	movf portA,w
	xorwf last,w
	btfss status,z
	goto start
	movf ptr,w
	call dlytbl
	nop
	nop
	nop
	movf ptr,w
	call dlytbl
	goto cycle	;and do sequence again
;=====================================================
dly0:	movlw 96	;16 delays, one for each setting
	movwf ctr0
t0:	decfsz ctr0,f
	goto t0
	return	;for 1.5Hz
;=====================================================
dly1:	movlw 64
	movwf ctr0
t1:	decfsz ctr0,f
	goto t1
	return	;for 2.2Hz
;=====================================================
dly2:	movlw 45
	movwf ctr0
t2:	decfsz ctr0,f
	goto t2
	nop
	nop
	return	;for 2.99Hz
;=====================================================
dly3:	movlw 33
	movwf ctr0
t3:	decfsz ctr0,f
	goto t3
	return	;for 3.99Hz
;=====================================================
dly4:	movlw 28
	movwf ctr0
t4:	decfsz ctr0,f
	goto t4
	return	;for 4.6Hz
;=====================================================
dly5:	movlw 24
	movwf ctr0
t5:	decfsz ctr0,f
	goto t5
	nop
	return	;for 5.17Hz
;=====================================================
dly6:	movlw 20
	movwf ctr0
t6:	decfsz ctr0,f
	goto t6
	nop
	return	;for 5.99Hz
;=====================================================
dly7:	movlw 14
	movwf ctr0
t7:	decfsz ctr0,f
	goto t7
	nop
	return	;for 7.85Hz (Schumman res.)
;=====================================================
dly8:	movlw 12
	movwf ctr0
t8:	decfsz ctr0,f
	goto t8
	return	;for 8.92Hz
;=====================================================
dly9:	movlw 10
	movwf ctr0
t9:	decfsz ctr0,f
	goto t9
	return	;for 10.11Hz
;=====================================================
dly10:	movlw 8
	movwf ctr0
t10:	decfsz ctr0,f
	goto t10
	nop
	nop
	return	;for 11.1Hz
;=====================================================
dly11:	movlw 7
	movwf ctr0
t11:	decfsz ctr0,f
	goto t11
	nop
	nop
	return	;for 11.98Hz
;=====================================================
dly12:	movlw 6
	movwf ctr0
t12:	decfsz ctr0,f
	goto t12
	nop
	nop
	return	;for 13.0Hz
;=====================================================
dly13:	movlw 3
	movwf ctr0
t13:	decfsz ctr0,f
	goto t13
	return	;for 18.96Hz
;=====================================================
dly14:	movlw 2
	movwf ctr0
t14:	decfsz ctr0,f
	goto t14
	nop
	return	;for 20.69Hz
;=====================================================
dly15:	movlw 2
	movwf ctr0
t15:	decfsz ctr0,f
	goto t15
	return	;for 21.67Hz
;=====================================================
	
	.END

