;WRITTEN BY JIM MAIN
;VER 1.00

	TITLE "MICROPROBE"
	LIST P=16F84

	INCLUDE P16F84.INC



;=========================================================================
;			PORT DESCRIPTION
;=========================================================================
;
;THE PORTS ARE:-
;
;PORTA[0] 	O/P
;PORTA[1] 	O/P
;PORTA[2] 	O/P   - UNUSED
;PORTA[3]	O/P   - UNUSED 
;PORTA[4]	I/P   -	PROBE INPUT

INPUTPIN	EQU	04

;
;PORTB		O/P   - OUTPUTS TO 4 BI-COLOUR LEDS



;======================	END OF PORTS DESCRIPTION =========================
;


;
;====================== ADDITIONAL EQUATES ===============================
;
OLD_LEVEL	EQU	0X0C
NEW_LEVEL	EQU	0X0D
LED_REG		EQU	0X0E
DATA_IN		EQU	0X0F



	ORG	00
	GOTO	INIT


;==========================================================================
;	START OF ACTIVE CODE FOLLOWS FROM HERE...
;==========================================================================

	ORG	05


;==========================================================================
;	SUBROUTINES
;==========================================================================

DELAY6_4
	GOTO	$+1		;OVERALL 6.4uS DELAY INCLUDING THE CALL AND RETURN INSTRUCTIONS
	GOTO	$+1
	GOTO	$+1		
	GOTO	$+1
	GOTO	$+1
	GOTO	$+1
	RETURN


INIT

	CLRF	PORTA
	CLRF	PORTB

	BSF	STATUS,RP0		;SELECT BANK 1
	MOVLW	B'00010000'
	MOVWF	TRISA			;MAKE PA4 AN INPUT - ALL OTHERS OUTPUTS
		
	CLRW
	MOVWF	TRISB			;PORTB ALL OUTPUTS


	MOVLW	B'10001111'
	MOVWF	OPTION_REG		;SET WDT  PRESCALE= 1:128 & PORTB PULLUPS OFF

	BCF	STATUS,RP0		;SELECT BANK 0

	CLRF	INTCON

	CLRF	DATA_IN
	CLRF	LED_REG

	CLRW
	BTFSC	PORTA,INPUTPIN
	MOVLW	01
	MOVWF	NEW_LEVEL

	BSF	PORTA,1
	BCF	PORTA,1

;==========================================================================
;	MAIN LOOP OF PROGRAM FOLLOWS
;==========================================================================
LEVEL_UPDATE
	MOVF	NEW_LEVEL,W
	MOVWF	OLD_LEVEL

PROG_LOOP 
	CLRW
	BTFSC	PORTA,INPUTPIN
	MOVLW	01
	MOVWF	NEW_LEVEL
	XORWF	OLD_LEVEL,W
	SKPNZ				;HAS THE LEVEL CHANGED SINCE THE LAST SAMPLE?
	GOTO	LEVEL_UPDATE		;NO, SO LOOP BACK		
SYNC1
	BTFSC	PORTA,INPUTPIN		;IS THE PIN CURRENTLY HIGH?
	GOTO	SYNC2			;YES, SO LOOK AT THE NEXT BIT AFTER 8uS DELAY
	CALL	DELAY6_4		;NO, SO WAIT 8uS & TRY AGAIN
	GOTO	$+1
	BTFSS	PORTA,INPUTPIN		;IS IT HIGH NOW?
	GOTO	LEVEL_UPDATE		;NO, SO BACK TO THE TOP
	NOP
SYNC2
	CALL	DELAY6_4
	NOP
	BTFSC	PORTA,INPUTPIN		;IS THE SECOND BIT=0?
	GOTO	LEVEL_UPDATE		;NO, SO LOOP BACK
SYNC3
	CALL	DELAY6_4
	GOTO	$+1
	BTFSS	PORTA,INPUTPIN		;IS THE THIRD BIT=1?
	GOTO	LEVEL_UPDATE		;NO, SO LOOP BACK

DATA_SECTION
	CLRF	DATA_IN
	CALL	DELAY6_4
	BCF	DATA_IN,2
	BTFSC	PORTA,INPUTPIN
	BSF	DATA_IN,2

	CALL	DELAY6_4
	NOP
	BCF	DATA_IN,1
	BTFSC	PORTA,INPUTPIN
	BSF	DATA_IN,1

	CALL	DELAY6_4
	NOP
	BCF	DATA_IN,0
	BTFSC	PORTA,INPUTPIN
	BSF	DATA_IN,0
	
PROCESS_DATA
	CLRF	PCLATH

	RLF	DATA_IN,F		;MULTIPLY THE DATA BY 4
	RLF	DATA_IN,W		;


	ADDWF	PCL,F			;THEN MAKE A COMPUTED GOTO
	
	BSF	LED_REG,0		;DATA_IN = 0
	NOP
	BCF	LED_REG,1
	GOTO	LED_EXIT

	BCF	LED_REG,0		;DATA_IN = 4
	NOP
	BSF	LED_REG,1
	GOTO	LED_EXIT

	BSF	LED_REG,2		;DATA_IN = 8
	NOP
	BCF	LED_REG,3
	GOTO	LED_EXIT

	BCF	LED_REG,2		;DATA_IN = 12
	NOP
	BSF	LED_REG,3
	GOTO	LED_EXIT

	BSF	LED_REG,4		;DATA_IN = 16
	NOP
	BCF	LED_REG,5
	GOTO	LED_EXIT

	BCF	LED_REG,4		;DATA_IN = 20
	NOP
	BSF	LED_REG,5
	GOTO	LED_EXIT

	BSF	LED_REG,6		;DATA_IN = 24
	NOP
	BCF	LED_REG,7
	GOTO	LED_EXIT

	BCF	LED_REG,6		;DATA_IN = 28
	NOP
	BSF	LED_REG,7

LED_EXIT
	MOVF	LED_REG,W		;LOAD THE LED REGISTER TO PORTB TO
	MOVWF	PORTB			;LIGHT THE LED's

	GOTO	PROG_LOOP		;AND LOOP BACK TO THE HEAD

	END
