;****************************************
; written by:Andrew Buckmaster          *
; date:13/10/96                         *
; version:1.2 with easy start, double start,
;  final version			*
; file called:c:\bucko\programs\Wiz4.asm*
; for PIC:16C54                         *
; clock frequency:2.4576MHz             *
; function:to moniter water flow        *
;****************************************

	
	list    P=16C54
        include "c:\mplab\p16c5x.inc"

;===============
; Declarations :
;===============

	porta           equ     05              ;
	portb           equ     06              ;
							
	TMRValue        equ     08              ; for counting to one litre
	units           equ     09              ; counts the units
	tens            equ     0A              ; counts the tens
	toggle2         equ     0B              ; same as wait above

	General         equ     0C              ; general file register 
	
	LEDCount        equ     0D              ; LED file registers
	Times10Count    equ     0E              ;
	
	BuzzCount       equ     0F              ; Buzzer file registers
	_25             equ     10              ;

	OnCheckPres1    equ     11              ; Prescalers for pulse  
	OnCheckPres2    equ     12              ; checking
	OnCheckPres3	equ	13		;

	temp            equ     14              ; Comparing file registers
	temp2           equ     15              ;

	BuzzPres1       equ     16              ; buzzer prescalers
	BuzzPres2       equ     17              ;
        BuzzPres3	equ	1D		;

	total           equ     18              ;
	CountPres       equ     19
	FinishCount     equ     1A
	
	bathcount	equ	1B
	FlashPres	equ	1C

	LEDmove		equ	1E
        LEDchanger	equ	1F
;==================
; Bit assignments :
;==================
	
#define         buzz    porta, 3        ;
#define         digit   0C, 0           ; 1 = ones digit, 0 = tens digit        
#define         buzzon  0C, 1           ; 1 = carry out buzzer subroutine
					;  0 = don't
#define		toggle   0C, 2 		; 1 = carry out long sleep
#define		Onoroff  0C,4		;  0 = test for pulses
#define		firstime 0C, 3	
#define		overbath 0C, 5		; 1= run second program, 0= normal
#define		longbuzz 0C,6		; 1=runs long buzzer, 0= don't
#define		buzztog	 0C,7		; 1=top LED,0=bottom
	
	org     0x1FF                   ;

	goto    start                   ;
	org     0                       ;

;======================================================================
;======================================================================
; Subroutines :
;==============
;======================================================================
Display
;======
	btfss           digit           ; which digit is currently on?
	b               Digit1          ;
	b               Digit10
Digit1  
	bsf             digit           ; next time tens digit
	movfw           tens            ; moves units into working reg
	call            _7seg_units      ; calls _7seg_units
	movwf           portb           ; puts the number into portb
	retlw           0
Digit10 
	bcf             digit           ; next time units digit
	movfw           units           ; moves tens into working reg
	call            _7seg_tens      ; calls _7seg_tens
	movwf           portb           ; moves the number into portb   
	retlw           0               

_7seg_units
	andlw           0x0F            ;       
	addwf           PCL             ;
	retlw           b'00000000'     ; 0
	retlw           b'01100000'     ; 1
	retlw           b'11011100'     ; 2
	retlw           b'11110100'     ; 3
	retlw           b'01100110'     ; 4
	retlw           b'10110110'     ; 5
	retlw           b'10111110'     ; 6
	retlw           b'11100000'     ; 7
	retlw           b'11111110'     ; 8
	retlw           b'11110110'     ; 9
	retlw           b'11111010'     ; 10

_7seg_tens
	andlw           0x0F            ;
	addwf           PCL             ;
	retlw           b'00000101'     ; 0
	retlw           b'10011111'     ; 1
	retlw           b'00100011'     ; 2
	retlw           b'00001011'     ; 3
	retlw           b'10011001'     ; 4
	retlw           b'01001001'     ; 5
	retlw           b'01000001'     ; 6
	retlw           b'00011111'     ; 7
	retlw           b'00000001'     ; 8
	retlw           b'00001001'     ; 9
	
;======================================================================
;======================================================================
TimeLoop
	subwf           BuzzPres1, w    ; has correct time passed?
	btfsc           STATUS, Z       ;
	b               TimeLoop+5      ; Yes, carries on checking
	incf            BuzzPres1       ; No
	retlw           0               ; Returns with 0
		
	
	clrf            BuzzPres1       ;
	incf            BuzzPres2	;
	movlw           .100		;
	subwf           BuzzPres2, w	;
	btfss           STATUS, Z	;
	retlw           0               ; NO, returns with 0
	clrf            BuzzPres2       ; resets
	retlw           1               ; YES, returns with 1
	
BuzzLoop				; long buzz
	movlw           .70            ; selects timing length
	call            TimeLoop        ; has time passed?
	btfss           STATUS, Z       ; 
	retlw		0	        ; No
	
	decfsz          FinishCount     ; Yes, does it 5 more times
	retlw		0	        ;

	movlw		.5
        movwf		FinishCount	;
	
	bcf		longbuzz	; finished, turns off buzzer
        bcf		buzz		; turns off buzzer
	retlw		0		; returns
;======================================================================
;======================================================================
LED 
	btfsc		firstime	; has one litre passed?
	retlw		0		; NO, return

	movfw           tens            ; YES, extracts tens value 

Times10Loop
	addwf           tens, w         ; multiplies it by ten
	decfsz          Times10Count    ;       
	b               Times10Loop     ;
	addwf           units, w        ;
	movwf           total           ; adds ones value

	movlw           .9              ; resets Times10Count
	movwf           Times10Count    ;
	clrf            temp            ; clears temp
LEDLoop 
	btfsc		overbath	; checks if over a bath
        b		LEDFlash	; YES, flash LEDs	

	movlw           .25		; NO, continues
	subwf           total           ; determines which LED is on
	btfss           STATUS, C       ;  by subtracting 25 until
	b               LEDisplay       ;  the result is negative
	incf            temp            ;
	b               LEDLoop         ;

LEDisplay                      
	btfss           buzzon          ; NO, checks whether or not to
					;  do timing subroutine
	b               LEDisplay+6     ; NO, skip timing subroutine   
	
	
	movlw           .25             ; YES, do timing subroutine
	call            TimeLoop        ; 
	
	btfsc           STATUS, Z       ; has timing finished ?
	b               Toggle          ;  YES, toggles buzzer
						
	movfw           temp            ; No, checks to see whether 
	subwf           LEDCount, w     ;  LED has changed
	btfsc           STATUS, Z       ; 
	retlw           0               ; NO, hasn't, return
	
Change                                  ; Yes, turn on buzzer
	movfw           temp            ; updates temp
	movwf           LEDCount        ;  
	movfw           LEDCount        ; displays correct LED
	call            LEDCode         ;
	movwf           porta           ;
	bsf             buzzon          ;       
	retlw           0
  
Toggle
	btfss           buzz            ; Toggles buzzzer three times
	b               BuzzOn          ;  
	bcf             buzz            ;
	retlw           0               ;

BuzzOn
	bsf             buzz            ;
	decfsz          BuzzCount       ;
	retlw           0               ;
	
	bcf     	buzz		;
	bcf             buzzon          ;
	movlw          .3               ;
	movwf          BuzzCount        ;
	retlw           0               ;

;======================================================================
;======================================================================

LEDCode
	addwf           PCL
	retlw           b'0000'         ; no LEDs
	b               L1              ; LED 4
	b               L2              ; LED 1
	b               L3              ; LED 2
	b               L4              ; LED 3

L1
	movlw		.3		; 3 buzzes
        movwf		BuzzCount	;
	movlw           b'0100'         ; makes RA2 input
	tris            porta
	retlw           b'1010'         ;

L2
	movlw		.5              ; 5 beeps
        movwf		BuzzCount 	
	movlw           b'0100'         ;
	tris            porta           ;
	retlw           b'1001'         ;

L3
	movlw		.7              ; 7 beeps
        movwf		BuzzCount	;
	movlw           b'0001'         ;
	tris            porta           ;
	retlw           b'1010'         ;
	
L4
	movlw           b'0001'         ;
	tris            porta           ;
	retlw           b'1100'         ;
	
;======================================================================
LEDFlash				; flashes LEDs
	movlw           .100		; Checks if another bath has gone
	subwf           total           ; 
	btfss           STATUS, C       ;  
	b               Bathcheck       ; NO, continues 
	bsf		LEDCount, 2   	; YES, another full bath 
	b               LEDFlash        ;

Bathcheck
	movfw		bathcount	; how many baths so far?
	addwf		PCL		; 
        retlw		0		; no baths yet so does nothing
        b		Led1            ; one bath used
        b		Led2            ; two baths used
        b		Led3            ; three baths used
        b		Led4            ; four baths used
;======================================================================
Led1	
	call		FlashTime       ;
	
	addwf		PCL		
        retlw		0               ; return, leave LEDs as same
	movlw           b'0100'         ; makes RA2 input
	tris            porta	
	
	btfss		porta, 1	; is TOP LED on or off?
        b		turn1on		; OFF, turn on TOP
       	b		topLED		; ON, turn on BOTTOM
	btfsc		longbuzz	;
        movlw           .8		;
	movwf		porta           ; 
	retlw		0

turn1on	
	btfsc		longbuzz	; buzzer on/off?
	b		turn1onA	; ON
	movlw           b'0010'         ; OFF, turns on first LED
        movwf		porta		;
        retlw           0

turn1onA
	movlw           b'1010'         ; turns on first LED+buzzer
        movwf		porta		;
        retlw           0

topLED
	movlw		b'0001'		;
        tris		porta		;
	bsf 		buzztog 	; next time BOTTOM LED
	btfsc		longbuzz	; checks if buzzer is on/off
        b		topLEDA		; ON , turns on both
	movlw		b'0100'		; OFF, turns on top LED only
        movwf		porta		;
	retlw		0

topLEDA
	movlw		b'1100'		; turns on top LED+ Buzzer
        movwf		porta           ;
        retlw		0		;

Led2	call		FlashTime

	addwf		PCL		
        retlw		0

	movlw           b'0100'         ; makes RA2 input
	tris            porta
	
	btfss		porta, 0	; is it on or off?
        b		turn2on		; OFF
     	movlw		0		; ON, turn it off
	btfsc		longbuzz	;
        movlw           .8		;
	movwf		porta           ; 
	retlw		0

turn2on	
	btfsc		longbuzz	;
	b		turn2onA	;
	movlw           b'0001'         ; turns on second LED
        movwf		porta		;
       	retlw           0

turn2onA
	movlw           b'1001'         ; turns on first LED+buzzer
        movwf		porta		;
        retlw           0

Led3	call		FlashTime
	addwf		PCL		
        retlw		0

	movlw           b'0001'         ; makes RA2 input
	tris            porta
	
	btfss		porta, 1	; is it on or off?
        b		turn3on		; OFF
       	movlw		0		; ON, turn it off
	btfsc		longbuzz	;
        movlw           .8		;
	movwf		porta           ; 
	retlw		0

turn3on	
	btfsc		longbuzz	;
	b		turn3onA	;
	movlw           b'0010'         ;
        movwf		porta		;
       	retlw           0

turn3onA
	movlw           b'1010'         ; turns on first LED+buzzer
        movwf		porta		;
        retlw           0

Led4	call		FlashTime
	addwf		PCL		
        retlw		0

	movlw           b'0001'         ; makes RA2 input
	tris            porta
	
	btfss		porta, 2	; is it on or off?
        b		turn4on		; OFF
       	movlw		0		; ON, turn it off
	btfsc		longbuzz	;
        movlw           .8		;
	movwf		porta           ; 
	retlw		0

turn4on	                                ; turns LED on
	btfsc		longbuzz	;
	b		turn4onA	;
	movlw           b'0100'         ;
        movwf		porta		;
        retlw           0

turn4onA
	movlw		b'1100'		;
	movwf		porta		;
	retlw		0		;
 
FlashTime                               ; tests to pulse
	movfw		FlashPres      	; has the TMR0 counted up 5?
        subwf		TMR0, w
        btfss		STATUS, Z
        retlw		0             	; NO, so returns with 0

        movlw		.5             	; YES, increases FlashPres
        addwf		FlashPres
        retlw		1               ; return with 1

;======================================================================
;======================================================================
; Checks to see if stopped
;=========================

IsOn    movfw           temp2           ; checks to see if still pulsing        
	subwf           TMR0, w         ; compares old value with current
	btfss           STATUS, Z       ; 
	b               ChangeVal       ; Different, so resets 
	decfsz          OnCheckPres1    ; Counts number of times no change
	retlw           0               ; returns
	decfsz          OnCheckPres2    ; Counts number of times no change
	retlw           0               ; returns
	decfsz		OnCheckPres3	; Counts number of times no change
	retlw           0               ; returns
	b		start		;

	
ChangeVal
	movfw           TMR0            ; updates temp2
	movwf           temp2           ;
	movlw		.255		;
	movwf           OnCheckPres1    ; resets prescalers
	movlw		.255		;
	movwf           OnCheckPres2    ;
	movlw		.3		;
	movwf		OnCheckPres3	;
	retlw           0               ; returns
;======================================================================
;======================================================================
; Initialisations :
;==================

init

;========
; Ports :
;========

	clrf            porta           ; sets the inputs and outputs
	clrf            portb           ;
	movlw           b'0111'         ;
	tris            porta           ;
	movlw           b'00000000'     ;
	tris            portb           ;


;=========
; Timing :
;=========
	
	movlw           b'00001111'     ; sets up WDT to 2.3 seconds
	option                          ;
		
	movlw           .0              ; sets ones to 10
	movwf           total           ;
	
	clrf		_25		;
	movlw		.2		;
	movwf		toggle2		;
	bsf		Onoroff		;
	b		start+1		;               

;====
init2
;====

	movlw		b'0000'		;
	tris		porta		; sets porta as outputs
	nop
	nop
        nop
        nop
	nop
	nop
	movlw           b'00100000'     ; sets TMR0 to count at 2
	option

	clrf            TMR0            ; resets TMR0
	b		FlowCheck+2	;

;====
init3 
;====
	movlw           b'00100011'     ; sets TMR0 to count at 16
	option

;=================
; File Registers :
;=================
	clrf            LEDCount        ;
	clrf            temp            ;
	clrf            temp2           ;
	clrf            BuzzPres1       ;
	clrf            BuzzPres2       ;
	
        movlw		.25		;
        movwf		BuzzPres3	;

	clrf		bathcount	;

	bcf		buzzon
	bsf		firstime	;

	movlw           .9              ; sets up registers
	movwf           Times10Count    ;

	movlw           .3              ;
	movwf           BuzzCount       ;
	
	movlw           .25             ;
	movwf           _25             ;
	
	movlw           .83             ;
	movwf           CountPres       ;

	movlw           .5              ; amount of wauts for turn off
	movwf           FinishCount     ;
	
	movlw		.255		; prescaler to wait for		
	movwf		OnCheckPres1    ;  pulses

	movlw		.255		; prescaler to wait for	
	movwf		OnCheckPres2    ;  pulses


	movlw		.3		; prescaler to wait for	
	movwf		OnCheckPres3	;  pulses

	bcf		longbuzz	; not long buzz
	bcf		overbath	; on if more than 1 bath
	
	b		MainLoop        ; returns
;======================================================================
;======================================================================
start
;=====
	b               init            ; sets up on turn on
	btfss		toggle		; tests toggle
	b		FlowCheck	; tests for pulses
	
	bcf		toggle		; clears toggle
	sleep
;======================================================================
; Stays on for 1/20th second
;===========================
FlowCheck
	
	bsf		toggle		; sets toggle
	b	        init2
	
	btfsc           TMR0, 0         ; checks for flowing water
	b               StayOn          ; if pulsing, goes to StayOn
	decfsz		_25		; stays on for longer
	b               FlowCheck+2     ;
	
	decfsz		toggle2
	b		FlowCheck+2	;
	
	btfss		Onoroff		;
	b		FlowCheck+2	;
	clrwdt				; clears watch dog timer
	bcf		Onoroff		;
	clrf		toggle2		;
	b		FlowCheck+2	;
	
;======================================================================
StayOn                                  
;=====
	b		init3           ; changes settings
	
MainLoop
	clrwdt                          ; keeps resetting watchdog 
	
	call            Display         ; displays the 7 segments
	
	call            LED             ; displays the LEDs
	
	btfsc		longbuzz	; tests if to do long buzz
        call		BuzzLoop	; times buzzer
	
	btfsc           LEDCount, 2     ; NO, checks to see if last LED
	b               Finish          ; YES, it was the last LED
	
	call            IsOn            ; NO, checks sensor is pulsing


;====================================
; Prescales Pulses to Tens and Ones :
;====================================

Counter
	movfw           CountPres       ; compares TMR0 with 83
	subwf           TMR0, w         ; 
	btfss           STATUS, Z       ;       
	b               MainLoop	;

	movlw           .83             ; updates Count pres
	addwf           CountPres       ;
	
	btfss		firstime	; is this the first count?
	b		LitreCount	;  NO
	clrf		units		;  YES, so resets values
	clrf		tens		;

LitreCount
	bcf		firstime
	incf            units           ; increases number in units up one
	movlw           .10            ; moves 10 into working register
	subwf           units, w        ; subtracts the units from 10
	btfss           STATUS, Z       ; checks STATUS flag
	
	b               MainLoop	; 
	incf            tens            ; increases the tens
	clrf            units           ; clears the units

	b               MainLoop	; returns to the main program
	
;==========================================
; Ending part for when reached 500 litres :
;==========================================
;===================================================================
LEDending
	clrf		LEDmove		;
	movfw		LEDchanger	;
        call		LEDCode		;
        movwf		porta		;
        movlw		.4		;
        subwf		LEDchanger, W	;
        btfsc		STATUS,Z	;
        clrf		LEDchanger	;
	b		Endsecond	;

Ending    				; long buzz after 500 litres
	movlw		.10		;
        movwf		BuzzPres3	;
	movlw		.100
        movwf		BuzzPres2	;
	clrf		LEDmove		;
	clrf		LEDCount	;
	clrf		LEDchanger	;
Ending2	
	call		Display		; displays numbers
	
	incf		LEDmove		; increases LEDmove
        movlw		.10		; compares it with 10
        subwf		LEDmove, W	;
        btfss		STATUS, Z	;
        b		Endsecond	;
        
	clrf		LEDmove		;
        incf		LEDCount        ;
        movlw		.10		;
	subwf		LEDCount	;
	btfss		STATUS, Z	;
	b		Endsecond	;	
	incf		LEDchanger	;
	b		LEDending	; YES, change
Endsecond
	clrwdt				; Clears watch dog timer
	decfsz		BuzzPres1	; 
        b		Ending2		; NO, retry
	clrf		BuzzPres1	; YES, resets the prescaler
        decfsz		BuzzPres2	;  
	b		Ending2		; NO, retry
        movlw		.100		; YES, resets prescaler
	movwf		BuzzPres2	; 
	decfsz		BuzzPres3	; Do it 5 times more
        b		Ending2		; NO, redo
        movlw		.25		;
        movwf		BuzzPres3	;
	b               start		; resets system

Finish  
	call            Display         ;
	clrwdt                          ; keeps resetting the WDT
	bsf		longbuzz	; turns on a long buzz
	bsf		buzz		; turns on buzzer
	
	bsf		overbath	; finished so run the flashing LED program
	
	incf		bathcount	; increases number of baths
	movlw		.5              ; has it reached 5?
        subwf		bathcount, w	;
        btfsc		STATUS, Z	; 
        b		Ending		; YES, so after a long buzz, resets
	
	movfw		TMR0		; NO, Makes FlashPres TMR0+ 2
	movwf		FlashPres	;
	movlw		.5		; 
        addwf		FlashPres	;

	movlw		.3		; resets the count down
        movwf		FinishCount	;

	clrf		units		; Clears units
        clrf		tens		; Clears tens
        clrf		total		; Clears total
        bcf		buzzon		; turns off buzzon
        clrf		LEDCount	; sets LEDCount to 1
	movlw		.1		;
        movwf		LEDCount	;
	b               MainLoop   	; no resets system
;=================================================================================
;=================================================================================

END
