; TK3TUT29.ASM 18DEC04 - JOHN BECKER - MODIFIED FOR PIC18F DEMO
; illustrating use of Timer 0, LCD set up and Data EEPROM use
; FOR 3.2768MHz XTAL upwards to this PIC's limit

        List P = PIC18F252 R=DEC; 	; sets PIC type and radix (decimal)

        include P18F252.inc		; load register and bit equates for this PIC

	__config H'300000', H'00'	; full set of config values 
	__config H'300001', H'22'	; (see TK3 Config screen)
	__config H'300002', H'08'
	__config H'300003', H'00'
	__config H'300004', H'00'
	__config H'300005', H'00'
	__config H'300006', H'80'
	__config H'300007', H'00'
	__config H'300008', H'0F'
	__config H'300009', H'C0'
	__config H'30000A', H'0F'
	__config H'30000B', H'E0'
	__config H'30000C', H'0F'
	__config H'30000D', H'40'

A	equ 0  		  ; set value for Access bank bit
                 
	CBLOCK
LOOP                      ; loop counter 1 - general
LOOPA                     ; loop counter 2 - LCD use only
CLKCNT                    ; 1/25 secs counter
STORE                     ; general store
RSLINE                    ; bit 4 RS line flag for LCD
	ENDC

; ************* PROGRAM COMMANDS ************************

		org	0
		goto	START
		org	0008h
		retfie
		org	0018h
		retfie			; interrupt vector

START           clrf PORTA,A
                clrf PORTB,A
                clrf TRISA,A            ; Port A0-A4 as output
                clrf TRISB,A		; PORTB as output
                movlw B'11000110'
		movwf T0CON,A
                goto SETUP              ; bypass table

TABLCD          addwf PCL,F,A           ; LCD initialisation table
                retlw B'00110011'       ; initialise lcd - first byte
                retlw B'00110011'       ; 2nd byte (repeat of first)
                retlw B'00110010'       ; set for 4-bit operation
                retlw B'00101100'       ; set for 2 lines
                retlw B'00000110'       ; set entry mode to increment each address
                retlw B'00001100'       ; set display on, cursor off, blink off
                retlw B'00000001'       ; clear display
                retlw B'00000010'       ; return home, cursor & RAM to zero
                                        ; end initialisation table
                 
MESSAG          addwf PCL,F,A
                retlw 'R'
                retlw 'E'
                retlw 'A'
                retlw 'D'
                retlw ' '
                retlw 'E'
                retlw 'P'
                retlw 'E'
                 
MESSAG2         addwf PCL,F,A
                retlw 'H'
                retlw 'I'
                retlw 'J'
                retlw 'K'
                retlw 'L'
                retlw 'M'
                retlw 'N'
                retlw 'O'

SETUP           call PAUSIT               ; perform first 1/5th sec delay
                 
; ************* LCD INITIALISATION FROM 1ST TABLE *******

LCDSET          clrf LOOP,A               ; clr LCD set-up loop
                clrf RSLINE,A             ; clear RS line for instruction send
LCDST2          movf LOOP,W,A             ; get table address
                call TABLCD               ; get set-up instruction
                call LCDOUT               ; perform it
                incf LOOP,F,A             ; inc loop - note double increment for 18F
                incf LOOP,F,A             ; inc loop	
                btfss LOOP,4,A            ; has last LCD set-up instruction now been done?
                goto LCDST2               ; no (loop length is twice that of table commands)
                call PAUSIT               ; yes, perform second 1/5th sec delay
                                          ; to allow final LCD command to occur
                                          ; (it takes longer than the rest)
                 
; ************* SHOW 2ND TABLE VALUES ON LCD ************

                bsf RSLINE,4,A            ; set RS for data send
LCDMSG          clrf LOOP,A               ; clear loop
                bsf RSLINE,4,A            ; set RS for data send
LCDMS2          movf LOOP,W,A             ; get table address
                call MESSAG               ; get message letter
                call LCDOUT               ; show it
                incf LOOP,F,A             ; inc loop - note double increment for 18F
                incf LOOP,F,A             ; inc loop
                btfss LOOP,4,A            ; has last LCD letter been sent?
                goto LCDMS2               ; no (loop length is twice that of table commands)

; ************* PUT 3RD TABLE VALUES INTO EEPROM ********

PRMMSG          clrf LOOP,A               ; clear loop
		movlw 8			  ; set eeprom address loop to 8
                movwf LOOPA,A             ;
PRMMS2          movf LOOP,W,A             ; get table address
                call MESSAG2              ; get message letter
		movwf STORE,A		  ; store it for eeprom use
		movf LOOPA,W,A		  ; get eeprom address val
		call SETPRM		  ; write to eeprom
                incf LOOPA,F,A            ; inc eeprom loop
                incf LOOP,F,A             ; inc loop - note double increment for 18F
                incf LOOP,F,A             ; inc loop
                btfss LOOP,4,A            ; has last table value been sent?
                goto PRMMS2               ; no (loop length is twice that of table commands)

; ************* RECALL 16 EEPROM VALUES AND DISPLAY ON LCD ******

		clrf LOOP,A
GETEEPROM	movf LOOP,W,A
		call GETPRM		  ; get eeprom value
		call LCDOUT		  ; display it
		incf LOOP,F,A
		btfss LOOP,3,A
		goto GETEEPROM

                call LCD21		  ; set for start of lcd line 2

		movlw 8			  ; set eeprom address loop to 8
                movwf LOOP,A
GETEEPROM2	movf LOOP,W,A
		call GETPRM		  ; get eeprom value
		call LCDOUT		  ; display it
		incf LOOP,F,A
		btfss LOOP,4,A
		goto GETEEPROM2

NOMORE          goto NOMORE               ; hold here ad infinitum!
                 
; ************* LCD ROUTINES ****************************

LCDOUT          movwf STORE,A             ; temp store data
                movlw 60                  ; set minimum time between sending full bytes to
                movwf LOOPA,A             ; LCD - value of 60 seems OK for this prog with
DELAY           decfsz LOOPA,F,A          ; XTAL clk of upto 5MHz, possibly 5.5MHz
                goto DELAY                ; keep decrementing LOOPA until zero
                call SENDIT               ; send MSB
                call SENDIT               ; send LSB
                return 
                 
SENDIT          swapf STORE,F,A           ; swap data nibbles
                movf STORE,W,A            ; get data byte
                andlw 15                  ; get nibble from byte (LSB)
                iorwf RSLINE,W,A          ; OR the RS bit
                movwf PORTB,A             ; output the byte
		nop
                bsf PORTB,5,A             ; set E line high
		nop
                bcf PORTB,5,A             ; set E line low
                return 
                 
LCD1	   	movlw %10000000		  ; sets lcd to screen line 1 1st cell
        	goto LCDLIN
LCD8	   	movlw %10001000		  ; sets lcd to screen line 1 8th cell
        	goto LCDLIN
LCD21	  	movlw %11000000		  ; sets lcd to screen line 2 1st cell
        	goto LCDLIN
LCD28	  	movlw %11001000		  ; sets lcd to screen line 2 8th cell

LCDLIN	 	bcf RSLINE,4,A    	  ; sets LCD command/line
	        call LCDOUT     	  ; and outputs command code to LCD
	        bsf RSLINE,4,A    	  ; set RS flag back to data write
	        return

PAUSIT          movlw 5                   ; set delay counter to 5
                movwf CLKCNT,A            ; (for 1/25th sec x 5)
                clrf INTCON,A             ; clear interupt flag
PAUSE                                     ; initial 1/5th sec wait before setting up LCD
                btfss INTCON,2,A          ; has a timer time-out been detected?
                goto PAUSE                ; no
                bcf INTCON,2,A            ; yes
                decfsz CLKCNT,F,A         ; dec counter, is it zero?
                goto PAUSE                ; no
                return                    ; yes

; ************* DATA EEPROM ROUTINES ********************

                                          ; READ DATA FROM EEPROM ROUTINE
                                          ; This routine is entered with W holding
                                          ; the eeprom byte address to be read.

GETPRM		movwf EEADR,A		  ; data memory address to read
		bcf EECON1,EEPGD,A	  ; point to data memory
		bcf EECON1,CFGS,A	  ; access program Flash or data eeprom memory
		bsf EECON1,RD,A		  ; eeprom read
		movf EEDATA,W,A		  ; load data into W
		return

                                          ; WRITE DATA TO EEPROM ROUTINE
                                          ; This routine is entered with W holding
                                          ; the eeprom byte address at which data
                                          ; is to be stored. The data to be stored
                                          ; is held in STORE.

SETPRM		movwf EEADR,A		  ; data memory address to write
                movf STORE,W,A            ; get data value from STORE and hold in W
		movwf EEDATA,A            ; data value to be written
		bcf EECON1,EEPGD,A	  ; point to data memory
		bcf EECON1,CFGS,A	  ; access program Flash or data eeprom memory
		bsf EECON1,WREN,A	  ; enable write
		bcf INTCON,GIE,A	  ; disable interrupts
		movlw H'55'		  ;
		movwf EECON2,A		  ; write H'55'
		movlw H'AA'		  ;
		movwf EECON2,A		  ; write H'AA'
		bsf EECON1,WR,A		  ; set WR bit to begin write
CHKWRT	        btfss PIR2,EEIF,A         ; wait until bit EEIF of PIR2 is set
                goto CHKWRT
                bcf EECON1,WREN,A         ; disable write
                bcf PIR2,EEIF,A           ; clear bit EEIF of PIR2
		bcf EECON1,WREN,A	  ; disable write on write complete (EEIF set)
		return

; ************* VALUES FOR DATA EEPROM ******************

	org	H'F00000'		  ; data eeprom assembly address

	de ' ','A','B','C','D','E','F','G','H','I' ; data eeprom values

                end                       ; final line

