; 	**** EETalker ****
; PIC16F628

; Define one of the following modes:

 #define talkwords	; talker speaks its vocabulary of words

; #define straightthru	; incoming 115.2 kb/s serial bytes written directly to PWM

; #define talkserialphonemes	; talk incoming 4.8 kb/s serial phonemes 

; #define loading	; enables EEPROM loading code

;------------
 #ifdef		talkserialphonemes
	#define	serialtransmitter	; enables serial port tx, must be on for talking serial port phonemes
 #endif

 #ifdef		loading
	#define	serialtransmitter	; enables serial port tx, must be on for loading EEPROM
 #endif

 #ifndef	loading
	#define	PWMreq	; enables PWM output - must be off when loading EEPROM
 #endif
;-----------------------------------------------------
 list p=16f628, f=inhx8m
 errorlevel	-302	; suppress Bank warnings
 errorlevel	-224	; suppress TRIS and OPTION mneumonic warnings
;------------------------------------------------------
 #include "p16f628.inc"  	; Microchip's standard include file for the 16F628

 #include "_p16f628.inc"	; Additional include file for the 16F628

 #include "ram.inc"		; Symbolic names for the RAM locations

 #include "ports.inc"		; Symbolic names for the I/O port lines

 #include "eedata.inc"	; EEPROM data initialisation
;------------------------------------------------------
 __config (_BODEN_ON & _PWRTE_ON & _CP_ALL & _WDT_OFF & _LVP_OFF & _MCLRE_OFF & _HS_OSC) 
;------------------------------------------------------
       
        org     RESETVECTOR	; reset address
	goto    start

        org     INTVECTOR	; interrupt address
	goto	tint

 #include "tables.asm"

 #include "isrs.asm"

 #include "subs.asm"

 #include "maths.asm"

start

 #include "init.asm"
;----------------------------------------------------------------------------
mainloop
	clrwdt


	clrf	bufferwriteoffset
;--------------------------------------
 #ifdef	loading
; Delay long enough for everything to stabilise
initdelay
	btfss	timerhi,3
	goto	initdelay

	call	i2c_puts
	call	i2c_gets
deadend
	goto	deadend
 #endif
;--------------------------------------
 #ifdef straightthru
; Straight thru routine.
; Each byte received via the serial input at 115200 is written directly
; to PWM 
	bcf	INTCON,GIE

stwaitforstartbit
	btfss	serialin
	goto	stwaitforstartbit

; A start bit has been found.
; With 14.7456 MHz crystal -> .2713 usec instruction cycles
; At 115200 bps, there are 32 instructions per bit.

; Wait until about at middle of start bit
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	movlw	B'10000000'
	movwf	PWMbyte		; PWMbyte is used as the serial rx byte
	clrf	TMR0

stloop
	btfss	TMR0,5
	goto	stloop

	bcf	TMR0,5

	bcf	_C
	btfss	serialin	; note sign inversion to give correct data byte
	bsf	_C

	rrf	PWMbyte,f
	btfss	_C		; skip if all bits got
	goto	stloop


; Now a little more than halfway thru the last data bit.

; Generate the new value for CCP1CON
	movlw	B'00001100'	; PWM mode
	btfsc	PWMbyte,1
	addlw	B'00100000'
	btfsc	PWMbyte,0
	addlw	B'00010000'
	movwf	CCP1CON

; Generate the new value for CCPR1L
	bcf	_C
	rrf	PWMbyte,f
	bcf	_C
	rrf	PWMbyte,w
	movwf	CCPR1L

; Wait until halfway through stop bit
stsbloop
	btfss	TMR0,5
	goto	stsbloop

	goto	stwaitforstartbit

 #endif
;--------------------------------------

 #ifdef talkserialphonemes
pctalkloop
	btfss	in0byteready
	goto	pctalkloop

	bcf	in0byteready
	movf	in0byte,w
	call	talkphoneme

	movlw	D'0'
	call	serial_send_byte
	goto	pctalkloop	

 #endif
;----------------------------------------
 #ifdef talkwords
sayagain
	call	talkword0
	call	talkphonemePA5
	call	talkword1
	call	talkphonemePA5
	call	talkword2
	call	talkphonemePA5
	call	talkword3
	call	talkphonemePA5
	call	talkword4
	call	talkphonemePA5
	call	talkword5
	call	talkphonemePA5
	call	talkword6
	call	talkphonemePA5
	call	talkword7
	call	talkphonemePA5
	call	talkword8
	call	talkphonemePA5
	call	talkword9
	call	talkphonemePA5
	call	talkword10
	call	talkphonemePA5
	call	talkword11
	call	talkphonemePA5
	call	talkword12
	call	talkphonemePA5
	call	talkword13
	call	talkphonemePA5
	call	talkword14
	call	talkphonemePA5
	call	talkword15
	call	talkphonemePA5
	call	talkword16
	call	talkphonemePA5
	call	talkword17
	call	talkphonemePA5
	call	talkword18
	call	talkphonemePA5
	call	talkword19
	call	talkphonemePA5
	call	talkword20
	call	talkphonemePA5
	call	talkword30
	call	talkphonemePA5
	call	talkword40
	call	talkphonemePA5
	call	talkword50
	call	talkphonemePA5
	call	talkword60
	call	talkphonemePA5
	call	talkword70
	call	talkphonemePA5
	call	talkword80
	call	talkphonemePA5
	call	talkword90
	call	talkphonemePA5
	call	talkwordhundred
	call	talkphonemePA5
	call	talkworddepth
	call	talkwordpoint
	call	talkwordanchor
	call	talkwordalarm
	call	talkwordon
	call	talkwordoff
	call	talkwordshallow
	call	talkwordand
	call	talkwordwatch
	call	talkwordlimit
	call	talkwordset
	call	talkwordheading
	call	talkwordgps
	call	talkwordno
	call	talkworddata
	call	talkwordnorth
	call	talkwordsouth
	call	talkwordeast
	call	talkwordwest
	call	talkwordposition
	goto	sayagain
#endif
;-------------------------------------------------------------------------



 end

