; 	****   ****

; Initialise RAM 
	movlw   RAMSTART
	movwf   RAM0END     ; initialise last byte of ram0 to RAMSTART (H'20')
	movwf   FSR         ; set FSR to ram_base
clearram    
	clrf    INDF
	incf    FSR,f
	btfsc	RAM0END,5	; test whether RAM0END has been zeroed yet
	goto    clearram

; Bank 0 control registers

configRA1thruRA4
; Configure digital I/O on RA1-RA4
	movlw	H'07'
	movwf	CMCON

; Set OPTION register
	; xxxxx111  /128 timer prescalar 
	; xxxx1xxx  prescalar applies to WDT
	; xxx0xxxx  increment timer0, don't care as not enabled
	; xx0xxxxx  timer0 clock is OSC/4
	; x0xxxxxx  interrupt on falling edge of INT
	; 0xxxxxxx  enable port B pullups
	movlw  B'00001111'     
	option			

; Initialise PORTA data
	movlw	PORTAinit
	movwf	PORTA

; Set PORTA data direction registers

	movlw   TRISAinit	; see ports.inc
	tris	PORTA

; Initialise PORTB data
	movlw	PORTBinit
	movwf	PORTB

;  PORT B DDR 
	movlw	TRISBinit
	tris	PORTB

; PIR1
; Reset clears all bits
; These are all status reporting bits and need no initialising

; T1CON
; Reset clears, so T1OSCEN (T1 osc enable) is clear
; (Need to watch this - if T1 OSC is enabled, RB7 and RB6 are forced to inputs

; T2CON
; Reset clears, disabling T2
; b7 is unimplemented
; b6-3 = 0 for postscale = 1
; b2 set -> T2 on
; b1-0 = 0 for prescale = 1
	movlw	B'00000100'
	movwf	T2CON

; CCP1CON
; Reset clears
; With b0-b3 clear, CCP and PWM are off

; RCSTA
; Reset clears. With b7 (SPEN) clear, serial port is disabled

; CMCON
; Reset clears. With b0-b2 clear, comparators are disabled


; Bank 1 control registers

; PR2
; H'3F' gives the highest PWM frequency for 8 bit resolution
	movlw	PR2
	movwf	FSR
	movlw	H'3F'
	movwf	INDF



; Set INTCON register
	; xxxxxxx0  RBIF, PORT B change IRQ
	; xxxxxx0x  INTF, ext int IRQ
	; xxxxx0xx  T0IF, timer IRQ
	; xxxx0xxx  RBIE, PORT B change interrupt enable
	; xxx1xxxx  INTE, external interrupt enable
	; xx1xxxxx  T0IE, timer interrupt enable
	; x0xxxxxx  PEIE int enable
	; 1xxxxxxx  GIE, global interrupt enable
	movlw   B'10100000'
	movwf   INTCON



initend
	nop
