; PIC18F DEMO1 27DEC04
; illustrating use of Timer 0, LCD set up, Data EEPROM read/write, FSR/INDF use
; FOR 3.2768MHz XTAL upwards to this PIC's limit

        List P = PIC18F252, R=DEC; 	; sets PIC type and radix (decimal)

        include P18F252.inc		; load register and bit equates for this PIC

	__config H'300000', H'00'	; full set of config values 
	__config H'300001', H'22'	; (see TK3 Config screen)
	__config H'300002', H'08'
	__config H'300003', H'00'
	__config H'300004', H'00'
	__config H'300005', H'00'
	__config H'300006', H'80'
	__config H'300007', H'00'
	__config H'300008', H'0F'
	__config H'300009', H'C0'
	__config H'30000A', H'0F'
	__config H'30000B', H'E0'
	__config H'30000C', H'0F'
	__config H'30000D', H'40'

A	equ 0  		  ; set value for Access bank bit
                 
	CBLOCK
LOOP                      ; loop counter 1 - general
LOOPA                     ; loop counter 2 - LCD use only
CLKCNT                    ; 1/25 secs counter
STORE                     ; general store for LCD
STORE1			  ; general store
RSLINE                    ; bit 4 RS line flag for LCD
TEST
TEST2
TEST3
TEST4
	ENDC

; ************* PROGRAM COMMANDS ************************

		org	0
		goto	START
		org	0008h
		retfie
		org	0018h
		retfie			; interrupt vector

START           clrf PORTA,A
                clrf PORTB,A
                clrf TRISA,A            ; Port A0-A4 as output
                clrf TRISB,A		; PORTB as output
                movlw B'11000110'
		movwf T0CON,A

SETUP           call PAUSIT               ; perform first 1/5th sec delay
                 
; ************* LCD INITIALISATION FROM 1ST TABLE *******

LCDSET          clrf RSLINE		; set RSLINE for LCD command mode
		movlw	UPPER TABLCD	; load upper, high and low parts of
		movwf	TBLPTRU,A	; the TABLCD address into TBLPTR
		movlw	HIGH TABLCD
		movwf	TBLPTRH,A
		movlw	LOW TABLCD
		movwf	TBLPTRL,A
		movlw	8
		movwf	LOOP,A		; initialise reads counter
LCDST2:
		tblrd*+			; read table, post increment address
		movf	TABLAT,W,A	; get data from latch to W
		rcall	LCDOUT
		decfsz	LOOP,F,A
		bra	LCDST2		
                call	PAUSIT            ; perform second 1/5th sec delay
                                          ; to allow final LCD command to occur
                                          ; (it takes longer than the rest)

                 
; ************* SHOW 2ND TABLE VALUES ON LCD ************

LCDMSG		bsf RSLINE,4		; set RSLINE for LCD write mode
		movlw	UPPER MESSAG	; load upper, high and low parts of
		movwf	TBLPTRU,A	; the address into TBLPTR
		movlw	HIGH MESSAG
		movwf	TBLPTRH,A
		movlw	LOW MESSAG
		movwf	TBLPTRL,A
                bsf 	RSLINE,4,A       ; set RS for data send
		movlw	8
		movwf	LOOP,A		; initialise reads counter
LCDMS2
		tblrd*+			; read table, post increment address
		movf	TABLAT,W,A	; get data from latch to W
		rcall	LCDOUT
		decfsz	LOOP,F,A
		bra	LCDMS2	

; ************* PUT 3RD TABLE VALUES INTO EEPROM ********

PRMMSG          
		movlw	UPPER MESSAG2	; load upper, high and low parts of
		movwf	TBLPTRU,A	; the address into TBLPTR
		movlw	HIGH MESSAG2
		movwf	TBLPTRH,A
		movlw	LOW MESSAG2
		movwf	TBLPTRL,A
                bsf 	RSLINE,4,A      ; set RS for data send
		movlw	8
		movwf	LOOP,A		; initialise reads counter
                movwf   LOOPA,A		; set eeprom address loop to 8
PRMMS2
		tblrd*+			; read table, post increment address
		movff	TABLAT, STORE1	; store data for EEPROM use
		movf	LOOPA,W,A	; get eeprom address val
		rcall	SETPRM
                incf	LOOPA,F,A	; inc eeprom loop
		decfsz	LOOP,F,A
		bra	PRMMS2	

; ************* RECALL 16 EEPROM VALUES AND DISPLAY ON LCD ******

		clrf LOOP,A
GETEEPROM	movf LOOP,W,A
		call GETPRM		  ; get eeprom value
		call LCDOUT		  ; display it
		incf LOOP,F,A
		btfss LOOP,3,A
		goto GETEEPROM

                call LCD21		  ; set for start of lcd line 2

		movlw 8			  ; set eeprom address loop to 8
                movwf LOOP,A
GETEEPROM2	movf LOOP,W,A
		call GETPRM		  ; get eeprom value
		call LCDOUT		  ; display it
		incf LOOP,F,A
		btfss LOOP,4,A
		goto GETEEPROM2

		movlw ' '
		call LCDOUT

; ******** FSR USE, READ WITH AUTO INCREMENT/DECREMENT, AND STRAIGHT READ. DISPLAY ON LCD ******

		movlw 5			  ; load 4 consecutive registers
		movwf TEST
		movlw 6
		movwf TEST2
		movlw 4
		movwf TEST3
		movlw 8
		movwf TEST4		  ; this reg not accessed by routine below

		lfsr FSR1,TEST		  ; load FSR1 with address of 1st reg (TEST)
		movf POSTINC1,W		  ; read 1st reg and inc FSR counter
		iorlw 48
		call LCDOUT               ; show REG contents as decimal
		movf POSTINC1,W 	  ; read 2nd reg and inc FSR counter
		iorlw 48
		call LCDOUT		  ; show REG contents as decimal
		movf INDF1,W		  ; read 3rd reg but don't inc FSR counter
		iorlw 48
		call LCDOUT		  ; show REG contents as decimal
		movf POSTDEC1,W		  ; read 3rd reg again and decrement FSR counter
		iorlw 48
		call LCDOUT		  ; show REG contents as decimal
		movf INDF1,W		  ; read 2nd reg but don't dec/inc FSR counter
		iorlw 48
		call LCDOUT		  ; show 2nd REG contents as decimal


NOMORE          goto NOMORE               ; hold here ad infinitum!
                 
; ************* LCD ROUTINES ****************************

LCDOUT          movwf STORE,A             ; temp store data
                movlw 60                  ; set minimum time between sending full bytes to
                movwf LOOPA,A             ; LCD - value of 60 seems OK for this prog with
DELAY           decfsz LOOPA,F,A          ; XTAL clk of upto 5MHz, possibly 5.5MHz
                goto DELAY                ; keep decrementing LOOPA until zero
                call SENDIT               ; send MSB
                call SENDIT               ; send LSB
                return 
                 
SENDIT          swapf STORE,F,A           ; swap data nibbles
                movf STORE,W,A            ; get data byte
                andlw 15                  ; get nibble from byte (LSB)
                iorwf RSLINE,W,A          ; OR the RS bit
                movwf PORTB,A             ; output the byte
		nop
                bsf PORTB,5,A             ; set E line high
		nop
                bcf PORTB,5,A             ; set E line low
                return 
                 
LCD1	   	movlw b'10000000'		  ; sets lcd to screen line 1 1st cell
        	goto LCDLIN
LCD8	   	movlw b'10001000'		  ; sets lcd to screen line 1 8th cell
        	goto LCDLIN
LCD21	  	movlw b'11000000'		  ; sets lcd to screen line 2 1st cell
        	goto LCDLIN
LCD28	  	movlw b'11001000'		  ; sets lcd to screen line 2 8th cell

LCDLIN	 	bcf RSLINE,4,A    	  ; sets LCD command/line
	        call LCDOUT     	  ; and outputs command code to LCD
	        bsf RSLINE,4,A    	  ; set RS flag back to data write
	        return

PAUSIT          movlw 25                   ; set delay counter to 25
                movwf CLKCNT,A            ; (for 1/25th sec x 5)
                clrf INTCON,A             ; clear interupt flag
PAUSE                                     ; initial 1/5th sec wait before setting up LCD
                btfss INTCON,2,A          ; has a timer time-out been detected?
                goto PAUSE                ; no
                bcf INTCON,2,A            ; yes
                decfsz CLKCNT,F,A         ; dec counter, is it zero?
                goto PAUSE                ; no
                return                    ; yes

; ************* DATA EEPROM ROUTINES ********************

                                          ; READ DATA FROM EEPROM ROUTINE
                                          ; This routine is entered with W holding
                                          ; the eeprom byte address to be read.

GETPRM		movwf EEADR,A		  ; data memory address to read
		bcf EECON1,EEPGD,A	  ; point to data memory
		bcf EECON1,CFGS,A	  ; access program Flash or data eeprom memory
		bsf EECON1,RD,A		  ; eeprom read
		movf EEDATA,W,A		  ; load data into W
		return

                                          ; WRITE DATA TO EEPROM ROUTINE
                                          ; This routine is entered with W holding
                                          ; the eeprom byte address at which data
                                          ; is to be stored. The data to be stored
                                          ; is held in STORE1.

SETPRM		movwf EEADR,A		  ; data memory address to write
                movf STORE1,W,A            ; get data value from STORE1 and hold in W
		movwf EEDATA,A            ; data value to be written
		bcf EECON1,EEPGD,A	  ; point to data memory
		bcf EECON1,CFGS,A	  ; access program Flash or data eeprom memory
		bsf EECON1,WREN,A	  ; enable write
		bcf INTCON,GIE,A	  ; disable interrupts
		movlw H'55'		  ;
		movwf EECON2,A		  ; write H'55'
		movlw H'AA'		  ;
		movwf EECON2,A		  ; write H'AA'
		bsf EECON1,WR,A		  ; set WR bit to begin write
CHKWRT	        btfss PIR2,EEIF,A         ; wait until bit EEIF of PIR2 is set
                goto CHKWRT
                bcf EECON1,WREN,A         ; disable write
                bcf PIR2,EEIF,A           ; clear bit EEIF of PIR2
		bcf EECON1,WREN,A	  ; disable write on write complete (EEIF set)
		return

                ; LCD initialisation table

TABLCD          db B'00110011', B'00110011'
                db B'00110010', B'00101100'
                db B'00000110', B'00001100'
                db B'00000001', B'00000010'

              ; end initialisation table
                
MESSAG                db 'R', 'E', 'A', 'D', ' ', 'E', 'P', 'E'
                 
MESSAG2               db 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O'


; ************* VALUES FOR DATA EEPROM ******************

	org	H'F00000'		  ; data eeprom assembly address

	de ' ','A','B','C','D','E','F','G','H','I' ; data eeprom values

                end                       ; final line

