; SUDOKU672.ASM 10MAR06 - COPYRIGHT JOHN BECKER
; PIC SUDOKU GAME

; PIC16F877-20, 20MHz, WDT OFF, POR ON, XTAL HS

; PROGRAM WRITTEN IN TASM - NEEDS TRANSLATING VIA TK3 TO SUIT MPASM

        List P = PIC16F877, R=DEC;
        __CONFIG   h'3F32'

        include P16F877.inc

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

#DEFINE PAGE0 BCF $03,5  ; clear STATUS bit 5 (RP0)
#DEFINE PAGE1 BSF $03,5  ; set   STATUS bit 5 (RP0)
#DEFINE RP1LO BCF $03,6  ; clear STATUS bit 6 (RP1)
#DEFINE RP1HI BSF $03,6  ; set   STATUS bit 6 (RP1)
#DEFINE BLOCK0 BCF $03,7 ; clear STATUS bit 7 (IRP)
#DEFINE BLOCK1 BSF $03,7 ; set   STATUS bit 7 (IRP)

#DEFINE         AWRON movlw $B0         ; autowrite on command
#DEFINE         AWROFF movlw $B2        ; autowrite off command
#DEFINE         PEEK movlw $E0          ; screen peek command
#DEFINE         CSRPOS movlw $21        ; cursor position command
#DEFINE         OFFSET movlw $22        ; offset position command
#DEFINE         ADPSET movlw $24        ; set address pointer
#DEFINE         TXHOME movlw $40        ; text home address command
#DEFINE         TXAREA movlw $41        ; text area (columns) address command
#DEFINE         GRHOME movlw $42        ; graphics home address command
#DEFINE         GRAREA movlw $43        ; graphic area (columns) address command

FS:             EQU %00000000          ;fs mode set by bit 5: 1 = 6x8, 0 = 8x8

        CBLOCK

PROMVAL
LOOPA
STORE
REGA
REGB
REGC
REGD
REGF
REGR
REGM

REGCX
REGRX

PREVINDEX1
PREVINDEX2
VAL0
VAL1
VAL2
VAL3
VAL4
VAL5
VAL6
VAL7
VAL8
VAL9
RNDVAL0
RNDVAL1
RNDVAL2
RNDVAL3
RNDVAL4
RNDVAL5
RNDVAL6
RNDVAL7
RNDVAL8
RNDVAL9

TEMPA                          ; temp store
ADRLSB                         ; low address
ADRMSB                         ; high address
ATTRIB                         ; attribute value
BITVAL                         ; val of bit to be set/reset
COLUMN                         ; column length holder
CLKCNT
LOOPB
LOOPC

LOOPG
LOOPH
LINESTORE
COLSTORE
LINECOUNT
COLCOUNT
SWITCHVAL
KEYSTORE
ROW
COL
ERRORCOUNT
ANSAFLAG
STORE3
RANDOM1
RANDOM2
RANDOM3
RANDOM4
XORGATE1
XORGATE2
REGH
REGJ
REGK
REGL
        ENDC

        CBLOCK $77
CURSORCOL
CURSORROW
PREVCURSOR
FSRSTOREG
FSRSTOREM
NOWCURSOR
EEPROMLOOP
STORE1                         ; temp store
STORE2                         ; temp store

        ENDC

MATRIX  EQU 4     ;matrix quantity value
                  ; 4 for (4 x 4)

GRID1:  .EQU $20      ; data memory location for Bank 1 (at $A0  = 160)
                      ; extends to $A0 + 81 = $F1 = 241

        ORG 0
        goto GIEOFF
        ORG 4            ; Interrupt vector address
        goto GIEOFF
        ORG 5

GIEOFF: BCF INTCON,GIE   ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

NUMCONVERT: ANDLW 15
          ADDWF PCL,F         
          RETLW 0      ; 0
          RETLW 0      ; 1
          RETLW 6      ; 2
          RETLW 12     ; 3
          RETLW 18     ; 4
          RETLW 24     ; 5
          RETLW 30     ; 6
          RETLW 36     ; 7
          RETLW 42     ; 8
          RETLW 48     ; 9
          RETLW 54     ;10
          RETLW 60     ;11
          RETLW 54     ;12
          RETLW 54     ;13
          RETLW 54     ;14
          RETLW 54     ;15
        
DOSQUARE: ANDLW 15
          ADDWF PCL,F
          goto SETNUM               ; 1  1
          goto SETNUM               ; 2  2
          goto SETNUM               ; 3  3
          goto CURSORUP    ; 'A'    ; 4
          goto SETNUM               ; 5  4
          goto SETNUM               ; 6  5
          goto SETNUM               ; 7  6
          goto CURSORDOWN  ; 'B'    ; 8
          goto SETNUM               ; 9  7
          goto SETNUM               ; 10 8
          goto SETNUM               ; 11 9
          goto CHECKVALS   ; 'C'    ; 12
          goto CURSORLEFT           ; 13  [BLANK]
          goto CURSORRIGHT          ; 14  '0'
          goto SHOWGRID2   ; '.'    ; 15  '.'
          retlw 'D'        ; 'D'    ; 16  'D'  then SETGAME called

GETNUM:   ANDLW 15
          ADDWF PCL,F
          retlw 1         ; 1  1
          retlw 2         ; 2  2
          retlw 3         ; 3  3
          retlw 0         ; 4
          retlw 4         ; 5  4
          retlw 5         ; 6  5
          retlw 6         ; 7  6
          retlw 0         ; 8
          retlw 7         ; 9  7
          retlw 8         ; 10 8
          retlw 9         ; 11 9
          retlw 0
          retlw 0
          retlw 0
          retlw 0
          retlw 0

NAME:     ANDLW 7  
          ADDWF PCL,F
          retlw 'S'
          retlw 'U'
          retlw 'D'
          retlw 'O'
          retlw 'K'
          retlw 'U'
          retlw ' '
          retlw ' '

ERRORS:   ANDLW 7  
          ADDWF PCL,F
          retlw 'E'
          retlw 'R'
          retlw 'R'
          retlw 'O'
          retlw 'R'
          retlw ' '
          retlw ' '
          retlw ' '

PRMBLANKADR: ANDLW 7  
          ADDWF PCL,F
          retlw 67 ; 0
          retlw 85
          retlw 103
          retlw 121
          retlw 139
          retlw 157
          retlw 175
          retlw 193

WAITD:    ANDLW 15 
          ADDWF PCL,F
          retlw 'P'
          retlw 'R'
          retlw 'E'
          retlw 'S'
          retlw 'S'
          retlw ' '
          retlw 'K'
          retlw 'E'
          retlw 'Y'
          retlw ' '
          retlw 'D'
          retlw ' '
          retlw ' '
          retlw ' '
          retlw ' '

FROMREGF: movf REGH,W
          ANDLW 15
          ADDWF PCL,F
          retlw 1   ;row 1
          retlw 10  ;row 2
          retlw 19  ;row 3

          retlw 1   ;row 1
          retlw 10  ;row 2
          retlw 19  ;row 3

TOREGB:   movf REGH,W
          ANDLW 15
          ADDWF PCL,F
          retlw 22  ;1 to row 3
          retlw 4   ;2 to row 1
          retlw 13  ;3 to row 2

          retlw 13  ;1 to row 2
          retlw 22  ;2 to row 3
          retlw 4   ;3 to row 1

FROMCOL:  movf REGJ,W
          ANDLW 15
          ADDWF PCL,F
          retlw 3   ; 1 to col 3
          retlw 1   ; 2 to col 1
          retlw 2   ; 3 to col 2

          retlw 2   ; 1 to col 2
          retlw 3   ; 2 to col 3
          retlw 1   ; 3 to col 1

COMPILE:  ANDLW 15
          ADDWF PCL,F
          retlw 'C'
          retlw 'O'
          retlw 'M'
          retlw 'P'
          retlw 'I'
          retlw 'L'
          retlw 'A'
          retlw 'T'
          retlw 'I'
          retlw 'O'
          retlw 'N'
          retlw ' '
          retlw ' '
          retlw ' '
          retlw ' '
          retlw ' '

; *************** START OF MAIN PROG ***********

START:  BCF STATUS,RP0      
        BCF STATUS,RP1      
        CLRF PORTA          
        CLRF PORTB          

        MOVLW %00001111    ; FS low, RST low, CD CE RD WR high
        MOVWF PORTC         
        CLRF PORTD          
        CLRF PORTE          
        movwf STORE
        PAGE1
        clrf TRISA         ; PORTA as output
        movlw 15
        movwf TRISB        ; PORTB RB0-RB3 as input, RB4-RB7 as output

        MOVLW FS            
        MOVWF TRISC         ; PORTC as output GRAPHIC LCD control/FS
        CLRF TRISD          ; PORTD as output GRAPHIC LCD D0-D7
        CLRF TRISE          ; PORTE as output
        MOVLW %00000110     ; pull-up Rs on (bit 7 lo), timer 1/25 sec
        MOVWF OPTION_REG    ; (for 3.2768MHz xtal)
        PAGE0
        MOVLW %00011111     ; FS low, RST CD CE RD WR high
        MOVWF PORTC         

        movlw 66 ; 210           ; get random seed
        call PRMGET

        movwf RANDOM1
        clrf RANDOM2
        clrf RANDOM3
        clrf RANDOM4

        CALL PAUSIT
        call GRAPHIC        

        movlw 66 ;210
        call PRMGET
        addlw 1             ; inc random seed value
        btfsc STATUS,Z      ; avoid zero value
        addlw 1

        movwf PROMVAL
        movlw 66 ;210
        call SETPRM         ; store new seed value

;        call DEMO9
;hereB:  goto hereB

        MOVLW %10010100     ; 
        MOVLW %10010100     ; text on, graphic off, cursor & blink off
        CALL SENDCMD        ; send command
        CLRF ADRMSB         ;
        CLRF ADRLSB         ;
        CALL SCREENADR      ; set screen write address

        call WAITX

WAIT2:  call GETKEY
        xorlw 16
        btfss STATUS,Z
        goto WAIT2
        call WAITSWRELEASE

SETGAME: clrf ANSAFLAG
        CLRF ADRMSB
        CLRF ADRLSB
        CALL SCREENADR      ; set screen write address

	movlw 1
        movwf REGCX
        movwf REGRX
        movwf PREVINDEX1
        movwf PREVINDEX2
        movwf CURSORROW
        clrf CURSORCOL
        clrf ANSAFLAG

        movlw GRID1         ; get grid address
        addlw 1
        iorlw 128
        movwf PREVCURSOR
        movwf NOWCURSOR

        CLRF ADRMSB
        CLRF ADRLSB
        CALL SCREENADR      ; set screen write address

        AWRON               ; AUTO WRITE ON
        CALL SENDCMD        ; send command
        call RESETGAME
        call BASICSQUARE

        call SETRANDOM
        movf RANDOM1,W
        andlw 1
        movwf STORE1
        bcf STATUS,C
        rlf STORE1,W     ; multiply by 3
        addwf STORE1,W
        andlw %00000011
        movwf REGK

        movf RANDOM2,W
        andlw 1
        movwf STORE1
        bcf STATUS,C
        rlf STORE1,W     ; multiply by 3
        addwf STORE1,W
        andlw %00000011
        movwf REGL

        call NEXTSQUARES
        call CLRTXT
        call COPYGRID2MEM

        AWROFF              ; AUTO WRITE OFF
        CALL SENDCMD        ; send command

        MOVLW %10000000     ; internal CG RAM mode, OR
        CALL SENDCMD        ; send command
        MOVLW %10011100     ; text & graphic on, cursor & blink off
        CALL SENDCMD        ; send command

        call SHOWLINES
        call SETBLANKS
        call SHOWGRID

        clrf ERRORCOUNT
        call CHECKCOMPILE
        movf ERRORCOUNT,F
        btfsc STATUS,Z
        goto GKEY

        call SHOWCOMPILEFAULT
        clrf ERRORCOUNT
        call WAITX
        goto WAIT2

GKEY:   call GETKEY
        movf SWITCHVAL,W
        btfsc STATUS,Z
        goto GKEY

        decf SWITCHVAL,W
        xorlw 15
        btfsc STATUS,Z
        goto SETGAME

        decf SWITCHVAL,W
        call DOSQUARE
        movwf STORE1

        call WAITSWRELEASE
        goto GKEY

; ******** END OF MAIN LOOP *********

COPYGRID2MEM:          ; copies full grid contents
        movlw GRID1
        addlw 1
        movwf FSRSTOREG
        movlw 81
        movwf LOOPA
        BLOCK0
        RP1LO

COPYGM: movf FSRSTOREG,W
        iorlw 128
        movwf FSR
        movf INDF,W
        movwf STORE1

        movf FSRSTOREG,W
        movwf FSR
        movf STORE1,W
        BLOCK1
        RP1HI

        movwf INDF
        incf FSRSTOREG,F
        incf FSRSTOREM,F
        BLOCK0
        RP1LO
        decfsz LOOPA,F
        goto COPYGM
        return

RESETGAME: movlw VAL9    ; load FSR with address of VAL9
	movwf FSR
        movlw 9
	movwf LOOPA

SETVAL: movf LOOPA,W     ; set VAL1-9 with vals 1-9
	movwf INDF
        decf FSR,F
        decfsz LOOPA,F
	goto SETVAL

RANDOMISEVALS: movlw 9
        movwf LOOPA
RV1:    call SETDATA
        movlw RNDVAL0    ; get address RNDVAL0
        addwf LOOPA,W    ; add LOOP val
        movwf FSR        ; put into FSR
        movf REGCX,W     ; getCX
        movwf INDF       ; put into RNDVAL(a) via INDF
        decfsz LOOPA,F   ; is loop = 0
        goto RV1         ; no, do again
        return           ; yes

SETDATA: call INCCOUNTER
        movlw VAL0      ; get address VAL0
        addwf REGCX,W   ; add CX
        movwf FSR       ; put into FSR
        nop
        movf INDF,W     ; is val in INDF = 0?
        movwf REGCX
        btfsc STATUS,Z
        goto SETDATA    ; yes
        clrf INDF
        return

INCCOUNTER: call SETRANDOM
        movf RANDOM1,W  ; get random val >0 <10
        andlw 15        ; and 15
        movwf REGCX
        btfsc STATUS,Z  ; is it > zero?
        goto INCCOUNTER ; it is zero
        addlw 6         ; >0 so is it >9?
        btfsc STATUS,DC
        goto INCCOUNTER ; yes
        return          ; no

; *****************

CURSORRIGHT: movf CURSORCOL,W
        xorlw 9
        btfsc STATUS,Z
        goto CR
        incf CURSORCOL,F
CR:     movf CURSORCOL,W
        movwf STORE1
        call SHOWCURSOR
        return

CURSORLEFT: movf CURSORCOL,W ; is it = 0?
        btfsc STATUS,Z
        goto CL              ; yes
        decf CURSORCOL,W     ; is it = 1?
        btfsc STATUS,Z
        goto CL
        decf CURSORCOL,F
        movf CURSORCOL,W
CL:     movf CURSORCOL,W
        movwf STORE1
        call SHOWCURSOR
        return

CURSORUP: movf CURSORROW,W  ; is it = 0?
        btfsc STATUS,Z
        goto CU             ; yes
        decf CURSORROW,W    ; is it = 1?
        btfsc STATUS,Z
        goto CU
        decf CURSORROW,F
        movf CURSORROW,W
CU:     movf CURSORROW,W
        movwf STORE1
        call SHOWCURSOR
        return

CURSORDOWN: movf CURSORROW,W
        xorlw 9
        btfss STATUS,Z
        incf CURSORROW,F
        movf CURSORROW,W
        movwf STORE1
        call SHOWCURSOR
        return

SHOWCURSOR: movf PREVCURSOR,W
        movwf FSR
        bcf INDF,5

        decf CURSORROW,W
        call MULTIPLY9
        decf CURSORCOL,W
        addwf REGM,W

        addlw GRID1        ; get grid address
        addlw 1
        iorlw 128
        movwf FSR
        movwf PREVCURSOR
        movwf NOWCURSOR
        movf INDF,W
        movwf STORE1
        bsf STORE1,5
        movf STORE1,W
        movwf INDF
        call SHOWGRID
        call CLRERROR
        clrf ANSAFLAG
        return

CLRERROR: clrf ADRMSB
        movlw 0             ; set column
        movwf ADRLSB
        clrf ADRMSB
        clrf LOOPA

CLE2:   AWROFF              ; AUTO WRITE OFF
        CALL SENDCMD        ; send command
        CALL SCREENADR      ; set screen write address

        AWRON               ; set auto write on
        call SENDCMD        ; send command
        movlw 0
        CALL AUTOWRITE      ; auto write and increment
        movf COLUMN,W
        addwf ADRLSB,F
        btfsc STATUS,C          
        incf ADRMSB,F           
        incf LOOPA,F
        movf LOOPA,W
        xorlw 8
        btfss STATUS,Z
        goto CLE2
        AWROFF              ; AUTO WRITE OFF
        CALL SENDCMD        ; send command
        return

MULTIPLY9: movwf REGM
        movwf STORE
        bcf STATUS,C
        rlf REGM,F          ; multiply x 8
        rlf REGM,F
        rlf REGM,F
        movf STORE,W
        addwf REGM,F        ; add STORE
        return

; ***********

BASICSQUARE:
        movlw 1
        movwf REGA
R1:     movlw 1
        movwf REGR

C1:     movlw 1
        movwf REGC
C2:     movlw 1
        subwf REGR,W

        call MULTIPLY9
        movf REGM,W
        addwf REGC,W
        movwf REGB

GETRNDVAL: movlw RNDVAL0
        addwf REGA,W
        movwf FSR
        movf INDF,W
        movwf STORE1

STOREGRID1: movlw GRID1
        iorlw 128
        addwf REGB,W
        movwf FSR
        movf STORE1,W
        movwf INDF
        incf REGA,F
        incf REGC,F
        btfss REGC,2
        goto C2
        incf REGR,F
        btfss REGR,2
        goto C1
        return

OTHERSQUARES:
        movf REGK,W
        movwf REGH
        call A0
        incf REGH,F
        call A0
        incf REGH,F
        call A0
        movlw 3
        addwf REGD,F
        decfsz LOOPB,F
        goto OTHERSQUARES
        return

A0:     movf REGD,W
        movwf REGC
        movlw 3
        movwf LOOPA
        call FROMREGF
        addwf REGC,W
        movwf REGF

        call TOREGB
        addwf REGC,W
        movwf REGB

A1:     call GRIDBF     ; copy reg(f) into reg(b)
        incf REGF,F
        incf REGB,F
        decfsz LOOPA,F
        goto A1
        return

NEXTSQUARES: movlw 0
        movwf REGD
HERED:  movlw 1
        movwf REGC
HEREC:  movlw 3
        movwf LOOPB
        movlw 0
        movf REGL,W
        movwf REGJ

N1A:    movf REGD,W
        movwf REGR
        movlw 3
        movwf LOOPA

N1:     movf REGR,W
        call MULTIPLY9

        call FROMCOL
        addwf REGM,W
        movwf REGF

        movf REGR,W
        addlw 3
        call MULTIPLY9
        movf REGM,W
        addwf REGC,W
        movwf REGB

        call GRIDBF
        incf REGR,F
        decfsz LOOPA,F
        goto N1

        incf REGJ,F
        incf REGC,F
        decfsz LOOPB,F
        goto N1A

        movlw 3
        addwf REGD,F
        movf REGD,W
        xorlw 6
        btfss STATUS,Z
        goto HERED

        movlw 2
        movwf LOOPB
        movlw 0
        movwf REGD
        call OTHERSQUARES

        movlw 2
        movwf LOOPB
        movlw 27
        movwf REGD
        call OTHERSQUARES

        movlw 2
        movwf LOOPB
        movlw 54
        movwf REGD
        call OTHERSQUARES
        return

GRIDBF: movlw GRID1        ; get grid(F)
        iorlw 128
        addwf REGF,W
        movwf FSR
        movf INDF,W
        movf INDF,W
        movwf STORE1

STOREGRIDBF: movlw GRID1   ; store it into grid(B)
        iorlw 128
        addwf REGB,W
        movwf FSR
        movf STORE1,W
        movwf INDF
        return

; ***************

SHOWGRID: movlw GRID1        ; get grid address
        addlw 1
        iorlw 128
        movwf FSR
        movlw 9
        movwf LOOPA
        movlw 3
        movwf LINESTORE
        clrf LINECOUNT
        clrf COLCOUNT

SHWG3:  movlw 2
        MOVWF ADRLSB        ; set column
        movwf COLSTORE
        movf LINESTORE,W
        CALL GLINE          ; multiply by line length to get address

SHWG2:  movf INDF,W
        movwf STORE1
        btfss STORE1,7
        goto SHOWG4
        movlw 10
SHOWG4: call NUMCONVERT
        movwf LOOPG
        movf LOOPG,W
        addlw 0 ;18
        CALL PRMGET

CHARX:  movlw 6
        movwf LOOPH
CHARX2: movf LOOPG,W
        addlw 0 ;18
        CALL PRMGET

        btfss INDF,5
        goto CHARX3
        movwf STORE1
        comf STORE1,W

CHARX3: CALL ONEWRITE
        MOVF COLUMN,W       
        ADDWF ADRLSB,F
        BTFSC STATUS,C      
        INCF ADRMSB,F       
        incf LOOPG,F
        decfsz LOOPH,F
        goto CHARX2

        incf COLCOUNT,F
        movf COLCOUNT,W
        xorlw 3
        btfss STATUS,Z
        goto ADDCOL
        clrf COLCOUNT
        incf COLSTORE,F

ADDCOL: incf COLSTORE,F
        movf COLSTORE,W
        movwf ADRLSB
        movf LINESTORE,W
        CALL GLINE          ; multiply by line length to get address
        incf FSR,F
        movf COLSTORE,W
        xorlw 14
        btfss STATUS,Z
        goto SHWG2

        movlw 6
        addwf LINESTORE,F

        incf LINECOUNT,F
        movf LINECOUNT,W
        xorlw 3
        btfss STATUS,Z
        goto BYPASS
        movlw 2
        addwf LINESTORE,F
        clrf LINECOUNT

BYPASS: decfsz LOOPA,F
        goto SHWG3
        call SHOWTITLE
        return

SHOWLINES: movlw 1          ; vertical
        MOVWF ADRLSB        ; set column
        movwf COLSTORE
        movlw 1
        movwf LINESTORE
        CALL GLINE          ; multiply by line length to get address

SL4:    movlw 61
        movwf LOOPA
SL3:    movlw %00001000
        CALL ONEWRITE
        movf COLSTORE,W
        movwf ADRLSB
        incf LINESTORE,F
        movf LINESTORE,W
        CALL GLINE          ; multiply by line length to get address
        decfsz LOOPA,F
        goto SL3

        movlw 5
        MOVWF ADRLSB        ; set column
        movwf COLSTORE
        movlw 1
        movwf LINESTORE
        CALL GLINE          ; multiply by line length to get address

SL6:    movlw 61
        movwf LOOPA
SL5:    movlw %00001000
        CALL ONEWRITE
        movf COLSTORE,W
        movwf ADRLSB
        incf LINESTORE,F
        movf LINESTORE,W
        CALL GLINE          ; multiply by line length to get address
        decfsz LOOPA,F
        goto SL5

        movlw 9
        MOVWF ADRLSB        ; set column
        movwf COLSTORE
        movlw 1
        movwf LINESTORE
        CALL GLINE          ; multiply by line length to get address

SL8:    movlw 61
        movwf LOOPA
SL7:    movlw %00001000
        CALL ONEWRITE
        movf COLSTORE,W
        movwf ADRLSB
        incf LINESTORE,F
        movf LINESTORE,W
        CALL GLINE          ; multiply by line length to get address
        decfsz LOOPA,F
        goto SL7

        movlw 13
        MOVWF ADRLSB        ; set column
        movwf COLSTORE
        movlw 1
        movwf LINESTORE
        CALL GLINE          ; multiply by line length to get address

SL10:   movlw 61
        movwf LOOPA
SL9:    movlw %00010000
        CALL ONEWRITE
        movf COLSTORE,W
        movwf ADRLSB
        incf LINESTORE,F
        movf LINESTORE,W
        CALL GLINE          ; multiply by line length to get address
        decfsz LOOPA,F
        goto SL9

HORIZ:  movlw 1
        movwf LINESTORE
        movlw 4
        movwf LOOPH

SL2:    movlw 1
        MOVWF ADRLSB        ; set column
        movwf COLSTORE
        movf LINESTORE,W
        CALL GLINE          ; multiply by line length to get address

        movlw %00001111
        CALL ONEWRITE
        incf COLSTORE,F

        movf COLSTORE,W
        movwf ADRLSB
        movf LINESTORE,W
        CALL GLINE          ; multiply by line length to get address

        movlw 11
        movwf LOOPA
SL1:    movlw 255
        CALL ONEWRITE
        incf COLSTORE,F
        movf COLSTORE,W
        movwf ADRLSB
        movf LINESTORE,W
        CALL GLINE          ; multiply by line length to get address
        decfsz LOOPA,F
        goto SL1

        movlw %11110000
        CALL ONEWRITE

        movlw 1
        movwf COLSTORE
        movlw 20
        addwf LINESTORE,F
        decfsz LOOPH,F
        goto SL2
        return

; ***************

SHOWTITLE: clrf ADRMSB
        movlw 14            ; set column
        movwf ADRLSB
        clrf ADRMSB
        clrf LOOPA

ST2:    AWROFF              ; AUTO WRITE OFF
        CALL SENDCMD        ; send command
;        movf COLUMN,W
;        addwf ADRLSB,F
;        btfsc STATUS,C          
;        incf ADRMSB,F           
        CALL SCREENADR      ; set screen write address

        AWRON               ; set auto write on
        call SENDCMD        ; send command
        movf LOOPA,W
        call NAME
        ADDLW 224           ; +224 is same as -32 for conversion from ASCII
        CALL AUTOWRITE      ; auto write and increment
        AWROFF              ; AUTO WRITE OFF
        CALL SENDCMD        ; send command
        movf COLUMN,W
        addwf ADRLSB,F
        btfsc STATUS,C          
        incf ADRMSB,F           

        incf LOOPA,F
        movf LOOPA,W
        xorlw 6
        btfss STATUS,Z
        goto ST2
        return

SHOWERRORCOUNT: clrf ADRMSB
        clrf ADRLSB
        clrf LOOPA

SE2:    AWROFF              ; AUTO WRITE OFF
        CALL SENDCMD        ; send command
        CALL SCREENADR      ; set screen write address

        AWRON               ; set auto write on
        call SENDCMD        ; send command
        movf LOOPA,W
        call ERRORS
        ADDLW 224           ; +224 is same as -32 for conversion from ASCII
        CALL AUTOWRITE      ; auto write and increment

        movf COLUMN,W
        addwf ADRLSB,F
        btfsc STATUS,C          
        incf ADRMSB,F           

        incf LOOPA,F
        movf LOOPA,W
        xorlw 6
        btfss STATUS,Z
        goto SE2

        AWROFF              ; AUTO WRITE OFF
        CALL SENDCMD        ; send command
        CALL SCREENADR      ; set screen write address
        AWRON               ; set auto write on
        call SENDCMD        ; send command

SE3:    swapf ERRORCOUNT,W
        andlw 15
        btfsc STATUS,Z
        goto SE5

        addlw 16
        CALL AUTOWRITE      ; auto write and increment
        AWROFF              ; AUTO WRITE OFF
        CALL SENDCMD        ; send command
        movf COLUMN,W
        addwf ADRLSB,F
        btfsc STATUS,C          
        incf ADRMSB,F           
        CALL SCREENADR      ; set screen write address
        AWRON               ; set auto write on
        call SENDCMD        ; send command

SE5:    movf ERRORCOUNT,W
        andlw 15
        addlw 16
        CALL AUTOWRITE      ; auto write and increment
        AWROFF              ; AUTO WRITE OFF
        CALL SENDCMD        ; send command
        RETURN

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F87x devices ****
;         according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf STATUS,RP0  ;set for Page 3
        bcf EECON1,EEPGD ;point to data memory
        bsf EECON1,RD   ;enable read flag
        bcf STATUS,RP0  ;set for Page 2 
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        bcf STATUS,RP1  ;set for Page 0
        return

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F87x devices ********
          ;according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in PROMVAL
SETPRM: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bcf STATUS,RP1  ;set for Page 0
        MOVF PROMVAL,W  ;get data value from PROMVAL and hold in W
        bsf STATUS,RP1  ;set for Page 2
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf STATUS,RP0  ;set for page 3
        bcf EECON1,EEPGD ;point to Data memory
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw H'55'       ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw H'AA'       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        bcf STATUS,RP1  ;set for Page 0
        bcf STATUS,RP0

CHKWRT: btfss PIR2,EEIF ;wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR2,EEIF   ;clear bit 4 of PIR2
        return

***********

GRAPHIC:        movlw 16                
                movwf COLUMN            ; set column length
                call SETUP              

                movlw %10000000         ; internal cg ram mode, or
                call SENDCMD            ; send command
                movlw %10011100         ; text & graphic on, cursor & blink off
                call SENDCMD            ; send command

                clrf PCLATH             
		return
		
; *************

LCDFRM:         movwf STORE2            ;split & format decimal byte for lcd
                swapf STORE2,W          ;swap byte into w to get tens
                andlw 15                ;and to get nibble
                iorlw 48                ;or with 48 to make ascii value
                call LCDOUT             ;send to lcd
                movf STORE2,W           ;get units
                andlw 15                ;and to get nibble
                iorlw 48                ;or with 48 to make ascii value
                call LCDOUT             ;send to lcd
                return                  

LCDOUT:         addlw 224               ; +224 is same as -32 for conversion from ascii
                call AUTOWRITE          ; auto write and increment
                return                  

; ************

                ;********** start of sub-routines ***************

PAUSIT:         movlw 5                 ; pause routine, 1/5th sec
                movwf CLKCNT            
                clrf INTCON             
PAUSE:          btfss INTCON,2          
                goto PAUSE              
                bcf INTCON,2            
                decfsz CLKCNT,F         
                goto PAUSE              
                return                  



BITWRITE:                               ; ** write single single bit data routine **
                movwf BITVAL            
                call SCREENADR          ; set screen write address
                movf BITVAL,W           
                call SENDCMD            ; send command
                return                  ;

                                        ;.........

ONEWRITE:                               ;  ** write single byte **
                movwf ATTRIB            ; temp store val brought in on w
                call SCREENADR          ; set screen write address - vals preset at call
                AWRON                   ; auto write on
                call SENDCMD            ; send command
                call CHECK3             ; read status for da0/da1 = 3
                movf ATTRIB,W           
                call OUTDATA
                AWROFF                  ; auto write off
                call SENDCMD            ; send command
                return                  
                                        ;............

AUTOWRITE:                              ; ** auto write routine **
                movwf TEMPA             ; temp store value brought in on w
                call CHECK8             ; read status for da3 = 8
                movf TEMPA,W            ; write data
                call OUTDATA            ;
                return                  ;

                                        ;..............

CMDADR:                                 ; ** set address for command sending **
                call CHECK3             ; read status for da0/da1 = 3
                movf ADRLSB,W           ; write data d1
                call OUTDATA            
                call CHECK3             ; read status for da0/da1 = 3
                movf ADRMSB,W           ; write data d2
                call OUTDATA            
                return                  

                                        ;.........

SCREENADR:                              ; ** set address for write/read to/from screen
                call CHECK3             ; read status for da0/da1 = 3
                movf ADRLSB,W           ; write address lsb
                call OUTDATA            ;
                call CHECK3             ; read status for da0/da1 = 3
                movf ADRMSB,W           ; write address msb
                call OUTDATA            ;
                ADPSET                  ; set address pointer
                call SENDCMD            ; send command
                return                  ;

                                        ;.............

TEXTHOME:                               ; ** set text home address **
                clrf ADRMSB             ; text home address $0000
                clrf ADRLSB             ;
                call CMDADR             ; send command address
                TXHOME
                call SENDCMD            ; send command
                return                  
                                        ;...........

GRAPHHOME:                              ;  ** set graphic home address **
                movlw $02               ; graphic home address $0200
                movwf ADRMSB            
                clrf ADRLSB             
                call CMDADR             ; send command address
                GRHOME
                call SENDCMD            ; send command
                return                  

                                        ;...........

TEXTAREA:                               ; ** set text area **
                clrf ADRMSB             ;
                movf COLUMN,W           ; columns length
                movwf ADRLSB            ;
                call CMDADR             ; send command address
                TXAREA                  ; text area command
                call SENDCMD            ; send command
                return                  

                                        ;...........

GRAPHAREA:                              ; ** set graphic area **
                clrf ADRMSB             
                movf COLUMN,W           ; columns length
                movwf ADRLSB            
                call CMDADR             ; send command address
                GRAREA                  ; graphic area command
                call SENDCMD            ; send command
                return                  
                                        ;...........

SETMODE:                                ;  ** set mode - many options, see epe text **
                movlw %10000000         ; (or mode, internal cg mode)
                call SENDCMD            ; send command
                return                  
                                        ; %1000x000   ; or mode
                                        ; %1000x001   ; xor mode
                                        ; %1000x011   ; and mode
                                        ; %1000x100   ; text attribute mode
                                        ; %10000xxx   ; internal cg rom mode
                                        ; %10001xxx   ; external cg ram mode

                                        ;...........

SETOFFSET:                              ; ** set offset register **
                                        ; setting offset address at 2 selects
                                        ; cg ram start address = $1400 where
                                        ; $80 is character number of 1st graphic byte
                                        ; values below that call ascii text characters
                clrf ADRMSB             
                movlw 2                 
                movwf ADRLSB            
                call CMDADR             ; send command address
                OFFSET
                call SENDCMD            ; send command
                return                  

                                        ;...........

SETDISPLAY:                             ;  ** display mode **  some options:
                movlw %10010100         ; text on, graphic off, cursor & blink off
                call SENDCMD            ; send command
                return                  

                                        ;...........

CLRTXT:                                 ;  ** clear text area ($0000) **
                clrf ADRMSB             ; clear all text screen lines, length as set
                clrf ADRLSB             
                call SCREENADR          ; set screen write address
                AWRON                   ; auto write on
                call SENDCMD            ; send command
                movlw 8                 ; number of lines
                movwf LOOPC             
CLR2:           movf COLUMN,W           ; column length
                movwf LOOPB             ;
CLR3:           movlw 0                 ; write 0
                call AUTOWRITE          ; auto write and increment
                decfsz LOOPB,F          
                goto CLR3               
                decfsz LOOPC,F          
                goto CLR2               
                AWROFF                  ; auto write off
                call SENDCMD            ; send command
                return                  

                                        ;............

CLRGRAPH:                               ; ** clear graph area ($0200) **
                movlw $02               
                movwf ADRMSB            
                clrf ADRLSB             
                call SCREENADR          ; set screen write address
                AWRON                   ; auto write on
                call SENDCMD            ; send command
                movlw 64                ; number of lines
                movwf LOOPC             
CLRG2:          movf COLUMN,W           ; column length
                movwf LOOPB             
CLRG3:          movlw 0                 ; write 0
                call AUTOWRITE          ; auto write and increment
                decfsz LOOPB,F          
                goto CLRG3              
                decfsz LOOPC,F          
                goto CLRG2              
                AWROFF                  ; auto write off
                call SENDCMD            ; send command
                return                  

                                        ;............

SETATTR:                                ;  ** send attribute & other data to screen as 1 character, looped
                call SCREENADR          ; set screen write address - vals preset at call
                AWRON                   ; auto write on
                call SENDCMD            ; send command
SETAT:          movf ATTRIB,W           ; val to be sent preset at call
                call AUTOWRITE          ; auto write and increment
                decfsz LOOPC,F          ; loopc val specified by calling routine
                goto SETAT              
                AWROFF                  ; auto write off
                call SENDCMD            ; send command
                return                  

                                        ;............

CHECK3:         BANK1                   ; status check for da0/da1 = 3
                movlw 255               
                movwf TRISD             ; set portd as inputs
                BANK0                   ; rst  cd  ce  rd  wr
                movlw %00011001         ;  1   1   0   0   1
                movwf PORTC             ; set ce, rd low
                nop                     
CK3:            btfss PORTD,0           ; portd bit 0 set?
                goto CK3                ; no
CK3A:           btfss PORTD,1           ; portd bit 1 set?
                goto CK3A               ; no  rst  cd  ce  rd  wr
                movlw %00011111         ;      1   1   1   1   1
                movwf PORTC             ; set controls
                nop                     
                BANK1                   
                clrf TRISD              ; set portd as outputs
                BANK0                   
                return                  

                                        ;............

CHECK6:         BANK1                   ; status check for da6 low
                bsf TRISD,6             ; set portd bit as input
                BANK0                   ; rst  cd  ce  rd  wr
                movlw %00011001         ;  1   1   0   0   1
                movwf PORTC             ; set ce, rd low
                nop                     
CK6:            btfsc PORTD,6           ; is portd bit 6 low?
                goto CK6                ; no rst  cd  ce  rd  wr
                movlw %00011111         ;     1   1   1   1   1
                movwf PORTC             ; set controls
                nop                     
                BANK1                   
                bcf TRISD,6             ; set portd bit 6 as output
                BANK0                   
                return                  

                                        ;............

CHECK8:         BANK1                   ; status check for da3 = 8
                bsf PORTD,3             ; set portd bit 3 as input
                BANK0                   ; rst  cd  ce  rd  wr
                movlw %00011001         ;  1   1   0   0   1
                movwf PORTC             ; set ce, rd low
                nop                     
CK8:            btfss PORTD,3           ; is portd,3 high?
                goto CK8                ; no  rst  cd  ce  rd  wr
                movlw %00011111         ;      1   1   1   1   1
                movwf PORTC             ; set controls
                nop                     
                BANK1                   
                bcf TRISD,3             ; set portd bit 3 as output
                BANK0                   
                return                  

                                        ;........

OUTDATA:                                ; ** send data routine **
                movwf TEMPA             ; temp store val brought in on w
                                        ; rst  cd  ce  rd  wr
                movlw %00010111         ;  1   0   1   1   1
                movwf PORTC             ; set cd low
                movf TEMPA,W            ; get stored data
                movwf PORTD             ; send data
                nop                     ; rst  cd  ce  rd  wr
                movlw %00010010         ;  1   0   0   1   0
                movwf PORTC             ; set cd, ce, wr low
                nop                     ; rst  cd  ce  rd  wr
                movlw %00010111         ;  1   0   1   1   1
                movwf PORTC             ; set ce, wr high
                nop                     ; rst  cd  ce  rd  wr
                movlw %00011111         ;  1   1   1   1   1
                movwf PORTC             ; set cd high
                return                  

                                        ;..........

SENDCMD:                                ;  ** command write routine **
                movwf TEMPA             ; temp store val brought in on w
                call CHECK3             ; read status for da0/da1 = 3
                movf TEMPA,W            ; write command
                movwf PORTD             ; send stored data
                nop                     ; rst  cd  ce  rd  wr
                movlw %00011010         ;  1   1   0   1   0
                movwf PORTC             ; set ce, wr low
                nop                     ; rst  cd  ce  rd  wr
                movlw %00011111         ;  1   1   1   1   1
                movwf PORTC             ; set all high
                return                  

                                        ;............

LINE7:          addwf COLUMN,W          ; sets line addresses for text screen
                btfsc STATUS,C          
                incf ADRMSB,F           
LINE6:          addwf COLUMN,W          
                btfsc STATUS,C          
                incf ADRMSB,F           
LINE5:          addwf COLUMN,W          
                btfsc STATUS,C          
                incf ADRMSB,F           
LINE4:          addwf COLUMN,W          
                btfsc STATUS,C          
                incf ADRMSB,F           
LINE3:          addwf COLUMN,W          
                btfsc STATUS,C          
                incf ADRMSB,F           
LINE2:          addwf COLUMN,W          
                btfsc STATUS,C          
                incf ADRMSB,F           
LINE1:          addwf COLUMN,W          
                btfsc STATUS,C          
                incf ADRMSB,F           
LINE0:          movwf ADRLSB            ; column sets number of cells per line
                return                  ; adrmsb is set/cleared before routine called

                                        ;..............

GLINE:                                  ;** get graphic line address **
                movwf LOOPB             ; store line val
                movlw 2                 ; set graphic base address ($02xx)
                movwf ADRMSB            
                movf LOOPB,W            ; line val = 0?
                btfsc STATUS,Z          
                return                  ; yes
GLIN2:          movf COLUMN,W           ; no, multiply line length by line val
                addwf ADRLSB,F          
                movlw 1                 
                andwf STATUS,W          ; extract and add carry (if any) to msb
                addwf ADRMSB,F          
                decfsz LOOPB,F          
                goto GLIN2              
                return                  

                                        ;..........

SETUP:                                  ; rst  cd  ce  rd  wr  general setup
                movlw %00011111         ;  1   1   1   1   1
                movwf PORTC             ; set controls high (off)
                call TEXTHOME           ; set text home address
                call GRAPHHOME          ; set graphic home address
                call TEXTAREA           ; set text area
                call GRAPHAREA          ; set graphic area
                call SETMODE            ; set mode (int/ext/and-or-xor etc)
                call SETOFFSET          ; set offset (see epe text)
                call SETDISPLAY         ; display mode (text, graph on/off etc)
                call CLRTXT             ; write text blank code $0000
                call CLRGRAPH           ; write graph blank code $0200
                return                  

; **************

;..........GET KEYPAD VAL ROUTINE........negative logic switch press
; PORTB pullups on, no external pullup/down resistors

GETKEY:  clrf SWITCHVAL
         movlw %00001111  ; outputs RB7 to RB4 low
         movwf PORTB

         call SETRANDOM

         comf PORTB,W     ;get PORTB
         btfsc STATUS,Z   ;is result NOT zero (are keys pressed)?
         return           ;no, so return to main prog

         movlw %11101111  ;yes, a key is pressed so get it, trying bit 4 high first
         movwf PORTB      ;initial val for RB7-RB4
         movlw %00010000 
         movwf KEYSTORE
         clrf ROW

GK2:     comf PORTB,W     ;get PORTB
         andlw 15         ;isolate bits 0-3
         btfss STATUS,Z   ;is result zero (keys not pressed)?

         goto GK3         ;no
         movlw MATRIX     ;yes
         addwf ROW,F
         rlf KEYSTORE,F   ;rotate RB7-RB4 left

         comf KEYSTORE,W
         andlw %11110000
         movwf PORTB
         btfss STATUS,C   ;is Carry set?
         goto GK2         ;no, so repeat
         return           ;yes, so return to main prog

GK3:     movwf STORE
         clrf COL         ;clear col number count

GK4:     bcf STATUS,C
         rrf STORE,F      ;rotate right PORTB store val
         btfsc STATUS,C   ;is carry flag set?
         goto SUMIT       ;yes so key pressed, go & finish answer
         incf COL,F
         goto GK4

SUMIT:   movf ROW,W       ;sum up results to single answer
         addwf COL,W      ;add ROW to COL (total of 0-15)
         addlw 1
         movwf SWITCHVAL
         return           ;return to main program
 
WAITSWRELEASE: clrf SWITCHVAL
         movlw %11110000  ;RB7 to RB4 high
         movwf PORTB
         nop              ;pause to allow PORTB to stabilise
         comf PORTB,W     ;get PORTB
         andlw 15         ;isolate bits 0-3

         btfss STATUS,Z   ;is result zero (keys NOT pressed)?
         goto WAITSWRELEASE
         call PAUSIT
         call PAUSIT
         return           ;no, so return to main prog

                              ;******* DEMO 9 SHOW FULL ALPHANUMERIC TEXT SET ***

DEMO9:                        ; ** WRITE FULL ASCII TEXT **
          MOVLW %10010100     ; text on, graphic off, cursor & blink off
          CALL SENDCMD        ; send command

          CLRF ADRMSB         ;
          CLRF ADRLSB         ;
          CALL SCREENADR      ; set screen write address
          AWRON               ; AUTO WRITE ON
          CALL SENDCMD        ; send command
          CLRF LOOPB          

DM9:      MOVF LOOPB,W        ;
          CALL AUTOWRITE      ; auto write and increment
          INCF LOOPB,F        ;
          BTFSS LOOPB,7       
          GOTO DM9            ;
          AWROFF              ; AUTO WRITE OFF
          CALL SENDCMD        ; send command
          RETURN              

;*******************

SHOWGRID2: call CLRERROR
        incf ANSAFLAG,F
        btfsc ANSAFLAG,0
        goto SG42
        call SHOWGRID
        return

SG42:   movlw GRID1         ; get grid address
        addlw 1
        movwf FSR
        movlw 9
        movwf LOOPA
        movlw 3
        movwf LINESTORE
        clrf LINECOUNT
        clrf COLCOUNT

SHWG32: movlw 2
        MOVWF ADRLSB        ; set column
        movwf COLSTORE
        movf LINESTORE,W
        CALL GLINE          ; multiply by line length to get address

SHWG22: BLOCK1
        RP1HI
        movf INDF,W
        BLOCK0
        RP1LO
        movwf STORE1

SHOWG42: call NUMCONVERT
        movwf LOOPG
        movf LOOPG,W
        addlw 0 ;18 ;90
        CALL PRMGET
        movlw 6
        movwf LOOPH
CHARX22: movf LOOPG,W
        addlw 0;  18 ;90
        CALL PRMGET

CHARX32: CALL ONEWRITE
        MOVF COLUMN,W       
        ADDWF ADRLSB,F
        BTFSC STATUS,C      
        INCF ADRMSB,F       
        incf LOOPG,F
        decfsz LOOPH,F
        goto CHARX22

        incf COLCOUNT,F
        movf COLCOUNT,W
        xorlw 3
        btfss STATUS,Z
        goto ADDCOL2
        clrf COLCOUNT
        incf COLSTORE,F

ADDCOL2: incf COLSTORE,F
        movf COLSTORE,W
        movwf ADRLSB
        movf LINESTORE,W
        CALL GLINE          ; multiply by line length to get address
        incf FSR,F
        movf COLSTORE,W
        xorlw 14
        btfss STATUS,Z
        goto SHWG22

        movlw 6
        addwf LINESTORE,F

        incf LINECOUNT,F
        movf LINECOUNT,W
        xorlw 3
        btfss STATUS,Z
        goto BYPASS2
        movlw 2
        addwf LINESTORE,F
        clrf LINECOUNT

BYPASS2: decfsz LOOPA,F
        goto SHWG32
        RP1LO
        BLOCK0
        call SHOWTITLE
        AWROFF              ; AUTO WRITE OFF
        CALL SENDCMD        ; send command
        return

SHOWRANDOM: AWROFF          ; AUTO WRITE OFF
        CALL SENDCMD        ; send command

        clrf ADRMSB
        movlw 14
        call LINE0
        CALL SCREENADR      ; set screen write address

        AWRON               ; AUTO WRITE ON
        CALL SENDCMD        ; send command
        movf RANDOM1,W
        andlw 15
        addlw 16
        CALL AUTOWRITE      ; auto write and increment

        AWROFF              ; AUTO WRITE OFF
        CALL SENDCMD        ; send command
        return

SETRANDOM: clrf XORGATE1
        clrf XORGATE2
        btfsc RANDOM1,2
        bsf XORGATE1,0
        btfsc RANDOM4,6
        bsf XORGATE2,0
        bcf STATUS,C
        movf XORGATE1,W
        xorwf XORGATE2,W
        btfsc STATUS,Z
        bsf STATUS,C
        rrf RANDOM1,F
        rrf RANDOM2,F
        rrf RANDOM3,F
        rrf RANDOM4,F
        return

CHECKVALS:                ; checks full grid contents against user-chosen
        BLOCK0
        RP1LO
        movlw 171
        movwf EEPROMLOOP

        movlw GRID1
        addlw 1
        movwf FSRSTOREG
        movlw 81
        movwf LOOPA
        clrf ERRORCOUNT

CHECKGM: movf FSRSTOREG,W     ; MEM
        movwf FSR

        BLOCK1
        RP1HI
        movf INDF,W          ; get MEM1
        BLOCK0
        RP1LO

        andlw 15
        movwf STORE1

        movf FSRSTOREG,W     ; GRID
        iorlw 128
        movwf FSR

        movf INDF,W          ; grid
        andlw 15
        movwf STORE2

        movf STORE2,W
        xorwf STORE1,W
        btfsc STATUS,Z
        goto CG2
        bsf INDF,5           ; SET highlight flags for errors
        incf ERRORCOUNT,F
        movf ERRORCOUNT,W    ; adjust for BCD
        addlw 6
        btfsc STATUS,DC
        movwf ERRORCOUNT

CG2:    incf FSRSTOREG,F

        decfsz LOOPA,F
        goto CHECKGM
        call SHOWGRID

        call SHOWERRORCOUNT

CLEARHIGHLIGHTFLAGS:
        movlw GRID1
        iorlw 128
        addlw 1
        movwf FSR
        movlw 81
        movwf LOOPA
CHF:    bcf INDF,5           ; clear highlight flags
        incf FSR,F
        decfsz LOOPA,F
        goto CHF

        movf NOWCURSOR,F
        movwf FSR
        bsf INDF,5           ; set cursor highlight flag
        clrf ANSAFLAG
        return

SETNUM: call GETNUM
        movwf STORE1
        movf NOWCURSOR,W
        movwf FSR
        btfss INDF,6
        return

        movf STORE1,W
        iorlw %01100000
        movwf INDF
        call SHOWGRID
        call CLRERROR
        return

SETBLANKS: movlw GRID1
        addlw 1
        iorlw 128
        movwf FSR

        call SETRANDOM

        movf RANDOM2,W   ; RANDOM1,W
        andlw 7
        movwf STORE1
        movwf STORE3

        movlw 14            ; set column
        movwf ADRLSB
        clrf ADRMSB
        call LINE7
        CALL SCREENADR      ; set screen write address
        AWRON               ; AUTO WRITE ON
        CALL SENDCMD        ; send command
        movf STORE1,W
        addlw 16
        call AUTOWRITE
        AWROFF              ; AUTO WRITE OFF
        CALL SENDCMD        ; send command

        movf STORE1,W
        call PRMBLANKADR
        movwf LOOPC
        clrf LOOPA

SETBL:  movf LOOPC,W
        call PRMGET
        btfss STATUS,Z
        goto SETBL3
        movlw %11000000
        iorwf INDF,F

SETBL3: incf FSR,F
        incf LOOPA,F
        INCF LOOPC,F
        movf LOOPC,W
        call PRMGET
        movwf STORE1

        clrf LOOPB
        bcf STATUS,C
SETBL2: rlf STORE1,F
        btfsc STATUS,C
        goto SETBL4
        movlw %11000000
        iorwf INDF,F

SETBL4: incf FSR,F
        incf LOOPB,F
        btfss LOOPB,3
        goto SETBL2

        incf LOOPA,F
        incf LOOPC,F
        movf LOOPA,W
        xorlw 18
        btfss STATUS,Z
        goto SETBL
        return

SHOWCOMPILEFAULT:
        call CLRGRAPH
        AWROFF              ; AUTO WRITE OFF
        CALL SENDCMD        ; send command
        clrf ADRMSB
        movlw 1
        call LINE0
        CALL SCREENADR      ; set screen write address
        AWRON               ; AUTO WRITE ON
        CALL SENDCMD        ; send command
        clrf LOOPA
CPF:    movf LOOPA,W
        call COMPILE
        addlw 224
        call AUTOWRITE
        incf LOOPA,F
        btfss LOOPA,4
        goto CPF
        AWROFF              ; AUTO WRITE OFF
        CALL SENDCMD        ; send command

        clrf ADRMSB
        movlw 1
        call LINE1
        CALL SCREENADR      ; set screen write address
        AWRON               ; AUTO WRITE ON
        CALL SENDCMD        ; send command
        clrf LOOPA
CP2:    movf LOOPA,W
        call ERRORS
        addlw 224
        call AUTOWRITE
        incf LOOPA,F
        btfss LOOPA,3
        goto CP2

        movlw 0
        call AUTOWRITE
        movf ERRORCOUNT,W
        addlw 16
        call AUTOWRITE
        AWROFF              ; AUTO WRITE OFF
        CALL SENDCMD        ; send command
        return

WAITX:  movlw 1
        movwf ADRLSB
        call LINE3
        CALL SCREENADR      ; set screen write address
        AWRON               ; AUTO WRITE ON
        CALL SENDCMD        ; send command

        clrf LOOPA
WAITIT: movf LOOPA,W
        call WAITD
        addlw 224
        CALL AUTOWRITE      ; auto write and increment
        incf LOOPA,F
        movf LOOPA,W
        xorlw 12
        btfss STATUS,Z
        goto WAITIT
        AWROFF              ; AUTO WRITE OFF
        CALL SENDCMD        ; send command

        call SHOWTITLE
        return

CHECKCOMPILE:
        movlw GRID1       ; check rows
        addlw 128
        addlw 1
        movwf FSRSTOREG

        movlw 9
        movwf LOOPB
CC5:    movlw 9
        movwf LOOPA
        movlw VAL9
        movwf FSR
CC0:    clrf INDF
        decf FSR,F
        decfsz LOOPA,F
        goto CC0

CC1:    movlw 9
        movwf LOOPA
        movlw VAL0
        movwf FSRSTOREM
        movlw GRID1
        addlw 128
        addlw 1
        movwf FSRSTOREG

CC2:    movf FSRSTOREG,W   ; set address G
        movwf FSR
        movf INDF,W        ; get val in G 
        andlw 15
        addwf FSRSTOREM,W  ; add to pointer value M
        movwf FSR          ; put into FSR
        bsf INDF,0         ; set value in M to 1
        incf FSRSTOREG,F
        decfsz LOOPA,F
        goto CC2

CC4:    movlw 9            ; check that vals in VALx are all > 0
        movwf LOOPA
        movlw VAL1
        movwf FSR

CC3:    movf INDF,W
        btfsc STATUS,Z
        incf ERRORCOUNT,F
        incf FSR,F
        decfsz LOOPA,F
        goto CC3
        decfsz LOOPB,F
        goto CC5

        movlw GRID1       ; check columns
        addlw 128
        addlw 1
        movwf FSRSTOREG

        movlw 0
        movwf LOOPB
CC5A:   movlw 9           ; zero all check regs
        movwf LOOPA
        movlw VAL9
        movwf FSR
CC0A:   clrf INDF
        decf FSR,F
        decfsz LOOPA,F
        goto CC0A

CC1A:   movlw 9
        movwf LOOPA
        movlw VAL0
        movwf FSRSTOREM
        movlw GRID1
        addlw 128
        addlw 1
        addwf LOOPB,W
        movwf FSRSTOREG

CC2A:   movf FSRSTOREG,W   ; set address G
        movwf FSR
        movf INDF,W        ; get val in G 
        andlw 15
        addwf FSRSTOREM,W  ; add to pointer value M
        movwf FSR          ; put into FSR
        bsf INDF,0         ; set value in M to 1
        movlw 9
        addwf FSRSTOREG,F
        decfsz LOOPA,F
        goto CC2A

CC4A:   movlw 9            ; check that vals in VALx are all > 0
        movwf LOOPA
        movlw VAL1
        movwf FSR

CC3A:   movf INDF,W
        btfsc STATUS,Z
        incf ERRORCOUNT,F
        incf FSR,F
        decfsz LOOPA,F
        goto CC3A
        incf LOOPB,F
        movf LOOPB,W
        xorlw 9
        btfss STATUS,Z
        goto CC5A
        return

; ********************

        org H'2100'      ; data eeprom address

        DE %00001000     ;0 18 LCD digit  1
        DE %00001000
        DE %00001000
        DE %00001000
        DE %00001000
        DE 0

        DE %00111110     ;6 24 LCD digit  2
        DE %00000010
        DE %00111110
        DE %00100000
        DE %00111110
        DE 0

        DE %00111110     ;12 30 LCD digit  3
        DE %00000010
        DE %00011110
        DE %00000010
        DE %00111110
        DE 0

        DE %00100010     ;18 36 LCD digit  4
        DE %00100010
        DE %00111110
        DE %00000010
        DE %00000010
        DE 0

        DE %00111110     ;24 42 LCD digit  5
        DE %00100000
        DE %00111110
        DE %00000010
        DE %00111110
        DE 0

        DE %00100000     ;30 48 LCD digit  6
        DE %00100000
        DE %00111110
        DE %00100010
        DE %00111110
        DE 0

        DE %00111110     ;36 54 LCD digit  7
        DE %00000010
        DE %00000010
        DE %00000010
        DE %00000010
        DE 0

        DE %00111110     ;42 60 LCD digit  8
        DE %00100010
        DE %00111110
        DE %00100010
        DE %00111110
        DE 0

        DE %00111110     ;48 66 LCD digit  9
        DE %00100010
        DE %00111110
        DE %00000010
        DE %00000010
        DE 0

        DE %00000000     ;54 72 LCD digit  10  (blank)
        DE %00000000
        DE %00000000
        DE %00000000
        DE %00000000
        DE %00000000

        DE %00000000     ;60 78 LCD digit  11-15 (shows central "point")
        DE %00000000
        DE %00011000
        DE %00011000
        DE %00000000
        DE %00000000

        DE 1           ;66 random seed number

        DE 1,%10010010 ;67-68  1 start "hidden" patterm
        DE 1,%01101101 ;69-70  2 '1' means shown, '0' means hidden
        DE 0,%11110010 ;71-72  3
        DE 0,%11110011 ;73-74  4
        DE 1,%01101101 ;75-76  5
        DE 1,%10011110 ;77-78  6
        DE 1,%10011110 ;79-80  7
        DE 1,%01101101 ;81-82  8
        DE 0,%11110011 ;83-84  9 end "hidden" patterm

        DE 0,%10101010 ;85   1 start second "hidden" patterm
        DE 1,%01010101 ;87   2 '1' means shown, '0' means hidden
        DE 0,%10101010 ;89   3
        DE 1,%01010101 ;91   4
        DE 0,%10101010 ;93   5
        DE 1,%01010101 ;95   6
        DE 0,%10101010 ;97   7
        DE 1,%01010101 ;99   8
        DE 0,%10101010 ;101  9 end second "hidden" patterm

        DE 1,%01010101 ;103  1 start third "hidden" patterm
        DE 0,%10101010 ;105  2 '1' means shown, '0' means hidden
        DE 1,%01010101 ;107  3
        DE 0,%10101010 ;109  4
        DE 1,%01010101 ;111  5
        DE 0,%10101010 ;113  6
        DE 1,%01010101 ;115  7
        DE 0,%10101010 ;117  8
        DE 1,%01010101 ;119  9 end third "hidden" patterm

        DE 1,%01100101 ;121  1 start fourth "hidden" patterm
        DE 0,%11001001 ;123  2 '1' means shown, '0' means hidden
        DE 1,%10010010 ;125  3
        DE 1,%00100100 ;127  4
        DE 0,%01001011 ;129  5
        DE 0,%10010111 ;131  6
        DE 1,%00101100 ;133  7
        DE 0,%01011011 ;135  8
        DE 0,%10110110 ;137  9 end fourth "hidden" patterm

        DE 0,%10101011 ;139  1 start fifth "hidden" patterm
        DE 1,%01010101 ;141  2 '1' means shown, '0' means hidden
        DE 0,%10101010 ;143  3
        DE 1,%01010101 ;145  4
        DE 1,%10101010 ;147  5
        DE 0,%11010101 ;149  6
        DE 1,%01101010 ;151  7
        DE 0,%10110101 ;153  8
        DE 1,%01011010 ;155  9 end fifth "hidden" patterm

        DE 1,%00010110 ;157  1 start sixth "hidden" patterm
        DE 1,%10101101 ;159  2 '1' means shown, '0' means hidden
        DE 1,%10110001 ;161  3
        DE 0,%00101011 ;163  4
        DE 1,%01010100 ;165  5
        DE 1,%01101010 ;167  6
        DE 0,%01110101 ;169  7
        DE 0,%10001100 ;171  8
        DE 0,%11011001 ;173  9 end sixth "hidden" patterm

        DE 0,%00000000 ;175  1 start seventh "hidden" patterm
        DE 1,%11101011 ;177  2 '1' means shown, '0' means hidden
        DE 1,%01101011 ;179  3
        DE 1,%11101001 ;181  4
        DE 0,%00000000 ;183  5
        DE 0,%11101110 ;185  6
        DE 0,%11101110 ;187  7
        DE 0,%11101110 ;189  8
        DE 0,%00000000 ;191  9 end seventh "hidden" patterm

        DE 0,%01100110 ;193  1 start eighth "hidden" patterm
        DE 0,%11001100 ;195  2 '1' means shown, '0' means hidden
        DE 1,%10011001 ;197  3
        DE 1,%00110011 ;199  4
        DE 0,%01100110 ;201  5
        DE 0,%11001100 ;203  6
        DE 1,%10011001 ;205  7
        DE 1,%00110011 ;207  8
        DE 0,%01100110 ;209  9 end eighth "hidden" patterm

        DE 'A','B'     ;210,201 just terminators, no function

        END

