; rxTVstandby320.ASM 06MAY07

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

    include p16f627.inc
    __CONFIG   h'3F30' ; int osc (4MHz)
    List P = PIC16F627, r=dec

        CBLOCK
CLKCNT
STORE
MAINIDCODE
IDSWITCH
UNITONFLAG
LOOP
UNITID
	ENDC

PROMVAL EQU h'70'    ; in both pages
SPBRG   EQU h'99'    ; not in INC file for some odd reason.  Bank 1

        ORG 0
        goto GIEOFF
        ORG 4            ; Interrupt vector address
        goto GIEOFF
        ORG 5

GIEOFF: BCF INTCON,GIE   ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto STARTIT

;****************

STARTIT: clrf PORTA
        clrf PORTB
        movlw 7
        movwf CMCON

        BANK1
        movlw b'11111111'
        movwf TRISB
        movlw b'00011101'
        movwf TRISA
        movlw b'00000111' ; timer 1:128, pull-ups on (bit 7 = 0)
        movwf OPTION_REG
        BANK0
        clrf UNITONFLAG

        call PAUSIT
        clrf STORE
        call JOESETBAUD     ; initialise serial BAUD rate etc
        call PAUSIT
        clrf LOOP

        btfss PORTA,2
        goto ST2
        call GETSWITCH      ; get main ID from switch
        movf IDSWITCH,W
        movwf PROMVAL
        movlw 0             ; store val in 0
        call SETPRM

ST3:    nop
        goto ST3            ; hold here till power off

ST2:    movlw 0             ; get main ID
        call PRMGET
        iorlw 64
        movwf MAINIDCODE

        call GETSWITCH
        movf IDSWITCH,W
        movwf UNITID

MAIN:   btfsc PORTA,0
        goto LOCAL
        btfss PIR1,RCIF         ; Check for any RX'd data
        goto MAIN

        movf RCREG,W        ; is it > 0?
        btfsc STATUS,Z
        goto MAIN           ; no 
        movwf STORE
        xorwf MAINIDCODE,W  ; is recd code same as main ID?
        btfss STATUS,Z
        goto MAIN           ; no

M2:     btfss PIR1,RCIF     ; Check for any RX'd data
        goto M2
        movf RCREG,W        ; is it > 0?
        btfsc STATUS,Z
        goto M2             ; no 
        movwf STORE
        xorlw %11000000     ; is it = %11000000 (turn all off)?
        btfsc STATUS,Z
        goto TURNOFF

        movf STORE,W
        andlw %01111111
        xorwf UNITID,W
        btfsc STATUS,Z
        goto SINGLE
        goto MAIN

TURNOFF: bcf PORTA,1         ; yes, so turn off unit
        bcf UNITONFLAG,0
        bcf PORTA,6          ; and LED
        goto MAIN

SINGLE: btfsc STORE,7        ; yes, is turn off required?
        goto TT2
        bcf PORTA,1          ; yes, so turn off unit
        bcf UNITONFLAG,0
	bcf PORTA,6	     ; and LED
        goto MAIN

TT2:    bsf PORTA,1          ; no, so turn on unit
        bsf PORTA,6          ; and LED
        bsf UNITONFLAG,0
        goto MAIN

GETSWITCH: clrf IDSWITCH
        btfsc PORTA,3        ; is RA3 high
        bsf IDSWITCH,0       ; yes, set IDSWITCH bit 0
        btfsc PORTA,4        ; is RA4 high
        bsf IDSWITCH,1       ; yes, set IDSWITCH bit 1

        btfsc PORTB,0        ; is RB0 high?
        bsf IDSWITCH,2       ; yes, set IDSWITCH bit 2
        btfsc PORTB,3        ; is RB3 high?
        bsf IDSWITCH,3       ; yes, set IDSWITCH bit 3
        btfsc PORTB,4        ; is RB4 high?
        bsf IDSWITCH,4       ; yes, set IDSWITCH bit 4
        btfsc PORTB,5        ; is RB5 high?
        bsf IDSWITCH,5       ; yes, set IDSWITCH bit 5
        return

LOCAL:  btfss UNITONFLAG,0   ; is unit aleady on?
        goto L2              ; no
        bcf PORTA,1          ; yes, turn it off
        bcf PORTA,6          ; and LED
        bcf UNITONFLAG,0
        goto L3

L2:     bsf UNITONFLAG,0     ; yes, turn it on
        bsf PORTA,1          ; yes, turn it on
        bsf PORTA,6          ; and LED

L3:     btfsc PORTA,0        ; wait for switch release
        goto L3
        call PAUSIT          ; allow for switch bounce
        goto MAIN

;*****************************************************************************

PAUSIT: movlw 5         ; 1/5th sec wait
        movwf CLKCNT
        clrf INTCON     ; clear interupt flag
PAUSE:  btfss INTCON,2  ; has a timer time-out been detected?
        goto PAUSE      ; no
        bcf INTCON,2    ; yes
        decfsz CLKCNT,F ; dec loop, is it zero?
        goto PAUSE      ; no
        return          ; yes

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F62x devices ********
          ;according to data sheet page 93 (is the same as for 16F87x devices
	  ; except that PIR2 of '87x has become PIR1 for '62x and page 2/3 not used)
	
                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in PROMVAL, which is located in both pages at or above h'70'
SETPRM: BANK1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        movf PROMVAL,W  ;get data value from PROMVAL and hold in W
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw h'55'     ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw h'AA'     ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        BANK0

CHKWRT: btfss PIR1,EEIF ;wait until bit 4 of PIR1 is set
        goto CHKWRT
        bcf PIR1,EEIF   ;clear bit 4 of PIR1
        return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F62x    retlwvices ****
;         the data sheet page 93 is wrong!  This routine here works!

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: BANK1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf EECON1,RD   ;enable read flag
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        BANK0
        return

       ;*************** OUTPUT TO PC SERIAL PORT FOR DOWNLOAD

;  Modified from Joe Farr's file SAMPLE5.ASM
;  Orig Date: 10-Feb-2003, mod date 01MAR03

JOESETBAUD: BANK1               ; Configure the baud rate generator
;        movlw 207               ; BRG for 1200baud from 4MHz, brgh=1
        movlw 103               ; BRG for 2400baud from 4MHz, brgh=1
;        movlw 51               ; BRG for 4800baud from 4MHz, brgh=1
                                ; Internal osc is 4MHz

        movwf   SPBRG           ; In bank 1
        movlw   b'00100100'     ; BRGH = 1(High speed, bit 2) & ASYNC transmission (bit 5)
        movwf   TXSTA           ; In bank 1
        bcf     STATUS,RP0      ; back to RAM BANK0
        movlw   b'10010000'     ; ASYNC reception
        movwf   RCSTA           ; In bank 0
        call    FlushRXBuffer   ; Flush the RX buffer in bank 0
        return

; Send byte in W to the USART

TxByte: nop
        btfss   PIR1,TXIF       ; TX Buffer empty yet ?
        goto    TxByte          ; No - Keep waiting
        movwf   TXREG           ; Now empty - send this character
        return

; Flush the contents of the RX Buffer

FlushRXBuffer:
	movf    RCREG,W        	; Flush the RX buffer in bank 0
        movf    RCREG,W
        movf    RCREG,W
        return

;*************

        org H'2100'      ; data eeprom address
        DE 63
        DE 0
        DE 0
        DE 0
        DE 0
        DE 0
        DE 0

        END
