;*****************************************************************************        
;
;   Module:     equates.inc
;               
;   Author:     Mike Hibbett 
;                                                                  
;   Version:    1.0 5/10/03                                                  
;
;               equate statements for variables and constants
;
;*****************************************************************************        


; D to A converter port; 8 bits
;D2A_PORT            EQU PORTB
;D2A_TRIS            EQU TRISB    
;D2A_TRIS_VALUE      EQU 0
RS232_TRIS_VALUE    EQU 0x06

	#DEFINE D2A_PORT PORTB
	#DEFINE D2A_TRIS TRISB    
	#DEFINE D2A_TRIS_VALUE 0
	#DEFINE I2C_TRIS TRISC  ;TRISA
	#DEFINE I2C_PORT PORTC  ; PORTA    
	#DEFINE IO_PORT PORTC   ;PORTA
	#DEFINE IO_TRIS TRISC   ;TRISA

SDA         EQU 0
SCL         EQU 1
SDA_BIT     EQU 1
SCL_BIT     EQU 2
;I2C_TRIS    EQU TRISA
;I2C_PORT    EQU PORTA    

; Port A setup
;IO_PORT             EQU PORTA
;IO_TRIS             EQU TRISA

IO_TRIS_VALUE_3I    EQU 0x00        ; RA0/1/4 In (i2c,input), RA2/3 IN (Inputs) 
IO_TRIS_VALUE       EQU 0xf3        ; RA0/1/4 In (i2c,LDR), RA2/3 Out (Led) 
INITIAL_LEDS        EQU 0x08        ; One LED on, One Off

BAUD_CONSTANT       EQU 0x0A            ;Constant for baud generator for 115200 baud
;BAUD_CONSTANT       EQU 0x20            ;Constant for baud generator for 38400 baud

; Bank 0 RAM

	CBLOCK
delay1            ;  EQU 0x20        ; delay routine variable
delay2            ;  EQU 0x21        ; delay routine variable
delay3            ;  EQU 0x22        ; delay routine variable

eepData           ;  EQU 0x23
bitCount          ;  EQU 0x24
eepBuff           ;  EQU 0x25
eepAddL           ;  EQU 0x26
eepAddH           ;  EQU 0x27
rxB1              ;  EQU 0x28
rxB2              ;  EQU 0x29
tmp1              ;  EQU 0x2A        ; Used in hex2byte routine, windUp, windDown

; PCB and Wav file information : see eeprom map in i2c.inc
hwType            ;  EQU 0x2B        ; PCB h/w type 
wav1SAH           ;  EQU 0x2C        ; High byte of Start Address
wav1SAL           ;  EQU 0x2D        ; Low byte of Start Address
wav1LENH          ;  EQU 0x2E        ; High byte of Data Length
wav1LENL          ;  EQU 0x2F        ; Low byte of Data Length
wav2SAH           ;  EQU 0x30        ; High byte of Start Address
wav2SAL           ;  EQU 0x31        ; Low byte of Start Address
wav2LENH          ;  EQU 0x32        ; High byte of Data Length
wav2LENL          ;  EQU 0x33        ; Low byte of Data Length
wav3SAH           ;  EQU 0x34        ; High byte of Start Address
wav3SAL           ;  EQU 0x35        ; Low byte of Start Address
wav3LENH          ;  EQU 0x36        ; High byte of Data Length
wav3LENL          ;  EQU 0x37        ; Low byte of Data Length

dataCountH        ;  EQU 0x38
dataCountL        ;  EQU 0x39
tmp2              ;  EQU 0x3A        ; Used in windUp, windDown

; Generic wav file data for 3 input option
wavSAH            ;  EQU 0x3B        ; High byte of Start Address
wavSAL            ;  EQU 0x3C        ; Low byte of Start Address
wavLENH           ;  EQU 0x3D        ; High byte of Data Length
wavLENL           ;  EQU 0x3E        ; Low byte of Data Length
	ENDC

PCLATH_TEMP         EQU 0x7d        ; Exists in all banks
STATUS_TEMP         EQU 0x7e        ; Exists in all banks
W_TEMP              EQU 0x7f        ; Exists in all banks
