VERSION 5.00
Object = "{DAD6819A-EF7C-43D3-ADFC-CD12675BD473}#7.0#0"; "EPESeralIO.OCX"
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Sample4 - Receive 256 bytes from PIC."
   ClientHeight    =   5400
   ClientLeft      =   2415
   ClientTop       =   2025
   ClientWidth     =   5865
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5400
   ScaleWidth      =   5865
   Begin VB.TextBox txtOutput 
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   3555
      Left            =   195
      MultiLine       =   -1  'True
      TabIndex        =   3
      Top             =   1785
      Width           =   5550
   End
   Begin EPESerialControl.EPESerial EPESerial1 
      Left            =   5160
      Top             =   105
      _ExtentX        =   926
      _ExtentY        =   926
   End
   Begin VB.CommandButton cmdRun 
      Caption         =   "Run Test"
      Enabled         =   0   'False
      Height          =   330
      Left            =   195
      TabIndex        =   2
      Top             =   795
      Width           =   1200
   End
   Begin VB.CommandButton cmdClose 
      Caption         =   "Close Port"
      Enabled         =   0   'False
      Height          =   330
      Left            =   195
      TabIndex        =   1
      Top             =   1365
      Width           =   1200
   End
   Begin VB.CommandButton cmdOpen 
      Caption         =   "Open Port"
      Height          =   330
      Left            =   195
      TabIndex        =   0
      Top             =   210
      Width           =   1200
   End
   Begin VB.Label Label1 
      BackStyle       =   0  'Transparent
      Caption         =   $"Form1.frx":0000
      Height          =   840
      Left            =   1605
      TabIndex        =   4
      Top             =   195
      Width           =   3525
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit


Private Sub cmdOpen_Click()

    On Error GoTo ErrorHandler
    
    
    With EPESerial1
        .ComPort = 1                    ' Use COM#1
        .Speed = sio19200               ' 19.2K Baud
        .Parity = sioNoParity           ' No parity
        .StopBits = 1                   ' 1 stop bit per word
        .WordLength = sio8Bits          ' 8 data bits per word
        .Handshaking = sioNone          ' No handshaking
        
        .RxBlockSize = 256              ' We are expecting 256 bytes per block
        .RxMode = sioBlockMode          ' Set block mode - control only returns back when we have 256 bytes OR theres a time-out
        .TimeOut = 10                   ' 10 seconds (this is the default value)
        .PortStatus = sioPortOpen       ' Open the port
    End With

    ' Tidy up the screen and enable/disable certain command buttons
    txtOutput.Text = ""

    cmdOpen.Enabled = False
    cmdClose.Enabled = True
    cmdRun.Enabled = True
    
    Exit Sub

ErrorHandler:
    MsgBox "An unexpected error occured - " & Err.Description, vbOKOnly + vbCritical, "Critical Error"
End Sub



Private Sub cmdClose_Click()
  
    With EPESerial1
        .PortStatus = sioPortClosed ' Close the serial port
    End With
    
    cmdOpen.Enabled = True
    cmdClose.Enabled = False
    cmdRun.Enabled = False
    
    
End Sub


Private Sub cmdRun_Click()

    Dim F                       As Integer
    Dim sBuffer                 As String
    
    
    On Error GoTo ErrorHandler
    
    Screen.MousePointer = vbHourglass
    txtOutput.Text = "" ' remove results from previous tests
    
    With EPESerial1
        ' Because of the different receive modes (RXMode) that
        ' the EPESerial control supports, you should always clear
        ' the recieve buffer.
        .ClearReceiveBuffer
    
        .SendText "X" ' Tell PIC to send it's data packet. Send it anything at all...
        
        '
        ' Wait here until a complete block has been received.
        ' In this case, 256 Bytes (ASCII 0 to 255)
        ' Look at the code behind the 'Open Port' button to see
        ' how the block size and mode is specified.
        sBuffer = .ReceiveText
        
        '
        ' sBuffer contains ASCII characters and we want to see the
        ' actual ASCII codes to check what we actually received.
        For F = 1 To Len(sBuffer)
            txtOutput.Text = txtOutput.Text & Right$("00" & Hex$(Asc(Mid$(sBuffer, F, 1))), 2) & " "
            If F Mod 16 = 0 Then
                ' Insert a [CRLF] after each 16th code so that the layout is readable
                txtOutput.Text = txtOutput.Text & vbCrLf
            End If
        Next F
        
        Screen.MousePointer = vbDefault
        
        If Len(sBuffer) < .RxBlockSize Then
            MsgBox "We did not receive all the characters we expected !", vbOKOnly + vbExclamation
        Else
            MsgBox "Receive Complete !"
        End If
    End With
    
    Exit Sub
    
ErrorHandler:
    MsgBox "An unexpected error occured - " & Err.Description, vbOKOnly + vbCritical, "Critical Error"
End Sub


Private Sub EPESerial1_CommunicationsEvent(EventCode As EPESerialControl.eCommsEvents, RXBufferContents As String)

    Select Case EventCode
    Case eCommsEvents.sioRXTimeOut
        MsgBox "Time-out waiting for data to be received !", vbOKOnly + vbExclamation
        
    End Select
End Sub

