VERSION 5.00
Object = "{DAD6819A-EF7C-43D3-ADFC-CD12675BD473}#10.0#0"; "EPESERALIO.OCX"
Begin VB.Form Seismograph 
   Caption         =   "EPE Seismograph Logger  V1.0  09JAN04"
   ClientHeight    =   7590
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   11820
   Icon            =   "Seismograph.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   7590
   ScaleWidth      =   11820
   StartUpPosition =   2  'CenterScreen
   Begin VB.CheckBox Check2 
      BackColor       =   &H00FFFF00&
      Caption         =   "Condense"
      Height          =   255
      Left            =   360
      TabIndex        =   59
      ToolTipText     =   "When clicked displays full file data on one line, without time markers"
      Top             =   1380
      Visible         =   0   'False
      Width           =   1095
   End
   Begin VB.ComboBox Combo3 
      Height          =   315
      Left            =   4920
      TabIndex        =   58
      Text            =   "0"
      ToolTipText     =   "Set file number at which to start live recording"
      Top             =   1080
      Width           =   855
   End
   Begin VB.ListBox List3 
      Height          =   1035
      ItemData        =   "Seismograph.frx":0442
      Left            =   9000
      List            =   "Seismograph.frx":0444
      TabIndex        =   56
      ToolTipText     =   "Can be double-clicked on list item to close when recording stopped"
      Top             =   480
      Visible         =   0   'False
      Width           =   2535
   End
   Begin VB.Timer Timer4 
      Enabled         =   0   'False
      Interval        =   1
      Left            =   9840
      Top             =   720
   End
   Begin VB.CommandButton EEPROMclear 
      BackColor       =   &H00FFFF00&
      Caption         =   "PIC Clear "
      Height          =   495
      Left            =   3840
      Style           =   1  'Graphical
      TabIndex        =   54
      ToolTipText     =   "Click this to view PIC count when clearing memory chips"
      Top             =   840
      Width           =   855
   End
   Begin VB.Timer Timer3 
      Enabled         =   0   'False
      Interval        =   1
      Left            =   9840
      Top             =   240
   End
   Begin VB.CommandButton PICrate 
      BackColor       =   &H00FFFF00&
      Caption         =   " PIC Rate"
      Height          =   495
      Left            =   3840
      Style           =   1  'Graphical
      TabIndex        =   53
      ToolTipText     =   "Click this to view PIC Rate setting when being changed"
      Top             =   240
      Width           =   855
   End
   Begin VB.Timer Timer2 
      Enabled         =   0   'False
      Interval        =   1
      Left            =   10560
      Top             =   720
   End
   Begin VB.CommandButton TestInput 
      BackColor       =   &H0000FFFF&
      Caption         =   "Test Input"
      Height          =   495
      Left            =   60
      Style           =   1  'Graphical
      TabIndex        =   51
      ToolTipText     =   "Used for basic testing of live data from PIC"
      Top             =   840
      Width           =   735
   End
   Begin VB.CommandButton Command2 
      BackColor       =   &H0000FF00&
      Caption         =   "Load Seismo0"
      Height          =   495
      Left            =   480
      Style           =   1  'Graphical
      TabIndex        =   50
      ToolTipText     =   "Loads in Live data file Seismo0 for viewing"
      Top             =   240
      Width           =   735
   End
   Begin VB.CommandButton Command1 
      Height          =   495
      Index           =   1
      Left            =   1200
      Picture         =   "Seismograph.frx":0446
      Style           =   1  'Graphical
      TabIndex        =   49
      ToolTipText     =   "Arrow buttons call in Live Recorded files in sequence, fore or back"
      Top             =   240
      Width           =   495
   End
   Begin VB.CommandButton Command1 
      Height          =   495
      Index           =   0
      Left            =   0
      Picture         =   "Seismograph.frx":0888
      Style           =   1  'Graphical
      TabIndex        =   48
      ToolTipText     =   "Arrow buttons call in Live Recorded files in sequence, fore or back"
      Top             =   240
      Width           =   495
   End
   Begin VB.CheckBox Check1 
      BackColor       =   &H0000FF00&
      Caption         =   "x 4"
      Height          =   255
      Left            =   960
      TabIndex        =   46
      ToolTipText     =   "Alternates Details graph values between x1 and x4"
      Top             =   1080
      Visible         =   0   'False
      Width           =   735
   End
   Begin VB.ComboBox Combo2 
      Height          =   315
      ItemData        =   "Seismograph.frx":0CCA
      Left            =   5760
      List            =   "Seismograph.frx":0CCC
      TabIndex        =   45
      Text            =   "Max File Qty"
      ToolTipText     =   "The max number of recording files that can be generated (max = 256 = approx 358.4 Mbytes)"
      Top             =   1080
      Width           =   1455
   End
   Begin VB.ComboBox Combo1 
      Height          =   315
      ItemData        =   "Seismograph.frx":0CCE
      Left            =   4920
      List            =   "Seismograph.frx":0CD0
      TabIndex        =   40
      Text            =   "Sample Rates"
      ToolTipText     =   "Selects/displays your sample rate "
      Top             =   480
      Width           =   2295
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Port COM 1"
      Height          =   255
      Index           =   0
      Left            =   7320
      TabIndex        =   39
      ToolTipText     =   "Selects port COM1  address"
      Top             =   240
      Value           =   -1  'True
      Width           =   1215
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Port COM 2"
      Height          =   255
      Index           =   1
      Left            =   7320
      TabIndex        =   38
      ToolTipText     =   "Selects port COM2  address"
      Top             =   480
      Width           =   1215
   End
   Begin VB.ListBox List2 
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   720
      Index           =   7
      ItemData        =   "Seismograph.frx":0CD2
      Left            =   0
      List            =   "Seismograph.frx":0CD4
      TabIndex        =   35
      ToolTipText     =   "Shows disk number and start time. Click to show file when recording ended"
      Top             =   6720
      Visible         =   0   'False
      Width           =   1695
   End
   Begin VB.ListBox List2 
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   720
      Index           =   6
      ItemData        =   "Seismograph.frx":0CD6
      Left            =   0
      List            =   "Seismograph.frx":0CD8
      TabIndex        =   34
      ToolTipText     =   "Shows disk number and start time. Click to show file when recording ended"
      Top             =   6000
      Visible         =   0   'False
      Width           =   1695
   End
   Begin VB.ListBox List2 
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   720
      Index           =   5
      ItemData        =   "Seismograph.frx":0CDA
      Left            =   0
      List            =   "Seismograph.frx":0CDC
      TabIndex        =   33
      ToolTipText     =   "Shows disk number and start time. Click to show file when recording ended"
      Top             =   5280
      Visible         =   0   'False
      Width           =   1695
   End
   Begin VB.ListBox List2 
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   720
      Index           =   4
      ItemData        =   "Seismograph.frx":0CDE
      Left            =   0
      List            =   "Seismograph.frx":0CE0
      TabIndex        =   32
      ToolTipText     =   "Shows disk number and start time. Click to show file when recording ended"
      Top             =   4560
      Visible         =   0   'False
      Width           =   1695
   End
   Begin VB.ListBox List2 
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   720
      Index           =   3
      ItemData        =   "Seismograph.frx":0CE2
      Left            =   0
      List            =   "Seismograph.frx":0CE4
      TabIndex        =   31
      ToolTipText     =   "Shows disk number and start time. Click to show file when recording ended"
      Top             =   3840
      Visible         =   0   'False
      Width           =   1695
   End
   Begin VB.ListBox List2 
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   720
      Index           =   2
      ItemData        =   "Seismograph.frx":0CE6
      Left            =   0
      List            =   "Seismograph.frx":0CE8
      TabIndex        =   30
      ToolTipText     =   "Shows disk number and start time. Click to show file when recording ended"
      Top             =   3120
      Visible         =   0   'False
      Width           =   1695
   End
   Begin VB.ListBox List2 
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   720
      Index           =   1
      ItemData        =   "Seismograph.frx":0CEA
      Left            =   0
      List            =   "Seismograph.frx":0CEC
      TabIndex        =   29
      ToolTipText     =   "Shows disk number and start time. Click to show file when recording ended"
      Top             =   2400
      Visible         =   0   'False
      Width           =   1695
   End
   Begin VB.ListBox List2 
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   720
      Index           =   0
      ItemData        =   "Seismograph.frx":0CEE
      Left            =   0
      List            =   "Seismograph.frx":0CF0
      TabIndex        =   28
      ToolTipText     =   "Shows disk number and start time. Click to show file when recording ended"
      Top             =   1680
      Visible         =   0   'False
      Width           =   1695
   End
   Begin VB.ListBox List1 
      Height          =   5715
      Left            =   0
      TabIndex        =   13
      ToolTipText     =   "Click top line to reshow full data. Click zone item to display section detail. "
      Top             =   1680
      Visible         =   0   'False
      Width           =   1695
   End
   Begin VB.PictureBox Picture1 
      Height          =   735
      Index           =   7
      Left            =   1800
      ScaleHeight     =   1024
      ScaleMode       =   0  'User
      ScaleWidth      =   64742.82
      TabIndex        =   12
      Top             =   6720
      Width           =   9855
   End
   Begin VB.PictureBox Picture1 
      Height          =   735
      Index           =   6
      Left            =   1800
      ScaleHeight     =   1024
      ScaleMode       =   0  'User
      ScaleWidth      =   64742.82
      TabIndex        =   11
      Top             =   6000
      Width           =   9855
   End
   Begin VB.PictureBox Picture1 
      Height          =   735
      Index           =   5
      Left            =   1800
      ScaleHeight     =   1024
      ScaleMode       =   0  'User
      ScaleWidth      =   64742.82
      TabIndex        =   10
      Top             =   5280
      Width           =   9855
   End
   Begin VB.PictureBox Picture1 
      Height          =   735
      Index           =   4
      Left            =   1800
      ScaleHeight     =   1024
      ScaleMode       =   0  'User
      ScaleWidth      =   64742.82
      TabIndex        =   9
      Top             =   4560
      Width           =   9855
   End
   Begin VB.PictureBox Picture1 
      AutoRedraw      =   -1  'True
      Height          =   735
      Index           =   3
      Left            =   1800
      ScaleHeight     =   1024
      ScaleMode       =   0  'User
      ScaleWidth      =   64742.82
      TabIndex        =   8
      Top             =   3840
      Width           =   9855
   End
   Begin VB.PictureBox Picture1 
      AutoRedraw      =   -1  'True
      Height          =   735
      Index           =   2
      Left            =   1800
      ScaleHeight     =   1024
      ScaleMode       =   0  'User
      ScaleWidth      =   64742.82
      TabIndex        =   7
      Top             =   3120
      Width           =   9855
   End
   Begin VB.PictureBox Picture1 
      AutoRedraw      =   -1  'True
      Height          =   735
      Index           =   1
      Left            =   1800
      ScaleHeight     =   1100
      ScaleMode       =   0  'User
      ScaleWidth      =   1.03589e6
      TabIndex        =   6
      Top             =   2400
      Width           =   9855
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   1
      Left            =   10560
      Top             =   240
   End
   Begin VB.CommandButton RunIt 
      BackColor       =   &H0000FF00&
      Caption         =   " Record Start"
      Height          =   495
      Left            =   2880
      Style           =   1  'Graphical
      TabIndex        =   5
      ToolTipText     =   "Click to start/stop recording live data from PIC unit"
      Top             =   840
      Width           =   855
   End
   Begin VB.PictureBox Picture1 
      AutoRedraw      =   -1  'True
      Height          =   735
      Index           =   0
      Left            =   1800
      ScaleHeight     =   1100
      ScaleMode       =   0  'User
      ScaleWidth      =   1.03589e6
      TabIndex        =   4
      Top             =   1680
      Width           =   9855
   End
   Begin VB.CommandButton ViewData 
      BackColor       =   &H00FFFF00&
      Caption         =   "View Data as Text "
      Height          =   495
      Left            =   1920
      Style           =   1  'Graphical
      TabIndex        =   3
      ToolTipText     =   "Calls in loaded data for viewing via Notepad/Wordpad"
      Top             =   840
      Width           =   855
   End
   Begin VB.CommandButton SerialInput 
      BackColor       =   &H0000FFFF&
      Caption         =   "Download Data "
      Height          =   495
      Left            =   1920
      Style           =   1  'Graphical
      TabIndex        =   2
      TabStop         =   0   'False
      ToolTipText     =   "Calls up PIC data download screen"
      Top             =   240
      Width           =   855
   End
   Begin VB.CommandButton Directory 
      BackColor       =   &H0000FFFF&
      Caption         =   "Directory"
      Height          =   495
      Left            =   2880
      Style           =   1  'Graphical
      TabIndex        =   0
      TabStop         =   0   'False
      ToolTipText     =   "Calls up file selection screen"
      Top             =   240
      Width           =   855
   End
   Begin EPESerialControl.EPESerial EPESerial1 
      Left            =   11040
      Top             =   240
      _ExtentX        =   926
      _ExtentY        =   926
   End
   Begin VB.Label Label12 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "File Start"
      Height          =   255
      Left            =   4920
      TabIndex        =   57
      ToolTipText     =   "Set file number at which to start live recording"
      Top             =   840
      Width           =   795
   End
   Begin VB.Label ConnectionLabel 
      Alignment       =   2  'Center
      BackColor       =   &H000080FF&
      Caption         =   "Connection Lost"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   9000
      TabIndex        =   55
      ToolTipText     =   "Can be double-clicked to close when recording stopped"
      Top             =   240
      Visible         =   0   'False
      Width           =   2535
   End
   Begin VB.Label Label7 
      Alignment       =   2  'Center
      Caption         =   "Running in Test Mode"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   495
      Left            =   4800
      TabIndex        =   52
      Top             =   240
      Visible         =   0   'False
      Width           =   4215
   End
   Begin VB.Label Label17 
      Alignment       =   2  'Center
      BackColor       =   &H0000FF00&
      Caption         =   "Detail"
      Height          =   255
      Left            =   960
      TabIndex        =   47
      Top             =   840
      Visible         =   0   'False
      Width           =   735
   End
   Begin VB.Label Label16 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Caption         =   "Markers"
      Height          =   255
      Left            =   7320
      TabIndex        =   44
      ToolTipText     =   "Indicates the time between white graph markers"
      Top             =   840
      Width           =   1335
   End
   Begin VB.Label Markers 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Height          =   375
      Left            =   7320
      TabIndex        =   43
      ToolTipText     =   "Indicates the time between white graph markers"
      Top             =   1080
      Width           =   1335
   End
   Begin VB.Label Label15 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Caption         =   "Max File Qty"
      Height          =   255
      Left            =   5760
      TabIndex        =   42
      ToolTipText     =   "The max number of recording files that can be generated (max = 256 = approx 358.4 Mbytes)"
      Top             =   840
      Width           =   1455
   End
   Begin VB.Label Label13 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Caption         =   "Live Recording Sample Rate"
      Height          =   255
      Left            =   4920
      TabIndex        =   41
      ToolTipText     =   "Selects/displays your sample rate "
      Top             =   240
      Width           =   2295
   End
   Begin VB.Label Label11 
      Alignment       =   2  'Center
      Caption         =   "While recording, a response delay of about 2 secs may be experienced   "
      ForeColor       =   &H00C00000&
      Height          =   855
      Left            =   120
      TabIndex        =   37
      Top             =   840
      Visible         =   0   'False
      Width           =   1575
   End
   Begin VB.Label Label10 
      Alignment       =   2  'Center
      Caption         =   " Live Record"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   735
      Left            =   240
      TabIndex        =   36
      Top             =   120
      Visible         =   0   'False
      Width           =   1335
   End
   Begin VB.Label Label9 
      Alignment       =   2  'Center
      Caption         =   "No File Selected Yet"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   855
      Left            =   8760
      TabIndex        =   27
      Top             =   480
      Width           =   2655
   End
   Begin VB.Label Label8 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "7"
      Height          =   255
      Index           =   7
      Left            =   1680
      TabIndex        =   26
      Top             =   6960
      Width           =   135
   End
   Begin VB.Label Label8 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "6"
      Height          =   255
      Index           =   6
      Left            =   1680
      TabIndex        =   25
      Top             =   6240
      Width           =   135
   End
   Begin VB.Label Label8 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "5"
      Height          =   255
      Index           =   5
      Left            =   1680
      TabIndex        =   24
      Top             =   5520
      Width           =   135
   End
   Begin VB.Label Label8 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "4"
      Height          =   255
      Index           =   4
      Left            =   1680
      TabIndex        =   23
      Top             =   4800
      Width           =   135
   End
   Begin VB.Label Label8 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "3"
      Height          =   255
      Index           =   3
      Left            =   1680
      TabIndex        =   22
      Top             =   4080
      Width           =   135
   End
   Begin VB.Label Label8 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "2"
      Height          =   255
      Index           =   2
      Left            =   1680
      TabIndex        =   21
      Top             =   3360
      Width           =   135
   End
   Begin VB.Label Label8 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "1"
      Height          =   255
      Index           =   1
      Left            =   1680
      TabIndex        =   20
      Top             =   2640
      Width           =   135
   End
   Begin VB.Label Label8 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "0"
      Height          =   255
      Index           =   0
      Left            =   1680
      TabIndex        =   19
      Top             =   1920
      Width           =   135
   End
   Begin VB.Label Label6 
      Caption         =   "6"
      Height          =   255
      Left            =   3840
      TabIndex        =   18
      Top             =   240
      Visible         =   0   'False
      Width           =   855
   End
   Begin VB.Label Label4 
      Caption         =   "4"
      Height          =   255
      Left            =   3840
      TabIndex        =   17
      Top             =   960
      Visible         =   0   'False
      Width           =   855
   End
   Begin VB.Label Label3 
      Caption         =   "3"
      Height          =   255
      Left            =   3840
      TabIndex        =   16
      Top             =   1200
      Visible         =   0   'False
      Width           =   855
   End
   Begin VB.Label Label2 
      Caption         =   "2"
      Height          =   255
      Left            =   3840
      TabIndex        =   15
      Top             =   720
      Visible         =   0   'False
      Width           =   1095
   End
   Begin VB.Label Label1 
      Caption         =   "1"
      Height          =   255
      Left            =   3840
      TabIndex        =   14
      Top             =   480
      Visible         =   0   'False
      Width           =   855
   End
   Begin VB.Label Label5 
      Alignment       =   2  'Center
      Caption         =   "Loaded Disk File"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   255
      Left            =   8760
      TabIndex        =   1
      Top             =   240
      Width           =   2655
   End
   Begin VB.Shape Shape3 
      BorderColor     =   &H00FF0000&
      BorderWidth     =   2
      Height          =   1455
      Left            =   1800
      Shape           =   4  'Rounded Rectangle
      Top             =   120
      Width           =   9855
   End
End
Attribute VB_Name = "Seismograph"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Sub Form_Load()

OCXport = 1: Option1(OCXport - 1).Value = True: SampleRate = 1: Zone = 0
MaxDiskCount = 1: DiskStart = 0

B = 25
For A = 1 To 6: C = CInt(B * 100) / 100: ' 11
tempC$ = LTrim$(Str$(C)): If C < 1 Then tempC$ = "0" & tempC$
tempC$ = Left$(tempC$ + "Hz        ", 7) & "= "
D = B * 3600: Combo1.AddItem tempC$ & Int(D) & " per hour": B = B / 2
Next

For A = 1 To 256
Combo2.AddItem A & " = " & A * 1.4 & "MB"
Combo3.AddItem A - 1
Next

Month$(1) = "Jan": Month$(2) = "Feb": Month$(3) = "Mar": Month$(4) = "Apr"
Month$(5) = "May": Month$(6) = "Jun": Month$(7) = "Jul": Month$(8) = "Aug"
Month$(9) = "Sep": Month$(10) = "Oct": Month$(11) = "Nov": Month$(12) = "Dec"

Seismograph.Show
'Seismograph.Refresh

OpenFile = "An unknown problem exists right at the start of loading Seismograph.EXE"
On Error GoTo FatalError: 'set error handler

newuser = 0:
ErrorMessage$ = "This error has been intercepted by the PC System, not by the Seismograph program."
ErrorMessage$ = ErrorMessage$ & "If the problem persists please report its details and circumstances of it occurring to John Becker at EPE"
defaulterror$ = ErrorMessage$
tempA$ = "No File Selected Yet"
InputFile(0) = tempA$: NamedFile(0) = tempA$: InputSize(0) = 0
InputFile(1) = tempA$: NamedFile(1) = tempA$: InputSize(1) = 0

DefaultDrive = "C:\"
DirComboText = "C:\"
SeismographDir.Combo1.Text = DirComboText

PicPath = 0: PrevPicPath = 2

On Error GoTo HistoryError
OpenFile = "Cannot find SeismographHistory.txt"
Open "SeismographHistory.txt" For Input As #1: Close

On Error GoTo SettingsError
OpenFile = "Cannot find SeismographSettings.txt"
Open "SeismographSettings.txt" For Input As #1: Close

GetSettings:

Open "SeismographSettings.txt" For Input As #1

Line Input #1, tempA$: SampleRate = Val(tempA$)
Line Input #1, tempA$: DriveC$ = tempA$:
Line Input #1, tempA$: DirComboText = tempA$
Line Input #1, tempA$: InputFile(0) = tempA$
Line Input #1, tempA$: NamedFile(0) = tempA$
Line Input #1, tempA$: InputFile(1) = tempA$
Line Input #1, tempA$: NamedFile(1) = tempA$
Line Input #1, tempA$: PicPath = Val(tempA$)
Line Input #1, tempA$: MaxDiskCount = Val(tempA$)
If MaxDiskCount < 1 Then MaxDiskCount = 1
If MaxDiskCount > 256 Then MaxDiskCount = 256
Line Input #1, tempA$: OCXport = Val(tempA$)
If OCXport = 0 Then OCXport = 1
Option1(OCXport - 1).Value = True
Close

Combo1.ListIndex = SampleRate
Combo2.ListIndex = MaxDiskCount - 1

On Error GoTo showerror
OpenFile = "Problem trying to allocate default drive path"

DefaultDrive = DriveC$: Drive1 = DriveC$

If UCase$(Left$(DriveC$, 3)) <> DefaultDrive Then DriveC$ = DefaultDrive

OpenFile = "Cannot correctly access Directory Default Drive path  " & DefaultDrive

SeismographDir.Drive1.Drive = DefaultDrive
OpenFile = "Cannot correctly access Directory (Drive C$) path  " & DriveC$
SeismographDir.Dir1.Path = DriveC$

HistoryQ = 0:
OpenFile = "Cannot find SeismographHistory.txt file, or its data is corrupted"
Open "SeismographHistory.txt" For Input As #1
getit3: If EOF(1) = 0 Then
  Line Input #1, tempA$
  If tempA$ <> "" And tempA$ <> History(HistoryQ) Then
  HistoryQ = HistoryQ + 1: History(HistoryQ) = tempA$
  SeismographDir.Combo1.AddItem tempA$
  End If
GoTo getit3
End If
OpenFile = ""
SeismographDir.Combo1.Text = DirComboText
SeismographDirPath(PicPath) = DirComboText
Close

On Error GoTo NewUserError: 'set error handler used to check if prog has been run before
Open "ClearSeismograph.txt" For Input As #1: Close

On Error GoTo 0


Exit Sub

'.............

NewUserError:
Close: Open "ClearSeismograph.txt" For Output As #2
Print #2, "Seismograph first loaded " & Date$ & " " & Time$: Close
DriveC$ = "C:\": newuser = 1
Close:
Open "SeismographHistory.txt" For Output As #2: Print #2, "C:\": Close
Call SaveDefaults
SeismographDir.Combo1.Text = DirComboText: SeismographDirPath(PicPath) = DirComboText
Resume Next

SettingsError:
Close: Call SaveDefaults
Resume Next

HistoryError:
Close: Open "SeismographHistory.txt" For Output As #2: Print #2, "C:\": Close
SeismographDir.Combo1.Text = DirComboText: SeismographDirPath(PicPath) = DirComboText
Resume Next

showerror:
Close: Call SeismographShowError.waitresponse
Resume enderror
enderror:
Exit Sub

FatalError:
Beep
tempB$ = "A non-recoverable error has occurred during program loading and involves the following Earth Resistivity generated statement:"
tempB$ = tempB$ & Chr(13) & Chr(13) & OpenFile
tempB$ = tempB$ & Chr(13) & Chr(13) & "Please check that all the Earth Resistivity files are in the same folder (directory) as the program you are now trying to run. The folder must be on the Hard Drive."
tempB$ = tempB$ & Chr(13) & Chr(13) & "If the data is corrupted re-copy the file of the same name from your original disk or FTP download."
tempB$ = tempB$ & Chr(13) & Chr(13) & "If you cannot resolve the problem please advise John Becker of the details via the EPE Editorial Office (not via the Chat Zone)."
tempB$ = tempB$ & Chr(13) & Chr(13) & "The loading has been aborted and you will be returned to the previous screen."
MsgBox tempB$, vbCritical
End

End Sub

Public Sub SaveDefaults()
Close: Open "SeismographSettings.txt" For Output As #2
If Len(DriveC$) <> 3 Then DriveC$ = "C:\"

Print #2, Combo1.ListIndex & " Sample rate index value"
Print #2, DriveC$
Print #2, SeismographDir.Combo1.Text
Print #2, InputFile(0): Print #2, NamedFile(0)
Print #2, InputFile(1): Print #2, NamedFile(1)
Print #2, PicPath
Print #2, MaxDiskCount
Print #2, OCXport & " OCX port value"
Close
End Sub

Private Sub Drive1_Change()
PicPath = 0: FileName = "*.TXT":
DefaultDrive = UCase$(Drive1.Drive) & "\"
DriveC$ = DefaultDrive
SeismographDir.Combo1.AddItem DriveC$
SeismographDir.Drive1.Drive = Drive1.Drive
SeismographDir.Dir1.Path = DriveC$
PrevPicPath = 0
Call SaveDefaults
PicPath = 0: FileName = DriveC$ & "*.TXT":
SeismographDir.Show
Call SeismographDir.dirshow
Label9.Caption = NamedFile(PicPath)
End Sub

Private Sub Directory_Click()
If Timer1.Enabled = True Then Exit Sub
If Timer2.Enabled = True Then Exit Sub
If Timer3.Enabled = True Then Exit Sub
If Timer4.Enabled = True Then Exit Sub

On Error GoTo showerror

FileName = "*.TXT"
If SeismographDir.Combo1.ListCount = 0 Then
SeismographDir.Combo1.Clear
For A = 1 To HistoryQ: SeismographDir.Combo1.AddItem History(A): Next
SeismographDir.Combo1.Text = DirComboText
End If

If SeismographDirPath(PicPath) = "" Then SeismographDirPath(PicPath) = DefaultDrive
OpenFile = SeismographDirPath(PicPath)

SeismographDir.Show
If PicPath <> PrevPicPath Then
If SeismographDirPath(PicPath) <> DefaultDrive Then SeismographDir.Dir1.Path = SeismographDirPath(PicPath)
Call SeismographDir.dirshow
PrevPicPath = PicPath: FilePath = InputFile(PicPath)
End If
Exit Sub

showerror:
If Err.Number = 68 Or Err.Number = 71 Or Err.Number = 76 Then
ErrorMessage = "Drive not ready for" & Chr(13) & OpenFile
Style = vbRetryCancel + vbExclamation
response = MsgBox(ErrorMessage, Style)
  If response = vbCancel Then
  SeismographDirPath(PicPath) = DefaultDrive
  OpenFile = SeismographDirPath(PicPath)
  Resume here
here:   Exit Sub
  End If

Resume
  Beep
  End If

SeismographShowError.Show
Call SeismographShowError.waitresponse
Resume enderror
enderror:
SeismographDir.Hide

End Sub

Private Sub AllFilesDir_Click()
SeismographDir.Show
End Sub

Private Sub List1_Click()
A = List1.ListIndex
If A < 2 Then
Call InputSamples
Exit Sub

End If
tempB$ = Left$(List1.Text, 8)
Call ExpandTrace

End Sub

Private Sub List2_Click(Index As Integer)
If Timer1.Enabled = True Then Exit Sub

tempB$ = Left$(List2(Index).Text, 9)
If Left$(tempB$, 1) = "S" Then
InputFile(PicPath) = "seismo" & Val(Mid$(tempB$, 2)) & ".txt"
NamedFile(PicPath) = "seismo" & Val(Mid$(tempB$, 2)) & ".txt"
Call InputSamples
End If
End Sub

Private Sub List3_dblClick()
If Timer1.Enabled = True Then Exit Sub
ConnectionLabel.Visible = False: List3.Visible = False
End Sub

Private Sub Option1_Click(Index As Integer)
If Timer1.Enabled = True Then Exit Sub
If Timer2.Enabled = True Then Exit Sub
If Timer3.Enabled = True Then Exit Sub
If Timer4.Enabled = True Then Exit Sub

OCXport = Index + 1:
Call SaveDefaults
End Sub

Private Sub Option2_Click(Index As Integer)
SampleRate = 2 ^ Index
End Sub

Private Sub RunIt_Click()
TestInput.Visible = False
Combo1.Enabled = False
Combo2.Enabled = False
PICrate.Visible = False
EEPROMclear.Visible = False

Label17.Visible = False
Check1.Visible = False

If Timer1.Enabled = False Then
List3.Visible = False
ConnectionFlag = 0: List3.Clear
ConnectionLabel.Visible = False

RunIt.Caption = " Record Stop"
RunIt.BackColor = &HFF00FF
Label10.Caption = " Live Record"
Label11.Visible = True
Command1(0).Visible = False
Command1(1).Visible = False
Command2.Visible = False
Check2.Visible = False
'Label19.Visible = False

Timer1.Enabled = True
Call StartRecord

Else
RunIt.Caption = " Record Start"
RunIt.BackColor = &HFF00&
Timer1.Enabled = False
EPESerial1.PortStatus = sioPortClosed
tempC$ = Combo1.Text
Print #1, Time$
Close
'Check2.Visible = True
Label10.Caption = "": '"Record Ended "
Label11.Visible = False
Command1(0).Visible = True
Command1(1).Visible = True
Command2.Visible = True
'Label19.Visible = True
PICrate.Visible = True
EEPROMclear.Visible = True
Label1.Visible = False
Label2.Visible = False
Label3.Visible = False
Label4.Visible = False
Label6.Visible = False
Combo1.Enabled = True
Combo2.Enabled = True
TestInput.Visible = True
End If

End Sub

Private Sub SerialInput_Click()
If Timer1.Enabled = True Then Exit Sub
If Timer2.Enabled = True Then Exit Sub
If Timer3.Enabled = True Then Exit Sub
If Timer4.Enabled = True Then Exit Sub

DownloadFlag2 = 0

SeismographOCX.ProgressBar1.Value = 0
SeismographOCX.Show

End Sub

Private Sub Timer1_Timer()
Call ReceiveSeismoData
End Sub

Private Sub ViewData_Click()
If Timer1.Enabled = True Then Exit Sub
If Timer2.Enabled = True Then Exit Sub
If Timer3.Enabled = True Then Exit Sub
If Timer4.Enabled = True Then Exit Sub

On Error GoTo showerror

fname = InputFile(PicPath)
If fname = "No File Selected Yet" Then
Beep
MsgBox fname, vbExclamation
Exit Sub
End If

OpenFile = fname

Open fname For Input As #1: Close
processid = Shell("Notepad " & fname, vbNormalFocus)
OpenFile = ""

Exit Sub

showerror:
SeismographShowError.Show
Call SeismographShowError.waitresponse
Resume enderror
enderror:

End Sub

Public Sub InputSamples()
If InputFile(PicPath) = "No File Selected Yet" Then
Label9.Caption = "No File Selected Yet"
Call SaveDefaults
Exit Sub
Else
Label9.Caption = NamedFile(PicPath) & " " & FileDateTime(InputFile(PicPath)) & " " & FileLen(InputFile(PicPath)) & " bytes"
End If

Label16.Caption = "Markers"
Label1.Visible = False
Label2.Visible = False
Label3.Visible = False
Label4.Visible = False
Label5.Visible = True
Label6.Visible = False
Label9.Visible = True
Label10.Visible = False
Label17.Visible = True
Check1.Visible = True
Check2.Visible = True
List1.Clear
List1.Visible = True


If Check2.Value = 0 Then
For A = 0 To 7
List2(A).Visible = False
Picture1(A).Cls
Picture1(A).ScaleWidth = 45000 - 100
Picture1(A).AutoRedraw = False
Picture1(A).Refresh
Next
Else
For A = 0 To 7
List2(A).Visible = False
Picture1(A).Cls
Picture1(A).ScaleWidth = 360000
Picture1(A).AutoRedraw = False
Picture1(A).Refresh
Next
End If

On Error GoTo showerror

OpenFile = InputFile(PicPath)
Open InputFile(PicPath) For Input As #1: L = LOF(1)
If L = 0 Then
Beep
Screen.MousePointer = vbDefault
Label6.Caption = "No File Selected Yet"
InputFile(PicPath) = "No File Selected Yet"
MsgBox "This file seems to be empty and input has been aborted", vbExclamation
Close
Exit Sub
End If

Line Input #1, tempA$:
Line Input #1, tempB$: Ln = 16384
Close

List1.Clear

If Mid$(tempA$, 35) <> "" Then
Ln = 12000
MarkerVal = Ln / 4
V = Val(Mid$(tempA$, 35))
List1.AddItem Mid$(tempA$, 35)
If Check2.Value = 0 Then
Markers.Caption = "Approx " & (MarkerVal / V) \ 60 & " min"
Else
Markers.Caption = "None"
End If

Else
MarkerVal = 4160
List1.AddItem Mid$(tempA$, 13)
B = Val(Mid$(tempA$, 8)) * MarkerVal
hours = B \ 3600
mins = (B - (hours * 3600)) \ 60
secs = B - (hours * 3600) - (mins * 60)
If Check2.Value = 0 Then
Markers.Caption = hours & "Hr " & mins & "min " & secs & "sec Approx"
Else
Markers.Caption = "None"
End If

End If
List1.AddItem Left$(tempA$, 10) & "  Zone"
Markers.Refresh: T = 0

A = 0: X = 0: Zone = 0: ZoneSeg = 0: Picture1(Zone).PSet (X, 512), vbBlue

Open InputFile(PicPath) For Input As #1: L = LOF(1)
Line Input #1, tempA$

GetIt: If EOF(1) Then Close: GoTo Endgetit
Line Input #1, tempA$: T = 0
If Len(tempA$) < 8 Then GoTo GetIt
If Check2.Value = 0 Then
List1.AddItem Right$(tempA$, 8) & "      " & Zone & " / " & ZoneSeg: ' List1.Refresh
End If

For C = 1 To Len(tempA$) - 9 Step (4 * 100)

Y = 0
For D = C To C + (4 * 100) Step 4
Y = Y Or Val(Mid$(tempA$, C, 3))
Next
If Check1.Value = 1 Then Y = (Y * 4) - 1500
Picture1(Zone).Line -(X, Y), vbBlue
X = X + 100: T = T + 1
If X > Picture1(Zone).ScaleWidth Then
X = 0: Zone = (Zone + 1): ' And 7
List1.Refresh
If Zone > 7 Then Close: Exit Sub
ZoneSeg = -1
Picture1(Zone).Cls: Picture1(Zone).PSet (X, Y), vbBlue
End If
Next

If Check2.Value = 0 Then
Picture1(Zone).Line (X, 0)-(X, 1100), vbWhite
Picture1(Zone).PSet (X, Y), vbBlue
ZoneSeg = ZoneSeg + 1
End If
GoTo GetIt
Endgetit:
Picture1(Zone).Line (X, 0)-(X, 1100), vbRed

Screen.MousePointer = vbDefault
List1.Refresh
Exit Sub

showerror:
Screen.MousePointer = vbDefault

If Err.Number = 68 Or Err.Number = 71 Or Err.Number = 76 Then
ErrorMessage = "Drive not ready for" & Chr(13) & OpenFile
Style = vbRetryCancel + vbExclamation
response = MsgBox(ErrorMessage, Style)
  If response = vbCancel Then
  SeismographDirPath(PicPath) = DefaultDrive
  OpenFile = SeismographDirPath(PicPath)
  Resume here
here:   Exit Sub
  End If

Resume
  Beep
  End If

SeismographShowError.Show
Call SeismographShowError.waitresponse
Resume enderror
enderror:
End Sub

Public Sub StartRecord()
    'On Error GoTo ErrorHandler
    Dim bError                          As Boolean
    Dim sDataBlock                      As String
    Dim A, B, C, D, E, F, L As Long
 
List1.Visible = False

For A = 0 To 7
List2(A).Clear
List2(A).Visible = True
Picture1(A).ScaleWidth = 270000 / (2 ^ Combo1.ListIndex)
Picture1(A).AutoRedraw = True
Picture1(A).Cls
Picture1(A).Refresh
Next
Markers.Caption = "Approx " & 15 * (2 ^ Combo1.ListIndex) & " mins"
List2(0).AddItem "S" & DiskStart & " =" & Time$ & " " & Left$(Date$, 6) & Right$(Date$, 2)

Label1.Visible = True
Label2.Visible = True
Label3.Visible = True
Label4.Visible = True
Label5.Visible = False
Label6.Visible = True
Label9.Visible = False
Label10.Visible = True
 
 Zone = 0: X = 0: DiskNumber = DiskStart: FileNumber = 0: LineLenCount = 0: FileCount = 0
 MarkerCount = 0
 Picture1(Zone).PSet (X, 512), vbBlue
 Label6.Caption = Date$
 Label1.Caption = Time$
 Label4.Caption = Time$
 Label3.Caption = 0
 
 
 Open "SeismoPowerLoss.txt" For Output As #2
Print #2, "File start time        " & Date$ & " " & Time$

Label2.Caption = "Seismo" & DiskStart & ".txt"
Open "Seismo" & DiskStart & ".txt" For Output As #1
Print #1, Date$ & " " & Time$ & " Sample rate = " & Combo1.Text
    bError = False
    
    With EPESerial1
        .RxBlockSize = 100
        .RxMode = sioBlockMode
        .ComPort = OCXport
        .Speed = sio9600       ' Setup the COM port parameters
        .WordLength = sio8Bits
        .Parity = sioNoParity
        .StopBits = sio1Bit
        .RxEvents = False       ' Make sure this is off else we will lose the contents of the RXBuffer after every event
        .ProgressEvents = False
        .TimeOut = 2            ' PIC must always respond within 2 seconds
        .PortStatus = sioPortOpen
        .ClearReceiveBuffer     ' Always do this after we open the port to make sure the buffer is really empty
        Exit Sub
        
ErrorHandler:
        Close
    MsgBox "An error occured - " & Err.Description, vbOKOnly + vbCritical
    On Error Resume Next
    EPESerial1.PortStatus = sioPortClosed
End With

End Sub

Private Sub ReceiveSeismoData()
   With EPESerial1
   sDataBlock = .ReceiveText
   If sDataBlock <> "" Then
   GoSub Showgraph
   If ConnectionFlag = 1 Then
   List3.AddItem "Restored at " & Time$ & " " & Date$
   Print #2, "Restored at " & Time$ & " " & Date$ & "  Seismo" & DiskNumber
   ConnectionFlag = 0
   End If
   Else
If ConnectionFlag = 0 Then
   List3.AddItem "Data lost at " & Time$ & " " & Date$
   Print #2, "Data lost at " & Time$ & " " & Date$ & "  Seismo" & DiskNumber
   ConnectionLabel.Visible = True
   List3.Visible = True
   ConnectionFlag = 1
   Print #1, "***," & Time$
   LineLenCount = 0: FileCount = FileCount + 14

Picture1(Zone).Line (X, 0)-(X, 1100), vbBlack
Picture1(Zone).PSet (X, Y), vbBlue
   
   End If
   End If
   End With
Exit Sub
    
Showgraph:
E = Len(sDataBlock)
B = 2: C = Asc(Left$(sDataBlock, 1)): If (C And 128) = 128 Then B = 1

For D = B To E Step (2 * SampleRate)

A1 = (Asc(Mid$(sDataBlock, D, 1)) And 127) * 128
If Mid$(sDataBlock, D + 1, 1) <> "" Then A2 = Asc(Mid$(sDataBlock, D + 1, 1))
Y = A1 + A2
If Y > 999 Then Y = 999
Y = 999 - Y
Picture1(Zone).Line -(X, Y), vbBlue
Print #1, Right$("  " & Y, 3) & ",";

X = X + 1
If X >= Picture1(Zone).ScaleWidth Then
X = 0: Zone = (Zone + 1) And 7
Picture1(Zone).Cls: Picture1(Zone).PSet (X, Y), vbBlue
List2(Zone).Clear: List2(Zone).AddItem "S" & DiskNumber & " Cont " & Time$ & " " & Date$
End If

FileCount = FileCount + 4
LineLenCount = LineLenCount + 4
MarkerCount = MarkerCount + 1

If LineLenCount >= 12000 Then
Print #1, Time$
LineLenCount = 0: FileCount = FileCount + 10
End If

Next

Label3.Caption = FileCount
If MarkerCount >= 22500 Then
MarkerCount = 0
Picture1(Zone).Line (X, 0)-(X, 1100), vbWhite
Picture1(Zone).PSet (X, Y), vbBlue
End If

If FileCount > 1440000 Then
Picture1(Zone).Line (X, 0)-(X, 1100), vbRed
Picture1(Zone).PSet (X, Y), vbBlue

DiskNumber = DiskNumber + 1
If DiskNumber = MaxDiskCount Then DiskNumber = 0
List2(Zone).AddItem "S" & DiskNumber & " = " & Time$ & " " & Left$(Date$, 6) & Right$(Date$, 2): 'Date$
LineLenCount = 0
Print #1, Time$: Close 1
FileCount = 0
Open "Seismo" & DiskNumber & ".txt" For Output As #1
Print #1, Date$ & " " & Time$ & " Sample rate = " & Combo1.Text
Label2.Caption = "Seismo" & DiskNumber & ".txt"
End If

Label4.Caption = Time$

Return

End Sub

Public Sub ExpandTrace()
Label16.Caption = "Markers"
'Label14.Visible = True
'Label14.Refresh
Check1.Visible = True
'On Error GoTo showerror

OpenFile = InputFile(PicPath)

Open InputFile(PicPath) For Input As #1: L = LOF(1)
If L = 0 Then
Beep
Screen.MousePointer = vbDefault
'Label14.Visible = False
Label6.Caption = "No File Selected Yet"
InputFile(PicPath) = "No File Selected Yet"
MsgBox "This file seems to be empty and input has been aborted", vbExclamation

Close
Exit Sub
End If

Line Input #1, tempA$

If Mid$(tempA$, 35) <> "" Then
V = Val(Mid$(tempA$, 35))
Markers.Caption = "Approx " & 25 \ V & " sec"
Else
V = Val(Mid$(tempA$, 8))
Markers.Caption = "Approx " & 25 * V & " sec"
End If

Markers.Refresh

Line Input #1, tempA$

'Ln = ((Len(tempA$) - 8) / 4) / 8
'If Ln < 1 Then Ln = 1
lx = Ln / 32

For A = 0 To 7
List1.Visible = True
Picture1(A).Cls
Picture1(A).ScaleWidth = lx: 'Ln
Picture1(A).AutoRedraw = False
Picture1(A).Refresh
Next

Close

A = 0: X = 0: Zone = 0: Picture1(Zone).PSet (X, 512), vbBlue: T = 0
Open InputFile(PicPath) For Input As #1: L = LOF(1)

For A = 0 To List1.ListIndex - 1
GetIt: If EOF(1) Then Close: GoTo hereJ
Line Input #1, tempA$
Next

Close
W = 0
For C = 1 To Len(tempA$) - 8 Step 4
Y = Val(Mid$(tempA$, C, 3))
'Y = 500
If Check1.Value = 1 Then Y = (Y * 4) - 1500
Picture1(Zone).Line -(X, Y), vbBlue
T = T + 1: W = W + 1
If T = 25 Then
Picture1(Zone).Line (X, 0)-(X, 1100), vbWhite
Picture1(Zone).PSet (X, Y), vbBlue: T = 0
End If

X = X + 1
If X >= Picture1(Zone).ScaleWidth Then
X = 0: Zone = (Zone + 1): ' And 7
If Zone > 7 Then Exit For
If Zone <> 0 Then Picture1(Zone).Cls: Picture1(Zone).PSet (X, Y), vbBlue
End If
Next
hereJ:
'Label14.Visible = False
'Label14.Refresh
Screen.MousePointer = vbDefault

Exit Sub

showerror:
Screen.MousePointer = vbDefault
'Label14.Visible = False
'Label14.Refresh

If Err.Number = 68 Or Err.Number = 71 Or Err.Number = 76 Then
ErrorMessage = "Drive not ready for" & Chr(13) & OpenFile
Style = vbRetryCancel + vbExclamation
response = MsgBox(ErrorMessage, Style)
  If response = vbCancel Then
  SeismographDirPath(PicPath) = DefaultDrive
  OpenFile = SeismographDirPath(PicPath)
  Resume here
here:   Exit Sub
  End If

Resume
  Beep
  End If

SeismographShowError.Show
Call SeismographShowError.waitresponse
Resume enderror
enderror:
End Sub

Private Sub Combo1_click()
If Timer1.Enabled = True Then Exit Sub
If Timer2.Enabled = True Then Exit Sub
If Timer3.Enabled = True Then Exit Sub
If Timer4.Enabled = True Then Exit Sub

SampleRate = 2 ^ Combo1.ListIndex
Call SaveDefaults
Directory.SetFocus
End Sub

Private Sub Combo2_click()
If Timer1.Enabled = True Then Exit Sub
If Timer2.Enabled = True Then Exit Sub
If Timer3.Enabled = True Then Exit Sub
If Timer4.Enabled = True Then Exit Sub

A = Combo2.ListIndex
MaxDiskCount = A + 1
Call SaveDefaults
Directory.SetFocus
End Sub

Private Sub Check1_Click()
If TestColour = vbBlue Then TestColour = vbBlack Else TestColour = vbBlue
End Sub

Private Sub Label17_Click()
If TestColour = vbBlue Then TestColour = vbBlack Else TestColour = vbBlue
End Sub

Private Sub command2_Click()

Label16.Caption = "Markers"
Command1(0).Visible = True
Command1(1).Visible = True
NamedFile(PicPath) = "seismo0.txt"
InputFile(PicPath) = "seismo0.txt"
Call InputSamples
End Sub

Private Sub Command1_Click(Index As Integer)
On Error GoTo showerror
Label16.Caption = "Markers"

100:
If Index = 0 Then
FileNumber = FileNumber - 1
If FileNumber < 0 Then FileNumber = MaxDiskCount
Else
FileNumber = FileNumber + 1
If FileNumber > MaxDiskCount Then FileNumber = 0
End If

NamedFile(PicPath) = "seismo" & FileNumber & ".txt"
InputFile(PicPath) = "seismo" & FileNumber & ".txt"


Close
OpenFile = InputFile(PicPath)
Open InputFile(PicPath) For Input As #1: L = LOF(1)
Close
Call InputSamples

Exit Sub


showerror:
Close
If Err.Number = 53 Then
ErrorMessage = "File not found at stated location"
Resume 100
End If

SeismographShowError.Show
Call SeismographShowError.waitresponse
Resume enderror
enderror:

End Sub

Private Sub TestInput_Click()
If Timer1.Enabled = True Then Exit Sub
If Timer3.Enabled = True Then Exit Sub
If Timer4.Enabled = True Then Exit Sub

If Timer2.Enabled = False Then
List3.Visible = False
ConnectionFlag = 0: List3.Clear
ConnectionLabel.Visible = False
Label12.Visible = False
Combo3.Visible = False
PICrate.Visible = False
EEPROMclear.Visible = False
TestInput.Caption = "Stop"
Check2.Visible = False
Timer2.Enabled = True
Label1.Visible = False
Label2.Visible = False
Label3.Visible = False
Label4.Visible = False
Label5.Visible = False
Label6.Visible = False
Label7.Visible = True
Label9.Visible = False
Label10.Visible = False
Label13.Visible = False
Label15.Visible = False
Label16.Visible = False
Label17.Visible = True
Combo1.Visible = False
Combo2.Visible = False
Option1(0).Visible = False
Option1(1).Visible = False
Check1.Value = 0
Check1.Visible = True
SerialInput.Visible = False
Directory.Visible = False
ViewData.Visible = False
RunIt.Visible = False
List1.Visible = False
'Label19.Visible = False
Command2.Visible = False
Command1(0).Visible = False
Command1(1).Visible = False
Markers.Visible = False
For A = 0 To 7: List2(A).Visible = False: Next
TestColour = vbBlue

Call StartTest

Else
TestInput.Caption = " Test Input"
Timer2.Enabled = False
Label5.Visible = True
Label7.Visible = False
Label9.Visible = True
'Label10.Visible = True
Label13.Visible = True
Label15.Visible = True
Combo1.Visible = True
Combo2.Visible = True
Option1(0).Visible = True
Option1(1).Visible = True

Label16.Visible = True
Label17.Visible = False
'If List1.Visible = False Then
Check1.Visible = False
'Check2.Visible = True
SerialInput.Visible = True
Directory.Visible = True
ViewData.Visible = True
RunIt.Visible = True
List1.Visible = True
'Label19.Visible = True
Command2.Visible = True
Command1(0).Visible = True
Command1(1).Visible = True
Markers.Caption = ""
Markers.Visible = True
PICrate.Visible = True
EEPROMclear.Visible = True
Label12.Visible = True
Combo3.Visible = True

End If

End Sub

Public Sub StartTest()
    'On Error GoTo ErrorHandler
    Dim bError                          As Boolean
    Dim sDataBlock                      As String
    Dim A, B, C, D, E, F, L As Long

For A = 0 To 7
Picture1(A).ScaleWidth = 300
Picture1(A).AutoRedraw = False
Picture1(A).Cls
Next
 
Zone = 0: X = 0
 Picture1(Zone).PSet (X, 512), vbBlue
    bError = False
    
    With EPESerial1
        .RxBlockSize = 2
        .RxMode = sioBlockMode
        .ComPort = OCXport
        .Speed = sio9600       ' Setup the COM port parameters
        .WordLength = sio8Bits
        .Parity = sioNoParity
        .StopBits = sio1Bit
        .RxEvents = False       ' Make sure this is off else we will lose the contents of the RXBuffer after every event
        .ProgressEvents = False
        .TimeOut = 1            ' PIC must always respond within 1 second
        .ClearReceiveBuffer     ' Always do this after we open the port to make sure the buffer is really empty
        Exit Sub
        
ErrorHandler:
        Close
    MsgBox "An error occured - " & Err.Description, vbOKOnly + vbCritical
    On Error Resume Next ' We don't want to know about any further errors
    EPESerial1.PortStatus = sioPortClosed
End With

End Sub

Private Sub Timer2_Timer()
Call ReceiveTestData
End Sub

Private Sub ReceiveTestData()
   With EPESerial1
        .PortStatus = sioPortOpen
   sDataBlock = .ReceiveText
        .PortStatus = sioPortClosed
   If sDataBlock <> "" Then
   GoSub Showgraph
       If ConnectionFlag = 1 Then
   List3.AddItem "Restored at " & Time$ & " " & Date$
   ConnectionFlag = 0
   End If
'End If
   Else
If ConnectionFlag = 0 Then
   List3.AddItem "Data lost at " & Time$ & " " & Date$
   ConnectionLabel.Visible = True
   List3.Visible = True
   ConnectionFlag = 1
   End If
End If
   End With
Exit Sub
    
Showgraph:

A1 = Asc(Left$(sDataBlock, 1)): A2 = Asc(Mid$(sDataBlock, 2, 1))

If (A1 And 128) = 128 Then
Y = (A1 And 127) * 128 + A2
Else
Y = (A2 And 127) * 128 + A1:
End If

If Y > 999 Then Y = 999
If Y < 0 Then Y = 0
Y = 999 - Y
If Check1.Value = 1 Then Y = (Y * 4) - 1500
Picture1(Zone).Line -(X, Y), TestColour

X = X + 1
If X >= Picture1(Zone).ScaleWidth Then
X = 0: Zone = (Zone + 1) And 7
Picture1(Zone).Cls: Picture1(Zone).PSet (X, Y), TestColour
End If

Return

End Sub

Private Sub PICrate_Click()

If Timer1.Enabled = True Then Exit Sub
If Timer2.Enabled = True Then Exit Sub
If Timer4.Enabled = True Then Exit Sub

If Timer3.Enabled = False Then
PICrate.Caption = "Stop"
Timer3.Enabled = True
Label16.Caption = "Monitor PIC Rate"
Label16.Visible = True
Markers.Caption = " Press PIC's Rate Switch"
Markers.Visible = True

Call StartPICrate

Else
PICrate.Caption = " PIC Rate"
Timer3.Enabled = False
End If

End Sub

Public Sub StartPICrate()
    'On Error GoTo ErrorHandler
    Dim bError                          As Boolean
    Dim sDataBlock                      As String
    Dim A, B, C, D, E, F, L As Long
    bError = False
    
    With EPESerial1
        .RxBlockSize = 1
        .RxMode = sioBlockMode
        .ComPort = OCXport
        .Speed = sio9600       ' Setup the COM port parameters
        .WordLength = sio8Bits
        .Parity = sioNoParity
        .StopBits = sio1Bit
        .RxEvents = False       ' Make sure this is off else we will lose the contents of the RXBuffer after every event
        .ProgressEvents = False
        .TimeOut = 1            ' PIC must always respond within 1 second
        .ClearReceiveBuffer     ' Always do this after we open the port to make sure the buffer is really empty
        Exit Sub
        
ErrorHandler:
        Close
    MsgBox "An error occured - " & Err.Description, vbOKOnly + vbCritical
    On Error Resume Next
    EPESerial1.PortStatus = sioPortClosed
End With

End Sub

Private Sub ReceivePICrate()
   With EPESerial1
        .PortStatus = sioPortOpen
   sDataBlock = .ReceiveText
        .PortStatus = sioPortClosed
If sDataBlock <> "" Then
Markers.Caption = Asc(Left$(sDataBlock, 1)) & " sec"
End If
   
   End With

End Sub

Private Sub Timer3_Timer()
Call ReceivePICrate
End Sub

Private Sub EEPROMclear_Click()

If Timer1.Enabled = True Then Exit Sub
If Timer2.Enabled = True Then Exit Sub
If Timer3.Enabled = True Then Exit Sub

If Timer4.Enabled = False Then
EEPROMclear.Caption = "Stop"
Timer4.Enabled = True
Markers.Caption = " Waiting Clearance"
Label16.Caption = "Monitor PIC Clear"
Markers.Visible = True
Label16.Visible = True
EchanCount = 0

Call StartPICclear

Else
EEPROMclear.Caption = " PIC Clear"
Timer4.Enabled = False
End If

End Sub

Public Sub StartPICclear()
    'On Error GoTo ErrorHandler
    Dim bError                          As Boolean
    Dim sDataBlock                      As String
    Dim A, B, C, D, E, F, L As Long
    bError = False
    
    With EPESerial1
        .RxBlockSize = 2
        .RxMode = sioBlockMode
        .ComPort = OCXport
        .Speed = sio9600       ' Setup the COM port parameters
        .WordLength = sio8Bits
        .Parity = sioNoParity
        .StopBits = sio1Bit
        .RxEvents = False       ' Make sure this is off else we will lose the contents of the RXBuffer after every event
        .ProgressEvents = False
        .TimeOut = 5
        .ClearReceiveBuffer     ' Always do this after we open the port to make sure the buffer is really empty
        Exit Sub
        
ErrorHandler:
        Close
    MsgBox "An error occured - " & Err.Description, vbOKOnly + vbCritical
    On Error Resume Next
    EPESerial1.PortStatus = sioPortClosed
End With

End Sub

Private Sub ReceivePICclear()
   With EPESerial1
        .PortStatus = sioPortOpen
   sDataBlock = .ReceiveText
        .PortStatus = sioPortClosed
If sDataBlock <> "" Then

A1 = Asc(Left$(sDataBlock, 1)): A2 = Asc(Mid$(sDataBlock, 2, 1))
If (A1 = 255) And (A2 = 255) Then
Call EEPROMclear_Click
Exit Sub
End If

If (A1 And 128) = 128 Then
Y = (A1 And 127) * 128 + A2
Else
Y = (A2 And 127) * 128 + A1:
End If
If Y = 0 Then EchanCount = EchanCount + 1
X = EchanCount And 1: Y = Y + (16384 * X)
Markers.Caption = Y & " Memory " & (EchanCount \ 2 + 1)
End If
   
   End With

End Sub

Private Sub Timer4_Timer()
Call ReceivePICclear
End Sub

Private Sub ConnectionLabel_dblClick()
If Timer1.Enabled = True Then Exit Sub
ConnectionLabel.Visible = False: List3.Visible = False
End Sub

'Seismograph Logger 31DEC03
Private Sub Combo3_Click()
If Timer1.Enabled = True Then Exit Sub
If Timer2.Enabled = True Then Exit Sub
If Timer3.Enabled = True Then Exit Sub
If Timer4.Enabled = True Then Exit Sub

DiskStart = Combo3.ListIndex
RunIt.SetFocus

End Sub

Private Sub Form_Unload(Cancel As Integer)
Close: End
End Sub

