'File: m4-switcher.bas,written in Proton+, version 2.1.5.3
'by K.R.Ginn, dated 17/10/2004,07:35 minus delay loop 
Device 16f84
declare xtal 4 
dim switip as word
input portb.0  'switcher pulse input
output portb.6 'switched output 1
output portb.5 'switched output 2
output portb.2 'switched output 3
output portb.1 'switched output 4
output porta.1 'red led bias
output porta.0 'green led bias
low portb.6 'switched output 1 - low
low portb.5 'switched output 2 - low
low portb.2 'switched output 3 - low
low portb.1 'switched output 4 - low
low porta.1 'red led bias - low
low porta.0 'green led bias - low

delayms 500' switch on delay 0.5 seconds
high porta.1' - switches led to red, invalid pulse

start:
		switip = pulsin portb.0,high  'measure pulse width, input
		if switip >99 then goto loop: else goto fail 
		
loop:
		switip = pulsin portb.0,high  'measure pulse width, input, go loop
		if switip <100 then goto fail 'routine switched on and this is 
	   	if switip >199 then goto fail 'first pulse circuit measures
		if switip >99 then goto validp
		
loop2:
		switip = pulsin portb.0,high  'measure pulse width, input, back in loop
		if switip <100 then goto fail 'measuring pulse after initial or
	   	if switip >199 then goto fail 'continious fail
		if switip >99 then goto workin
		
validp:
		gosub wled
		if switip <120 then goto onone
		if switip <140 then goto ontwo
		if switip <160 then goto neutral
		if switip <180 then goto onthree
		if switip <200 then goto onfour
		
onone:	
		low portb.1' output 4 off
		low portb.2' output 3 off
		low portb.5' output 2 off
		high portb.6' output 1 on		
		goto loop
		
ontwo:
		low portb.6' output 1 off
		low portb.2' output 3 off
		low portb.1' output 4 off
		high portb.5' output 2 on		
		goto loop
		
onthree:
		low portb.6' output 1 off
		low portb.5' output 2 off
		low portb.1' output 4 off
		high portb.2' output 3 on
		goto loop
		
onfour:
		low portb.6' output 1 off
		low portb.5' output 2 off
		low portb.2' output 3 off
		high portb.1' output 4 on		
		goto loop		
	
neutral:
		low portb.1' output 4 off
		low portb.2' output 3 off
		low portb.5' output 2 off
		low portb.6' output 1 off
		gosub wled		
		goto loop	
		
fail:
		gosub offled
		gosub alloff
		goto loop
		
workin:
		switip = pulsin portb.0,high ' added to check and delay return to working
		if switip >99 then goto loop2: else goto fail 
		
wled:	
		low porta.1' red led goes out, valid pulse
		high porta.0' green led illuminates
		return
		
offled:		
		high porta.1' red led illuminates
		low porta.0' green led goes out
		return		
		
alloff:	
		low portb.1' output 4 off
		low portb.2' output 3 off
		low portb.5' output 2 off
		low portb.6' output 1 off	
		return			
		
		end	