;Stepper Motor Driver		
;Uses active low inputs for use with pull-ups		
;Andy Flind		
;08/02/04		
;for PIC16F627/628		
		
__config H'3F30' ;osc = INT(no xtal), wdt = OFF, put = ON (PIC16F627/628)		
		
#DEFINE PAGE0   BCF $03,5		
#DEFINE PAGE1   BSF $03,5		
		
STATUS:	.EQU $03	;general equates
PORTA:	.EQU $05	
PORTB:	.EQU $06	
TRISA:	.EQU $05	
TRISB:	.EQU $06	
PCL:	.EQU $02	
RTCC:	.EQU $01	
OPTION:	.EQU $01	
INTCON:	.EQU $0B	
CMCON:	.EQU $1F	;(needed by PIC16F627/628)
F:	.EQU $01	
W:	.EQU $00	
Z:	.EQU $02	
C:	.EQU $00	
		
STEPS:	.EQU $20	;used to keep track of step count
CTR1:	.EQU $21	
OUTPUT:	.EQU $22	;temp store for output pattern
		
	.ORG $0004	
	.ORG $0005	
		
	GOTO START	
;=============================================================		
FULL	MOVF STEPS,W	;table for FULL operation
	ANDLW B'00000011	
	ADDWF PCL,F	
	RETLW B'00000011	
	RETLW B'00000110	
	RETLW B'00001100	
	RETLW B'00001001	
		
HALF	MOVF STEPS,W	;table for HALF operation
	ANDLW B'00000111	
	ADDWF PCL,F	
	RETLW B'00000001	
	RETLW B'00000011	
	RETLW B'00000010	
	RETLW B'00000110	
	RETLW B'00000100	
	RETLW B'00001100	
	RETLW B'00001000	
	RETLW B'00001001	
		
WAVE	MOVF STEPS,W	;table for WAVE operation
	ANDLW B'00000011	
	ADDWF PCL,F	
	RETLW B'00000001	
	RETLW B'00000010	
	RETLW B'00000100	
	RETLW B'00001000	
;=============================================================		
START:	MOVLW 7	
	MOVWF CMCON	
	CLRF PORTA	
	CLRF PORTB	
	PAGE1	
	MOVLW B'11100000	
	MOVWF TRISA	
	MOVLW B'11110011	
	MOVWF TRISB	
	BCF OPTION,7	;pull-ups enabled
	PAGE 0	
	CLRF PORTB	
	CLRF PORTA	
	CLRF STEPS	
	DECF STEPS,F	;to start with first tabled pattern
;=============================================================
STEP	BTFSS  PORTB,6	;powerdown active?
	CALL TMOUT	;call timeout check subroutine
	BTFSS PORTB,7	;are we doing direction/step mode?
	GOTO DSTEP
	BTFSS PORTB,0	;fwd request?
	GOTO STPA	
	BTFSS PORTB,1	;reverse request?
	GOTO STPA
	GOTO STEP	;no request, check again
STPA	BTFSS PORTB,0	;increment STEPS for forward
	INCF STEPS,F	
	BTFSS PORTB,1	;decrement STEPS for reverse
	DECF STEPS,F	
	CALL OUTPT	
STPB	BTFSS PORTB,6	;if powerdown active, check for timeout
	CALL TMOUT	
	BTFSS PORTB,0	;check if FWD input still active
	GOTO STPB	
	BTFSS PORTB,1	;check if REV input still active
	GOTO STPB	
	GOTO STEP	;return to start
;=============================================================
DSTEP	BTFSC PORTB,1	;is a step called for?
	GOTO STEP	;if not, go back to start
	BTFSC PORTB,0	;direction forward?
	INCF STEPS,F	
	BTFSS PORTB,0	;direction reverse?
	DECF STEPS,F
	CALL OUTPT	
DSTPA	BTFSS PORTB,6	;if powerdown active, check for timeout
	CALL TMOUT	
	BTFSS PORTB,1	;check if step input still active
	GOTO DSTPA	
	GOTO STEP	;return to start
;=============================================================		
OUTPT	CALL FULL	;load FULL into W
	BTFSS PORTB,4	;replace with WAVE if switch active
	CALL WAVE	
	BTFSS PORTB,5	;replace with HALF if switch active
	CALL HALF	
	MOVWF OUTPUT	;store resulting pattern
	BTFSS PORTB,6	;if PWDN active start timer
	CALL TMINIT	;initialise timer on RA4
	MOVF OUTPUT,W	
	MOVWF PORTA	;place pattern on portA
	RETURN	
;=============================================================		
TMINIT	PAGE1	;discharge timing capacitor on RA4
	BCF TRISA,4	
	PAGE0	
	BCF PORTA,4	
	MOVLW 3	
	MOVWF CTR1	
TMIA	DECFSZ CTR1,F	;delay for timing capacitor to discharge
	GOTO TMIA	
	PAGE1	
	BSF TRISA,4	
	PAGE0	;timer up and running...
	RETURN	
;=============================================================		
TMOUT	BTFSC PORTA,4	;clear portA on timeout
	CLRF PORTA	
	RETURN	
;=============================================================		
	.END	
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
