;Stepper Control for Driver		
;Using active low inputs for pull-up operation		
;Andy Flind		
;08/02/04		
;for PIC16F627/628		
		
__config H'3F30' ;osc = INT (no xtal), wdt = OFF, put = ON (PIC16F627/628)		
		
#DEFINE PAGE0   BCF $03,5		
#DEFINE PAGE1   BSF $03,5		
		
STATUS:	.EQU $03	;general equates
PORTA:	.EQU $05	
PORTB:	.EQU $06	
TRISA:	.EQU $05	
TRISB:	.EQU $06	
PCL:	.EQU $02	
RTCC:	.EQU $01	
OPTION:	.EQU $01	
INTCON:	.EQU $0B	
CMCON:	.EQU $1F	;(needed by PIC16F627/628)
F:	.EQU $01	
W:	.EQU $00	
Z:	.EQU $02	
C:	.EQU $00	
		
CTR1:	.EQU $20	;general usage
CTR2:	.EQU $21	;general usage
CTR3:	.EQU $22	;general usage
CTR4:	.EQU $23	;used by timer
		
	.ORG $0004	
	.ORG $0005	
;=============================================================		
	MOVLW 7	
	MOVWF CMCON	
	CLRF PORTA	
	CLRF PORTB	
	PAGE1	
	MOVLW B'11100000
	MOVWF TRISA	
	MOVLW B'10111111	
	MOVWF TRISB	
	BCF OPTION,7	;pull-ups enabled
	PAGE 0	
		
	MOVLW 255	
	MOVWF PORTB
	MOVLW 1
	MOVWF PORTA	
;=============================================================		
READ	BTFSS PORTB,7	;test for direction/step mode
	GOTO DSTEP
	BTFSS PORTB,1	;single forward
	GOTO SFWD	
	BTFSS PORTB,2	;single reverse
	GOTO SREV	
	BTFSS PORTB,0	;continuous forward
	GOTO CFWD	
	BTFSS PORTB,3	;continuous reverse
	GOTO CREV	
	GOTO READ	
;=============================================================		
SFWD	MOVLW 50	;single forward pulse
	MOVWF CTR1	;debounce RB1 on
SFA	MOVLW 50	
	MOVWF CTR2	
SFB	BTFSC PORTB,1	
	GOTO READ	
	DECFSZ CTR2,F	
	GOTO SFB	
	DECFSZ CTR1,F	
	GOTO SFA	
	BCF PORTA,0	;set RA0 active low
SFC	MOVLW 50	;debounce RB1 off
	MOVWF CTR1	
SFD	MOVLW 50	
	MOVWF CTR2	
SFE	BTFSS PORTB,1	
	GOTO SFC	
	DECFSZ CTR2,F	
	GOTO SFE	
	DECFSZ CTR1,F	
	GOTO SFD	
	BSF PORTA,0	;return RA0 high
	GOTO READ	;return to look for next input
;=============================================================		
SREV	MOVLW 50	;single forward pulse
	MOVWF CTR1	;debounce RB2 on
SRA	MOVLW 50	
	MOVWF CTR2	
SRB	BTFSC PORTB,2	
	GOTO READ	
	DECFSZ CTR2,F	
	GOTO SRB	
	DECFSZ CTR1,F	
	GOTO SRA	
	BCF PORTB,6	;set RB6 active low
SRC	MOVLW 50	;debounce RB2 off
	MOVWF CTR1	
SRD	MOVLW 50	
	MOVWF CTR2	
SRE	BTFSS PORTB,2	
	GOTO SRC	
	DECFSZ CTR2,F	
	GOTO SRE	
	DECFSZ CTR1,F	
	GOTO SRD	
	BSF PORTB,6	;return RB6 high
	GOTO READ	;return to look for next input
;=============================================================		
CFWD	MOVLW 50	;continuous forward pulses
	MOVWF CTR1	;debounce RB0 on
CFA	MOVLW 50	
	MOVWF CTR2	
CFB	BTFSC PORTB,0	
	GOTO READ	
	DECFSZ CTR2,F	
	GOTO CFB	
	DECFSZ CTR1,F	
	GOTO CFA	
CFC	BCF PORTA,0	;RA0 active low
	BSF PORTA,1	;RA1 high for counter or 'scope
	CALL TMR	
	BSF PORTA,0	;RA0 return to high
	BCF PORTA,1	;RA1 return to low
	CALL TMR	
	BTFSS PORTB,0	;check for button release
	GOTO CFC	;no, so keep pulsing
	MOVLW 50	;debounce RB0 off
	MOVWF CTR1	
CFD	MOVLW 50	
	MOVWF CTR2	
CFE	BTFSS PORTB,0	
	GOTO CFC	
	DECFSZ CTR2,F	
	GOTO CFE	
	DECFSZ CTR1,F	
	GOTO CFD	
	GOTO READ	;return to look for next input
;=============================================================		
CREV	MOVLW 50	;continuous reverse pulses
	MOVWF CTR1	;debounce RB3 on
CRA	MOVLW 50	
	MOVWF CTR2	
CRB	BTFSC PORTB,3	
	GOTO READ	
	DECFSZ CTR2,F	
	GOTO CRB	
	DECFSZ CTR1,F	
	GOTO CRA	
CRC	BCF PORTB,6	;RB6 active low
	BSF PORTA,1	;RA1 high for counter or 'scope
	CALL TMR	
	BSF PORTB,6	;RB6 return to high
	BCF PORTA,1	;RA1 return to low
	CALL TMR	
	BTFSS PORTB,3	;check for button release
	GOTO CRC	;no, so keep pulsing
	MOVLW 50	;debounce RB3 off
	MOVWF CTR1	
CRD	MOVLW 50	
	MOVWF CTR2	
CRE	BTFSS PORTB,3	
	GOTO CRC	
	DECFSZ CTR2,F	
	GOTO CRE	
	DECFSZ CTR1,F	
	GOTO CRD	
	GOTO READ	;return to look for next input
;=============================================================	
DSTEP	BTFSS PORTB,2	;is single step active?
	GOTO DSSGL	;single direction/step
	BTFSS PORTB,3	;is continuous step active?
	GOTO DSCTS	;continuous direction/step
	GOTO READ	;return to look for next input
;=============================================================	
DSSGL	BTFSC PORTB,1	;direction/step single step
	BSF PORTA,0	;set up direction output
	BTFSS PORTB,1	
	BCF PORTA,0	
	MOVLW 50	;debounce RB2 on
	MOVWF CTR1	
DSSA	MOVLW 50	
	MOVWF CTR2	
DSSB	BTFSC PORTB,2	
	GOTO READ	
	DECFSZ CTR2,F	
	GOTO DSSB	
	DECFSZ CTR1,F	
	GOTO DSSA	
	BCF PORTB,6	;set RB6 active low
DSSC	MOVLW 50	;debounce RB2 off
	MOVWF CTR1	
DSSD	MOVLW 50	
	MOVWF CTR2	
DSSE	BTFSS PORTB,2	
	GOTO DSSC	
	DECFSZ CTR2,F	
	GOTO DSSE	
	DECFSZ CTR1,F	
	GOTO DSSD	
	BSF PORTB,6	;return RB6 high
	GOTO READ	;return to look for next input
;=============================================================
DSCTS	MOVLW 50	;direction/step continuous
	MOVWF CTR1	;debounce RB3 on
DSCA	MOVLW 50	
	MOVWF CTR2	
DSCB	BTFSC PORTB,3	
	GOTO READ	
	DECFSZ CTR2,F	
	GOTO DSCB	
	DECFSZ CTR1,F	
	GOTO DSCA	
DSCC	BTFSC PORTB,1	;set up direction output
	BSF PORTA,0	
	BTFSS PORTB,1	
	BCF PORTA,0	
	BCF PORTB,6	;RB6 active low
	BSF PORTA,1	;RA1 high for counter or 'scope
	CALL TMR	
	BSF PORTB,6	;RB6 return to high
	BCF PORTA,1	;RA1 return to low
	CALL TMR	
	MOVLW 50	;debounce RB3 off
	MOVWF CTR1	
DSCD	MOVLW 50	
	MOVWF CTR2	
DSCE	BTFSS PORTB,3	
	GOTO DSCC	
	DECFSZ CTR2,F	
	GOTO DSCE	
	DECFSZ CTR1,F	
	GOTO DSCD	
	GOTO READ	;return to look for next input
;=============================================================		
TMR	MOVLW 100	;100 reps, slowest
	BTFSS PORTB,5	
	MOVLW 10	;10 reps, mid range
	BTFSS PORTB,4	
	MOVLW 1	;1 rep, fastest
	MOVWF CTR3	
TMRA	PAGE1	;set RA4 as output
	BCF TRISA,4	
	PAGE0	
	BCF PORTA,4	;set RA4 low
	MOVLW 3	
	MOVWF CTR4	
TMRB	DECFSZ CTR4,F	;allow time for C to discharge
	GOTO TMRB	
	PAGE1	;return RA4 to input
	BSF TRISA,4	
	PAGE0	
TMRC	BTFSS PORTA,4	;wait for timeout
	GOTO TMRC	
	DECFSZ CTR3,F	;repeat as necessary
	GOTO TMRA	
	RETURN	
;=============================================================		
	.END	
