;PSCOP182.ASM 24JUN00 - COPYRIGHT JOHN BECKER - EPE VIRTUAL PIC SCOPE

;PIC16F877-20, 5MHz, WDT OFF, POR ON, XTAL HS

;Config register bits (all PIC Toolkit Mk2 defaults except for OS1 & OS0)
; CP1 CP0 DBG NIL WRT CPD LVP BOR CP1 CP0 POR WDT OS1 OS0
;  1   1   1   1   1   1   0   0   1   1   0   0   1   0
;N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
;respectively - refer to PIC '87 data sheet.

#DEFINE PAGE0   BCF $03,5
#DEFINE PAGE1   BSF $03,5

OPTION:  .EQU $01  ;page 1, 3
PCL:     .EQU $02  ;page 0, 1, 2, 3
STATUS:  .EQU $03  ;page 0, 1, 2, 3

PORTA:   .EQU $05  ;page 0
TRISA:   .EQU $05  ;page 1
PORTB:   .EQU $06  ;page 0, 2
TRISB:   .EQU $06  ;page 1, 3
PORTC:   .EQU $07  ;page 0
TRISC:   .EQU $07  ;page 1
PORTD:   .EQU $08  ;page 0
TRISD:   .EQU $08  ;page 1
PORTE:   .EQU $09  ;page 0
TRISE:   .EQU $09  ;page 1

INTCON:  .EQU $0B  ;page 0, 1, 2, 3
ADRESH:  .EQU $1E  ;page 0

ADCON0:  .EQU $1F  ;page 0
ADCON1:  .EQU $1F  ;page 1

CHAN:   .EQU $25
DELAYA: .EQU $26        ; delay for data send to PC
STEP:   .EQU $27        ; additive step value for playback counter
MEMHI:  .EQU $28        ; msb val ADC
MEMLO:  .EQU $29        ; lsb val ADC
WADDRH: .EQU $2A        ; msb of mem address
WADDRL: .EQU $2B        ; lsb of mem address
LIMIT:  .EQU $2C        ; sample limit value
SLOWIT: .EQU $2D        ; pause counter
CHANGE: .EQU $2E        ; flag for Change command received from PC
CHANGA: .EQU $2F        ; temp store
FOSC:   .EQU $31        ; ADC clock osc rate 0=Fosc/8, 1=Fosc/2

          ; locations up to $7F are available

             ;************************************************************
             ;           Bit Definitions
             ;************************************************************

W:      .EQU 0
F:      .EQU 1
C:      .EQU 0
Z:      .EQU 2

RP0:    .EQU 5           ;STATUS reg
RP1:    .EQU 6           ;STATUS reg
GIE:    .EQU 7           ;INTCON reg
GO:     .EQU 2           ;ADCON0 reg

        .ORG $0004      ;Interrupt vector address
        GOTO GIEOFF     ;Jump to interrupt routine on interrupt
        .ORG $0005      ;Start of program memory

GIEOFF: BCF INTCON,GIE  ;turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START


ROUTE:  ADDWF PCL,F
        goto RESETP       ;0  000  PC orig val 000 = 0 RESET
        goto CHANAB       ;1  001  PC orig val 100 = 4 both chans
        goto CHANA        ;2  010  PC orig val 010 = 2 chan 0
        goto MAX2         ;3  011  PC orig val 110 = 6 2K
        goto INCRATE      ;4  100  PC orig val 001 = 1 change ADC sample rate
        goto MAX32        ;5  101  PC orig val 101 = 5 32K
        goto CHANB        ;6  110  PC orig val 011 = 3 chan 1
        goto MAX0         ;7  111  PC orig val 111 = 7 direct

OUTIT:  ADDWF PCL,F      ;routing for nibble send to PC, etc
        goto SENDLS3     ;0. chan 0 lsb
        goto STEP0       ;1. address step
        goto SENDLS4     ;2. chan 1 lsb
        retlw 1          ;3. nil
        goto SENDMS3     ;4. chan 0 msb
        retlw 2          ;5. nil
        goto SENDMS4     ;6. chan 1 msb
        retlw 1          ;7. nil

OUTIT2: ADDWF PCL,F      ;routing for nibble send to PC, etc
        goto SENDLS3     ;0. chan 0 lsb
        retlw 0          ;1. address step
        goto SENDLS4     ;2. chan 1 lsb
        retlw 1          ;3. nil
        goto SENDMS3     ;4. chan 0 msb
        retlw 0          ;5. address step
        goto SENDMS4     ;6. chan 1 msb
        retlw 1          ;7. nil

;..............

START:  bcf STATUS,RP0
        bcf STATUS,RP1
        clrf PORTA
        clrf PORTB
        clrf PORTC
        clrf PORTD
        clrf PORTE
        PAGE1
        movlw %00001111     ;RA0-RA3 as inputs, RA4-RA5 as output
        movwf TRISA
        clrf TRISB          ;PORTB as output
        clrf TRISC          ;PORTC as output
        clrf TRISD          ;PORTD as output
        movlw 7
        movwf TRISE         ;PORTE as input
        movlw %00000100     ;set LHS justify, RA0, RA1, RA3 as analog inputs
        movwf ADCON1        ;with RA2, RA5, RE0-2 digital, ref to +VE and 0V
        movlw %00000101     ;timer 1:64 (1/50th sec)
        movwf OPTION
        PAGE0
        movlw %01000001
        movwf ADCON0        ;set Fosc/8, AD on
        movlw 1
        movwf FOSC

        clrf CHAN
        call PAUSIT
        clrf INTCON
        clrf CHANGE

        movlw 2
        movwf CHAN
        movlw %00001000    ;2K
        movwf LIMIT

;............................ END OF SETUP

INTRPT: movlw 255           ;main loop start point
        movwf CHANGE

        PAGE1
        clrf TRISD          ;PORTD as outputs
        PAGE0
        movlw %00110000     ;set mem WE hi, OE hi
        movwf PORTA
        movf CHAN,W
        btfsc STATUS,Z
        goto CHAN0
        btfss CHAN,1
        goto CHAN1
        goto DOUBLE

;............

CHAN0:  bcf ADCON0,3
        goto PATHIT

CHAN1:  bsf ADCON0,3

PATHIT: movf LIMIT,W         :is LIMIT = 0 (direct sampling)
        btfsc STATUS,Z
        goto DIRECT          ;yes

;...........SINGLE CHANNEL - 0 or 1 via memory

DX0:     movlw 1
         movwf STEP
         bsf ADCON0,GO       ;start data conversion
         PAGE1
         clrf TRISD          ;PORTD as outputs
         PAGE0
         movlw %00110000     ;set mem WE hi, OE hi
         movwf PORTA
         clrf PORTB
         movf LIMIT,W
         movwf PORTC

WAITAD0: btfsc ADCON0,GO
         goto WAITAD0

         movf ADRESH,W     ;get ADC val
         bsf ADCON0,GO     ;start data conversion for next sample
         movwf PORTD       ;put it out to mem
         bcf PORTA,4       ;toggle mem WE down, up
         bsf PORTA,4

         btfsc PORTA,2    ;is PC requesting function change?
         goto MODSET      ;yes

         incfsz PORTB,F
         goto WAITAD0
         decfsz PORTC,F
         goto WAITAD0

SENDPC0: PAGE1
         movlw %11111111     ;PORTD as inputs
         movwf TRISD
         PAGE0

         movf LIMIT,W
         movwf WADDRH
         clrf WADDRL
         movlw %00010000  ;set WE high (bit 4), OE low (bit 5)
         movwf PORTA

GETLSB0: movf WADDRL,W    ;get lo address
         movwf PORTB
         movf WADDRH,W    ;get hi address
         andlw %01111111  ;clear bit 7
         movwf PORTC
         nop
         movf PORTD,W     ;get data from mem at this address
         movwf MEMLO      ;store it
         movwf MEMHI      ;store it

BRANCH0: btfsc PORTA,2    ;is PC requesting function change?
         goto MODSET      ;yes
         nop
         nop
         movf PORTE,W     ;get PC code
         andlw 7
         movwf CHANGA
         xorwf CHANGE,W
         btfsc STATUS,Z
         goto BRANCH0
         movf CHANGA,W
         movwf CHANGE
         call OUTIT
         iorlw 0          ;affect Z flag (retlw 0 on its own does not set Z)
         btfsc STATUS,Z   ;is W = 0 (step performed) ?
         goto GETLSB0     ;yes
         addlw 1
         btfss STATUS,C   ;is RESET = 255?
         goto BRANCH0     ;no
         goto DX0

;.............

         ;SAMPLE 2 CHANNELS VIA MEMORY

DOUBLE:  movf LIMIT,W         ;is LIMIT = 0 (direct sampling)
         btfsc STATUS,Z
         goto DOUBLEDIRECT    ;yes
         movlw 2
         movwf STEP

DX3:     bcf ADCON0,3         ;chan 0
         bsf ADCON0,GO

         PAGE1
         clrf TRISD          ;PORTD as outputs
         PAGE0
         movlw %00110000     ;set mem WE hi, OE hi
         movwf PORTA
         clrf PORTB
         movf LIMIT,W
         movwf PORTC

WAITAD2: btfsc ADCON0,GO
         goto WAITAD2

GETVAL2: movf ADRESH,W     ;get ADC val
         movwf PORTD       ;put it out to mem
         bcf PORTA,4       ;toggle mem WE down, up
         bsf PORTA,4
         bsf ADCON0,3     ;chan 1
         call DELAYB
         btfsc PORTA,2    ;is PC requesting function change?
         goto MODSET      ;yes
         bsf ADCON0,GO
         incfsz PORTB,F
         goto WAITAD3
         decfsz PORTC,F
         goto SENDPC3

WAITAD3: btfsc ADCON0,GO
         goto WAITAD3

GETVAL3: movf ADRESH,W    ;get ADC val
         movwf PORTD      ;put it out to mem
         bcf PORTA,4      ;toggle mem WE down, up
         bsf PORTA,4
         bcf ADCON0,3     ;chan 0
         call DELAYB
         btfsc PORTA,2    ;is PC requesting function change?
         goto MODSET      ;yes
         bsf ADCON0,GO
         incfsz PORTB,F
         goto WAITAD2
         decfsz PORTC,F
         goto WAITAD2

SENDPC3: PAGE1
         movlw %11111111     ;PORTD as inputs
         movwf TRISD
         PAGE0

         movf LIMIT,W
         movwf WADDRH
         clrf WADDRL
         movlw %00010000  ;set WE high (bit 4), OE low (bit 5)
         movwf PORTA

GETLSB3: movf WADDRL,W    ;get lo address
         movwf PORTB
         movf WADDRH,W    ;get hi address
         andlw %01111111  ;clear bit 7
         movwf PORTC
         nop
         movf PORTD,W     ;get data from mem at this address
         movwf MEMLO      ;store it - CHAN0

         bsf PORTB,0
         nop
         movf PORTD,W     ;get data from mem at this address
         movwf MEMHI      ;store it - CHAN1

BRANCH3: btfsc PORTA,2    ;is PC requesting function change?
         goto MODSET      ;yes
         nop
         nop
         movf PORTE,W     ;get PC code
         andlw 7
         movwf CHANGA
         xorwf CHANGE,W
         btfsc STATUS,Z
         goto BRANCH3
         movf CHANGA,W
         movwf CHANGE
         call OUTIT
         iorlw 0          ;affect Z flag (retlw 0 on its own does not set Z)
         btfsc STATUS,Z   ;is W = 0 (step performed) ?
         goto GETLSB3     ;yes
         addlw 1
         btfss STATUS,C   ;is RESET = 255?
         goto BRANCH3     ;no
         goto DX3

;.............

DIRECT:  bsf ADCON0,GO    ;sample chan 0 or 1 without memory

WAITADA: btfsc ADCON0,GO
         goto WAITADA

         movf ADRESH,W    ;get ADC val
         bsf ADCON0,GO
         movwf MEMLO      ;store it - CHAN 0
         movwf MEMHI      ;store it - CHAN 1

BRANCH2: btfsc PORTA,2    ;is PC requesting function change?
         goto MODSET      ;yes
         movf PORTE,W     ;get PC code
         andlw 7
         movwf CHANGA
         xorwf CHANGE,W
         btfsc STATUS,Z
         goto BRANCH2
         movf CHANGA,W
         movwf CHANGE
         call OUTIT2
         iorlw 0          ;affect Z flag (retlw 0 on its own does not set Z)
         btfsc STATUS,Z   ;is W = 0 (step performed) ?
         goto WAITADA     ;yes
         goto BRANCH2     ;no

;.............

DOUBLEDIRECT:      ;sample 2 chans without memory
DX4:     bcf ADCON0,3     ;set for Chan 0
         call DELAYB
         bsf ADCON0,GO

WAITADY: btfsc ADCON0,GO
         goto WAITADY
         movf ADRESH,W    ;get ADC val
         movwf MEMLO      ;store it - Chan 0

         bsf ADCON0,3     ;set for Chan 1
         call DELAYB
         bsf ADCON0,GO

WAITADZ: btfsc ADCON0,GO
         goto WAITADZ
         movf ADRESH,W    ;get ADC val
         movwf MEMHI      ;store it - Chan 1

BRANCH4: btfsc PORTA,2    ;is PC requesting function change?
         goto MODSET      ;yes
         nop
         nop
         movf PORTE,W     ;get PC code
         andlw 7
         movwf CHANGA
         xorwf CHANGE,W
         btfsc STATUS,Z
         goto BRANCH4
         movf CHANGA,W
         movwf CHANGE
         call OUTIT2
         iorlw 0          ;affect Z flag (retlw 0 on its own does not set Z)
         btfsc STATUS,Z   ;is W = 0 (step performed) ?
         goto DX4         ;yes
         goto BRANCH4     ;no

;.............

MODSET: clrf PORTC       ;route from PC command
        movf PORTE,W     ;get PORTE
        goto ROUTE
;..........

RESETP:  goto WAITCLR
CHANA:   clrf CHAN         ;channel 0 only
         goto WAITCLR
CHANB:   movlw 1           ;channel 1 only
         movwf CHAN
         goto WAITCLR
CHANAB:  movlw 2           ;channel 0 & 1 together
         movwf CHAN
         goto WAITCLR
MAX32:   movlw %01111111   ;sample limit 32k
         movwf LIMIT
         goto WAITCLR
MAX2:    movlw %00001000   ;sample limit 2k
         movwf LIMIT
         goto WAITCLR
MAX0:    clrf LIMIT        ;sample limit nil - direct sampling to PC

WAITCLR: movlw %00011111
         movwf PORTC
WAITCLR2: btfsc PORTA,2
         goto WAITCLR2
         clrf PORTC
         goto INTRPT

;.............

SENDLS3: movf MEMLO,W
         andlw 15         ;put LSB out to PORTB with PC flag (bit 7) high
         iorlw 128        ;NB, PC sees bit 7 as LOW (BUSY line inverted)
         movwf PORTC
         nop
         nop
         retlw 1

SENDMS3: swapf MEMLO,W
         andlw 15         ;put MSB out to PORTB with PC flag (bit 7) low
         movwf PORTC      ;NB, now PC sees bit 7 as HIGH (BUSY line inverted)
         nop
         nop
         retlw 1

SENDLS4: movf MEMHI,W
         andlw 15         ;put LSB out to PORTB with PC flag (bit 7) high
         iorlw 128        ;NB, PC sees bit 7 as LOW (BUSY line inverted)
         movwf PORTC
         nop
         nop
         retlw 1

SENDMS4: swapf MEMHI,W
         andlw 15         ;put MSB out to PORTB with PC flag (bit 7) low
         movwf PORTC      ;NB, now PC sees bit 7 as HIGH (BUSY line inverted)
         nop
         nop
         retlw 1

STEP0:   movlw 8
         movwf DELAYA

DELAY0:  decfsz DELAYA,F
         goto DELAY0
         movf STEP,W
         addwf WADDRL,F
         btfss STATUS,C
         retlw 0          ;step complete OK
         decfsz WADDRH,F
         retlw 0          ;step complete OK
         retlw 255        ;reset needed, goto start next batch of sampling

;.............

PAUSIT: movlw 10
        movwf SLOWIT
        clrf INTCON
PAUSE:  btfss INTCON,2
        goto PAUSE
        BCF INTCON,2
        decfsz SLOWIT,F
        goto PAUSE
        return

INCRATE: movlw %01000000
         addwf ADCON0,F
         bcf ADCON0,7

GETRATE: swapf ADCON0,W
         andlw %00001100
         movwf FOSC
         bcf STATUS,C 
         rrf FOSC,F
         rrf FOSC,F
         movf FOSC,W

WAITCLR3: iorlw %00011110
          movwf PORTC
WAITCLR4: btfsc PORTA,2
          goto WAITCLR4
          clrf PORTC
          goto INTRPT

DELAYB:   nop
          nop
          nop
          nop
          nop
          nop
          nop
          return

         .END

