'TKPROG02 22MAR99 PIC16x84/F87x PROGRAM COMPILER - COPYRIGHT (c) JOHN BECKER
version$ = "V2.4": ON ERROR GOTO errortrap: '(18AUG00)

'V2.4 12AUG00

'V2.1 05JUL99 space after comma in command line avoided
'V2.1 05JUL99 corrected for use of TAB instead of spaces
'V2.1 05JUL99 corrected for use of hex ($) value in column 4 (d$(4))
'V2.1 05JUL99 corrected for use of extra space between twin single quotes

'V2.2 06JUL99 nil

'V2.3 24JUL99 filebase$ + ".REF" changed to "TKTEMP.REF"
'V2.3 24JUL99 intercept for no/wrong .ORG added
'V2.3 24JUL99 equate capacity increased to 300
'V2.3 24JUL99 equates usage (by asterisk) added - line length limit 75
'V2.3 24JUL99 column split value limited to 5
'V2.3 31JUL99 line numbers for errors set to match orig source code
'V2.3 31JUL99 intercept added for missing W/F or bit number as appropriate

'V2.4 12AUG00 filebase$ + ".ERR" changed to "TKTEMP.ERR"
'V2.4 12AUG00 filebase$ + ".LST" changed to "TKTEMP.LST"
'V2.4 12AUG00 keyed options following assembly added, including .ERR view
'V2.4 14AUG00 option to print errors to printer added
'V2.4 14AUG00 display of QBasic errors following unforeseen error added
'V2.4 17AUG00 $INCLUDE & .INCLUDE files facility added
'V2.4 18AUG00 intercept for "input past end of file" added

SCREEN 9: COLOR 15, 1
DIM CODE$(255), CODE%(255), default$(13): GOSUB clearit
LOCATE 2, 10: PRINT "****** ASSEMBLE .OBJ FILE FROM TASM SOURCE CODE ";
PRINT version$; " ******": COLOR 14
LOCATE 24, 15: PRINT "THIS PROGRAM NOW HANDLES .INCLUDE & $INCLUDE FILES";
LOCATE 1, 1: COLOR 15
maxlen% = 16383: 'maximum allowed space for source code file length

DIM equate$(300), equate%(300), define$(20), label$(1000), label%(1000)
DIM mainline%(maxlen%, 1), jump%(1000), jump$(1000)
spx$ = "                                                  "
orgflag% = 0: jumpx% = 0: printer = 0

OPEN "C:\PIC\TKFILE.TXT" FOR INPUT AS #1: INPUT #1, a$
INPUT #1, directoryreturn$: INPUT #1, route$: CLOSE
OPEN "C:\PIC\TKDEFALT.TXT" FOR INPUT AS #1: FOR a = 1 TO 13
INPUT #1, default$(a): NEXT: CLOSE 1: default$ = default$(12)

dir$ = "C:\PIC\": dot$ = ".ASM"

getcodes: READ h$: IF h$ = "#" THEN GOTO sortcodes
CODE% = CODE% + 1: CODE$(CODE%) = h$: GOTO getcodes
sortcodes: num% = CODE%: span% = num% / 2
DO WHILE span% > 0: FOR i% = span% TO num% - 1: j% = i% - span% + 1
FOR j% = (i% - span% + 1) TO 1 STEP -span%
IF CODE$(j%) <= CODE$(j% + span%) THEN EXIT FOR
SWAP CODE$(j%), CODE$(j% + span%)
NEXT j%: NEXT i%: span% = span% / 2: LOOP
FOR a = 1 TO CODE%: h$ = CODE$(a):
IF RIGHT$(h$, 1) = "*" THEN h$ = LEFT$(h$, LEN(h$) - 2)
GOSUB getbin: CODE%(a) = v%: NEXT

GOSUB gettitle:
IF file$ = "M" OR file$ = "Q" THEN z$ = file$: GOTO finish2

getsource: L = LEN(file$): filebase$ = LEFT$(file$, L - 4)
file2$ = LEFT$(file$, L - 4) + ".LST"
file4$ = LEFT$(file$, L - 4) + ".OBJ": b$ = "": LOCATE 7, 21
PRINT TIME$; " 1 SPLITTING "; : COLOR 11: PRINT UCASE$(file$): COLOR 15
GOSUB storedefault

OPEN file$ FOR INPUT AS #1
OPEN "TKTEMP.REF" FOR OUTPUT AS #2: ' full source line
OPEN "TKTEMP.ERR" FOR OUTPUT AS #5: ' error details file

PRINT #5, "ERRORS LIST "; file$; " "; DATE$; " "; TIME$: PRINT #5, ""
filenum = 1

getit1: IF EOF(1) THEN GOTO noorg
IF filenum <> 9 THEN GOTO getit1a
IF EOF(9) THEN CLOSE 9: filenum = 1: PRINT #2, ";endinclude "; include$: mainline% = mainline% + 1
getit1a:
a$ = INPUT$(1, filenum): IF a$ = CHR$(13) THEN GOTO 100
IF a$ = CHR$(10) THEN GOTO getit1
IF a$ = CHR$(9) THEN a$ = " "
IF a$ = "," THEN a$ = "\": 'correct for commas
IF a$ = ";" THEN a$ = " ;"
b$ = b$ + a$: GOTO getit1

100 : mainline% = mainline% + 1: b$ = RTRIM$(b$)
IF LEFT$(b$, 1) = " " THEN b$ = ".       " + b$
IF UCASE$(LEFT$(b$, 8)) = ".INCLUDE" THEN b$ = "$INCLUDE" + MID$(b$, 9)
PRINT #2, b$: reg$ = "": IF b$ = "" THEN GOTO getit1

IF UCASE$(LEFT$(b$, 8)) = "$INCLUDE" THEN GOSUB openinclude: b$ = "": GOTO getit1
IF UCASE$(LEFT$(b$, 7)) = "#DEFINE" THEN GOSUB getdefine: b$ = "": GOTO getit1
GOSUB splitit1
b$ = "": IF UCASE$(d$(2)) = ".EQU" THEN GOSUB getequate: GOTO getit1
IF UCASE$(d$(2)) <> ".ORG" THEN GOTO getit1
GOSUB getorigin: IF org% <> 4 THEN errors% = errors% + 1: PRINT #5, "wrong .ORG found"
address% = 4: mainline%(mainline% + 1, 0) = address%
mainline%(mainline% + 1, 1) = 10245

endintro: GOSUB sortequates
LOCATE 9, 21: PRINT TIME$; " 3 PROCESSING SOURCE CODE": filenum = 1

getit2: IF EOF(1) THEN GOTO 2100
IF filenum <> 9 THEN GOTO getit2a
IF EOF(9) THEN CLOSE 9: filenum = 1: PRINT #2, ";endinclude "; include$: mainline% = mainline% + 1:
getit2a:
a$ = INPUT$(1, filenum): IF a$ = ";" THEN f = 1: a$ = " ;"
IF a$ = CHR$(10) THEN GOTO getit2
IF a$ = CHR$(9) THEN a$ = " "
IF a$ = " " AND b$ = " " THEN GOTO getit2: 'avoid double spaces
IF f = 0 AND a$ = " " AND b$ = "\" THEN GOTO getit2: 'avoid space after command comma
IF a$ = ":" THEN b$(f) = b$(f) + a$: a$ = " ": 'correct for no space after label colon
IF a$ = "," THEN a$ = "\": 'correct for commas
IF a$ <> CHR$(13) THEN b$(f) = b$(f) + a$: b$ = a$: GOTO getit2

mainline% = mainline% + 1: IF mainline% > maxlen% THEN GOTO filelength
b$ = b$(0): IF LEFT$(b$, 1) = " " THEN b$ = ".       " + b$
IF UCASE$(LEFT$(b$, 8)) = ".INCLUDE" THEN b$ = "$INCLUDE" + MID$(b$, 9)
PRINT #2, LEFT$(b$ + spx$, 28); b$(1)
IF UCASE$(LEFT$(b$, 8)) = "$INCLUDE" THEN GOSUB openinclude: b$ = "": GOTO getit2
b$(0) = RTRIM$(b$(0)): b$ = "": f = 0: reg$ = ""
IF b$(0) = "" THEN GOTO 2010
GOSUB splitit:
IF UCASE$(d$(2)) = ".ORG" THEN GOSUB getorigin: GOTO 2010

IF UCASE$(d$(2)) = ".END" THEN GOTO 2100
IF d$(1) <> "" THEN GOSUB getlabel
IF d$(2) = "" THEN GOTO 2010
address% = address% + 1: IF orgflag% > 0 THEN address% = org%: orgflag% = 0
IF labelflag% > 0 THEN GOSUB setlabel

GOSUB compileit
IF reg$ <> "" THEN jp% = jp% + 1: jump%(jp%) = mainline%: jump$(jp%) = reg$
mainline%(mainline%, 0) = address%: mainline%(mainline%, 1) = byte%
2010 : f = 0: b$(0) = "": b$(1) = "": GOTO getit2

2100 : CLOSE 1: CLOSE 2: GOSUB sort

doaddresses: LOCATE 10, 21: PRINT TIME$; " 4 ALLOCATING JUMPS"
FOR a = 1 TO jp%: b% = jump%(a): k$ = jump$(a): GOSUB binarychop2
v% = label%(q): w% = mainline%(b%, 1): x% = v% OR w%: mainline%(b%, 1) = x%
NEXT

LOCATE 11, 21: PRINT TIME$; " 5 CREATING OUTPUT FILES"
OPEN "TKTEMP.REF" FOR INPUT AS #1: ' full source line
OPEN "TKTEMP.LST" FOR OUTPUT AS #2: ' list file
PRINT #2, file$; " LIST FILE "; DATE$; " "; TIME$: PRINT #2, ""
OPEN filebase$ + ".OBJ" FOR OUTPUT AS #4: ' obj file
inc$ = "  "

bytecount% = 0: x% = 0: FOR a% = 1 TO mainline%: b% = mainline%(a%, 0)
c% = mainline%(a%, 1): msb% = c% \ 256: lsb% = c% - (msb% * 256)
c$ = RIGHT$("000" + HEX$(c%), 4)
c$ = LEFT$(c$, 2) + " " + RIGHT$(c$, 2) + " "
IF b% > 0 THEN x% = b% + 1 ELSE c$ = "      ": b% = x%
a$ = RIGHT$("000" + LTRIM$(STR$(a%)), 4): ' + " "
b$ = RIGHT$("000" + HEX$(b%), 4) + " "
IF EOF(1) = 0 THEN INPUT #1, d$ ELSE d$ = ""
IF LEFT$(d$, 1) = "." THEN d$ = " " + MID$(d$, 2)
IF UCASE$(LEFT$(d$, 8)) = "$INCLUDE" THEN inc$ = "+ "
IF LEFT$(d$, 11) = ";endinclude" THEN inc$ = "  "

FOR c = 1 TO LEN(d$)
IF MID$(d$, c, 1) = "\" THEN d$ = LEFT$(d$, c - 1) + "," + MID$(d$, c + 1): EXIT FOR
NEXT: PRINT #2, a$; inc$; b$; c$; "    "; d$
IF mainline%(a%, 0) > 0 THEN PRINT #4, CHR$(msb%); CHR$(lsb%); : bytecount% = bytecount% + 1:
NEXT: PRINT #2, "": PRINT #4, ""

PRINT #2, "": PRINT #2, "EQUATES VALUES - TOTAL"; STR$(eq%)
PRINT #2, "'*' MARKS USAGE (LINE LEN LIMIT 75) - THOSE WITHOUT '*' NOT USED"
FOR a = 1 TO eq%: h$ = "$" + RIGHT$("0" + HEX$(equate%(a)), 2)
PRINT #2, h$; " "; LEFT$(equate$(a), 71): NEXT
PRINT #2, "": PRINT #2, "LABEL VALUES - TOTAL"; STR$(label%)
FOR a = 1 TO label%: h$ = RIGHT$("000" + HEX$(label%(a)), 4)
PRINT #2, "$"; h$; " "; label$(a): NEXT
IF org% = 4 THEN errors% = errors% + 1: PRINT #5, "insufficient .ORG values"

IF errors% = 0 THEN PRINT #5, "NO ERRORS"

finalbit:

CLOSE 5: OPEN "TKTEMP.ERR" FOR INPUT AS #5: PRINT #2, ""
geterr: IF EOF(5) THEN GOTO endgeterr
INPUT #5, a$: PRINT #2, a$: GOTO geterr

endgeterr: CLOSE : LOCATE 12, 21: PRINT TIME$; " 6 FINISHED ASSEMBLY"
COLOR 14: LOCATE 13, 21: PRINT "ERRORS ="; errors%;
IF errors% > 0 THEN PRINT "DETAILS IN .LST AND .ERR FILES": BEEP ELSE PRINT
COLOR 11: LOCATE 15, 21
PRINT "BYTE COUNT OF "; : COLOR 14: PRINT filebase$; ".OBJ";
COLOR 11: PRINT " CODE ="; bytecount%
LOCATE 16, 21: PRINT "ORIGINAL SOURCE CODE LINES ="; mainline%

finish: COLOR 14: LOCATE 18, 31: PRINT "FINISHED": COLOR 11
LOCATE 19, 21: PRINT "<ENTER> "; : COLOR 15: IF errors% = 0 THEN GOTO fin2
PRINT "  VIEW .ERR ERROR FILE ": GOTO fin3
fin2: PRINT "  PROGRAM PIC WITH "; : COLOR 11: PRINT filebase$; ".OBJ"
fin3: LOCATE 20, 21: COLOR 11: PRINT "   E    "; : COLOR 15
PRINT "  EDIT SOURCE CODE     "
COLOR 11: LOCATE 21, 20: PRINT "ANY OTHER"; : COLOR 15
PRINT "  GOTO MAIN TOOLKIT MENU"

GOSUB hold
IF UCASE$(z$) = "E" THEN route$ = "E": GOTO finish3: ' goto EDIT route
IF z$ <> CHR$(13) THEN GOTO finish2
IF errors% > 0 THEN GOTO SHOWERRORS
route$ = "2": ' go straight for sending prog to PIC
finish3:
OPEN "C:\PIC\TKFILE.TXT" FOR INPUT AS #1: INPUT #1, a$
INPUT #1, directoryreturn$: CLOSE
a$ = file4$: 'PRINT a$: STOP
OPEN "C:\PIC\TKFILE.TXT" FOR OUTPUT AS #1: PRINT #1, a$
PRINT #1, directoryreturn$: PRINT #1, route$: CLOSE
finish2: CHAIN "TKMAIN02"

'*****************

filelength: CLOSE : COLOR 14:
LOCATE 17, 21: PRINT "PROBLEM - YOUR SOURCE CODE FILE IS TOO LONG"
LOCATE 18, 21: PRINT "THE FILE LENGTH MUST BE LESS THAN"; maxlen%; "LINES"
LOCATE 19, 21: PRINT "SO EDIT IT TO REMOVE SOME BLANK LINES"
GOTO finish

getequate:
IF RIGHT$(d$(1), 1) = ":" THEN L = LEN(d$(1)): d$(1) = LEFT$(d$(1), L - 1)
IF LEFT$(d$(3), 1) = "$" THEN h$ = d$(3): GOSUB gethex: GOTO geteq1
IF LEFT$(d$(3), 1) = "%" THEN h$ = d$(3): GOSUB getbin: GOTO geteq1
v% = VAL(d$(3))
geteq1: eq% = eq% + 1: equate$(eq%) = d$(1) + " ": equate%(eq%) = v%: RETURN

getorigin:
IF LEFT$(d$(3), 1) = "$" THEN h$ = d$(3): GOSUB gethex: GOTO getorg
IF LEFT$(d$(3), 1) = "%" THEN h$ = d$(3): GOSUB getbin: GOTO getorg
v% = VAL(d$(3))
getorg: orgflag% = orgflag% + 1: org% = v%: RETURN

getlabel: label% = label% + 1: L = LEN(d$(1)): labelflag% = labelflag% + 1
IF RIGHT$(d$(1), 1) = ":" THEN L = L - 1
label$(label%) = LEFT$(d$(1), L) + " ": RETURN

setlabel: label%(label%) = address%: IF labelflag% > 2 THEN labelflag = 2
IF labelflag% = 2 THEN label%(label% - 1) = address%
labelflag% = 0: RETURN

gethex: v% = VAL("&H" + MID$(h$, 2)): RETURN

getbin: IF LEFT$(h$, 1) = "%" THEN h$ = MID$(h$, 2)
L = LEN(h$): IF RIGHT$(h$, 1) = "%" THEN L = L - 1: h$ = LEFT$(h$, L)
d = 0: v% = 0: FOR c = L TO 1 STEP -1: e = VAL(MID$(h$, c, 1)) * (2 ^ d)
v% = v% + e: d = d + 1: NEXT: RETURN

getasc: v% = ASC(MID$(h$, 2)): RETURN

getdefine: define% = define% + 1: h$ = MID$(b$, 9)
define$(define%) = RTRIM$(LTRIM$(h$)): RETURN

splitit1: b$ = b$ + " ": d = 0: e = 1: FOR c = 1 TO LEN(b$)
IF MID$(b$, c, 1) <> " " THEN GOTO bypass1
IF MID$(b$, c, 2) = "  " THEN GOTO bypass1
IF d > 4 THEN EXIT FOR
d = d + 1: d$(d) = RTRIM$(MID$(b$, e, c - e)): e = c + 1
bypass1: NEXT: FOR c = d + 1 TO 5: d$(c) = "": NEXT: RETURN

splitit: c$ = b$(0) + " "
FOR c = 1 TO 4: d$(c) = "": NEXT: d = 0: e = 1: FOR c = 1 TO LEN(c$)
IF MID$(c$, c, 1) <> "'" THEN GOTO split3
IF MID$(c$, c, 3) = "' '" THEN c = c + 2: GOTO bypass
IF MID$(c$, c + 2, 2) <> " '" THEN GOTO split3
c$ = LEFT$(c$, c + 1) + MID$(c$, c + 3) + " ": GOTO bypass
IF MID$(c$, c, 4) = "': '" THEN c = c + 3: GOTO bypass
split3:
IF MID$(c$, c, 1) <> " " AND MID$(c$, c, 1) <> "\" THEN GOTO bypass
IF MID$(c$, c, 2) = "  " THEN GOTO bypass
IF d > 4 THEN EXIT FOR
d = d + 1: d$(d) = MID$(c$, e, c - e): e = c + 1
bypass: NEXT: RETURN

compileit: k$ = UCASE$(d$(2)) + " ": GOSUB binarychop: qx = q
IF q = 0 THEN GOSUB substitute: IF v% > 0 THEN GOTO compileit
byte% = CODE%(q): IF q = 0 THEN number = 1000: GOTO problem
IF LEFT$(d$(3), 1) = "$" THEN h$ = d$(3): GOSUB gethex: GOTO comp1
IF LEFT$(d$(3), 1) = "%" THEN h$ = d$(3): GOSUB getbin: GOTO comp1
IF LEFT$(d$(3), 1) = "'" THEN h$ = d$(3): GOSUB getasc: GOTO comp1
IF d$(3) >= "A" THEN GOSUB getreg ELSE v% = VAL(d$(3))
comp1: byte% = byte% OR v%
IF d$(4) <> "" THEN GOSUB getdest: byte% = byte% OR (v% * 128): RETURN
IF RIGHT$(CODE$(qx), 1) <> "*" THEN RETURN
IF d$(4) <> "" THEN RETURN
errors% = errors% + 1: PRINT #5, LEFT$(k$ + "            ", 10);
PRINT #5, "destination (W/F or bit) missing at line"; mainline%: RETURN

getdest: k$ = d$(4) + " ":
IF LEFT$(k$, 1) = "$" THEN v% = VAL("&H" + MID$(k$, 2)): RETURN
IF VAL(k$) > 0 OR k$ = "0 " THEN v% = VAL(k$): RETURN
GOSUB binarychop3: v% = equate%(q)
IF q > 0 THEN equate$(q) = equate$(q) + "*": RETURN
errors% = errors% + 1:
PRINT #5, LEFT$(k$ + "            ", 10); "equate unknown at line"; mainline%
COLOR 14: LOCATE 13, 21: PRINT "ERRORS ="; errors%: COLOR 15: RETURN

getreg: f% = 0: v% = 0: k$ = d$(3) + " "
GOSUB binarychop3: v% = equate%(q): IF q = 0 THEN reg$ = k$:
IF q <> 0 THEN equate$(q) = equate$(q) + "*": ' PRINT equate$(q)
RETURN

binarychop: L = 1: h = CODE%: k = LEN(k$)
chop1: q = INT((h + L) / 2): IF LEFT$(CODE$(q), k) = k$ THEN RETURN
IF k$ < CODE$(q) OR CODE$(q) = "" THEN h = q - 1 ELSE L = q + 1
IF L > h THEN q = 0: RETURN
GOTO chop1

binarychop2: L = 1: h = label%: k = LEN(k$)
chop21: q = INT((h + L) / 2): IF LEFT$(label$(q), k) = k$ THEN RETURN
IF k$ < label$(q) OR label$(q) = "" THEN h = q - 1 ELSE L = q + 1
IF L > h THEN q = 0 ELSE GOTO chop21
errors% = errors% + 1
PRINT #5, LEFT$(k$ + "            ", 10); "label/equate unknown at line"; b%
COLOR 14: LOCATE 13, 21: PRINT "ERRORS ="; errors%: COLOR 15: RETURN

binarychop3: L = 1: h = eq%: k = LEN(k$)
chop31: q = INT((h + L) / 2): IF LEFT$(equate$(q), k) = k$ THEN RETURN
IF k$ < equate$(q) OR equate$(q) = "" THEN h = q - 1 ELSE L = q + 1
IF L > h THEN q = 0: RETURN
GOTO chop31

substitute: v% = 0: L = LEN(d$(2)): FOR q = 1 TO define%
IF d$(2) = LEFT$(define$(q), L) THEN v% = q: EXIT FOR
NEXT: IF v% = 0 THEN GOTO sub2
b$(0) = define$(v%): GOSUB splitit: RETURN

sub2: errors% = errors% + 1
PRINT #5, LEFT$(d$(2) + "            ", 10); "command unfound at line"; mainline%: ' address%
COLOR 14: LOCATE 13, 21: PRINT "ERRORS ="; errors%: COLOR 15: RETURN

'***************

hold: z$ = UCASE$(INKEY$): IF z$ = "" THEN GOTO hold ELSE RETURN

' ********************

sort: num% = label%: span% = num% / 2
DO WHILE span% > 0: FOR i% = span% TO num% - 1: j% = i% - span% + 1
FOR j% = (i% - span% + 1) TO 1 STEP -span%
IF label$(j%) <= label$(j% + span%) THEN EXIT FOR
SWAP label$(j%), label$(j% + span%): SWAP label%(j%), label%(j% + span%)
NEXT j%: NEXT i%: span% = span% / 2: LOOP:

checkrepeatlabels:
FOR a = 1 TO label%: IF label$(a) <> label$(a + 1) THEN GOTO crl2: 'eq%
errors% = errors% + 1: k$ = LEFT$(label$(a) + "          ", 10)
PRINT #5, k$; "$"; HEX$(label%(a)); " duplicate labels"
k$ = LEFT$(label$(a + 1) + "          ", 10)
PRINT #5, k$; "$"; HEX$(label%(a + 1)); " duplicate labels"
COLOR 14: LOCATE 13, 21: PRINT "ERRORS ="; errors%: COLOR 15
crl2: NEXT: RETURN

sortequates:
LOCATE 8, 21: PRINT TIME$; " 2 SORTING EQUATES": num% = eq%: span% = num% / 2
DO WHILE span% > 0: FOR i% = span% TO num% - 1: j% = i% - span% + 1
FOR j% = (i% - span% + 1) TO 1 STEP -span%
IF equate$(j%) <= equate$(j% + span%) THEN EXIT FOR
SWAP equate$(j%), equate$(j% + span%): SWAP equate%(j%), equate%(j% + span%)
NEXT j%: NEXT i%: span% = span% / 2: LOOP

checkrepeatequates:
FOR a = 1 TO eq%: IF equate$(a) <> equate$(a + 1) THEN GOTO cre2
errors% = errors% + 1:
k$ = LEFT$(equate$(a) + "          ", 10) + "$" + HEX$(equate%(a))
PRINT #5, k$; " duplicate equates"
k$ = LEFT$(equate$(a + 1) + "          ", 10) + "$" + HEX$(equate%(a + 1))
PRINT #5, k$; " duplicate equates"
COLOR 14: LOCATE 13, 21: PRINT "ERRORS ="; errors%: COLOR 15
cre2: NEXT: RETURN

clearit: LINE (2, 2)-(637, 347), 7, B: LINE (5, 5)-(634, 344), 7, B
PAINT (3, 3), 7, 7: LINE (6, 6)-(633, 343), 0, BF: RETURN

'****************

'* marks those that need destination (W/F etc)

DATA ADDLW    111110kkkkkkkk
DATA ADDWF    0001110fffffff *
DATA ANDLW    111001kkkkkkkk
DATA ANDWF    0001010fffffff *
DATA BCF      0100000fffffff *
DATA BSF      0101000fffffff *
DATA BTFSC    0110000fffffff *
DATA BTFSS    0111000fffffff *
DATA CALL     100kkkkkkkkkkk
DATA CLRF     0000011fffffff
DATA CLRW     00000100000011
DATA CLRWDT   00000001100100
DATA COMF     0010010fffffff *
DATA DECF     0000110fffffff *
DATA DECFSZ   0010110fffffff *
DATA GOTO     101kkkkkkkkkkk
DATA INCF     0010100fffffff *
DATA INCFSZ   0011110fffffff *
DATA IORLW    111000kkkkkkkk
DATA IORWF    0001000fffffff *
DATA MOVF     0010000fffffff *
DATA MOVLW    1100xxkkkkkkkk
DATA MOVWF    0000001fffffff
DATA NOP      0000000xx00000
DATA RETFIE   00000000001001
DATA RETLW    1101xxkkkkkkkk
DATA RETURN   00000000001000
DATA RLF      0011010fffffff *
DATA RRF      0011000fffffff *
DATA SLEEP    00000001100011
DATA SUBLW    11110xkkkkkkkk
DATA SUBWF    0000100fffffff *
DATA SWAPF    0011100fffffff *
DATA XORLW    111010kkkkkkkk
DATA XORWF    0001100fffffff *
DATA #

'***********

gettitle: COLOR 14: LOCATE 3, 21
PRINT "SOURCE FILE SEARCHED IS "; dir$; "xxx"; dot$: LOCATE 4, 15
PRINT "OUTPUT TO "; : COLOR 11: PRINT dir$; "xxx.OBJ ";
COLOR 14: PRINT "+ "; : COLOR 11: PRINT "TKTEMP.ERR";
COLOR 14: PRINT " & "; : COLOR 11: PRINT "TKTEMP.LST"
COLOR 11: LOCATE 19, 21: PRINT "<ENTER> ";
COLOR 15: PRINT "SELECT DEFAULT FILE"
COLOR 11: LOCATE 20, 21: PRINT "   D    ";
COLOR 15: PRINT "DIRECTORY DISPLAY"
COLOR 11: LOCATE 21, 21: PRINT "   M    ";
COLOR 15: PRINT "GOTO MAIN TOOLKIT MENU"

GT2: COLOR 15: GOSUB getfilename
IF file$ = "D" THEN GOTO showdirectory
IF file$ = "M" OR file$ = "Q" THEN RETURN
IF file$ = "" THEN file$ = default$: GOTO gt3
file$ = dir$ + file$ + dot$: COLOR 11: f$ = "FILE NOT FOUND " + file$
COLOR 10: LOCATE 6, 21: PRINT "NEW DEFAULT =        ";
PRINT file$; "             "

gt3: OPEN file$ FOR BINARY AS #1: b = LOF(1)
IF b = 0 THEN LOCATE 7, 21: CLOSE : PRINT f$; "    ": KILL file$: BEEP: GOTO GT2
COLOR 15: CLOSE : RETURN

getfilename: LOCATE 5, 21: COLOR 15
PRINT "PROCESS WHICH FILE                   ": COLOR 14
LOCATE 6, 21: PRINT "DEFAULT =            ";
COLOR 11: PRINT default$; "         ": COLOR 15

LOCATE 5, 40: INPUT file$
file$ = UCASE$(file$): FOR c = 1 TO LEN(file$)
IF MID$(file$, c, 1) = "." THEN file$ = LEFT$(file$, c - 1): EXIT FOR
NEXT: LOCATE 5, 42: COLOR 11: PRINT file$; "    ": COLOR 15: RETURN

showdirectory: route$ = "11"
OPEN "C:\PIC\TKFILE.TXT" FOR OUTPUT AS #2: PRINT #2, "C:\PIC\*.ASM"
PRINT #2, directoryreturn$: PRINT #2, route$: CLOSE : CHAIN "TKDIR03"

'**************

errortrap: number = ERR:
IF number = 25 AND printer = 1 THEN GOTO printeroff
IF number = 62 THEN RESUME NEXT
IF number <> 53 THEN GOTO problem
LOCATE 1, 1: PRINT dirfile$; : COLOR 14: PRINT "  CATEGORY NOT FOUND - ";
PRINT "IF NECESSARY PRESS ENTER FOR "; : COLOR 15: PRINT "*.*": COLOR 10
LOCATE 2, 1: PRINT "WHICH NEW DIRECTORY CATEGORY TO TRY "; : COLOR 15
errortrap2: INPUT f$: f$ = UCASE$(f$): IF f$ = "" THEN f$ = "*.*"
IF MID$(f$, 2, 2) <> ":\" THEN f$ = drive$ + dir$ + f$
dirfile$ = f$: CLS : RESUME

problem: WIDTH 80, 43: SCREEN 9: COLOR 15, 1
GOSUB clearit: COLOR 10: LOCATE 2, 28
PRINT "EPE PIC TOOLKIT MK2 "; version$: COLOR 14: LOCATE 4, 16
PRINT "AN ASSEMBLY PROGRAM ERROR HAS OCCURRED, QBASIC NUMBER";
COLOR 10: PRINT number: COLOR 14: LOCATE 6, 4
PRINT "THE FOLLOWING QBASIC ERROR CODES ARE A GUIDE TO HELP YOU SOLVE THE PROBLEM"
COLOR 11: OPEN "C:\PIC\TKERRORS.TXT" FOR INPUT AS #8
FOR a = 1 TO 30: INPUT #8, a$: LOCATE a + 7, 3: PRINT a$: NEXT: CLOSE
COLOR 14: LOCATE 40, 21: PRINT "PRESS ANY KEY TO RESTART ASSEMBLY SCREEN"
COLOR 15: GOSUB hold: WIDTH 80, 25: RUN

storedefault: default$(12) = file$: 'default$(13) = FILE$:
default$(2) = file4$: ' STOP
OPEN "C:\PIC\TKDEFALT.TXT" FOR OUTPUT AS #2
FOR a = 1 TO 13: PRINT #2, default$(a): NEXT: CLOSE 2: RETURN

'*********

noorg: PRINT #5, "NO .ORG value found"
errors% = errors% + 1: GOTO finalbit

SHOWERRORS: GOSUB clearit: COLOR 14
LOCATE 2, 23: PRINT "***** SHOW ASSEMBLY ERRORS *****"
OPEN "TKTEMP.ERR" FOR INPUT AS #1: LOCATE 3, 3
COLOR 11: INPUT #1, a$: PRINT a$; " TOTAL"; errors%: COLOR 15: b$ = a$
INPUT #1, a$: b = 5: ' COLOR 14

FOR a = 1 TO errors%: LOCATE b, 2: b = b + 1: INPUT #1, a$: PRINT a; a$
IF (a MOD 18) <> 0 OR EOF(1) THEN GOTO showerr2
LOCATE 24, 3: PRINT "MORE ERRORS - PRESS ANY KEY"; : LOCATE 1, 1
GOSUB hold: b = 5: GOSUB clearit: COLOR 14
LOCATE 2, 23: PRINT "***** SHOW ASSEMBLY ERRORS *****"
COLOR 11: LOCATE 3, 3: PRINT b$; " TOTAL"; errors%: COLOR 15
showerr2: NEXT: CLOSE
LOCATE 23, 4: COLOR 11: PRINT "<ENTER>"; : COLOR 15
PRINT " EDIT SOURCE CODE  "; : COLOR 11: PRINT " P"; : COLOR 15
PRINT " PRINT ERRORS LIST (FOLLOWED BY RETURN TO EDIT)"
COLOR 11: LOCATE 24, 4: PRINT "ANY OTHER KEY"; : COLOR 15
PRINT " GOTO MAIN TOOLKIT MENU";
LOCATE 24, 55: COLOR 14: PRINT "ENSURE PRINTER IS READY!";
LOCATE 1, 1

GOSUB hold
IF z$ = CHR$(13) THEN route$ = "E": GOTO finish4: ' goto EDIT route
IF UCASE$(z$) <> "P" THEN GOTO finish5

printroute:
printer = 1: OPEN "TKTEMP.ERR" FOR INPUT AS #1
INPUT #1, a$: LPRINT a$; " TOTAL"; errors%: INPUT #1, a$: LPRINT a$
FOR a = 1 TO errors%: INPUT #1, a$: LPRINT a; a$: NEXT: CLOSE
route$ = "E"

finish4: OPEN "C:\PIC\TKFILE.TXT" FOR INPUT AS #1: INPUT #1, a$
INPUT #1, directoryreturn$: CLOSE
OPEN "C:\PIC\TKFILE.TXT" FOR OUTPUT AS #1: PRINT #1, a$
PRINT #1, directoryreturn$: PRINT #1, route$: CLOSE
finish5: printer = 0: CHAIN "TKMAIN02"

printeroff: LOCATE 23, 4: PRINT "                            ";
PRINT "                                               "
LOCATE 24, 55: PRINT "                        ";
LOCATE 23, 4: COLOR 14: PRINT "PRINTER NOT READY "; : COLOR 11
PRINT "- CHECK IT THEN PRESS <ENTER>": GOSUB hold
IF z$ <> CHR$(13) THEN CLOSE : GOTO finish5
LOCATE 23, 4: COLOR 14: PRINT "OK                          ";
PRINT "                                               ": RESUME

openinclude:
include$ = LTRIM$(MID$(b$, 9)): filenum = 9: b$ = "": b$(0) = "": b$(1) = ""
OPEN "C:\PIC\" + include$ FOR INPUT AS #9: RETURN

