	NOLIST 
;Macros to save and restore context for interrupt. 

;****** ******* ******* ******* ******* ******* ******* *** * 
;COPYRIGHT (C) 2005 Keith Anderson 
;------ ------- ------- ------- ------- ------- ------- --- - 

;****** ******* ******* ******* ******* ******* ******* *** * 
;CONTENTS 
;------ ------- ------- ------- ------- ------- ------- --- - 

;SaveContext Save context for interrupt. 
;RestoreContext Restore context for interrupt. 

;****** ******* ******* ******* ******* ******* ******* *** * 
;SaveContext 
;RestoreContext 
;------ ------- ------- ------- ------- ------- ------- --- - 

;WARNING! 
;These macros depend upon defining the variables 
;used to save context as: 
;TempW 
;TempSTATUS 
;TempPCLATH 
;TempFSR 

;It is always necessary to save W and STATUS. 

;If memory space is less than 2K, 
;and if all tables using 
;	addwf,PCL 
;are on Page 0, Block 0, 
;it is not necessary to save PCLATH. 

;If FSR is not used inside interrupt, 
;it is not necessary to save FSR. 

;In these cases, the appropriate variable is left 
;undefined, and will not be saved or restored. 

;The bank bits in STATUS must be set appropriately 
;before the first access of an application specific 
;variable by the interrupt procedure. 
;Microchip data often suggest: 
;	clrf STATUS 
;Although this is not always essential, 
;it is safe and general.

;PCLATH must be set to the appropriate value 
;before the first goto or call after interrupt. 
;Microchip data often suggest: 
;	clrf PCLATH 
;This is often, but not always appropriate. 
;SaveContext does not change PCLATH, 
;but is usually followed by: 
;	pagesel Destination
;	goto Destination 
;and this will set PCLATH appropriately. 

;The RestoreContext macro does NOT include the 
;	retfie 
;instruction that will usually follow it. 

SaveContext MACRO 

	movwf TempW 

	swapf STATUS,w 
	movwf TempStatus 
	clrf STATUS 

	ifdef TempPCLATH 
	movf PCLATH,w 
	movwf TempPCLATH 
;	clrf PCLATH 
	endif 

	ifdef TempFSR 
	movf FSR,w 
	movwf TempFSR 
	endif 

	ENDM 

RestoreContext MACRO 
	ifdef TempFSR 
	movf TempFSR,w 
	movwf FSR 
	endif 

	ifdef TempPCLATH 
	movf TempPCLATH,w 
	movwf PCLATH 
	endif 

	swapf TempStatus,w 
	movwf STATUS 

	swapf TempW,f 
	swapf TempW,w 

	ENDM 

;****** ******* ******* ******* ******* ******* ******* *** * 
;COPYRIGHT (C) 2005 Keith Anderson 
;------ ------- ------- ------- ------- ------- ------- --- - 

	LIST 



