	NOLIST 
;Define mnemonics for If... macros. 

;****** ******* ******* ******* ******* ******* ******* *** * 
;COPYRIGHT (C) 2005 - Keith Anderson 
;------ ------- ------- ------- ------- ------- ------- --- - 

;Signed comparisons on the PIC are a bit 
;counterintuitive and it is handy to have macros 
;to get the code right every time. 

;Well, most of the time. 

;****** ******* ******* ******* ******* ******* ******* *** * 
;EXPLANATION 
;------ ------- ------- ------- ------- ------- ------- --- - 

;All of the If... macros have the pattern: 
;	IfV.. Variable,Cf,Something 

;The intended understanding is: 
;	IfV.. <condition> 
;	then 
;	<single instruction> 
;	endif 

;Warning! 
;The If... macros generate the correct code to implement: 
;	if condition then instruction. 
;They do not implement: 
;	if condition then SKIP instruction. 

;If the action corresponding to the condition 
;can be implemented by a single instruction, 
;then that action should follow the If... macro, 
;with no goto instructions. 

;If the action needs several instructions, 
;and/or an "else" clause, then this must be implemented 
;manually, using the compliment of the condition. 

;The intended structure is: 
;	IfV.. <compliment of condition> 
;	goto ElseLabel 
;	then 
;	<instruction> 
;	... 
;	<instruction> 
;	goto EndifLabel 
;	else 
;ElseLabel 
;	<instruction> 
;	... 
;	<instruction> 
;	endif 
;EndifLabel 

;If the "else" clause is empty, the intended structure is: 
;	IfV.. <compliment of condition> 
;	goto EndifLabel 
;	then 
;	<instruction> 
;	... 
;	<instruction> 
;	endif 
;EndifLabel 

;****** ******* ******* ******* ******* ******* ******* *** * 
;DEFINE IF MNEMONICS 
;------ ------- ------- ------- ------- ------- ------- --- - 

;I want to use the abbreviations LT, LE, GE, GT, EQ, NE 
;The assembler handles only single character text literals 
;I need to define the mnemonics I want to use. 
;The mnemonics must not be defined elsewhere. 
LT equ "L" 
LE equ "l" 
GE equ "g" 
GT equ "G" 
EQ equ "E" 
NE equ "N" 

;****** ******* ******* ******* ******* ******* ******* *** * 
;COPYRIGHT (C) 2005 - Keith Anderson 
;------ ------- ------- ------- ------- ------- ------- --- - 

	LIST 



