; EPE Pic 'n Mix - August 2004
; Andrew Jarvis
; pnm0804_pwm.asm v1.0
; 02 June 2004
;
; Example code to demonstrate 'Hello World' using PWM
; Uses a PIC16F628 with internal 4MHz oscillator
; Timer0 used to periodically change the PWM duty
; Produces pulsing LED pattern on CCP1 (pin 9)

	list p=PIC16f628,r=hex
	#include <p16f628.inc>
	errorlevel  -302	; suppress message 302, warning about ensuring correct bank bits

	__CONFIG   _INTRC_OSC_NOCLKOUT & _WDT_OFF & _PWRTE_ON & _BODEN_OFF & _MCLRE_OFF & _LVP_OFF & _DATA_CP_OFF & _CP_OFF  
		
	org 0			; reset vector
	goto start
	org 4			; interrupt vector

	; note - usual interrupt service routine handling procedures
	; omitted for clarity in this simple example.
	
	bcf INTCON, T0IF	; clear the TMR0 overflow interrupt flag
	incf CCPR1L, F		; increase the duty cycle	
	retfie			; exit isr
	
start
	banksel TRISB		; Bank 1
	clrf TRISB		; set PORTB as outputs
	
	movlw b'10000011'	; pull ups disabled, prescaler assigned to TMR0
	movwf OPTION_REG	; TMR0 prescaler rate 1:16

	movlw 0xf9		; set the pwm period
	movwf PR2

	banksel PORTB		; Bank 0
	clrf PORTB		; reset PORTB

	clrf CCPR1L		; initialise pwm duty
	movlw b'00001100'	; set PWM mode
	movwf CCP1CON

	bsf T2CON, TMR2ON	; switch on Timer2

	movlw b'10100000'	; enable global and TMR0 overflow interrupts
	movwf INTCON
	
	; do nothing, CCP module will do all the work :-)
main	goto main

	end

