;*****************************************************************************        
;
;   Module:     config.inc
;               
;   Author:     Mike Hibbett, mikehibbett@oceanfree.net 
;                                                                  
;   Version:    1.0 11/10/05                                              
;
;               Definition of config register bits
;               You should change this to suit your *hardware* requirements
;               If you change this file, you must re-program your PIC using
;               a normal PIC programmer. The bootloader cannot change config 
;               registers.
;
;*****************************************************************************        


    ;   MSB XXXXXXXX LSB
    ;       0 ---------- IESO    No Clock Switching required
    ;        0 --------- FCMEN   No clock monitoring
    ;         00 ------- Unused
    ;           0110 --- FOSC    HS, 4 x  PLL
    ;
    __config 0x300001, 0x06
    
    
    ;   MSB XXXXXXXX LSB
    ;       000 -------- Unused
    ;          11 ------ BORV    Brown out voltage (Not Used)
    ;            00 ---- BOREN   Brown out reset disabled
    ;              0 --- /PWRTEN Power up timer enabled
    ;
    __config 0x300002, 0x18
    
    
    ;   MSB XXXXXXXX LSB
    ;       000 -------- Unused
    ;          0000 ---- WatchDog Postscaler 1:1 ( Unused )
    ;              0 --- WDTEN WatchDog disabled
    ;
    __config 0x300003, 0x00
    
     
    ;   MSB XXXXXXXX LSB
    ;       1 ---------- MCLRE /MCLR pin is a reset input
    ;        0000 ------ Unused
    ;            0 ----- LPT1OSC Timer1 OSC is high power ( Unused )
    ;             0 ---- PBADEN Port B A/D - disabled, pins are I/O
    ;              1 --- CCP2MX CCP2 Muxed with RC1 ( Unused )
    ;
    __config 0x300005, 0x81


    ;   MSB XXXXXXXX LSB
    ;       1 ---------- /DEBUG Debug disabled
    ;        0 --------- XINST No extended instructions
    ;         000 ------ Unused
    ;            0 ----- LVP disabled
    ;             0 ---- Unused
    ;              1 --- STVREN Reset on stack overflow enabled   
    ;
    __config 0x300006, 0x81

    ;   MSB XXXXXXXX LSB
    ;       0000 ------- Unused
    ;           1111 --- Code protection off, blocks 0 - 3    
    ;
    __config 0x300008, 0x0F
    
    ;   MSB XXXXXXXX LSB
    ;       1 ---------- CPD Code protection off on Data EEPROM
    ;        1 --------- CPB Code protection off on Boot block
    ;         000000 --- Unused
    ;
    __config 0x300009, 0xC0
    
    ;   MSB XXXXXXXX LSB
    ;       0000 ------- Unused
    ;           1111 --- WRT Write protection off, blocks 0 -3
    ;
    __config 0x30000A, 0x0F
    
    ;   MSB XXXXXXXX LSB
    ;       1 ---------- WRTD Write protection off, Data EEPROM
    ;        1 --------- WRTB Write protection off, Boot Block
    ;         1 -------- WRTC Write protection off, Config Registers
    ;          00000 --- Unused
    ;
    __config 0x30000B, 0xE0
    
    ;   MSB XXXXXXXX LSB
    ;       0000 ------- Unused
    ;           1111 --- EBTR Tables reads enabled blocks 0 - 3
    ;
    __config 0x30000C, 0x0F
    
    ;   MSB XXXXXXXX LSB
    ;       0 ---------- Unused
    ;        1 --------- EBTRB Table reads enabled, boot block
    ;         000000 --- Unused
    ;
    __config 0x30000D, 0x40

